/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.impls;

import java.io.IOException;
import java.io.InputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import net.sbbi.upnp.Discovery;
import net.sbbi.upnp.devices.Device;
import net.sbbi.upnp.devices.RootDevice;
import net.sbbi.upnp.messages.ActionMessage;
import net.sbbi.upnp.messages.ActionResponse;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.messages.StateVariableResponse;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.Action;
import net.sbbi.upnp.services.Service;
import net.sbbi.upnp.services.StateVariable;

public class InternetGatewayDevice {
    private final RootDevice igd;
    private UPNPMessageFactory msgFactory;

    public static void main(String[] args) {
        block14: {
            int internalPort = -1;
            int externalPort = -1;
            try {
                externalPort = Integer.parseInt(args[0]);
                internalPort = Integer.parseInt(args[1]);
            }
            catch (Exception e) {
                System.out.println("usage: java -jar upnp.jar <externalPort> <internalPort>");
                System.out.println(e.getMessage());
                System.exit(0);
            }
            try {
                InetAddress local = null;
                Enumeration<NetworkInterface> ifaces = NetworkInterface.getNetworkInterfaces();
                while (ifaces.hasMoreElements() && local == null) {
                    NetworkInterface iface = ifaces.nextElement();
                    Enumeration<InetAddress> addresses = iface.getInetAddresses();
                    while (addresses.hasMoreElements() && local == null) {
                        InetAddress addr = addresses.nextElement();
                        if (!(addr instanceof Inet4Address) || addr.isLoopbackAddress()) continue;
                        local = addr;
                    }
                }
                if (local == null) {
                    System.out.println("Could not determine local address!");
                    System.exit(0);
                }
                assert (local != null);
                System.out.println("looking for device");
                InternetGatewayDevice[] devices = InternetGatewayDevice.getDevices(2000);
                if (devices == null) {
                    System.out.println("UPnP turned off, or no devices (ex: routers) found");
                    System.exit(0);
                }
                InternetGatewayDevice dev = devices[0];
                System.out.println("Attempting to map port on " + dev.msgFactory.service.serviceType + " service");
                System.out.println("adding mapping from " + dev.getExternalIPAddress() + ":" + externalPort);
                System.out.println("\tto " + local.getHostAddress() + ":" + internalPort);
                boolean mapped = dev.addPortMapping("foo", "TCP", null, externalPort, local.getHostAddress(), internalPort, 0);
                if (mapped) {
                    System.out.println("waiting for connection");
                    ServerSocket ss = new ServerSocket(internalPort);
                    ss.setSoTimeout(10000);
                    try {
                        Socket s = ss.accept();
                        System.out.println("\tConnection made!");
                        InputStream in = s.getInputStream();
                        while (in.available() > 0) {
                            System.out.println("byte : " + in.read());
                        }
                    }
                    catch (SocketTimeoutException stoe) {
                        System.out.println("\tTimed out");
                    }
                    System.out.print("removing mapping : ");
                    System.out.println(dev.deletePortMapping(null, externalPort, "TCP"));
                    break block14;
                }
                System.out.println("port mapping failed!");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (UPNPResponseException e) {
                e.printStackTrace();
            }
        }
    }

    public static void printDevices() {
        try {
            System.out.print("Searching for gateway devices...");
            System.out.flush();
            InternetGatewayDevice[] devs = InternetGatewayDevice.getDevices(1000);
            System.out.println(" found " + devs.length);
            for (InternetGatewayDevice d : devs) {
                System.out.println(d.igd);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private InternetGatewayDevice(RootDevice igd, boolean WANIPConnection, boolean WANPPPConnection) throws UnsupportedOperationException {
        this.igd = igd;
        Device myIGDWANConnDevice = igd.getChildDevice("urn:schemas-upnp-org:device:WANConnectionDevice:1");
        if (myIGDWANConnDevice == null) {
            throw new UnsupportedOperationException("device urn:schemas-upnp-org:device:WANConnectionDevice:1 not supported by IGD device " + igd.modelName);
        }
        Service wanIPSrv = myIGDWANConnDevice.getService("urn:schemas-upnp-org:service:WANIPConnection:1");
        Service wanPPPSrv = myIGDWANConnDevice.getService("urn:schemas-upnp-org:service:WANPPPConnection:1");
        if (WANIPConnection && WANPPPConnection && wanIPSrv == null && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 or urn:schemas-upnp-org:service:WANPPPConnection:1 service");
        }
        if (WANIPConnection && !WANPPPConnection && wanIPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANIPConnection:1 service");
        }
        if (!WANIPConnection && WANPPPConnection && wanPPPSrv == null) {
            throw new UnsupportedOperationException("Unable to find any urn:schemas-upnp-org:service:WANPPPConnection:1 service");
        }
        if (wanIPSrv != null && wanPPPSrv == null) {
            this.msgFactory = new UPNPMessageFactory(wanIPSrv);
        } else if (wanPPPSrv != null && wanIPSrv == null) {
            this.msgFactory = new UPNPMessageFactory(wanPPPSrv);
        } else {
            Device wanDevice = igd.getChildDevice("urn:schemas-upnp-org:device:WANDevice:1");
            Service configService = wanDevice.getService("urn:schemas-upnp-org:service:WANCommonInterfaceConfig:1");
            if (configService != null) {
                Action act = configService.getUPNPServiceAction("GetActiveConnection");
                if (act != null) {
                    UPNPMessageFactory msg = new UPNPMessageFactory(configService);
                    String deviceContainer = null;
                    String serviceID = null;
                    try {
                        ActionResponse resp = msg.getMessage("GetActiveConnection").setInputParameter("NewActiveConnectionIndex", 0).service();
                        deviceContainer = resp.getOutActionArgumentValue("NewActiveConnDeviceContainer");
                        serviceID = resp.getOutActionArgumentValue("NewActiveConnectionServiceID");
                    }
                    catch (IOException ex) {
                    }
                    catch (UPNPResponseException respEx) {
                        // empty catch block
                    }
                    if (deviceContainer != null && deviceContainer.trim().length() > 0 && serviceID != null && serviceID.trim().length() > 0) {
                        for (Device dv : igd.getChildDevices()) {
                            if (!deviceContainer.startsWith(dv.UDN) || dv.deviceType.indexOf(":WANConnectionDevice:") == -1) continue;
                            myIGDWANConnDevice = dv;
                            break;
                        }
                        this.msgFactory = new UPNPMessageFactory(myIGDWANConnDevice.getServiceByID(serviceID));
                    }
                } else {
                    StateVariable wat = configService.getUPNPServiceStateVariable("WANAccessType");
                    assert (wat != null) : "bugged upnp implementation";
                    try {
                        String accessType = wat.getValue();
                        System.out.println(accessType);
                        if (accessType.equals("DSL") || accessType.equals("POTS")) {
                            this.msgFactory = new UPNPMessageFactory(wanPPPSrv);
                        } else if (accessType.equals("Cable") || accessType.equals("Ethernet")) {
                            this.msgFactory = new UPNPMessageFactory(wanIPSrv);
                        } else assert (false) : "Illegal access type : " + accessType;
                    }
                    catch (UPNPResponseException e) {
                        e.printStackTrace();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (this.msgFactory == null) {
                if (this.testWANInterface(wanIPSrv)) {
                    this.msgFactory = new UPNPMessageFactory(wanIPSrv);
                } else if (this.testWANInterface(wanPPPSrv)) {
                    this.msgFactory = new UPNPMessageFactory(wanPPPSrv);
                }
            }
            if (this.msgFactory == null) {
                this.msgFactory = new UPNPMessageFactory(wanIPSrv);
            }
        }
    }

    private boolean testWANInterface(Service srv) {
        UPNPMessageFactory tmp = new UPNPMessageFactory(srv);
        ActionMessage msg = tmp.getMessage("GetExternalIPAddress");
        String ipToParse = null;
        try {
            ipToParse = msg.service().getOutActionArgumentValue("NewExternalIPAddress");
        }
        catch (UPNPResponseException ex) {
        }
        catch (IOException ex) {
            // empty catch block
        }
        if (ipToParse != null && ipToParse.length() > 0 && !ipToParse.equals("0.0.0.0")) {
            try {
                return InetAddress.getByName(ipToParse) != null;
            }
            catch (UnknownHostException ex) {
                // empty catch block
            }
        }
        return false;
    }

    public RootDevice getIGDRootDevice() {
        return this.igd;
    }

    public static InternetGatewayDevice[] getDevices(int timeout) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, 4, 3, true, true, null);
    }

    public static InternetGatewayDevice[] getDevices(int timeout, int ttl, int mx, NetworkInterface ni) throws IOException {
        return InternetGatewayDevice.lookupDeviceDevices(timeout, ttl, mx, true, true, ni);
    }

    private static InternetGatewayDevice[] lookupDeviceDevices(int timeout, int ttl, int mx, boolean WANIPConnection, boolean WANPPPConnection, NetworkInterface ni) throws IOException {
        RootDevice[] devices = null;
        InternetGatewayDevice[] rtrVal = null;
        devices = timeout == -1 ? Discovery.discover(1500, ttl, mx, "urn:schemas-upnp-org:device:InternetGatewayDevice:1", ni) : Discovery.discover(timeout, ttl, mx, "urn:schemas-upnp-org:device:InternetGatewayDevice:1", ni);
        if (devices != null) {
            int i;
            HashSet<InternetGatewayDevice> valid = new HashSet<InternetGatewayDevice>();
            for (i = 0; i < devices.length; ++i) {
                try {
                    valid.add(new InternetGatewayDevice(devices[i], WANIPConnection, WANPPPConnection));
                    continue;
                }
                catch (UnsupportedOperationException ex) {
                    // empty catch block
                }
            }
            if (valid.size() == 0) {
                return null;
            }
            rtrVal = new InternetGatewayDevice[valid.size()];
            i = 0;
            Iterator itr = valid.iterator();
            while (itr.hasNext()) {
                rtrVal[i++] = (InternetGatewayDevice)itr.next();
            }
        }
        return rtrVal;
    }

    public String getExternalIPAddress() throws UPNPResponseException, IOException {
        ActionMessage msg = this.msgFactory.getMessage("GetExternalIPAddress");
        return msg.service().getOutActionArgumentValue("NewExternalIPAddress");
    }

    public ActionResponse getGenericPortMappingEntry(int newPortMappingIndex) throws IOException, UPNPResponseException {
        ActionMessage msg = this.msgFactory.getMessage("GetGenericPortMappingEntry");
        msg.setInputParameter("NewPortMappingIndex", newPortMappingIndex);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public ActionResponse getSpecificPortMappingEntry(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("GetSpecificPortMappingEntry");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            return msg.service();
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return null;
            }
            throw ex;
        }
    }

    public boolean addPortMapping(String description, String protocol, String remoteHost, int externalPort, String internalClient, int internalPort, int leaseDuration) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        if (externalPort != 0) {
            this.checkPortRange(externalPort);
        }
        this.checkPortRange(internalPort);
        String string = description = description == null ? "" : description;
        if (leaseDuration < 0) {
            throw new IllegalArgumentException("Invalid leaseDuration (" + leaseDuration + ") value");
        }
        ActionMessage msg = this.msgFactory.getMessage("AddPortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol).setInputParameter("NewInternalPort", internalPort).setInputParameter("NewInternalClient", internalClient).setInputParameter("NewEnabled", true).setInputParameter("NewPortMappingDescription", description).setInputParameter("NewLeaseDuration", leaseDuration);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 718) {
                return false;
            }
            throw ex;
        }
    }

    public boolean deletePortMapping(String remoteHost, int externalPort, String protocol) throws IOException, UPNPResponseException {
        remoteHost = remoteHost == null ? "" : remoteHost;
        this.checkPortMappingProtocol(protocol);
        this.checkPortRange(externalPort);
        ActionMessage msg = this.msgFactory.getMessage("DeletePortMapping");
        msg.setInputParameter("NewRemoteHost", remoteHost).setInputParameter("NewExternalPort", externalPort).setInputParameter("NewProtocol", protocol);
        try {
            msg.service();
            return true;
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() == 714) {
                return false;
            }
            throw ex;
        }
    }

    public Integer getNatMappingsCount() throws IOException, UPNPResponseException {
        Integer rtrval;
        block2: {
            rtrval = null;
            StateVariableMessage natTableSize = this.msgFactory.getStateVariableMessage("PortMappingNumberOfEntries");
            try {
                StateVariableResponse resp = natTableSize.service();
                rtrval = new Integer(resp.getStateVariableValue());
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 404) break block2;
                throw ex;
            }
        }
        return rtrval;
    }

    public Integer getNatTableSize() throws IOException, UPNPResponseException {
        int startIndex = -1;
        for (int i = 0; i < 50; ++i) {
            try {
                this.getGenericPortMappingEntry(i);
                startIndex = i;
                break;
            }
            catch (UPNPResponseException ex) {
                if (ex.getDetailErrorCode() == 713 || ex.getDetailErrorCode() == 402) continue;
                throw ex;
            }
        }
        if (startIndex == -1) {
            return null;
        }
        int size = 0;
        try {
            while (true) {
                this.getGenericPortMappingEntry(startIndex++);
                ++size;
            }
        }
        catch (UPNPResponseException ex) {
            if (ex.getDetailErrorCode() != 713 && ex.getDetailErrorCode() != 402) {
                throw ex;
            }
            return new Integer(size);
        }
    }

    private void checkPortMappingProtocol(String prot) throws IllegalArgumentException {
        if (prot == null || !prot.equals("TCP") && !prot.equals("UDP")) {
            throw new IllegalArgumentException("PortMappingProtocol must be either TCP or UDP");
        }
    }

    private void checkPortRange(int port) throws IllegalArgumentException {
        if (port < 1 || port > 65535) {
            throw new IllegalArgumentException("Port range must be between 1 and 65535");
        }
    }
}

