/*
 * Decompiled with CFR 0.152.
 */
package net.sbbi.upnp.services;

import java.io.IOException;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import net.sbbi.upnp.XMLUtil;
import net.sbbi.upnp.messages.StateVariableMessage;
import net.sbbi.upnp.messages.UPNPMessageFactory;
import net.sbbi.upnp.messages.UPNPResponseException;
import net.sbbi.upnp.services.ISO8601Date;
import net.sbbi.upnp.services.Service;
import net.sbbi.upnp.services.StateVariableTypes;
import org.w3c.dom.Node;

public class StateVariable
implements StateVariableTypes {
    private StateVariableMessage stateVarMsg = null;
    public final String name;
    public final boolean sendEvents;
    public final String dataType;
    public final String defaultValue;
    public final String minimumRangeValue;
    public final String maximumRangeValue;
    public final String stepRangeValue;
    public final Set<String> allowedvalues = new HashSet<String>();
    public final Service parent;

    StateVariable(Service parent, Node xml) throws XPathExpressionException {
        this.parent = parent;
        this.sendEvents = Boolean.parseBoolean(XMLUtil.xpath.evaluate("/@sendEvents", xml));
        this.name = XMLUtil.xpath.evaluate("name", xml);
        this.dataType = XMLUtil.xpath.evaluate("dataType", xml);
        this.defaultValue = XMLUtil.xpath.evaluate("defaultValue", xml);
        this.minimumRangeValue = XMLUtil.xpath.evaluate("allowedValueRange/minimum", xml);
        this.maximumRangeValue = XMLUtil.xpath.evaluate("allowedValueRange/maximum", xml);
        this.stepRangeValue = XMLUtil.xpath.evaluate("allowedValueRange/step", xml);
        Node allowedXML = (Node)XMLUtil.xpath.evaluate("allowedValueList", xml, XPathConstants.NODE);
        if (allowedXML != null) {
            int count = Integer.parseInt(XMLUtil.xpath.evaluate("count( allowedValue )", allowedXML));
            for (int i = 1; i <= count; ++i) {
                String av = XMLUtil.xpath.evaluate("allowedValue[ " + i + " ]", allowedXML);
                this.allowedvalues.add(av);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue() throws UPNPResponseException, IOException {
        if (this.stateVarMsg == null) {
            StateVariable stateVariable = this;
            synchronized (stateVariable) {
                if (this.stateVarMsg == null) {
                    UPNPMessageFactory factory = new UPNPMessageFactory(this.parent);
                    this.stateVarMsg = factory.getStateVariableMessage(this.name);
                }
            }
        }
        return this.stateVarMsg.service().getStateVariableValue();
    }

    public Class getDataTypeAsClass() {
        return StateVariable.getDataTypeClassMapping(this.dataType);
    }

    static Class getDataTypeClassMapping(String dataType) {
        int hash = dataType.hashCode();
        if (hash == UI1_INT) {
            return Short.class;
        }
        if (hash == UI2_INT) {
            return Integer.class;
        }
        if (hash == UI4_INT) {
            return Long.class;
        }
        if (hash == I1_INT) {
            return Byte.class;
        }
        if (hash == I2_INT) {
            return Short.class;
        }
        if (hash == I4_INT) {
            return Integer.class;
        }
        if (hash == INT_INT) {
            return Integer.class;
        }
        if (hash == R4_INT) {
            return Float.class;
        }
        if (hash == R8_INT) {
            return Double.class;
        }
        if (hash == NUMBER_INT) {
            return Double.class;
        }
        if (hash == FIXED_14_4_INT) {
            return Double.class;
        }
        if (hash == FLOAT_INT) {
            return Float.class;
        }
        if (hash == CHAR_INT) {
            return Character.class;
        }
        if (hash == STRING_INT) {
            return String.class;
        }
        if (hash == DATE_INT) {
            return Date.class;
        }
        if (hash == DATETIME_INT) {
            return Date.class;
        }
        if (hash == DATETIME_TZ_INT) {
            return Date.class;
        }
        if (hash == TIME_INT) {
            return Date.class;
        }
        if (hash == TIME_TZ_INT) {
            return Date.class;
        }
        if (hash == BOOLEAN_INT) {
            return Boolean.class;
        }
        if (hash == BIN_BASE64_INT) {
            return String.class;
        }
        if (hash == BIN_HEX_INT) {
            return String.class;
        }
        if (hash == URI_INT) {
            return URI.class;
        }
        if (hash == UUID_INT) {
            return String.class;
        }
        return null;
    }

    static String getUPNPDataTypeMapping(String className) {
        if (className.equals(Short.class.getName()) || className.equals("short")) {
            return "i2";
        }
        if (className.equals(Byte.class.getName()) || className.equals("byte")) {
            return "i1";
        }
        if (className.equals(Integer.class.getName()) || className.equals("int")) {
            return "int";
        }
        if (className.equals(Long.class.getName()) || className.equals("long")) {
            return "ui4";
        }
        if (className.equals(Float.class.getName()) || className.equals("float")) {
            return "float";
        }
        if (className.equals(Double.class.getName()) || className.equals("double")) {
            return "number";
        }
        if (className.equals(Character.class.getName()) || className.equals("char")) {
            return "char";
        }
        if (className.equals(String.class.getName()) || className.equals("string")) {
            return "string";
        }
        if (className.equals(Date.class.getName())) {
            return "dateTime";
        }
        if (className.equals(Boolean.class.getName()) || className.equals("boolean")) {
            return "boolean";
        }
        if (className.equals(URI.class.getName())) {
            return "uri";
        }
        return null;
    }

    static Object UPNPToJavaObject(String dataType, String value) throws Throwable {
        if (value == null) {
            throw new Exception("null value");
        }
        if (dataType == null) {
            throw new Exception("null dataType");
        }
        int hash = dataType.hashCode();
        if (hash == UI1_INT) {
            return new Short(value);
        }
        if (hash == UI2_INT) {
            return new Integer(value);
        }
        if (hash == UI4_INT) {
            return new Long(value);
        }
        if (hash == I1_INT) {
            return new Byte(value);
        }
        if (hash == I2_INT) {
            return new Short(value);
        }
        if (hash == I4_INT) {
            return new Integer(value);
        }
        if (hash == INT_INT) {
            return new Integer(value);
        }
        if (hash == R4_INT) {
            return new Float(value);
        }
        if (hash == R8_INT) {
            return new Double(value);
        }
        if (hash == NUMBER_INT) {
            return new Double(value);
        }
        if (hash == FIXED_14_4_INT) {
            return new Double(value);
        }
        if (hash == FLOAT_INT) {
            return new Float(value);
        }
        if (hash == CHAR_INT) {
            return new Character(value.charAt(0));
        }
        if (hash == STRING_INT) {
            return value;
        }
        if (hash == DATE_INT) {
            return ISO8601Date.parse(value);
        }
        if (hash == DATETIME_INT) {
            return ISO8601Date.parse(value);
        }
        if (hash == DATETIME_TZ_INT) {
            return ISO8601Date.parse(value);
        }
        if (hash == TIME_INT) {
            return ISO8601Date.parse(value);
        }
        if (hash == TIME_TZ_INT) {
            return ISO8601Date.parse(value);
        }
        if (hash == BOOLEAN_INT) {
            if (value.equals("1") || value.equalsIgnoreCase("yes") || value.equals("true")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        if (hash == BIN_BASE64_INT) {
            return value;
        }
        if (hash == BIN_HEX_INT) {
            return value;
        }
        if (hash == URI_INT) {
            return new URI(value);
        }
        if (hash == UUID_INT) {
            return value;
        }
        throw new Exception("Unhandled data type " + dataType);
    }

    public String toString() {
        return this.name + ":" + this.dataType;
    }
}

