/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.shaper;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.geom.GeneralPath;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.shaper.BaseButtonShaper;
import org.jvnet.substance.shaper.RectangularButtonShaper;
import org.jvnet.substance.utils.HashMapKey;
import org.jvnet.substance.utils.LazyResettableHashMap;
import org.jvnet.substance.utils.SubstanceArrowButton;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceOutlineUtilities;
import org.jvnet.substance.utils.SubstanceSizeUtils;
import org.jvnet.substance.utils.border.SubstanceBorder;
import org.jvnet.substance.utils.border.SubstanceButtonBorder;

public class StandardButtonShaper
extends BaseButtonShaper
implements RectangularButtonShaper {
    private static final LazyResettableHashMap<GeneralPath> contours = new LazyResettableHashMap("StandardButtonShaper");

    @Override
    public String getDisplayName() {
        return "Standard";
    }

    @Override
    public GeneralPath getButtonOutline(AbstractButton button, Insets insets, int width, int height, boolean isInner) {
        HashMapKey key;
        GeneralPath result;
        Set<SubstanceConstants.Side> straightSides = SubstanceCoreUtilities.getSides(button, "substancelaf.buttonside");
        float radius = this.getCornerRadius(button, insets);
        if (isInner) {
            radius -= (float)((int)SubstanceSizeUtils.getBorderStrokeWidth(SubstanceSizeUtils.getComponentFontSize(button)));
        }
        if ((result = contours.get(key = SubstanceCoreUtilities.getHashKey(width, height, straightSides, Float.valueOf(radius), insets))) != null) {
            return result;
        }
        result = SubstanceOutlineUtilities.getBaseOutline(width, height, radius, straightSides, insets);
        contours.put(key, result);
        return result;
    }

    @Override
    public Border getButtonBorder(AbstractButton button) {
        return new SubstanceButtonBorder(StandardButtonShaper.class){

            @Override
            public Insets getBorderInsets(Component c) {
                AbstractButton button;
                int componentFontSize = SubstanceSizeUtils.getComponentFontSize(c);
                int extraPadding = SubstanceSizeUtils.getExtraPadding(componentFontSize);
                if (c instanceof AbstractButton && SubstanceCoreUtilities.hasText(button = (AbstractButton)c)) {
                    int dh = SubstanceSizeUtils.getMinButtonHeight(SubstanceSizeUtils.getComponentFontSize(button));
                    int lrPadding = SubstanceSizeUtils.getTextButtonLRPadding(componentFontSize);
                    return new Insets(lrPadding + extraPadding, extraPadding + dh / 2, lrPadding + extraPadding, extraPadding + dh / 2);
                }
                return new Insets(extraPadding, extraPadding, extraPadding, extraPadding);
            }
        };
    }

    @Override
    public Dimension getPreferredSize(AbstractButton button, Dimension uiPreferredSize) {
        boolean toTweakWidth = false;
        boolean toTweakHeight = false;
        Icon icon = button.getIcon();
        boolean hasIcon = SubstanceCoreUtilities.hasIcon(button);
        boolean hasText = SubstanceCoreUtilities.hasText(button);
        Insets margin = button.getMargin();
        Dimension result = uiPreferredSize;
        boolean hasNoMinSizeProperty = SubstanceCoreUtilities.hasNoMinSizeProperty(button);
        if (!hasNoMinSizeProperty && hasText) {
            int baseWidth = uiPreferredSize.width;
            baseWidth = Math.max(baseWidth, SubstanceSizeUtils.getMinButtonWidth(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(baseWidth, uiPreferredSize.height);
            int baseHeight = result.height;
            baseHeight = Math.max(baseHeight, SubstanceSizeUtils.getMinButtonHeight(SubstanceSizeUtils.getComponentFontSize(button)));
            result = new Dimension(result.width, baseHeight);
        } else if (hasNoMinSizeProperty && margin != null) {
            result = new Dimension(result.width + margin.left + margin.right, result.height + margin.top + margin.bottom);
        }
        int extraPadding = SubstanceSizeUtils.getExtraPadding(SubstanceSizeUtils.getComponentFontSize(button));
        int iconPaddingWidth = 6 + 2 * extraPadding;
        int iconPaddingHeight = 6 + 2 * extraPadding;
        if (margin != null) {
            iconPaddingWidth = Math.max(iconPaddingWidth, margin.left + margin.right);
            iconPaddingHeight = Math.max(iconPaddingHeight, margin.top + margin.bottom);
        }
        if (hasIcon) {
            int iconWidth;
            int iconHeight = icon.getIconHeight();
            if ((double)iconHeight > result.getHeight() - (double)iconPaddingHeight) {
                result = new Dimension(result.width, iconHeight);
                toTweakHeight = true;
            }
            if ((double)(iconWidth = icon.getIconWidth()) > result.getWidth() - (double)iconPaddingWidth) {
                result = new Dimension(iconWidth, result.height);
                toTweakWidth = true;
            }
        }
        if (SubstanceCoreUtilities.isScrollBarButton(button)) {
            toTweakWidth = false;
            toTweakHeight = false;
        }
        if (toTweakWidth) {
            result = new Dimension(result.width + iconPaddingWidth, result.height);
        }
        if (toTweakHeight) {
            result = new Dimension(result.width, result.height + iconPaddingHeight);
        }
        if (result.height % 2 != 0) {
            ++result.height;
        }
        return result;
    }

    public static boolean isRoundButton(AbstractButton button) {
        return !SubstanceCoreUtilities.isComboBoxButton(button) && !SubstanceCoreUtilities.isScrollButton(button) && SubstanceCoreUtilities.hasText(button);
    }

    @Override
    public boolean isProportionate() {
        return true;
    }

    @Override
    public float getCornerRadius(AbstractButton button, Insets insets) {
        Border parentBorder;
        int width = button.getWidth();
        int height = button.getHeight();
        boolean isRoundCorners = StandardButtonShaper.isRoundButton(button);
        float radius = SubstanceSizeUtils.getClassicButtonCornerRadius(SubstanceSizeUtils.getComponentFontSize(button));
        if (button.getClass().isAnnotationPresent(SubstanceArrowButton.class) && (parentBorder = ((JComponent)button.getParent()).getBorder()) instanceof SubstanceBorder) {
            radius *= ((SubstanceBorder)parentBorder).getRadiusScaleFactor();
        }
        if (insets != null) {
            width -= insets.left + insets.right;
            height -= insets.top + insets.bottom;
        }
        if (isRoundCorners) {
            radius = width > height ? (float)height / 2.0f : (float)width / 2.0f;
        }
        if (SubstanceCoreUtilities.isToolBarButton(button)) {
            radius = SubstanceCoreUtilities.getToolbarButtonCornerRadius(button, insets);
        }
        return radius;
    }
}

