/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.substance.utils.menu;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.MultipleGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import org.jvnet.lafwidget.animation.FadeKind;
import org.jvnet.lafwidget.animation.FadeState;
import org.jvnet.lafwidget.layout.TransitionLayout;
import org.jvnet.substance.api.ComponentState;
import org.jvnet.substance.api.SubstanceColorScheme;
import org.jvnet.substance.api.SubstanceConstants;
import org.jvnet.substance.painter.utils.BackgroundPaintingUtils;
import org.jvnet.substance.painter.utils.HighlightPainterUtils;
import org.jvnet.substance.utils.SubstanceColorSchemeUtilities;
import org.jvnet.substance.utils.SubstanceCoreUtilities;
import org.jvnet.substance.utils.SubstanceFadeUtilities;

public class SubstanceMenuBackgroundDelegate {
    public static void paintBackground(Graphics g, Component menuItem, int textOffset) {
        if (!menuItem.isShowing()) {
            return;
        }
        int menuWidth = menuItem.getWidth();
        int menuHeight = menuItem.getHeight();
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        BackgroundPaintingUtils.update(graphics, menuItem, false);
        if (menuItem.getParent() instanceof JPopupMenu) {
            if (menuItem.getComponentOrientation().isLeftToRight()) {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.DEFAULT);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getUltraLightColor() : scheme.getLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.SOFT_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getUltraLightColor() : scheme.getLightColor();
                    LinearGradientPaint gp = new LinearGradientPaint(0.0f, 0.0f, textOffset, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{leftColor, rightColor}, MultipleGradientPaint.CycleMethod.REPEAT);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(0, 0, textOffset - 2, menuHeight);
                }
            } else {
                SubstanceConstants.MenuGutterFillKind fillKind = SubstanceCoreUtilities.getMenuGutterFillKind();
                if (fillKind != SubstanceConstants.MenuGutterFillKind.NONE) {
                    SubstanceColorScheme scheme = SubstanceColorSchemeUtilities.getColorScheme(menuItem, ComponentState.DEFAULT);
                    Color leftColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.HARD ? scheme.getLightColor() : scheme.getUltraLightColor();
                    Color rightColor = fillKind == SubstanceConstants.MenuGutterFillKind.HARD_FILL || fillKind == SubstanceConstants.MenuGutterFillKind.SOFT ? scheme.getLightColor() : scheme.getUltraLightColor();
                    LinearGradientPaint gp = new LinearGradientPaint(textOffset, 0.0f, menuWidth, 0.0f, new float[]{0.0f, 1.0f}, new Color[]{leftColor, rightColor}, MultipleGradientPaint.CycleMethod.REPEAT);
                    graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, 0.7f, g));
                    graphics.setPaint(gp);
                    graphics.fillRect(textOffset - 2, 0, menuWidth, menuHeight);
                }
            }
        }
        graphics.dispose();
    }

    public static void paintHighlights(Graphics g, JMenuItem menuItem, float borderAlpha) {
        boolean hasHighlight;
        MenuElement[] selectedMenuPath;
        Graphics2D graphics = (Graphics2D)g.create();
        ButtonModel model = menuItem.getModel();
        ComponentState prevState = SubstanceCoreUtilities.getPrevComponentState(menuItem);
        ComponentState currState = ComponentState.getState(model, menuItem, !(menuItem instanceof JMenu));
        float startAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha(menuItem, prevState);
        float endAlpha = SubstanceColorSchemeUtilities.getHighlightAlpha(menuItem, currState);
        FadeState state = SubstanceFadeUtilities.getFadeState((Component)menuItem, FadeKind.SELECTION, FadeKind.ARM, FadeKind.ROLLOVER);
        float fadeCoef = 0.0f;
        float totalAlpha = endAlpha;
        if (state != null) {
            fadeCoef = state.getFadePosition();
            totalAlpha = state.isFadingIn() ? startAlpha + (endAlpha - startAlpha) * fadeCoef : startAlpha + (endAlpha - startAlpha) * (1.0f - fadeCoef);
            if (state.isFadingIn()) {
                fadeCoef = 1.0f - fadeCoef;
            }
        }
        boolean isRollover = (selectedMenuPath = MenuSelectionManager.defaultManager().getSelectedPath()).length == 0;
        for (MenuElement elem : selectedMenuPath) {
            if (elem != menuItem) continue;
            isRollover = true;
            break;
        }
        isRollover = isRollover && model.isRollover();
        boolean bl = hasHighlight = state != null || model.isArmed() || isRollover || menuItem instanceof JMenu && model.isSelected();
        if (hasHighlight && totalAlpha > 0.0f) {
            graphics.setComposite(TransitionLayout.getAlphaComposite(menuItem, totalAlpha, g));
            HighlightPainterUtils.paintHighlight(graphics, null, menuItem, new Rectangle(0, 0, menuItem.getWidth(), menuItem.getHeight()), borderAlpha, null, currState, prevState, fadeCoef);
            graphics.setComposite(TransitionLayout.getAlphaComposite((Component)menuItem, g));
        }
        graphics.dispose();
    }
}

