/*
 * Decompiled with CFR 0.152.
 */
package util.image;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
enum ImagePointType {
    decorations("decorations.txt", "misc", null, true, true, true, false, true, true, "decorations.txt will place any kind of image you want anywhere, using the 'misc' folder", "<html>decorations.txt will allow for multiple points per image. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create a copy of currently selected image OR closest image <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    name_place("name_place.txt", "territoryNames", null, true, false, true, true, false, false, "name_place.txt only places images with the exact name of the territories on map, using the 'territoryNames' folder", "<html>name_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = nothing <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    pu_place("pu_place.txt", "PUs", "2.png", false, false, true, true, false, false, "pu_place.txt is the point where the PUs get shown, and picks the PU images (like '2.png') from the 'PUs' folder", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    capitols("capitols.txt", "flags", "Neutral_large.png", false, false, false, false, false, true, "capitols.txt is the point where a capitol flag is shown, and picks the <name>_large.png image from the 'flags' folder", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    vc("vc.txt", "misc", "vc.png", false, false, false, false, false, true, "vc.txt is the point where a Victory City icon is shown, and picks the 'vc.png' image from the 'misc' folder", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    blockade("blockade.txt", "misc", "blockade.png", false, false, false, false, false, true, "blockade.txt is the point where a blockade zone icon is shown, and picks the 'blockade.png' image from the 'misc' folder", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    convoy("convoy.txt", "flags", "Neutral.png", false, false, false, false, false, true, "convoy.txt is the point where a nation flag is shown on any sea zone that has production ability, and picks the <name>.png image from the 'flags' folder", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    comments("comments.txt", "misc", "exampleConvoyText.png", false, false, false, true, false, false, "comments.txt is the point where text details about a convoy zone or route is shown, and it does not use any image, instead it writes the text in-game", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    kamikaze_place("kamikaze_place.txt", "flags", "Neutral_fade.png", false, false, false, false, false, true, "kamikaze_place.txt is the point where a kamikaze zone symbol is shown, and it picks the <name>_fade.png image from the 'flags' folder", "<html>pu_place.txt only allows 1 point per image/territory. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = create an image and point for this territory if none exists yet <br>CTRL/SHIFT + Right Click = delete currently selected image point</html>"),
    territory_effects("territory_effects.txt", "territoryEffects", "mountain.png", false, false, false, false, true, true, "territory_effects.txt is the point where a territory effect image is shown, and it picks the <effect>.png image from the 'territoryEffects' folder", "<html>pu_place.txt will allow for multiple points per image. <br>Left Click = select closest image  OR  place currently selected image <br>Right click = copy selected image OR create an image for this territory<br>CTRL/SHIFT + Right Click = delete currently selected image point</html>");

    public static final int SPACE_BETWEEN_NAMES_AND_PUS = 32;
    private final String m_fileName;
    private final String m_folderName;
    private final String m_imageName;
    private final boolean m_useFolder;
    private final boolean m_endInPNG;
    private final boolean m_fillAll;
    private final boolean m_canUseBottomLeftPoint;
    private final boolean m_canHaveMultiplePoints;
    private final boolean m_usesCentersPoint;
    private final String m_description;
    private final String m_instructions;

    public static ImagePointType[] getTypes() {
        return new ImagePointType[]{decorations, name_place, pu_place, capitols, vc, blockade, convoy, comments, kamikaze_place, territory_effects};
    }

    private ImagePointType(String fileName, String folderName, String imageName, boolean useFolder, boolean endInPNG, boolean fillAll, boolean canUseBottomLeftPoint, boolean canHaveMultiplePoints, boolean usesCentersPoint, String description, String instructions) {
        this.m_fileName = fileName;
        this.m_folderName = folderName;
        this.m_imageName = imageName;
        this.m_useFolder = useFolder;
        this.m_endInPNG = endInPNG;
        this.m_fillAll = fillAll;
        this.m_canUseBottomLeftPoint = canUseBottomLeftPoint;
        this.m_canHaveMultiplePoints = canHaveMultiplePoints;
        this.m_usesCentersPoint = usesCentersPoint;
        this.m_description = description;
        this.m_instructions = instructions;
    }

    public String getFileName() {
        return this.m_fileName;
    }

    public String getFolderName() {
        return this.m_folderName;
    }

    public String getImageName() {
        return this.m_imageName;
    }

    public boolean isUseFolder() {
        return this.m_useFolder;
    }

    public boolean isEndInPNG() {
        return this.m_endInPNG;
    }

    public boolean isFillAll() {
        return this.m_fillAll;
    }

    public boolean isCanUseBottomLeftPoint() {
        return this.m_canUseBottomLeftPoint;
    }

    public boolean isCanHaveMultiplePoints() {
        return this.m_canHaveMultiplePoints;
    }

    public boolean isUsesCentersPoint() {
        return this.m_usesCentersPoint;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getInstructions() {
        return this.m_instructions;
    }
}

