/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import games.strategy.engine.framework.GameRunner;
import games.strategy.engine.framework.ProcessRunnerUtil;
import games.strategy.net.DesktopUtilityBrowserLauncher;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import util.image.AutoPlacementFinder;
import util.image.CenterPicker;
import util.image.ConnectionFinder;
import util.image.DecorationPlacer;
import util.image.FileSave;
import util.image.ImageShrinker;
import util.image.MapPropertiesMaker;
import util.image.PlacementPicker;
import util.image.PolygonGrabber;
import util.image.ReliefImageBreaker;
import util.image.TileImageBreaker;

public class MapCreator
extends JFrame {
    private static final long serialVersionUID = 3593102638082774498L;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";
    private static final String TRIPLEA_UNIT_ZOOM = "triplea.unit.zoom";
    private static final String TRIPLEA_UNIT_WIDTH = "triplea.unit.width";
    private static final String TRIPLEA_UNIT_HEIGHT = "triplea.unit.height";
    private static long s_memory = (long)((double)Runtime.getRuntime().maxMemory() * 1.15) + 0x4000000L;
    private static File s_mapFolderLocation = null;
    private static double s_unit_zoom = 0.75;
    private static int s_unit_width = 48;
    private static int s_unit_height = 48;
    private static boolean s_runUtilitiesAsSeperateProcesses = true;
    final JPanel m_mainPanel;
    final JPanel m_sidePanel;
    final JButton m_part1;
    final JButton m_part2;
    final JButton m_part3;
    final JButton m_part4;
    final JPanel m_panel1 = new JPanel();
    final JPanel m_panel2 = new JPanel();
    final JPanel m_panel3 = new JPanel();
    final JPanel m_panel4 = new JPanel();

    public static String[] getProperties() {
        return new String[]{TRIPLEA_MAP_FOLDER, TRIPLEA_UNIT_ZOOM, TRIPLEA_UNIT_WIDTH, TRIPLEA_UNIT_HEIGHT};
    }

    public static void main(String[] args) {
        MapCreator.handleCommandLineArgs(args);
        MapCreator creator = new MapCreator();
        creator.setSize(800, 600);
        creator.setLocationRelativeTo(null);
        creator.setVisible(true);
    }

    public MapCreator() {
        super("TripleA Map Creator");
        this.setDefaultCloseOperation(3);
        this.m_mainPanel = new JPanel();
        this.m_sidePanel = new JPanel();
        this.m_part1 = new JButton("Step 1: Map Properties");
        this.m_part2 = new JButton("Step 2: Map Utilities");
        this.m_part3 = new JButton("Step 3: Game XML");
        this.m_part4 = new JButton("Other: Optional Things");
        this.m_sidePanel.setLayout(new BoxLayout(this.m_sidePanel, 3));
        this.m_sidePanel.add(Box.createVerticalGlue());
        this.m_sidePanel.add(this.m_part1);
        this.m_part1.setAlignmentX(0.5f);
        this.m_sidePanel.add(Box.createVerticalGlue());
        this.m_sidePanel.add(this.m_part2);
        this.m_part2.setAlignmentX(0.5f);
        this.m_sidePanel.add(Box.createVerticalGlue());
        this.m_sidePanel.add(this.m_part3);
        this.m_part3.setAlignmentX(0.5f);
        this.m_sidePanel.add(Box.createVerticalGlue());
        this.m_sidePanel.add(this.m_part4);
        this.m_part4.setAlignmentX(0.5f);
        this.m_sidePanel.add(Box.createVerticalGlue());
        this.createPart1Panel();
        this.createPart2Panel();
        this.createPart3Panel();
        this.createPart4Panel();
        this.m_part1.addActionListener(new AbstractAction("Part 1"){
            private static final long serialVersionUID = 5363944759664271421L;

            public void actionPerformed(ActionEvent e) {
                MapCreator.this.setupMainPanel(MapCreator.this.m_panel1);
            }
        });
        this.m_part2.addActionListener(new AbstractAction("Part 2"){
            private static final long serialVersionUID = -8158213072422149296L;

            public void actionPerformed(ActionEvent e) {
                MapCreator.this.setupMainPanel(MapCreator.this.m_panel2);
            }
        });
        this.m_part3.addActionListener(new AbstractAction("Part 3"){
            private static final long serialVersionUID = 881434681054088699L;

            public void actionPerformed(ActionEvent e) {
                MapCreator.this.setupMainPanel(MapCreator.this.m_panel3);
            }
        });
        this.m_part4.addActionListener(new AbstractAction("Part 4"){
            private static final long serialVersionUID = 2794249359841059679L;

            public void actionPerformed(ActionEvent e) {
                MapCreator.this.setupMainPanel(MapCreator.this.m_panel4);
            }
        });
        AbstractAction exitAction = new AbstractAction("Exit"){
            private static final long serialVersionUID = 5363944759664271421L;

            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        };
        exitAction.putValue("ShortDescription", "Exit The Program");
        JMenuItem exitItem = new JMenuItem(exitAction);
        JMenuBar menuBar = new JMenuBar();
        this.setJMenuBar(menuBar);
        JMenu fileMenu = new JMenu("File");
        fileMenu.setMnemonic('F');
        fileMenu.addSeparator();
        fileMenu.add(exitItem);
        menuBar.add(fileMenu);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JScrollPane(this.m_sidePanel), "West");
        this.getContentPane().add((Component)new JScrollPane(this.m_mainPanel), "Center");
        this.setupMainPanel(this.m_panel1);
    }

    private void setupMainPanel(JPanel panel) {
        this.m_mainPanel.removeAll();
        this.m_mainPanel.add(panel);
        this.setWidgetActivation();
    }

    private void setWidgetActivation() {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    MapCreator.this.setWidgetActivation();
                }
            });
            return;
        }
        this.m_mainPanel.validate();
        this.m_mainPanel.repaint();
        this.validate();
        this.repaint();
    }

    private void createPart1Panel() {
        this.m_panel1.removeAll();
        this.m_panel1.setLayout(new BoxLayout(this.m_panel1, 3));
        this.m_panel1.add(Box.createVerticalStrut(30));
        JTextArea text = new JTextArea(12, 10);
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setText("Welcome to Veqryn's shitty map maker.\r\nThis program just runs utilities inside the triplea.jar file for you, and you could easily run them yourself from the command line by reading the docs/developer_documentation.html\r\n\r\nBefore you begin, go create a folder in your directory: Users\\yourname\\triplea\\maps\r\nName the folder with a short name of your map, do not use any special characters in the name.\r\nNext, create 5 folders inside your map folder, with these names: flags, units, baseTiles, reliefTiles, games\r\nThen, create a text file and rename it \"map.properties\".\r\n\r\nTo start the Map Utilities, have a png image of your map with just the territory borders and nothing else. The borders must be in black (hex: 000000) and there should not be any anti-aliasing (smoothing) of the lines or edges that stick out.\r\nCreate a small image of the map (approx 250 pixels wide) and name it \"smallMap.jpeg\".\r\nPut these in the map's root folder. You can now start the map maker by clicking and filling in the details below, before moving on to 'Step 2' and running the map utilities.");
        JScrollPane scrollText = new JScrollPane(text);
        this.m_panel1.add(scrollText);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.add(new JLabel("Click button open up the readme file on how to make maps:"));
        JButton helpButton = new JButton("Start Tutorial  /  Show Help Document");
        helpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openFile(new File(GameRunner.getRootFolder(), "doc" + File.separator + "map_and_map_skin_making_overview.html"));
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_panel1.add(helpButton);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.add(new JLabel("Click button to select where your map folder is:"));
        JButton mapFolderButton = new JButton("Select Map Folder");
        mapFolderButton.addActionListener(new AbstractAction("Select Map Folder"){
            private static final long serialVersionUID = 3918797244306320614L;

            public void actionPerformed(ActionEvent e) {
                File mapFolder;
                String path = new FileSave("Where is your map's folder?", null, s_mapFolderLocation).getPathString();
                if (path != null && (mapFolder = new File(path)).exists()) {
                    s_mapFolderLocation = mapFolder;
                    System.setProperty(MapCreator.TRIPLEA_MAP_FOLDER, s_mapFolderLocation.getPath());
                }
            }
        });
        this.m_panel1.add(mapFolderButton);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.add(new JLabel("Set the unit scaling (unit image zoom): "));
        this.m_panel1.add(new JLabel("Choose one of: 1.25, 1, 0.875, 0.8333, 0.75, 0.6666, 0.5625, 0.5"));
        final JTextField unitZoomText = new JTextField("" + s_unit_zoom);
        unitZoomText.setMaximumSize(new Dimension(100, 20));
        unitZoomText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                try {
                    s_unit_zoom = Math.min(4.0, Math.max(0.1, Double.parseDouble(unitZoomText.getText())));
                    System.setProperty(MapCreator.TRIPLEA_UNIT_ZOOM, "" + s_unit_zoom);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                unitZoomText.setText("" + s_unit_zoom);
            }
        });
        this.m_panel1.add(unitZoomText);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.add(new JLabel("Set the width of the unit images: "));
        final JTextField unitWidthText = new JTextField("" + s_unit_width);
        unitWidthText.setMaximumSize(new Dimension(100, 20));
        unitWidthText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                try {
                    s_unit_width = Math.min(400, Math.max(1, Integer.parseInt(unitWidthText.getText())));
                    System.setProperty(MapCreator.TRIPLEA_UNIT_WIDTH, "" + s_unit_width);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                unitWidthText.setText("" + s_unit_width);
            }
        });
        this.m_panel1.add(unitWidthText);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.add(new JLabel("Set the height of the unit images: "));
        final JTextField unitHeightText = new JTextField("" + s_unit_height);
        unitHeightText.setMaximumSize(new Dimension(100, 20));
        unitHeightText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                try {
                    s_unit_height = Math.min(400, Math.max(1, Integer.parseInt(unitHeightText.getText())));
                    System.setProperty(MapCreator.TRIPLEA_UNIT_HEIGHT, "" + s_unit_height);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                unitHeightText.setText("" + s_unit_height);
            }
        });
        this.m_panel1.add(unitHeightText);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.add(new JLabel("<html>Here you can set the 'max memory' that utilities like the Polygon Grabber will use.<br>This is useful is you have a very large map, or ever get any Java Heap Space errors.</html>"));
        this.m_panel1.add(new JLabel("Set the amount of memory to use when running new processes (in megabytes [mb]):"));
        final JTextField memoryText = new JTextField("" + s_memory / 0x100000L);
        memoryText.setMaximumSize(new Dimension(100, 20));
        memoryText.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
            }

            public void focusLost(FocusEvent e) {
                try {
                    s_memory = 0x100000L * (long)Math.min(4096, Math.max(256, Integer.parseInt(memoryText.getText())));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                memoryText.setText("" + s_memory / 0x100000L);
            }
        });
        this.m_panel1.add(memoryText);
        final JCheckBox runTypeBox = new JCheckBox("Run All Utilities as Separate Processes");
        runTypeBox.setSelected(s_runUtilitiesAsSeperateProcesses);
        runTypeBox.addActionListener(new AbstractAction("Run All Utilities as Separate Processes"){
            private static final long serialVersionUID = 363422421871497915L;

            public void actionPerformed(ActionEvent e) {
                s_runUtilitiesAsSeperateProcesses = runTypeBox.isSelected();
            }
        });
        this.m_panel1.add(runTypeBox);
        this.m_panel1.add(Box.createVerticalStrut(30));
        this.m_panel1.validate();
    }

    private void createPart2Panel() {
        this.m_panel2.removeAll();
        this.m_panel2.setLayout(new BoxLayout(this.m_panel2, 3));
        this.m_panel2.add(Box.createVerticalStrut(30));
        this.m_panel2.add(new JLabel("Map Skin Utilities:"));
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton mapPropertiesMakerButton = new JButton("Run the Map Properties Maker");
        mapPropertiesMakerButton.addActionListener(new AbstractAction("Run the Map Properties Maker"){
            private static final long serialVersionUID = -5708777348010034859L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.MapPropertiesMaker");
                } else {
                    new Thread(){

                        public void run() {
                            MapPropertiesMaker.main(new String[0]);
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(mapPropertiesMakerButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton centerPickerButton = new JButton("Run the Center Picker");
        centerPickerButton.addActionListener(new AbstractAction("Run the Center Picker"){
            private static final long serialVersionUID = -2070004374472175438L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.CenterPicker");
                } else {
                    new Thread(){

                        public void run() {
                            CenterPicker.main(new String[0]);
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(centerPickerButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton polygonGrabberButton = new JButton("Run the Polygon Grabber");
        polygonGrabberButton.addActionListener(new AbstractAction("Run the Polygon Grabber"){
            private static final long serialVersionUID = -5708777348010034859L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.PolygonGrabber");
                } else {
                    new Thread(){

                        public void run() {
                            PolygonGrabber.main(new String[0]);
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(polygonGrabberButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton autoPlacerButton = new JButton("Run the Automatic Placement Finder");
        autoPlacerButton.addActionListener(new AbstractAction("Run the Automatic Placement Finder"){
            private static final long serialVersionUID = 7557803418683843877L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.AutoPlacementFinder");
                } else {
                    new Thread(){

                        public void run() {
                            AutoPlacementFinder.main(new String[0]);
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(autoPlacerButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton placementPickerButton = new JButton("Run the Placement Picker");
        placementPickerButton.addActionListener(new AbstractAction("Run the Placement Picker"){
            private static final long serialVersionUID = 2456185407945946528L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.PlacementPicker");
                } else {
                    new Thread(){

                        public void run() {
                            PlacementPicker.main(new String[0]);
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(placementPickerButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton tileBreakerButton = new JButton("Run the Tile Image Breaker");
        tileBreakerButton.addActionListener(new AbstractAction("Run the Tile Image Breaker"){
            private static final long serialVersionUID = 8636496829644907047L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.TileImageBreaker");
                } else {
                    new Thread(){

                        public void run() {
                            try {
                                TileImageBreaker.main(new String[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(tileBreakerButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        JButton decorationPlacerButton = new JButton("Run the Decoration Placer");
        decorationPlacerButton.addActionListener(new AbstractAction("Run the Decoration Placer"){
            private static final long serialVersionUID = 8981678371888002420L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.DecorationPlacer");
                } else {
                    new Thread(){

                        public void run() {
                            try {
                                DecorationPlacer.main(new String[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        });
        this.m_panel2.add(decorationPlacerButton);
        this.m_panel2.add(Box.createVerticalStrut(30));
        this.m_panel2.validate();
    }

    private void createPart3Panel() {
        this.m_panel3.removeAll();
        this.m_panel3.setLayout(new BoxLayout(this.m_panel3, 3));
        this.m_panel3.add(Box.createVerticalStrut(30));
        this.m_panel3.add(new JLabel("Game XML Utilities:"));
        this.m_panel3.add(new JLabel("Sorry but for now the only XML creator is Wisconsin's 'Part 2' of his map maker."));
        this.m_panel3.add(new JLabel("You can try downloading it from our dev forum: http://triplea.sourceforge.net/mywiki/Forum"));
        this.m_panel3.add(Box.createVerticalStrut(30));
        JButton goToWebButton = new JButton("Go To Dev Forum");
        goToWebButton.addActionListener(new AbstractAction("Go To Dev Forum"){
            private static final long serialVersionUID = 5059004450673029377L;

            public void actionPerformed(ActionEvent e) {
                try {
                    DesktopUtilityBrowserLauncher.openURL("http://triplea.sourceforge.net/mywiki/Forum");
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        });
        this.m_panel3.add(goToWebButton);
        this.m_panel3.add(Box.createVerticalStrut(30));
        JButton connectionFinderButton = new JButton("Run the Connection Finder");
        connectionFinderButton.addActionListener(new AbstractAction("Run the Connection Finder"){
            private static final long serialVersionUID = 8778155499250138516L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.ConnectionFinder");
                } else {
                    new Thread(){

                        public void run() {
                            try {
                                ConnectionFinder.main(new String[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        });
        this.m_panel3.add(connectionFinderButton);
        this.m_panel3.add(Box.createVerticalStrut(30));
        this.m_panel3.validate();
    }

    private void createPart4Panel() {
        this.m_panel4.removeAll();
        this.m_panel4.setLayout(new BoxLayout(this.m_panel4, 3));
        this.m_panel4.add(Box.createVerticalStrut(30));
        this.m_panel4.add(new JLabel("Other or Optional Utilities:"));
        this.m_panel4.add(Box.createVerticalStrut(30));
        JButton reliefBreakerButton = new JButton("Run the Relief Image Breaker");
        reliefBreakerButton.addActionListener(new AbstractAction("Run the Relief Image Breaker"){
            private static final long serialVersionUID = 8981678371888002420L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.ReliefImageBreaker");
                } else {
                    new Thread(){

                        public void run() {
                            try {
                                ReliefImageBreaker.main(new String[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        });
        this.m_panel4.add(reliefBreakerButton);
        this.m_panel4.add(Box.createVerticalStrut(30));
        JButton imageShrinkerButton = new JButton("Run the Image Shrinker");
        imageShrinkerButton.addActionListener(new AbstractAction("Run the Image Shrinker"){
            private static final long serialVersionUID = 8778155499250138516L;

            public void actionPerformed(ActionEvent e) {
                if (s_runUtilitiesAsSeperateProcesses) {
                    MapCreator.this.runUtility("util.image.ImageShrinker");
                } else {
                    new Thread(){

                        public void run() {
                            try {
                                ImageShrinker.main(new String[0]);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        });
        this.m_panel4.add(imageShrinkerButton);
        this.m_panel4.add(Box.createVerticalStrut(30));
        this.m_panel4.validate();
    }

    private void runUtility(String javaClass) {
        ArrayList<String> commands = new ArrayList<String>();
        ProcessRunnerUtil.populateBasicJavaArgs(commands, s_memory);
        if (s_mapFolderLocation != null && s_mapFolderLocation.exists()) {
            try {
                String pathWithoutSpaces = s_mapFolderLocation.getCanonicalPath().replaceAll(" ", "(");
                commands.add("-Dtriplea.map.folder=\"" + pathWithoutSpaces + "\"");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        commands.add("-Dtriplea.unit.zoom=" + s_unit_zoom);
        commands.add("-Dtriplea.unit.width=" + s_unit_width);
        commands.add("-Dtriplea.unit.height=" + s_unit_height);
        commands.add(javaClass);
        ProcessRunnerUtil.exec(commands);
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        String heightString;
        String widthString;
        String zoomString;
        String[] properties = MapCreator.getProperties();
        if (args.length == 1) {
            String value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? MapCreator.getValue(args[0]) : args[0];
            File mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
        boolean usagePrinted = false;
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            boolean found = false;
            String arg = args[argIndex];
            int indexOf = arg.indexOf(61);
            if (indexOf > 0) {
                arg = arg.substring(0, indexOf);
                for (int propIndex = 0; propIndex < properties.length; ++propIndex) {
                    if (!arg.equals(properties[propIndex])) continue;
                    String value = MapCreator.getValue(args[argIndex]);
                    System.getProperties().setProperty(properties[propIndex], value);
                    System.out.println(properties[propIndex] + ":" + value);
                    found = true;
                    break;
                }
            }
            if (found) continue;
            System.out.println("Unrecogized:" + args[argIndex]);
            if (usagePrinted) continue;
            usagePrinted = true;
            System.out.println("Arguments\r\n   triplea.map.folder=<FILE_PATH>\r\n   triplea.unit.zoom=<UNIT_ZOOM_LEVEL>\r\n   triplea.unit.width=<UNIT_WIDTH>\r\n   triplea.unit.height=<UNIT_HEIGHT>\r\n");
        }
        String folderString = System.getProperty(TRIPLEA_MAP_FOLDER);
        if (folderString != null && folderString.length() > 0) {
            File mapFolder = new File(folderString = folderString.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + folderString);
            }
        }
        if ((zoomString = System.getProperty(TRIPLEA_UNIT_ZOOM)) != null && zoomString.length() > 0) {
            try {
                s_unit_zoom = Double.parseDouble(zoomString);
                System.out.println("Unit Zoom Percent to use: " + s_unit_zoom);
            }
            catch (Exception ex) {
                System.err.println("Not a decimal percentage: " + zoomString);
            }
        }
        if ((widthString = System.getProperty(TRIPLEA_UNIT_WIDTH)) != null && widthString.length() > 0) {
            try {
                s_unit_width = Integer.parseInt(widthString);
                System.out.println("Unit Width to use: " + s_unit_width);
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + widthString);
            }
        }
        if ((heightString = System.getProperty(TRIPLEA_UNIT_HEIGHT)) != null && heightString.length() > 0) {
            try {
                s_unit_height = Integer.parseInt(heightString);
                System.out.println("Unit Height to use: " + s_unit_height);
            }
            catch (Exception ex) {
                System.err.println("Not an integer: " + heightString);
            }
        }
    }
}

