/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import util.image.FileOpen;
import util.image.FileSave;

public class TileImageBreaker {
    private static String location = null;
    private static JFrame observer = new JFrame();
    private boolean m_baseMap;
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";

    public static void main(String[] args) throws Exception {
        TileImageBreaker.handleCommandLineArgs(args);
        JOptionPane.showMessageDialog(null, new JLabel("<html>This is the TileImageBreaker, it will create the map image tiles file for you. <br>It will take any image, and break it up into 256x256 pixel squares, and put them all in a folder. <br>You can use this to create the base tiles (background) as well as the relief tiles (art relief).<br>For the base image (the one used to make centers.txt, etc), please save it to a folder called baseTiles<br>For the relief image, please save it to a folder called reliefTiles</html>"));
        FileSave locationSelection = new FileSave("Where to save Tile Images?", null, s_mapFolderLocation);
        location = locationSelection.getPathString();
        if (s_mapFolderLocation == null && locationSelection.getFile() != null) {
            s_mapFolderLocation = locationSelection.getFile().getParentFile();
        }
        if (location == null) {
            System.out.println("You need to select a folder to save the tiles in for this to work");
            System.out.println("Shutting down");
            System.exit(0);
            return;
        }
        new TileImageBreaker().createMaps();
    }

    public void createMaps() throws IOException {
        Image map = TileImageBreaker.loadImage();
        if (map == null) {
            System.out.println("You need to select a map image for this to work");
            System.out.println("Shutting down");
            System.exit(0);
            return;
        }
        int x = 0;
        while (x * 256 < map.getWidth(null)) {
            int y = 0;
            while (y * 256 < map.getHeight(null)) {
                Rectangle bounds = new Rectangle(x * 256, y * 256, 256, 256);
                GraphicsConfiguration m_localGraphicSystem = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                BufferedImage relief = m_localGraphicSystem.createCompatibleImage(256, 256, this.m_baseMap ? 2 : 3);
                relief.getGraphics().drawImage(map, 0, 0, 256, 256, bounds.x, bounds.y, bounds.x + 256, bounds.y + 256, observer);
                String outFileName = location + File.separator + x + "_" + y + ".png";
                ImageIO.write((RenderedImage)relief, "png", new File(outFileName));
                System.out.println("wrote " + outFileName);
                ++y;
            }
            ++x;
        }
        System.out.println("All Finished!");
        JOptionPane.showMessageDialog(null, new JLabel("All Finished"));
        System.exit(0);
    }

    private static Image loadImage() {
        System.out.println("Select the map");
        String mapName = new FileOpen("Select The Map", s_mapFolderLocation, ".gif", ".png").getPathString();
        if (mapName != null) {
            Image img = Toolkit.getDefaultToolkit().createImage(mapName);
            MediaTracker tracker = new MediaTracker(new Panel());
            tracker.addImage(img, 1);
            try {
                tracker.waitForAll();
                return img;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
                return TileImageBreaker.loadImage();
            }
        }
        return null;
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        File mapFolder;
        String value;
        if (args.length == 1) {
            value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? TileImageBreaker.getValue(args[0]) : args[0];
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        } else if (args.length > 1) {
            System.out.println("Only argument allowed is the map directory.");
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            mapFolder = new File(value = value.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
    }
}

