/*
 * Decompiled with CFR 0.152.
 */
package util.image;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import util.image.FileOpen;

public class XmlUpdater {
    private static File s_mapFolderLocation = null;
    private static final String TRIPLEA_MAP_FOLDER = "triplea.map.folder";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        ByteArrayOutputStream resultBuf;
        XmlUpdater.handleCommandLineArgs(args);
        File gameXmlFile = new FileOpen("Select xml file", s_mapFolderLocation, ".xml").getFile();
        if (gameXmlFile == null) {
            System.out.println("No file selected");
            return;
        }
        InputStream source = XmlUpdater.class.getResourceAsStream("gameupdate.xslt");
        if (source == null) {
            throw new IllegalStateException("Could not find xslt file");
        }
        Transformer trans = TransformerFactory.newInstance().newTransformer(new StreamSource(source));
        BufferedInputStream gameXmlStream = new BufferedInputStream(new FileInputStream(gameXmlFile));
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(true);
            URL url = XmlUpdater.class.getResource("");
            String system = url.toExternalForm();
            StreamSource xmlSource = new StreamSource(gameXmlStream, system);
            resultBuf = new ByteArrayOutputStream();
            trans.transform(xmlSource, new StreamResult(resultBuf));
        }
        finally {
            ((InputStream)gameXmlStream).close();
        }
        gameXmlFile.renameTo(new File(gameXmlFile.getAbsolutePath() + ".backup"));
        new FileOutputStream(gameXmlFile).write(resultBuf.toByteArray());
        System.out.println("Successfully updated:" + gameXmlFile);
    }

    private static String getValue(String arg) {
        int index = arg.indexOf(61);
        if (index == -1) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static void handleCommandLineArgs(String[] args) {
        File mapFolder;
        String value;
        if (args.length == 1) {
            value = args[0].startsWith(TRIPLEA_MAP_FOLDER) ? XmlUpdater.getValue(args[0]) : args[0];
            mapFolder = new File(value);
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        } else if (args.length > 1) {
            System.out.println("Only argument allowed is the map directory.");
        }
        if ((s_mapFolderLocation == null || s_mapFolderLocation.length() < 1L) && (value = System.getProperty(TRIPLEA_MAP_FOLDER)) != null && value.length() > 0) {
            mapFolder = new File(value = value.replaceAll("\\(", " "));
            if (mapFolder.exists()) {
                s_mapFolderLocation = mapFolder;
            } else {
                System.out.println("Could not find directory: " + value);
            }
        }
    }
}

