/* Important rules:
 * - Addr.mode without operand (IMPLIED) must be the last for a mnemonic!
 * - ACCU operand must come before ABS addressing modes!
*/
  "adc",  {IMMED  ,               }, {0x69,0x00,0x00,M6502},
  "adc",  {ABS    ,               }, {0x6d,0x65,0x6f,M6502},
  "adc",  {SR     ,               }, {0x63,0x00,0x00,WDC65816},
  "adc",  {SRINDY ,               }, {0x73,0x00,0x00,WDC65816},
  "adc",  {DPINDX ,               }, {0x61,0x00,0x00,M6502},
  "adc",  {DPINDY ,               }, {0x71,0x00,0x00,M6502},
  "adc",  {DPINDZ ,               }, {0x72,0x00,0x00,CSGCE02},
  "adc",  {DPIND  ,               }, {0x72,0x00,0x00,M65C02},
  "adc",  {ABSX   ,               }, {0x7d,0x75,0x7f,M6502},
  "adc",  {ABSY   ,               }, {0x79,0x00,0x00,M6502},
  "adc",  {QDPINDZ,               }, {0x72,0x00,0x00,M45GS02},
  "adc",  {LDPINDY,               }, {0x77,0x00,0x00,WDC65816},
  "adc",  {LDPIND ,               }, {0x67,0x00,0x00,WDC65816},
  "adcq", {ABS    ,               }, {0x6d,0x65,0x00,M45GS02Q},
  "adcq", {DPIND  ,               }, {0x72,0x00,0x00,M45GS02Q},
  "adcq", {QDPIND ,               }, {0x72,0x00,0x00,M45GS02Q},
  "ahx",  {DPINDY ,               }, {0x93,0x00,0x00,ILL},
  "ahx",  {ABSY   ,               }, {0x9f,0x00,0x00,ILL},
  "alr",  {IMMED  ,               }, {0x4b,0x00,0x00,ILL},
  "anc",  {IMMED  ,               }, {0x0b,0x00,0x00,ILL},
  "anc2", {IMMED  ,               }, {0x2b,0x00,0x00,ILL},
  "and",  {IMMED  ,               }, {0x29,0x00,0x00,M6502},
  "and",  {ABS    ,               }, {0x2d,0x25,0x2f,M6502},
  "and",  {SR     ,               }, {0x23,0x00,0x00,WDC65816},
  "and",  {SRINDY ,               }, {0x33,0x00,0x00,WDC65816},
  "and",  {DPINDX ,               }, {0x21,0x00,0x00,M6502},
  "and",  {DPINDY ,               }, {0x31,0x00,0x00,M6502},
  "and",  {DPINDZ ,               }, {0x32,0x00,0x00,CSGCE02},
  "and",  {DPIND  ,               }, {0x32,0x00,0x00,M65C02},
  "and",  {ABSX   ,               }, {0x3d,0x35,0x3f,M6502},
  "and",  {ABSY   ,               }, {0x39,0x00,0x00,M6502},
  "and",  {QDPINDZ,               }, {0x32,0x00,0x00,M45GS02},
  "and",  {LDPINDY,               }, {0x37,0x00,0x00,WDC65816},
  "and",  {LDPIND ,               }, {0x27,0x00,0x00,WDC65816},
  "andq", {ABS    ,               }, {0x2d,0x25,0x00,M45GS02Q},
  "andq", {DPIND  ,               }, {0x32,0x00,0x00,M45GS02Q},
  "andq", {QDPIND ,               }, {0x32,0x00,0x00,M45GS02Q},
  "arr",  {IMMED  ,               }, {0x6b,0x00,0x00,ILL},
  "asl",  {ACCU   ,               }, {0x0a,0x00,0x00,M6502},
  "asl",  {ABS    ,               }, {0x0e,0x06,0x00,M6502},
  "asl",  {ABSX   ,               }, {0x1e,0x16,0x00,M6502},
  "asl",  {IMPLIED,               }, {0x0a,0x00,0x00,M6502},
  "aslq", {ABS    ,               }, {0x0e,0x06,0x00,M45GS02Q},
  "aslq", {ABSX   ,               }, {0x1e,0x16,0x00,M45GS02Q},
  "aslq", {IMPLIED,               }, {0x0a,0x00,0x00,M45GS02Q},
  "aso",  {ABS    ,               }, {0x0f,0x07,0x00,ILL},
  "aso",  {DPINDX ,               }, {0x03,0x00,0x00,ILL},
  "aso",  {DPINDY ,               }, {0x13,0x00,0x00,ILL},
  "aso",  {ABSX   ,               }, {0x1f,0x17,0x00,ILL},
  "aso",  {ABSY   ,               }, {0x1b,0x00,0x00,ILL},
  "asr",  {ACCU   ,               }, {0x43,0x00,0x00,CSGCE02},
  "asr",  {ABS    ,               }, {0x00,0x44,0x00,CSGCE02},
  "asr",  {ABSX   ,               }, {0x00,0x54,0x00,CSGCE02},
  "asr",  {IMPLIED,               }, {0x43,0x00,0x00,CSGCE02},
  "asrq", {ABS    ,               }, {0x00,0x44,0x00,M45GS02Q},
  "asrq", {ABSX   ,               }, {0x00,0x54,0x00,M45GS02Q},
  "asrq", {IMPLIED,               }, {0x43,0x00,0x00,M45GS02Q},
  "asw",  {ABS    ,               }, {0xcb,0x00,0x00,CSGCE02},
  "axa",  {DPINDY ,               }, {0x93,0x00,0x00,ILL},
  "axa",  {ABSY   ,               }, {0x9f,0x00,0x00,ILL},
  "axs",  {IMMED  ,               }, {0xcb,0x00,0x00,ILL},
  "axs",  {ABS    ,               }, {0x8f,0x87,0x00,ILL},
  "axs",  {DPINDX ,               }, {0x83,0x00,0x00,ILL},
  "axs",  {ABSY   ,               }, {0x00,0x97,0x00,ILL},
  "bbr",  {WBIT   ,DPAGE  ,REL8   }, {0x00,0x0f,0x00,WDC02},
  "bbr0", {DPAGE  ,REL8           }, {0x00,0x0f,0x00,WDC02},
  "bbr1", {DPAGE  ,REL8           }, {0x00,0x1f,0x00,WDC02},
  "bbr2", {DPAGE  ,REL8           }, {0x00,0x2f,0x00,WDC02},
  "bbr3", {DPAGE  ,REL8           }, {0x00,0x3f,0x00,WDC02},
  "bbr4", {DPAGE  ,REL8           }, {0x00,0x4f,0x00,WDC02},
  "bbr5", {DPAGE  ,REL8           }, {0x00,0x5f,0x00,WDC02},
  "bbr6", {DPAGE  ,REL8           }, {0x00,0x6f,0x00,WDC02},
  "bbr7", {DPAGE  ,REL8           }, {0x00,0x7f,0x00,WDC02},
  "bbs",  {WBIT   ,DPAGE  ,REL8   }, {0x00,0x8f,0x00,WDC02},
  "bbs0", {DPAGE  ,REL8           }, {0x00,0x8f,0x00,WDC02},
  "bbs1", {DPAGE  ,REL8           }, {0x00,0x9f,0x00,WDC02},
  "bbs2", {DPAGE  ,REL8           }, {0x00,0xaf,0x00,WDC02},
  "bbs3", {DPAGE  ,REL8           }, {0x00,0xbf,0x00,WDC02},
  "bbs4", {DPAGE  ,REL8           }, {0x00,0xcf,0x00,WDC02},
  "bbs5", {DPAGE  ,REL8           }, {0x00,0xdf,0x00,WDC02},
  "bbs6", {DPAGE  ,REL8           }, {0x00,0xef,0x00,WDC02},
  "bbs7", {DPAGE  ,REL8           }, {0x00,0xff,0x00,WDC02},
  "bcc",  {REL8   ,               }, {0x90,0x00,0x00,M6502},
  "bcs",  {REL8   ,               }, {0xb0,0x00,0x00,M6502},
  "beq",  {REL8   ,               }, {0xf0,0x00,0x00,M6502},
  "bit",  {IMMED  ,               }, {0x89,0x00,0x00,M65C02},
  "bit",  {ABS    ,               }, {0x2c,0x24,0x00,M6502},
  "bit",  {ABSX   ,               }, {0x3c,0x34,0x00,M65C02},
  "bitq", {ABS    ,               }, {0x2c,0x24,0x00,M45GS02Q},
  "blt",  {REL8   ,               }, {0x90,0x00,0x00,M6502},
  "bge",  {REL8   ,               }, {0xb0,0x00,0x00,M6502},
  "bmi",  {REL8   ,               }, {0x30,0x00,0x00,M6502},
  "bne",  {REL8   ,               }, {0xd0,0x00,0x00,M6502},
  "bpl",  {REL8   ,               }, {0x10,0x00,0x00,M6502},
  "bra",  {REL8   ,               }, {0x12,0x00,0x00,DTV},
  "bra",  {REL8   ,               }, {0x80,0x00,0x00,M65C02},
  "brk",  {IMMED8 ,               }, {0x00,0x00,0x00,M6502},
  "brk",  {IMPLIED,               }, {0x00,0x00,0x00,M6502},
  "brl",  {REL16  ,               }, {0x82,0x00,0x00,WDC65816},
  "bsr",  {REL8   ,               }, {0x44,0x00,0x00,HU6280},
  "bvc",  {REL8   ,               }, {0x50,0x00,0x00,M6502},
  "bvs",  {REL8   ,               }, {0x70,0x00,0x00,M6502},
  "cla",  {IMPLIED,               }, {0x62,0x00,0x00,HU6280},
  "clc",  {IMPLIED,               }, {0x18,0x00,0x00,M6502},
  "cld",  {IMPLIED,               }, {0xd8,0x00,0x00,M6502},
  "cle",  {IMPLIED,               }, {0x02,0x00,0x00,CSGCE02},
  "cli",  {IMPLIED,               }, {0x58,0x00,0x00,M6502},
  "clv",  {IMPLIED,               }, {0xb8,0x00,0x00,M6502},
  "clx",  {IMPLIED,               }, {0x82,0x00,0x00,HU6280},
  "cly",  {IMPLIED,               }, {0xc2,0x00,0x00,HU6280},
  "cmp",  {IMMED  ,               }, {0xc9,0x00,0x00,M6502},
  "cmp",  {ABS    ,               }, {0xcd,0xc5,0xcf,M6502},
  "cmp",  {SR     ,               }, {0xc3,0x00,0x00,WDC65816},
  "cmp",  {SRINDY ,               }, {0xd3,0x00,0x00,WDC65816},
  "cmp",  {DPINDX ,               }, {0xc1,0x00,0x00,M6502},
  "cmp",  {DPINDY ,               }, {0xd1,0x00,0x00,M6502},
  "cmp",  {DPINDZ ,               }, {0xd2,0x00,0x00,CSGCE02},
  "cmp",  {DPIND  ,               }, {0xd2,0x00,0x00,M65C02},
  "cmp",  {ABSX   ,               }, {0xdd,0xd5,0xdf,M6502},
  "cmp",  {ABSY   ,               }, {0xd9,0x00,0x00,M6502},
  "cmp",  {QDPINDZ,               }, {0xd2,0x00,0x00,M45GS02},
  "cmp",  {LDPINDY,               }, {0xd7,0x00,0x00,WDC65816},
  "cmp",  {LDPIND ,               }, {0xc7,0x00,0x00,WDC65816},
  "cpa",  {IMMED  ,               }, {0xc9,0x00,0x00,WDC65816},
  "cpa",  {ABS    ,               }, {0xcd,0xc5,0xcf,WDC65816},
  "cpa",  {SR     ,               }, {0xc3,0x00,0x00,WDC65816},
  "cpa",  {SRINDY ,               }, {0xd3,0x00,0x00,WDC65816},
  "cpa",  {DPINDX ,               }, {0xc1,0x00,0x00,WDC65816},
  "cpa",  {DPINDY ,               }, {0xd1,0x00,0x00,WDC65816},
  "cpa",  {DPIND  ,               }, {0xd2,0x00,0x00,WDC65816},
  "cpa",  {ABSX   ,               }, {0xdd,0xd5,0xdf,WDC65816},
  "cpa",  {ABSY   ,               }, {0xd9,0x00,0x00,WDC65816},
  "cpa",  {LDPINDY,               }, {0xd7,0x00,0x00,WDC65816},
  "cpa",  {LDPIND ,               }, {0xc7,0x00,0x00,WDC65816},
  "cop",  {IMMED8 ,               }, {0x02,0x00,0x00,WDC65816},
  "cpq",  {ABS    ,               }, {0xcd,0xc5,0x00,M45GS02Q},
  "cpq",  {DPIND  ,               }, {0xd2,0x00,0x00,M45GS02Q},
  "cpq",  {QDPIND ,               }, {0xd2,0x00,0x00,M45GS02Q},
  "cpx",  {IMMEDX ,               }, {0xe0,0x00,0x00,M6502},
  "cpx",  {ABS    ,               }, {0xec,0xe4,0x00,M6502},
  "cpy",  {IMMEDX ,               }, {0xc0,0x00,0x00,M6502},
  "cpy",  {ABS    ,               }, {0xcc,0xc4,0x00,M6502},
  "cpz",  {IMMED  ,               }, {0xc2,0x00,0x00,CSGCE02},
  "cpz",  {ABS    ,               }, {0xdc,0xd4,0x00,CSGCE02},
  "csh",  {IMPLIED,               }, {0xd4,0x00,0x00,HU6280},
  "csl",  {IMPLIED,               }, {0x54,0x00,0x00,HU6280},
  "dcm",  {ABS    ,               }, {0xcf,0xc7,0x00,ILL},
  "dcm",  {DPINDX ,               }, {0xc3,0x00,0x00,ILL},
  "dcm",  {DPINDY ,               }, {0xd3,0x00,0x00,ILL},
  "dcm",  {ABSX   ,               }, {0xdf,0xd7,0x00,ILL},
  "dcm",  {ABSY   ,               }, {0xdb,0x00,0x00,ILL},
  "dcp",  {ABS    ,               }, {0xcf,0xc7,0x00,ILL},
  "dcp",  {DPINDX ,               }, {0xc3,0x00,0x00,ILL},
  "dcp",  {DPINDY ,               }, {0xd3,0x00,0x00,ILL},
  "dcp",  {ABSX   ,               }, {0xdf,0xd7,0x00,ILL},
  "dcp",  {ABSY   ,               }, {0xdb,0x00,0x00,ILL},
  "dea",  {IMPLIED,               }, {0x3a,0x00,0x00,M65C02},    
  "dec",  {ACCU   ,               }, {0x3a,0x00,0x00,M65C02},
  "dec",  {ABS    ,               }, {0xce,0xc6,0x00,M6502},
  "dec",  {ABSX   ,               }, {0xde,0xd6,0x00,M6502},
  "dec",  {IMPLIED,               }, {0x3a,0x00,0x00,M65C02},
  "deq",  {ABS    ,               }, {0xce,0xc6,0x00,M45GS02Q},
  "deq",  {ABSX   ,               }, {0xde,0xd6,0x00,M45GS02Q},
  "deq",  {IMPLIED,               }, {0x3a,0x00,0x00,M45GS02Q},
  "dew",  {DPAGE  ,               }, {0x00,0xc3,0x00,CSGCE02},
  "dex",  {IMPLIED,               }, {0xca,0x00,0x00,M6502},
  "dey",  {IMPLIED,               }, {0x88,0x00,0x00,M6502},
  "dez",  {IMPLIED,               }, {0x3b,0x00,0x00,CSGCE02},
  "eom",  {IMPLIED,               }, {0xea,0x00,0x00,M45GS02},
  "eor",  {IMMED  ,               }, {0x49,0x00,0x00,M6502},
  "eor",  {ABS    ,               }, {0x4d,0x45,0x4f,M6502},
  "eor",  {SR     ,               }, {0x43,0x00,0x00,WDC65816},
  "eor",  {SRINDY ,               }, {0x53,0x00,0x00,WDC65816},
  "eor",  {DPINDX ,               }, {0x41,0x00,0x00,M6502},
  "eor",  {DPINDY ,               }, {0x51,0x00,0x00,M6502},
  "eor",  {DPINDZ ,               }, {0x52,0x00,0x00,CSGCE02},
  "eor",  {DPIND  ,               }, {0x52,0x00,0x00,M65C02},
  "eor",  {ABSX   ,               }, {0x5d,0x55,0x5f,M6502},
  "eor",  {ABSY   ,               }, {0x59,0x00,0x00,M6502},
  "eor",  {QDPINDZ,               }, {0x52,0x00,0x00,M45GS02},
  "eor",  {LDPINDY,               }, {0x57,0x00,0x00,WDC65816},
  "eor",  {LDPIND ,               }, {0x47,0x00,0x00,WDC65816},
  "eorq", {ABS    ,               }, {0x4d,0x45,0x00,M45GS02Q},
  "eorq", {DPIND  ,               }, {0x52,0x00,0x00,M45GS02Q},
  "eorq", {QDPIND ,               }, {0x52,0x00,0x00,M45GS02Q},
  "ina",  {IMPLIED,               }, {0x1a,0x00,0x00,M65C02},
  "inc",  {ACCU   ,               }, {0x1a,0x00,0x00,M65C02},
  "inc",  {ABS    ,               }, {0xee,0xe6,0x00,M6502},
  "inc",  {ABSX   ,               }, {0xfe,0xf6,0x00,M6502},
  "inc",  {IMPLIED,               }, {0x1a,0x00,0x00,M65C02},
  "inq",  {ABS    ,               }, {0xee,0xe6,0x00,M45GS02Q},
  "inq",  {ABSX   ,               }, {0xfe,0xf6,0x00,M45GS02Q},
  "inq",  {IMPLIED,               }, {0x1a,0x00,0x00,M45GS02Q},
  "ins",  {ABS    ,               }, {0xef,0xe7,0x00,ILL},
  "ins",  {DPINDX ,               }, {0xe3,0x00,0x00,ILL},
  "ins",  {DPINDY ,               }, {0xf3,0x00,0x00,ILL},
  "ins",  {ABSX   ,               }, {0xff,0xf7,0x00,ILL},
  "ins",  {ABSY   ,               }, {0xfb,0x00,0x00,ILL},
  "inw",  {ABS    ,               }, {0x00,0xe3,0x00,CSGCE02},
  "inx",  {IMPLIED,               }, {0xe8,0x00,0x00,M6502},
  "iny",  {IMPLIED,               }, {0xc8,0x00,0x00,M6502},
  "inz",  {IMPLIED,               }, {0x1b,0x00,0x00,CSGCE02},
  "isc",  {ABS    ,               }, {0xef,0xe7,0x00,ILL},
  "isc",  {DPINDX ,               }, {0xe3,0x00,0x00,ILL},
  "isc",  {DPINDY ,               }, {0xf3,0x00,0x00,ILL},
  "isc",  {ABSX   ,               }, {0xff,0xf7,0x00,ILL},
  "isc",  {ABSY   ,               }, {0xfb,0x00,0x00,ILL},
  "jml",  {LABS   ,               }, {0x00,0x00,0x5c,WDC65816},
  "jml",  {LINDIR ,               }, {0xdc,0x00,0x00,WDC65816},
  "jmp",  {ABS    ,               }, {0x4c,0x00,0x5c,M6502},
  "jmp",  {INDIRX ,               }, {0x7c,0x00,0x00,M65C02},
  "jmp",  {INDIR  ,               }, {0x6c,0x00,0x00,M6502},
  "jmp",  {LINDIR ,               }, {0xdc,0x00,0x00,WDC65816},
  "jsl",  {LABS   ,               }, {0x00,0x00,0x22,WDC65816},
  "jsr",  {ABS    ,               }, {0x20,0x00,0x22,M6502},
  "jsr",  {INDIRX ,               }, {0xfc,0x00,0x00,WDC65816},
  "las",  {ABSY   ,               }, {0xbb,0x00,0x00,ILL},
  "lax",  {IMMED  ,               }, {0xab,0x00,0x00,ILL},
  "lax",  {ABS    ,               }, {0xaf,0xa7,0x00,ILL},
  "lax",  {ABSY   ,               }, {0xbf,0xb7,0x00,ILL},
  "lax",  {DPINDX ,               }, {0xa3,0x00,0x00,ILL},
  "lax",  {DPINDY ,               }, {0xb3,0x00,0x00,ILL},
  "lda",  {IMMED  ,               }, {0xa9,0x00,0x00,M6502},
  "lda",  {ABS    ,               }, {0xad,0xa5,0xaf,M6502},
  "lda",  {SR     ,               }, {0xa3,0x00,0x00,WDC65816},
  "lda",  {SRINDY ,               }, {0xb3,0x00,0x00,WDC65816},
  "lda",  {DPINDX ,               }, {0xa1,0x00,0x00,M6502},
  "lda",  {DPINDY ,               }, {0xb1,0x00,0x00,M6502},
  "lda",  {DPINDZ ,               }, {0xb2,0x00,0x00,CSGCE02},
  "lda",  {DPIND  ,               }, {0xb2,0x00,0x00,M65C02},
  "lda",  {ABSX   ,               }, {0xbd,0xb5,0xbf,M6502},
  "lda",  {ABSY   ,               }, {0xb9,0x00,0x00,M6502},
  "lda",  {QDPINDZ,               }, {0xb2,0x00,0x00,M45GS02},
  "lda",  {LDPINDY,               }, {0xb7,0x00,0x00,WDC65816},
  "lda",  {LDPIND ,               }, {0xa7,0x00,0x00,WDC65816},
  "ldq",  {ABS    ,               }, {0xad,0xa5,0x00,M45GS02Q},
  "ldq",  {DPINDZ ,               }, {0xb2,0x00,0x00,M45GS02Q},
  "ldq",  {QDPINDZ,               }, {0xb2,0x00,0x00,M45GS02Q},
  "ldx",  {IMMEDX ,               }, {0xa2,0x00,0x00,M6502},
  "ldx",  {ABS    ,               }, {0xae,0xa6,0x00,M6502},
  "ldx",  {ABSY   ,               }, {0xbe,0xb6,0x00,M6502},
  "ldy",  {IMMEDX ,               }, {0xa0,0x00,0x00,M6502},
  "ldy",  {ABS    ,               }, {0xac,0xa4,0x00,M6502},
  "ldy",  {ABSX   ,               }, {0xbc,0xb4,0x00,M6502},
  "ldz",  {IMMED  ,               }, {0xa3,0x00,0x00,CSGCE02},
  "ldz",  {ABS    ,               }, {0xab,0x00,0x00,CSGCE02},
  "ldz",  {ABSX   ,               }, {0xbb,0x00,0x00,CSGCE02},
  "lse",  {ABS    ,               }, {0x4f,0x47,0x00,ILL},
  "lse",  {DPINDX ,               }, {0x43,0x00,0x00,ILL},
  "lse",  {DPINDY ,               }, {0x53,0x00,0x00,ILL},
  "lse",  {ABSX   ,               }, {0x5f,0x57,0x00,ILL},
  "lse",  {ABSY   ,               }, {0x5b,0x00,0x00,ILL},
  "lsr",  {ACCU   ,               }, {0x4a,0x00,0x00,M6502},
  "lsr",  {ABS    ,               }, {0x4e,0x46,0x00,M6502},
  "lsr",  {ABSX   ,               }, {0x5e,0x56,0x00,M6502},
  "lsr",  {IMPLIED,               }, {0x4a,0x00,0x00,M6502},
  "lsrq", {ABS    ,               }, {0x4e,0x46,0x00,M45GS02Q},
  "lsrq", {ABSX   ,               }, {0x5e,0x56,0x00,M45GS02Q},
  "lsrq", {IMPLIED,               }, {0x4a,0x00,0x00,M45GS02Q},
  "map",  {IMPLIED,               }, {0x5c,0x00,0x00,CSGCE02},
  "mvn",  {IMMED8 ,IMMED8         }, {0x54,0x00,0x00,WDC65816},
  "mvn",  {MVBANK ,MVBANK         }, {0x54,0x00,0x00,WDC65816},
  "mvp",  {IMMED8 ,IMMED8         }, {0x44,0x00,0x00,WDC65816},
  "mvp",  {MVBANK ,MVBANK         }, {0x44,0x00,0x00,WDC65816},
  "neg",  {ACCU,                  }, {0x42,0x00,0x00,CSGCE02},
  "neg",  {IMPLIED,               }, {0x42,0x00,0x00,CSGCE02},
  "nop",  {IMPLIED,               }, {0xea,0x00,0x00,M6502},
  "oal",  {IMMED  ,               }, {0xab,0x00,0x00,ILL},
  "ora",  {IMMED  ,               }, {0x09,0x00,0x00,M6502},
  "ora",  {ABS    ,               }, {0x0d,0x05,0x0f,M6502},
  "ora",  {SR     ,               }, {0x03,0x00,0x00,WDC65816},
  "ora",  {SRINDY ,               }, {0x13,0x00,0x00,WDC65816},
  "ora",  {DPINDX ,               }, {0x01,0x00,0x00,M6502},
  "ora",  {DPINDY ,               }, {0x11,0x00,0x00,M6502},
  "ora",  {DPINDZ ,               }, {0x12,0x00,0x00,CSGCE02},
  "ora",  {DPIND  ,               }, {0x12,0x00,0x00,M65C02},
  "ora",  {ABSX   ,               }, {0x1d,0x15,0x1f,M6502},
  "ora",  {ABSY   ,               }, {0x19,0x00,0x00,M6502},
  "ora",  {QDPINDZ,               }, {0x12,0x00,0x00,M45GS02},
  "ora",  {LDPINDY,               }, {0x17,0x00,0x00,WDC65816},
  "ora",  {LDPIND ,               }, {0x07,0x00,0x00,WDC65816},
  "orq",  {ABS    ,               }, {0x0d,0x05,0x00,M45GS02Q},
  "orq",  {DPIND  ,               }, {0x12,0x00,0x00,M45GS02Q},
  "orq",  {QDPIND ,               }, {0x12,0x00,0x00,M45GS02Q},
  "pea",  {IMMED16,               }, {0xf4,0x00,0x00,WDC65816},
  "pea",  {ABS    ,               }, {0xf4,0x00,0x00,WDC65816},
  "pei",  {DPIND  ,               }, {0xd4,0x00,0x00,WDC65816},
  "per",  {REL16  ,               }, {0x62,0x00,0x00,WDC65816},
  "pha",  {IMPLIED,               }, {0x48,0x00,0x00,M6502},
  "phb",  {IMPLIED,               }, {0x8b,0x00,0x00,WDC65816},
  "phd",  {IMPLIED,               }, {0x0b,0x00,0x00,WDC65816},
  "phk",  {IMPLIED,               }, {0x4b,0x00,0x00,WDC65816},
  "php",  {IMPLIED,               }, {0x08,0x00,0x00,M6502},
  "phw",  {IMMED16,               }, {0xf4,0x00,0x00,CSGCE02},
  "phw",  {ABS,                   }, {0xfc,0x00,0x00,CSGCE02},
  "phx",  {IMPLIED,               }, {0xda,0x00,0x00,M65C02},
  "phy",  {IMPLIED,               }, {0x5a,0x00,0x00,M65C02},
  "phz",  {IMPLIED,               }, {0xdb,0x00,0x00,CSGCE02},
  "pla",  {IMPLIED,               }, {0x68,0x00,0x00,M6502},
  "plb",  {IMPLIED,               }, {0xab,0x00,0x00,WDC65816},
  "pld",  {IMPLIED,               }, {0x2b,0x00,0x00,WDC65816},
  "plp",  {IMPLIED,               }, {0x28,0x00,0x00,M6502},
  "plx",  {IMPLIED,               }, {0xfa,0x00,0x00,M65C02},
  "ply",  {IMPLIED,               }, {0x7a,0x00,0x00,M65C02},
  "plz",  {IMPLIED,               }, {0xfb,0x00,0x00,CSGCE02},
  "rep",  {IMMED8,                }, {0xc2,0x00,0x00,WDC65816},
  "rla",  {ABS    ,               }, {0x2f,0x27,0x00,ILL},
  "rla",  {DPINDX ,               }, {0x23,0x00,0x00,ILL},
  "rla",  {DPINDY ,               }, {0x33,0x00,0x00,ILL},
  "rla",  {ABSX   ,               }, {0x3f,0x37,0x00,ILL},
  "rla",  {ABSY   ,               }, {0x3b,0x00,0x00,ILL},
  "rmb",  {WBIT   ,DPAGE          }, {0x00,0x07,0x00,WDC02},
  "rmb0", {DPAGE                  }, {0x00,0x07,0x00,WDC02},
  "rmb1", {DPAGE                  }, {0x00,0x17,0x00,WDC02},
  "rmb2", {DPAGE                  }, {0x00,0x27,0x00,WDC02},
  "rmb3", {DPAGE                  }, {0x00,0x37,0x00,WDC02},
  "rmb4", {DPAGE                  }, {0x00,0x47,0x00,WDC02},
  "rmb5", {DPAGE                  }, {0x00,0x57,0x00,WDC02},
  "rmb6", {DPAGE                  }, {0x00,0x67,0x00,WDC02},
  "rmb7", {DPAGE                  }, {0x00,0x77,0x00,WDC02},
  "rol",  {ACCU   ,               }, {0x2a,0x00,0x00,M6502},
  "rol",  {ABS    ,               }, {0x2e,0x26,0x00,M6502},
  "rol",  {ABSX   ,               }, {0x3e,0x36,0x00,M6502},
  "rol",  {IMPLIED,               }, {0x2a,0x00,0x00,M6502},
  "rolq", {ABS    ,               }, {0x2e,0x26,0x00,M45GS02Q},
  "rolq", {ABSX   ,               }, {0x3e,0x36,0x00,M45GS02Q},
  "rolq", {IMPLIED,               }, {0x2a,0x00,0x00,M45GS02Q},
  "ror",  {ACCU   ,               }, {0x6a,0x00,0x00,M6502},
  "ror",  {ABS    ,               }, {0x6e,0x66,0x00,M6502},
  "ror",  {ABSX   ,               }, {0x7e,0x76,0x00,M6502},
  "ror",  {IMPLIED,               }, {0x6a,0x00,0x00,M6502},
  "rorq", {ABS    ,               }, {0x6e,0x66,0x00,M45GS02Q},
  "rorq", {ABSX   ,               }, {0x7e,0x76,0x00,M45GS02Q},
  "rorq", {IMPLIED,               }, {0x6a,0x00,0x00,M45GS02Q},
  "row",  {ABS    ,               }, {0xeb,0x00,0x00,CSGCE02},
  "rra",  {ABS    ,               }, {0x6f,0x67,0x00,ILL},
  "rra",  {DPINDX ,               }, {0x63,0x00,0x00,ILL},
  "rra",  {DPINDY ,               }, {0x73,0x00,0x00,ILL},
  "rra",  {ABSX   ,               }, {0x7f,0x77,0x00,ILL},
  "rra",  {ABSY   ,               }, {0x7b,0x00,0x00,ILL},
  "rti",  {IMPLIED,               }, {0x40,0x00,0x00,M6502},
  "rtl",  {IMPLIED,               }, {0x6b,0x00,0x00,WDC65816},
  "rts",  {IMMED  ,               }, {0x62,0x60,0x00,CSGCE02},
  "rts",  {IMPLIED,               }, {0x60,0x00,0x00,M6502},
  "sac",  {IMMED  ,               }, {0x32,0x00,0x00,DTV},
  "sax",  {IMMED  ,               }, {0xcb,0x00,0x00,ILL},
  "sax",  {ABS    ,               }, {0x8f,0x87,0x00,ILL},
  "sax",  {DPINDX ,               }, {0x83,0x00,0x00,ILL},
  "sax",  {ABSY   ,               }, {0x00,0x97,0x00,ILL},
  "sax",  {IMPLIED,               }, {0x22,0x00,0x00,HU6280},
  "say",  {ABSX   ,               }, {0x9c,0x00,0x00,ILL},
  "say",  {IMPLIED,               }, {0x42,0x00,0x00,HU6280},
  "sbc",  {IMMED  ,               }, {0xe9,0x00,0x00,M6502},
  "sbc",  {ABS    ,               }, {0xed,0xe5,0xef,M6502},
  "sbc",  {SR     ,               }, {0xe3,0x00,0x00,WDC65816},
  "sbc",  {SRINDY ,               }, {0xf3,0x00,0x00,WDC65816},
  "sbc",  {DPINDX ,               }, {0xe1,0x00,0x00,M6502},
  "sbc",  {DPINDY ,               }, {0xf1,0x00,0x00,M6502},
  "sbc",  {DPINDZ ,               }, {0xf2,0x00,0x00,CSGCE02},
  "sbc",  {DPIND  ,               }, {0xf2,0x00,0x00,M65C02},
  "sbc",  {ABSX   ,               }, {0xfd,0xf5,0xff,M6502},
  "sbc",  {ABSY   ,               }, {0xf9,0x00,0x00,M6502},
  "sbc",  {QDPINDZ,               }, {0xf2,0x00,0x00,M45GS02},
  "sbc",  {LDPINDY,               }, {0xf7,0x00,0x00,WDC65816},
  "sbc",  {LDPIND ,               }, {0xe7,0x00,0x00,WDC65816},
  "sbc2", {IMMED  ,               }, {0xeb,0x00,0x00,ILL},
  "sbcq", {ABS    ,               }, {0xed,0xe5,0x00,M45GS02Q},
  "sbcq", {DPIND  ,               }, {0xf2,0x00,0x00,M45GS02Q},
  "sbcq", {QDPIND ,               }, {0xf2,0x00,0x00,M45GS02Q},
  "sec",  {IMPLIED,               }, {0x38,0x00,0x00,M6502},
  "sed",  {IMPLIED,               }, {0xf8,0x00,0x00,M6502},
  "see",  {IMPLIED,               }, {0x03,0x00,0x00,CSGCE02},
  "sei",  {IMPLIED,               }, {0x78,0x00,0x00,M6502},
  "sep",  {IMMED8,                }, {0xe2,0x00,0x00,WDC65816},
  "set",  {IMPLIED,               }, {0xf4,0x00,0x00,HU6280},
  "shx",  {ABSY   ,               }, {0x9e,0x00,0x00,ILL},
  "shy",  {ABSX   ,               }, {0x9c,0x00,0x00,ILL},
  "sir",  {IMMED  ,               }, {0x42,0x00,0x00,DTV},
  "slo",  {ABS    ,               }, {0x0f,0x07,0x00,ILL},
  "slo",  {DPINDX ,               }, {0x03,0x00,0x00,ILL},
  "slo",  {DPINDY ,               }, {0x13,0x00,0x00,ILL},
  "slo",  {ABSX   ,               }, {0x1f,0x17,0x00,ILL},
  "slo",  {ABSY   ,               }, {0x1b,0x00,0x00,ILL},
  "smb",  {WBIT   ,DPAGE          }, {0x00,0x87,0x00,WDC02},
  "smb0", {DPAGE                  }, {0x00,0x87,0x00,WDC02},
  "smb1", {DPAGE                  }, {0x00,0x97,0x00,WDC02},
  "smb2", {DPAGE                  }, {0x00,0xa7,0x00,WDC02},
  "smb3", {DPAGE                  }, {0x00,0xb7,0x00,WDC02},
  "smb4", {DPAGE                  }, {0x00,0xc7,0x00,WDC02},
  "smb5", {DPAGE                  }, {0x00,0xd7,0x00,WDC02},
  "smb6", {DPAGE                  }, {0x00,0xe7,0x00,WDC02},
  "smb7", {DPAGE                  }, {0x00,0xf7,0x00,WDC02},
  "sre",  {ABS    ,               }, {0x4f,0x47,0x00,ILL},
  "sre",  {DPINDX ,               }, {0x43,0x00,0x00,ILL},
  "sre",  {DPINDY ,               }, {0x53,0x00,0x00,ILL},
  "sre",  {ABSX   ,               }, {0x5f,0x57,0x00,ILL},
  "sre",  {ABSY   ,               }, {0x5b,0x00,0x00,ILL},
  "st0",  {IMMED  ,               }, {0x03,0x00,0x00,HU6280},
  "st1",  {IMMED  ,               }, {0x13,0x00,0x00,HU6280},
  "st2",  {IMMED  ,               }, {0x23,0x00,0x00,HU6280},
  "sta",  {ABS    ,               }, {0x8d,0x85,0x8f,M6502},
  "sta",  {SR     ,               }, {0x83,0x00,0x00,WDC65816},
  "sta",  {SRINDY ,               }, {0x93,0x00,0x00,WDC65816},
  "sta",  {DPINDX ,               }, {0x81,0x00,0x00,M6502},
  "sta",  {DPINDY ,               }, {0x91,0x00,0x00,M6502},
  "sta",  {DPINDZ ,               }, {0x92,0x00,0x00,CSGCE02},
  "sta",  {DPIND  ,               }, {0x92,0x00,0x00,M65C02},
  "sta",  {ABSX   ,               }, {0x9d,0x95,0x9f,M6502},
  "sta",  {ABSY   ,               }, {0x99,0x00,0x00,M6502},
  "sta",  {QDPINDZ,               }, {0x92,0x00,0x00,M45GS02},
  "sta",  {LDPINDY,               }, {0x97,0x00,0x00,WDC65816},
  "sta",  {LDPIND ,               }, {0x87,0x00,0x00,WDC65816},
  "stp",  {IMPLIED,               }, {0xdb,0x00,0x00,WDC02ALL},
  "stq",  {ABS    ,               }, {0x8d,0x85,0x00,M45GS02Q},
  "stq",  {DPIND  ,               }, {0x92,0x00,0x00,M45GS02Q},
  "stq",  {QDPIND ,               }, {0x92,0x00,0x00,M45GS02Q},
  "stx",  {ABS    ,               }, {0x8e,0x86,0x00,M6502},
  "stx",  {ABSY   ,               }, {0x00,0x96,0x00,M6502},
  "sty",  {ABS    ,               }, {0x8c,0x84,0x00,M6502},
  "sty",  {ABSX   ,               }, {0x00,0x94,0x00,M6502},
  "stz",  {ABS    ,               }, {0x9c,0x64,0x00,M65C02},
  "stz",  {ABSX   ,               }, {0x9e,0x74,0x00,M65C02},
  "swa",  {IMPLIED,               }, {0xeb,0x00,0x00,WDC65816},
  "sxy",  {IMPLIED,               }, {0x02,0x00,0x00,HU6280},
  "tab",  {IMPLIED,               }, {0x5b,0x00,0x00,CSGCE02},
  "tad",  {IMPLIED,               }, {0x5b,0x00,0x00,WDC65816},
  "tai",  {ABS    ,ABS    ,ABS    }, {0xf3,0x00,0x00,HU6280},
  "tam",  {IMMED  ,               }, {0x53,0x00,0x00,HU6280},
  "tas",  {ABSY   ,               }, {0x9b,0x00,0x00,ILL},
  "tas",  {IMPLIED,               }, {0x1b,0x00,0x00,WDC65816},
  "tax",  {IMPLIED,               }, {0xaa,0x00,0x00,M6502},
  "tay",  {IMPLIED,               }, {0xa8,0x00,0x00,M6502},
  "taz",  {IMPLIED,               }, {0x4b,0x00,0x00,CSGCE02},
  "tba",  {IMPLIED,               }, {0x7b,0x00,0x00,CSGCE02},
  "tcd",  {IMPLIED,               }, {0x5b,0x00,0x00,WDC65816},
  "tcs",  {IMPLIED,               }, {0x1b,0x00,0x00,WDC65816},
  "tda",  {IMPLIED,               }, {0x7b,0x00,0x00,WDC65816},
  "tdc",  {IMPLIED,               }, {0x7b,0x00,0x00,WDC65816},
  "tdd",  {ABS    ,ABS    ,ABS    }, {0xc3,0x00,0x00,HU6280},
  "tia",  {ABS    ,ABS    ,ABS    }, {0xe3,0x00,0x00,HU6280},
  "tii",  {ABS    ,ABS    ,ABS    }, {0x73,0x00,0x00,HU6280},
  "tin",  {ABS    ,ABS    ,ABS    }, {0xd3,0x00,0x00,HU6280},
  "tma",  {IMMED  ,               }, {0x43,0x00,0x00,HU6280},
  "trb",  {ABS    ,               }, {0x1c,0x14,0x00,M65C02},
  "tsa",  {IMPLIED,               }, {0x3b,0x00,0x00,WDC65816},
  "tsb",  {ABS    ,               }, {0x0c,0x04,0x00,M65C02},
  "tsc",  {IMPLIED,               }, {0x3b,0x00,0x00,WDC65816},
  "tst",  {IMMED  ,ABS            }, {0x93,0x83,0x00,HU6280},
  "tst",  {IMMED  ,ABSX           }, {0xb3,0xa3,0x00,HU6280},
  "tsx",  {IMPLIED,               }, {0xba,0x00,0x00,M6502},
  "tsy",  {IMPLIED,               }, {0x0b,0x00,0x00,CSGCE02},
  "txa",  {IMPLIED,               }, {0x8a,0x00,0x00,M6502},
  "txs",  {IMPLIED,               }, {0x9a,0x00,0x00,M6502},
  "txy",  {IMPLIED,               }, {0x9b,0x00,0x00,WDC65816},
  "tya",  {IMPLIED,               }, {0x98,0x00,0x00,M6502},
  "tys",  {IMPLIED,               }, {0x2b,0x00,0x00,CSGCE02},
  "tyx",  {IMPLIED,               }, {0xbb,0x00,0x00,WDC65816},
  "tza",  {IMPLIED,               }, {0x6b,0x00,0x00,CSGCE02},
  "wai",  {IMPLIED,               }, {0xcb,0x00,0x00,WDC02ALL},
  "wdm",  {IMPLIED,               }, {0x42,0x00,0x00,WDC65816},
  "xaa",  {IMMED  ,               }, {0x8b,0x00,0x00,ILL},
  "xas",  {ABSY   ,               }, {0x9e,0x00,0x00,ILL},
  "xba",  {IMPLIED,               }, {0xeb,0x00,0x00,WDC65816},
  "xce",  {IMPLIED,               }, {0xfb,0x00,0x00,WDC65816},
