#include "translator.h"

translator::translator(QString lang)
{
    m_languageset = lang;
}

QString translator::beautifyString(QString value, int length) {
    QString helper = value;
    QString rc = "";
    int counter = 0;

    // Word-Wrap of lines that are longer than [length] characters ...
    for (int i = 0; i < helper.length(); i++) {
        if ((counter > length) && (helper.mid(i,1) == ' ')) {
            rc = rc + "\n";
            counter = 0;
        } else {
            rc = rc + helper.mid(i,1);
        }
        counter++;
    }

    return rc;
}

QString translator::translateit(QString original) {

    QString base = "Be verbose.|";
            base = base + "Show filenames inside scanned archives.|";
            base = base + "Enable libclamav's debug messages.|";
            base = base + "Only output error messages.|";
            base = base + "Write to stdout instead of stderr. Does not affect 'debug' messages.|";
            base = base + "Disable summary at end of scanning.|";
            base = base + "Only print infected files.|";
            base = base + "Skip printing OK files.|";
            base = base + "Sound bell on virus detection.|";
            base = base + "Do not remove temporary files.|";
            base = base + "Generate JSON description of scanned file(s). JSON will be printed and also-|";
            base = base + "Only load official signatures.|";
            base = base + "Scan subdirectories recursively.|";
            base = base + "Continue scanning within file after finding a match.|";
            base = base + "Scan files and directories on other filesystems.|";
            base = base + "Remove infected files. Be careful!|";
            base = base + "Load unsigned bytecode. **Caution**: You should NEVER run bytecode signatures from untrusted sources. Doing so may result in arbitrary code execution.|";
            base = base + "Detect Possibly Unwanted Applications.|";
            base = base + "Detect structured data (SSN, Credit Card).|";
            base = base + "Scan mail files.|";
            base = base + "Enable email signature-based phishing detection.|";
            base = base + "Enable URL signature-based phishing detection.|";
            base = base + "Heuristic alerts.|";
            base = base + "Stop scanning as soon as a heuristic match is found.|";
            base = base + "Normalize html, script, and text files. Use normalize=no for yara compatibility.|";
            base = base + "Scan PE files.|";
            base = base + "Scan ELF files.|";
            base = base + "Scan OLE2 containers.|";
            base = base + "Scan PDF files.|";
            base = base + "Scan SWF files.|";
            base = base + "Scan HTML files.|";
            base = base + "Scan xml-based document files.|";
            base = base + "Scan HWP3 files.|";
            base = base + "Scan archive files (supported by libclamav).|";
            base = base + "Alert on broken executable files (PE & ELF).|";
            base = base + "Alert on broken graphics files (JPEG, TIFF, PNG, GIF).|";
            base = base + "Alert on encrypted archives and documents.|";
            base = base + "Alert on encrypted archives.|";
            base = base + "Alert on encrypted documents.|";
            base = base + "Alert on OLE2 files containing VBA macros.|";
            base = base + "Alert on files that exceed max file size, max scan size, or max recursion limit.|";
            base = base + "Alert on emails containing SSL mismatches in URLs.|";
            base = base + "Alert on emails containing cloaked URLs.|";
            base = base + "Alert on raw DMG image files containing partition intersections.|";
            base = base + "Disable authenticode certificate chain verification in PE files.|";
            base = base + "Dump authenticode certificate chain in PE files.|";
            base = base + "Disable caching and cache checks for hash sums of scanned files.|";
// new with version 1.4.2 of clamav
            base = base + "Create temporary files for nested file scans that would otherwise be in-memory only.|";
            base = base + "Generate JSON metadata for the scanned file(s). For testing & development use ONLY.|";
            base = base + "Return with a nonzero error code if virus database outdated.|";
            base = base + "Scan OneNote files.|";
            base = base + "Scan image (graphics) files.|";
            base = base + "Detect files by calculating image (graphics) fuzzy hashes.|";
            base = base + "Create temporary files for nested file scans that would otherwise be in-memory only.|";
// clamd.conf
            base = base + "Save all reports to a log file. Default: disabled.|";
            base = base + "By default the log file is locked for writing and only a single daemon process can write to it. This option disables the lock. Default: no|";
            base = base + "Maximum size of the log file. Value of 0 disables the limit. Default: 1048576|";
            base = base + "Log time for each message. Default: no|";
            base = base + "Log all clean files. Useful in debugging but drastically increases the log size. Default: no|";
            base = base + "Use the system logger (can work together with LogFile). Default: no|";
            base = base + "Type of syslog messages. Please refer to 'man syslog' for facility names. (LOG_LOCAL6, LOG_MAIL), Default: LOG_LOCAL6|";
            base = base + "Enable verbose logging. Default: no|";
            base = base + "Rotate log file. Requires LogFileMaxSize option set prior to this option. Default: no|";
            base = base + "Log additional information about the infected file, such as its size and hash, together with the virus name. Default: no|";
            base = base + "Write the daemon's pid to the specified file. Default: disabled|";
            base = base + "This option allows you to change the default temporary directory. Default: /tmp|";
            base = base + "This option allows you to change the default database directory. If you enable it, please make sure it points to the same directory in both clamd and freshclam. Default: /usr/local/share/clamav|";
            base = base + "Only load the official signatures published by the ClamAV project. Default: no|";
            base = base + "Return with a nonzero error code if the virus database is older than the specified number of days. Default: -1|";
            base = base + "Path to a local (Unix) socket the daemon will listen on. Default: disabled|";
            base = base + "Sets the group ownership on the unix socket. Default: |";
            base = base + "Sets the permissions on the unix socket to the specified mode. Default: 660|";
            base = base + "Remove stale socket after unclean shutdown. Default: yes|";
            base = base + "TCP port number the daemon will listen on. Default: disabled|";
            base = base + "By default clamd binds to INADDR_ANY. This option allows you to restrict the TCP address and provide some degree of protection from the outside world. This option can be specified multiple times in order to listen on multiple IPs. IPv6 is now supported. Default: disabled|";
            base = base + "Maximum length the queue of pending connections may grow to. Default: 200|";
            base = base + "Close the STREAM session when the data size limit is exceeded. The value should match your MTA's limit for the maximum attachment size. Default: 100M|";
            base = base + "The STREAM command uses an FTP-like protocol. This option sets the lower boundary for the port range. Default: 1024|";
            base = base + "This option sets the upper boundary for the port range. Default: 2048|";
            base = base + "Maximum number of threads running at the same time. Default: 10|";
            base = base + "This option specifies the time (in seconds) after which clamd should timeout if a client doesn't provide any data. Default: 120|";
            base = base + "This option specifies the time (in seconds) after which clamd should timeout if a client doesn't provide any initial command after connecting.  The default is set to 30 to avoid timeouts with TCP sockets  when  processing large messages.  If using a Unix socket, the value can be changed to 5.  Note: the timeout for subsequents commands, and/or data chunks is specified by ReadTimeout. Default: 30|";
            base = base + "This option specifies how long to wait (in milliseconds) if the send buffer is full.  Keep this value low to prevent clamd hanging. Default: 500|";
            base = base + "Maximum number of queued items (including those being processed by MaxThreads threads).  It is recommended to have this value at least twice MaxThreads if possible. WARNING: you shouldn't increase this too much to avoid running out of file descriptors, the following condition should hold: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE.  RLIMIT_NOFILE is the maximum number of open file descriptors (usually 1024), set by ulimit -n. Default: 100|";
            base = base + "This option specifies how long (in seconds) the process should wait for a new job. Default: 30|";
            base = base + "Don't scan files and directories matching REGEX. This directive can be used multiple times. Default: disabled|";
            base = base + "Maximum depth directories are scanned at. Default: 15|";
            base = base + "Follow directory symlinks. Default: no|";
            base = base + "Scan files and directories on other filesystems. Default: yes|";
            base = base + "Follow regular file symlinks. Default: no|";
            base = base + "This option specifies the time intervals (in seconds) in which clamd should perform a database check. Default: 600|";
            base = base + "Enable non-blocking (multi-threaded/concurrent) database reloads. This feature will temporarily load a second scanning engine while scanning continues using the first engine. Once loaded, the new engine  takes  over.  The old  engine  is removed as soon as all scans using the old engine have completed. This feature requires more RAM, so this option is provided in case users are willing to block scans during reload in exchange for lower RAM requirements. Default: yes|";
            base = base + "Execute a command when virus is found.  Use the following environment variables to identify the file and virus names: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME In the command string, '%v' will also  be  replaced  with  the  virus name.  Note: The '%f' filename format character has been disabled and will no longer be replaced with the file name, due to command injection security concerns.  Use the 'CLAVIRUSEVENT_FILENAME' environment variable instead.  For the same reason, you should NOT use the environment variables in the command directly, but should use it carefully from your executed script. Default: disabled|";
            base = base + "Stop daemon when libclamav reports out of memory condition. Default: no|";
            base = base + "Permit use of the ALLMATCHSCAN command. Default: yes|";
            base = base + "Don't fork into background. Default: no|";
            base = base + "Enable debug messages from libclamav. Default: no|";
            base = base + "Do not remove temporary files (for debugging purpose). Default: no GenerateMetadataJson BOOL Record metadata about the file being scanned.  Scan metadata is useful for file analysis purposes and for debugging scan behavior.  The JSON metadata will be printed after the scan is complete if Debug is enabled. A metadata.json file will be written to the scan temp directory if LeaveTemporaryFiles is enabled. Default: no|";
            base = base + "Run the daemon as a specified user (the process must be started by root). Default: disabled|";
            base = base + "With this option enabled ClamAV will load bytecode from the database. It is highly recommended you keep this option turned on, otherwise you may miss detections for many new viruses. Default: yes|";
            base = base + "Set bytecode security level. Possible values: TrustSigned - trust bytecode loaded from signed .c[lv]d files and insert runtime safety checks for bytecode loaded from other sources, Paranoid - don't trust any bytecode, insert runtime checks for all. Recommended: TrustSigned, because bytecode in .cvd files already has these checks. (TrustSigned, Paranoid) Default: TrustSigned|";
            base = base + "Set bytecode timeout in milliseconds. Default: 10000|";
            base = base + "Allow loading bytecode from outside digitally signed .c[lv]d files.  **Caution**: You should NEVER run bytecode signatures from untrusted sources.  Doing so may result in arbitrary code execution. Default: no|";
            base = base + "Set bytecode execution mode. Possible values: Auto - automatically choose JIT if possible, fallback to interpreter ForceJIT - always choose JIT, fail if not possible ForceInterpreter - always choose interpreter Test - run with both JIT and interpreter and compare results. Make all failures fatal. Default: Auto|";
            base = base + "Detect Possibly Unwanted Applications. Default: no|";
            base = base + "Exclude a specific PUA category. This directive can be used multiple times. See https://docs.clamav.net/faq/faq-pua.html for the complete list of PUA categories. Default: disabled|";
            base = base + "Only include a specific PUA category. This directive can be used multiple times. See https://docs.clamav.net/faq/faq-pua.html for the complete list of PUA categories. Default: disabled|";
            base = base + "In some cases (eg. complex malware, exploits in graphic files, and others), ClamAV uses special algorithms to provide accurate detection. This option controls the algorithmic detection. Default: yes|";
            base = base + "Allow  heuristic  match  to  take  precedence. When enabled, if a heuristic scan (such as phishingScan) detects a possible virus/phishing it will stop scanning immediately. Recommended, saves CPU scan-time. When disabled, virus/phishing detected by heuristic scans will be reported only at the end of a scan. If an archive contains both a heuristically detected virus/phishing, and a real malware, the real malware will be reported. Keep  this disabled  if  you intend to handle \"*.Heuristics.*\" viruses  differently from \"real\" malware. If a non-heuristically-detected virus (signature-based) is found first, the scan is interrupted immediately, regardless of this config option. Default: no|";
            base = base + "PE stands for Portable Executable - it's an executable file format used in all 32 and 64-bit versions of Windows operating systems. This option allows ClamAV to perform a deeper analysis of executable files and it's  also required for decompression of popular executable packers such as UPX. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "Executable and Linking Format is a standard format for UN*X executables. This option allows you to control the scanning of ELF files. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "Enable scanning of mail files. If you turn off this option, the original files will still be scanned, but without parsing individual messages/attachments. Default: yes|";
            base = base + "Scan RFC1341 messages split over many emails. You will need to periodically clean up $TemporaryDirectory/clamav-partial directory. WARNING: This option may open your system to a DoS attack. Never use it on loaded servers. Default: no|";
            base = base + "Enable email signature-based phishing detection. Default: yes|";
            base = base + "Enable URL signature-based phishing detection (Heuristics.Phishing.Email.*) Default: yes|";
            base = base + "Enable the DLP module. Default: no|";
            base = base + "This option sets the lowest number of Credit Card numbers found in a file to generate a detect. Default: 3|";
            base = base + "With this option enabled the DLP module will search for valid Credit Card0umbers only. Debit and Private Label cards will not be searched. Default: no|";
            base = base + "This option sets the lowest number of Social Security Numbers found in a file to generate a detect. Default: 3|";
            base = base + "With this option enabled the DLP module will search for valid SSNs formatted as xxx-yy-zzzz. Default: yes|";
            base = base + "With this option enabled the DLP module will search for valid SSNs formatted as xxxyyzzzz. Default: no|";
            base = base + "Perform HTML/JavaScript/ScriptEncoder normalisation and decryption. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "This option enables scanning of OLE2 files, such as Microsoft Office documents and .msi files. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "This option enables scanning within PDF files. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "This option enables scanning within SWF files. If you turn off this option, the original files will still be scanned, but without decoding and additional processing. Default: yes|";
            base = base + "This option enables scanning xml-based document files supported by libclamav. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "This option enables scanning HWP3 files. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "This option enables scanning OneNote files. If you turn off this option, the original files will still be scanned, but without additional processing. Default: yes|";
            base = base + "Scan within archives and compressed files. If you turn off this option, the original files will still be scanned, but without unpacking and additional processing. Default: yes|";
            base = base + "This option enables scanning of image (graphics). If you turn off this option, the original files will still be scanned, but without unpacking and additional processing. Default: yes|";
            base = base + "This option enables detection by calculating a fuzzy hash of image (graphics) files. Signatures using image fuzzy hashes typically match files and documents by identifying images embedded or attached to those files. If you turn off this option, then some files may no longer be detected. Default: yes|";
            base = base + "Alert on broken executable files (PE & ELF). Default: no|";
            base = base + "Alert on broken graphics files (JPEG, TIFF, PNG, GIF). Default: no|";
            base = base + "Alert on encrypted archives and documents (encrypted .zip, .7zip, .rar, .pdf). Default: no|";
            base = base + "Alert on encrypted archives (encrypted .zip, .7zip, .rar). Default: no|";
            base = base + "Alert on encrypted documents (encrypted .pdf). Default: no|";
            base = base + "Alert on OLE2 files containing VBA macros (Heuristics.OLE2.ContainsMacros). Default: no|";
            base = base + "When AlertExceedsMax is set, files exceeding the MaxFileSize, MaxScanSize, or MaxRecursion limit will be flagged with the virus name starting with \"Heuristics.Limits.Exceeded\". Default: no|";
            base = base + "Alert on emails containing SSL mismatches in URLs (might lead to false positives!). Default: no|";
            base = base + "Alert on emails containing cloaked URLs (might lead to some false positives). Default: no|";
            base = base + "Alert on raw DMG image files containing partition intersections. Default: no|";
            base = base + "This option allows you to disable the caching feature of the engine. By default, the engine will store an MD5 in a cache of any files that are not flagged as virus or that hit limits checks. Warning: Disabling the cache will have a negative performance impact on large scans. Default: no|";
            base = base + "This option allows you to set the number of entries the cache can store. The value should be a square number or will be rounded up to the nearest square number. Default: 65536|";
            base = base + "This option causes memory or nested map scans to dump the content to disk. If you turn on this option, more data is written to disk and is available when the leave-temps option is enabled at the cost of more disk writes. Default: no|";
            base = base + "This  option  sets the maximum amount of time a scan may take to complete. The value is in milliseconds. The value of 0 disables the limit. WARNING: disabling this limit or setting it too high may result allow scanning of certain files to lock up the scanning process/threads resulting in a Denial of Service. Default: 120000|";
            base = base + "Sets the maximum amount of data to be scanned for each input file. Archives and other containers are recursively extracted and scanned up to this value. The size of an archive plus the sum of the sizes of all files within archive count toward the scan size. For example, a 1M uncompressed archive containing a single 1M inner file counts as 2M toward the max scan size. Warning: disabling this limit or setting it too high may result in severe damage to the system. Default: 400M|";
            base = base + "Files larger than this limit won't be scanned. Affects the input file itself as well as files contained inside it (when the input file is an archive, a document or some other kind of container).  Warning:  disabling  this limit or setting it too high may result in severe damage to the system. Technical design limitations prevent ClamAV from scanning files greater than 2 GB at this time. Default: 100M|";
            base = base + "Nested  archives are scanned recursively, e.g. if a Zip archive contains a RAR file, all files within it will also be scanned. This options specifies how deeply the process should be continued. Warning: setting this limit too high may result in severe damage to the system. Default: 17|";
            base = base + "Number of files to be scanned within an archive, a document, or any other kind of container. Warning: disabling this limit or setting it too high may result in severe damage to the system. Default: 10000|";
            base = base + "This option sets the maximum size of a file to check for embedded PE. Files larger than this value will skip the additional analysis step. Negative values are not allowed. Default: 40M|";
            base = base + "This option sets the maximum size of a HTML file to normalize. HTML files larger than this value will not be normalized or scanned. Negative values are not allowed. Default: 40M|";
            base = base + "This option sets the maximum size of a normalized HTML file to scan. HTML files larger than this value after normalization will not be scanned. Negative values are not allowed. Default: 8M|";
            base = base + "This option sets the maximum size of a script file to normalize. Script content larger than this value will not be normalized or scanned. Negative values are not allowed. Default: 20M|";
            base = base + "This option sets the maximum size of a ZIP file to reanalyze type recognition. ZIP files larger than this value will skip the step to potentially reanalyze as PE. Negative values are not allowed. WARNING: setting this limit too high may result in severe damage or impact performance. Default: 1M|";
            base = base + "This option sets the maximum number of partitions of a raw disk image to be scanned. Raw disk images with more partitions than this value will have up to the value partitions scanned. Negative values are not allowed. WARNING: setting this limit too high may result in severe damage or impact performance. Default: 50|";
            base = base + "This option sets the maximum number of icons within a PE to be scanned. PE files with more icons than this value will have up to the value number icons scanned. Negative values are not allowed. WARNING: setting this limit too high may result in severe damage or impact performance.|";
            base = base + "This option sets the maximum recursive calls to HWP3 parsing function. HWP3 files using more than this limit will be terminated and alert the user. Scans will be unable to scan any HWP3 attachments if the recursive limit is reached. Negative values are not allowed. WARNING: setting this limit too high may result in severe damage or impact performance.|";
            base = base + "This option sets the maximum calls to the PCRE match function during an instance of regex matching. Instances using more than this limit will be terminated and alert the user but the scan will continue. For more information on match_limit, see the PCRE documentation. Negative values are not allowed. WARNING: setting this limit too high may severely impact performance. Default: 10000|";
            base = base + "This option sets the maximum recursive calls to the PCRE match function during an instance of regex matching. Instances using more than this limit will be terminated and alert the user but the scan will continue. For more information on match_limit_recursion, see the PCRE documentation. Negative values are not allowed and values > PCREMatchLimit are superfluous. WARNING: setting this limit too high may severely impact performance. Default: 2000|";
            base = base + "This option sets the maximum filesize for which PCRE subsigs will be executed. Files exceeding this limit will not have PCRE subsigs executed unless a subsig is encompassed to a smaller buffer. Negative values are not allowed. Setting this value to zero disables the limit. WARNING: setting this limit too high or disabling it may severely impact performance. Default: 100M|";
            base = base + "This option specifies a directory (including all files and directories inside it), which should be scanned on access. This option can be used multiple times. Default: disabled|";
            base = base + "This option allows excluding directories from on-access scanning. It can be used multiple times. Default: disabled|";
            base = base + "With this option you can exclude the root UID (0). Processes run under root will be able to access all files without triggering scans or permission denied events. Note that if clamd cannot check the uid of the process that generated an on-access scan event (e.g., because OnAccessPrevention was not enabled, and the process already exited), clamd will perform a scan.   Thus,  setting OnAccessExcludeRootUID is not guaranteed to prevent every access by the root user from triggering a scan (unless OnAccessPrevention is enabled). Default: no|";
            base = base + "With this option you can exclude specific UIDs. Processes with these UIDs will be able to access all files without triggering scans or permission denied events. This option can be used multiple times (one per line). Note: using a value of 0 on any line will disable this option entirely. To exclude the root UID (0) please enable the OnAccessExcludeRootUID option. Also note that if clamd cannot check the uid of the process that generated an on-access scan event (e.g., because OnAccessPrevention was not enabled, and the process already exited), clamd will perform a scan.  Thus, set- ting OnAccessExcludeUID is not guaranteed to prevent every access by the specified uid from triggering a scan (unless OnAccessPrevention is enabled). Default: disabled|";
            base = base + "This option allows exclusions via user names when using the on-access scanning client. It can be used multiple times, and has the same potential race condition limitations of the OnAccessExcludeUID option. Default: disabled|";
            base = base + "Files larger than this value will not be scanned in on access. Default: 5M|";
            base = base + "Max number of scanning threads to allocate to the OnAccess thread pool at startup. These threads are the ones responsible for creating a connection with the daemon and kicking off scanning after an  event  has  been  pro- cessed. To prevent clamonacc from consuming all clamd's resources keep this lower than clamd's max threads. Default: 5|";
            base = base + "Max amount of time (in milliseconds) that the OnAccess client should spend for every connect, send, and receive attempt when communicating with clamd via curl. Default: 5000 (5 seconds)|";
            base = base + "Specifies a mount point (including all files and directories under it), which should be scanned on access. This option can be used multiple times. Default: disabled|";
            base = base + "Disables the dynamic directory determination system which allows for recursively watching include paths. Default: no|";
            base = base + "Enables fanotify blocking when malicious files are found. Default: disabled|";
            base = base + "Number of times the OnAccess client will retry a failed scan due to connection problems (or other issues). Default: 0|";
            base = base + "When  using  prevention,  if this option is turned on, any errors that occur during  scanning will result in the event attempt being denied. This could potentially lead to unwanted system behaviour with certain configurations, so the client defaults this to off and prefers allowing access events in case of scan or connection error. Default: no|";
            base = base + "Toggles extra scanning and notifications when a file or directory is created or moved. Requires the  DDD system to kick-off extra scans. Default: no|";
            base = base + "Disable authenticode certificate chain verification in PE files. Default: no|";
            base = base + "Store html URIs in metadata. URIs will be written to the metadata.json file in an array called 'URIs'.|";
            base = base + "Store pdf URIs in metadata. URIs will be written to the metadata.json file in an array called 'URIs'.|";
            base = base + "Store md5 and sha1 in addition to sha2-256 in metadata.|";
            base = base + "Print the file hash after each file scanned.|";
            base = base + "Print the file type after each file scanned.|";
            base = base + "Enforce FIPS-like limits on using hash algorithms for cryptographic purposes. Will disable MD5 & SHA1. FP sigs and will require '.sign' files to verify CVD authenticity.";

// translations de_DE
    QString base_de_DE = "Sei mitteilsam|";
            base_de_DE = base_de_DE + "Dateien innerhalb von Archiven anzeigen|";
            base_de_DE = base_de_DE + "Aktiviere libclamav's Debug Meldungen|";
            base_de_DE = base_de_DE + "Nur Fehlermeldungen ausgeben|";
            base_de_DE = base_de_DE + "Schreibe nach stdout anstatt nach stderr. Betrifft nicht 'debug' Meldungen.|";
            base_de_DE = base_de_DE + "Deaktiviere die Scanzusammenfassung am Ende des Scanvorgangs|";
            base_de_DE = base_de_DE + "Nur infizierte Dateien ausgeben|";
            base_de_DE = base_de_DE + "Überspringe die Ausgabe von OK Dateien|";
            base_de_DE = base_de_DE + "Klingel bei Viruserkennung|";
            base_de_DE = base_de_DE + "Temporäre Dateien nicht entfernen|";
            base_de_DE = base_de_DE + "Erstelle JSON Beschreibung von gescannten Dateien. JSON wird ausgegeben und auch-|";
            base_de_DE = base_de_DE + "Nur offizielle Signaturen laden|";
            base_de_DE = base_de_DE + "Scanne Unterverzeichnisse rekursiv|";
            base_de_DE = base_de_DE + "Fahre mit dem Scannen in der Datei fort wenn ein Treffer erziehlt wurde|";
            base_de_DE = base_de_DE + "Scanne Dateien und Verzeichnisse auf anderen Dateisystemen|";
            base_de_DE = base_de_DE + "Infizierte Dateien entfernen. Seien Sie vorsichtig!|";
            base_de_DE = base_de_DE + "Laden Sie unsignierten Bytecode. **Achtung**: Sie sollten NIEMALS Bytecode-Signaturen von nicht vertrauenswürdigen Quellen ausführen. Dies kann zur Ausführung willkürlichen Codes führen.|";
            base_de_DE = base_de_DE + "Erkenne vermutlich ungewollte Anwendungen|";
            base_de_DE = base_de_DE + "Erkenne strukturierte Daten (SSN, Credit Card)|";
            base_de_DE = base_de_DE + "Scanne Mail Dateien|";
            base_de_DE = base_de_DE + "Aktivieren Sie die Phishing-Erkennung mit E-Mail-Signaturen|";
            base_de_DE = base_de_DE + "Aktivieren der URL-Signatur und Phishing-Erkennung|";
            base_de_DE = base_de_DE + "Heuristische Warnungen|";
            base_de_DE = base_de_DE + "Beenden Sie die Suche, sobald eine heuristische Übereinstimmung gefunden wird.|";
            base_de_DE = base_de_DE + "Normalisieren Sie HTML-, Skript- und Textdateien. Verwenden Sie normalize=no für Yara-Kompatibilität|";
            base_de_DE = base_de_DE + "PE-Dateien scannen|";
            base_de_DE = base_de_DE + "ELF-Dateien scannen|";
            base_de_DE = base_de_DE + "OLE2-Container scannen|";
            base_de_DE = base_de_DE + "PDF-Dateien scannen|";
            base_de_DE = base_de_DE + "SWF-Dateien scannen|";
            base_de_DE = base_de_DE + "HTML-Dateien scannen|";
            base_de_DE = base_de_DE + "xml-basierte Dokumentdateien scannen|";
            base_de_DE = base_de_DE + "HWP3-Dateien scannen|";
            base_de_DE = base_de_DE + "Scannen von Archivdateien (unterstützt von libclamav)|";
            base_de_DE = base_de_DE + "Warnung vor defekten ausführbaren Dateien (PE & ELF)|";
            base_de_DE = base_de_DE + "Warnung bei defekten Grafikdateien (JPEG, TIFF, PNG, GIF)|";
            base_de_DE = base_de_DE + "Warnung vor verschlüsselten Archiven und Dokumenten|";
            base_de_DE = base_de_DE + "Warnung bei verschlüsselten Archiven|";
            base_de_DE = base_de_DE + "Warnung bei verschlüsselten Dokumenten|";
            base_de_DE = base_de_DE + "Warnung vor OLE2-Dateien, die VBA-Makros enthalten|";
            base_de_DE = base_de_DE + "Warnung bei Dateien, die die maximale Dateigröße, die maximale Scangröße oder die maximale Rekursionsgrenze überschreiten|";
            base_de_DE = base_de_DE + "Warnung bei E-Mails, die SSL-Fehlanpassungen in URLs enthalten|";
            base_de_DE = base_de_DE + "Warnung bei E-Mails mit getarnten URLs|";
            base_de_DE = base_de_DE + "Warnung bei rohen DMG-Image-Dateien, die Partitionsüberschneidungen enthalten|";
            base_de_DE = base_de_DE + "Deaktivieren der Authenticode-Zertifikatskettenprüfung in PE-Dateien|";
            base_de_DE = base_de_DE + "Dump der Authenticode-Zertifikatskette in PE-Dateien|";
            base_de_DE = base_de_DE + "Deaktivieren Sie die Zwischenspeicherung und die Cache-Prüfungen für Hash-Summen von gescannten Dateien.|";
// New with version 1.4.2 of clamav
            base_de_DE = base_de_DE + "Erstellen von temporären Dateien für verschachtelte Dateiscans, die sonst nur im Arbeitsspeicher gespeichert würden|";
            base_de_DE = base_de_DE + "Generieren Sie JSON-Metadaten für die gescannte(n) Datei(en). NUR für Test- und Entwicklungszwecke.|";
            base_de_DE = base_de_DE + "Gibt einen Fehlercode ungleich Null zurück, wenn die Virendatenbank veraltet ist.|";
            base_de_DE = base_de_DE + "OneNote-Dateien scannen|";
            base_de_DE = base_de_DE + "Scannen von Bilddateien (Grafiken)|";
            base_de_DE = base_de_DE + "Dateien durch Berechnung von Fuzzy-Hashes für Bilder (Grafiken) erkennen|";
            base_de_DE = base_de_DE + "Erstellen von temporären Dateien für verschachtelte Dateiscans, die sonst nur im Arbeitsspeicher gespeichert würden|";
// clamd.conf
            base_de_DE = base_de_DE + "Alle Berichte in einer Protokolldatei speichern. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Standardmäßig ist die Protokolldatei für das Schreiben gesperrt und nur ein einziger Daemon-Prozess kann in sie schreiben. Mit dieser Option wird die Sperre deaktiviert. Standard: no|";
            base_de_DE = base_de_DE + "Maximale Größe der Protokolldatei. Der Wert 0 schaltet die Begrenzung aus. Standard: 1048576|";
            base_de_DE = base_de_DE + "Protokollierungszeit für jede Meldung. Standard: no|";
            base_de_DE = base_de_DE + "Alle sauberen Dateien protokollieren. Nützlich bei der Fehlersuche, erhöht aber die Protokollgröße drastisch. Standard: no|";
            base_de_DE = base_de_DE + "Verwenden Sie den Systemlogger (kann mit LogFile zusammenarbeiten). Standard: nein|";
            base_de_DE = base_de_DE + "Art der Syslog-Meldungen. Bitte schauen Sie in 'man syslog' für die Namen der Einrichtungen nach. (LOG_LOCAL6, LOG_MAIL), Standard: LOG_LOCAL6|";
            base_de_DE = base_de_DE + "Ausführliche Protokollierung einschalten. Standard: no|";
            base_de_DE = base_de_DE + "Protokolldatei rotieren. Erfordert die Option LogFileMaxSize, die vor dieser Option gesetzt wurde. Standard: no|";
            base_de_DE = base_de_DE + "Zusätzliche Informationen über die infizierte Datei protokollieren, z. B. ihre Größe und ihren Hash, zusammen mit dem Virusnamen. Standard: no|";
            base_de_DE = base_de_DE + "Schreibt die PID des Daemons in die angegebene Datei. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Mit dieser Option können Sie das temporäre Standardverzeichnis ändern. Standard: /tmp|";
            base_de_DE = base_de_DE + "Mit dieser Option können Sie das Standardverzeichnis der Datenbank ändern. Wenn Sie diese Option aktivieren, vergewissern Sie sich bitte, dass es in clamd und freshclam auf dasselbe Verzeichnis zeigt. Standard: /usr/local/share/clamav|";
            base_de_DE = base_de_DE + "Lade nur die offiziellen Signaturen, die vom ClamAV-Projekt veröffentlicht wurden. Standard: no|";
            base_de_DE = base_de_DE + "Gibt einen Fehlercode ungleich Null zurück, wenn die Virendatenbank älter ist als die angegebene Anzahl von Tagen. Standard: -1|";
            base_de_DE = base_de_DE + "Pfad zu einem lokalen (Unix-)Socket, an dem der Daemon lauschen wird. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Setzt die Gruppenzugehörigkeit für den Unix-Socket. Standard: |";
            base_de_DE = base_de_DE + "Setzt die Berechtigungen für den Unix-Socket auf den angegebenen Modus. Standard: 660|";
            base_de_DE = base_de_DE + "Entferne verfallenen Socket nach unsauberem shutdown. Standard: yes|";
            base_de_DE = base_de_DE + "TCP-Portnummer, an der der Daemon lauschen wird. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Standardmäßig bindet sich clamd an INADDR_ANY. Mit dieser Option können Sie die TCP-Adresse einschränken und einen gewissen Schutz vor der Außenwelt bieten. Diese Option kann mehrfach angegeben werden, um auf mehreren IPs zu lauschen. IPv6 wird jetzt unterstützt. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Maximale Länge, auf die die Warteschlange der anstehenden Verbindungen anwachsen darf. Standard: 200|";
            base_de_DE = base_de_DE + "Schließt die STREAM-Sitzung, wenn das Datengrößenlimit überschritten wird. Der Wert sollte dem Limit Ihres MTAs für die maximale Größe des Anhangs entsprechen. Standard: 100M|";
            base_de_DE = base_de_DE + "Der STREAM-Befehl verwendet ein FTP-ähnliches Protokoll. Diese Option legt die untere Grenze für den Portbereich fest. Standard: 1024|";
            base_de_DE = base_de_DE + "Diese Option legt die obere Grenze für den Portbereich fest. Standard: 2048|";
            base_de_DE = base_de_DE + "Maximale Anzahl von Threads, die gleichzeitig laufen. Standard: 10|";
            base_de_DE = base_de_DE + "Diese Option gibt die Zeit (in Sekunden) an, nach der clamd einen Timeout durchführen soll, wenn ein Client keine Daten liefert. Standard: 120|";
            base_de_DE = base_de_DE + "Diese Option gibt die Zeit (in Sekunden) an, nach der clamd eine Zeitüberschreitung erleiden soll, wenn ein Client nach dem Herstellen der Verbindung keinen ersten Befehl übermittelt.  Der Standardwert ist auf 30 gesetzt, um Timeouts bei TCP-Sockets zu vermeiden, wenn große Nachrichten verarbeitet werden.  Wenn ein Unix-Socket verwendet wird, kann der Wert auf 5 geändert werden.  Hinweis: Der Timeout für nachfolgende Befehle und/oder Datenpakete wird durch ReadTimeout festgelegt. Standard: 30|";
            base_de_DE = base_de_DE + "Diese Option gibt an, wie lange (in Millisekunden) gewartet werden soll, wenn der Sendepuffer voll ist.  Halten Sie diesen Wert niedrig, um ein Aufhängen von clamd zu verhindern. Standard: 500|";
            base_de_DE = base_de_DE + "Maximale Anzahl von Elementen in der Warteschlange (einschließlich derjenigen, die von MaxThreads-Threads verarbeitet werden).  Es wird empfohlen, diesen Wert mindestens doppelt so hoch wie MaxThreads zu wählen, wenn möglich. WARNUNG: Sie sollten diesen Wert nicht zu sehr erhöhen, um zu vermeiden, dass Ihnen die Dateideskriptoren ausgehen; die folgende Bedingung sollte gelten: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE.  RLIMIT_NOFILE ist die maximale Anzahl offener Dateideskriptoren (normalerweise 1024), die durch ulimit -n festgelegt wird. Standard: 100|";
            base_de_DE = base_de_DE + "Diese Option gibt an, wie lange (in Sekunden) der Prozess auf einen neuen Auftrag warten soll. Standard: 30|";
            base_de_DE = base_de_DE + "Dateien und Verzeichnisse, die mit REGEX übereinstimmen, werden nicht gescannt. Diese Direktive kann mehrfach verwendet werden. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Maximum depth directories are scanned at. Default: 15|";
            base_de_DE = base_de_DE + "Verzeichnis-Symlinks folgen. Standard: no|";
            base_de_DE = base_de_DE + "Scanne Dateien und Verzeichnisse auf anderen Dateisystemen. Standard: yes|";
            base_de_DE = base_de_DE + "Regelmäßigen Dateisymlinks folgen. Standard: no|";
            base_de_DE = base_de_DE + "Diese Option gibt die Zeitintervalle (in Sekunden) an, in denen clamd eine Datenbankprüfung durchführen soll. Standard: 600|";
            base_de_DE = base_de_DE + "Aktiviere nicht-blockierende (multi-threaded/concurrent) Datenbank-Nachladungen. Mit dieser Funktion wird vorübergehend eine zweite Scan-Engine geladen, während die Überprüfung mit der ersten Engine fortgesetzt wird. Sobald sie geladen ist, übernimmt die neue Engine die Arbeit.  Die alte Engine wird entfernt, sobald alle Scans mit der alten Engine abgeschlossen sind. Diese Funktion benötigt mehr Arbeitsspeicher, daher wird diese Option angeboten, falls Benutzer bereit sind, Scans während des Neuladens zu blockieren und dafür weniger Arbeitsspeicher benötigen. Standard: ja|";
            base_de_DE = base_de_DE + "Führt einen Befehl aus, wenn ein Virus gefunden wird.  Verwenden Sie die folgenden Umgebungsvariablen, um die Datei- und Virusnamen zu identifizieren: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME In der Befehlszeichenfolge wird '%v' ebenfalls durch den Virusnamen ersetzt.  Hinweis: Das Formatierungszeichen \"%f\" für den Dateinamen wurde deaktiviert und wird aufgrund von Sicherheitsbedenken bezüglich der Befehlsinjektion nicht mehr durch den Dateinamen ersetzt.  Verwenden Sie stattdessen die Umgebungsvariable 'CLAVIRUSEVENT_FILENAME'.  Aus demselben Grund sollten Sie die Umgebungsvariablen NICHT direkt im Befehl verwenden, sondern sie vorsichtig in Ihrem ausgeführten Skript einsetzen. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Stoppen Sie den Daemon, wenn libclamav einen Speichermangel meldet. Standard: nein|";
            base_de_DE = base_de_DE + "Erlaube die Verwendung des ALLMATCHSCAN-Befehls. Standard: yes|";
            base_de_DE = base_de_DE + "Nicht in den Hintergrund verzweigen. Standard: no|";
            base_de_DE = base_de_DE + "Debug-Meldungen von libclamav aktivieren. Standard: no|";
            base_de_DE = base_de_DE + "Temporäre Dateien nicht entfernen (zu Debugging-Zwecken). Standardwert: no GenerateMetadataJson BOOL Aufzeichnung von Metadaten über die gescannte Datei.  Scan-Metadaten sind nützlich für die Analyse von Dateien und für die Fehlersuche im Scan-Verhalten.  Die JSON-Metadaten werden nach Abschluss des Scans gedruckt, wenn Debug aktiviert ist. Eine metadata.json-Datei wird in das temporäre Verzeichnis des Scans geschrieben, wenn LeaveTemporaryFiles aktiviert ist. Standard: no|";
            base_de_DE = base_de_DE + "Führen Sie den Daemon als angegebener Benutzer aus (der Prozess muss von root gestartet werden). Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Wenn diese Option aktiviert ist, lädt ClamAV den Bytecode aus der Datenbank. Es wird dringend empfohlen, diese Option eingeschaltet zu lassen, da Sie sonst möglicherweise viele neue Viren nicht erkennen. Standard: yes|";
            base_de_DE = base_de_DE + "Sicherheitsstufe für Bytecode festlegen. Mögliche Werte: TrustSigned - vertraut Bytecode, der aus signierten .c[lv]d-Dateien geladen wurde, und fügt Laufzeit-Sicherheitsprüfungen für Bytecode ein, der aus anderen Quellen geladen wurde, Paranoid - vertraut keinem Bytecode, fügt Laufzeitprüfungen für alle ein. Empfohlen: TrustSigned, da Bytecode in .cvd-Dateien bereits über diese Prüfungen verfügt. (TrustSigned, Paranoid) Standard: TrustSigned|";
            base_de_DE = base_de_DE + "Bytecode-Timeout in Millisekunden festlegen. Standard: 10000|";
            base_de_DE = base_de_DE + "Erlaubt das Laden von Bytecode von außerhalb digital signierter .c[lv]d-Dateien.  **Vorsicht**: Sie sollten NIEMALS Bytecode-Signaturen aus nicht vertrauenswürdigen Quellen ausführen.  Dies kann zur Ausführung von beliebigem Code führen. Standard: no|";
            base_de_DE = base_de_DE + "Bytecode-Ausführungsmodus festlegen. Mögliche Werte: Auto - wählt automatisch JIT, wenn möglich, Fallback auf Interpreter ForceJIT - wählt immer JIT, scheitert, wenn nicht möglich ForceInterpreter - wählt immer Interpreter Test - läuft sowohl mit JIT als auch mit Interpreter und vergleicht die Ergebnisse. Alle Fehlschläge sind fatal. Standard: Auto|";
            base_de_DE = base_de_DE + "Möglicherweise unerwünschte Anwendungen erkennen. Standard: no|";
            base_de_DE = base_de_DE + "Eine bestimmte PUA-Kategorie ausschließen. Diese Direktive kann mehrfach verwendet werden. Siehe https://docs.clamav.net/faq/faq-pua.html für die vollständige Liste der PUA-Kategorien. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Nur eine bestimmte PUA-Kategorie einschließen. Diese Direktive kann mehrfach verwendet werden. Siehe https://docs.clamav.net/faq/faq-pua.html für die vollständige Liste der PUA-Kategorien. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "In einigen Fällen (z. B. komplexe Malware, Exploits in Grafikdateien und andere) verwendet ClamAV spezielle Algorithmen, um eine genaue Erkennung zu gewährleisten. Diese Option steuert die algorithmische Erkennung. Standard: yes|";
            base_de_DE = base_de_DE + "Vorrang für heuristischen Abgleich zulassen. Wenn diese Option aktiviert ist, wird die Überprüfung sofort abgebrochen, wenn ein heuristischer Scan (z. B. phishingScan) einen möglichen Virus/Phishing entdeckt. Empfohlen, spart CPU-Scan-Zeit. Wenn diese Option deaktiviert ist, werden Viren/Phishing, die von heuristischen Scans entdeckt werden, erst am Ende eines Scans gemeldet. Wenn ein Archiv sowohl einen heuristisch erkannten Virus/Phishing als auch echte Malware enthält, wird die echte Malware gemeldet. Lassen Sie diese Option deaktiviert, wenn Sie beabsichtigen, \"*.Heuristik.*\"-Viren anders zu behandeln als \"echte\" Malware. Wenn ein nicht heuristisch erkannter Virus (auf der Grundlage von Signaturen) zuerst gefunden wird, wird die Überprüfung sofort unterbrochen, unabhängig von dieser Konfigurationsoption. Standard: no|";
            base_de_DE = base_de_DE + "PE steht für Portable Executable - es ist ein ausführbares Dateiformat, das in allen 32- und 64-Bit-Versionen von Windows-Betriebssystemen verwendet wird. Mit dieser Option kann ClamAV eine tiefere Analyse von ausführbaren Dateien durchführen und sie ist auch für die Dekomprimierung beliebter ausführbarer Packer wie UPX erforderlich. Wenn Sie diese Option deaktivieren, werden die Originaldateien weiterhin gescannt, jedoch ohne zusätzliche Verarbeitung. Standard: ja|";
            base_de_DE = base_de_DE + "Executable and Linking Format ist ein Standardformat für UN*X-Executables. Mit dieser Option können Sie das Scannen von ELF-Dateien steuern. Wenn Sie diese Option deaktivieren, werden die Originaldateien weiterhin gescannt, aber ohne zusätzliche Verarbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Aktiviere das Scannen von Mail-Dateien. Wenn Sie diese Option deaktivieren, werden die Originaldateien weiterhin gescannt, jedoch ohne die einzelnen Nachrichten/Anhänge zu parsen. Standard: yes|";
            base_de_DE = base_de_DE + "Scannen von RFC1341-Nachrichten, die auf viele E-Mails verteilt sind. Sie müssen das Verzeichnis $TemporaryDirectory/clamav-partial regelmäßig bereinigen. WARNUNG: Diese Option kann Ihr System für einen DoS-Angriff öffnen. Verwenden Sie sie niemals auf belasteten Servern. Standard: no|";
            base_de_DE = base_de_DE + "Aktiviere E-Mail-Signatur-basierte Phishing-Erkennung. Standard: yes|";
            base_de_DE = base_de_DE + "Aktiviere URL-Signatur-basierte Phishing-Erkennung (Heuristics.Phishing.Email.*) Standard: yes|";
            base_de_DE = base_de_DE + "Aktiviere das DLP Modul. Standard: no|";
            base_de_DE = base_de_DE + "Diese Option setzt die niedrigste Anzahl von Kreditkartennummern, die gefunden werden müssen um eine Detektion auszulösen. Standard: 3|";
            base_de_DE = base_de_DE + "Durch setzen dieser Option wird das DLP Modul nur nach gültigen Kreditkartennummern suchen. Debit und private Label Karten werden nicht gesucht. Standard: no|";
            base_de_DE = base_de_DE + "Diese Option setzt die niedrigste Anzahl von Sozialversicherungsnummern, die gefunden werden müssen um eine Detektion auszulösen. Standard: 3|";
            base_de_DE = base_de_DE + "Mit dieser Option sucht das DLP Modul nach gültigen SSNs im Format xxx-yy-zzzz. Standard: yes|";
            base_de_DE = base_de_DE + "Mit dieser Option sucht das DLP Modul nach gültigen SSNs im Format xxxyyzzzz. Standard: no|";
            base_de_DE = base_de_DE + "Führt eine HTML/JavaScript/ScriptEncoder Normalisierung und Entschlüsselung durch. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen von OLE2 Dateien, wie Microsoft Office Dokumente und .msi Dateien. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen innerhalb von PDF Dateien. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen innerhalb von SWF Dateien. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen von xml-basierten Dokumenten Dateien unterstützt von libclamav. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen von HWP3 Dateine. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen von OneNote Dateine. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Scannen innerhalb von Archiven und comprimierten Dateien. Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert das Scannen von Bildern (graphics). Wenn Sie die Option ausschalten, werden die original Datein trotzdem gescannt aber ohne weiter Bearbeitung. Standard: yes|";
            base_de_DE = base_de_DE + "Diese Option aktiviert die Erkennung durch die Erstellung eines \"Fuzzy Hash\" von Grafikdateien. Signaturen die \"Fuzzy Hashes\" verwenden identifizieren üblicherweise Dateien und Dokumente durch die Erkennung von eingebetteten oder angehangenen Bildern an diese Dateien. Wenn Sie diese Option deaktivieren, dann werden einige Dateien möglicherweise nicht länger erkannt. Standard: yes|";
            base_de_DE = base_de_DE + "Alarmiert bei defekten ausführbaren Dateien (PE & ELF). Standard: no|";
            base_de_DE = base_de_DE + "Alarmiert bei defekten  Grafik Dateien  (JPEG, TIFF, PNG, GIF). Voreinstelllung: no|";
            base_de_DE = base_de_DE + "Alarmiert bei verschlüsselten Archiven und Dokumenten (verschlüsselte .zip, .7zip, .rar, .pdf). Standard: no|";
            base_de_DE = base_de_DE + "Alarmiert bei verschlüsselten Archiven (verschlüsselte .zip, .7zip, .rar). Standard: no|";
            base_de_DE = base_de_DE + "Alarmiert bei verschlüsselten Documenten (verschlüsselte .pdf). Standard: no|";
            base_de_DE = base_de_DE + "Alarmiert bei OLE2 Dateien die VBA Makro beinhalten (Heuristics.OLE2.ContainsMacros). Standard: no|";
            base_de_DE = base_de_DE + "Wenn AlertExceedsMax gesetzt ist, Dateien die MaxFileSize, MaxScanSize, oder MaxRecursion Limits überschreiten werden mit einem Virusnamen markiert der mit \"Heuristics.Limits.Exceeded\" beginnt. Standard: no|";
            base_de_DE = base_de_DE + "Alarmiere bei emails die einen SSL mismatches in URLs beinhalten (kann zu false positives führen!). Standard: no|";
            base_de_DE = base_de_DE + "Alarmiere bei emails die cloaked URLs beinhalten (kann zu einigen false positives führen). Standard: no|";
            base_de_DE = base_de_DE + "Alarmiere bei raw DMG Grafikdatien die eine Partitionsüberschneidung beinhalten. Standard: no|";
            base_de_DE = base_de_DE + "Mit dieser Option können Sie die Caching-Funktion der Engine deaktivieren. Standardmäßig speichert die Engine einen MD5-Wert in einem Cache aller Dateien, die nicht als Viren gekennzeichnet sind oder die Grenzwertprüfungen durchlaufen haben. Warnung: Das Deaktivieren des Caches wirkt sich bei großen Scans negativ auf die Leistung aus. Standard: nein|";
            base_de_DE = base_de_DE + "Mit dieser Option können Sie die Anzahl der Einträge festlegen, die der Cache speichern kann. Der Wert muss eine Quadratzahl sein oder wird auf die nächste Quadratzahl aufgerundet. Standard: 65536|";
            base_de_DE = base_de_DE + "Diese Option bewirkt, dass Speicher- oder verschachtelte Map-Scans den Inhalt auf die Festplatte schreiben. Wenn Sie diese Option aktivieren, werden mehr Daten auf die Festplatte geschrieben und sind verfügbar, wenn die Option „Leave-Temps“ aktiviert ist. Dies geschieht jedoch auf Kosten von mehr Festplattenschreibvorgängen. Standard: nein|";
            base_de_DE = base_de_DE + "Mit dieser Option legen Sie die maximale Zeit fest, die ein Scan in Anspruch nehmen darf. Der Wert wird in Millisekunden angegeben. Der Wert 0 deaktiviert die Begrenzung. ACHTUNG: Wenn Sie diese Begrenzung deaktivieren oder zu hoch einstellen, kann dies dazu führen, dass bestimmte Dateien gescannt werden und der Scanvorgang/die Scanthreads blockiert werden, was zu einem Denial of Service führt. Standard: 120000|";
            base_de_DE = base_de_DE + "Legt die maximale Datenmenge fest, die für jede Eingabedatei gescannt werden soll. Archive und andere Container werden rekursiv extrahiert und bis zu diesem Wert gescannt. Die Größe eines Archivs plus die Summe der Größen aller Dateien im Archiv werden zur Scangröße gezählt. Beispielsweise zählt ein 1 MB großes unkomprimiertes Archiv, das eine einzelne 1 MB große innere Datei enthält, als 2 MB zur maximalen Scangröße. Warnung: Wenn Sie diese Grenze deaktivieren oder zu hoch einstellen, kann das System schwer beschädigt werden. Standard: 400 MB|";
            base_de_DE = base_de_DE + "Dateien, die größer als dieses Limit sind, werden nicht gescannt. Dies betrifft sowohl die Eingabedatei selbst als auch die darin enthaltenen Dateien (wenn die Eingabedatei ein Archiv, ein Dokument oder ein anderer Containertyp ist). Achtung: Wenn Sie dieses Limit deaktivieren oder zu hoch einstellen, kann dies zu schweren Systemschäden führen. Technische Designbeschränkungen verhindern derzeit, dass ClamAV Dateien scannt, die größer als 2 GB sind. Standard: 100 M|";
            base_de_DE = base_de_DE + "Verschachtelte Archive werden rekursiv gescannt. Wenn beispielsweise ein Zip-Archiv eine RAR-Datei enthält, werden auch alle darin enthaltenen Dateien gescannt. Diese Option gibt an, wie tief der Prozess fortgesetzt werden soll. Achtung: Wenn Sie diesen Grenzwert zu hoch einstellen, kann dies zu schweren Systemschäden führen. Standard: 17|";
            base_de_DE = base_de_DE + "Anzahl der zu scannenden Dateien in einem Archiv, einem Dokument oder einem anderen Containertyp. Achtung: Wenn Sie dieses Limit deaktivieren oder zu hoch einstellen, kann dies zu schweren Systemschäden führen. Standard: 10000|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Größe einer Datei fest, die auf eingebettetes PE geprüft werden soll. Bei Dateien, die größer als dieser Wert sind, wird der zusätzliche Analyseschritt übersprungen. Negative Werte sind nicht zulässig. Standard: 40M|";
            base_de_DE = base_de_DE + "Mit dieser Option legen Sie die maximale Größe einer zu normalisierenden HTML-Datei fest. HTML-Dateien, die größer als dieser Wert sind, werden nicht normalisiert oder gescannt. Negative Werte sind nicht zulässig. Standard: 40M|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Größe einer normalisierten HTML-Datei fest, die gescannt werden soll. HTML-Dateien, die nach der Normalisierung größer als dieser Wert sind, werden nicht gescannt. Negative Werte sind nicht zulässig. Standard: 8M|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Größe einer zu normalisierenden Skriptdatei fest. Skriptinhalte, die größer als dieser Wert sind, werden nicht normalisiert oder gescannt. Negative Werte sind nicht zulässig. Standard: 20 MB|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Größe einer ZIP-Datei fest, um die Typerkennung erneut zu analysieren. ZIP-Dateien, die größer als dieser Wert sind, überspringen den Schritt zur potenziellen erneuten Analyse als PE. Negative Werte sind nicht zulässig. ACHTUNG: Wenn Sie diesen Grenzwert zu hoch einstellen, kann dies zu schweren Schäden oder Leistungseinbußen führen. Standard: 1 MB|";
            base_de_DE = base_de_DE + "Mit dieser Option legen Sie die maximale Anzahl der zu scannenden Partitionen eines Raw-Disk-Image fest. Bei Raw-Disk-Images mit mehr Partitionen als diesem Wert werden bis zu diesem Wert Partitionen gescannt. Negative Werte sind nicht zulässig. ACHTUNG: Wenn Sie diesen Grenzwert zu hoch einstellen, kann dies zu schweren Schäden oder Leistungseinbußen führen. Standard: 50|";
            base_de_DE = base_de_DE + "Mit dieser Option legen Sie die maximale Anzahl von Symbolen fest, die innerhalb eines PE gescannt werden sollen. Bei PE-Dateien mit mehr Symbolen als diesem Wert werden maximal so viele Symbole gescannt. Negative Werte sind nicht zulässig. ACHTUNG: Wenn Sie diesen Grenzwert zu hoch einstellen, kann dies zu schweren Schäden oder Leistungseinbußen führen.|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Anzahl rekursiver Aufrufe der HWP3-Analysefunktion fest. HWP3-Dateien, die mehr als diese Grenze verwenden, werden beendet und der Benutzer wird benachrichtigt. Scans können keine HWP3-Anhänge scannen, wenn die rekursive Grenze erreicht ist. Negative Werte sind nicht zulässig. ACHTUNG: Wenn Sie diese Grenze zu hoch einstellen, kann dies zu schweren Schäden oder Leistungseinbußen führen.|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Anzahl von Aufrufen der PCRE-Match-Funktion während einer Instanz von Regex-Matching fest. Instanzen, die mehr als dieses Limit verwenden, werden beendet und der Benutzer wird benachrichtigt, aber der Scan wird fortgesetzt. Weitere Informationen zu match_limit finden Sie in der PCRE-Dokumentation. Negative Werte sind nicht zulässig. ACHTUNG: Wenn Sie dieses Limit zu hoch einstellen, kann dies die Leistung erheblich beeinträchtigen. Standard: 10000|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Anzahl rekursiver Aufrufe der PCRE-Match-Funktion während einer Instanz von Regex-Matching fest. Instanzen, die mehr als dieses Limit verwenden, werden beendet und der Benutzer wird benachrichtigt, aber der Scan wird fortgesetzt. Weitere Informationen zu match_limit_recursion finden Sie in der PCRE-Dokumentation. Negative Werte sind nicht zulässig und Werte > PCREMatchLimit sind überflüssig. WARNUNG: Wenn Sie dieses Limit zu hoch einstellen, kann dies die Leistung erheblich beeinträchtigen. Standard: 2000|";
            base_de_DE = base_de_DE + "Diese Option legt die maximale Dateigröße fest, für die PCRE-Subsigs ausgeführt werden. Für Dateien, die diese Grenze überschreiten, werden keine PCRE-Subsigs ausgeführt, es sei denn, eine Subsig wird in einen kleineren Puffer eingeschlossen. Negative Werte sind nicht zulässig. Wenn Sie diesen Wert auf Null setzen, wird die Grenze deaktiviert. WARNUNG: Wenn Sie diese Grenze zu hoch setzen oder deaktivieren, kann dies die Leistung erheblich beeinträchtigen. Standard: 100 M|";
            base_de_DE = base_de_DE + "Mit dieser Option wird ein Verzeichnis (einschließlich aller darin enthaltenen Dateien und Verzeichnisse) angegeben, das beim Zugriff gescannt werden soll. Diese Option kann mehrfach verwendet werden. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Mit dieser Option können Verzeichnisse vom On-Access-Scan ausgeschlossen werden. Sie kann mehrfach verwendet werden. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Mit dieser Option können Sie die Root-UID (0) ausschließen. Unter Root ausgeführte Prozesse können auf alle Dateien zugreifen, ohne Scans oder Zugriffsverweigerungsereignisse auszulösen. Beachten Sie, dass clamd einen Scan ausführt, wenn clamd die UID des Prozesses, der ein On-Access-Scan-Ereignis generiert hat, nicht überprüfen kann (z. B. weil OnAccessPrevention nicht aktiviert war und der Prozess bereits beendet wurde). Daher ist die Einstellung von OnAccessExcludeRootUID nicht garantiert, dass jeder Zugriff des Root-Benutzers einen Scan auslöst (es sei denn, OnAccessPrevention ist aktiviert). Standard: nein|";
            base_de_DE = base_de_DE + "Mit dieser Option können Sie bestimmte UIDs ausschließen. Prozesse mit diesen UIDs können auf alle Dateien zugreifen, ohne Scans oder Zugriffsverweigerungsereignisse auszulösen. Diese Option kann mehrfach verwendet werden (einmal pro Zeile). Hinweis: Wenn Sie in einer beliebigen Zeile den Wert 0 verwenden, wird diese Option vollständig deaktiviert. Um die Stamm-UID (0) auszuschließen, aktivieren Sie bitte die Option OnAccessExcludeRootUID. Beachten Sie auch, dass clamd einen Scan durchführt, wenn clamd die UID des Prozesses, der ein On-Access-Scan-Ereignis generiert hat, nicht überprüfen kann (z. B. weil OnAccessPrevention nicht aktiviert war und der Prozess bereits beendet wurde). Daher ist durch das Setzen von OnAccessExcludeUID nicht garantiert, dass jeder Zugriff durch die angegebene UID einen Scan auslöst (es sei denn, OnAccessPrevention ist aktiviert). Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Diese Option ermöglicht Ausschlüsse über Benutzernamen bei Verwendung des On-Access-Scan-Clients. Sie kann mehrfach verwendet werden und hat dieselben potenziellen Race-Condition-Einschränkungen wie die Option OnAccessExcludeUID. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Dateien, die größer als dieser Wert sind, werden beim Zugriff nicht gescannt. Standard: 5M|";
            base_de_DE = base_de_DE + "Maximale Anzahl von Scan-Threads, die beim Start dem OnAccess-Threadpool zugewiesen werden. Diese Threads sind dafür verantwortlich, eine Verbindung mit dem Daemon herzustellen und den Scanvorgang nach der Verarbeitung eines Ereignisses zu starten. Um zu verhindern, dass clamonacc alle Ressourcen von clamd verbraucht, halten Sie diesen Wert niedriger als die maximale Anzahl von Threads von clamd. Standard: 5|";
            base_de_DE = base_de_DE + "Maximale Zeit (in Millisekunden), die der OnAccess-Client für jeden Verbindungs-, Sende- und Empfangsversuch bei der Kommunikation mit clamd über curl aufwenden soll. Standard: 5000 (5 Sekunden)|";
            base_de_DE = base_de_DE + "Gibt einen Mount-Punkt (einschließlich aller Dateien und Verzeichnisse darunter) an, der beim Zugriff gescannt werden soll. Diese Option kann mehrfach verwendet werden. Standard: deaktiviert|";
            base_de_DE = base_de_DE + "Deaktiviert das dynamische Verzeichnisbestimmungssystem, das eine rekursive Überwachung von Include-Pfaden ermöglicht. Standard: nein|";
            base_de_DE = base_de_DE + "Aktiviert die Blockierung von Fanotify, wenn schädliche Dateien gefunden werden. Standardmäßig deaktiviert|";
            base_de_DE = base_de_DE + "Anzahl der Wiederholungsversuche des OnAccess-Clients bei einem fehlgeschlagenen Scan aufgrund von Verbindungsproblemen (oder anderen Problemen). Standard: 0|";
            base_de_DE = base_de_DE + "Wenn diese Option bei Verwendung der Prävention aktiviert ist, führen alle während des Scannens auftretenden Fehler dazu, dass der Ereignisversuch abgelehnt wird. Dies könnte bei bestimmten Konfigurationen möglicherweise zu unerwünschtem Systemverhalten führen, daher deaktiviert der Client diese Option standardmäßig und lässt im Falle eines Scan- oder Verbindungsfehlers lieber Zugriffsereignisse zu. Standard: nein|";
            base_de_DE = base_de_DE + "Schaltet zusätzliche Scans und Benachrichtigungen um, wenn eine Datei oder ein Verzeichnis erstellt oder verschoben wird. Erfordert, dass das DDD-System zusätzliche Scans startet. Standard: nein|";
            base_de_DE = base_de_DE + "Deaktiviert die Überprüfung der Authenticode-Zertifikatkette in PE-Dateien. Standard: nein|";
            base_de_DE = base_de_DE + "Speichern Sie HTML-URIs in Metadaten. URIs werden in die Datei metadata.json in einem Array namens „URIs“ geschrieben.|";
            base_de_DE = base_de_DE + "Speichern Sie PDF-URIs in Metadaten. URIs werden in einem Array namens „URIs“ in die Datei metadata.json geschrieben.|";
            base_de_DE = base_de_DE + "Speichern Sie MD5 und SHA1 zusätzlich zu SHA2-256 in Metadaten.|";
            base_de_DE = base_de_DE + "Ausgabe des Datei-Hash nach jeder gescannten Datei.|";
            base_de_DE = base_de_DE + "Ausgabe des Datei-Typ nach jeder gescannten Datei.|";
            base_de_DE = base_de_DE + "Setzen Sie FIPS-ähnliche Beschränkungen für die Verwendung von Hash-Algorithmen für kryptografische Zwecke durch. Deaktiviert MD5 und SHA1. PHP signiert und benötigt „.sign“-Dateien, um die CVD-Authentizität zu überprüfen.";

// translations pt_PT and all countries with portugese language
    QString base_pt_PT = "Ser detalhista|";
            base_pt_PT = base_pt_PT + "Mostrar nomes de ficheiros nos arquivos digitalizados|";
            base_pt_PT = base_pt_PT + "Ativar as mensagens de depuração da libclamav|";
            base_pt_PT = base_pt_PT + "Apenas mensagens de erro|";
            base_pt_PT = base_pt_PT + "Escreve para stdout em vez de stderr. Não afecta as mensagens de 'debug'.|";
            base_pt_PT = base_pt_PT + "Desativar o resumo no final da verificação|";
            base_pt_PT = base_pt_PT + "Imprimir apenas ficheiros infectados|";
            base_pt_PT = base_pt_PT + "Saltar a impressão de ficheiros OK|";
            base_pt_PT = base_pt_PT + "Sinal sonoro na deteção de vírus|";
            base_pt_PT = base_pt_PT + "Não remover ficheiros temporários|";
            base_pt_PT = base_pt_PT + "Gera uma descrição JSON do(s) ficheiro(s) digitalizado(s). O JSON será impresso e também...|";
            base_pt_PT = base_pt_PT + "Carregar apenas assinaturas oficiais|";
            base_pt_PT = base_pt_PT + "Pesquisar subdirectórios recursivamente|";
            base_pt_PT = base_pt_PT + "Continuar a procurar no ficheiro depois de encontrar uma correspondência|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros e diretórios noutros sistemas de ficheiros|";
            base_pt_PT = base_pt_PT + "Remover ficheiros infectados. Cuidado!|";
            base_pt_PT = base_pt_PT + "Carregar bytecode não assinado. **Caution**: You should NEVER run bytecode signatures from untrusted sources. Fazer isso pode resultar na execução arbitrária de código.|";
            base_pt_PT = base_pt_PT + "Detetar aplicações possivelmente indesejadas|";
            base_pt_PT = base_pt_PT + "Detetar dados estruturados (SSN, cartão de crédito)|";
            base_pt_PT = base_pt_PT + "Digitalizar ficheiros de correio|";
            base_pt_PT = base_pt_PT + "Ativar a deteção de phishing baseada em assinaturas de correio eletrónico|";
            base_pt_PT = base_pt_PT + "Ativar a deteção de phishing baseada em assinaturas de URL|";
            base_pt_PT = base_pt_PT + "Alertas heurísticos|";
            base_pt_PT = base_pt_PT + "Parar a pesquisa assim que for encontrada uma correspondência heurística|";
            base_pt_PT = base_pt_PT + "Normaliza ficheiros html, script e texto. Use normalize=no para compatibilidade com yara|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros PE|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros ELF|";
            base_pt_PT = base_pt_PT + "Verificar contentores OLE2|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros PDF|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros SWF|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros HTML|";
            base_pt_PT = base_pt_PT + "Digitalizar ficheiros de documentos baseados em xml|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros HWP3|";
            base_pt_PT = base_pt_PT + "Analisar ficheiros de arquivo (suportado pela libclamav)|";
            base_pt_PT = base_pt_PT + "Alerta sobre ficheiros executáveis danificados (PE & ELF)|";
            base_pt_PT = base_pt_PT + "Alerta sobre ficheiros gráficos danificados (JPEG, TIFF, PNG, GIF)|";
            base_pt_PT = base_pt_PT + "Alerta sobre arquivos e documentos encriptados|";
            base_pt_PT = base_pt_PT + "Alerta sobre arquivos encriptados|";
            base_pt_PT = base_pt_PT + "Alerta sobre documentos encriptados|";
            base_pt_PT = base_pt_PT + "Alerta sobre ficheiros OLE2 que contêm macros VBA|";
            base_pt_PT = base_pt_PT + "Alerta sobre ficheiros que excedem o tamanho máximo do ficheiro, o tamanho máximo da pesquisa ou o limite máximo de recursão|";
            base_pt_PT = base_pt_PT + "Alerta sobre mensagens de correio eletrónico com incompatibilidades SSL nos URLs|";
            base_pt_PT = base_pt_PT + "Alerta sobre mensagens de correio eletrónico que contenham URLs camuflados|";
            base_pt_PT = base_pt_PT + "Alerta sobre ficheiros de imagem DMG em bruto que contêm intersecções de partições|";
            base_pt_PT = base_pt_PT + "Desativar a verificação da cadeia de certificados authenticode nos ficheiros PE|";
            base_pt_PT = base_pt_PT + "Despejar a cadeia de certificados authenticode nos ficheiros PE|";
            base_pt_PT = base_pt_PT + "Desativar o armazenamento em cache e as verificações de cache para somas de hash de ficheiros digitalizados.|";
// new with version 1.4.2 of clamav
            base_pt_PT = base_pt_PT + "Criar ficheiros temporários para análises de ficheiros aninhados que, de outra forma, seriam apenas na memória|";
            base_pt_PT = base_pt_PT + "Gerar metadados JSON para o(s) ficheiro(s) digitalizado(s). APENAS para utilização em testes e desenvolvimento.|";
            base_pt_PT = base_pt_PT + "Retorna com um código de erro diferente de zero se a base de dados de vírus estiver desactualizada.|";
            base_pt_PT = base_pt_PT + "Digitalizar ficheiros OneNote|";
            base_pt_PT = base_pt_PT + "Digitalizar ficheiros de imagem (gráficos)|";
            base_pt_PT = base_pt_PT + "Detetar ficheiros através do cálculo de hashes difusos de imagens (gráficos)|";
            base_pt_PT = base_pt_PT + "Criar ficheiros temporários para análises de ficheiros aninhados que, de outra forma, seriam apenas na memória|";
// clamd.conf
            base_pt_PT = base_pt_PT + "Guardar todos os relatórios num ficheiro de registo. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Por defeito, o ficheiro de registo está bloqueado para escrita e apenas um único processo daemon pode escrever no mesmo. Esta opção desactiva o bloqueio. Padrão: no|";
            base_pt_PT = base_pt_PT + "Tamanho máximo do ficheiro de registo. Valor 0 desativa o limite. Predefinição: 1048576|";
            base_pt_PT = base_pt_PT + "Tempo de registo de cada mensagem. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Registar todos os ficheiros limpos. Útil na depuração, mas aumenta drasticamente o tamanho do registo. Padrão: não|";
            base_pt_PT = base_pt_PT + "Utilizar o registo do sistema (pode funcionar em conjunto com o LogFile). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Tipo de mensagens syslog. Consulte 'man syslog' para os nomes das facilidades. (LOG_LOCAL6, LOG_MAIL), Predefinição: LOG_LOCAL6|";
            base_pt_PT = base_pt_PT + "Ativar registo detalhado. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Rodar ficheiro de registo. Requer a opção LogFileMaxSize definida antes desta opção. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Registar informação adicional sobre o ficheiro infetado, como o seu tamanho e hash, juntamente com o nome do vírus. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Grava o pid do daemon no ficheiro especificado. Default: desativado|";
            base_pt_PT = base_pt_PT + "Esta opção permite alterar o diretório temporário padrão. Padrão: /tmp|";
            base_pt_PT = base_pt_PT + "Esta opção permite alterar o directório padrão da base de dados. Se a activar, certifique-se que aponta para o mesmo directório no clamd e no freshclam. Padrão: /usr/local/share/clamav|";
            base_pt_PT = base_pt_PT + "Carregar apenas as assinaturas oficiais publicadas pelo projeto ClamAV. Padrão: não|";
            base_pt_PT = base_pt_PT + "Retorna com um código de erro diferente de zero se a base de dados de vírus for mais antiga que o número de dias especificado. Predefinição: -1|";
            base_pt_PT = base_pt_PT + "Caminho para um socket local (Unix) no qual o daemon irá escutar. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Define a propriedade do grupo no socket unix. Padrão: |";
            base_pt_PT = base_pt_PT + "Define as permissões no socket unix para o modo especificado. Predefinição: 660|";
            base_pt_PT = base_pt_PT + "Remover socket obsoleto após encerramento impuro. Default: sim|";
            base_pt_PT = base_pt_PT + "Número da porta TCP na qual o daemon irá escutar. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Por defeito, o clamd liga-se a INADDR_ANY. Esta opção permite restringir o endereço TCP e fornecer algum grau de protecção do mundo externo. Esta opção pode ser especificada várias vezes para escutar em vários IPs. O IPv6 é agora suportado. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Comprimento máximo que a fila de ligações pendentes pode atingir. Predefinição: 200|";
            base_pt_PT = base_pt_PT + "Fechar a sessão STREAM quando o limite de tamanho de dados é excedido. O valor deve corresponder ao limite do seu MTA para o tamanho máximo de anexo. Padrão: 100M|";
            base_pt_PT = base_pt_PT + "O comando STREAM utiliza um protocolo semelhante ao FTP. Esta opção define o limite inferior para o intervalo de portas. Predefinição: 1024|";
            base_pt_PT = base_pt_PT + "Esta opção define o limite superior para o intervalo de portas. Predefinição: 2048|";
            base_pt_PT = base_pt_PT + "Número máximo de threads a correr ao mesmo tempo. Predefinição: 10|";
            base_pt_PT = base_pt_PT + "Esta opção especifica o tempo (em segundos) após o qual o clamd deve atingir o tempo limite se um cliente não fornecer quaisquer dados. Predefinição: 120|";
            base_pt_PT = base_pt_PT + "Esta opção especifica o tempo (em segundos) após o qual o clamd deve atingir o tempo limite se um cliente não fornecer nenhum comando inicial após a ligação. O padrão é definido como 30 para evitar tempos limite com sockets TCP ao processar mensagens grandes. Se utilizar um socket Unix, o valor pode ser alterado para 5. Nota: o tempo limite para comandos subsequentes e/ou blocos de dados é especificado por ReadTimeout. Padrão: 30|";
            base_pt_PT = base_pt_PT + "Esta opção especifica quanto tempo esperar (em milissegundos) se o buffer de envio estiver cheio. Mantenha este valor baixo para evitar o crash do clamd. Predefinição: 500|";
            base_pt_PT = base_pt_PT + "Número máximo de itens na fila (incluindo aqueles que estão a ser processados ​​pelos threads MaxThreads). É recomendado ter este valor pelo menos duas vezes MaxThreads, se possível. AVISO: não deve aumentar muito isto para evitar ficar sem descritores de ficheiros, a seguinte condição deve ser mantida: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE. RLIMIT_NOFILE é o número máximo de descritores de ficheiros abertos (geralmente 1024), definido por ulimit -n.|";
            base_pt_PT = base_pt_PT + "Esta opção especifica quanto tempo (em segundos) o processo deve esperar por um novo trabalho. Predefinição: 30|";
            base_pt_PT = base_pt_PT + "Não digitalizar ficheiros e directórios que correspondam a REGEX. Esta directiva pode ser utilizada várias vezes. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Profundidade máxima a que os diretórios são digitalizados. Predefinição: 15|";
            base_pt_PT = base_pt_PT + "Seguir links simbólicos do diretório. Padrão: não|";
            base_pt_PT = base_pt_PT + "Verificar ficheiros e diretórios noutros sistemas de ficheiros. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Seguir links simbólicos de ficheiros regulares. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Esta opção especifica os intervalos de tempo (em segundos) em que o clamd deve executar uma verificação da base de dados. Predefinição: 600|";
            base_pt_PT = base_pt_PT + "Ativar recarregamentos de base de dados não bloqueantes (multithread/simultâneos). Esta funcionalidade carregará temporariamente um segundo motor de scan enquanto o scan continua utilizando o primeiro motor. Uma vez carregado, o novo motor assume o controlo. O motor antigo é removido assim que todos os scans utilizando o motor antigo forem concluídos. Esta funcionalidade requer mais RAM, pelo que esta opção é fornecida no caso de os utilizadores estarem dispostos a fazer scans durante a recarga em troca de requisitos de RAM mais baixos. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Execute um comando quando o vírus for encontrado. Utilize as seguintes variáveis ​​de ambiente para identificar os nomes do ficheiro e do vírus: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME Na sequência de comando, '%v' também será substituído pelo nome do vírus. Nota: o caractere de formato de nome de ficheiro '%f' foi desativado e já não será substituído pelo nome do devido a preocupações com a segurança da injeção de comandos. Utilize a variável de ambiente 'CLAVIRUSEVENT_FILENAME' em vez disso.|";
            base_pt_PT = base_pt_PT + "Parar daemon quando libclamav reporta condição de falta de memória. Padrão: não|";
            base_pt_PT = base_pt_PT + "Permitir utilização do comando ALLMATCHSCAN. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Não bifurcar em segundo plano. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Ativar mensagens de depuração do libclamav. Padrão: não|";
            base_pt_PT = base_pt_PT + "Não remova ficheiros temporários (para fins de depuração). Padrão: não GenerateMetadataJson BOOL Regista os metadados sobre o ficheiro que está a ser digitalizado. Os metadados de digitalização são úteis para fins de análise de ficheiros e para depurar o comportamento da digitalização. Os metadados JSON serão impressos após a conclusão da digitalização se o Debug estiver ativado. Um ficheiro metadata. json será gravado no diretório temporário da digitalização se o LeaveTemporaryFiles estiver ativado. Padrão: |";
            base_pt_PT = base_pt_PT + "Executar o daemon como um utilizador especificado (o processo deve ser iniciado pelo root). Predefinição: desativado|";
            base_pt_PT = base_pt_PT + "Com esta opção activada, o ClamAV irá carregar o bytecode da base de dados. É altamente recomendável que mantenha esta opção activada, caso contrário poderá perder detecções de muitos vírus novos. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Define o nível de segurança do bytecode. Valores possíveis: TrustSigned - confia no bytecode carregado de ficheiros .c[lv]d assinados e insere verificações de segurança em tempo de execução para o bytecode carregado de outras fontes, Paranoid - não confia em nenhum bytecode, insere verificações em tempo de execução para todos. Recomendado: TrustSigned, porque o bytecode nos ficheiros .cvd já tem estas verificações. Paranoid) Padrão: TrustSigned|";
            base_pt_PT = base_pt_PT + "Define o tempo limite do bytecode em milissegundos. Predefinição: 10000|";
            base_pt_PT = base_pt_PT + "Permitir o carregamento de bytecode de ficheiros . c[lv]d assinados digitalmente a partir do exterior. **Cuidado**: NUNCA deve executar assinaturas de bytecode de fontes não fidedignas. Isto pode resultar na execução de código arbitrário. Padrão: não|";
            base_pt_PT = base_pt_PT + "Define o modo de execução do bytecode. Valores possíveis: Automático - escolhe automaticamente JIT se possível, retorna ao interpretador ForceJIT - escolhe sempre JIT, falha se não for possível ForceInterpreter - escolhe sempre interpretador Teste - executa com JIT e interpretador e compara os resultados. Torna todas as falhas fatais. Predefinição: Automático|";
            base_pt_PT = base_pt_PT + "Detetar aplicações possivelmente indesejadas. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Apaga uma categoria PUA específica. Esta directiva pode ser utilizada várias vezes. Consulte https://docs.clamav.net/faq/faq-pua.html para a lista completa de categorias PUA. Predefinição: desactivado|";
            base_pt_PT = base_pt_PT + "Incluir apenas uma categoria PUA específica. Esta diretiva pode ser utilizada várias vezes. Consulte https://docs.clamav.net/faq/faq-pua.html para obter a lista completa de categorias PUA. Predefinição: desativado|";
            base_pt_PT = base_pt_PT + "Em alguns casos (por exemplo, malware complexo, exploits em ficheiros gráficos e outros), o ClamAV utiliza algoritmos especiais para fornecer uma deteção precisa. Esta opção controla a deteção algorítmica. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Permitir que a correspondência heurística tenha precedência. Quando ativado, se uma verificação heurística (como phishingScan) detetar um possível vírus/phishing, interromperá a verificação imediatamente. Recomendado, poupa tempo de verificação da CPU. Quando desativado, os vírus/phishing detetados por verificações heurísticas só serão reportados no final de uma verificação. Se um ficheiro contiver um vírus/phishing detetado heuristicamente e um malware real, o malware real será reportado. Mantenha ativado se pretender lidar com vírus \"*. Heuristics. *\" de forma diferente do malware \"real\". Se for encontrado primeiro um vírus não detetado heuristicamente (baseado em assinaturas), a verificação será interrompida imediatamente, independentemente desta opção de configuração Padrão: não|";
            base_pt_PT = base_pt_PT + "PE significa Portable Executable - é um formato de ficheiro executável utilizado em todas as versões de 32 e 64 bits dos sistemas operativos Windows. Esta opção permite ao ClamAV executar uma análise mais profunda de ficheiros executáveis ​​e também é necessária para descomprimir compactadores executáveis ​​populares, como o UPX. Se desativar esta opção, os ficheiros originais ainda serão digitalizados, mas sem processamento adicional. Padrão: |";
            base_pt_PT = base_pt_PT + "Executable and Linking Format é um formato padrão para executáveis ​​UN*X. Esta opção permite controlar a varredura de ficheiros ELF. Se desativar esta opção, os ficheiros originais ainda serão varridos, mas sem processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Ativar verificação de ficheiros de e-mail. Se desativar esta opção, os ficheiros originais serão na mesma verificados, mas sem analisar mensagens/anexos individuais. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Verificar mensagens RFC1341 divididas em muitos e-mails. Terá de limpar periodicamente o directório $TemporaryDirectory/clamav-partial. AVISO: Esta opção pode abrir o seu sistema a um ataque DoS. Nunca utilize em servidores carregados. Predefinição: no|";
            base_pt_PT = base_pt_PT + "Ativar deteção de phishing baseada na assinatura de e-mail. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Ativar deteção de phishing baseada em assinatura de URL (Heuristics.Phishing.Email.*) Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Activar o módulo DLP. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Esta opção define o menor número de números de cartões de crédito encontrados num ficheiro para gerar uma deteção. Predefinição: 3|";
            base_pt_PT = base_pt_PT + "Com esta opção activada, o módulo DLP apenas irá pesquisar números de cartões de crédito válidos. Os cartões de débito e Private Label não serão pesquisados. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Esta opção define o menor número de números de segurança social encontrados num ficheiro para gerar uma deteção. Predefinição: 3|";
            base_pt_PT = base_pt_PT + "Com esta opção ativada, o módulo DLP irá pesquisar SSNs válidos formatados como xxx-yy-zzzz. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Com esta opção ativada, o módulo DLP irá pesquisar SSNs válidos formatados como xxxyyzzzz. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Executa a normalização e desencriptação de HTML/JavaScript/ScriptEncoder. Se desativar esta opção, os ficheiros originais serão ainda digitalizados, mas sem processamento adicional. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Esta opção ativa a verificação de ficheiros OLE2, como documentos do Microsoft Office e ficheiros . msi. Se desativar esta opção, os ficheiros originais serão ainda verificados, mas sem processamento adicional. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Esta opção activa a digitalização dentro de ficheiros PDF. Se desactivar esta opção, os ficheiros originais serão ainda digitalizados, mas sem processamento adicional. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Esta opção activa a digitalização dentro de ficheiros SWF. Se desactivar esta opção, os ficheiros originais serão na mesma varridos, mas sem descodificação e processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Esta opção permite a verificação de ficheiros de documentos baseados em xml suportados pelo libclamav. Se desativar esta opção, os ficheiros originais serão ainda varridos, mas sem processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Esta opção permite a verificação de ficheiros HWP3. Se desativar esta opção, os ficheiros originais serão ainda varridos, mas sem processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Esta opção ativa a verificação de ficheiros do OneNote. Se desativar esta opção, os ficheiros originais ainda serão verificados, mas sem processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Verificar dentro de ficheiros comprimidos e comprimidos. Se desativar esta opção, os ficheiros originais ainda serão verificados, mas sem descompressão e processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Esta opção activa a digitalização de imagens (gráficos). Se desactivar esta opção, os ficheiros originais serão na mesma digitalizados, mas sem descompressão e processamento adicional. Padrão: sim|";
            base_pt_PT = base_pt_PT + "Esta opção permite a deteção calculando um hash difuso de ficheiros de imagem (gráficos). As assinaturas que utilizam hashes difusos de imagem correspondem frequentemente a ficheiros e documentos que identificam imagens incorporadas ou anexadas a esses ficheiros. Se desativar esta opção, alguns ficheiros poderão deixar de ser detetados. Predefinição: sim|";
            base_pt_PT = base_pt_PT + "Alerta sobre ficheiros executáveis ​​quebrados (PE e ELF). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para ficheiros gráficos partidos (JPEG, TIFF, PNG, GIF). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para ficheiros e documentos encriptados (. zip, . 7zip, . rar, . pdf encriptados). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para ficheiros encriptados (. zip, . 7zip, . rar encriptados). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para documentos encriptados (. pdf encriptado). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para ficheiros OLE2 que contenham macros VBA (Heuristics.OLE2.ContainsMacros). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Quando AlertExceedsMax estiver definido, os ficheiros que excederem o limite MaxFileSize, MaxScanSize ou MaxRecursion serão sinalizados com o nome do vírus iniciado por \"Heuristics.Limits.Exceeded\". Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para e-mails que contenham incompatibilidades de SSL em URLs (pode levar a falsos positivos!). Padrão: não|";
            base_pt_PT = base_pt_PT + "Alerta para e-mails que contenham URLs ocultos (pode levar a alguns falsos positivos). Predefinição: não|";
            base_pt_PT = base_pt_PT + "Alerta para ficheiros de imagem DMG em bruto contendo intersecções de partições. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Esta opção permite desativar a funcionalidade de cache do motor. Por predefinição, o motor irá armazenar um MD5 numa cache de todos os ficheiros que não estejam sinalizados como vírus ou que atinjam verificações de limites. Aviso: A desativação da cache terá um impacto negativo no desempenho em varrimentos grandes. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Esta opção permite definir o número de entradas que a cache pode armazenar. O valor deve ser um número quadrado ou será arredondado para o número quadrado mais próximo. Predefinição: 65536|";
            base_pt_PT = base_pt_PT + "Esta opção faz com que os scans de memória ou de mapa aninhado despejem o conteúdo no disco. Se ativar esta opção, mais dados serão gravados no disco e estarão disponíveis quando a opção leave-temps estiver ativada, com o custo de mais gravações no disco. Predefinição: no|";
            base_pt_PT = base_pt_PT + "Esta opção define o tempo máximo que uma verificação pode demorar a ser concluída. O valor está em milissegundos. O valor 0 desativa o limite. AVISO: desativar este limite ou defini-lo demasiado alto pode resultar em permitir que a verificação de determinados ficheiros bloqueie o processo/threads de verificação, resultando numa Negação de Serviço. Predefinição: 120000|";
            base_pt_PT = base_pt_PT + "Define a quantidade máxima de dados a digitalizar para cada ficheiro de entrada. Os ficheiros e outros contentores são extraídos recursivamente e digitalizados até esse valor. O tamanho de um ficheiro mais a soma dos tamanhos de todos os ficheiros dentro do ficheiro contam para o tamanho do digitalizador. Por exemplo, um ficheiro descomprimido de 1 M contendo um único ficheiro interno de 1 M conta como 2 M para o tamanho máximo do digital fini-lo demasiado alto pode resultar em danos graves no sistema. Padrão: 400 M|";
            base_pt_PT = base_pt_PT + "Os ficheiros maiores do que este limite não serão digitalizados. Afeta o ficheiro de entrada em si, bem como os ficheiros nele contidos (quando o ficheiro de entrada é um ficheiro, um documento ou algum outro tipo de contentor). Aviso: desativar este limite ou defini-lo demasiado alto pode resultar em danos graves no sistema. As limitações técnicas de design impedem o ClamAV de digitalizar ficheiros maiores que 2 GB neste momento. Padrão: 100M|";
            base_pt_PT = base_pt_PT + "Os ficheiros aninhados são digitalizados recursivamente, por exemplo, se um ficheiro Zip contiver um ficheiro RAR, todos os ficheiros dentro do mesmo serão também digitalizados. Esta opção especifica o quão profundamente o processo deve ser continuado. Aviso: definir este limite demasiado elevado pode resultar em danos graves no sistema. Predefinição: 17|";
            base_pt_PT = base_pt_PT + "Número de ficheiros a digitalizar dentro de um ficheiro, um documento ou qualquer outro tipo de contentor. Aviso: desativar este limite ou defini-lo demasiado alto pode resultar em danos graves no sistema. Padrão: 10000|";
            base_pt_PT = base_pt_PT + "Esta opção define o tamanho máximo de um ficheiro para verificar o PE incorporado. Os ficheiros superiores a este valor irão saltar o passo de análise adicional. Não são permitidos valores negativos. Predefinição: 40M|";
            base_pt_PT = base_pt_PT + "Esta opção define o tamanho máximo de um ficheiro HTML para normalizar. Os ficheiros HTML maiores que este valor não serão normalizados nem digitalizados. Não são permitidos valores negativos. Predefinição: 40M|";
            base_pt_PT = base_pt_PT + "Esta opção define o tamanho máximo de um ficheiro HTML normalizado a ser digitalizado. Os ficheiros HTML superiores a este valor após a normalização não serão digitalizados. Não são permitidos valores negativos. Predefinição: 8M|";
            base_pt_PT = base_pt_PT + "Esta opção define o tamanho máximo de um ficheiro de script para normalizar. Conteúdo de script superior a este valor não será normalizado nem digitalizado. Não são permitidos valores negativos. Predefinição: 20M|";
            base_pt_PT = base_pt_PT + "Esta opção define o tamanho máximo de um ficheiro ZIP para reanalisar o reconhecimento de tipos. Os ficheiros ZIP superiores a este valor saltarão o passo para potencialmente reanalisar como PE. Não são permitidos valores negativos. AVISO: a definição deste limite demasiado elevado pode resultar em danos graves ou ter impacto no desempenho. Padrão: 1M|";
            base_pt_PT = base_pt_PT + "Esta opção define o número máximo de partições de uma imagem de disco em bruto a ser digitalizada. As imagens de disco em bruto com mais partições do que este valor terão até ao valor de partições digitalizadas. Não são permitidos valores negativos. AVISO: definir este limite demasiado elevado pode resultar em danos graves ou ter impacto no desempenho. Padrão: 50|";
            base_pt_PT = base_pt_PT + "Esta opção define o número máximo de ícones dentro de um PE a serem digitalizados. Os ficheiros PE com mais ícones do que este valor terão até o valor number de ícones digitalizados. Não são permitidos valores negativos. AVISO: definir este limite demasiado elevado pode resultar em danos graves ou ter impacto no desempenho.|";
            base_pt_PT = base_pt_PT + "Esta opção define o máximo de chamadas recursivas para a função de análise sintática HWP3. Os ficheiros HWP3 que utilizem mais do que este limite serão encerrados e alertarão o utilizador. As verificações não poderão verificar qualquer anexo HWP3 se o limite recursivo for atingido. Não são permitidos valores negativos. AVISO: a definição deste limite demasiado elevado pode resultar em danos graves ou afetar o desempenho.|";
            base_pt_PT = base_pt_PT + "Esta opção define o máximo de chamadas para a função de correspondência PCRE durante uma instância de correspondência regex. As instâncias que utilizem mais do que este limite serão encerradas e alertarão o utilizador, mas a verificação continuará. Para mais informações sobre o match_limit, consulte a documentação do PCRE. Os valores negativos não são permitidos. AVISO: a definição deste limite demasiado elevado pode afetar gravemente o desempenho. Padrão: 10000|";
            base_pt_PT = base_pt_PT + "Esta opção define o máximo de chamadas recursivas para a função de correspondência PCRE durante uma instância de correspondência regex. As instâncias que utilizam mais do que este limite serão encerradas e alertarão o utilizador, mas a verificação continuará. Para mais informações sobre match_limit_recursion, consulte a documentação do PCRE. Os valores negativos não são permitidos e os valores > PCREMatchLimit são supérfluos. AVISO: definir este limite demasiado elevado pode afectar gravemente o desempenho. Padrão: |";
            base_pt_PT = base_pt_PT + "Esta opção define o tamanho máximo de ficheiro para o qual as assinaturas PCRE serão executadas. Os ficheiros que excedam este limite não terão assinaturas PCRE executadas, a menos que uma assinatura seja englobada num buffer mais pequeno. Não são permitidos valores negativos. Definir este valor como zero desativa o limite. AVISO: definir este limite demasiado alto ou desativá-lo pode ter um impacto severo no desempenho. Padrão: 100M|";
            base_pt_PT = base_pt_PT + "Esta opção especifica um diretório (incluindo todos os ficheiros e diretórios dentro do mesmo), que deve ser digitalizado no acesso. Esta opção pode ser utilizada várias vezes. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Esta opção permite excluir diretórios da varredura no acesso. Pode ser utilizada várias vezes. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Com esta opção, pode eliminar o UID raiz (0). Os processos executados sob o root poderão aceder a todos os ficheiros sem disparar scans ou eventos de permissão negada. Note que se o clamd não conseguir verificar o uid do processo que gerou um evento de scan ao aceder (por exemplo, porque o OnAccessPrevention não estava ativado e o processo já saiu), o clamd executará um scan. Portanto, não há garantia de que a configuração de otUID impeça que todo o acesso do utilizador root acione um scan (a menos que OnAccessPrevention esteja ativado).|";
            base_pt_PT = base_pt_PT + "Com esta opção, pode eliminar UIDs específicos. Os processos com estes UID poderão aceder a todos os ficheiros sem disparar scans ou eventos de permissão negada. Esta opção pode ser utilizada várias vezes (uma por linha). Nota: a utilização de um valor de 0 em qualquer linha irá desativar esta opção por completo. Para eliminar o UID raiz (0), ative a opção OnAccessExcludeRootUID. Note também que se o clamd não conseguir verificar o uid do processo que gerou um evento de scan ao aceder (por exemplo, porque OnAccessPrevention não estava ativado e o processo já foi terminado), o clamd executará um scan. Portanto, não há garantia de que a configuração de OnAccessExcludeUID impeça que todo o acesso pelo uid especificado acione um scan (a menos que OnAccessPrevention esteja ativado).|";
            base_pt_PT = base_pt_PT + "Esta opção permite eliminações através de nomes de utilizador quando se utiliza o cliente de varrimento no momento do acesso. Pode ser utilizada várias vezes e tem as mesmas limitações potenciais de condição de corrida que a opção OnAccessExcludeUID. Padrão: desativado|";
            base_pt_PT = base_pt_PT + "Os ficheiros superiores a este valor não serão digitalizados no acesso. Padrão: 5M|";
            base_pt_PT = base_pt_PT + "Número máximo de threads de varrimento a alocar ao pool de threads OnAccess no arranque. Estes threads são os responsáveis ​​por criar uma ligação com o daemon e iniciar o scan após um evento ter sido processado. Para evitar que o clamonacc consuma todos os recursos do clamd, mantenha isto abaixo do número máximo de threads do clamd. Predefinição: 5|";
            base_pt_PT = base_pt_PT + "Quantidade máxima de tempo (em milissegundos) que o cliente OnAccess deve gastar por cada tentativa de ligação, envio e recepção quando comunica com o clamd via curl. Padrão: 5000 (5 segundos)|";
            base_pt_PT = base_pt_PT + "Especifica um ponto de montagem (incluindo todos os ficheiros e directórios sob o mesmo), que deve ser digitalizado no acesso. Esta opção pode ser utilizada várias vezes. Predefinição: desativado|";
            base_pt_PT = base_pt_PT + "Desativa o sistema de determinação de diretórios dinâmico que permite a observação recursiva de caminhos de inclusão. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Ativa o bloqueio do fanotify quando são encontrados ficheiros maliciosos. Default: desativado|";
            base_pt_PT = base_pt_PT + "Número de vezes que o cliente OnAccess tentará novamente uma verificação com falha devido a problemas de ligação (ou outros problemas). Predefinição: 0|";
            base_pt_PT = base_pt_PT + "Ao utilizar a prevenção, se esta opção estiver ativada, quaisquer erros que ocorram durante o scan resultarão na negação da tentativa de evento. Isto pode levar a um comportamento indesejado do sistema com determinadas definições, pelo que o cliente define isto como desativado por defeito e prefere permitir eventos de acesso em caso de scan ou erro de ligação. Padrão: não|";
            base_pt_PT = base_pt_PT + "Alterna scans extra e notificações quando um ficheiro ou diretório é criado ou movido. Requer que o sistema DDD inicie scans extra. Predefinição: não|";
            base_pt_PT = base_pt_PT + "Desativar verificação da cadeia de certificados authenticode em ficheiros PE. Padrão: não|";
            base_pt_PT = base_pt_PT + "Armazene URIs HTML em metadados. Os URIs serão gravados no arquivo metadata.json em uma matriz chamada 'URIs'|";
            base_pt_PT = base_pt_PT + "Armazene URIs de PDF em metadados. Os URIs serão gravados no arquivo metadata.json em uma matriz chamada 'URIs'.|";
            base_pt_PT = base_pt_PT + "Armazene md5 e sha1 além de sha2-256 nos metadados.|";
            base_pt_PT = base_pt_PT + "Imprima o hash do arquivo após cada arquivo digitalizado.|";
            base_pt_PT = base_pt_PT + "Imprima o tipo do arquivo após cada arquivo digitalizado.|";
            base_pt_PT = base_pt_PT + "Aplique limites semelhantes aos do FIPS no uso de algoritmos de hash para fins criptográficos. Desativará MD5 e SHA1. O PHP assina e exigirá arquivos '.sign' para verificar a autenticidade do CVD.";

//  translation it_IT
    QString base_it_IT = "Essere prolissi|";
            base_it_IT = base_it_IT + "Mostra i nomi dei file all'interno degli archivi scansionati|";
            base_it_IT = base_it_IT + "Abilitare i messaggi di debug di libclamav|";
            base_it_IT = base_it_IT + "Emette solo messaggi di errore|";
            base_it_IT = base_it_IT + "Scrive su stdout invece che su stderr. Non influisce sui messaggi di debug.|";
            base_it_IT = base_it_IT + "Disabilita il riepilogo al termine della scansion|";
            base_it_IT = base_it_IT + "Stampa solo i file infetti|";
            base_it_IT = base_it_IT + "Salta la stampa dei file OK|";
            base_it_IT = base_it_IT + "Campanello sonoro per il rilevamento dei virus|";
            base_it_IT = base_it_IT + "Non rimuovere i file temporanei|";
            base_it_IT = base_it_IT + "Genera una descrizione JSON dei file scansionati. JSON verrà stampato e anche|";
            base_it_IT = base_it_IT + "Caricare solo le firme ufficiali|";
            base_it_IT = base_it_IT + "Scansione ricorsiva delle sottodirectory|";
            base_it_IT = base_it_IT + "Continuare la scansione all'interno del file dopo aver trovato una corrispondenza|";
            base_it_IT = base_it_IT + "Scansione di file e directory su altri filesystem|";
            base_it_IT = base_it_IT + "Rimuovere i file infetti. Attenzione!|";
            base_it_IT = base_it_IT + "Carica bytecode senza segno. **Attenzione**: non dovresti MAI eseguire firme bytecode da fonti non attendibili. Ciò potrebbe comportare l'esecuzione di codice arbitrario.|";
            base_it_IT = base_it_IT + "Rilevare le applicazioni potenzialmente indesiderate|";
            base_it_IT = base_it_IT + "Rilevare dati strutturati (SSN, carta di credito)|";
            base_it_IT = base_it_IT + "Scansione di file di posta elettronica|";
            base_it_IT = base_it_IT + "Abilitare il rilevamento del phishing basato sulle firme delle e-mail|";
            base_it_IT = base_it_IT + "Abilitare il rilevamento del phishing basato sulle firme degli URL|";
            base_it_IT = base_it_IT + "Avvisi euristici|";
            base_it_IT = base_it_IT + "Interrompere la scansione non appena viene trovata una corrispondenza euristica.|";
            base_it_IT = base_it_IT + "Normalizza i file html, di script e di testo. Usare normalize=no per la compatibilità con yara|";
            base_it_IT = base_it_IT + "Scansione dei file PE|";
            base_it_IT = base_it_IT + "Scansione dei file ELF|";
            base_it_IT = base_it_IT + "Scansione dei contenitori OLE2|";
            base_it_IT = base_it_IT + "Scansione di file PDF|";
            base_it_IT = base_it_IT + "Scansione di file SWF|";
            base_it_IT = base_it_IT + "Scansione dei file HTML|";
            base_it_IT = base_it_IT + "Scansione di file di documenti basati su xml|";
            base_it_IT = base_it_IT + "Scansione dei file HWP3|";
            base_it_IT = base_it_IT + "Scansione di file di archivio (supportata da libclamav)|";
            base_it_IT = base_it_IT + "Avviso sui file eseguibili non funzionanti (PE e ELF)|";
            base_it_IT = base_it_IT + "Avviso su file grafici non funzionanti (JPEG, TIFF, PNG, GIF)|";
            base_it_IT = base_it_IT + "Allarme su archivi e documenti criptati|";
            base_it_IT = base_it_IT + "Avviso su archivi criptati|";
            base_it_IT = base_it_IT + "Allarme sui documenti criptati|";
            base_it_IT = base_it_IT + "Avviso su file OLE2 contenenti macro VBA|";
            base_it_IT = base_it_IT + "Avviso sui file che superano la dimensione massima del file, la dimensione massima della scansione o il limite massimo di ricorsione.|";
            base_it_IT = base_it_IT + "Avviso su e-mail contenenti errori di corrispondenza SSL negli URL|";
            base_it_IT = base_it_IT + "Allarme sulle e-mail contenenti URL occultati|";
            base_it_IT = base_it_IT + "Avviso su file immagine DMG grezzi contenenti intersezioni di partizioni|";
            base_it_IT = base_it_IT + "Disabilitare la verifica della catena di certificati authenticode nei file PE|";
            base_it_IT = base_it_IT + "Eseguire il dump della catena di certificati authenticode nei file PE|";
            base_it_IT = base_it_IT + "Disattivare la cache e i controlli della cache per le somme hash dei file scansionati.|";
// New with version 1.4.2 of clamav
            base_it_IT = base_it_IT + "Creazione di file temporanei per le scansioni di file annidati che altrimenti verrebbero memorizzati solo nella memoria di lavoro.|";
            base_it_IT = base_it_IT + "Genera metadati JSON per i file scansionati. Solo per scopi di test e sviluppo.|";
            base_it_IT = base_it_IT + "Restituisce un codice di errore non nullo se il database dei virus non è aggiornato.|";
            base_it_IT = base_it_IT + "Scansione di file OneNote|";
            base_it_IT = base_it_IT + "Scansione di file immagine (grafica)|";
            base_it_IT = base_it_IT + "Riconoscere i file calcolando hash fuzzy per le immagini (grafica)|";
            base_it_IT = base_it_IT + "Crea file temporanei per le scansioni di file annidati che altrimenti sarebbero solo in memoria.|";
// clamd.conf
            base_it_IT = base_it_IT + "Salva tutti i report in un file di registro. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Per impostazione predefinita, il file di registro è bloccato per la scrittura e solo un singolo processo demone può scriverci. Questa opzione disabilita il blocco. Predefinito: no|";
            base_it_IT = base_it_IT + "Dimensione massima del file di registro. Il valore 0 disabilita il limite. Predefinito: 1048576|";
            base_it_IT = base_it_IT + "Registra l'ora per ogni messaggio. Predefinito: no|";
            base_it_IT = base_it_IT + "Registra tutti i file puliti. Utile per il debug, ma aumenta drasticamente la dimensione del registro. Predefinito: no|";
            base_it_IT = base_it_IT + "Utilizza il logger di sistema (può funzionare insieme a LogFile). Predefinito: no|";
            base_it_IT = base_it_IT + "Tipo di messaggi syslog. Fare riferimento a 'man syslog' per i nomi delle strutture. (LOG_LOCAL6, LOG_MAIL), Default: LOG_LOCAL6|";
            base_it_IT = base_it_IT + "Abilita la registrazione dettagliata. Default: no|";
            base_it_IT = base_it_IT + "Ruota il file di registro. Richiede l'opzione LogFileMaxSize impostata prima di questa opzione. Default: no|";
            base_it_IT = base_it_IT + "Registra informazioni aggiuntive sul file infetto, come la sua dimensione e hash, insieme al nome del virus. Default: no|";
            base_it_IT = base_it_IT + "Scrivi il pid del demone nel file specificato. Default: disabilitato|";
            base_it_IT = base_it_IT + "Questa opzione consente di modificare la directory temporanea predefinita. Default: /tmp|";
            base_it_IT = base_it_IT + "Questa opzione consente di modificare la directory predefinita del database. Se la si abilita, assicurarsi che punti alla stessa directory sia in clamd che in freshclam. Predefinito: /usr/local/share/clamav|";
            base_it_IT = base_it_IT + "Carica solo le firme ufficiali pubblicate dal progetto ClamAV. Predefinito: no|";
            base_it_IT = base_it_IT + "Restituisce un codice di errore diverso da zero se il database dei virus è più vecchio del numero di giorni specificato. Predefinito: -1|";
            base_it_IT = base_it_IT + "Percorso a un socket locale (Unix) su cui il demone ascolterà. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Imposta la proprietà del gruppo sul socket Unix. Predefinito: |";
            base_it_IT = base_it_IT + "Imposta i permessi sul socket Unix sulla modalità specificata. Predefinito: 660|";
            base_it_IT = base_it_IT + "Rimuove il socket obsoleto dopo uno spegnimento non pulito. Predefinito: sì|";
            base_it_IT = base_it_IT + "Numero di porta TCP su cui il demone ascolterà. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Per impostazione predefinita, clamd si collega a INADDR_ANY. Questa opzione consente di limitare l'indirizzo TCP e fornire un certo grado di protezione dal mondo esterno. Questa opzione può essere specificata più volte per ascoltare su più IP. Ora è supportato IPv6. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Lunghezza massima a cui può arrivare la coda di connessioni in sospeso. Predefinito: 200|";
            base_it_IT = base_it_IT + "Chiude la sessione STREAM quando viene superato il limite di dimensione dei dati. Il valore deve corrispondere al limite del tuo MTA per la dimensione massima degli allegati. Predefinito: 100 M|";
            base_it_IT = base_it_IT + "Il comando STREAM utilizza un protocollo di tipo FTP. Questa opzione imposta il limite inferiore per l'intervallo di porte. Predefinito: 1024|";
            base_it_IT = base_it_IT + "Questa opzione imposta il limite superiore per l'intervallo di porte. Predefinito: 2048|";
            base_it_IT = base_it_IT + "Numero massimo di thread in esecuzione contemporaneamente. Predefinito: 10|";
            base_it_IT = base_it_IT + "Questa opzione specifica il tempo (in secondi) dopo il quale clamd dovrebbe andare in timeout se un client non fornisce alcun dato. Predefinito: 120|";
            base_it_IT = base_it_IT + "Questa opzione specifica il tempo (in secondi) dopo il quale clamd dovrebbe andare in timeout se un client non fornisce alcun comando iniziale dopo la connessione. Il valore predefinito è impostato su 30 per evitare timeout con socket TCP durante l'elaborazione di messaggi di grandi dimensioni. Se si utilizza un socket Unix, il valore può essere modificato in 5. Nota: il timeout per i comandi successivi e/o i blocchi di dati è specificato da ReadTimeout. Predefinito: 30|";
            base_it_IT = base_it_IT + "Questa opzione specifica per quanto tempo attendere (in millisecondi) se il buffer di invio è pieno. Mantenere basso questo valore per evitare che clamd si blocchi. Predefinito: 500|";
            base_it_IT = base_it_IT + "Numero massimo di elementi in coda (inclusi quelli elaborati dai thread MaxThreads). Si consiglia di avere questo valore almeno il doppio di MaxThreads, se possibile. ATTENZIONE: non dovresti aumentarlo troppo per evitare di esaurire i descrittori di file, dovrebbe essere valida la seguente condizione: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE. RLIMIT_NOFILE è il numero massimo di descrittori di file aperti (solitamente 1024), impostato da ulimit -n. Predefinito: 100|";
            base_it_IT = base_it_IT + "Questa opzione specifica per quanto tempo (in secondi) il processo deve attendere un nuovo job. Predefinito: 30|";
            base_it_IT = base_it_IT + "Non eseguire la scansione di file e directory corrispondenti a REGEX. Questa direttiva può essere utilizzata più volte. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Le directory con profondità massima vengono scansionate. Predefinito: 15|";
            base_it_IT = base_it_IT + "Segui i collegamenti simbolici delle directory. Predefinito: no|";
            base_it_IT = base_it_IT + "Scansiona file e directory su altri filesystem. Predefinito: yes|";
            base_it_IT = base_it_IT + "Segui i collegamenti simbolici dei file regolari. Predefinito: no|";
            base_it_IT = base_it_IT + "Questa opzione specifica gli intervalli di tempo (in secondi) in cui clamd deve eseguire un controllo del database. Predefinito: 600|";
            base_it_IT = base_it_IT + "Abilita i ricaricamenti del database non bloccanti (multi-thread/contemporanei). Questa funzionalità caricherà temporaneamente un secondo motore di scansione mentre la scansione continua utilizzando il primo motore. Una volta caricato, il nuovo motore prende il sopravvento. Il vecchio motore viene rimosso non appena tutte le scansioni che utilizzano il vecchio motore sono state completate. Questa funzionalità richiede più RAM, quindi questa opzione è fornita nel caso in cui gli utenti siano disposti a bloccare le scansioni durante il ricaricamento in cambio di requisiti di RAM inferiori. Predefinito: sì|";
            base_it_IT = base_it_IT + "Esegui un comando quando viene trovato un virus. Utilizza le seguenti variabili di ambiente per identificare i nomi del file e del virus: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME Nella stringa di comando, '%v' verrà anche sostituito con il nome del virus. Nota: il carattere di formato del nome file '%f' è stato disabilitato e non verrà più sostituito con il nome del file, a causa di problemi di sicurezza dell'iniezione di comandi. Utilizza invece la variabile di ambiente 'CLAVIRUSEVENT_FILENAME'. Per lo stesso motivo, NON dovresti usare le variabili di ambiente nel comando direttamente, ma dovresti usarle con attenzione dallo script eseguito. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Arresta il demone quando libclamav segnala una condizione di memoria insufficiente. Predefinito: no|";
            base_it_IT = base_it_IT + "Consenti l'uso del comando ALLMATCHSCAN. Predefinito: sì|";
            base_it_IT = base_it_IT + "Non eseguire il fork in background. Predefinito: no|";
            base_it_IT = base_it_IT + "Abilita i messaggi di debug da libclamav. Predefinito: no|";
            base_it_IT = base_it_IT + "Non rimuovere i file temporanei (per scopi di debug). Predefinito: no GenerateMetadataJson BOOL Registra i metadati sul file sottoposto a scansione. I metadati di scansione sono utili per scopi di analisi dei file e per il debug del comportamento della scansione. I metadati JSON verranno stampati al termine della scansione se Debug è abilitato. Un file metadata.json verrà scritto nella directory temporanea della scansione se LeaveTemporaryFiles è abilitato. Predefinito: no|";
            base_it_IT = base_it_IT + "Esegui il demone come utente specificato (il processo deve essere avviato da root). Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Con questa opzione abilitata ClamAV caricherà il bytecode dal database. Si consiglia vivamente di mantenere questa opzione attivata, altrimenti si potrebbero perdere i rilevamenti di molti nuovi virus. Predefinito: sì|";
            base_it_IT = base_it_IT + "Imposta il livello di sicurezza del bytecode. Valori possibili: TrustSigned - considera attendibile il bytecode caricato da file .c[lv]d firmati e inserisci controlli di sicurezza runtime per il bytecode caricato da altre fonti, Paranoid - non considera attendibile alcun bytecode, inserisci controlli runtime per tutti. Consigliato: TrustSigned, perché il bytecode nei file .cvd ha già questi controlli. (TrustSigned, Paranoid) Predefinito: TrustSigned|";
            base_it_IT = base_it_IT + "Imposta il timeout del bytecode in millisecondi. Predefinito: 10000|";
            base_it_IT = base_it_IT + "Consenti il ​​caricamento del bytecode dall'esterno di file .c[lv]d firmati digitalmente. **Attenzione**: NON dovresti MAI eseguire firme bytecode da fonti non attendibili. Ciò potrebbe causare l'esecuzione di codice arbitrario. Predefinito: no|";
            base_it_IT = base_it_IT + "Imposta la modalità di esecuzione del bytecode. Valori possibili: Auto - scegli automaticamente JIT se possibile, fallisci sull'interprete ForceJIT - scegli sempre JIT, fallisci se non è possibile ForceInterpreter - scegli sempre l'interprete Test - esegui sia con JIT che con l'interprete e confronta i risultati. Rendi tutti i fallimenti fatali. Predefinito: Auto|";
            base_it_IT = base_it_IT + "Rileva applicazioni potenzialmente indesiderate. Predefinito: no|";
            base_it_IT = base_it_IT + "Escludi una categoria PUA specifica. Questa direttiva può essere utilizzata più volte. Consulta https://docs.clamav.net/faq/faq-pua.html per l'elenco completo delle categorie PUA. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Includi solo una categoria PUA specifica. Questa direttiva può essere utilizzata più volte. Consulta https://docs.clamav.net/faq/faq-pua.html per l'elenco completo delle categorie PUA. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "In alcuni casi (ad esempio malware complessi, exploit in file grafici e altri), ClamAV utilizza algoritmi speciali per fornire un rilevamento accurato. Questa opzione controlla il rilevamento algoritmico. Predefinito: sì|";
            base_it_IT = base_it_IT + "Consenti alla corrispondenza euristica di avere la precedenza. Se abilitata, se una scansione euristica (come phishingScan) rileva un possibile virus/phishing, interromperà immediatamente la scansione. Consigliato, consente di risparmiare tempo di scansione della CPU. Se disabilitata, i virus/phishing rilevati dalle scansioni euristiche verranno segnalati solo alla fine di una scansione. Se un archivio contiene sia un virus/phishing rilevato euristicamente sia un malware reale, verrà segnalato il malware reale. Mantieni questa opzione disabilitata se intendi gestire i virus \"*.Heuristics.*\" in modo diverso dal malware \"reale\". Se viene trovato per primo un virus non rilevato euristicamente (basato sulla firma), la scansione viene interrotta immediatamente, indipendentemente da questa opzione di configurazione. Predefinito: no|";
            base_it_IT = base_it_IT + "PE sta per Portable Executable, è un formato di file eseguibile utilizzato in tutte le versioni a 32 e 64 bit dei sistemi operativi Windows. Questa opzione consente a ClamAV di eseguire un'analisi più approfondita dei file eseguibili ed è anche necessaria per la decompressione di popolari pacchetti eseguibili come UPX. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza elaborazione aggiuntiva. Predefinito: sì|";
            base_it_IT = base_it_IT + "Executable and Linking Format è un formato standard per gli eseguibili UN*X. Questa opzione consente di controllare la scansione dei file ELF. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza elaborazione aggiuntiva. Predefinito: sì|";
            base_it_IT = base_it_IT + "Abilita la scansione dei file di posta. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza analizzare i singoli messaggi/allegati. Predefinito: sì|";
            base_it_IT = base_it_IT + "Scansiona i messaggi RFC1341 suddivisi in più email. Dovrai pulire periodicamente la directory $TemporaryDirectory/clamav-partial. ATTENZIONE: questa opzione potrebbe esporre il tuo sistema a un attacco DoS. Non usarla mai su server caricati. Predefinito: no|";
            base_it_IT = base_it_IT + "Abilita il rilevamento del phishing basato sulla firma email. Predefinito: yes|";
            base_it_IT = base_it_IT + "Abilita rilevamento phishing basato su firma URL (Heuristics.Phishing.Email.*) Predefinito: sì|";
            base_it_IT = base_it_IT + "Abilita il modulo DLP. Predefinito: no|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero più basso di numeri di carte di credito trovati in un file per generare un rilevamento. Predefinito: 3|";
            base_it_IT = base_it_IT + "Con questa opzione abilitata, il modulo DLP cercherà solo numeri di carte di credito validi. Le carte di debito e private label non verranno cercate. Predefinito: no|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero più basso di numeri di previdenza sociale trovati in un file per generare un rilevamento. Predefinito: 3|";
            base_it_IT = base_it_IT + "Con questa opzione abilitata, il modulo DLP cercherà i codici SSN validi formattati come xxx-yy-zzzz. Predefinito: sì|";
            base_it_IT = base_it_IT + "Con questa opzione abilitata, il modulo DLP cercherà i codici SSN validi formattati come xxxyyzzzz. Predefinito: no|";
            base_it_IT = base_it_IT + "Esegui la normalizzazione e la decifratura HTML/JavaScript/ScriptEncoder. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza ulteriore elaborazione. Predefinito: sì|";
            base_it_IT = base_it_IT + "Questa opzione abilita la scansione dei file OLE2, come i documenti di Microsoft Office e i file .msi. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza ulteriore elaborazione. Predefinito: sì|";
            base_it_IT = base_it_IT + "Questa opzione abilita la scansione all'interno di file PDF. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza elaborazione aggiuntiva. Predefinito: sì|";
            base_it_IT = base_it_IT + "Questa opzione abilita la scansione all'interno di file SWF. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza decodifica ed elaborazione aggiuntiva. Predefinito: sì|";
            base_it_IT = base_it_IT + "Questa opzione abilita la scansione di file di documenti basati su xml supportati da libclamav. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza elaborazione aggiuntiva. Predefinito: sì|";
            base_it_IT = base_it_IT + "Questa opzione abilita la scansione di file HWP3. Se disattivi questa opzione, i file originali verranno comunque scansionati, ma senza elaborazione aggiuntiva. Predefinito: sì|";
            base_it_IT = base_it_IT + "Questa opzione consente la scansione dei file OneNote. Se si disattiva questa opzione, i file originali verranno comunque scansionati, ma senza ulteriore elaborazione. Impostazione predefinita: sì|";
            base_it_IT = base_it_IT + "Scansione all'interno di archivi e file compressi. Se si disattiva questa opzione, i file originali verranno comunque scansionati, ma senza decompressione ed elaborazione aggiuntiva. Impostazione predefinita: sì|";
            base_it_IT = base_it_IT + "Questa opzione consente la scansione di immagini (grafiche). Se si disattiva questa opzione, i file originali verranno comunque scansionati, ma senza decompressione ed elaborazione aggiuntiva. Impostazione predefinita: sì|";
            base_it_IT = base_it_IT + "Questa opzione consente il rilevamento mediante il calcolo di un hash fuzzy dei file di immagini (grafiche). Le firme che utilizzano hash fuzzy delle immagini in genere corrispondono a file e documenti identificando le immagini incorporate o allegate a tali file. Se si disattiva questa opzione, alcuni file potrebbero non essere più rilevati. Impostazione predefinita: sì|";
            base_it_IT = base_it_IT + "Avviso su file eseguibili danneggiati (PE ed ELF). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso su file grafici danneggiati (JPEG, TIFF, PNG, GIF). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso su archivi e documenti crittografati (.zip, .7zip, .rar, .pdf crittografati). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso su archivi crittografati (.zip, .7zip, .rar crittografati). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso su documenti crittografati (.pdf crittografati). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso sui file OLE2 contenenti macro VBA (Heuristics.OLE2.ContainsMacros). Predefinito: no|";
            base_it_IT = base_it_IT + "Quando AlertExceedsMax è impostato, i file che superano il limite MaxFileSize, MaxScanSize o MaxRecursion saranno contrassegnati con il nome del virus che inizia con \"Heuristics.Limits.Exceeded\". Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso sulle e-mail contenenti mancate corrispondenze SSL negli URL (potrebbe causare falsi positivi!). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso sulle e-mail contenenti URL mascherati (potrebbe causare alcuni falsi positivi). Predefinito: no|";
            base_it_IT = base_it_IT + "Avviso sui file immagine DMG raw contenenti intersezioni di partizioni. Predefinito: no|";
            base_it_IT = base_it_IT + "Questa opzione consente di disattivare la funzionalità di memorizzazione nella cache del motore. Per impostazione predefinita, il motore memorizzerà un MD5 in una cache di tutti i file che non sono contrassegnati come virus o che hanno superato i controlli dei limiti. Attenzione: la disattivazione della cache avrà un impatto negativo sulle prestazioni nelle scansioni di grandi dimensioni. Predefinito: no|";
            base_it_IT = base_it_IT + "Questa opzione consente di impostare il numero di voci che la cache può memorizzare. Il valore deve essere un numero quadrato o verrà arrotondato al quadrato più vicino. Predefinito: 65536|";
            base_it_IT = base_it_IT + "Questa opzione fa sì che le scansioni di memoria o di mappe nidificate scarichino il contenuto sul disco. Se si attiva questa opzione, vengono scritti più dati sul disco e sono disponibili quando l'opzione leave-temps è abilitata a costo di più scritture su disco. Predefinito: no|";
            base_it_IT = base_it_IT + "Questa opzione imposta il tempo massimo di completamento di una scansione. Il valore è in millisecondi. Il valore 0 disabilita il limite. ATTENZIONE: disabilitare questo limite o impostarlo troppo alto potrebbe consentire la scansione di determinati file per bloccare il processo/thread di scansione, con conseguente Denial of Service. Predefinito: 120000|";
            base_it_IT = base_it_IT + "Imposta la quantità massima di dati da sottoporre a scansione per ogni file di input. Archivi e altri contenitori vengono estratti e scansionati in modo ricorsivo fino a questo valore. La dimensione di un archivio più la somma delle dimensioni di tutti i file all'interno dell'archivio contano per la dimensione della scansione. Ad esempio, un archivio non compresso da 1 M contenente un singolo file interno da 1 M conta come 2 M per la dimensione massima della scansione. Attenzione: disabilitare questo limite o impostarlo troppo alto potrebbe causare gravi danni al sistema. Predefinito: 400 M|";
            base_it_IT = base_it_IT + "I file più grandi di questo limite non verranno scansionati. Influisce sul file di input stesso e sui file in esso contenuti (quando il file di input è un archivio, un documento o un altro tipo di contenitore). Attenzione: disabilitare questo limite o impostarlo troppo alto potrebbe causare gravi danni al sistema. Le limitazioni di progettazione tecnica impediscono a ClamAV di scansionare file più grandi di 2 GB in questo momento. Predefinito: 100 M|";
            base_it_IT = base_it_IT + "Gli archivi nidificati vengono scansionati in modo ricorsivo, ad esempio se un archivio Zip contiene un file RAR, verranno scansionati anche tutti i file al suo interno. Questa opzione specifica quanto in profondità deve essere continuato il processo. Attenzione: impostare questo limite troppo alto potrebbe causare gravi danni al sistema. Predefinito: 17|";
            base_it_IT = base_it_IT + "Numero di file da scansionare all'interno di un archivio, un documento o qualsiasi altro tipo di contenitore. Attenzione: disabilitare questo limite o impostarlo su un valore troppo alto potrebbe causare gravi danni al sistema. Predefinito: 10000|";
            base_it_IT = base_it_IT + "Questa opzione imposta la dimensione massima di un file da controllare per PE incorporato. I file più grandi di questo valore salteranno la fase di analisi aggiuntiva. I valori negativi non sono consentiti. Predefinito: 40M|";
            base_it_IT = base_it_IT + "Questa opzione imposta la dimensione massima di un file HTML da normalizzare. I file HTML più grandi di questo valore non verranno normalizzati o scansionati. I valori negativi non sono consentiti. Predefinito: 40M|";
            base_it_IT = base_it_IT + "Questa opzione imposta la dimensione massima di un file HTML normalizzato da analizzare. I file HTML più grandi di questo valore dopo la normalizzazione non verranno analizzati. I valori negativi non sono consentiti. Predefinito: 8M|";
            base_it_IT = base_it_IT + "Questa opzione imposta la dimensione massima di un file script da normalizzare. Il contenuto script più grande di questo valore non verrà normalizzato o analizzato. I valori negativi non sono consentiti. Predefinito: 20M|";
            base_it_IT = base_it_IT + "Questa opzione imposta la dimensione massima di un file ZIP per rianalizzare il riconoscimento del tipo. I file ZIP più grandi di questo valore salteranno il passaggio per rianalizzare potenzialmente come PE. Non sono consentiti valori negativi. ATTENZIONE: impostare questo limite troppo alto potrebbe causare gravi danni o influire sulle prestazioni. Predefinito: 1M|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero massimo di partizioni di un'immagine disco raw da scansionare. Le immagini disco raw con più partizioni di questo valore avranno fino al valore di partizioni scansionate. Non sono consentiti valori negativi. ATTENZIONE: impostare questo limite troppo alto potrebbe causare gravi danni o influire sulle prestazioni. Predefinito: 50|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero massimo di icone all'interno di un PE da scansionare. I file PE con più icone di questo valore avranno fino al valore numero di icone scansionate. I valori negativi non sono consentiti. ATTENZIONE: impostare questo limite troppo alto potrebbe causare gravi danni o influire sulle prestazioni.|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero massimo di chiamate ricorsive alla funzione di analisi HWP3. I file HWP3 che utilizzano più di questo limite verranno terminati e avviseranno l'utente. Le scansioni non saranno in grado di scansionare alcun allegato HWP3 se viene raggiunto il limite ricorsivo. I valori negativi non sono consentiti. ATTENZIONE: impostare questo limite troppo alto potrebbe causare gravi danni o influire sulle prestazioni.|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero massimo di chiamate alla funzione di corrispondenza PCRE durante un'istanza di corrispondenza regex. Le istanze che utilizzano più di questo limite verranno terminate e avviseranno l'utente, ma la scansione continuerà. Per maggiori informazioni su match_limit, consulta la documentazione PCRE. Non sono consentiti valori negativi. ATTENZIONE: impostare questo limite troppo alto potrebbe avere un impatto significativo sulle prestazioni. Predefinito: 10000|";
            base_it_IT = base_it_IT + "Questa opzione imposta il numero massimo di chiamate ricorsive alla funzione di corrispondenza PCRE durante un'istanza di corrispondenza regex. Le istanze che utilizzano più di questo limite verranno terminate e avviseranno l'utente, ma la scansione continuerà. Per maggiori informazioni su match_limit_recursion, consulta la documentazione PCRE. Non sono consentiti valori negativi e i valori > PCREMatchLimit sono superflui. ATTENZIONE: impostare questo limite troppo alto potrebbe avere un impatto significativo sulle prestazioni. Predefinito: 2000|";
            base_it_IT = base_it_IT + "Questa opzione imposta la dimensione massima del file per cui verranno eseguite le sottofirme PCRE. I file che superano questo limite non avranno sottofirme PCRE eseguite a meno che una sottofirma non sia racchiusa in un buffer più piccolo. Non sono consentiti valori negativi. Impostando questo valore su zero si disabilita il limite. ATTENZIONE: impostare questo limite su un valore troppo alto o disabilitarlo potrebbe avere un impatto significativo sulle prestazioni. Predefinito: 100 M|";
            base_it_IT = base_it_IT + "Questa opzione specifica una directory (inclusi tutti i file e le directory al suo interno), che dovrebbe essere scansionata all'accesso. Questa opzione può essere utilizzata più volte. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Questa opzione consente di escludere le directory dalla scansione all'accesso. Può essere utilizzata più volte. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Con questa opzione puoi escludere l'UID root (0). I processi eseguiti sotto root saranno in grado di accedere a tutti i file senza attivare scansioni o eventi di autorizzazione negata. Nota che se clamd non riesce a controllare l'UID del processo che ha generato un evento di scansione all'accesso (ad esempio, perché OnAccessPrevention non era abilitato e il processo era già terminato), clamd eseguirà una scansione. Pertanto, l'impostazione di OnAccessExcludeRootUID non garantisce che ogni accesso da parte dell'utente root non attivi una scansione (a meno che OnAccessPrevention non sia abilitato). Predefinito: no|";
            base_it_IT = base_it_IT + "Con questa opzione puoi escludere UID specifici. I processi con questi UID saranno in grado di accedere a tutti i file senza attivare scansioni o eventi di autorizzazione negata. Questa opzione può essere utilizzata più volte (una per riga). Nota: l'utilizzo di un valore pari a 0 su qualsiasi riga disabiliterà completamente questa opzione. Per escludere l'UID radice (0), abilitare l'opzione OnAccessExcludeRootUID. Si noti inoltre che se clamd non riesce a controllare l'UID del processo che ha generato un evento di scansione all'accesso (ad esempio, perché OnAccessPrevention non era abilitato e il processo era già terminato), clamd eseguirà una scansione. Pertanto, l'impostazione di OnAccessExcludeUID non garantisce che ogni accesso da parte dell'UID specificato non attivi una scansione (a meno che OnAccessPrevention non sia abilitato). Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Questa opzione consente esclusioni tramite nomi utente quando si utilizza il client di scansione all'accesso. Può essere utilizzata più volte e presenta le stesse potenziali limitazioni di race condition dell'opzione OnAccessExcludeUID. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "I file più grandi di questo valore non verranno scansionati all'accesso. Predefinito: 5M|";
            base_it_IT = base_it_IT + "Numero massimo di thread di scansione da allocare al pool di thread OnAccess all'avvio. Questi thread sono quelli responsabili della creazione di una connessione con il demone e dell'avvio della scansione dopo l'elaborazione di un evento. Per evitare che clamonacc consumi tutte le risorse di clamd, mantieni questo valore inferiore al numero massimo di thread di clamd. Predefinito: 5|";
            base_it_IT = base_it_IT + "Quantità massima di tempo (in millisecondi) che il client OnAccess deve impiegare per ogni tentativo di connessione, invio e ricezione quando comunica con clamd tramite curl. Predefinito: 5000 (5 secondi)|";
            base_it_IT = base_it_IT + "Specifica un punto di montaggio (inclusi tutti i file e le directory sottostanti), che deve essere scansionato all'accesso. Questa opzione può essere utilizzata più volte. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Disabilita il sistema di determinazione dinamica delle directory che consente di monitorare ricorsivamente i percorsi di inclusione. Predefinito: no|";
            base_it_IT = base_it_IT + "Abilita il blocco fanotify quando vengono trovati file dannosi. Predefinito: disabilitato|";
            base_it_IT = base_it_IT + "Numero di volte in cui il client OnAccess riproverà una scansione non riuscita a causa di problemi di connessione (o altri problemi). Predefinito: 0|";
            base_it_IT = base_it_IT + "Quando si usa la prevenzione, se questa opzione è attivata, tutti gli errori che si verificano durante la scansione comporteranno il rifiuto del tentativo di evento. Ciò potrebbe potenzialmente portare a un comportamento indesiderato del sistema con determinate configurazioni, quindi il client imposta questa opzione su off e preferisce consentire gli eventi di accesso in caso di errore di scansione o connessione. Predefinito: no|";
            base_it_IT = base_it_IT + "Attiva/disattiva la scansione extra e le notifiche quando un file o una directory vengono creati o spostati. Richiede al sistema DDD di avviare scansioni extra. Predefinito: no|";
            base_it_IT = base_it_IT + "Disattiva la verifica della catena di certificati Authenticode nei file PE. Predefinito: no|";
            base_it_IT = base_it_IT + "Memorizza gli URI html nei metadati. Gli URI verranno scritti nel file metadata.json in un array chiamato 'URI'|";
            base_it_IT = base_it_IT + "Memorizza gli URI pdf nei metadati. Gli URI verranno scritti nel file metadata.json in un array denominato 'URI'|.";
            base_it_IT = base_it_IT + "Memorizza md5 e sha1 oltre a sha2-256 nei metadati.|";
            base_it_IT = base_it_IT + "Stampa l'hash del file dopo ogni file scansionato.|";
            base_it_IT = base_it_IT + "Stampa il tipo di file dopo ogni file scansionato.|";
            base_it_IT = base_it_IT + "Applicare limiti simili a FIPS sull'utilizzo di algoritmi hash per scopi crittografici. Disabiliterà MD5 e SHA1. PHP firma e richiederà file '.sign' per verificare l'autenticità CVD.";

// translations da_DK
    QString base_da_DK = "Sei mitteilsam|";
            base_da_DK = base_da_DK + "Vis filer i arkiver|";
            base_da_DK = base_da_DK + "Aktiver libclamavs fejlfindingsmeddelelser|";
            base_da_DK = base_da_DK + "Udsender kun fejlmeddelelser|";
            base_da_DK = base_da_DK + "Skriv til stdout i stedet for stderr. Påvirker ikke 'debug'-meddelelser.|";
            base_da_DK = base_da_DK + "Deaktiver scanningsoversigten ved afslutningen af scanningsprocessen|";
            base_da_DK = base_da_DK + "Udsender kun inficerede filer|";
            base_da_DK = base_da_DK + "Spring output af OK-filer over|";
            base_da_DK = base_da_DK + "Klokke til virusdetektion|";
            base_da_DK = base_da_DK + "Fjern ikke midlertidige filer|";
            base_da_DK = base_da_DK + "Opret JSON-beskrivelse af scannede filer. JSON er output og også|";
            base_da_DK = base_da_DK + "Indlæs kun officielle underskrifter|";
            base_da_DK = base_da_DK + "Scan undermapper rekursivt|";
            base_da_DK = base_da_DK + "Fortsæt med at scanne i filen, hvis der opnås et hit|";
            base_da_DK = base_da_DK + "Scan filer og mapper på andre filsystemer|";
            base_da_DK = base_da_DK + "Fjern inficerede filer. Vær forsigtig!|";
            base_da_DK = base_da_DK + "Indlæs usigneret bytekode. **Forsigtig**: Du bør ALDRIG køre bytekode-signaturer fra upålidelige kilder. Hvis du gør det, kan det resultere i udførelse af vilkårlig kode.|";
            base_da_DK = base_da_DK + "Genkender formentlig uønskede programmer|";
            base_da_DK = base_da_DK + "Genkender strukturerede data (SSN, kreditkort)|";
            base_da_DK = base_da_DK + "Scanning af mailfiler|";
            base_da_DK = base_da_DK + "Aktivér phishing-registrering med e-mail-signaturer|";
            base_da_DK = base_da_DK + "Aktivér URL-signatur og phishing-registrering|";
            base_da_DK = base_da_DK + "Heuristiske advarsler|";
            base_da_DK = base_da_DK + "Stop søgningen, så snart der er fundet et heuristisk match.|";
            base_da_DK = base_da_DK + "Normaliser HTML-, script- og tekstfiler. Brug normalise=no for Yara-kompatibilitet|";
            base_da_DK = base_da_DK + "Scan PE-filer|";
            base_da_DK = base_da_DK + "Scanning af ELF-filer|";
            base_da_DK = base_da_DK + "Scan OLE2-container|";
            base_da_DK = base_da_DK + "Scan PDF-filer|";
            base_da_DK = base_da_DK + "Scan SWF-filer|";
            base_da_DK = base_da_DK + "Scan HTML-filer|";
            base_da_DK = base_da_DK + "Scan xml-baserede dokumentfiler|";
            base_da_DK = base_da_DK + "Scan HWP3-filer|";
            base_da_DK = base_da_DK + "Scanning af arkivfiler (understøttes af libclamav)|";
            base_da_DK = base_da_DK + "Advarsel om defekte eksekverbare filer (PE & ELF)|";
            base_da_DK = base_da_DK + "Advarsel om defekte grafikfiler (JPEG, TIFF, PNG, GIF)|";
            base_da_DK = base_da_DK + "Advarsel om krypterede arkiver og dokumenter|";
            base_da_DK = base_da_DK + "Advarsel for krypterede arkiver|";
            base_da_DK = base_da_DK + "Advarsel for krypterede dokumenter|";
            base_da_DK = base_da_DK + "Advarsel om OLE2-filer, der indeholder VBA-makroer|";
            base_da_DK = base_da_DK + "Advarsel for filer, der overskrider den maksimale filstørrelse, den maksimale scanningsstørrelse eller den maksimale rekursionsgrænse|";
            base_da_DK = base_da_DK + "Advarsel for e-mails, der indeholder SSL-misforhold i URL'er|";
            base_da_DK = base_da_DK + "Advarsel om e-mails med skjulte URL'er|";
            base_da_DK = base_da_DK + "Advarsel for rå DMG-billedfiler, der indeholder partitionsoverlapninger|";
            base_da_DK = base_da_DK + "Deaktivering af Authenticode-certifikatkædekontrol i PE-filer|";
            base_da_DK = base_da_DK + "Dump af Authenticode-certifikatkæden i PE-filer|";
            base_da_DK = base_da_DK + "Deaktiver caching og cache-kontrol af hashsummer for scannede filer.|";
// new with version 1.4.2 of clamav
            base_da_DK = base_da_DK + "Opret midlertidige filer til indlejrede filscanninger, der ellers kun ville være i hukommelsen|";
            base_da_DK = base_da_DK + "Generer JSON-metadata for de scannede filer. KUN til test- og udviklingsbrug.|";
            base_da_DK = base_da_DK + "Returneres med en fejlkode forskellig fra nul, hvis virusdatabasen er forældet.|";
            base_da_DK = base_da_DK + "Scan OneNote-filer|";
            base_da_DK = base_da_DK + "Scanning af billedfiler (grafik)|";
            base_da_DK = base_da_DK + "Registrer filer ved at beregne fuzzy hashes for billeder (grafik)|";
            base_da_DK = base_da_DK + "Opret midlertidige filer til indlejrede filscanninger, der ellers kun ville være i hukommelsen|";
// clamd.conf
            base_da_DK = base_da_DK + "Gem alle rapporter i en logfil. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Som standard er logfilen låst til skrivning, og kun en enkelt dæmonproces kan skrive til den. Denne mulighed deaktiverer låsen. Standard: nej|";
            base_da_DK = base_da_DK + "Maksimal størrelse af logfilen. Værdi på 0 deaktiverer grænsen. Standard: 1048576|";
            base_da_DK = base_da_DK + "Logtid for hver besked. Standard: nej|";
            base_da_DK = base_da_DK + "Log alle rene filer. Nyttigt ved fejlfinding, men øger logstørrelsen drastisk. Standard: nej|";
            base_da_DK = base_da_DK + "Brug systemloggeren (kan fungere sammen med LogFile). Standard: nej|";
            base_da_DK = base_da_DK + "Type syslog-meddelelser. Se venligst 'man syslog' for facilitetsnavne. (LOG_LOCAL6, LOG_MAIL), Standard: LOG_LOCAL6|";
            base_da_DK = base_da_DK + "Aktiver detaljeret logning. Standard: nej|";
            base_da_DK = base_da_DK + "Roter logfil. Kræver LogFileMaxSize-indstilling forud for denne indstilling. Standard: nej|";
            base_da_DK = base_da_DK + "Log yderligere oplysninger om den inficerede fil, såsom dens størrelse og hash, sammen med virusnavnet. Standard: nej|";
            base_da_DK = base_da_DK + "Skriv dæmonens pid til den angivne fil. Standard: disabled|";
            base_da_DK = base_da_DK + "Denne mulighed giver dig mulighed for at ændre den midlertidige standardmappe. Standard: /tmp|";
            base_da_DK = base_da_DK + "Denne mulighed giver dig mulighed for at ændre standarddatabasebiblioteket. Hvis du aktiverer det, skal du sørge for, at det peger på det samme bibliotek i både clamd og freshclam. Standard: /usr/local/share/clamav|";
            base_da_DK = base_da_DK + "Indlæs kun de officielle signaturer udgivet af ClamAV-projektet. Standard: nej|";
            base_da_DK = base_da_DK + "Retur med en fejlkode, der ikke er nul, hvis virusdatabasen er ældre end det angivne antal dage. Standard: -1|";
            base_da_DK = base_da_DK + "Sti til en lokal (Unix) socket dæmonen vil lytte på. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Indstiller gruppeejerskabet på unix-socket. Standard: |";
            base_da_DK = base_da_DK + "Sætter tilladelserne på unix-socket til den angivne tilstand. Standard: 660|";
            base_da_DK = base_da_DK + "Fjern forældet sokkel efter uren nedlukning. Standard: yes|";
            base_da_DK = base_da_DK + "TCP-portnummer dæmonen vil lytte på. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Som standard binder clamd til INADDR_ANY. Denne mulighed giver dig mulighed for at begrænse TCP-adressen og give en vis grad af beskyttelse fra omverdenen. Denne mulighed kan specificeres flere gange for at lytte på flere IP'er. IPv6 er nu understøttet. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Maksimal længde køen af ​​afventende forbindelser kan vokse til. Standard: 200|";
            base_da_DK = base_da_DK + "Luk STREAM-sessionen, når datastørrelsesgrænsen er overskredet. Værdien bør matche din MTA's grænse for den maksimale vedhæftede filstørrelse. Standard: 100M|";
            base_da_DK = base_da_DK + "STREAM-kommandoen bruger en FTP-lignende protokol. Denne indstilling sætter den nedre grænse for portområdet. Standard: 1024|";
            base_da_DK = base_da_DK + "Denne indstilling sætter den øvre grænse for portområdet. Standard: 2048|";
            base_da_DK = base_da_DK + "Maksimalt antal tråde, der kører på samme tid. Standard: 10|";
            base_da_DK = base_da_DK + "Denne indstilling angiver den tid (i sekunder), hvorefter clamd skal timeout, hvis en klient ikke leverer nogen data. Standard: 120|";
            base_da_DK = base_da_DK + "Denne indstilling specificerer tiden (i sekunder), hvorefter clamd skal timeout, hvis en klient ikke giver nogen indledende kommando efter tilslutning. Standarden er sat til 30 for at undgå timeouts med TCP-sockets ved behandling af store meddelelser. Hvis du bruger en Unix-socket, kan værdien ændres til 5, og efterfølgende kommandoer er specificeret for data eller timeouts ved hjælp af timeouts. ReadTimeout. Standard: 30|";
            base_da_DK = base_da_DK + "Denne indstilling angiver, hvor længe der skal ventes (i millisekunder), hvis sendebufferen er fuld. Hold denne værdi lav for at forhindre, at clamd hænger. Standard: 500|";
            base_da_DK = base_da_DK + "Maksimalt antal elementer i kø (inklusive dem, der behandles af MaxThreads-tråde). Det anbefales at have denne værdi mindst to gange MaxThreads, hvis det er muligt. ADVARSEL: du bør ikke øge dette for meget for at undgå at løbe tør for filbeskrivelser. RLIMIT_NOFILE RLIMIT_NOFILE er det maksimale antal åbne filbeskrivelser (normalt 1024), angivet af ulimit -n. Standard: 100|";
            base_da_DK = base_da_DK + "Denne indstilling angiver, hvor længe (i sekunder) processen skal vente på et nyt job. Standard: 30|";
            base_da_DK = base_da_DK + "Scan ikke filer og mapper, der matcher REGEX. Dette direktiv kan bruges flere gange. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Maksimal dybde mapper scannes på. Standard: 15|";
            base_da_DK = base_da_DK + "Følg mappesymlinks. Standard: nej|";
            base_da_DK = base_da_DK + "Scan filer og mapper på andre filsystemer. Standard: yes|";
            base_da_DK = base_da_DK + "Følg almindelige fil-symlinks. Standard: nej|";
            base_da_DK = base_da_DK + "Denne indstilling specificerer tidsintervallerne (i sekunder), hvori clamd skal udføre en databasekontrol. Standard: 600|";
            base_da_DK = base_da_DK + "Aktiver ikke-blokerende (multi-threaded/samtidige) databasegenindlæsninger. Denne funktion indlæser midlertidigt en anden scanningsmotor, mens scanningen fortsætter med at bruge den første motor. Når den er indlæst, overtager den nye motor. Den gamle motor fjernes, så snart alle scanninger, der bruger den gamle motor, er fuldført. Denne funktion kræver, at brugerne genindlæser i tilfælde af RAM, så denne mulighed skal genindlæses under RAM. i bytte for lavere RAM-krav Standard: ja|";
            base_da_DK = base_da_DK + "Udfør en kommando, når virus er fundet. Brug følgende miljøvariabler til at identificere fil- og virusnavne: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME I kommandostrengen vil '%v' også blive erstattet med virusnavnet. Bemærk: \"Tegnet \"filnavnet\" vil ikke længere være blevet deaktiveret, og filnavnet \"%f\" vil ikke længere være deaktiveret. på grund af sikkerhedsproblemer med kommandoen. Brug miljøvariablen 'CLAVIRUSEVENT_FILENAME'. Af samme grund bør du IKKE bruge miljøvariablerne i kommandoen, men bruge den omhyggeligt fra dit udførte script.|";
            base_da_DK = base_da_DK + "Stop dæmon når libclamav rapporterer uden hukommelse. Standard: nej|";
            base_da_DK = base_da_DK + "Tillad brug af ALLMATCHSCAN-kommandoen. Standard: yes|";
            base_da_DK = base_da_DK + "Forkast ikke i baggrunden. Standard: nej|";
            base_da_DK = base_da_DK + "Aktiver fejlretningsmeddelelser fra libclamav. Standard: nej|";
            base_da_DK = base_da_DK + "Fjern ikke midlertidige filer (til fejlretningsformål). Standard: nej GenerateMetadataJson BOOL Optag metadata om filen, der scannes. Scanningsmetadata er nyttige til filanalyseformål og til fejlfinding af scanningsadfærd. JSON-metadataene vil blive udskrevet, efter scanningen er fuldført, hvis Debug-filen kan skrives til temp. mappe hvis LeaveTemporaryFiles er aktiveret Standard: nej|";
            base_da_DK = base_da_DK + "Kør dæmonen som en specificeret bruger (processen skal startes af root). Standard: disabled|";
            base_da_DK = base_da_DK + "Med denne mulighed aktiveret vil ClamAV indlæse bytekode fra databasen. Det anbefales stærkt, at du holder denne indstilling slået til, ellers kan du gå glip af registreringer for mange nye vira. Standard: ja|";
            base_da_DK = base_da_DK + "Indstil bytekode sikkerhedsniveau. Mulige værdier: TrustSigned - trust bytecode indlæst fra signerede .c[lv]d filer og indsæt runtime sikkerhedstjek for bytekode indlæst fra andre kilder, Paranoid - stol ikke på nogen bytecode, indsæt runtime checks for all TrustteSigned, insert runtime checks for all. har allerede disse kontroller (TrustSigned, Paranoid) Standard: TrustSigned|";
            base_da_DK = base_da_DK + "Sæt bytekode timeout i millisekunder. Standard: 10000|";
            base_da_DK = base_da_DK + "Tillad indlæsning af bytekode udefra digitalt signerede .c[lv]d-filer. **Forsigtig**: Du bør ALDRIG køre bytekodesignaturer fra ikke-pålidelige kilder. Hvis du gør det, kan det resultere i vilkårlig kodeudførelse. Standard: nej|";
            base_da_DK = base_da_DK + "Indstil bytecode execution mode. Mulige værdier: Auto - vælg automatisk JIT hvis muligt, fallback til tolk ForceJIT - vælg altid JIT, fail hvis ikke muligt ForceInterpreter - vælg altid tolk Test - kør med både JIT og tolk og sammenlign resultater. Gør alle fejl fatale. Standard: Auto|";
            base_da_DK = base_da_DK + "Detekter muligvis uønskede applikationer. Standard: nej|";
            base_da_DK = base_da_DK + "Ekskluder en specifik PUA-kategori. Dette direktiv kan bruges flere gange. Se https://docs.clamav.net/faq/faq-pua.html for den komplette liste over PUA-kategorier. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Inkluder kun en specifik PUA-kategori. Dette direktiv kan bruges flere gange. Se https://docs.clamav.net/faq/faq-pua.html for den komplette liste over PUA-kategorier. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "I nogle tilfælde (f.eks. kompleks malware, udnyttelser i grafiske filer og andre), bruger ClamAV specielle algoritmer til at give nøjagtig detektion. Denne mulighed styrer den algoritmiske detektion. Standard: yes|";
            base_da_DK = base_da_DK + "Tillad, at heuristisk match har forrang. Når den er aktiveret, hvis en heuristisk scanning (såsom phishingScan) registrerer en mulig virus/phishing, stopper den med at scanne med det samme. Anbefales, sparer CPU-scanningstid. Når den er deaktiveret, vil virus/phishing, der kun er detekteret af en heuristisk scanning, blive rapporteret i slutningen af ​​en scanning. både en heuristisk detekteret virus/phishing og en ægte malware, vil den rigtige malware blive rapporteret, hvis du har til hensigt at håndtere \"*.Heuristics.*\" virus anderledes end \"rigtig\" malware.|";
            base_da_DK = base_da_DK + "PE står for Portable Executable - det er et eksekverbart filformat, der bruges i alle 32- og 64-bit versioner af Windows-operativsystemer. Denne mulighed giver ClamAV mulighed for at udføre en dybere analyse af eksekverbare filer, og det er også påkrævet til dekomprimering af populære eksekverbare pakker såsom UPX. Hvis du deaktiverer denne mulighed, vil den originale scanning stadig blive slået fra uden yderligere scanning. Standard: ja|";
            base_da_DK = base_da_DK + "Executable and Linking Format er et standardformat for UN*X eksekverbare filer. Denne mulighed giver dig mulighed for at kontrollere scanningen af ​​ELF-filer. Hvis du slår denne mulighed fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Aktiver scanning af mailfiler. Hvis du slår denne mulighed fra, vil de originale filer stadig blive scannet, men uden at parse individuelle meddelelser/vedhæftede filer. Standard: ja|";
            base_da_DK = base_da_DK + "Scan RFC1341-meddelelser opdelt over mange e-mails. Du skal med jævne mellemrum rydde op i $TemporaryDirectory/clamav-partial bibliotek. ADVARSEL: Denne mulighed kan åbne dit system for et DoS-angreb. Brug det aldrig på indlæste servere. Standard: nej|";
            base_da_DK = base_da_DK + "Aktiver e-mailsignatur-baseret phishing-detektion. Standard: yes|";
            base_da_DK = base_da_DK + "Aktiver URL-signaturbaseret phishing-detektion (Heuristics.Phishing.Email.*) Standard: yes|";
            base_da_DK = base_da_DK + "Aktiver DLP-modulet. Standard: nej|";
            base_da_DK = base_da_DK + "Denne mulighed indstiller det laveste antal kreditkortnumre fundet i en fil til at generere en detektering. Standard: 3|";
            base_da_DK = base_da_DK + "Med denne mulighed aktiveret vil DLP-modulet kun søge efter gyldige kreditkortnumre. Debet- og Private Label-kort vil ikke blive søgt. Standard: nej|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller det laveste antal CPR-numre fundet i en fil til at generere en detektion. Standard: 3|";
            base_da_DK = base_da_DK + "Med denne indstilling aktiveret vil DLP-modulet søge efter gyldige SSN'er formateret som xxx-yy-zzzz. Standard: yes|";
            base_da_DK = base_da_DK + "Med denne indstilling aktiveret vil DLP-modulet søge efter gyldige SSN'er formateret som xxxyyzzzz. Standard: nej|";
            base_da_DK = base_da_DK + "Udfør HTML/JavaScript/ScriptEncoder normalisering og dekryptering. Hvis du slår denne mulighed fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Denne mulighed aktiverer scanning af OLE2-filer, såsom Microsoft Office-dokumenter og .msi-filer. Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Denne mulighed aktiverer scanning i PDF-filer. Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: yes|";
            base_da_DK = base_da_DK + "Denne mulighed aktiverer scanning i SWF-filer. Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden afkodning og yderligere behandling. Standard: yes|";
            base_da_DK = base_da_DK + "Denne mulighed gør det muligt at scanne xml-baserede dokumentfiler understøttet af libclamav. Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Denne mulighed gør det muligt at scanne HWP3-filer. Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Denne mulighed gør det muligt at scanne OneNote-filer. Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Scan i arkiver og komprimerede filer. Hvis du slår denne mulighed fra, vil de originale filer stadig blive scannet, men uden udpakning og yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Denne mulighed aktiverer scanning af billede (grafik). Hvis du slår denne indstilling fra, vil de originale filer stadig blive scannet, men uden udpakning og yderligere behandling. Standard: ja|";
            base_da_DK = base_da_DK + "Denne mulighed aktiverer detektion ved at beregne en fuzzy hash af billedfiler (grafikfiler). Signaturer, der bruger billedfuzzy hashes, matcher typisk filer og dokumenter ved at identificere billeder, der er indlejret eller vedhæftet til disse filer. Hvis du slår denne mulighed fra, kan nogle filer muligvis ikke længere registreres. Standard: ja|";
            base_da_DK = base_da_DK + "Advarsel om ødelagte eksekverbare filer (PE & ELF). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om ødelagte grafikfiler (JPEG, TIFF, PNG, GIF). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om krypterede arkiver og dokumenter (krypteret .zip, .7zip, .rar, .pdf). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om krypterede arkiver (krypteret .zip, .7zip, .rar). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om krypterede dokumenter (krypteret .pdf). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om OLE2-filer, der indeholder VBA-makroer (Heuristics.OLE2.ContainsMacros). Standard: nej|";
            base_da_DK = base_da_DK + "Når AlertExceedsMax er indstillet, vil filer, der overskrider MaxFileSize-, MaxScanSize- eller MaxRecursion-grænsen, blive markeret med virusnavnet, der starter med \"Heuristics.Limits.Exceeded\". Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om e-mails, der indeholder SSL-uoverensstemmelser i URL'er (kan føre til falske positiver!). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om e-mails, der indeholder tilslørede URL'er (kan føre til nogle falske positiver). Standard: nej|";
            base_da_DK = base_da_DK + "Advarsel om rå DMG-billedfiler, der indeholder partitionskryds. Standard: nej|";
            base_da_DK = base_da_DK + "Denne mulighed giver dig mulighed for at deaktivere motorens cachefunktion. Som standard vil motoren gemme en MD5 i en cache af alle filer, der ikke er markeret som virus eller som hit begrænser kontrol. Advarsel: Deaktivering af cachen vil have en negativ effekt på ydeevnen på store scanninger. Standard: nej|";
            base_da_DK = base_da_DK + "Denne mulighed giver dig mulighed for at indstille antallet af poster, som cachen kan gemme. Værdien skal være et kvadrattal eller vil blive rundet op til nærmeste kvadrattal. Standard: 65536|";
            base_da_DK = base_da_DK + "Denne mulighed får hukommelses- eller indlejrede kortscanninger til at dumpe indholdet til disken. Hvis du slår denne mulighed til, skrives flere data til disken og er tilgængelig, når muligheden for leave-temps er aktiveret på bekostning af flere diskskrivninger. Standard: nej|";
            base_da_DK = base_da_DK + "Denne indstilling angiver den maksimale tid, en scanning kan tage at fuldføre. Værdien er i millisekunder. Værdien 0 deaktiverer grænsen. ADVARSEL: Deaktivering af denne grænse eller indstilling for høj kan resultere i, at scanning af visse filer kan låse scanningsprocessen/trådene, hvilket resulterer i et Denial of Service: 12000|";
            base_da_DK = base_da_DK + "Indstiller den maksimale mængde data, der skal scannes for hver inputfil. Arkiver og andre beholdere udtrækkes rekursivt og scannes op til denne værdi. Størrelsen af ​​et arkiv plus summen af ​​størrelserne af alle filer i arkivet tæller med i scanningsstørrelsen. For eksempel, et 1M ukomprimeret enkelt arkiv til 1M max. scanningsstørrelse Advarsel: Deaktivering af denne grænse eller indstilling for høj kan resultere i alvorlig skade på systemet.|";
            base_da_DK = base_da_DK + "Filer, der er større end denne grænse, vil ikke blive scannet. Påvirker selve inputfilen såvel som filer indeholdt i den (når inputfilen er et arkiv, et dokument eller en anden form for container). Advarsel: Deaktivering af denne grænse eller indstilling for høj kan resultere i alvorlig skade på systemet. Tekniske designbegrænsninger fra scanning af 2maV-filer forhindrer denne standardtid. 100M|";
            base_da_DK = base_da_DK + "Indlejrede arkiver scannes rekursivt, f.eks. hvis et Zip-arkiv indeholder en RAR-fil, vil alle filer i den også blive scannet. Denne indstilling angiver, hvor dybt processen skal fortsættes. Advarsel: Hvis denne grænse indstilles for højt, kan det resultere i alvorlig skade på systemet\": 17|";
            base_da_DK = base_da_DK + "Antal filer, der skal scannes i et arkiv, et dokument eller enhver anden form for container. Advarsel: Deaktivering af denne grænse eller indstilling for høj kan resultere i alvorlig skade på systemet. Standard: 10000|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller den maksimale størrelse på en fil for at kontrollere for indlejret PE. Filer større end denne værdi vil springe det yderligere analysetrin over. Negative værdier er ikke tilladt. Standard: 40M|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller den maksimale størrelse af en HTML-fil til normalisering. HTML-filer større end denne værdi vil ikke blive normaliseret eller scannet. Negative værdier er ikke tilladt. Standard: 40M|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller den maksimale størrelse af en normaliseret HTML-fil, der skal scannes. HTML-filer større end denne værdi efter normalisering vil ikke blive scannet. Negative værdier er ikke tilladt. Standard: 8M|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller den maksimale størrelse af en scriptfil til normalisering. Scriptindhold større end denne værdi vil ikke blive normaliseret eller scannet. Negative værdier er ikke tilladt. Standard: 20M|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller den maksimale størrelse af en ZIP-fil til at genanalysere typegenkendelse. ZIP-filer, der er større end denne værdi, vil springe trinnet over for potentielt at genanalysere som PE. Negative værdier er ikke tilladt. ADVARSEL: Hvis denne grænse indstilles for højt, kan det resultere i alvorlig skade eller påvirkningsydelse. Standard: 1M|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller det maksimale antal partitioner af et rå diskbillede, der skal scannes. Raw diskbilleder med flere partitioner end denne værdi vil have op til de scannede værdipartitioner. Negative værdier er ikke tilladt. ADVARSEL: Hvis denne grænse indstilles for højt, kan det resultere i alvorlige skader eller påvirkningsydelse. Standard: 50|";
            base_da_DK = base_da_DK + "Denne mulighed indstiller det maksimale antal ikoner inden for en PE, der skal scannes. PE-filer med flere ikoner end denne værdi vil have op til værdien antal ikoner scannet. Negative værdier er ikke tilladt. ADVARSEL: Hvis denne grænse indstilles for højt, kan det resultere i alvorlig skade eller stødydelse.|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller de maksimale rekursive opkald til HWP3-parsing-funktionen. HWP3-filer, der bruger mere end denne grænse, vil blive afsluttet og advare brugeren. Scanninger vil ikke være i stand til at scanne nogen HWP3-vedhæftede filer, hvis den rekursive grænse er nået. Negative værdier er ikke tilladt. ADVARSEL: kan resultere i alvorlige skader eller ydelse.|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller de maksimale kald til PCRE-matchfunktionen under en forekomst af regex-matching. Forekomster, der bruger mere end denne grænse, vil blive afsluttet og advare brugeren, men scanningen fortsætter. Se PCRE-dokumentationen for mere information om match_limit. Negative værdier er ikke tilladt. ADVARSEL: at sætte denne grænse for høj effekt:|0fault kan se.|";
            base_da_DK = base_da_DK + "Denne mulighed indstiller de maksimale rekursive kald til PCRE-matchfunktionen under en forekomst af regex-matching. Forekomster, der bruger mere end denne grænse, vil blive afsluttet og advare brugeren, men scanningen fortsætter. For mere information om match_limit_recursion, se PCRE-dokumentationen. Negative værdier er ikke tilladt, og grænseværdier er for høje .MatchLimit> PCRE-værdier er for høje. kan påvirke ydeevnen alvorligt. Standard: 2000|";
            base_da_DK = base_da_DK + "Denne indstilling indstiller den maksimale filstørrelse, for hvilken PCRE subsigs vil blive eksekveret. Filer, der overskrider denne grænse, vil ikke have PCRE subsigs eksekveret, medmindre en subsig er omfattet af en mindre buffer. Negative værdier er ikke tilladt. Indstilling af denne værdi til nul deaktiverer grænsen. ADVARSEL: indstilling af denne grænse kan påvirke ydelsen for høj eller deaktivere. 100M|";
            base_da_DK = base_da_DK + "Denne mulighed specificerer en mappe (inklusive alle filer og mapper i den), som skal scannes ved adgang. Denne mulighed kan bruges flere gange. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Denne mulighed tillader at ekskludere mapper fra scanning ved adgang. Den kan bruges flere gange. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Med denne mulighed kan du udelukke root-UID'et (0). Processer, der køres under root, vil være i stand til at få adgang til alle filer uden at udløse scanninger eller tilladelses nægtede hændelser. Bemærk, at hvis clamd ikke kan kontrollere uid'et for den proces, der genererede en on-access-scanningshændelse (f. OnAccessExcludeRootUID er ikke garanteret at forhindre enhver adgang fra root-brugeren i at udløse en scanning (medmindre OnAccessPrevention er aktiveret: nej|";
            base_da_DK = base_da_DK + "Med denne indstilling kan du udelukke specifikke UID'er. Processer med disse UID'er vil være i stand til at få adgang til alle filer uden at udløse scanninger eller tilladelses nægtede hændelser. Denne mulighed kan bruges flere gange (én pr. linje). Bemærk: Brug af en værdi på 0 på en linje vil deaktivere denne mulighed helt. For at udelukke root-UID'et, skal du også ikke Acceptere det Onoot-ID (0) clamd kan ikke kontrollere uid'et for den proces, der genererede en on-access scanningshændelse (f.eks. fordi OnAccessPrevention ikke var aktiveret, og processen allerede er afsluttet), vil clamd udføre en scanning. Indstilling af OnAccessExcludeUID er derfor ikke garanteret at forhindre enhver adgang fra den angivne uid i at udløse en scanning (medmindre OnAccessPrevention er slået til.|";
            base_da_DK = base_da_DK + "Denne mulighed tillader ekskluderinger via brugernavne, når du bruger scanningsklienten ved adgang. Den kan bruges flere gange og har de samme potentielle begrænsninger for racetilstanden som OnAccessExcludeUID-indstillingen. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Filer større end denne værdi vil ikke blive scannet ind ved adgang. Standard: 5M|";
            base_da_DK = base_da_DK + "Maksimalt antal scanningstråde, der skal allokeres til OnAccess-trådpuljen ved opstart. Disse tråde er dem, der er ansvarlige for at skabe en forbindelse med dæmonen og starte scanningen efter en hændelse er blevet behandlet. For at forhindre clamonacc i at forbruge alle clamds ressourcer, hold dette lavere end clamds ressourcer.|";
            base_da_DK = base_da_DK + "Maks. tid (i millisekunder), som OnAccess-klienten skal bruge for hvert forsøg på at forbinde, sende og modtage, når der kommunikeres med clamd via curl. Standard: 5000 (5 sekunder)|";
            base_da_DK = base_da_DK + "Specificerer et monteringspunkt (inklusive alle filer og mapper under det), som skal scannes ved adgang. Denne mulighed kan bruges flere gange. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Deaktiverer det dynamiske biblioteksbestemmelsessystem, som giver mulighed for rekursiv overvågning af inkluderede stier. Standard: nej|";
            base_da_DK = base_da_DK + "Aktiverer fanotify-blokering, når der findes skadelige filer. Standard: deaktiveret|";
            base_da_DK = base_da_DK + "Antal gange OnAccess-klienten vil prøve en mislykket scanning igen på grund af forbindelsesproblemer (eller andre problemer). Standard: 0|";
            base_da_DK = base_da_DK + "Når du bruger forebyggelse, hvis denne mulighed er slået til, vil eventuelle fejl, der opstår under scanning, resultere i, at hændelsesforsøget afvises. Dette kan potentielt føre til uønsket systemadfærd med visse konfigurationer, så klienten sætter dette som standard til fra og foretrækker at tillade adgangsbegivenheder i tilfælde af scannings- eller forbindelsesfejl. Standard: nej|";
            base_da_DK = base_da_DK + "Skifter ekstra scanning og meddelelser, når en fil eller mappe oprettes eller flyttes. Kræver DDD-systemet for at starte ekstra scanninger. Standard: nej|";
            base_da_DK = base_da_DK + "Deaktiver verifikation af autentikode-certifikatkæde i PE-filer. Standard: nej|";
            base_da_DK = base_da_DK + "Gem html-URI'er i metadata. URI'er vil blive skrevet til filen metadata.json i et array kaldet 'URI'er'.|";
            base_da_DK = base_da_DK + "Gem pdf-URI'er i metadata. URI'er vil blive skrevet til filen metadata.json i et array kaldet 'URI'er'.|";
            base_da_DK = base_da_DK + "Gem md5 og sha1 ud over sha2-256 i metadata.|";
            base_da_DK = base_da_DK + "Udskriv filhashen efter hver scannet fil.|";
            base_da_DK = base_da_DK + "Udskriv filtypen efter hver scannet fil.|";
            base_da_DK = base_da_DK + "Håndhæv FIPS-lignende grænser for brug af hash-algoritmer til kryptografiske formål. Deaktiverer MD5 og SHA1. PHP underskriver og vil kræve '.sign'-filer for at bekræfte CVD-ægtheden.";

// translations fr_FR
    QString base_fr_FR = "Sois communicatif|";
            base_fr_FR = base_fr_FR + "Afficher les fichiers dans les archives|";
            base_fr_FR = base_fr_FR + "Activer les messages de débogage de libclamav|";
            base_fr_FR = base_fr_FR + "N'afficher que les messages d'erreur|";
            base_fr_FR = base_fr_FR + "Écrire dans stdout au lieu de stderr. Ne concerne pas les messages 'debug'.|";
            base_fr_FR = base_fr_FR + "Désactiver le résumé de l'analyse à la fin du processus d'analyse|";
            base_fr_FR = base_fr_FR + "N'afficher que les fichiers infectés|";
            base_fr_FR = base_fr_FR + "Saute la sortie des fichiers OK|";
            base_fr_FR = base_fr_FR + "Sonnerie en cas de détection de virus|";
            base_fr_FR = base_fr_FR + "Ne pas supprimer les fichiers temporaires|";
            base_fr_FR = base_fr_FR + "Crée une description JSON des fichiers scannés. Le JSON est produit et aussi-|";
            base_fr_FR = base_fr_FR + "Ne charger que les signatures officielles|";
            base_fr_FR = base_fr_FR + "Scanne les sous-répertoires de manière récursive|";
            base_fr_FR = base_fr_FR + "Poursuivre l'analyse du fichier lorsqu'une réponse positive est obtenue.|";
            base_fr_FR = base_fr_FR + "Analyse des fichiers et des répertoires sur d'autres systèmes de fichiers|";
            base_fr_FR = base_fr_FR + "Supprimer les fichiers infectés. Soyez prudent !|";
            base_fr_FR = base_fr_FR + "Chargez le bytecode non signé. **Attention** : Vous ne devez JAMAIS exécuter de signatures de bytecode provenant de sources non fiables. Cela pourrait entraîner l’exécution de code arbitraire.|";
            base_fr_FR = base_fr_FR + "Détecte les applications probablement indésirables|";
            base_fr_FR = base_fr_FR + "Reconnaître les données structurées (SSN, carte de crédit)|";
            base_fr_FR = base_fr_FR + "Scanner les fichiers de messagerie|";
            base_fr_FR = base_fr_FR + "Activer la détection du phishing avec les signatures d'e-mail|";
            base_fr_FR = base_fr_FR + "Activer la signature URL et la détection du phishing|";
            base_fr_FR = base_fr_FR + "Alertes heuristiques|";
            base_fr_FR = base_fr_FR + "Arrêtez la recherche dès qu'une correspondance heuristique est trouvée.|";
            base_fr_FR = base_fr_FR + "Normaliser les fichiers HTML, les scripts et les fichiers texte. Utilisez normalize=no pour la compatibilité avec Yara|";
            base_fr_FR = base_fr_FR + "Scanner des fichiers PE|";
            base_fr_FR = base_fr_FR + "Scanner des fichiers ELF|";
            base_fr_FR = base_fr_FR + "Scanner un conteneur OLE2|";
            base_fr_FR = base_fr_FR + "Scanner des fichiers PDF|";
            base_fr_FR = base_fr_FR + "Scanner des fichiers SWF|";
            base_fr_FR = base_fr_FR + "Scanner des fichiers HTML|";
            base_fr_FR = base_fr_FR + "scanner des fichiers de documents basés sur xml|";
            base_fr_FR = base_fr_FR + "Scanner des fichiers HWP3|";
            base_fr_FR = base_fr_FR + "Numérisation de fichiers d'archive (prise en charge par libclamav)|";
            base_fr_FR = base_fr_FR + "Alerte aux fichiers exécutables défectueux (PE & ELF)|";
            base_fr_FR = base_fr_FR + "Avertissement en cas de fichiers graphiques défectueux (JPEG, TIFF, PNG, GIF)|";
            base_fr_FR = base_fr_FR + "Avertissement sur les archives et documents cryptés|";
            base_fr_FR = base_fr_FR + "Avertissement sur les archives cryptées|";
            base_fr_FR = base_fr_FR + "Avertissement pour les documents cryptés|";
            base_fr_FR = base_fr_FR + "Avertissement concernant les fichiers OLE2 contenant des macros VBA|";
            base_fr_FR = base_fr_FR + "Avertissement pour les fichiers dépassant la taille maximale du fichier, la taille maximale de l'analyse ou la limite maximale de récursivité|";
            base_fr_FR = base_fr_FR + "Avertissement pour les e-mails contenant des URL mal adaptées au protocole SSL|";
            base_fr_FR = base_fr_FR + "Avertissement pour les e-mails contenant des URL déguisées|";
            base_fr_FR = base_fr_FR + "Avertissement pour les fichiers image DMG bruts contenant des chevauchements de partitions|";
            base_fr_FR = base_fr_FR + "Désactiver la vérification de la chaîne de certificats Authenticode dans les fichiers PE|";
            base_fr_FR = base_fr_FR + "Dump de la chaîne de certificats Authenticode dans les fichiers PE|";
            base_fr_FR = base_fr_FR + "Désactiver la mise en cache et les contrôles de cache pour les sommes de hachage des fichiers analysés.|";
// new with version 1.4.2 of clamav
            base_fr_FR = base_fr_FR + "Créer des fichiers temporaires pour les analyses de fichiers imbriqués qui, autrement, seraient uniquement en mémoire.|";
            base_fr_FR = base_fr_FR + "Générer des métadonnées JSON pour le(s) fichier(s) numérisé(s). A utiliser UNIQUEMENT pour les tests et le développement.|";
            base_fr_FR = base_fr_FR + "Retourne un code d'erreur non nul si la base de données virale est obsolète.|";
            base_fr_FR = base_fr_FR + "Numériser des fichiers OneNote|";
            base_fr_FR = base_fr_FR + "Numériser des fichiers d'images (graphiques)|";
            base_fr_FR = base_fr_FR + "Détecter les fichiers en calculant les hachages flous des images (graphiques)|";
            base_fr_FR = base_fr_FR + "Créer des fichiers temporaires pour les analyses de fichiers imbriqués qui, autrement, seraient uniquement en mémoire.|";
// clamd.conf
            base_fr_FR = base_fr_FR + "Enregistrer tous les rapports dans un fichier journal. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Par défaut, le fichier journal est verrouillé en écriture et un seul processus démon peut y écrire. Cette option désactive le verrouillage. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Taille maximale du fichier journal. La valeur 0 désactive la limite. Par défaut : 1048576|";
            base_fr_FR = base_fr_FR + "Heure d'enregistrement de chaque message. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Enregistrer tous les fichiers propres. Utile pour le débogage mais augmente considérablement la taille du journal. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Utiliser le journal système (peut fonctionner avec LogFile). Par défaut : non|";
            base_fr_FR = base_fr_FR + "Type de messages syslog. Veuillez vous référer à 'man syslog' pour les noms d'installation. (LOG_LOCAL6, LOG_MAIL), par défaut : LOG_LOCAL6|";
            base_fr_FR = base_fr_FR + "Activer la journalisation détaillée. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Faire pivoter le fichier journal. Nécessite que l'option LogFileMaxSize soit définie avant cette option. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Enregistrer des informations supplémentaires sur le fichier infecté, telles que sa taille et son hachage, ainsi que le nom du virus. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Écrire le PID du démon dans le fichier spécifié. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Cette option vous permet de modifier le répertoire temporaire par défaut. Par défaut : /tmp|";
            base_fr_FR = base_fr_FR + "Cette option vous permet de modifier le répertoire de base de données par défaut. Si vous l'activez, assurez-vous qu'il pointe vers le même répertoire dans clamd et freshclam. Par défaut : /usr/local/share/clamav|";
            base_fr_FR = base_fr_FR + "Charger uniquement les signatures officielles publiées par le projet ClamAV. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Renvoyer un code d'erreur différent de zéro si la base de données virale est plus ancienne que le nombre de jours spécifié. Par défaut : -1|";
            base_fr_FR = base_fr_FR + "Chemin vers un socket local (Unix) sur lequel le démon écoutera. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Définit la propriété du groupe sur le socket Unix. Par défaut : |";
            base_fr_FR = base_fr_FR + "Définit les permissions sur le socket Unix sur le mode spécifié. Par défaut : 660|";
            base_fr_FR = base_fr_FR + "Supprime le socket obsolète après un arrêt incorrect. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Numéro de port TCP sur lequel le démon écoutera. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Par défaut, clamd se lie à INADDR_ANY. Cette option vous permet de restreindre l'adresse TCP et de fournir un certain degré de protection contre le monde extérieur. Cette option peut être spécifiée plusieurs fois afin d'écouter sur plusieurs IP. IPv6 est désormais pris en charge. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Longueur maximale de la file d'attente des connexions en attente. Par défaut : 200|";
            base_fr_FR = base_fr_FR + "Fermer la session STREAM lorsque la limite de taille des données est dépassée. La valeur doit correspondre à la limite de votre MTA pour la taille maximale des pièces jointes. Par défaut : 100 M|";
            base_fr_FR = base_fr_FR + "La commande STREAM utilise un protocole de type FTP. Cette option définit la limite inférieure de la plage de ports. Par défaut : 1 024|";
            base_fr_FR = base_fr_FR + "Cette option définit la limite supérieure de la plage de ports. Par défaut : 2 048|";
            base_fr_FR = base_fr_FR + "Nombre maximal de threads exécutés en même temps. Par défaut : 10|";
            base_fr_FR = base_fr_FR + "Cette option spécifie le temps (en secondes) après lequel clamd doit expirer si un client ne fournit aucune donnée. Par défaut : 120|";
            base_fr_FR = base_fr_FR + "Cette option spécifie le temps (en secondes) après lequel clamd doit expirer si un client ne fournit aucune commande initiale après la connexion. La valeur par défaut est définie sur 30 pour éviter les dépassements de délai avec les sockets TCP lors du traitement de messages volumineux. Si vous utilisez un socket Unix, la valeur peut être modifiée à 5. Remarque : le délai d'expiration des commandes suivantes et/ou des blocs de données est spécifié par ReadTimeout. Par défaut : 30|";
            base_fr_FR = base_fr_FR + "Cette option spécifie la durée d'attente (en millisecondes) si le tampon d'envoi est plein. Gardez cette valeur basse pour éviter que clamd ne se bloque. Par défaut : 500|";
            base_fr_FR = base_fr_FR + "Nombre maximal d'éléments en file d'attente (y compris ceux traités par les threads MaxThreads). Il est recommandé d'avoir cette valeur au moins deux fois supérieure à MaxThreads si possible. AVERTISSEMENT : vous ne devez pas trop augmenter cette valeur pour éviter de manquer de descripteurs de fichiers, la condition suivante doit être respectée : MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE. RLIMIT_NOFILE est le nombre maximal de descripteurs de fichiers ouverts (généralement 1024), défini par ulimit -n. Par défaut : 100|";
            base_fr_FR = base_fr_FR + "Cette option spécifie combien de temps (en secondes) le processus doit attendre un nouveau travail. Par défaut : 30|";
            base_fr_FR = base_fr_FR + "Ne pas analyser les fichiers et répertoires correspondant à REGEX. Cette directive peut être utilisée plusieurs fois. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Profondeur maximale à laquelle les répertoires sont scannés. Par défaut : 15|";
            base_fr_FR = base_fr_FR + "Suivre les liens symboliques des répertoires. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Analyser les fichiers et les répertoires sur d'autres systèmes de fichiers. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Suivre les liens symboliques des fichiers habituels. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Cette option spécifie les intervalles de temps (en secondes) dans lesquels clamd doit effectuer une vérification de la base de données. Par défaut : 600|";
            base_fr_FR = base_fr_FR + "Activer les rechargements de base de données non bloquants (multithread/concurrents). Cette fonctionnalité chargera temporairement un deuxième moteur d'analyse pendant que l'analyse continue à l'aide du premier moteur. Une fois chargé, le nouveau moteur prend le relais. L'ancien moteur est supprimé dès que toutes les analyses utilisant l'ancien moteur sont terminées. Cette fonctionnalité nécessite plus de RAM, cette option est donc fournie au cas où les utilisateurs seraient prêts à bloquer les analyses pendant le rechargement en échange de besoins en RAM inférieurs. Par défaut : oui | ";
            base_fr_FR = base_fr_FR + "Exécutez une commande lorsqu'un virus est détecté. Utilisez les variables d'environnement suivantes pour identifier les noms de fichier et de virus : - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME Dans la chaîne de commande, '%v' sera également remplacé par le nom du virus. Remarque : le caractère de format de nom de fichier '%f' a été désactivé et ne sera plus remplacé par le nom de fichier, en raison de problèmes de sécurité liés à l'injection de commandes. Utilisez plutôt la variable d'environnement 'CLAVIRUSEVENT_FILENAME'. Pour la même raison, vous ne devez PAS utiliser les variables d'environnement directement dans la commande, mais les utiliser avec précaution à partir de votre script exécuté. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Arrêtez le démon lorsque libclamav signale une condition de mémoire insuffisante. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Autorisez l'utilisation de la commande ALLMATCHSCAN. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Ne pas passer en arrière-plan. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Activer les messages de débogage de libclamav. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Ne pas supprimer les fichiers temporaires (à des fins de débogage). Par défaut : no GenerateMetadataJson BOOL Enregistrer les métadonnées sur le fichier en cours d'analyse. Les métadonnées d'analyse sont utiles à des fins d'analyse de fichiers et pour déboguer le comportement d'analyse. Les métadonnées JSON seront imprimées une fois l'analyse terminée si Debug est activé. Un fichier metadata.json sera écrit dans le répertoire temporaire d'analyse si LeaveTemporaryFiles est activé. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Exécuter le démon en tant qu'utilisateur spécifié (le processus doit être démarré par root). Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Avec cette option activée, ClamAV chargera le bytecode à partir de la base de données. Il est fortement recommandé de garder cette option activée, sinon vous risquez de manquer des détections pour de nombreux nouveaux virus. Par défaut : yes|";
            base_fr_FR = base_fr_FR + "Définir le niveau de sécurité du bytecode. Valeurs possibles : TrustSigned - faire confiance au bytecode chargé à partir de fichiers .c[lv]d signés et insérer des contrôles de sécurité d'exécution pour le bytecode chargé à partir d'autres sources, Paranoid - ne faire confiance à aucun bytecode, insérer des contrôles d'exécution pour tous. Recommandé : TrustSigned, car le bytecode dans les fichiers .cvd possède déjà ces contrôles. (TrustSigned, Paranoid) Par défaut : TrustSigned|";
            base_fr_FR = base_fr_FR + "Définir le délai d'expiration du bytecode en millisecondes. Par défaut : 10000|";
            base_fr_FR = base_fr_FR + "Autoriser le chargement de bytecode à partir de fichiers .c[lv]d signés numériquement en dehors de la base. **Attention** : vous ne devez JAMAIS exécuter de signatures de bytecode à partir de sources non fiables. Cela pourrait entraîner l'exécution de code arbitraire. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Définir le mode d'exécution du bytecode. Valeurs possibles : Auto - choisir automatiquement JIT si possible, revenir à l'interpréteur ForceJIT - toujours choisir JIT, échouer si ce n'est pas possible ForceInterpreter - toujours choisir l'interpréteur Test - exécuter avec JIT et l'interpréteur et comparer les résultats. Rendre tous les échecs fatals. Par défaut : Auto|";
            base_fr_FR = base_fr_FR + "Détecter les applications potentiellement indésirables. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Exclure une catégorie PUA spécifique. Cette directive peut être utilisée plusieurs fois. Voir https://docs.clamav.net/faq/faq-pua.html pour la liste complète des catégories PUA. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Inclure uniquement une catégorie PUA spécifique. Cette directive peut être utilisée plusieurs fois. Voir https://docs.clamav.net/faq/faq-pua.html pour la liste complète des catégories PUA. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Dans certains cas (par exemple, malware complexe, exploits dans des fichiers graphiques et autres), ClamAV utilise des algorithmes spéciaux pour fournir une détection précise. Cette option contrôle la détection algorithmique. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Autoriser la correspondance heuristique à avoir la priorité. Lorsqu'elle est activée, si une analyse heuristique (comme phishingScan) détecte un virus/phishing possible, elle arrête immédiatement l'analyse. Recommandé, économise le temps d'analyse du processeur. Lorsqu'elle est désactivée, les virus/phishing détectés par les analyses heuristiques ne seront signalés qu'à la fin d'une analyse. Si une archive contient à la fois un virus/phishing détecté de manière heuristique et un véritable malware, le véritable malware sera signalé. Gardez cette option désactivée si vous avez l'intention de gérer les virus \"*.Heuristics.*\" différemment des \"vrais\" malwares\". Si un virus non détecté de manière heuristique (basé sur la signature) est trouvé en premier, l'analyse est immédiatement interrompue, quelle que soit cette option de configuration. Par défaut : no|";
            base_fr_FR = base_fr_FR + "PE signifie Portable Executable - c'est un format de fichier exécutable utilisé dans toutes les versions 32 et 64 bits des systèmes d'exploitation Windows. Cette option permet à ClamAV d'effectuer une analyse plus approfondie des fichiers exécutables et elle est également requise pour la décompression des packers exécutables populaires tels que UPX. Si vous désactivez cette option, les fichiers d'origine seront toujours analysés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Executable and Linking Format est un format standard pour les exécutables UN*X. Cette option vous permet de contrôler l'analyse des fichiers ELF. Si vous désactivez cette option, les fichiers d'origine seront toujours analysés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Activer l'analyse des fichiers de courrier. Si vous désactivez cette option, les fichiers d'origine seront toujours analysés, mais sans analyser les messages/pièces jointes individuels. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Analyser les messages RFC1341 répartis sur plusieurs e-mails. Vous devrez nettoyer périodiquement le répertoire $TemporaryDirectory/clamav-partial. AVERTISSEMENT : cette option peut exposer votre système à une attaque DoS. Ne l'utilisez jamais sur des serveurs chargés. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Activer la détection de phishing basée sur la signature de courrier électronique. Par défaut : yes|";
            base_fr_FR = base_fr_FR + "Activer la détection de phishing basée sur la signature d'URL (Heuristics.Phishing.Email.*) Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Activer le module DLP. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre le plus faible de numéros de carte de crédit trouvés dans un fichier pour générer une détection. Par défaut : 3|";
            base_fr_FR = base_fr_FR + "Avec cette option activée, le module DLP recherchera uniquement les numéros de carte de crédit valides. Les cartes de débit et de marque privée ne seront pas recherchées. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre le plus faible de numéros de sécurité sociale trouvés dans un fichier pour générer une détection. Par défaut : 3|";
            base_fr_FR = base_fr_FR + "Avec cette option activée, le module DLP recherchera des numéros de sécurité sociale valides au format xxx-yy-zzzz. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Avec cette option activée, le module DLP recherchera des numéros de sécurité sociale valides au format xxxyyzzzz. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Effectuer la normalisation et le décryptage HTML/JavaScript/ScriptEncoder. Si vous désactivez cette option, les fichiers d'origine seront toujours analysés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet d'analyser des fichiers OLE2, tels que des documents Microsoft Office et des fichiers .msi. Si vous désactivez cette option, les fichiers d'origine seront toujours analysés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de numériser dans les fichiers PDF. Si vous désactivez cette option, les fichiers originaux seront toujours numérisés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de numériser dans les fichiers SWF. Si vous désactivez cette option, les fichiers originaux seront toujours numérisés, mais sans décodage ni traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de numériser les fichiers de documents basés sur XML pris en charge par libclamav. Si vous désactivez cette option, les fichiers originaux seront toujours numérisés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de numériser les fichiers HWP3. Si vous désactivez cette option, les fichiers originaux seront toujours numérisés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de numériser les fichiers OneNote. Si vous désactivez cette option, les fichiers d'origine seront toujours numérisés, mais sans traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Numériser dans les archives et les fichiers compressés. Si vous désactivez cette option, les fichiers d'origine seront toujours numérisés, mais sans décompression ni traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de numériser les images (graphiques). Si vous désactivez cette option, les fichiers d'origine seront toujours numérisés, mais sans décompression ni traitement supplémentaire. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Cette option permet de détecter en calculant un hachage flou des fichiers d'image (graphiques). Les signatures utilisant des hachages flous d'image correspondent généralement aux fichiers et aux documents en identifiant les images incorporées ou jointes à ces fichiers. Si vous désactivez cette option, certains fichiers peuvent ne plus être détectés. Par défaut : oui|";
            base_fr_FR = base_fr_FR + "Alerte sur fichiers exécutables endommagés (PE & ELF). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur fichiers graphiques endommagés (JPEG, TIFF, PNG, GIF). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur archives et documents chiffrés (.zip, .7zip, .rar, .pdf chiffrés). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur archives chiffrées (.zip, .7zip, .rar chiffrés). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur documents chiffrés (.pdf chiffrés). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur les fichiers OLE2 contenant des macros VBA (Heuristics.OLE2.ContainsMacros). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Lorsque AlertExceedsMax est défini, les fichiers dépassant la limite MaxFileSize, MaxScanSize ou MaxRecursion seront signalés par le nom du virus commençant par \"Heuristics.Limits.Exceeded\". Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur les e-mails contenant des non-concordances SSL dans les URL (peut conduire à des faux positifs !). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur les e-mails contenant des URL masquées (peut conduire à des faux positifs). Par défaut : no|";
            base_fr_FR = base_fr_FR + "Alerte sur les fichiers image DMG bruts contenant des intersections de partitions. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Cette option vous permet de désactiver la fonction de mise en cache du moteur. Par défaut, le moteur stockera un MD5 dans un cache de tous les fichiers qui ne sont pas marqués comme virus ou qui atteignent les limites de vérification. Avertissement : la désactivation du cache aura un impact négatif sur les performances des analyses volumineuses. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Cette option vous permet de définir le nombre d'entrées que le cache peut stocker. La valeur doit être un nombre carré ou sera arrondie au nombre carré le plus proche. Par défaut : 65536|";
            base_fr_FR = base_fr_FR + "Cette option provoque le vidage du contenu sur le disque des analyses de mémoire ou de cartes imbriquées. Si vous activez cette option, davantage de données sont écrites sur le disque et sont disponibles lorsque l'option leave-temps est activée au prix d'un plus grand nombre d'écritures sur le disque. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Cette option définit la durée maximale d'une analyse. La valeur est en millisecondes. La valeur 0 désactive la limite. AVERTISSEMENT : désactiver cette limite ou la définir trop haut peut entraîner le blocage du processus/des threads d'analyse par l'analyse de certains fichiers, ce qui peut entraîner un déni de service. Par défaut : 120 000 |";
            base_fr_FR = base_fr_FR + "Définit la quantité maximale de données à analyser pour chaque fichier d'entrée. Les archives et autres conteneurs sont extraits et analysés de manière récursive jusqu'à cette valeur. La taille d'une archive plus la somme des tailles de tous les fichiers au sein de l'archive comptent pour la taille d'analyse. Par exemple, une archive non compressée de 1 M contenant un seul fichier interne de 1 M compte pour 2 M dans la taille d'analyse maximale. Avertissement : désactiver cette limite ou la définir trop haut peut entraîner de graves dommages au système. Par défaut : 400 M|";
            base_fr_FR = base_fr_FR + "Les fichiers plus grands que cette limite ne seront pas analysés. Affecte le fichier d'entrée lui-même ainsi que les fichiers qu'il contient (lorsque le fichier d'entrée est une archive, un document ou un autre type de conteneur). Attention : désactiver cette limite ou la définir trop haut peut entraîner de graves dommages au système. Des limitations de conception technique empêchent ClamAV d'analyser les fichiers supérieurs à 2 Go pour le moment. Par défaut : 100 Mo |";
            base_fr_FR = base_fr_FR + "Les archives imbriquées sont analysées de manière récursive, par exemple si une archive Zip contient un fichier RAR, tous les fichiers qu'elle contient seront également analysés. Cette option spécifie la profondeur à laquelle le processus doit être poursuivi. Attention : définir cette limite trop haut peut entraîner de graves dommages au système. Par défaut : 17 |";
            base_fr_FR = base_fr_FR + "Nombre de fichiers à analyser dans une archive, un document ou tout autre type de conteneur. Attention : désactiver cette limite ou la définir trop haut peut entraîner de graves dommages au système. Par défaut : 10 000|";
            base_fr_FR = base_fr_FR + "Cette option définit la taille maximale d'un fichier à vérifier pour le PE intégré. Les fichiers plus volumineux que cette valeur ignoreront l'étape d'analyse supplémentaire. Les valeurs négatives ne sont pas autorisées. Par défaut : 40 M|";
            base_fr_FR = base_fr_FR + "Cette option définit la taille maximale d'un fichier HTML à normaliser. Les fichiers HTML plus volumineux que cette valeur ne seront pas normalisés ou analysés. Les valeurs négatives ne sont pas autorisées. Par défaut : 40 M|";
            base_fr_FR = base_fr_FR + "Cette option définit la taille maximale d'un fichier HTML normalisé à analyser. Les fichiers HTML plus volumineux que cette valeur après normalisation ne seront pas analysés. Les valeurs négatives ne sont pas autorisées. Par défaut : 8 M|";
            base_fr_FR = base_fr_FR + "Cette option définit la taille maximale d'un fichier de script à normaliser. Le contenu de script supérieur à cette valeur ne sera pas normalisé ou analysé. Les valeurs négatives ne sont pas autorisées. Par défaut : 20 M|";
            base_fr_FR = base_fr_FR + "Cette option définit la taille maximale d'un fichier ZIP pour réanalyser la reconnaissance de type. Les fichiers ZIP supérieurs à cette valeur ignoreront l'étape de réanalyse potentielle en tant que PE. Les valeurs négatives ne sont pas autorisées. AVERTISSEMENT : définir cette limite trop haut peut entraîner de graves dommages ou avoir un impact sur les performances. Par défaut : 1 M|";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre maximal de partitions d'une image de disque brut à analyser. Les images de disque brut avec plus de partitions que cette valeur auront jusqu'à la valeur partitions analysées. Les valeurs négatives ne sont pas autorisées. AVERTISSEMENT : définir cette limite trop haut peut entraîner de graves dommages ou avoir un impact sur les performances. Par défaut : 50|";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre maximal d'icônes à analyser dans un PE. Les fichiers PE avec plus d'icônes que cette valeur auront jusqu'au nombre d'icônes analysées. Les valeurs négatives ne sont pas autorisées. AVERTISSEMENT : définir cette limite trop haut peut entraîner de graves dommages ou avoir un impact sur les performances.|";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre maximal d'appels récursifs à la fonction d'analyse HWP3. Les fichiers HWP3 utilisant plus que cette limite seront interrompus et alerteront l'utilisateur. Les analyses ne pourront analyser aucune pièce jointe HWP3 si la limite récursive est atteinte. Les valeurs négatives ne sont pas autorisées. AVERTISSEMENT : définir cette limite trop haut peut entraîner de graves dommages ou avoir un impact sur les performances.|";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre maximal d'appels à la fonction de correspondance PCRE pendant une instance de correspondance d'expressions régulières. Les instances utilisant plus que cette limite seront interrompues et alerteront l'utilisateur, mais l'analyse continuera. Pour plus d'informations sur match_limit, consultez la documentation PCRE. Les valeurs négatives ne sont pas autorisées. AVERTISSEMENT : définir cette limite trop haut peut avoir un impact important sur les performances. Valeur par défaut : 10 000 |";
            base_fr_FR = base_fr_FR + "Cette option définit le nombre maximal d'appels récursifs à la fonction de correspondance PCRE pendant une instance de correspondance regex. Les instances utilisant plus que cette limite seront terminées et alerteront l'utilisateur, mais l'analyse continuera. Pour plus d'informations sur match_limit_recursion, consultez la documentation PCRE. Les valeurs négatives ne sont pas autorisées et les valeurs > PCREMatchLimit sont superflues. AVERTISSEMENT : définir cette limite trop haut peut avoir un impact important sur les performances. Par défaut : 2000|";
            base_fr_FR = base_fr_FR + "Cette option définit la taille de fichier maximale pour laquelle les sous-signatures PCRE seront exécutées. Les fichiers dépassant cette limite n'auront pas de sous-signatures PCRE exécutées à moins qu'une sous-signature ne soit incluse dans un tampon plus petit. Les valeurs négatives ne sont pas autorisées. La définition de cette valeur à zéro désactive la limite. AVERTISSEMENT : définir cette limite trop haut ou la désactiver peut avoir un impact important sur les performances. Par défaut : 100 M|";
            base_fr_FR = base_fr_FR + "Cette option spécifie un répertoire (y compris tous les fichiers et répertoires qu'il contient), qui doit être analysé lors de l'accès. Cette option peut être utilisée plusieurs fois. Par défaut : désactivé |";
            base_fr_FR = base_fr_FR + "Cette option permet d'exclure des répertoires de l'analyse à l'accès. Elle peut être utilisée plusieurs fois. Par défaut : désactivé |";
            base_fr_FR = base_fr_FR + "Avec cette option, vous pouvez exclure l'UID racine (0). Les processus exécutés sous root pourront accéder à tous les fichiers sans déclencher d'analyses ou d'événements de refus d'autorisation. Notez que si clamd ne peut pas vérifier l'UID du processus qui a généré un événement d'analyse à l'accès (par exemple, parce que OnAccessPrevention n'était pas activé et que le processus était déjà terminé), clamd effectuera une analyse. Ainsi, le paramétrage de OnAccessExcludeRootUID n'est pas garanti pour empêcher chaque accès par l'utilisateur root de déclencher une analyse (à moins que OnAccessPrevention ne soit activé). Par défaut : non |";
            base_fr_FR = base_fr_FR + "Avec cette option, vous pouvez exclure des UID spécifiques. Les processus avec ces UID pourront accéder à tous les fichiers sans déclencher d'analyses ou d'événements d'autorisation refusée. Cette option peut être utilisée plusieurs fois (une par ligne). Remarque : l'utilisation d'une valeur de 0 sur n'importe quelle ligne désactivera entièrement cette option. Pour exclure l'UID racine (0), veuillez activer l'option OnAccessExcludeRootUID. Notez également que si clamd ne peut pas vérifier l'UID du processus qui a généré un événement d'analyse à l'accès (par exemple, parce que OnAccessPrevention n'était pas activé et que le processus était déjà terminé), clamd effectuera une analyse. Ainsi, la définition de OnAccessExcludeUID n'est pas garantie d'empêcher chaque accès par l'UID spécifié de déclencher une analyse (à moins que OnAccessPrevention ne soit activé). Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Cette option permet des exclusions via les noms d'utilisateur lors de l'utilisation du client d'analyse à l'accès. Elle peut être utilisée plusieurs fois et présente les mêmes limitations de conditions de concurrence potentielles que l'option OnAccessExcludeUID. Par défaut : désactivé | ";
            base_fr_FR = base_fr_FR + "Les fichiers plus volumineux que cette valeur ne seront pas analysés lors de l'accès. Par défaut : 5 M | ";
            base_fr_FR = base_fr_FR + "Nombre maximal de threads d'analyse à allouer au pool de threads OnAccess au démarrage. Ces threads sont responsables de la création d'une connexion avec le démon et du lancement de l'analyse après le traitement d'un événement. Pour empêcher clamonacc de consommer toutes les ressources de clamd, maintenez ce nombre inférieur au nombre maximal de threads de clamd. Par défaut : 5 | ";
            base_fr_FR = base_fr_FR + "Durée maximale (en millisecondes) que le client OnAccess doit consacrer à chaque tentative de connexion, d'envoi et de réception lors de la communication avec clamd via curl. Par défaut : 5 000 (5 secondes) |";
            base_fr_FR = base_fr_FR + "Spécifie un point de montage (y compris tous les fichiers et répertoires sous celui-ci), qui doit être analysé lors de l'accès. Cette option peut être utilisée plusieurs fois. Par défaut : désactivée |";
            base_fr_FR = base_fr_FR + "Désactive le système de détermination dynamique des répertoires qui permet de surveiller de manière récursive les chemins d'inclusion. Par défaut : non |";
            base_fr_FR = base_fr_FR + "Active le blocage fanotify lorsque des fichiers malveillants sont détectés. Par défaut : désactivé|";
            base_fr_FR = base_fr_FR + "Nombre de fois où le client OnAccess va relancer une analyse échouée en raison de problèmes de connexion (ou d'autres problèmes). Par défaut : 0|";
            base_fr_FR = base_fr_FR + "Lors de l'utilisation de la prévention, si cette option est activée, toute erreur qui se produit pendant l'analyse entraînera le refus de la tentative d'événement. Cela pourrait potentiellement conduire à un comportement indésirable du système avec certaines configurations, donc le client désactive cette option par défaut et préfère autoriser les événements d'accès en cas d'erreur d'analyse ou de connexion. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Active l'analyse supplémentaire et les notifications lorsqu'un fichier ou un répertoire est créé ou déplacé. Nécessite que le système DDD lance des analyses supplémentaires. Par défaut : non|";
            base_fr_FR = base_fr_FR + "Désactiver la vérification de la chaîne de certificats authenticode dans les fichiers PE. Par défaut : no|";
            base_fr_FR = base_fr_FR + "Stockez les URI HTML dans les métadonnées. Les URI seront écrits dans le fichier metadata.json dans un tableau appelé « URI »|";
            base_fr_FR = base_fr_FR + "Stockez les URI PDF dans les métadonnées. Les URI seront écrits dans le fichier metadata.json dans un tableau appelé « URI ».|";
            base_fr_FR = base_fr_FR + "Stockez md5 et sha1 en plus de sha2-256 dans les métadonnées.|";
            base_fr_FR = base_fr_FR + "Imprimez le hachage du fichier après chaque fichier analysé.|";
            base_fr_FR = base_fr_FR + "Imprimez le type de fichier après chaque fichier numérisé.|";
            base_fr_FR = base_fr_FR + "Appliquez des limites de type FIPS sur l'utilisation d'algorithmes de hachage à des fins cryptographiques. Désactivera MD5 et SHA1. PHP signe et nécessitera des fichiers « .sign » pour vérifier l'authenticité du CVD.";

// translations es_ES
    QString base_es_ES = "Sea comunicativo|";
            base_es_ES = base_es_ES + "Visualizar ficheros dentro de archivos|";
            base_es_ES = base_es_ES + "Activar los mensajes de depuración de libclamav|";
            base_es_ES = base_es_ES + "Sólo mensajes de error|";
            base_es_ES = base_es_ES + "Escribe en stdout en lugar de stderr. No afecta a los mensajes de depuración.|";
            base_es_ES = base_es_ES + "Desactivar el resumen de escaneo al final del proceso de escaneo|";
            base_es_ES = base_es_ES + "Sólo archivos infectados|";
            base_es_ES = base_es_ES + "Omitir la salida de archivos OK|";
            base_es_ES = base_es_ES + "Campana para la detección de virus|";
            base_es_ES = base_es_ES + "No eliminar los archivos temporales|";
            base_es_ES = base_es_ES + "Crea una descripción JSON de los archivos escaneados. Se emite JSON y también|";
            base_es_ES = base_es_ES + "Cargar sólo firmas oficiales|";
            base_es_ES = base_es_ES + "Explorar subdirectorios recursivamente|";
            base_es_ES = base_es_ES + "Continuar la búsqueda en el fichero si se obtiene una respuesta positiva|";
            base_es_ES = base_es_ES + "Escanear archivos y directorios en otros sistemas de archivos|";
            base_es_ES = base_es_ES + "Elimine los archivos infectados. ¡Cuidado!|";
            base_es_ES = base_es_ES + "Cargar código de bytes sin firmar. **Precaución**: NUNCA debe ejecutar firmas de código de bytes de fuentes que no sean de confianza. Hacerlo puede resultar en la ejecución de código arbitrario.|";
            base_es_ES = base_es_ES + "Reconocer aplicaciones presuntamente no deseadas|";
            base_es_ES = base_es_ES + "Reconocer datos estructurados (SSN, tarjeta de crédito)|";
            base_es_ES = base_es_ES + "Escanear archivos de correo|";
            base_es_ES = base_es_ES + "Activar la detección de phishing con firmas de correo electrónico|";
            base_es_ES = base_es_ES + "Activar la firma de URL y la detección de phishing|";
            base_es_ES = base_es_ES + "Advertencias heurísticas|";
            base_es_ES = base_es_ES + "Detener la búsqueda en cuanto se encuentre una coincidencia heurística.|";
            base_es_ES = base_es_ES + "Normalice los archivos HTML, script y de texto. Utilice normalise=no para compatibilidad con Yara|";
            base_es_ES = base_es_ES + "Escanear archivos PE|";
            base_es_ES = base_es_ES + "Escanear archivos ELF|";
            base_es_ES = base_es_ES + "Escanear contenedor OLE2|";
            base_es_ES = base_es_ES + "Escanear archivos PDF|";
            base_es_ES = base_es_ES + "Escanear archivos SWF|";
            base_es_ES = base_es_ES + "Escanear archivos HTML|";
            base_es_ES = base_es_ES + "Escanear archivos de documentos basados en xml|";
            base_es_ES = base_es_ES + "Escanear archivos HWP3|";
            base_es_ES = base_es_ES + "Escaneado de archivos comprimidos (compatible con libclamav)|";
            base_es_ES = base_es_ES + "Advertencia de archivos ejecutables defectuosos (PE y ELF)|";
            base_es_ES = base_es_ES + "Advertencia sobre archivos gráficos defectuosos (JPEG, TIFF, PNG, GIF)|";
            base_es_ES = base_es_ES + "Advertencia sobre archivos y documentos cifrados|";
            base_es_ES = base_es_ES + "Advertencia para archivos encriptados|";
            base_es_ES = base_es_ES + "Advertencia sobre documentos encriptados|";
            base_es_ES = base_es_ES + "Advertencia sobre archivos OLE2 que contienen macros VBA|";
            base_es_ES = base_es_ES + "Advertencia para archivos que superen el tamaño máximo de archivo, el tamaño máximo de escaneado o el límite máximo de recursión|";
            base_es_ES = base_es_ES + "Advertencia para los mensajes de correo electrónico que contengan errores SSL en las URL|";
            base_es_ES = base_es_ES + "Advertencia para los correos electrónicos con URL camufladas|";
            base_es_ES = base_es_ES + "Advertencia para archivos de imagen DMG sin procesar que contienen solapamientos de particiones|";
            base_es_ES = base_es_ES + "Desactivación de la comprobación de la cadena de certificados Authenticode en archivos PE|";
            base_es_ES = base_es_ES + "Volcado de la cadena de certificados Authenticode en archivos PE|";
            base_es_ES = base_es_ES + "Desactivar el almacenamiento en caché y las comprobaciones en caché de las sumas hash de los archivos escaneados.|";
// new with version 1.4.2 of clamav
            base_es_ES = base_es_ES + "Crear archivos temporales para exploraciones de archivos anidados que, de otro modo, sólo estarían en memoria.|";
            base_es_ES = base_es_ES + "Generar metadatos JSON para los archivos escaneados. SÓLO para pruebas y desarrollo.|";
            base_es_ES = base_es_ES + "Devuelve un código de error distinto de cero si la base de datos de virus no está actualizada.|";
            base_es_ES = base_es_ES + "Escanear archivos de OneNote|";
            base_es_ES = base_es_ES + "Escanear archivos de imagen (gráficos)|";
            base_es_ES = base_es_ES + "Detección de archivos mediante el cálculo de hashes difusos de imágenes (gráficos)|";
            base_es_ES = base_es_ES + "Crear archivos temporales para exploraciones de archivos anidados que, de otro modo, sólo estarían en memoria.|";
// clamd.conf
            base_es_ES = base_es_ES + "Guardar todos los informes en un archivo de registro. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "De manera predeterminada, el archivo de registro está bloqueado para escritura y solo un único proceso demonio puede escribir en él. Esta opción deshabilita el bloqueo. Predeterminado: no|";
            base_es_ES = base_es_ES + "Tamaño máximo del archivo de registro. El valor 0 deshabilita el límite. Predeterminado: 1048576|";
            base_es_ES = base_es_ES + "Tiempo de registro para cada mensaje. Predeterminado: no|";
            base_es_ES = base_es_ES + "Registrar todos los archivos limpios. Útil para la depuración, pero aumenta drásticamente el tamaño del registro. Predeterminado: no|";
            base_es_ES = base_es_ES + "Usar el registrador del sistema (puede funcionar junto con LogFile). Predeterminado: no|";
            base_es_ES = base_es_ES + "Tipo de mensajes de syslog. Consulte 'man syslog' para conocer los nombres de las funciones. (LOG_LOCAL6, LOG_MAIL), valor predeterminado: LOG_LOCAL6|";
            base_es_ES = base_es_ES + "Habilitar registro detallado. Valor predeterminado: no|";
            base_es_ES = base_es_ES + "Rotar archivo de registro. Requiere que la opción LogFileMaxSize esté configurada antes de esta opción. Valor predeterminado: no|";
            base_es_ES = base_es_ES + "Registrar información adicional sobre el archivo infectado, como su tamaño y hash, junto con el nombre del virus. Valor predeterminado: no|";
            base_es_ES = base_es_ES + "Escribir el pid del demonio en el archivo especificado. Valor predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Esta opción le permite cambiar el directorio temporal predeterminado. Predeterminado: /tmp|";
            base_es_ES = base_es_ES + "Esta opción le permite cambiar el directorio de base de datos predeterminado. Si la habilita, asegúrese de que apunte al mismo directorio tanto en clamd como en freshclam. Predeterminado: /usr/local/share/clamav|";
            base_es_ES = base_es_ES + "Cargar solo las firmas oficiales publicadas por el proyecto ClamAV. Predeterminado: no|";
            base_es_ES = base_es_ES + "Regresar con un código de error distinto de cero si la base de datos de virus es más antigua que la cantidad de días especificada. Predeterminado: -1|";
            base_es_ES = base_es_ES + "Ruta a un socket local (Unix) en el que el demonio escuchará. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Establece la propiedad del grupo en el socket Unix. Predeterminado: |";
            base_es_ES = base_es_ES + "Establece los permisos en el socket Unix en el modo especificado. Predeterminado: 660|";
            base_es_ES = base_es_ES + "Eliminar socket obsoleto después de un apagado incorrecto. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Número de puerto TCP en el que escuchará el demonio. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "De manera predeterminada, clamd se vincula a INADDR_ANY. Esta opción le permite restringir la dirección TCP y brindar cierto grado de protección del mundo exterior. Esta opción se puede especificar varias veces para escuchar en varias IP. Ahora se admite IPv6. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Longitud máxima que puede alcanzar la cola de conexiones pendientes. Predeterminado: 200|";
            base_es_ES = base_es_ES + "Cerrar la sesión STREAM cuando se exceda el límite de tamaño de los datos. El valor debe coincidir con el límite de su MTA para el tamaño máximo de los archivos adjuntos. Predeterminado: 100M|";
            base_es_ES = base_es_ES + "El comando STREAM utiliza un protocolo similar a FTP. Esta opción establece el límite inferior para el rango de puertos. Predeterminado: 1024|";
            base_es_ES = base_es_ES + "Esta opción establece el límite superior para el rango de puertos. Predeterminado: 2048|";
            base_es_ES = base_es_ES + "Número máximo de subprocesos que se ejecutan al mismo tiempo. Predeterminado: 10|";
            base_es_ES = base_es_ES + "Esta opción especifica el tiempo (en segundos) después del cual clamd debe expirar si un cliente no proporciona ningún dato. Predeterminado: 120|";
            base_es_ES = base_es_ES + "Esta opción especifica el tiempo (en segundos) después del cual clamd debe expirar si un cliente no proporciona ningún comando inicial después de conectarse. El valor predeterminado es 30 para evitar tiempos de espera con sockets TCP al procesar mensajes grandes. Si se usa un socket Unix, el valor se puede cambiar a 5. Nota: el tiempo de espera para los comandos subsiguientes y/o fragmentos de datos se especifica mediante ReadTimeout. Predeterminado: 30|";
            base_es_ES = base_es_ES + "Esta opción especifica cuánto tiempo esperar (en milisegundos) si el búfer de envío está lleno. Mantenga este valor bajo para evitar que clamd se cuelgue. Predeterminado: 500|";
            base_es_ES = base_es_ES + "Número máximo de elementos en cola (incluidos los que están siendo procesados ​​por subprocesos MaxThreads). Se recomienda que este valor sea al menos el doble de MaxThreads si es posible. ADVERTENCIA: no debe aumentarlo demasiado para evitar quedarse sin descriptores de archivos, se debe cumplir la siguiente condición: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE. RLIMIT_NOFILE es el número máximo de descriptores de archivos abiertos (normalmente 1024), establecido por ulimit -n. Predeterminado: 100|";
            base_es_ES = base_es_ES + "Esta opción especifica cuánto tiempo (en segundos) debe esperar el proceso por un nuevo trabajo. Predeterminado: 30|";
            base_es_ES = base_es_ES + "No escanee archivos y directorios que coincidan con REGEX. Esta directiva se puede usar varias veces. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Profundidad máxima a la que se escanean los directorios. Predeterminado: 15|";
            base_es_ES = base_es_ES + "Seguir enlaces simbólicos de directorios. Predeterminado: no|";
            base_es_ES = base_es_ES + "Escanear archivos y directorios en otros sistemas de archivos. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Seguir enlaces simbólicos de archivos regulares. Predeterminado: no|";
            base_es_ES = base_es_ES + "Esta opción especifica los intervalos de tiempo (en segundos) en los que clamd debe realizar una verificación de la base de datos. Predeterminado: 600|";
            base_es_ES = base_es_ES + "Habilitar recargas de base de datos sin bloqueo (multiproceso/concurrente). Esta función cargará temporalmente un segundo motor de escaneo mientras el escaneo continúa usando el primer motor. Una vez cargado, el nuevo motor toma el control. El motor anterior se elimina tan pronto como se completan todos los escaneos que usan el motor anterior. Esta función requiere más RAM, por lo que esta opción se proporciona en caso de que los usuarios estén dispuestos a bloquear los escaneos durante la recarga a cambio de requisitos de RAM más bajos. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Ejecutar un comando cuando se encuentre un virus. Utilice las siguientes variables de entorno para identificar los nombres de los archivos y los virus: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME En la cadena de comandos, '%v' también se reemplazará con el nombre del virus. Nota: El carácter de formato de nombre de archivo '%f' se ha deshabilitado y ya no se reemplazará con el nombre del archivo, debido a problemas de seguridad de inyección de comandos. Utilice la variable de entorno 'CLAVIRUSEVENT_FILENAME' en su lugar. Por la misma razón, NO debe utilizar las variables de entorno en el comando directamente, sino que debe utilizarlas con cuidado desde el script ejecutado. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Detener el demonio cuando libclamav informa una condición de falta de memoria. Predeterminado: no|";
            base_es_ES = base_es_ES + "Permitir el uso del comando ALLMATCHSCAN. Predeterminado: sí|";
            base_es_ES = base_es_ES + "No bifurcar en segundo plano. Predeterminado: no|";
            base_es_ES = base_es_ES + "Habilitar mensajes de depuración desde libclamav. Predeterminado: no|";
            base_es_ES = base_es_ES + "No eliminar archivos temporales (para fines de depuración). Predeterminado: no GenerateMetadataJson BOOL Registra metadatos sobre el archivo que se está escaneando. Los metadatos del escaneo son útiles para fines de análisis de archivos y para depurar el comportamiento del escaneo. Los metadatos JSON se imprimirán una vez que se complete el escaneo si la opción Debug está habilitada. Se escribirá un archivo metadata.json en el directorio temporal del escaneo si LeaveTemporaryFiles está habilitado. Predeterminado: no|";
            base_es_ES = base_es_ES + "Ejecutar el demonio como un usuario especificado (el proceso debe iniciarse por root). Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Con esta opción habilitada, ClamAV cargará el código de bytes de la base de datos. Se recomienda encarecidamente que mantenga esta opción activada, de lo contrario, puede perder detecciones para muchos virus nuevos. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Establecer el nivel de seguridad del bytecode. Valores posibles: TrustSigned - confiar en el bytecode cargado desde archivos .c[lv]d firmados e insertar comprobaciones de seguridad en tiempo de ejecución para el bytecode cargado desde otras fuentes, Paranoid - no confiar en ningún bytecode, insertar comprobaciones en tiempo de ejecución para todos. Recomendado: TrustSigned, porque el bytecode en archivos .cvd ya tiene estas comprobaciones. (TrustSigned, Paranoid) Predeterminado: TrustSigned|";
            base_es_ES = base_es_ES + "Establecer el tiempo de espera del bytecode en milisegundos. Predeterminado: 10000|";
            base_es_ES = base_es_ES + "Permitir cargar bytecode desde archivos .c[lv]d firmados digitalmente. **Precaución**: NUNCA debe ejecutar firmas de bytecode desde fuentes no confiables. Hacerlo puede resultar en la ejecución de código arbitrario. Predeterminado: no|";
            base_es_ES = base_es_ES + "Establecer el modo de ejecución de bytecode. Valores posibles: Automático: elegir JIT automáticamente si es posible, recurrir al intérprete ForceJIT: elegir siempre JIT, fallar si no es posible ForceInterpreter: elegir siempre el intérprete Test: ejecutar con JIT e intérprete y comparar los resultados. Hacer que todos los fallos sean fatales. Predeterminado: Automático|";
            base_es_ES = base_es_ES + "Detectar aplicaciones posiblemente no deseadas. Predeterminado: no|";
            base_es_ES = base_es_ES + "Excluir una categoría de PUA específica. Esta directiva se puede utilizar varias veces. Consulte https://docs.clamav.net/faq/faq-pua.html para obtener la lista completa de categorías de PUA. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Incluir solo una categoría de PUA específica. Esta directiva se puede utilizar varias veces. Consulte https://docs.clamav.net/faq/faq-pua.html para obtener la lista completa de categorías de PUA. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "En algunos casos (por ejemplo, malware complejo, exploits en archivos gráficos y otros), ClamAV utiliza algoritmos especiales para proporcionar una detección precisa. Esta opción controla la detección algorítmica. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Permitir que la coincidencia heurística tenga prioridad. Cuando está habilitada, si un análisis heurístico (como phishingScan) detecta un posible virus o phishing, detendrá el análisis inmediatamente. Recomendado, ahorra tiempo de análisis de la CPU. Cuando está deshabilitada, los virus o phishing detectados por análisis heurísticos se informarán solo al final de un análisis. Si un archivo contiene un virus o phishing detectado heurísticamente y un malware real, se informará del malware real. Mantenga esta opción deshabilitada si desea manejar los virus \"*.Heuristics.*\" de forma diferente al malware \"real\". Si se encuentra primero un virus no detectado heurísticamente (basado en firmas), el análisis se interrumpe inmediatamente, independientemente de esta opción de configuración. Predeterminado: no|";
            base_es_ES = base_es_ES + "PE significa Portable Executable (Ejecutable portátil), es un formato de archivo ejecutable utilizado en todas las versiones de 32 y 64 bits de los sistemas operativos Windows. Esta opción permite a ClamAV realizar un análisis más profundo de los archivos ejecutables y también es necesaria para la descompresión de los empaquetadores de ejecutables más populares, como UPX. Si desactiva esta opción, se seguirán analizando los archivos originales, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Executable and Linking Format (Formato ejecutable y de enlace) es un formato estándar para ejecutables UN*X. Esta opción le permite controlar el análisis de archivos ELF. Si desactiva esta opción, se seguirán analizando los archivos originales, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Habilitar el análisis de archivos de correo. Si desactiva esta opción, se seguirán analizando los archivos originales, pero sin analizar los mensajes o archivos adjuntos individuales. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Analice los mensajes RFC1341 divididos en muchos correos electrónicos. Deberá limpiar periódicamente el directorio $TemporaryDirectory/clamav-partial. ADVERTENCIA: Esta opción puede exponer su sistema a un ataque DoS. Nunca la use en servidores cargados. Predeterminado: no|";
            base_es_ES = base_es_ES + "Habilitar la detección de phishing basada en firmas de correo electrónico. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Habilitar la detección de phishing basada en firmas de URL (Heuristics.Phishing.Email.*) Predeterminado: sí|";
            base_es_ES = base_es_ES + "Habilitar el módulo DLP. Predeterminado: no|";
            base_es_ES = base_es_ES + "Esta opción establece el número más bajo de números de tarjeta de crédito encontrados en un archivo para generar una detección. Predeterminado: 3|";
            base_es_ES = base_es_ES + "Con esta opción habilitada, el módulo DLP buscará únicamente números de tarjeta de crédito válidos. No se buscarán tarjetas de débito ni de marca privada. Predeterminado: no|";
            base_es_ES = base_es_ES + "Esta opción establece el número más bajo de números de Seguro Social encontrados en un archivo para generar una detección. Predeterminado: 3|";
            base_es_ES = base_es_ES + "Con esta opción habilitada, el módulo DLP buscará números de Seguro Social válidos con el formato xxx-yy-zzzz. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Con esta opción habilitada, el módulo DLP buscará números de seguro social válidos con el formato xxxyyzzzz. Predeterminado: no|";
            base_es_ES = base_es_ES + "Realizar la normalización y descifrado de HTML/JavaScript/ScriptEncoder. Si desactiva esta opción, se seguirán escaneando los archivos originales, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear archivos OLE2, como documentos de Microsoft Office y archivos .msi. Si desactiva esta opción, se seguirán escaneando los archivos originales, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear dentro de archivos PDF. Si desactiva esta opción, se seguirán escaneando los archivos originales, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear dentro de archivos SWF. Si desactiva esta opción, los archivos originales se seguirán escaneando, pero sin decodificación ni procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear archivos de documentos basados ​​en xml compatibles con libclamav. Si desactiva esta opción, los archivos originales se seguirán escaneando, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear archivos HWP3. Si desactiva esta opción, los archivos originales se seguirán escaneando, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear archivos de OneNote. Si desactiva esta opción, los archivos originales se seguirán escaneando, pero sin procesamiento adicional. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Escanear dentro de archivos comprimidos. Si desactiva esta opción, los archivos originales se escanearán de todos modos, pero sin descomprimirlos ni procesarlos más. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite escanear imágenes (gráficos). Si desactiva esta opción, los archivos originales se escanearán de todos modos, pero sin descomprimirlos ni procesarlos más. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Esta opción permite la detección mediante el cálculo de un hash difuso de archivos de imagen (gráficos). Las firmas que utilizan hashes difusos de imágenes suelen hacer coincidir archivos y documentos mediante la identificación de imágenes incrustadas o adjuntas a esos archivos. Si desactiva esta opción, es posible que ya no se detecten algunos archivos. Predeterminado: sí|";
            base_es_ES = base_es_ES + "Alerta sobre archivos ejecutables dañados (PE y ELF). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre archivos gráficos dañados (JPEG, TIFF, PNG, GIF). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre archivos y documentos cifrados (.zip, .7zip, .rar, .pdf cifrados). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre archivos cifrados (.zip, .7zip, .rar cifrados). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre documentos cifrados (.pdf cifrados). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre archivos OLE2 que contienen macros VBA (Heuristics.OLE2.ContainsMacros). Predeterminado: no|";
            base_es_ES = base_es_ES + "Cuando se establece AlertExceedsMax, los archivos que excedan el límite MaxFileSize, MaxScanSize o MaxRecursion se marcarán con el nombre del virus comenzando con \"Heuristics.Limits.Exceeded\". Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre correos electrónicos que contienen incompatibilidades de SSL en las URL (¡pueden dar lugar a falsos positivos!). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre correos electrónicos que contienen URL ocultas (pueden dar lugar a algunos falsos positivos). Predeterminado: no|";
            base_es_ES = base_es_ES + "Alerta sobre archivos de imagen DMG sin procesar que contienen intersecciones de particiones. Predeterminado: no|";
            base_es_ES = base_es_ES + "Esta opción le permite desactivar la función de almacenamiento en caché del motor. De forma predeterminada, el motor almacenará un MD5 en una caché de todos los archivos que no estén marcados como virus o que alcancen los límites de comprobación. Advertencia: Deshabilitar la caché tendrá un impacto negativo en el rendimiento en análisis de gran tamaño. Predeterminado: no|";
            base_es_ES = base_es_ES + "Esta opción le permite establecer el número de entradas que puede almacenar la caché. El valor debe ser un número cuadrado o se redondeará al número cuadrado más cercano. Predeterminado: 65536|";
            base_es_ES = base_es_ES + "Esta opción hace que los escaneos de memoria o de mapas anidados vuelquen el contenido al disco. Si activa esta opción, se escriben más datos en el disco y están disponibles cuando la opción leave-temps está habilitada a costa de más escrituras en el disco. Predeterminado: no|";
            base_es_ES = base_es_ES + "Esta opción establece la cantidad máxima de tiempo que puede tardar un escaneo en completarse. El valor está en milisegundos. El valor 0 deshabilita el límite. ADVERTENCIA: deshabilitar este límite o configurarlo demasiado alto puede provocar que el escaneo de ciertos archivos bloquee el proceso/los subprocesos de escaneo, lo que resulta en una denegación de servicio. Predeterminado: 120000|";
            base_es_ES = base_es_ES + "Establece la cantidad máxima de datos que se escanearán para cada archivo de entrada. Los archivos y otros contenedores se extraen y escanean de forma recursiva hasta este valor. El tamaño de un archivo más la suma de los tamaños de todos los archivos dentro del archivo cuentan para el tamaño de escaneo. Por ejemplo, un archivo sin comprimir de 1 M que contiene un solo archivo interno de 1 M cuenta como 2 M para el tamaño máximo de escaneo. Advertencia: deshabilitar este límite o configurarlo demasiado alto puede provocar daños graves al sistema. Predeterminado: 400 M|";
            base_es_ES = base_es_ES + "Los archivos más grandes que este límite no se escanearán. Afecta al archivo de entrada en sí, así como a los archivos que contiene (cuando el archivo de entrada es un archivo, un documento o algún otro tipo de contenedor). Advertencia: deshabilitar este límite o configurarlo demasiado alto puede provocar daños graves al sistema. Las limitaciones de diseño técnico impiden que ClamAV escanee archivos de más de 2 GB en este momento. Predeterminado: 100 M|";
            base_es_ES = base_es_ES + "Los archivos anidados se escanean de forma recursiva, por ejemplo, si un archivo Zip contiene un archivo RAR, también se escanearán todos los archivos que contenga. Esta opción especifica la profundidad con la que debe continuar el proceso. Advertencia: si se establece este límite demasiado alto, se pueden producir daños graves en el sistema. Predeterminado: 17|";
            base_es_ES = base_es_ES + "Número de archivos que se escanearán dentro de un archivo, un documento o cualquier otro tipo de contenedor. Advertencia: si se deshabilita este límite o se lo establece demasiado alto, se pueden producir daños graves en el sistema. Predeterminado: 10000|";
            base_es_ES = base_es_ES + "Esta opción establece el tamaño máximo de un archivo para comprobar si hay archivos PE incrustados. Los archivos más grandes que este valor omitirán el paso de análisis adicional. No se permiten valores negativos. Predeterminado: 40M|";
            base_es_ES = base_es_ES + "Esta opción establece el tamaño máximo de un archivo HTML para normalizar. Los archivos HTML más grandes que este valor no se normalizarán ni escanearán. No se permiten valores negativos. Predeterminado: 40M|";
            base_es_ES = base_es_ES + "Esta opción establece el tamaño máximo de un archivo HTML normalizado para escanear. Los archivos HTML más grandes que este valor después de la normalización no se escanearán. No se permiten valores negativos. Predeterminado: 8M|";
            base_es_ES = base_es_ES + "Esta opción establece el tamaño máximo de un archivo de script para normalizar. El contenido de script más grande que este valor no se normalizará ni escaneará. No se permiten valores negativos. Predeterminado: 20M|";
            base_es_ES = base_es_ES + "Esta opción establece el tamaño máximo de un archivo ZIP para volver a analizar el reconocimiento de tipo. Los archivos ZIP más grandes que este valor omitirán el paso para volver a analizarse potencialmente como PE. No se permiten valores negativos. ADVERTENCIA: establecer este límite demasiado alto puede provocar daños graves o afectar el rendimiento. Predeterminado: 1M|";
            base_es_ES = base_es_ES + "Esta opción establece la cantidad máxima de particiones de una imagen de disco sin procesar que se escanearán. Las imágenes de disco sin procesar con más particiones que este valor tendrán hasta el valor de particiones escaneadas. No se permiten valores negativos. ADVERTENCIA: si se establece este límite demasiado alto, se pueden producir daños graves o afectar el rendimiento. Predeterminado: 50|";
            base_es_ES = base_es_ES + "Esta opción establece la cantidad máxima de íconos dentro de un PE que se escanearán. Los archivos PE con más íconos que este valor tendrán hasta el valor de número de íconos escaneados. No se permiten valores negativos. ADVERTENCIA: si se establece este límite demasiado alto, se pueden producir daños graves o afectar el rendimiento.|";
            base_es_ES = base_es_ES + "Esta opción establece el número máximo de llamadas recursivas a la función de análisis de HWP3. Los archivos HWP3 que utilicen más de este límite se terminarán y alertarán al usuario. Los análisis no podrán analizar ningún archivo adjunto HWP3 si se alcanza el límite recursivo. No se permiten valores negativos. ADVERTENCIA: establecer este límite demasiado alto puede provocar daños graves o afectar el rendimiento. |";
            base_es_ES = base_es_ES + "Esta opción establece el número máximo de llamadas a la función de coincidencia de PCRE durante una instancia de coincidencia de expresiones regulares. Las instancias que utilicen más de este límite se terminarán y alertarán al usuario, pero el análisis continuará. Para obtener más información sobre match_limit, consulte la documentación de PCRE. No se permiten valores negativos. ADVERTENCIA: establecer este límite demasiado alto puede afectar gravemente el rendimiento. Predeterminado: 10000 |";
            base_es_ES = base_es_ES + "Esta opción establece el máximo de llamadas recursivas a la función de coincidencia de PCRE durante una instancia de coincidencia de expresiones regulares. Las instancias que utilicen más de este límite se terminarán y alertarán al usuario, pero el análisis continuará. Para obtener más información sobre match_limit_recursion, consulte la documentación de PCRE. No se permiten valores negativos y los valores > PCREMatchLimit son superfluos. ADVERTENCIA: establecer este límite demasiado alto puede afectar gravemente el rendimiento. Predeterminado: 2000|";
            base_es_ES = base_es_ES + "Esta opción establece el tamaño máximo de archivo para el que se ejecutarán las subsigs de PCRE. Los archivos que superen este límite no tendrán subsigs de PCRE ejecutados a menos que una subsig esté incluida en un búfer más pequeño. No se permiten valores negativos. Establecer este valor en cero deshabilita el límite. ADVERTENCIA: establecer este límite demasiado alto o deshabilitarlo puede afectar gravemente el rendimiento. Predeterminado: 100M|";
            base_es_ES = base_es_ES + "Esta opción especifica un directorio (incluyendo todos los archivos y directorios dentro de él), que debe ser escaneado en el acceso. Esta opción puede ser usada varias veces. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Esta opción permite excluir directorios del escaneo en acceso. Puede ser usada varias veces. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Con esta opción puede excluir el UID raíz (0). Los procesos que se ejecutan bajo la raíz podrán acceder a todos los archivos sin activar escaneos o eventos de permiso denegado. Tenga en cuenta que si clamd no puede verificar el uid del proceso que generó un evento de escaneo en acceso (por ejemplo, porque OnAccessPrevention no estaba habilitado y el proceso ya salió), clamd realizará un escaneo. Por lo tanto, no se garantiza que la configuración de OnAccessExcludeRootUID evite que cada acceso por parte del usuario raíz active un escaneo (a menos que OnAccessPrevention esté habilitado). Predeterminado: no|";
            base_es_ES = base_es_ES + "Con esta opción puede excluir UID específicos. Los procesos con estos UID podrán acceder a todos los archivos sin activar escaneos o eventos de permiso denegado. Esta opción se puede utilizar varias veces (una por línea). Nota: si utiliza un valor de 0 en cualquier línea, deshabilitará esta opción por completo. Para excluir el UID raíz (0), habilite la opción OnAccessExcludeRootUID. Tenga en cuenta también que si clamd no puede comprobar el uid del proceso que generó un evento de escaneo en acceso (por ejemplo, porque OnAccessPrevention no estaba habilitado y el proceso ya había salido), clamd realizará un escaneo. Por lo tanto, no se garantiza que la configuración de OnAccessExcludeUID impida que cada acceso por parte del uid especificado active un escaneo (a menos que OnAccessPrevention esté habilitado). Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Esta opción permite exclusiones a través de nombres de usuario cuando se utiliza el cliente de escaneo en tiempo real. Puede utilizarse varias veces y tiene las mismas limitaciones de condición de carrera potencial de la opción OnAccessExcludeUID. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Los archivos mayores a este valor no serán escaneados en el acceso. Predeterminado: 5M|";
            base_es_ES = base_es_ES + "Número máximo de subprocesos de escaneo para asignar al grupo de subprocesos OnAccess al inicio. Estos subprocesos son los responsables de crear una conexión con el demonio y de iniciar el escaneo después de que se haya procesado un evento. Para evitar que clamonacc consuma todos los recursos de clamd, mantenga este valor por debajo del número máximo de subprocesos de clamd. Predeterminado: 5|";
            base_es_ES = base_es_ES + "Cantidad máxima de tiempo (en milisegundos) que el cliente OnAccess debe emplear en cada intento de conexión, envío y recepción al comunicarse con clamd a través de curl. Predeterminado: 5000 (5 segundos)|";
            base_es_ES = base_es_ES + "Especifica un punto de montaje (incluyendo todos los archivos y directorios que se encuentran debajo de él), que debe escanearse al acceder. Esta opción se puede usar varias veces. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Deshabilita el sistema de determinación dinámica de directorios que permite observar recursivamente las rutas de inclusión. Predeterminado: no|";
            base_es_ES = base_es_ES + "Habilita el bloqueo de fanotify cuando se encuentran archivos maliciosos. Predeterminado: deshabilitado|";
            base_es_ES = base_es_ES + "Número de veces que el cliente OnAccess volverá a intentar un escaneo fallido debido a problemas de conexión (u otros problemas). Predeterminado: 0|";
            base_es_ES = base_es_ES + "Al usar la prevención, si esta opción está activada, cualquier error que ocurra durante el escaneo provocará que se deniegue el intento de evento. Esto podría generar un comportamiento no deseado del sistema con ciertas configuraciones, por lo que el cliente desactiva esta opción de manera predeterminada y prefiere permitir eventos de acceso en caso de error de escaneo o conexión. Predeterminado: no|";
            base_es_ES = base_es_ES + "Activa escaneos adicionales y notificaciones cuando se crea o mueve un archivo o directorio. Requiere que el sistema DDD inicie escaneos adicionales. Predeterminado: no|";
            base_es_ES = base_es_ES + "Desactivar la verificación de la cadena de certificados authenticode en archivos PE. Predeterminado: no|";
            base_es_ES = base_es_ES + "Almacene URI HTML en metadatos. Los URI se escribirán en el archivo metadata.json en una matriz llamada 'URI'|";
            base_es_ES = base_es_ES + "Almacene URI de PDF en metadatos. Los URI se escribirán en el archivo metadata.json en una matriz denominada 'URI'.|";
            base_es_ES = base_es_ES + "Almacene md5 y sha1 además de sha2-256 en metadatos.|";
            base_es_ES = base_es_ES + "Imprima el hash del archivo después de cada archivo escaneado.|";
            base_es_ES = base_es_ES + "Imprima el tipo de archivo después de cada archivo escaneado.|";
            base_es_ES = base_es_ES + "Haga cumplir límites similares a FIPS en el uso de algoritmos hash con fines criptográficos. Deshabilitará MD5 y SHA1. PHP firma y requerirá archivos '.sign' para verificar la autenticidad del CVD.";

// translation uk_UA
    QString base_uk_UA = "Будьте багатослівні|";
            base_uk_UA = base_uk_UA + "Показувати імена файлів всередині відсканованих архівів|";
            base_uk_UA = base_uk_UA + "Увімкнути налагоджувальні повідомлення libclamav|";
            base_uk_UA = base_uk_UA + "Виводити тільки повідомлення про помилки|";
            base_uk_UA = base_uk_UA + "Писати до stdout замість stderr. Не впливає на «налагоджувальні» повідомлення.|";
            base_uk_UA = base_uk_UA + "Вимкнути підсумок в кінці сканування|";
            base_uk_UA = base_uk_UA + "Друкуйте лише заражені файли|";
            base_uk_UA = base_uk_UA + "Пропустити друк файлів OK|";
            base_uk_UA = base_uk_UA + "Звуковий сигнал при виявленні вірусу|";
            base_uk_UA = base_uk_UA + "Не видаляйте тимчасові файли|";
            base_uk_UA = base_uk_UA + "Згенеруйте JSON опис відсканованого файлу(ів). JSON буде надруковано, а також|";
            base_uk_UA = base_uk_UA + "Завантажуйте лише офіційні підписи|";
            base_uk_UA = base_uk_UA + "Сканувати підкаталоги рекурсивно|";
            base_uk_UA = base_uk_UA + "Після знаходження збігу продовжити сканування у файлі|";
            base_uk_UA = base_uk_UA + "Сканування файлів і каталогів в інших файлових системах|";
            base_uk_UA = base_uk_UA + "Видаліть заражені файли. Обережно!|";
            base_uk_UA = base_uk_UA + "Завантажити непідписаний байт-код. **Увага**: НІКОЛИ не слід запускати підписи байт-коду з ненадійних джерел. Це може призвести до виконання довільного коду.|";
            base_uk_UA = base_uk_UA + "Виявлення можливих небажаних програм|";
            base_uk_UA = base_uk_UA + "Виявлення структурованих даних (SSN, кредитна картка)|";
            base_uk_UA = base_uk_UA + "Сканувати поштові файли|";
            base_uk_UA = base_uk_UA + "Увімкнути виявлення фішингу за підписом електронної пошти|";
            base_uk_UA = base_uk_UA + "Увімкнути виявлення фішингу на основі сигнатур URL-адрес|";
            base_uk_UA = base_uk_UA + "Евристичні сповіщення|";
            base_uk_UA = base_uk_UA + "Зупиніть сканування, як тільки буде знайдено евристичний збіг|";
            base_uk_UA = base_uk_UA + "Нормалізувати html, скриптові та текстові файли. Використовуйте normalize=no для сумісності з yara|";
            base_uk_UA = base_uk_UA + "Сканувати PE-файли|";
            base_uk_UA = base_uk_UA + "Сканувати ELF-файли|";
            base_uk_UA = base_uk_UA + "Сканування контейнерів OLE2|";
            base_uk_UA = base_uk_UA + "Сканувати PDF-файли|";
            base_uk_UA = base_uk_UA + "Сканувати SWF-файли|";
            base_uk_UA = base_uk_UA + "Сканування HTML-файлів|";
            base_uk_UA = base_uk_UA + "Сканування файлів документів у форматі xml|";
            base_uk_UA = base_uk_UA + "Сканувати файли HWP3|";
            base_uk_UA = base_uk_UA + "Сканування архівних файлів (підтримується libclamav)|";
            base_uk_UA = base_uk_UA + "Сповіщення про пошкоджені виконувані файли (PE та ELF)|";
            base_uk_UA = base_uk_UA + "Сповіщення про пошкоджені графічні файли (JPEG, TIFF, PNG, GIF)|";
            base_uk_UA = base_uk_UA + "Сповіщення про зашифровані архіви та документи|";
            base_uk_UA = base_uk_UA + "Сповіщення про зашифровані архіви|";
            base_uk_UA = base_uk_UA + "Сповіщення про зашифровані документи|";
            base_uk_UA = base_uk_UA + "Попередження про OLE2-файли, що містять макроси VBA|";
            base_uk_UA = base_uk_UA + "Сповіщення про файли, які перевищують максимальний розмір файлу, максимальний розмір сканування або максимальний ліміт рекурсії|";
            base_uk_UA = base_uk_UA + "Сповіщення про імейли, що містять SSL невідповідності в URL-адресах|";
            base_uk_UA = base_uk_UA + "Сповіщення про листи, що містять приховані URL-адреси|";
            base_uk_UA = base_uk_UA + "Сповіщення про необроблені файли зображень DMG, що містять перетини розділів|";
            base_uk_UA = base_uk_UA + "Вимкнути перевірку ланцюжка сертифікатів автентичності в PE-файлах|";
            base_uk_UA = base_uk_UA + "Дамп ланцюжка сертифікатів authenticode у PE-файлах|";
            base_uk_UA = base_uk_UA + "Вимкнути кешування та перевірку хеш-сум сканованих файлів.|";
// new with version 1.4.2 of clamav
            base_uk_UA = base_uk_UA + "Створюйте тимчасові файли для сканування вкладених файлів, які інакше були б тільки в пам'яті|";
            base_uk_UA = base_uk_UA + "Згенеруйте метадані JSON для відсканованого файлу(ів). Використовувати ТІЛЬКИ для тестування та розробки.|";
            base_uk_UA = base_uk_UA + "Повертається ненульовий код помилки, якщо вірусна база даних застаріла.|";
            base_uk_UA = base_uk_UA + "Сканування файлів OneNote|";
            base_uk_UA = base_uk_UA + "Сканувати файли зображень (графіки)|";
            base_uk_UA = base_uk_UA + "Виявлення файлів шляхом обчислення нечітких хешів зображень (графіки)|";
            base_uk_UA = base_uk_UA + "Створюйте тимчасові файли для сканування вкладених файлів, які інакше були б тільки в пам'яті|";
// clamd.conf
            base_uk_UA = base_uk_UA + "Зберігати всі звіти у файл журналу. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "За замовчуванням файл журналу заблоковано для запису, і лише один процес демона може писати в нього. Цей параметр вимикає блокування. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Максимальний розмір файлу журналу. Значення 0 вимикає обмеження. За замовчуванням: 1048576|";
            base_uk_UA = base_uk_UA + "Час журналу для кожного повідомлення. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Реєструвати всі чисті файли. Корисно для налагодження, але значно збільшує розмір журналу. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Використовувати системний журнал (може працювати разом з LogFile). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Тип повідомлень системного журналу. Будь ласка, зверніться до 'man syslog' для назв засобів. (LOG_LOCAL6, LOG_MAIL), за замовчуванням: LOG_LOCAL6|";
            base_uk_UA = base_uk_UA + "Увімкнути детальне журналювання. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Обертати файл журналу. Потрібна опція LogFileMaxSize, установлена ​​перед цією опцією. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Зареєструвати додаткову інформацію про заражений файл, наприклад його розмір і хеш, разом із назвою вірусу. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Записати pid демона у вказаний файл. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє змінити типовий тимчасовий каталог. За замовчуванням: /tmp|";
            base_uk_UA = base_uk_UA + "Цей параметр дозволяє змінити каталог бази даних за замовчуванням. Якщо ви ввімкнете його, переконайтеся, що він вказує на той самий каталог у clamd і freshclam. За замовчуванням: /usr/local/share/clamav|";
            base_uk_UA = base_uk_UA + "Завантажувати лише офіційні підписи, опубліковані проектом ClamAV. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Повернути з ненульовим кодом помилки, якщо вірусна база старше вказаної кількості днів. За замовчуванням: -1|";
            base_uk_UA = base_uk_UA + "Шлях до локального (Unix) сокета, який демон слухатиме. Типове значення: вимкнено|";
            base_uk_UA = base_uk_UA + "Встановлює групове право власності на сокет Unix. За замовчуванням: |";
            base_uk_UA = base_uk_UA + "Встановлює дозволи на сокет unix у вказаний режим. За замовчуванням: 660|";
            base_uk_UA = base_uk_UA + "Видалити застарілий сокет після нечистого завершення роботи. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Номер порту TCP, який демон слухатиме. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "За замовчуванням clamd прив’язується до INADDR_ANY. Ця опція дозволяє обмежити TCP-адресу та забезпечити певний ступінь захисту від зовнішнього світу. Цю опцію можна вказати кілька разів, щоб прослуховувати кілька IP-адрес. IPv6 тепер підтримується. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Максимальна довжина черги очікуваних з'єднань може зрости. За замовчуванням: 200|";
            base_uk_UA = base_uk_UA + "Закрийте сеанс STREAM, коли перевищено ліміт розміру даних. Значення має відповідати обмеженню вашого MTA для максимального розміру вкладення. За замовчуванням: 100M|";
            base_uk_UA = base_uk_UA + "Команда STREAM використовує протокол, схожий на FTP. Ця опція встановлює нижню межу діапазону портів. Типове значення: 1024|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює верхню межу діапазону портів. За замовчуванням: 2048|";
            base_uk_UA = base_uk_UA + "Максимальна кількість потоків, що працюють одночасно. За замовчуванням: 10|";
            base_uk_UA = base_uk_UA + "Ця опція вказує час (у секундах), після якого clamd має закінчитися, якщо клієнт не надає жодних даних. Типове значення: 120|";
            base_uk_UA = base_uk_UA + "Ця опція вказує час (у секундах), після якого clamd має закінчитися, якщо клієнт не надає жодної початкової команди після підключення. За замовчуванням установлено значення 30, щоб уникнути тайм-аутів із TCP-сокетами під час обробки великих повідомлень. Якщо використовується сокет Unix, значення можна змінити на 5. Примітка: час очікування для наступних команд та/або блоків даних визначається ReadTimeout. Типове значення: 30|";
            base_uk_UA = base_uk_UA + "Ця опція вказує, як довго чекати (у мілісекундах), якщо буфер надсилання заповнений. Тримайте це значення низьким, щоб запобігти зависанню clamd. Типове значення: 500|";
            base_uk_UA = base_uk_UA + "Максимальна кількість елементів у черзі (включно з тими, що обробляються потоками MaxThreads). Рекомендується мати це значення принаймні вдвічі більше MaxThreads, якщо це можливо. ПОПЕРЕДЖЕННЯ: не слід збільшувати це значення занадто сильно, щоб уникнути вичерпання дескрипторів файлів, має виконуватись така умова: MaxThreads*MaxRecursion + MaxQueue - MaxThreads + 6 < RLIMIT_NOFILE — це максимальна кількість відкритих файлових дескрипторів (зазвичай 1024), встановлена ​​параметром ulimit -n. За замовчуванням: 100|";
            base_uk_UA = base_uk_UA + "Ця опція вказує, як довго (у секундах) процес має чекати нового завдання. За замовчуванням: 30|";
            base_uk_UA = base_uk_UA + "Не сканувати файли та каталоги, що відповідають REGEX. Цю директиву можна використовувати кілька разів. Типове значення: вимкнено|";
            base_uk_UA = base_uk_UA + "Скануються каталоги максимальної глибини. За замовчуванням: 15|";
            base_uk_UA = base_uk_UA + "Дотримуйтесь символічних посилань каталогу. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Сканувати файли та каталоги в інших файлових системах. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Дотримуйтеся звичайних символічних посилань файлів. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Ця опція вказує часові інтервали (у секундах), протягом яких clamd має виконувати перевірку бази даних. Типове значення: 600|";
            base_uk_UA = base_uk_UA + "Увімкнути неблокуюче (багатопотокове/одночасне) перезавантаження бази даних. Ця функція тимчасово завантажуватиме другий механізм сканування, поки сканування продовжується за допомогою першого механізму. Після завантаження новий механізм бере на себе роботу. Старий механізм видаляється, щойно всі сканування за допомогою старого механізму завершаться. Ця функція вимагає більше оперативної пам’яті, тому ця опція надається, якщо користувачі бажають заблокувати сканування під час перезавантаження в обмін на зниження вимог до оперативної пам'яті Типове значення: так|";
            base_uk_UA = base_uk_UA + "Виконайте команду, коли знайдено вірус. Використовуйте наступні змінні середовища для ідентифікації файлів і імен вірусів: - $CLAVIRUSEVENT_FILENAME - $CLAVIRUSEVENT_VIRUSNAME У командному рядку \"%v\" також буде замінено назвою вірусу. Примітка. Символ формату назви файлу \"%f\" вимкнено та більше не замінюватиметься на ім'я файлу через проблеми безпеки ін'єкцій. Замість цього використовуйте змінну середовища 'CLAVIRUSEVENT_FILENAME'. З тієї ж причини НЕ слід використовувати змінні середовища в команді безпосередньо, але слід використовувати її з виконуваного сценарію.|";
            base_uk_UA = base_uk_UA + "Зупинити демон, коли libclamav повідомляє про стан пам'яті. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Дозволити використання команди ALLMATCHSCAN. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Не переходити у фоновий режим. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Увімкнути повідомлення про налагодження від libclamav. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Не видаляти тимчасові файли (з метою налагодження). За замовчуванням: немає GenerateMetadataJson BOOL Запис метаданих про файл, який сканується. Метадані сканування корисні для цілей аналізу файлів і для налагодження поведінки сканування. Метадані JSON буде надруковано після завершення сканування, якщо ввімкнено Debug. Файл metadata.json буде записаний до сканування temp каталог, якщо LeaveTemporaryFiles увімкнено: no|";
            base_uk_UA = base_uk_UA + "Запускати демон від імені вказаного користувача (процес повинен бути запущений адміністратором). За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Якщо цю опцію ввімкнено, ClamAV завантажуватиме байт-код із бази даних. Настійно рекомендується залишати цю опцію увімкненою, інакше ви можете пропустити виявлення багатьох нових вірусів. Типове значення: так|";
            base_uk_UA = base_uk_UA + "Встановити рівень безпеки байт-коду. Можливі значення: TrustSigned - довіряти байт-коду, завантаженому з підписаних файлів .c[lv]d, і вставляти перевірки безпеки під час виконання для байт-коду, завантаженого з інших джерел, Paranoid - не довіряти жодному байт-коду, вставляти перевірки часу виконання для всіх. Рекомендовано: TrustSigned, оскільки байт-код у файлах .cvd уже має ці перевірки. (TrustSigned, Paranoid) Типове значення: TrustSigned|";
            base_uk_UA = base_uk_UA + "Установити час очікування байт-коду в мілісекундах. За замовчуванням: 10000|";
            base_uk_UA = base_uk_UA + "Дозволити завантаження байт-коду з зовнішніх файлів .c[lv]d з цифровим підписом. **Застереження**: НІКОЛИ не слід запускати підписи байт-коду з ненадійних джерел. Це може призвести до виконання довільного коду. Типове значення: ні|";
            base_uk_UA = base_uk_UA + "Встановити режим виконання байт-коду. Можливі значення: Auto - автоматично вибирати JIT, якщо можливо, повертатися до інтерпретатора ForceJIT - завжди вибирати JIT, не вдаватися, якщо неможливо ForceInterpreter - завжди вибирати інтерпретатор Test - запускати з JIT і інтерпретатором і порівнювати результати. Зробити всі збої фатальними. За замовчуванням: Auto|";
            base_uk_UA = base_uk_UA + "Виявлення можливо небажаних програм. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Виключити конкретну категорію PUA. Цю директиву можна використовувати кілька разів. Див. https://docs.clamav.net/faq/faq-pua.html для повного списку категорій PUA. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Включати лише певну категорію PUA. Цю директиву можна використовувати кілька разів. Див. https://docs.clamav.net/faq/faq-pua.html для повного списку категорій PUA. Типове значення: вимкнено|";
            base_uk_UA = base_uk_UA + "У деяких випадках (наприклад, складне шкідливе програмне забезпечення, експлойти в графічних файлах тощо), ClamAV використовує спеціальні алгоритми для забезпечення точного виявлення. Цей параметр контролює алгоритмічне виявлення. Типове значення: так|";
            base_uk_UA = base_uk_UA + "Дозволити перевагу евристичному збігу. Якщо ввімкнено, якщо евристичне сканування (наприклад, phishingScan) виявить можливий вірус/фішинг, сканування буде негайно припинено. Рекомендовано, економить час сканування ЦП. Якщо вимкнено, віруси/фішинг, виявлені евристичним скануванням, повідомлятимуть лише наприкінці сканування. Якщо архів містить як евристично виявлений, так і вірус/фішинг, справжнє зловмисне програмне забезпечення буде вимкнено, якщо ви маєте намір обробляти віруси \"*.Euristics.*\" інакше, ніж \"справжні\" шкідливі програми.|";
            base_uk_UA = base_uk_UA + "PE означає Portable Executable - це формат виконуваного файлу, який використовується у всіх 32- та 64-розрядних версіях операційних систем Windows. Ця опція дозволяє ClamAV виконувати глибший аналіз виконуваних файлів, а також потрібна для розпакування популярних пакувальників виконуваних файлів, таких як UPX. Якщо вимкнути цю опцію, оригінальні файли все одно скануватимуться, але без додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Формат виконуваних файлів і посилань — це стандартний формат для виконуваних файлів UN*X. Ця опція дозволяє контролювати сканування файлів ELF. Якщо вимкнути цю опцію, вихідні файли все одно скануватимуться, але без додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Увімкнути сканування поштових файлів. Якщо ви вимкнете цю опцію, оригінальні файли все одно скануватимуться, але без аналізу окремих повідомлень/вкладень. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Сканувати повідомлення RFC1341, розділені на багато електронних листів. Вам потрібно буде періодично очищати каталог $TemporaryDirectory/clamav-partial. ПОПЕРЕДЖЕННЯ: ця опція може відкрити вашу систему для DoS-атаки. Ніколи не використовуйте її на завантажених серверах. Типове значення: ні|";
            base_uk_UA = base_uk_UA + "Увімкнути виявлення фішингу на основі підпису електронної пошти. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Увімкнути виявлення фішингу на основі підпису URL-адреси (Euristics.Phishing.Email.*) За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Увімкнути модуль DLP. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює найменшу кількість номерів кредитних карток, знайдених у файлі для створення виявлення. За замовчуванням: 3|";
            base_uk_UA = base_uk_UA + "Якщо цю опцію ввімкнено, модуль DLP шукатиме лише дійсні номери кредитних карток. Дебетові картки та картки приватних марок не шукатимуться. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює найменшу кількість номерів соціального страхування, знайдених у файлі, для створення виявлення. За замовчуванням: 3|";
            base_uk_UA = base_uk_UA + "Якщо цю опцію ввімкнено, модуль DLP шукатиме дійсні SSN у форматі xxx-yy-zzzz. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Якщо цю опцію ввімкнено, модуль DLP шукатиме дійсні SSN у форматі xxxyyzzzz. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Виконати нормалізацію та дешифрування HTML/JavaScript/ScriptEncoder. Якщо ви вимкнете цю опцію, вихідні файли все одно скануватимуться, але без додаткової обробки. Типове значення: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати файли OLE2, такі як документи Microsoft Office і файли .msi. Якщо вимкнути цю опцію, оригінальні файли все одно скануватимуться, але без додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати PDF-файли. Якщо вимкнути цю опцію, вихідні файли все одно скануватимуться, але без додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати файли SWF. Якщо вимкнути цю опцію, оригінальні файли все одно скануватимуться, але без декодування та додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати файли документів на основі xml, які підтримуються libclamav. Якщо ви вимкнете цю опцію, оригінальні файли все одно скануватимуться, але без додаткової обробки. Типове значення: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати файли HWP3. Якщо ви вимкнете цю опцію, вихідні файли все одно скануватимуться, але без додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати файли OneNote. Якщо ви вимкнете цю опцію, вихідні файли все одно скануватимуться, але без додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Сканувати всередині архівів і стиснених файлів. Якщо вимкнути цю опцію, вихідні файли все одно скануватимуться, але без розпакування та додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє сканувати зображення (графіку). Якщо вимкнути цю опцію, оригінальні файли все одно будуть скануватися, але без розпакування та додаткової обробки. За замовчуванням: так|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє виявлення шляхом обчислення нечіткого хешу файлів зображень (графіки). Підписи з використанням нечітких хешів зображень зазвичай збігаються з файлами та документами, ідентифікуючи зображення, вбудовані або прикріплені до цих файлів. Якщо вимкнути цю опцію, деякі файли можуть більше не виявлятися. Типове: так|";
            base_uk_UA = base_uk_UA + "Сповіщення про пошкоджені виконувані файли (PE & ELF). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Попередження про пошкоджені графічні файли (JPEG, TIFF, PNG, GIF). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Сповіщення про зашифровані архіви та документи (зашифровані .zip, .7zip, .rar, .pdf). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Сповіщення про зашифровані архіви (зашифровані .zip, .7zip, .rar). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Сповіщення про зашифровані документи (зашифровані .pdf). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Попередження про файли OLE2, що містять макроси VBA (Euristics.OLE2.ContainsMacros). За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Якщо встановлено AlertExceedsMax, файли, що перевищують ліміт MaxFileSize, MaxScanSize або MaxRecursion, позначатимуться прапорцями з назвою вірусу, яка починається з \"Euristics.Limits.Exceeded\". Типове значення: ні|";
            base_uk_UA = base_uk_UA + "Попередження про електронні листи, які містять невідповідності SSL в URL-адресах (може призвести до помилкових спрацьовувань!). Типове значення: ні|";
            base_uk_UA = base_uk_UA + "Попередження про електронні листи, що містять приховані URL-адреси (може призвести до помилкових спрацьовувань). Типове значення: ні|";
            base_uk_UA = base_uk_UA + "Сповіщення про необроблені файли зображень DMG, що містять перетини розділів. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє вимкнути функцію кешування двигуна. За замовчуванням механізм зберігатиме MD5 у кеш-пам’яті будь-яких файлів, які не позначено як вірус або які пройшли перевірку обмежень. Попередження: вимкнення кешу матиме негативний вплив на продуктивність великих сканувань. Типове значення: ні|";
            base_uk_UA = base_uk_UA + "Цей параметр дозволяє встановити кількість записів, які може зберігати кеш. Значення має бути квадратним числом або буде округлено до найближчого квадратного числа. За замовчуванням: 65536|";
            base_uk_UA = base_uk_UA + "Ця опція змушує сканування пам’яті або вкладених карт вивантажувати вміст на диск. Якщо ви ввімкнете цю опцію, більше даних буде записано на диск і стане доступним, якщо ввімкнуто параметр залишити, за рахунок збільшення кількості записів на диск. Типове: ні|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний час, який може знадобитися для завершення сканування. Значення вказано в мілісекундах. Значення 0 вимикає обмеження. ПОПЕРЕДЖЕННЯ: вимкнення цього обмеження або його встановлення занадто високим може призвести до дозволу сканування певних файлів, щоб заблокувати процес/потоки сканування, що призведе до відмови в обслуговуванні. За замовчуванням: 120000|";
            base_uk_UA = base_uk_UA + "Встановлює максимальний обсяг даних для сканування для кожного вхідного файлу. Архіви та інші контейнери рекурсивно витягуються та скануються до цього значення. Розмір архіву плюс сума розмірів усіх файлів в архіві зараховується до розміру сканування. Наприклад, 1 Мб нестисненого архіву, що містить один 1Мб внутрішнього файлу, зараховується як 2Мб до максимальний розмір сканування. Попередження: вимкнення цього обмеження або встановлення його занадто великого розміру може призвести до серйозних пошкоджень системи. За замовчуванням: 400M|";
            base_uk_UA = base_uk_UA + "Файли, розмір яких перевищує цей ліміт, не скануватимуться. Впливає на сам вхідний файл, а також на файли, що містяться в ньому (якщо вхідний файл є архівом, документом або іншим типом контейнера). Попередження: вимкнення цього ліміту або його встановлення занадто високим може призвести до серйозної шкоди системі. Технічні обмеження дизайну не дозволяють ClamAV сканувати файли, розмір яких перевищує 2 ГБ, наразі. За замовчуванням: 100M|";
            base_uk_UA = base_uk_UA + "Вкладені архіви скануються рекурсивно, наприклад, якщо Zip-архів містить RAR-файл, усі файли в ньому також будуть скановані. Цей параметр визначає, наскільки глибоко слід продовжувати процес. Попередження: встановлення цього обмеження зависоке може призвести до серйозних пошкоджень системи. За замовчуванням: 17|";
            base_uk_UA = base_uk_UA + "Кількість файлів для сканування в архіві, документі або будь-якому іншому типі контейнера. Попередження: вимкнення цього обмеження або його встановлення занадто високим може призвести до серйозних пошкоджень системи. Типове значення: 10000|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний розмір файлу для перевірки на наявність вбудованого PE. Файли, більші за це значення, пропустять додатковий крок аналізу. Від'ємні значення не допускаються. За замовчуванням: 40M|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний розмір HTML-файлу для нормалізації. HTML-файли, більші за це значення, не нормалізуються чи скануються. Негативні значення не допускаються. За замовчуванням: 40M|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний розмір нормалізованого HTML-файлу для сканування. HTML-файли, більші за це значення, після нормалізації не скануватимуться. Негативні значення не допускаються. За замовчуванням: 8M|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний розмір файлу сценарію для нормалізації. Вміст сценарію, більший за це значення, не буде нормалізовано або скановано. Негативні значення не допускаються. За замовчуванням: 20M|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний розмір ZIP-файлу для повторного аналізу розпізнавання типу. ZIP-файли, більші за це значення, пропускатимуть крок для потенційного повторного аналізу як PE. Негативні значення не допускаються. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження надто високого може призвести до серйозної шкоди або погіршення продуктивності. За замовчуванням: 1M|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальну кількість розділів необробленого образу диска, який потрібно сканувати. Необроблені образи дисків із більшою кількістю розділів, ніж це значення, матимуть до сканованих розділів значення. Негативні значення не допускаються. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження надто високого може призвести до серйозної шкоди або погіршити продуктивність. Типове значення: 50|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальну кількість піктограм у PE для сканування. PE-файли з більшою кількістю піктограм, ніж це значення, матимуть не більше значення кількості сканованих піктограм. Негативні значення не допускаються. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження надто високого може призвести до серйозної шкоди або погіршити продуктивність.|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальну кількість рекурсивних викликів функції синтаксичного аналізу HWP3. Файли HWP3, які використовують більше, ніж це обмеження, буде припинено та сповіщено користувача. Сканування не зможуть сканувати жодні вкладені файли HWP3, якщо досягнуто обмеження рекурсивної дії. Негативні значення не допускаються. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження надто високого може призвести до серйозної шкоди або погіршити продуктивність.|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальну кількість викликів функції збігу PCRE під час перевірки регулярних виразів. Примірники, які використовують більше, ніж це обмеження, будуть припинені та сповіщатимуть користувача, але сканування продовжуватиметься. Щоб отримати додаткові відомості про match_limit, перегляньте документацію PCRE. Від'ємні значення не допускаються. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження надто високо може серйозно вплинути на продуктивність. За замовчуванням: 10000|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальну кількість рекурсивних викликів функції збігу PCRE під час перевірки регулярних виразів. Примірники, які використовують більше, ніж це обмеження, будуть припинені та попередять користувача, але сканування продовжуватиметься. Щоб отримати додаткові відомості про match_limit_recursion, перегляньте документацію PCRE. Негативні значення не дозволені, а значення > PCREMatchLimit є зайвими. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження також висока може сильно вплинути на продуктивність: 2000|";
            base_uk_UA = base_uk_UA + "Ця опція встановлює максимальний розмір файлу, для якого виконуватимуться субпідписи PCRE. Для файлів, що перевищують це обмеження, підпідписи PCRE не виконуватимуться, якщо тільки підпідпис не включено до меншого буфера. Від’ємні значення не допускаються. Встановлення цього значення до нуля вимикає обмеження. ПОПЕРЕДЖЕННЯ: встановлення цього обмеження занадто високе або його вимкнення може серйозно вплинути на продуктивність. За замовчуванням: 100M|";
            base_uk_UA = base_uk_UA + "Цей параметр визначає каталог (включно з усіма файлами та каталогами в ньому), який слід сканувати під час доступу. Цей параметр можна використовувати багаторазово. Типове значення: вимкнено|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє виключати каталоги зі сканування під час доступу. Її можна використовувати кілька разів. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "За допомогою цього параметра ви можете виключити root UID (0). Процеси, запущені під root, зможуть отримати доступ до всіх файлів без ініціювання сканування або подій відмови в дозволі. Зауважте, що якщо clamd не може перевірити uid процесу, який створив подію сканування під час доступу (наприклад, оскільки OnAccessPrevention не було ввімкнено, і процес уже вийшов), clamd виконає сканування. Таким чином, встановлення OnAccessExcludeRootUID не гарантує запобігання запуску сканування кожним доступом користувача root (якщо OnAccessPrevention не ввімкнено за замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "За допомогою цього параметра ви можете виключити певні UID. Процеси з цими UID матимуть доступ до всіх файлів без ініціювання сканування або подій відмови у дозволі. Цей параметр можна використовувати кілька разів (по одному на рядок). Примітка: використання значення 0 у будь-якому рядку повністю вимкне цей параметр. Щоб виключити кореневий UID (0), увімкніть параметр OnAccessExcludeRootUID. Також зауважте, що якщо clamd не може перевірити uid процесу, який створив подію сканування під час доступу (наприклад, через те, що OnAccessPrevention не було ввімкнено, і процес уже завершився), clamd виконає сканування, таким чином, встановлення OnAccessExcludeUID не гарантує, що кожен доступ за допомогою вказаного uid буде запускати сканування (якщо OnAccessPrevention не ввімкнено). За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Ця опція дозволяє робити виключення через імена користувачів під час використання клієнта сканування під час доступу. Її можна використовувати кілька разів і вона має ті самі потенційні обмеження умов змагання, що й опція OnAccessExcludeUID. Типове значення: вимкнено|";
            base_uk_UA = base_uk_UA + "Файли, розмір яких перевищує це значення, не скануватимуться під час доступу. За замовчуванням: 5M|";
            base_uk_UA = base_uk_UA + "Максимальна кількість потоків сканування для виділення пулу потоків OnAccess під час запуску. Ці потоки відповідають за створення з’єднання з демоном і запуск сканування після обробки події. Щоб запобігти споживанню clamonacc усіх ресурсів clamd, тримайте це значення нижче, ніж максимальне значення потоків clamd. За замовчуванням: 5|";
            base_uk_UA = base_uk_UA + "Максимальний час (у мілісекундах), який клієнт OnAccess повинен витрачати на кожну спробу підключення, надсилання та отримання під час спілкування з clamd через curl. За замовчуванням: 5000 (5 секунд)|";
            base_uk_UA = base_uk_UA + "Вказує точку монтування (включаючи всі файли та каталоги під нею), яку слід сканувати під час доступу. Цю опцію можна використовувати кілька разів. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Вимикає систему динамічного визначення каталогу, яка дозволяє рекурсивно переглядати включені шляхи. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Вмикає блокування fanotify при виявленні шкідливих файлів. За замовчуванням: вимкнено|";
            base_uk_UA = base_uk_UA + "Кількість разів, коли клієнт OnAccess повторюватиме невдале сканування через проблеми з підключенням (або інші проблеми). Типове значення: 0|";
            base_uk_UA = base_uk_UA + "Під час використання запобігання, якщо цей параметр увімкнено, будь-які помилки, що виникають під час сканування, призведуть до відхилення спроби події. Це потенційно може призвести до небажаної поведінки системи з певними конфігураціями, тому клієнт за замовчуванням вимкнено та надає перевагу дозволу подій доступу у разі сканування або помилки з’єднання. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Вимикає додаткове сканування та сповіщення, коли файл або каталог створюється або переміщується. Потрібна система DDD для запуску додаткових сканувань. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Вимкнути перевірку ланцюжка сертифікатів автентикоду в PE-файлах. За замовчуванням: ні|";
            base_uk_UA = base_uk_UA + "Зберігайте URI html у метаданих. Ідентифікатори URI будуть записані у файл metadata.json у масиві під назвою «URI».|";
            base_uk_UA = base_uk_UA + "Зберігайте URI PDF-файлів у метаданих. Ідентифікатори URI будуть записані у файл metadata.json у масиві під назвою «URI».|";
            base_uk_UA = base_uk_UA + "Зберігайте md5 і sha1 на додаток до sha2-256 у метаданих.|";
            base_uk_UA = base_uk_UA + "Друкуйте хеш файлу після кожного сканованого файлу.|";
            base_uk_UA = base_uk_UA + "Друкуйте тип файлу після кожного сканованого файлу.|";
            base_uk_UA = base_uk_UA + "Забезпечте обмеження, подібні до FIPS, на використання алгоритмів хешування для криптографічних цілей. Вимкне MD5 і SHA1. PHP підписує та вимагатиме файлів '.sign' для перевірки автентичності CVD.";

// End of DATA-Block

    QStringList originals = base.split("|");
    QStringList translations;
    QString rc = original;

    if (m_languageset == "[de_DE]") translations = base_de_DE.split("|");
    if ((m_languageset == "[pt_PT]") || (m_languageset == "[pt_AO]") || (m_languageset == "[pt_BR]") || (m_languageset == "[pt_CV]") || (m_languageset == "[pt_MZ]") || (m_languageset == "[pt_MO]") || (m_languageset == "[pt_ST]") || (m_languageset == "[pt_TL]")) translations = base_pt_PT.split("|");
    if (m_languageset == "[it_IT]") translations = base_it_IT.split("|");
    if (m_languageset == "[da_DK]") translations = base_da_DK.split("|");
    if (m_languageset == "[fr_FR]") translations = base_fr_FR.split("|");
    if (m_languageset == "[es_ES]") translations = base_es_ES.split("|");
    if (m_languageset == "[uk_UA]") translations = base_uk_UA.split("|");
    if (translations.length() == 0) translations = base.split("|");

    QString helper;
    int pos = originals.indexOf(original);

    if (pos != -1) {
        rc = "";
        helper = translations.at(pos);
    } else helper = "<<< " + original + ">>>";

    rc = helper;

    return rc;
}
