// Copyright 2018-2025 the Deno authors. MIT license.

// This file is auto-generated by tools/update_tsgo.ts
// DO NOT EDIT THIS FILE MANUALLY

pub struct Hashes {
  pub windows_x64: &'static str,
  pub macos_x64: &'static str,
  pub macos_arm64: &'static str,
  pub linux_x64: &'static str,
  pub linux_arm64: &'static str,
}

impl Hashes {
  pub const fn all(&self) -> [&'static str; 5] {
    [
      self.windows_x64,
      self.macos_x64,
      self.macos_arm64,
      self.linux_x64,
      self.linux_arm64,
    ]
  }
}

pub const VERSION: &str = "0.1.8";
pub const DOWNLOAD_BASE_URL: &str =
  "https://github.com/denoland/typescript-go/releases/download/v0.1.8";
pub const HASHES: Hashes = Hashes {
  windows_x64: "sha256:3e5c7102c387d1b85795e0baf402e93a1c3bd82d75b5ad90089ea72f0525bc22",
  macos_x64: "sha256:5f31471910b585dfbffdd370ffd0d0dc9f408e1b7482e293a84246d7c8bf980b",
  macos_arm64: "sha256:73d88c842a5276d721f38c6b749a923417f1c42f237fafe06ed4c50d772dda71",
  linux_x64: "sha256:e83798203401f8fd31f2539ef23c1bc76a9bf02cfe6902dc854310ed8d994454",
  linux_arm64: "sha256:f82e11a474bb9e69e0397c614ab30a08eb09c93c69bb3de19364ef660a851ede",
};

const _: () = {
  let sha256 = "sha256".as_bytes();

  let mut i = 0;
  let hashes = HASHES.all();

  while i < hashes.len() {
    let hash = hashes[i].as_bytes();
    let mut j = 0;

    while j < 6 {
      if hash[j] != sha256[j] {
        panic!("Hash algorithm is not sha256");
      }
      j += 1;
    }
    i += 1;
  }
};
