### This file is generated by opam2nix.

self:
let
    lib = self.lib;
    pkgs = self.pkgs;
    repoPath = self.repoPath;
    repos = 
    {
      opam-repository = 
      rec {
        fetch = 
        {
          owner = "ocaml";
          repo = "opam-repository";
          rev = "a8e6a61ca4b6c45e8812cd438ac3faf4d0f5650b";
          sha256 = "00ki4pz8dpjn05665l0yqab9sdw4cwvs7xfr99kdnlv0xsn9gf6s";
        };
        src = (pkgs.fetchFromGitHub) fetch;
      };
    };
    selection = self.selection;
in
{
  format-version = 4;
  ocaml-version = "4.12.0";
  repos = repos;
  selection = 
  {
    astring = 
    {
      opamInputs = 
      {
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
        topkg = selection.topkg;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1djnad9sq12idlakj069xvwm2nn7wqm137pqbxxai5frkgi08x74";
        package = "packages/astring/astring.0.8.5";
      };
      pname = "astring";
      src = pkgs.fetchurl 
      {
        sha256 = "1ykhg9gd3iy7zsgyiy2p9b1wkpqg9irw5pvcqs3sphq71iir4ml6";
        url = "https://erratique.ch/software/astring/releases/astring-0.8.5.tbz";
      };
      version = "0.8.5";
    };
    base = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        dune-configurator = selection.dune-configurator;
        ocaml = selection.ocaml;
        sexplib0 = selection.sexplib0;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:014xlh33ayf440lf9yx62z43q9977254911p3jyncw2hrmarny4h";
        package = "packages/base/base.v0.14.1";
      };
      pname = "base";
      src = pkgs.fetchurl 
      {
        sha256 = "13b0xc62ka8i2ry2r62gc194wzfdq1vqf2qygwrrk26pvqn8a9l9";
        url = "https://github.com/janestreet/base/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    base-bytes = 
    {
      opamInputs = 
      {
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0a68lmbf68jgm1i3b59j2sc3ha9yhv4678f9mfwwvczw88prq7l3";
        package = "packages/base-bytes/base-bytes.base";
      };
      pname = "base-bytes";
      src = null;
      version = "base";
    };
    base-threads = 
    {
      opamInputs = {
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1c4bpyh61ampjgk5yh3inrgcpf1z1xv0pshn54ycmpn4dyzv0p2x";
        package = "packages/base-threads/base-threads.base";
      };
      pname = "base-threads";
      src = null;
      version = "base";
    };
    base-unix = 
    {
      opamInputs = {
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0mpsvb7684g723ylngryh15aqxg3blb7hgmq2fsqjyppr36iyzwg";
        package = "packages/base-unix/base-unix.base";
      };
      pname = "base-unix";
      src = null;
      version = "base";
    };
    base_bigstring = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_jane = selection.ppx_jane;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0yn51npq4fwi9nllfhq2r3kkb17pg3igvvjgblac1g3v0nmhj6c4";
        package = "packages/base_bigstring/base_bigstring.v0.14.0";
      };
      pname = "base_bigstring";
      src = pkgs.fetchurl 
      {
        sha256 = "1fhldk58w56ixkin763kpic512xvkkf9b4mrnjfsbm8in75kzndq";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/base_bigstring-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    base_quickcheck = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_base = selection.ppx_base;
        ppx_fields_conv = selection.ppx_fields_conv;
        ppx_let = selection.ppx_let;
        ppx_sexp_message = selection.ppx_sexp_message;
        ppx_sexp_value = selection.ppx_sexp_value;
        ppxlib = selection.ppxlib;
        splittable_random = selection.splittable_random;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0lxxagkyg1jh0x7bbps1972bid51a82m1h2x3nyz342dnsy4k6h1";
        package = "packages/base_quickcheck/base_quickcheck.v0.14.1";
      };
      pname = "base_quickcheck";
      src = pkgs.fetchurl 
      {
        sha256 = "0n5h0ysn593awvz4crkvzf5r800hd1c55bx9mm9vbqs906zii6mn";
        url = "https://github.com/janestreet/base_quickcheck/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    bigarray-compat = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0mcg8csmd60ph17vam1s8xjsl9kp6k77i3mnkbxy0jvkn49m4a0k";
        package = "packages/bigarray-compat/bigarray-compat.1.0.0";
      };
      pname = "bigarray-compat";
      src = pkgs.fetchurl 
      {
        sha256 = "1bpmmnxb1yx72aqlbdaqfl18rgz1cq9cf6cqvnfl88mz5dfr4x0d";
        url = "https://github.com/mirage/bigarray-compat/archive/v1.0.0.tar.gz";
      };
      version = "1.0.0";
    };
    bin_prot = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        mirage-xen-ocaml = selection.mirage-xen-ocaml or null;
        ocaml = selection.ocaml;
        ppx_compare = selection.ppx_compare;
        ppx_custom_printf = selection.ppx_custom_printf;
        ppx_fields_conv = selection.ppx_fields_conv;
        ppx_optcomp = selection.ppx_optcomp;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppx_variants_conv = selection.ppx_variants_conv;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:17ylwhh1kv9klavfag20n4g3175i7nmljbdj12z9yiqm4da3r4rk";
        package = "packages/bin_prot/bin_prot.v0.14.0";
      };
      pname = "bin_prot";
      src = pkgs.fetchurl 
      {
        sha256 = "1f1ng6cixi3ci0nb765yfzqk9b3s752hy1i3702kh59gni1psycp";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/bin_prot-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    biniou = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        easy-format = selection.easy-format;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1m9s9v4zr7022k6d50482qq7w41fdqp58nkpfhcp8574hg65kh69";
        package = "packages/biniou/biniou.1.2.1";
      };
      pname = "biniou";
      src = pkgs.fetchurl 
      {
        sha256 = "0da3m0g0dhl02jfynrbysjh070xk2z6rxcx34xnqx6ljn5l6qm1m";
        url = "https://github.com/mjambon/biniou/releases/download/1.2.1/biniou-1.2.1.tbz";
      };
      version = "1.2.1";
    };
    bisect_ppx = 
    {
      opamInputs = 
      {
        base-unix = selection.base-unix;
        cmdliner = selection.cmdliner;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0bgsv2i9zq8xzasbrq36m41mmawmbxrq8hp02b7vfi6mv5f44ksd";
        package = "packages/bisect_ppx/bisect_ppx.2.6.0";
      };
      pname = "bisect_ppx";
      src = pkgs.fetchurl 
      {
        sha256 = "13nskfi8xms6zgifdnjlvl0ndb638s27rpam6hrxnk6phj7n856k";
        url = "https://github.com/aantron/bisect_ppx/archive/2.6.0.tar.gz";
      };
      version = "2.6.0";
    };
    camomile = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:08z0c35bcm72ch2n7w0b1x7xnwn2hhcky5r6vyz8hi4m9jqv6azv";
        package = "packages/camomile/camomile.1.0.2";
      };
      pname = "camomile";
      src = pkgs.fetchurl 
      {
        sha256 = "0chn7ldqb3wyf95yhmsxxq65cif56smgz1mhhc7m0dpwmyq1k97h";
        url = "https://github.com/yoriyuki/Camomile/releases/download/1.0.2/camomile-1.0.2.tbz";
      };
      version = "1.0.2";
    };
    charInfo_width = 
    {
      opamInputs = 
      {
        camomile = selection.camomile;
        dune = selection.dune;
        ocaml = selection.ocaml;
        result = selection.result;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1llh67ns94c9jn1mki2crs0r4ny0v249q7anj0phb8dijda6jd89";
        package = "packages/charInfo_width/charInfo_width.1.1.0";
      };
      pname = "charInfo_width";
      src = pkgs.fetchurl 
      {
        sha256 = "0wl1hcwbx2mmgbhwh1wwgjixvppjq0k43nqyq13xm4pvgdxfvci1";
        url = "https://github.com/kandu/charInfo_width/archive/1.1.0.tar.gz";
      };
      version = "1.1.0";
    };
    cinaps = 
    {
      opamInputs = 
      {
        base-unix = selection.base-unix;
        dune = selection.dune;
        ocaml = selection.ocaml;
        re = selection.re;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:01ycwfmid8zkir81g425dvjnjfdd58z2zjxig0aqwxgdxc139931";
        package = "packages/cinaps/cinaps.v0.15.1";
      };
      pname = "cinaps";
      src = pkgs.fetchurl 
      {
        sha256 = "0w3125jfwckvmd3dx3r0qx7hj9kahdi9nqf3cqsv19nqymq8xq8v";
        url = "https://github.com/ocaml-ppx/cinaps/archive/v0.15.1.tar.gz";
      };
      version = "v0.15.1";
    };
    cmdliner = 
    {
      opamInputs = {
                     ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:05qlm4yp6124w2z10dpdchldfrmgmcr6h31rnxp8qs8mk0xzx48z";
        package = "packages/cmdliner/cmdliner.1.0.4";
      };
      pname = "cmdliner";
      src = pkgs.fetchurl 
      {
        sha256 = "1h04q0zkasd0mw64ggh4y58lgzkhg6yhzy60lab8k8zq9ba96ajw";
        url = "http://erratique.ch/software/cmdliner/releases/cmdliner-1.0.4.tbz";
      };
      version = "1.0.4";
    };
    conf-gmp = 
    {
      buildInputs = [ (pkgs.gmp or null) (pkgs.gmp-dev or null)
                       (pkgs.gmp-devel or null) (pkgs.libgmp-dev or null) ];
      opamInputs = {
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0xmnv1w1w66c15dgahcgzj980khq7hsva5k9bwc2r1pcj4a2q94d";
        package = "packages/conf-gmp/conf-gmp.3";
      };
      pname = "conf-gmp";
      src = null;
      version = "3";
    };
    coq-core = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
        zarith = selection.zarith;
      };
      opamSrc = "coq-core.opam";
      pname = "coq-core";
      src = self.directSrc "coq-core";
      version = "dev";
    };
    core = 
    {
      buildInputs = [ (pkgs.linux-headers or null) ];
      opamInputs = 
      {
        base-threads = selection.base-threads;
        core_kernel = selection.core_kernel;
        dune = selection.dune;
        jst-config = selection.jst-config;
        ocaml = selection.ocaml;
        ppx_jane = selection.ppx_jane;
        sexplib = selection.sexplib;
        spawn = selection.spawn;
        timezone = selection.timezone;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:03lf7w7gj0gvnbldkf7xpna4c4qv5wc550kap2x1j7rl22q8igcz";
        package = "packages/core/core.v0.14.1";
      };
      pname = "core";
      src = pkgs.fetchurl 
      {
        sha256 = "1862zsk85i00vsv2chgb156b1chp8f7p508hsz6sadjx6h98q5cc";
        url = "https://github.com/janestreet/core/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    core_bench = 
    {
      opamInputs = 
      {
        core = selection.core;
        core_kernel = selection.core_kernel;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_jane = selection.ppx_jane;
        re = selection.re;
        textutils = selection.textutils;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1wpvyznr2301knfdx17nnrlsv6w3yddqazcssk102vdknhkfn7a5";
        package = "packages/core_bench/core_bench.v0.14.0";
      };
      pname = "core_bench";
      src = pkgs.fetchurl 
      {
        sha256 = "1cnpc6831hgcrc50x27qbfcyfk7anz0y62vj42kf9m96axk5b1br";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/core_bench-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    core_kernel = 
    {
      opamInputs = 
      {
        base = selection.base;
        base_bigstring = selection.base_bigstring;
        base_quickcheck = selection.base_quickcheck;
        bin_prot = selection.bin_prot;
        dune = selection.dune;
        fieldslib = selection.fieldslib;
        jane-street-headers = selection.jane-street-headers;
        jst-config = selection.jst-config;
        ocaml = selection.ocaml;
        ppx_assert = selection.ppx_assert;
        ppx_base = selection.ppx_base;
        ppx_hash = selection.ppx_hash;
        ppx_inline_test = selection.ppx_inline_test;
        ppx_jane = selection.ppx_jane;
        ppx_optcomp = selection.ppx_optcomp;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppx_sexp_message = selection.ppx_sexp_message;
        sexplib = selection.sexplib;
        splittable_random = selection.splittable_random;
        stdio = selection.stdio;
        time_now = selection.time_now;
        typerep = selection.typerep;
        variantslib = selection.variantslib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:09c7k6m1vm8jhqfivn8w663v362qwjf6cb5xlzijd0sjgh1dwai5";
        package = "packages/core_kernel/core_kernel.v0.14.2";
      };
      pname = "core_kernel";
      src = pkgs.fetchurl 
      {
        sha256 = "0jyf08i9wzg3yf32f158i6n9gm751bk8zj7xqx79jnnkchwkbxb6";
        url = "https://github.com/janestreet/core_kernel/archive/v0.14.2.tar.gz";
      };
      version = "v0.14.2";
    };
    cppo = 
    {
      opamInputs = 
      {
        base-unix = selection.base-unix;
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0pzd8irqkkkpfgw8nq9d21z9rj5m3qlzixyb7ybfy4b1fwh3n8bp";
        package = "packages/cppo/cppo.1.6.8";
      };
      pname = "cppo";
      src = pkgs.fetchurl 
      {
        sha256 = "0lxy4xkkkwgs1cj6d9lyzsqi9f6fc9r6cir5imi7yjqrpd86s1by";
        url = "https://github.com/ocaml-community/cppo/archive/v1.6.8.tar.gz";
      };
      version = "1.6.8";
    };
    csexp = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:01lc95kz13gpki4xazyh6n20kv1g9inyb5myv240wl2n9v50z8fl";
        package = "packages/csexp/csexp.1.5.1";
      };
      pname = "csexp";
      src = pkgs.fetchurl 
      {
        sha256 = "00mc19f89pxpmjl62862ya5kjcfrl8rjzvs00j05h2m9bw3f81fn";
        url = "https://github.com/ocaml-dune/csexp/releases/download/1.5.1/csexp-1.5.1.tbz";
      };
      version = "1.5.1";
    };
    ctypes = 
    {
      opamInputs = 
      {
        bigarray-compat = selection.bigarray-compat;
        ctypes-foreign = selection.ctypes-foreign or null;
        integers = selection.integers;
        mirage-xen = selection.mirage-xen or null;
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0cwxwp4bj0yyyg8pwd8v8v6x0gvjniwih922q6cglpc04n9w98py";
        package = "packages/ctypes/ctypes.0.19.1";
      };
      pname = "ctypes";
      src = pkgs.fetchurl 
      {
        sha256 = "05q6xrl09g515njfx3cdb497460jy6x60fjbz8iz9ajg7x1y591f";
        url = "https://github.com/ocamllabs/ocaml-ctypes/archive/0.19.1.tar.gz";
      };
      version = "0.19.1";
    };
    dot-merlin-reader = 
    {
      opamInputs = 
      {
        csexp = selection.csexp;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
        result = selection.result;
        yojson = selection.yojson;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1cs765ls6zkv2vakmzg0b7gmqvj6dxk0c0hvk46573zkqmw8vpcr";
        package = "packages/dot-merlin-reader/dot-merlin-reader.4.1";
      };
      pname = "dot-merlin-reader";
      src = pkgs.fetchurl 
      {
        sha256 = "1kg765h6gqq5ffa1fdvm0kpa9w922y3af804ags5ssk4p1pnv8ql";
        url = "https://github.com/ocaml/merlin/releases/download/v4.1/dot-merlin-reader-v4.1.tbz";
      };
      version = "4.1";
    };
    dune = 
    {
      opamInputs = 
      {
        base-threads = selection.base-threads;
        base-unix = selection.base-unix;
        ocaml = selection.ocaml or null;
        ocamlfind-secondary = selection.ocamlfind-secondary or null;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:09s6k6kiw081kdh96zhp8ccgf8niw0391brfjl7gva7fansfqaqd";
        package = "packages/dune/dune.2.9.1";
      };
      pname = "dune";
      src = pkgs.fetchurl 
      {
        sha256 = "09lzq04b642iy0ljp59p32lgk3q8iphjh8fkdp69q29l5frgwx5k";
        url = "https://github.com/ocaml/dune/releases/download/2.9.1/dune-2.9.1.tbz";
      };
      version = "2.9.1";
    };
    dune-configurator = 
    {
      opamInputs = 
      {
        csexp = selection.csexp;
        dune = selection.dune;
        ocaml = selection.ocaml;
        result = selection.result;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1aik9w82r8vbb9fsfphpb0vam68s19ggkxprnqr99ygyalp2b71j";
        package = "packages/dune-configurator/dune-configurator.2.9.1";
      };
      pname = "dune-configurator";
      src = pkgs.fetchurl 
      {
        sha256 = "09lzq04b642iy0ljp59p32lgk3q8iphjh8fkdp69q29l5frgwx5k";
        url = "https://github.com/ocaml/dune/releases/download/2.9.1/dune-2.9.1.tbz";
      };
      version = "2.9.1";
    };
    easy-format = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0rjgw1ygf8khwb7vgl5vnw907m8b5mpkb0bnlqiqz9zfmfb4jd47";
        package = "packages/easy-format/easy-format.1.3.2";
      };
      pname = "easy-format";
      src = pkgs.fetchurl 
      {
        sha256 = "09hrikx310pac2sb6jzaa7k6fmiznnmhdsqij1gawdymhawc4h1l";
        url = "https://github.com/mjambon/easy-format/releases/download/1.3.2/easy-format-1.3.2.tbz";
      };
      version = "1.3.2";
    };
    fieldslib = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1gsrbs4x45k4bp1zih9c6db3axhaiy91knac6bk6hpgv9sjalicm";
        package = "packages/fieldslib/fieldslib.v0.14.0";
      };
      pname = "fieldslib";
      src = pkgs.fetchurl 
      {
        sha256 = "10n5y376fb5jgqk9h8vq158rm1b36h9lzh6p11q33h6xgvb1v6n3";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/fieldslib-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    fmt = 
    {
      opamInputs = 
      {
        base-unix = selection.base-unix or null;
        cmdliner = selection.cmdliner or null;
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
        topkg = selection.topkg;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1kw1a7h3i66xzl5id0y07zy3z8hnvn9w36y6xm5gg7mmxf6ipw5a";
        package = "packages/fmt/fmt.0.8.10";
      };
      pname = "fmt";
      src = pkgs.fetchurl 
      {
        sha256 = "1gxjlzbxfl237zzq86cxhyc7r6pdfiy7yphpda0czz29xj7k3jjj";
        url = "https://erratique.ch/software/fmt/releases/fmt-0.8.10.tbz";
      };
      version = "0.8.10";
    };
    fpath = 
    {
      opamInputs = 
      {
        astring = selection.astring;
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
        topkg = selection.topkg;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1pnskgw9fqq4kg1x4sc4vcv9rh0kksilx4qngwafpyss42mqq2i2";
        package = "packages/fpath/fpath.0.7.3";
      };
      pname = "fpath";
      src = pkgs.fetchurl 
      {
        sha256 = "03z7mj0sqdz465rc4drj1gr88l9q3nfs374yssvdjdyhjbqqzc0j";
        url = "https://erratique.ch/software/fpath/releases/fpath-0.7.3.tbz";
      };
      version = "0.7.3";
    };
    integers = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1n15jqsbgd9xp7xn68sb52m4jdw66l6rlnsza67nw0r164i2nj00";
        package = "packages/integers/integers.0.5.1";
      };
      pname = "integers";
      src = pkgs.fetchurl 
      {
        sha256 = "1f1nkgpqjnavyw5vqlgrgsqaqdgzp0xngs4hx97dn7glraccw27n";
        url = "https://github.com/ocamllabs/ocaml-integers/archive/0.5.1.tar.gz";
      };
      version = "0.5.1";
    };
    jane-street-headers = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1w6zjjmyszk9pax139rkxb3vx0w23w0pfd46bddfyfkxq2rbwsvf";
        package = "packages/jane-street-headers/jane-street-headers.v0.14.0";
      };
      pname = "jane-street-headers";
      src = pkgs.fetchurl 
      {
        sha256 = "028yxb4h3iy025iy89v8653m5brh7flrjshghs4x99pd690pmfs7";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/jane-street-headers-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    js_of_ocaml = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        js_of_ocaml-compiler = selection.js_of_ocaml-compiler;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
        uchar = selection.uchar;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1w9czcc5nr5sxvc81air91gvkivnxcws9dasv3nmw6hrci7x0qaa";
        package = "packages/js_of_ocaml/js_of_ocaml.3.11.0";
      };
      pname = "js_of_ocaml";
      src = pkgs.fetchurl 
      {
        sha256 = "0flws9mw0yjfw4d8d3y3k408mivy2xgky70xk1br3iqs4zksz38m";
        url = "https://github.com/ocsigen/js_of_ocaml/releases/download/3.11.0/js_of_ocaml-3.11.0.tbz";
      };
      version = "3.11.0";
    };
    js_of_ocaml-compiler = 
    {
      opamInputs = 
      {
        cmdliner = selection.cmdliner;
        dune = selection.dune;
        menhir = selection.menhir;
        menhirLib = selection.menhirLib;
        menhirSdk = selection.menhirSdk;
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind or null;
        ppxlib = selection.ppxlib;
        yojson = selection.yojson;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0zq8dis4cw67pf7r2b1sk8q885kqg4pvh54f2v3sx9wqpjw8i7z0";
        package = "packages/js_of_ocaml-compiler/js_of_ocaml-compiler.3.11.0";
      };
      pname = "js_of_ocaml-compiler";
      src = pkgs.fetchurl 
      {
        sha256 = "0flws9mw0yjfw4d8d3y3k408mivy2xgky70xk1br3iqs4zksz38m";
        url = "https://github.com/ocsigen/js_of_ocaml/releases/download/3.11.0/js_of_ocaml-3.11.0.tbz";
      };
      version = "3.11.0";
    };
    jst-config = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        dune-configurator = selection.dune-configurator;
        ocaml = selection.ocaml;
        ppx_assert = selection.ppx_assert;
        stdio = selection.stdio;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0myym84b9yx4vqa0ml0zf3cx6rms3g5dv704vhf5bpr7jnqz0qcb";
        package = "packages/jst-config/jst-config.v0.14.1";
      };
      pname = "jst-config";
      src = pkgs.fetchurl 
      {
        sha256 = "0wdjs0lvc5wbggh27cf490jarfibrrb5xxsrigg41m32kjkbijm4";
        url = "https://github.com/janestreet/jst-config/archive/refs/tags/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    lambda-term = 
    {
      opamInputs = 
      {
        camomile = selection.camomile;
        dune = selection.dune;
        lwt = selection.lwt;
        lwt_log = selection.lwt_log;
        lwt_react = selection.lwt_react;
        mew_vi = selection.mew_vi;
        ocaml = selection.ocaml;
        react = selection.react;
        zed = selection.zed;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:01k27v0d6xlgsia58g4gcv4yan8z9vak63zvqdcv3fayb5d63pfd";
        package = "packages/lambda-term/lambda-term.3.1.0";
      };
      pname = "lambda-term";
      src = pkgs.fetchurl 
      {
        sha256 = "1462j2c2nnzv6ng8b6907bw0zy3mhhnnjdm8k6as0sgm9ls0r77r";
        url = "https://github.com/ocaml-community/lambda-term/archive/3.1.0.tar.gz";
      };
      version = "3.1.0";
    };
    logs = 
    {
      opamInputs = 
      {
        base-threads = selection.base-threads or null;
        cmdliner = selection.cmdliner or null;
        fmt = selection.fmt or null;
        js_of_ocaml = selection.js_of_ocaml or null;
        lwt = selection.lwt or null;
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
        topkg = selection.topkg;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1k797gb7f2s1hlqyqsq2xyq9gm20l5q2iwh26bs44f3bp3gklg1a";
        package = "packages/logs/logs.0.7.0";
      };
      pname = "logs";
      src = pkgs.fetchurl 
      {
        sha256 = "1jnmd675wmsmdwyb5mx5b0ac66g4c6gpv5s4mrx2j6pb0wla1x46";
        url = "https://erratique.ch/software/logs/releases/logs-0.7.0.tbz";
      };
      version = "0.7.0";
    };
    lwt = 
    {
      opamInputs = 
      {
        base-threads = selection.base-threads or null;
        base-unix = selection.base-unix or null;
        conf-libev = selection.conf-libev or null;
        cppo = selection.cppo;
        dune = selection.dune;
        dune-configurator = selection.dune-configurator;
        mmap = selection.mmap;
        ocaml = selection.ocaml;
        ocaml-syntax-shims = selection.ocaml-syntax-shims or null;
        ocplib-endian = selection.ocplib-endian;
        result = selection.result;
        seq = selection.seq;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1jss4a1pihrjdbcnfkva8i0p14ahx2ia6qwfjrqjkzir5fwp2n7j";
        package = "packages/lwt/lwt.5.4.2";
      };
      pname = "lwt";
      src = pkgs.fetchurl 
      {
        sha256 = "1jyjq43q9rbrw7ijy8l8rd1rhiy74ix2j1w15q0694rdfbkcnsg1";
        url = "https://github.com/ocsigen/lwt/archive/refs/tags/5.4.2.tar.gz";
      };
      version = "5.4.2";
    };
    lwt_log = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        lwt = selection.lwt;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:18iddwpvs7hwkmsbii11kiw0aaad4kf8iv9vjw01npflxh729vig";
        package = "packages/lwt_log/lwt_log.1.1.1";
      };
      pname = "lwt_log";
      src = pkgs.fetchurl 
      {
        sha256 = "0gszc8nvk2hpfq47plb36qahlnyfq28sa9mhicnf6mg5c7n1kyql";
        url = "https://github.com/aantron/lwt_log/archive/1.1.1.tar.gz";
      };
      version = "1.1.1";
    };
    lwt_react = 
    {
      buildInputs = [ (pkgs.unzip) ];
      opamInputs = 
      {
        dune = selection.dune;
        lwt = selection.lwt;
        ocaml = selection.ocaml;
        react = selection.react;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0i1pn2nahdcxjxy279lbzmbzccys3xgny015ibkza499njdyikkw";
        package = "packages/lwt_react/lwt_react.1.1.4";
      };
      pname = "lwt_react";
      src = pkgs.fetchurl 
      {
        sha256 = "1lv5i3znmiqx6fiq2q1lapsq1bk20bgw7h57wmk9czx9x050a5n5";
        url = "https://github.com/ocsigen/lwt/archive/5.4.0.zip";
      };
      version = "1.1.4";
    };
    mdx = 
    {
      opamInputs = 
      {
        astring = selection.astring;
        cmdliner = selection.cmdliner;
        cppo = selection.cppo;
        csexp = selection.csexp;
        dune = selection.dune;
        fmt = selection.fmt;
        logs = selection.logs;
        ocaml = selection.ocaml;
        ocaml-version = selection.ocaml-version;
        ocamlfind = selection.ocamlfind;
        odoc-parser = selection.odoc-parser;
        re = selection.re;
        result = selection.result;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:18pcb9gbb1gwb7bxs5ajdddl1kqv8ci72cv20wspdf0n4yli2b5k";
        package = "packages/mdx/mdx.1.11.0";
      };
      pname = "mdx";
      src = pkgs.fetchurl 
      {
        sha256 = "1hk8ffh3d9hiibrj6691khnbmjnfs9psmiawnrbgi0577bw030wx";
        url = "https://github.com/realworldocaml/mdx/releases/download/1.11.0/mdx-1.11.0.tbz";
      };
      version = "1.11.0";
    };
    menhir = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        menhirLib = selection.menhirLib;
        menhirSdk = selection.menhirSdk;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:17ryhvbg6yaxsai77s2d37sf132rvkcv57ilm33nl5zlgclw6b60";
        package = "packages/menhir/menhir.20211012";
      };
      pname = "menhir";
      src = pkgs.fetchurl 
      {
        sha256 = "0sjhh4r793p297ywjrygjjz9hmhrmld0vfm53kqqcimp8vr1wxd2";
        url = "https://gitlab.inria.fr/fpottier/menhir/-/archive/20211012/archive.tar.gz";
      };
      version = "20211012";
    };
    menhirLib = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0m32qmix5g25h883154v64429yjvf8bjmf583hxfw1mnhl4fplqh";
        package = "packages/menhirLib/menhirLib.20211012";
      };
      pname = "menhirLib";
      src = pkgs.fetchurl 
      {
        sha256 = "0sjhh4r793p297ywjrygjjz9hmhrmld0vfm53kqqcimp8vr1wxd2";
        url = "https://gitlab.inria.fr/fpottier/menhir/-/archive/20211012/archive.tar.gz";
      };
      version = "20211012";
    };
    menhirSdk = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0gw6smpyzmb6g25ch74ji7asf1f8pbwp8ngpz7hn6ynnr6njcyln";
        package = "packages/menhirSdk/menhirSdk.20211012";
      };
      pname = "menhirSdk";
      src = pkgs.fetchurl 
      {
        sha256 = "0sjhh4r793p297ywjrygjjz9hmhrmld0vfm53kqqcimp8vr1wxd2";
        url = "https://gitlab.inria.fr/fpottier/menhir/-/archive/20211012/archive.tar.gz";
      };
      version = "20211012";
    };
    merlin = 
    {
      opamInputs = 
      {
        csexp = selection.csexp;
        dot-merlin-reader = selection.dot-merlin-reader;
        dune = selection.dune;
        ocaml = selection.ocaml;
        result = selection.result;
        yojson = selection.yojson;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0mjspn06vv09hhzsdva5nik14s4jlc4fqw5d65yg2y6a2ddkw4lq";
        package = "packages/merlin/merlin.4.3.1-412";
      };
      pname = "merlin";
      src = pkgs.fetchurl 
      {
        sha256 = "0ah2zbj1hhrrfxp4nhfh47jsbkvm0b30dr7ikjpmvb13wa8h20sr";
        url = "https://github.com/ocaml/merlin/releases/download/v4.3.1-412/merlin-v4.3.1-412.tbz";
      };
      version = "4.3.1-412";
    };
    mew = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        result = selection.result;
        trie = selection.trie;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0g9xms016f909fzbwgxcy0k4xmvr5zk5bhnz66v9vpsiak2qm4s3";
        package = "packages/mew/mew.0.1.0";
      };
      pname = "mew";
      src = pkgs.fetchurl 
      {
        sha256 = "1rjri9mgfb9gn9fmjn0ax21y9jd9wkvr7mmx2jrlqmzgabmqrlv4";
        url = "https://github.com/kandu/mew/archive/0.1.0.tar.gz";
      };
      version = "0.1.0";
    };
    mew_vi = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        mew = selection.mew;
        ocaml = selection.ocaml;
        react = selection.react;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0zsfhxpff78cqk2c81parajb59m7hqf6v8arksxbyfha6mls65hz";
        package = "packages/mew_vi/mew_vi.0.5.0";
      };
      pname = "mew_vi";
      src = pkgs.fetchurl 
      {
        sha256 = "1nmg3cysglgw4115n5zpz4azrfbnfxkn2kvw73chzs69viygm4m6";
        url = "https://github.com/kandu/mew_vi/archive/0.5.0.tar.gz";
      };
      version = "0.5.0";
    };
    mmap = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1snhaf6mixmmb49gcin5wmbz4bfjz406mip4556lids8ajm22ibh";
        package = "packages/mmap/mmap.1.1.0";
      };
      pname = "mmap";
      src = pkgs.fetchurl 
      {
        sha256 = "0l6waidal2n8mkdn74avbslvc10sf49f5d889n838z03pra5chsc";
        url = "https://github.com/mirage/mmap/releases/download/v1.1.0/mmap-v1.1.0.tbz";
      };
      version = "1.1.0";
    };
    num = 
    {
      opamInputs = 
      {
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:04wb8ww165lsifn36jcrxw5zs87id5kib6rilq6zh6qhzvij88pf";
        package = "packages/num/num.1.4";
      };
      pname = "num";
      src = pkgs.fetchurl 
      {
        sha256 = "090gl27g84r3s2b12vgkz8fp269jqlrhx4lpg7008yviisv8hl01";
        url = "https://github.com/ocaml/num/archive/v1.4.tar.gz";
      };
      version = "1.4";
    };
    ocaml = 
    {
      opamInputs = 
      {
        ocaml-base-compiler = selection.ocaml-base-compiler or null;
        ocaml-config = selection.ocaml-config;
        ocaml-system = selection.ocaml-system or null;
        ocaml-variants = selection.ocaml-variants or null;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:11mxrkiixqfyv0arpx57xk9kfa1an749lnbx6saf4h616llb5sj9";
        package = "packages/ocaml/ocaml.4.12.0";
      };
      pname = "ocaml";
      src = null;
      version = "4.12.0";
    };
    ocaml-base-compiler = 
    {
      opamInputs = {
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:06c7jb58zqqjd0vbg27k4n4v69xqfzjfcm89i43a2j7r7frjlwn1";
        package = "packages/ocaml-base-compiler/ocaml-base-compiler.4.12.0";
      };
      pname = "ocaml-base-compiler";
      src = pkgs.fetchurl 
      {
        sha256 = "0i37laikik5vwydw1cwygxd8xq2d6n35l20irgrh691njlwpmh5d";
        url = "https://github.com/ocaml/ocaml/archive/4.12.0.tar.gz";
      };
      version = "4.12.0";
    };
    ocaml-compiler-libs = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1blynia10j8vyj559kcvc7ic69zq6qjjn092fcsjzfw6czd8ya2c";
        package = "packages/ocaml-compiler-libs/ocaml-compiler-libs.v0.12.4";
      };
      pname = "ocaml-compiler-libs";
      src = pkgs.fetchurl 
      {
        sha256 = "0q3pl20pkx410gw9g4m26qq6dmzi9qan2dqlga6c2ifc6pnckjaf";
        url = "https://github.com/janestreet/ocaml-compiler-libs/releases/download/v0.12.4/ocaml-compiler-libs-v0.12.4.tbz";
      };
      version = "v0.12.4";
    };
    ocaml-config = 
    {
      opamInputs = 
      {
        ocaml-base-compiler = selection.ocaml-base-compiler or null;
        ocaml-system = selection.ocaml-system or null;
        ocaml-variants = selection.ocaml-variants or null;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0h0hgqq9mbywvqygppfdc50gf9ss8a97l4dgsv3hszmzh6gglgrg";
        package = "packages/ocaml-config/ocaml-config.2";
      };
      pname = "ocaml-config";
      src = null;
      version = "2";
    };
    ocaml-migrate-parsetree = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1x28grfw31s7x31nncavcmjl6b5vnz9f0r9s86p1hhkl2l794h89";
        package = "packages/ocaml-migrate-parsetree/ocaml-migrate-parsetree.2.2.0";
      };
      pname = "ocaml-migrate-parsetree";
      src = pkgs.fetchurl 
      {
        sha256 = "188v3z09bg4gyv80c138fa3a3j2w54w5gc4r1ajw7klr70yqz9mj";
        url = "https://github.com/ocaml-ppx/ocaml-migrate-parsetree/releases/download/v2.2.0/ocaml-migrate-parsetree-v2.2.0.tbz";
      };
      version = "2.2.0";
    };
    ocaml-version = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:18ixm46gxssqcljvjyz3yj65jphbs3jf9v998bbfm06m3y49z038";
        package = "packages/ocaml-version/ocaml-version.3.4.0";
      };
      pname = "ocaml-version";
      src = pkgs.fetchurl 
      {
        sha256 = "09cavcmla9zyqj3vmmp4n59bgj1ydbk4qhsz1dqvgsyqx2svxhfq";
        url = "https://github.com/ocurrent/ocaml-version/releases/download/v3.4.0/ocaml-version-v3.4.0.tbz";
      };
      version = "3.4.0";
    };
    ocamlbuild = 
    {
      opamInputs = {
                     ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1r5qnrcxfypzyvjvb3zd9f66kr5ldxdl3g9rsi3pb6040krqb5w7";
        package = "packages/ocamlbuild/ocamlbuild.0.14.0";
      };
      pname = "ocamlbuild";
      src = pkgs.fetchurl 
      {
        sha256 = "0y1fskw9rg2y1zgb7whv3v8v4xw04svgxslf3856q2aqd7lrrcl7";
        url = "https://github.com/ocaml/ocamlbuild/archive/0.14.0.tar.gz";
      };
      version = "0.14.0";
    };
    ocamlfind = 
    {
      opamInputs = 
      {
        graphics = selection.graphics or null;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:11avrzm0gdc6mz7dazr8q18ir5429ckc36s2mv0l8722znq8lc3k";
        package = "packages/ocamlfind/ocamlfind.1.9.1";
      };
      pname = "ocamlfind";
      src = pkgs.fetchurl 
      {
        sha256 = "1qhgk25avmz4l4g47g8jvk0k1g9p9d5hbdrwpz2693a8ajyvhhib";
        url = "http://download.camlcity.org/download/findlib-1.9.1.tar.gz";
      };
      version = "1.9.1";
    };
    ocplib-endian = 
    {
      opamInputs = 
      {
        base-bytes = selection.base-bytes;
        cppo = selection.cppo;
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0j5ymxa4ky208k8m4bprvmvbqf9jnr4d0xwdaivznbv85jq9hw4q";
        package = "packages/ocplib-endian/ocplib-endian.1.1";
      };
      pname = "ocplib-endian";
      src = pkgs.fetchurl 
      {
        sha256 = "0qy5q7p11gxi5anhvi8jj6mr80ml0ih8lax5k579rsr2hsp3sns5";
        url = "https://github.com/OCamlPro/ocplib-endian/archive/1.1.tar.gz";
      };
      version = "1.1";
    };
    octavius = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0bagilkanfjyi56hrk9dw43xs6zry9p8n3l55r3d58v5hz2xsbwl";
        package = "packages/octavius/octavius.1.2.2";
      };
      pname = "octavius";
      src = pkgs.fetchurl 
      {
        sha256 = "1bg0fcm7haqxvx5wx2cci0mbbq0gf1vw9fa4kkd6jsriw1611jga";
        url = "https://github.com/ocaml-doc/octavius/archive/v1.2.2.tar.gz";
      };
      version = "1.2.2";
    };
    odoc = 
    {
      opamInputs = 
      {
        astring = selection.astring;
        cmdliner = selection.cmdliner;
        cppo = selection.cppo;
        dune = selection.dune;
        fmt = selection.fmt;
        fpath = selection.fpath;
        logs = selection.logs;
        ocaml = selection.ocaml;
        ocaml-migrate-parsetree = selection.ocaml-migrate-parsetree;
        odoc-parser = selection.odoc-parser;
        re = selection.re;
        result = selection.result;
        tyxml = selection.tyxml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:089xy28z9bi6i4k3nf01fd2wn0izdamj6zfnbcrshwl6m05dclf3";
        package = "packages/odoc/odoc.2.0.0";
      };
      pname = "odoc";
      src = pkgs.fetchurl 
      {
        sha256 = "01yh1h9cigcljp6gkb6ab2ba5ivw8ps438xgk04bkd0qzwmfnccc";
        url = "https://github.com/ocaml/odoc/releases/download/2.0.0/odoc-2.0.0.tbz";
      };
      version = "2.0.0";
    };
    odoc-parser = 
    {
      opamInputs = 
      {
        astring = selection.astring;
        dune = selection.dune;
        ocaml = selection.ocaml;
        result = selection.result;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1z2y8dqdyfwd1l0aam87c9xdgmyc1bj2fjxr7mfnwp8ipzx5jf2d";
        package = "packages/odoc-parser/odoc-parser.0.9.0";
      };
      pname = "odoc-parser";
      src = pkgs.fetchurl 
      {
        sha256 = "0ydxy2sj2w9i4vvyjnxplgmp5gbkp5ilnv36pvk4vgrrmldss3fz";
        url = "https://github.com/ocaml-doc/odoc-parser/releases/download/0.9.0/odoc-parser-0.9.0.tbz";
      };
      version = "0.9.0";
    };
    parsexp = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        sexplib0 = selection.sexplib0;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:099c589d87lk87kys3imlfdfx1x4hjbagsxfiblp343z7q4n71qj";
        package = "packages/parsexp/parsexp.v0.14.1";
      };
      pname = "parsexp";
      src = pkgs.fetchurl 
      {
        sha256 = "1c0faqydsvn06qxwnyns567frmg9lxs2fv2bsy20ngyii16fcq04";
        url = "https://github.com/janestreet/parsexp/archive/refs/tags/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_assert = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_cold = selection.ppx_cold;
        ppx_compare = selection.ppx_compare;
        ppx_here = selection.ppx_here;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1ry1bqssjw5lc7h0x2cc7f8rmz807j5l7029lxd4i12vgq91x5km";
        package = "packages/ppx_assert/ppx_assert.v0.14.0";
      };
      pname = "ppx_assert";
      src = pkgs.fetchurl 
      {
        sha256 = "1l2rr4jz2q5b35ryn2z146z7m9v6k8krp5gpn8ilib66mnz5zx15";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_assert-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_base = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_cold = selection.ppx_cold;
        ppx_compare = selection.ppx_compare;
        ppx_enumerate = selection.ppx_enumerate;
        ppx_hash = selection.ppx_hash;
        ppx_js_style = selection.ppx_js_style;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1n66x8xl2n0qbq1g0b1l3nsdqlb3czj5w509riwqdgz11fyrzi25";
        package = "packages/ppx_base/ppx_base.v0.14.0";
      };
      pname = "ppx_base";
      src = pkgs.fetchurl 
      {
        sha256 = "0b7a3fmi90jk8paz0g36yzaq670fbnrbi1j8r5ibh9wbcfli7ji6";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_base-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_bench = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_inline_test = selection.ppx_inline_test;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0r17lcfhxd14ihbbhqjqjmx26ig4xf62dmc2pblg7flzcf4k64dp";
        package = "packages/ppx_bench/ppx_bench.v0.14.1";
      };
      pname = "ppx_bench";
      src = pkgs.fetchurl 
      {
        sha256 = "1jr3cf4zsk894x64c8ir9ap9l412q35b2605pr7flrlxbm4vkf3f";
        url = "https://github.com/janestreet/ppx_bench/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_bin_prot = 
    {
      opamInputs = 
      {
        base = selection.base;
        bin_prot = selection.bin_prot;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_here = selection.ppx_here;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0rsbhajm4927f1798baalwf3f7f5vs8jy27bxd6rhhybnvqjxyj9";
        package = "packages/ppx_bin_prot/ppx_bin_prot.v0.14.0";
      };
      pname = "ppx_bin_prot";
      src = pkgs.fetchurl 
      {
        sha256 = "0wa2jmvm2k88b37pbcafy1mdf5iaip0yxg5dw774sbh28nm08m2s";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_bin_prot-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_cold = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0g566vskiblrxr246c3s26rlzxciln518fr4f6d8lid63qgrgnfm";
        package = "packages/ppx_cold/ppx_cold.v0.14.0";
      };
      pname = "ppx_cold";
      src = pkgs.fetchurl 
      {
        sha256 = "1madfzhpir9amnxmg530n70vll0jrl59vyp71miji73i6b9sy6n2";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_cold-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_compare = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1ndfsgazb7yg5q3aqzcrnr914sf615bsh4z4q202bdvpf0fqj31k";
        package = "packages/ppx_compare/ppx_compare.v0.14.0";
      };
      pname = "ppx_compare";
      src = pkgs.fetchurl 
      {
        sha256 = "0mqxa2s194nif7x4fjn1p5gd9i3bakr8nv27gf8x1g5nmi8q9pmp";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_compare-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_custom_printf = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1karjqaa17ai6v4y7wb2zwfpscyirmb4ixdr3lw6i83icklsgmdw";
        package = "packages/ppx_custom_printf/ppx_custom_printf.v0.14.1";
      };
      pname = "ppx_custom_printf";
      src = pkgs.fetchurl 
      {
        sha256 = "0kzbckbvhfn3s9an1hq01qd5iac7wgirw182ablpqxc6r3dmijrl";
        url = "https://github.com/janestreet/ppx_custom_printf/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_derivers = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0r8rjp4m5jfbf3wz8qlgh82pxjws4arjwxhqq0zjglby6l6h8p3x";
        package = "packages/ppx_derivers/ppx_derivers.1.2.1";
      };
      pname = "ppx_derivers";
      src = pkgs.fetchurl 
      {
        sha256 = "159vqy616ni18mn0dlv8c2y4h7mb4hahwjn53yrr59yyhzhmwndn";
        url = "https://github.com/ocaml-ppx/ppx_derivers/archive/1.2.1.tar.gz";
      };
      version = "1.2.1";
    };
    ppx_enumerate = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0lgnrpq1vmb44367y7mdr7jw1yqmy08fi6phgq8pch3a47fdk2rm";
        package = "packages/ppx_enumerate/ppx_enumerate.v0.14.0";
      };
      pname = "ppx_enumerate";
      src = pkgs.fetchurl 
      {
        sha256 = "1ij6sffgqhnjwnj9brhrrw1c6xgxlh0s6r17x1qkgnyrc73gfsz8";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_enumerate-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_expect = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_here = selection.ppx_here;
        ppx_inline_test = selection.ppx_inline_test;
        ppxlib = selection.ppxlib;
        re = selection.re;
        stdio = selection.stdio;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:15qiv5ggyxxm3zwm1as6f29vnmnw9zksc2wib9l5lgp040zbcj70";
        package = "packages/ppx_expect/ppx_expect.v0.14.1";
      };
      pname = "ppx_expect";
      src = pkgs.fetchurl 
      {
        sha256 = "188zaqdqxqw9xbga1ip4yi5f9p41zgdqr51idcnw4yayvdxg81q3";
        url = "https://github.com/janestreet/ppx_expect/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_fields_conv = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        fieldslib = selection.fieldslib;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0332mrn1xk3423rm4hk5lif9igrj3339xyfd6464wcbkpakivfba";
        package = "packages/ppx_fields_conv/ppx_fields_conv.v0.14.2";
      };
      pname = "ppx_fields_conv";
      src = pkgs.fetchurl 
      {
        sha256 = "0r7d51j54r1za6bwqsmhmhhfab8n10zyk5zznhkm91f20dx9ddip";
        url = "https://github.com/janestreet/ppx_fields_conv/archive/v0.14.2.tar.gz";
      };
      version = "v0.14.2";
    };
    ppx_fixed_literal = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:13wng3z0x3fx6l4vym8rddc0yniplim94gn5x8bcfkjd2yhxd88s";
        package = "packages/ppx_fixed_literal/ppx_fixed_literal.v0.14.0";
      };
      pname = "ppx_fixed_literal";
      src = pkgs.fetchurl 
      {
        sha256 = "0w0a06143mhmczbpr0lfb66r6im7075gck4p0idbcari63sximqj";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_fixed_literal-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_hash = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_compare = selection.ppx_compare;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0zcnsd0724w6kpx4w1i3nbfrvffhnqjn3rinddgqjndx5pvghrlc";
        package = "packages/ppx_hash/ppx_hash.v0.14.0";
      };
      pname = "ppx_hash";
      src = pkgs.fetchurl 
      {
        sha256 = "0x4wgdvhgd8a49bzari52jpkykxpv6ncgp5ncda3xgg0a9r49s8n";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_hash-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_here = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0f7p619ymqm27iclcx3cbyyn1k0mccw9vsa0l88m1jk3kjgjbmzz";
        package = "packages/ppx_here/ppx_here.v0.14.0";
      };
      pname = "ppx_here";
      src = pkgs.fetchurl 
      {
        sha256 = "0b444djy68v6ji0ypwv5l02pkl151qzrgg96lyhl8dxfrzvj1zkj";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_here-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_inline_test = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
        time_now = selection.time_now;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1vwg8bgw093ia075n7vh0kl82sjd5r9yk27s45ljzz9cmfqrr4sa";
        package = "packages/ppx_inline_test/ppx_inline_test.v0.14.1";
      };
      pname = "ppx_inline_test";
      src = pkgs.fetchurl 
      {
        sha256 = "0qzvm8rg07annl8zpqlhzx1z8ahrrf02r1brd43ykqas5sww3rfp";
        url = "https://github.com/janestreet/ppx_inline_test/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_jane = 
    {
      opamInputs = 
      {
        base_quickcheck = selection.base_quickcheck;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_assert = selection.ppx_assert;
        ppx_base = selection.ppx_base;
        ppx_bench = selection.ppx_bench;
        ppx_bin_prot = selection.ppx_bin_prot;
        ppx_custom_printf = selection.ppx_custom_printf;
        ppx_expect = selection.ppx_expect;
        ppx_fields_conv = selection.ppx_fields_conv;
        ppx_fixed_literal = selection.ppx_fixed_literal;
        ppx_here = selection.ppx_here;
        ppx_inline_test = selection.ppx_inline_test;
        ppx_let = selection.ppx_let;
        ppx_module_timer = selection.ppx_module_timer;
        ppx_optcomp = selection.ppx_optcomp;
        ppx_optional = selection.ppx_optional;
        ppx_pipebang = selection.ppx_pipebang;
        ppx_sexp_message = selection.ppx_sexp_message;
        ppx_sexp_value = selection.ppx_sexp_value;
        ppx_stable = selection.ppx_stable;
        ppx_string = selection.ppx_string;
        ppx_typerep_conv = selection.ppx_typerep_conv;
        ppx_variants_conv = selection.ppx_variants_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1jqzfdg3rbb96mgw0cpbsmr1y06whhqys6a4rkfdih6z4n5cm4ns";
        package = "packages/ppx_jane/ppx_jane.v0.14.0";
      };
      pname = "ppx_jane";
      src = pkgs.fetchurl 
      {
        sha256 = "18js98xdqf8d54sjn1gccjkwbv2p56qy7bhvjgk94pr3fipfz0v7";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_jane-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_js_style = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        octavius = selection.octavius;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:05bc07ghvfd4d85inf1qvpqxphvcg7mgf8fn9ycib6fdmxdkkamq";
        package = "packages/ppx_js_style/ppx_js_style.v0.14.1";
      };
      pname = "ppx_js_style";
      src = pkgs.fetchurl 
      {
        sha256 = "1nq4rj659f34dc28pj7ir2szqbpky4nzs9qfw0am6sf36jwispiw";
        url = "https://github.com/janestreet/ppx_js_style/archive/refs/tags/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_let = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1n3ayvvmiwmv5jnyjl8nr510dblijwx9g2r39hl5xxgr57d4c7f7";
        package = "packages/ppx_let/ppx_let.v0.14.0";
      };
      pname = "ppx_let";
      src = pkgs.fetchurl 
      {
        sha256 = "1qcrnd86pbr1di5m6z4ps4p15qawwa02jxwz3xfd82hdbjmdwf1s";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_let-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_module_timer = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_base = selection.ppx_base;
        ppxlib = selection.ppxlib;
        stdio = selection.stdio;
        time_now = selection.time_now;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:18q8zyppvl9wskx5flhcfmkznzihfs3kk3c38n0kdh1ngg6c1prr";
        package = "packages/ppx_module_timer/ppx_module_timer.v0.14.0";
      };
      pname = "ppx_module_timer";
      src = pkgs.fetchurl 
      {
        sha256 = "04a7vzk4s3jn6wj94q0hn8kd9vxlzkpcq5ifpvz3bdfgmypjks5z";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_module_timer-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_optcomp = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
        stdio = selection.stdio;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0xh7m3hsm7vrhzmd86n3irhydp9lyr23ax9mg1khq2jhcbyqqvy0";
        package = "packages/ppx_optcomp/ppx_optcomp.v0.14.3";
      };
      pname = "ppx_optcomp";
      src = pkgs.fetchurl 
      {
        sha256 = "0bxzh0pm3zdiadrd37jjzp7zm2qn28mx25ahk0shgfb73vya809n";
        url = "https://github.com/janestreet/ppx_optcomp/archive/v0.14.3.tar.gz";
      };
      version = "v0.14.3";
    };
    ppx_optional = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0jg35ql4vwzh27hv2vn52hilfb2cpdl91wiaj0r6nh9s6iwy8dzf";
        package = "packages/ppx_optional/ppx_optional.v0.14.0";
      };
      pname = "ppx_optional";
      src = pkgs.fetchurl 
      {
        sha256 = "1hh6ivlp1qpvyn8l0vhrahkkcp3scf7km254sgplprmk10wnyidz";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_optional-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_pipebang = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1rklw915zv3apij5icp19337aza8di19sp86qp0w6lwimmdvx7dn";
        package = "packages/ppx_pipebang/ppx_pipebang.v0.14.0";
      };
      pname = "ppx_pipebang";
      src = pkgs.fetchurl 
      {
        sha256 = "19afbbvy72i1347prvkpy3ms75xnk7kl2hn83h40p6yh27100hky";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_pipebang-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_sexp_conv = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
        sexplib0 = selection.sexplib0;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:03c4ar76g1sz2y35a9jbffw957i17ixwd7ky8cg5ss7m7jl7x1fs";
        package = "packages/ppx_sexp_conv/ppx_sexp_conv.v0.14.3";
      };
      pname = "ppx_sexp_conv";
      src = pkgs.fetchurl 
      {
        sha256 = "0fbnkhsd6yphc49pa21nlmbik99n7qkaz8l9paq96v012ipg9h9g";
        url = "https://github.com/janestreet/ppx_sexp_conv/archive/v0.14.3.tar.gz";
      };
      version = "v0.14.3";
    };
    ppx_sexp_message = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_here = selection.ppx_here;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0djv8npvc7lx1d20f3ln3s3hffh729fpyyj156fpylkqnr9lcfv7";
        package = "packages/ppx_sexp_message/ppx_sexp_message.v0.14.1";
      };
      pname = "ppx_sexp_message";
      src = pkgs.fetchurl 
      {
        sha256 = "06d1cx8nh6chgx09lqjgsagc02lfsvv18fydrviqjvydx52m2qjf";
        url = "https://github.com/janestreet/ppx_sexp_message/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_sexp_value = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_here = selection.ppx_here;
        ppx_sexp_conv = selection.ppx_sexp_conv;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0wqj7nr9nvyss3qjf5jcbijjqkrah2ib8ypfp4hxw00vmyfvyrps";
        package = "packages/ppx_sexp_value/ppx_sexp_value.v0.14.0";
      };
      pname = "ppx_sexp_value";
      src = pkgs.fetchurl 
      {
        sha256 = "0yc6i1yx9mb8pwjkswy09aqg5kz1hgrpjyniq2v6whfjvxl1qrkj";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/ppx_sexp_value-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    ppx_stable = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1b2kvif9jc2wj99ciaz6876myn05qbk3a7gn40msnpmd9prgg1lc";
        package = "packages/ppx_stable/ppx_stable.v0.14.1";
      };
      pname = "ppx_stable";
      src = pkgs.fetchurl 
      {
        sha256 = "1dw8ilrvi5lssxnbflnzskmyi3k93ij2kbyz49y93agv0b8dsq01";
        url = "https://github.com/janestreet/ppx_stable/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_string = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_base = selection.ppx_base;
        ppxlib = selection.ppxlib;
        stdio = selection.stdio;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0adczy40rfpif3jwz2vrhf8kphzilvgffws2si9ypzs264ipjvg8";
        package = "packages/ppx_string/ppx_string.v0.14.1";
      };
      pname = "ppx_string";
      src = pkgs.fetchurl 
      {
        sha256 = "1a8f7bplbxvwm4lh0m57j89jkwkxfm9r5ndcvvlj5v6py8pv69wj";
        url = "https://github.com/janestreet/ppx_string/archive/v0.14.1.tar.gz";
      };
      version = "v0.14.1";
    };
    ppx_typerep_conv = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
        typerep = selection.typerep;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:13fsnz1ndp973s265alzn2l8r1s5bwyica864xgl247yp77f8yy2";
        package = "packages/ppx_typerep_conv/ppx_typerep_conv.v0.14.2";
      };
      pname = "ppx_typerep_conv";
      src = pkgs.fetchurl 
      {
        sha256 = "1g1sb3prscpa7jwnk08f50idcgyiiv0b9amkl0kymj5cghkdqw0n";
        url = "https://github.com/janestreet/ppx_typerep_conv/archive/v0.14.2.tar.gz";
      };
      version = "v0.14.2";
    };
    ppx_variants_conv = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppxlib = selection.ppxlib;
        variantslib = selection.variantslib;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0x7xyzzdp9gpx3j32nkh8n1baw8831ppa40c5s4lb4f5gpzjg9m9";
        package = "packages/ppx_variants_conv/ppx_variants_conv.v0.14.2";
      };
      pname = "ppx_variants_conv";
      src = pkgs.fetchurl 
      {
        sha256 = "06d63vi2ijzqa3wqnywwqywldq72karss39zi47d544y10rq4rid";
        url = "https://github.com/janestreet/ppx_variants_conv/archive/v0.14.2.tar.gz";
      };
      version = "v0.14.2";
    };
    ppxlib = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        ocaml-compiler-libs = selection.ocaml-compiler-libs;
        ppx_derivers = selection.ppx_derivers;
        sexplib0 = selection.sexplib0;
        stdlib-shims = selection.stdlib-shims;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1hym210g2ggbzqlnkshn8c3yihcrlqklwmy4ihsm09k5ln7wa9al";
        package = "packages/ppxlib/ppxlib.0.23.0";
      };
      pname = "ppxlib";
      src = pkgs.fetchurl 
      {
        sha256 = "1r8jzrqrklwgdbc9qwmp36shhkwgjvrr9nj7rxma3mdrhv0kcn0v";
        url = "https://github.com/ocaml-ppx/ppxlib/releases/download/0.23.0/ppxlib-0.23.0.tbz";
      };
      version = "0.23.0";
    };
    re = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        seq = selection.seq;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1f2xgscc07g800ia8z43i1p377dj2fjdrpzsqgzvw1dnplwnklya";
        package = "packages/re/re.1.10.3";
      };
      pname = "re";
      src = pkgs.fetchurl 
      {
        sha256 = "1fqfg609996bgxr14yyfxhvl6hm9c1j0mm2xjdjigqrzgyb4crc4";
        url = "https://github.com/ocaml/ocaml-re/releases/download/1.10.3/re-1.10.3.tbz";
      };
      version = "1.10.3";
    };
    react = 
    {
      opamInputs = 
      {
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
        topkg = selection.topkg;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0wk5i83r2hxz1r1skkhzz8rild68m4g9i9blxigbg9r60hgw18z5";
        package = "packages/react/react.1.2.1";
      };
      pname = "react";
      src = pkgs.fetchurl 
      {
        sha256 = "1aj8w79gdd9xnrbz7s5p8glcb4pmimi8jp9f439dqnf6ih3mqb3v";
        url = "http://erratique.ch/software/react/releases/react-1.2.1.tbz";
      };
      version = "1.2.1";
    };
    result = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0ybmvlisfz5swvbcq855czz1ysv9zxmb79f1m0x8284hczmfm98f";
        package = "packages/result/result.1.5";
      };
      pname = "result";
      src = pkgs.fetchurl 
      {
        sha256 = "0cpfp35fdwnv3p30a06wd0py3805qxmq3jmcynjc3x2qhlimwfkw";
        url = "https://github.com/janestreet/result/releases/download/1.5/result-1.5.tbz";
      };
      version = "1.5";
    };
    seq = 
    {
      opamInputs = {
                     ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1vm8mk6zm2q3fwnkprl6jib048zr4ysldw0bl74x6wwbxj0vx6k9";
        package = "packages/seq/seq.base";
      };
      pname = "seq";
      src = null;
      version = "base";
    };
    sexplib = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        num = selection.num;
        ocaml = selection.ocaml;
        parsexp = selection.parsexp;
        sexplib0 = selection.sexplib0;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1nlzjkx60d4z09b15nq35ivzl6akk3svq7nl4vv5swhsmj8gvpl4";
        package = "packages/sexplib/sexplib.v0.14.0";
      };
      pname = "sexplib";
      src = pkgs.fetchurl 
      {
        sha256 = "12rlnc6fcrjfdn3gs2agi418sj54ighhs6dfll37zcv7mgywblm2";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/sexplib-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    sexplib0 = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0k9vkjbiibja48c0yayal7xwyik3h3c3v4dwd3j7jbmras63ig2c";
        package = "packages/sexplib0/sexplib0.v0.14.0";
      };
      pname = "sexplib0";
      src = pkgs.fetchurl 
      {
        sha256 = "0adrc0r1vvvr41dcpj8jwkzh1dfgqf0mks9xlnnskqfm3a51iavg";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/sexplib0-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    spawn = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0mllm9byw1w9kl04i8wgrz2rkzsff0q3ki4qf5cripwhfi2as9ph";
        package = "packages/spawn/spawn.v0.14.0";
      };
      pname = "spawn";
      src = pkgs.fetchurl 
      {
        sha256 = "153x03v5ji6wg30i45lxxd057lyqysrxndriaw8ssvr3mlylfyqs";
        url = "https://github.com/janestreet/spawn/releases/download/v0.14.0/spawn-v0.14.0.tbz";
      };
      version = "v0.14.0";
    };
    splittable_random = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_assert = selection.ppx_assert;
        ppx_bench = selection.ppx_bench;
        ppx_inline_test = selection.ppx_inline_test;
        ppx_sexp_message = selection.ppx_sexp_message;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:14s1ka5p5af599ira53kygzny65ls49vkxw3xk9ia5xavp7gv4bp";
        package = "packages/splittable_random/splittable_random.v0.14.0";
      };
      pname = "splittable_random";
      src = pkgs.fetchurl 
      {
        sha256 = "185rpmdnrzs80br138pnjbx9hfp1046zvj1ap0brq1sxdwzak6lf";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/splittable_random-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    stdio = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:19hlf6bgx1avq4ifwji2rj2f2j26v3nf8ywjnwh2m3dpvfqc4pvk";
        package = "packages/stdio/stdio.v0.14.0";
      };
      pname = "stdio";
      src = pkgs.fetchurl 
      {
        sha256 = "1hj5hraprqy2i90a690l11yjszvb99j818q3d684ryx6p2lddk0l";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/stdio-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    stdlib-shims = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:19g9dnaxyh2ajz6pdczdsqzzvsmfrxwx6f613inkr31jw5hrqkiz";
        package = "packages/stdlib-shims/stdlib-shims.0.3.0";
      };
      pname = "stdlib-shims";
      src = pkgs.fetchurl 
      {
        sha256 = "0jnqsv6pqp5b5g7lcjwgd75zqqvcwcl5a32zi03zg1kvj79p5gxs";
        url = "https://github.com/ocaml/stdlib-shims/releases/download/0.3.0/stdlib-shims-0.3.0.tbz";
      };
      version = "0.3.0";
    };
    textutils = 
    {
      opamInputs = 
      {
        core = selection.core;
        core_kernel = selection.core_kernel;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_jane = selection.ppx_jane;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:09ikh4xmy7ghzvz8m1p790jbhi04akarlaxqaywjl1f1qbdrhpnk";
        package = "packages/textutils/textutils.v0.14.0";
      };
      pname = "textutils";
      src = pkgs.fetchurl 
      {
        sha256 = "1ss956gfk2pch3nsqis4x7z79j2d6q002bf8z8xw9z2r64wzi8hl";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/textutils-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    time_now = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        jane-street-headers = selection.jane-street-headers;
        jst-config = selection.jst-config;
        ocaml = selection.ocaml;
        ppx_base = selection.ppx_base;
        ppx_optcomp = selection.ppx_optcomp;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1s8bqbks0cjw4x68nn5xlkykn3bcqh2rmrx6hgs53dalkiqv7ry0";
        package = "packages/time_now/time_now.v0.14.0";
      };
      pname = "time_now";
      src = pkgs.fetchurl 
      {
        sha256 = "0hkn2jw4dz5gflnsblskl5wp6z7zbrahwjmaxmsskfviwjg82cqh";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/time_now-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    timezone = 
    {
      opamInputs = 
      {
        core_kernel = selection.core_kernel;
        dune = selection.dune;
        ocaml = selection.ocaml;
        ppx_jane = selection.ppx_jane;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1508a5cygb5p4n3kknx8dsrndf9x47fsq232gz4hr9pm8ipriixz";
        package = "packages/timezone/timezone.v0.14.0";
      };
      pname = "timezone";
      src = pkgs.fetchurl 
      {
        sha256 = "095xni0szjqqax2r9zh9820l72ixfga2pl0njnarp3795vkw0rdp";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/timezone-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    topkg = 
    {
      opamInputs = 
      {
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:0gvngd4nayhhw02gcsljvmx6jkjpv9m3mqwpgimcfq04h0cf4knb";
        package = "packages/topkg/topkg.1.0.4";
      };
      pname = "topkg";
      src = pkgs.fetchurl 
      {
        sha256 = "1kzw5cxkizcvh4rgzwgpjlj9hfxfk6yr686bxx6wrbsfs8as371k";
        url = "https://erratique.ch/software/topkg/releases/topkg-1.0.4.tbz";
      };
      version = "1.0.4";
    };
    trie = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:19fpyjxqyniqjnpbqxbdb9i8khn33aqmn144h30apbdq8pxb950i";
        package = "packages/trie/trie.1.0.0";
      };
      pname = "trie";
      src = pkgs.fetchurl 
      {
        sha256 = "1slq4kiwnc723dsaw15ms7xxpqz061v8zck1m6iyc5j2li70by62";
        url = "https://github.com/kandu/trie/archive/1.0.0.tar.gz";
      };
      version = "1.0.0";
    };
    typerep = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1hhgz8nrarcmbrnknah05wlz3yf1sq4j4mjgjajmbjnls26dkyfa";
        package = "packages/typerep/typerep.v0.14.0";
      };
      pname = "typerep";
      src = pkgs.fetchurl 
      {
        sha256 = "0rmp5jsjg6sgn5yx0pcvch0phs7nak2fg1d48g5sjcyyyj8n1279";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/typerep-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    tyxml = 
    {
      opamInputs = 
      {
        dune = selection.dune;
        ocaml = selection.ocaml;
        re = selection.re;
        seq = selection.seq;
        uutf = selection.uutf;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1lw91vsiijp4n6vgpfbws72c1v7a1b0v1fkxd7spasl8z27ljq2g";
        package = "packages/tyxml/tyxml.4.5.0";
      };
      pname = "tyxml";
      src = pkgs.fetchurl 
      {
        sha256 = "0s30f72m457c3gbdmdwbx7ls9zg806nvm83aiz9qkpglbppwr6n6";
        url = "https://github.com/ocsigen/tyxml/releases/download/4.5.0/tyxml-4.5.0.tbz";
      };
      version = "4.5.0";
    };
    uchar = 
    {
      opamInputs = 
      {
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:17sfpyj5a1z3knnjvnfa5vql6cj2x9pzgzk8w4jrvd2zii2bwpcl";
        package = "packages/uchar/uchar.0.0.2";
      };
      pname = "uchar";
      src = pkgs.fetchurl 
      {
        sha256 = "1w2saw7zanf9m9ffvz2lvcxvlm118pws2x1wym526xmydhqpyfa7";
        url = "https://github.com/ocaml/uchar/releases/download/v0.0.2/uchar-0.0.2.tbz";
      };
      version = "0.0.2";
    };
    utop = 
    {
      opamInputs = 
      {
        base-threads = selection.base-threads;
        base-unix = selection.base-unix;
        camomile = selection.camomile;
        cppo = selection.cppo;
        dune = selection.dune;
        lambda-term = selection.lambda-term;
        lwt = selection.lwt;
        lwt_react = selection.lwt_react;
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
        react = selection.react;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:06vqirjvqjqx9h33nd7c25x51zfl28icjkvhqdsgw8rggssmpx9k";
        package = "packages/utop/utop.2.8.0";
      };
      pname = "utop";
      src = pkgs.fetchurl 
      {
        sha256 = "0mi571ifjzq4wcjarn8q1b7yl8nxjm1jfx3afac224lqwn6bhb2d";
        url = "https://github.com/ocaml-community/utop/releases/download/2.8.0/utop-2.8.0.tbz";
      };
      version = "2.8.0";
    };
    uutf = 
    {
      opamInputs = 
      {
        cmdliner = selection.cmdliner or null;
        ocaml = selection.ocaml;
        ocamlbuild = selection.ocamlbuild;
        ocamlfind = selection.ocamlfind;
        topkg = selection.topkg;
        uchar = selection.uchar;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1j4hkk196lg1dsnf6jb1n8y3na606lkfb5vlr0gjb53qc7pdh6cy";
        package = "packages/uutf/uutf.1.0.2";
      };
      pname = "uutf";
      src = pkgs.fetchurl 
      {
        sha256 = "1nx1rly3qj23jzn9yk3x6fwqimcxjd84kv5859vvhdg56psq26p6";
        url = "http://erratique.ch/software/uutf/releases/uutf-1.0.2.tbz";
      };
      version = "1.0.2";
    };
    variantslib = 
    {
      opamInputs = 
      {
        base = selection.base;
        dune = selection.dune;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1g0z5w2wgsj59vrz7mdzjxdg0vxhck0q8yvzhvag77xzw85r5kjs";
        package = "packages/variantslib/variantslib.v0.14.0";
      };
      pname = "variantslib";
      src = pkgs.fetchurl 
      {
        sha256 = "11zp27gh282dx9ifbhcp6i7fkc97fvk8amaj58mf1g1hwklc0lm3";
        url = "https://ocaml.janestreet.com/ocaml-core/v0.14/files/variantslib-v0.14.0.tar.gz";
      };
      version = "v0.14.0";
    };
    yojson = 
    {
      opamInputs = 
      {
        biniou = selection.biniou;
        cppo = selection.cppo;
        dune = selection.dune;
        easy-format = selection.easy-format;
        ocaml = selection.ocaml;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:1n8iih0jmaf9b0hsv6ph729jajws9w43kgm24324p4wlj45rjs2q";
        package = "packages/yojson/yojson.1.7.0";
      };
      pname = "yojson";
      src = pkgs.fetchurl 
      {
        sha256 = "1iich6323npvvs8r50lkr4pxxqm9mf6w67cnid7jg1j1g5gwcvv5";
        url = "https://github.com/ocaml-community/yojson/releases/download/1.7.0/yojson-1.7.0.tbz";
      };
      version = "1.7.0";
    };
    zarith = 
    {
      opamInputs = 
      {
        conf-gmp = selection.conf-gmp;
        ocaml = selection.ocaml;
        ocamlfind = selection.ocamlfind;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:03by05004bgfkfllpacf3vk1h8i6q7wzwi7cgxy0nyj5ffga0ggh";
        package = "packages/zarith/zarith.1.12";
      };
      pname = "zarith";
      src = pkgs.fetchurl 
      {
        sha256 = "1098xpqsq3gwpz9k2gc6ahiz2zk0z0xxi1lwc07nvj2570y5ccnc";
        url = "https://github.com/ocaml/Zarith/archive/release-1.12.tar.gz";
      };
      version = "1.12";
    };
    zed = 
    {
      opamInputs = 
      {
        base-bytes = selection.base-bytes;
        camomile = selection.camomile;
        charInfo_width = selection.charInfo_width;
        dune = selection.dune;
        ocaml = selection.ocaml;
        react = selection.react;
      };
      opamSrc = repoPath (repos.opam-repository.src) 
      {
        hash = "sha256:163xyha7x4q4fd1aai8cll72py1jkp9bl1qpz9smqn3dbzfrkrk0";
        package = "packages/zed/zed.3.1.0";
      };
      pname = "zed";
      src = pkgs.fetchurl 
      {
        sha256 = "1z95fs49hi00xy078a83m0vfdqwjb5953rwr15lfpirldi4v11y3";
        url = "https://github.com/ocaml-community/zed/archive/3.1.0.tar.gz";
      };
      version = "3.1.0";
    };
  };
}

