#! /usr/bin/env python3
# -*- coding: utf-8 -*-

# Tauon Music Box

# Copyright © 2015-2024, Taiko2k captain(dot)gxj(at)gmail.com

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

# --------------------------------------------------------------------
# Preamble

# Welcome to the Tauon Music Box source code. I started this project when I was first
# learning python, as a result this code can be quite messy. No doubt I have
# written some things terribly wrong or inefficiently in places.
# I would highly recommend not using this project as an example on how to code cleanly or correctly.

# --------------------------------------------------------------------

import sys
import socket

from t_modules import t_bootstrap
from t_modules.t_phazor import player4, phazor_exists


h = t_bootstrap.holder
t_window = h.w
renderer = h.r
logical_size = h.wl
window_size = h.wr
maximized = h.m
scale = h.s
window_opacity = h.o
draw_border = h.d
transfer_args_and_exit = h.e
old_window_position = h.ow
install_directory = h.id
pyinstaller_mode = h.py
phone = h.p
window_default_size = h.wdf
window_title = h.window_title
fs_mode = h.fs_mode
t_title = h.title
n_version = h.n_version
t_version = h.t_version
t_id = h.t_id
t_agent = h.agent
dev_mode = h.dev_mode
instance_lock = h.lock
print(f"Window size: {window_size}")

should_save_state = True

import os
import pickle
import shutil

# Detect platform
windows_native = False
macos = False
msys = False
if sys.platform == 'win32':
    # system = 'windows'
    # windows_native = False
    system = 'linux'
    msys = True
else:
    system = 'linux'
    import fcntl

if sys.platform == "darwin":
    macos = True

if not windows_native:
    import gi
    from gi.repository import GLib

    font_folder = os.path.join(install_directory, "fonts")
    if os.path.isdir(font_folder):
        import ctypes

        fc = ctypes.cdll.LoadLibrary("libfontconfig-1.dll")
        fc.FcConfigReference.restype = ctypes.c_void_p
        fc.FcConfigReference.argtypes = (ctypes.c_void_p,)
        fc.FcConfigAppFontAddDir.argtypes = (ctypes.c_void_p, ctypes.c_char_p)
        config = ctypes.c_void_p()
        config.contents = fc.FcConfigGetCurrent()
        fc.FcConfigAppFontAddDir(config.value, font_folder.encode())

# Detect what desktop environment we are in to enable specific features
desktop = os.environ.get('XDG_CURRENT_DESKTOP')
# de_notify_support = desktop == 'GNOME' or desktop == 'KDE'
de_notify_support = False
draw_min_button = True
draw_max_button = True
left_window_control = False
xdpi = 0

from t_modules.t_extra import *

detect_macstyle = False
gtk_settings = None
mac_close = (253, 70, 70, 255)
mac_maximize = (254, 176, 36, 255)
mac_minimize = (42, 189, 49, 255)
try:
    gi.require_version('Gtk', '3.0')
    from gi.repository import Gtk

    gtk_settings = Gtk.Settings().get_default()
    xdpi = gtk_settings.get_property("gtk-xft-dpi") / 1024
    if "minimize" not in str(gtk_settings.get_property("gtk-decoration-layout")):
        draw_min_button = False
    if "maximize" not in str(gtk_settings.get_property("gtk-decoration-layout")):
        draw_max_button = False
    if "close" in str(gtk_settings.get_property("gtk-decoration-layout")).split(":")[0]:
        left_window_control = True
    gtk_theme = str(gtk_settings.get_property("gtk-theme-name")).lower()
    #print(f"GTK theme is: {gtk_theme}")
    for k, v in mac_styles.items():
        if k in gtk_theme:
            detect_macstyle = True
            if v is not None:
                mac_close = v[0]
                mac_maximize = v[1]
                mac_minimize = v[2]

except:
    print("Error accessing GTK settings")

# if system == "windows" or msys:
#     os.environ["PYSDL2_DLL_PATH"] = install_directory + "\\lib"

# Assume that it's a classic Linux install, use standard paths
if install_directory.startswith("/usr/"):
    install_directory = "/usr/share/TauonMusicBox"

# Set data folders (portable mode)
user_directory = install_directory
config_directory = user_directory
cache_directory = os.path.join(user_directory, "cache")
home_directory = os.path.join(os.path.expanduser('~'))

asset_directory = os.path.join(install_directory, "assets")
svg_directory = os.path.join(install_directory, "assets/svg")
scaled_asset_directory = asset_directory

music_directory = os.path.join(os.path.expanduser('~'), "Music")
if not os.path.isdir(music_directory):
    music_directory = os.path.join(os.path.expanduser('~'), "music")

download_directory = os.path.join(os.path.expanduser('~'), "Downloads")

# Detect if we are installed or running portable
install_mode = False
flatpak_mode = False
snap_mode = False
if install_directory.startswith("/opt/") \
        or install_directory.startswith("/usr/") \
        or install_directory.startswith("/app/") \
        or install_directory.startswith("/snap/"):

    install_mode = True
    if install_directory[:6] == "/snap/":
        snap_mode = True
    if install_directory[:5] == "/app/":
        # Flatpak mode
        print("Detected running as Flatpak")

        # [old / no longer used] Symlink fontconfig from host system as workaround for poor font rendering
        if os.path.exists(os.path.join(home_directory, ".var/app/com.github.taiko2k.tauonmb/config")):

            host_fcfg = os.path.join(home_directory, ".config/fontconfig/")
            flatpak_fcfg = os.path.join(home_directory, ".var/app/com.github.taiko2k.tauonmb/config/fontconfig")

            if os.path.exists(host_fcfg):

                # if os.path.isdir(flatpak_fcfg) and not os.path.islink(flatpak_fcfg):
                #     shutil.rmtree(flatpak_fcfg)
                if os.path.islink(flatpak_fcfg):
                    print("-- Symlink to fonconfig exists, removing")
                    os.unlink(flatpak_fcfg)
                # else:
                #     print("-- Symlinking user fonconfig")
                #     #os.symlink(host_fcfg, flatpak_fcfg)

        flatpak_mode = True

# If we're installed, use home data locations
if (install_mode and system == 'linux') or macos or msys:

    cache_directory = os.path.join(GLib.get_user_cache_dir(), "TauonMusicBox")
    user_directory = os.path.join(GLib.get_user_data_dir(), "TauonMusicBox")
    config_directory = os.path.join(GLib.get_user_data_dir(), "TauonMusicBox")

    if not os.path.isdir(user_directory):
        os.makedirs(user_directory)

    if not os.path.isdir(config_directory):
        os.makedirs(config_directory)

    if snap_mode:
        print("Installed as Snap")
    elif flatpak_mode:
        print("Installed as Flatpak")
    else:
        print("Running from installed location")

    print("User files location: " + user_directory)

    if not os.path.isdir(os.path.join(user_directory, "encoder")):
        os.makedirs(os.path.join(user_directory, "encoder"))


# elif (system == 'windows' or msys) and ('Program Files' in install_directory or
#                                         os.path.isfile(install_directory + '\\unins000.exe')):
#
#     user_directory = os.path.expanduser('~').replace("\\", '/') + "/Music/TauonMusicBox"
#     config_directory = user_directory
#     cache_directory = user_directory + "\\cache"
#     print("User Directroy: ", end="")
#     print(user_directory)
#     install_mode = True
#     if not os.path.isdir(user_directory):
#         os.makedirs(user_directory)


else:
    print("Running in portable mode")

    user_directory = os.path.join(install_directory, "user-data")
    config_directory = user_directory

    if not os.path.isdir(user_directory):
        os.makedirs(user_directory)

if not os.path.isfile(os.path.join(user_directory, "state.p")):
    if os.path.isdir(cache_directory):
        print("Clearing old cache directory")
        print(cache_directory)
        shutil.rmtree(cache_directory)

n_cache_dir = os.path.join(cache_directory, "network")
e_cache_dir = os.path.join(cache_directory, "export")
g_cache_dir = os.path.join(cache_directory, "gallery")
a_cache_dir = os.path.join(cache_directory, "artist")
r_cache_dir = os.path.join(cache_directory, "radio-thumbs")
b_cache_dir = os.path.join(user_directory, "artist-backgrounds")

if not os.path.isdir(n_cache_dir):
    os.makedirs(n_cache_dir)
if not os.path.isdir(e_cache_dir):
    os.makedirs(e_cache_dir)
if not os.path.isdir(g_cache_dir):
    os.makedirs(g_cache_dir)
if not os.path.isdir(a_cache_dir):
    os.makedirs(a_cache_dir)
if not os.path.isdir(b_cache_dir):
    os.makedirs(b_cache_dir)
if not os.path.isdir(r_cache_dir):
    os.makedirs(r_cache_dir)

if not os.path.isdir(os.path.join(user_directory, "artist-pictures")):
    os.makedirs(os.path.join(user_directory, "artist-pictures"))

if not os.path.isdir(os.path.join(user_directory, "theme")):
    os.makedirs(os.path.join(user_directory, "theme"))

if system == 'linux':
    system_config_directory = GLib.get_user_config_dir()
    xdg_dir_file = os.path.join(system_config_directory, 'user-dirs.dirs')

    if os.path.isfile(xdg_dir_file):
        with open(xdg_dir_file) as f:
            for line in f.readlines():
                if line.startswith("XDG_MUSIC_DIR="):
                    music_directory = os.path.expanduser(
                        os.path.expandvars(line.split("=")[1].strip().replace('"', "")))
                    print(f"Found XDG-Music: {music_directory}")
                if line.startswith("XDG_DOWNLOAD_DIR="):
                    target = os.path.expanduser(os.path.expandvars(line.split("=")[1].strip().replace('"', "")))
                    if os.path.isdir(target):
                        download_directory = target
                    print(f"Found XDG-Downloads: {download_directory}")

if not os.path.isdir(music_directory):
    music_directory = None

print('Install directory: ' + install_directory)

old_backend = 2

# Things for detecting and launching programs outside of flatpak sandbox
def whicher(target):
    try:
        if flatpak_mode:
            complete = subprocess.run(shlex.split("flatpak-spawn --host which " + target), stdout=subprocess.PIPE,
                                      stderr=subprocess.PIPE)
            r = complete.stdout.decode()
            return "bin/" + target in r
        else:
            return shutil.which(target)
    except:
        return False


launch_prefix = ""
if flatpak_mode:
    launch_prefix = "flatpak-spawn --host "

pid = os.getpid()

from sdl2 import *
from sdl2.sdlimage import *
from ctypes import pointer

if not macos:
    icon = IMG_Load(os.path.join(asset_directory, "icon-64.png").encode())
else:
    icon = IMG_Load(os.path.join(asset_directory, "tau-mac.png").encode())

SDL_SetWindowIcon(t_window, icon)

if not phone:
    if window_size[0] != logical_size[0]:
        SDL_SetWindowMinimumSize(t_window, 560, 330)
    else:
        SDL_SetWindowMinimumSize(t_window, round(560 * scale), round(330 * scale))

max_window_tex = 1000
if window_size[0] > max_window_tex or window_size[1] > max_window_tex:

    while window_size[0] > max_window_tex:
        max_window_tex += 1000
    while window_size[1] > max_window_tex:
        max_window_tex += 1000

main_texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, max_window_tex,
                                 max_window_tex)
main_texture_overlay_temp = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET,
                                              max_window_tex, max_window_tex)

overlay_texture_texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, 300, 300)
SDL_SetTextureBlendMode(overlay_texture_texture, SDL_BLENDMODE_BLEND)
SDL_SetRenderTarget(renderer, overlay_texture_texture)
SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
SDL_RenderClear(renderer)
SDL_SetRenderTarget(renderer, None)

tracklist_texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, max_window_tex,
                                      max_window_tex)
tracklist_texture_rect = SDL_Rect(0, 0, max_window_tex, max_window_tex)
SDL_SetTextureBlendMode(tracklist_texture, SDL_BLENDMODE_BLEND)

SDL_SetRenderTarget(renderer, None)

# Paint main texture
SDL_SetRenderTarget(renderer, main_texture)
SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255)

SDL_SetRenderTarget(renderer, main_texture_overlay_temp)
SDL_SetTextureBlendMode(main_texture_overlay_temp, SDL_BLENDMODE_BLEND)
SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255)
SDL_RenderClear(renderer)


#
# SDL_SetRenderTarget(renderer, None)
# SDL_SetRenderDrawColor(renderer, 7, 7, 7, 255)
# SDL_RenderClear(renderer)
# #SDL_RenderPresent(renderer)
#
# SDL_SetWindowOpacity(t_window, window_opacity)


class LoadImageAsset:
    assets = []

    def __init__(self, path, is_full_path=False, reload=False, scale_name=""):
        if not reload:
            self.assets.append(self)

        self.path = path
        self.scale_name = scale_name

        raw_image = IMG_Load(self.path.encode())
        self.sdl_texture = SDL_CreateTextureFromSurface(renderer, raw_image)

        p_w = pointer(c_int(0))
        p_h = pointer(c_int(0))
        SDL_QueryTexture(self.sdl_texture, None, None, p_w, p_h)

        if is_full_path:
            SDL_SetTextureAlphaMod(self.sdl_texture, prefs.custom_bg_opacity)

        self.rect = SDL_Rect(0, 0, p_w.contents.value, p_h.contents.value)
        SDL_FreeSurface(raw_image)
        self.w = p_w.contents.value
        self.h = p_h.contents.value

    def reload(self):
        SDL_DestroyTexture(self.sdl_texture)
        if self.scale_name:
            self.path = os.path.join(scaled_asset_directory, self.scale_name)
        self.__init__(self.path, reload=True, scale_name=self.scale_name)

    def render(self, x, y, colour=None):
        self.rect.x = round(x)
        self.rect.y = round(y)
        SDL_RenderCopy(renderer, self.sdl_texture, None, self.rect)


class WhiteModImageAsset:
    assets = []

    def __init__(self, path, reload=False, scale_name=""):
        if not reload:
            self.assets.append(self)
        self.path = path
        self.scale_name = scale_name
        raw_image = IMG_Load(path.encode())
        self.sdl_texture = SDL_CreateTextureFromSurface(renderer, raw_image)
        self.colour = [255, 255, 255, 255]
        p_w = pointer(c_int(0))
        p_h = pointer(c_int(0))
        SDL_QueryTexture(self.sdl_texture, None, None, p_w, p_h)
        self.rect = SDL_Rect(0, 0, p_w.contents.value, p_h.contents.value)
        SDL_FreeSurface(raw_image)
        self.w = p_w.contents.value
        self.h = p_h.contents.value

    def reload(self):
        SDL_DestroyTexture(self.sdl_texture)
        if self.scale_name:
            self.path = os.path.join(scaled_asset_directory, self.scale_name)
        self.__init__(self.path, reload=True, scale_name=self.scale_name)

    def render(self, x, y, colour):
        if colour != self.colour:
            SDL_SetTextureColorMod(self.sdl_texture, colour[0], colour[1], colour[2])
            SDL_SetTextureAlphaMod(self.sdl_texture, colour[3])
            self.colour = colour
        self.rect.x = round(x)
        self.rect.y = round(y)
        SDL_RenderCopy(renderer, self.sdl_texture, None, self.rect)


loaded_asset_dc = {}


def asset_loader(name, mod=False):
    if name in loaded_asset_dc:
        return loaded_asset_dc[name]

    target = os.path.join(scaled_asset_directory, name)
    if mod:
        item = WhiteModImageAsset(target, scale_name=name)
    else:
        item = LoadImageAsset(target, scale_name=name)
    loaded_asset_dc[name] = item
    return item


# loading_image = asset_loader('loading.png')

if maximized:
    i_x = pointer(c_int(0))
    i_y = pointer(c_int(0))
    import time

    time.sleep(0.02)
    SDL_PumpEvents()
    SDL_GetWindowSize(t_window, i_x, i_y)
    logical_size[0] = i_x.contents.value
    logical_size[1] = i_y.contents.value
    SDL_GL_GetDrawableSize(t_window, i_x, i_y)
    window_size[0] = i_x.contents.value
    window_size[1] = i_y.contents.value

# loading_image.render(window_size[0] // 2 - loading_image.w // 2, window_size[1] // 2 - loading_image.h // 2)
# SDL_RenderPresent(renderer)

# if install_directory != config_directory and not os.path.isfile(os.path.join(config_directory, "config.txt")):
#     print("Config file is missing... copying template from program files")
#     shutil.copy(os.path.join(install_directory, "config.txt"), config_directory)

if install_directory != config_directory and not os.path.isfile(os.path.join(config_directory, "input.txt")):
    print("Input config file is missing... copying template from program files")
    shutil.copy(os.path.join(install_directory, "input.txt"), config_directory)

last_fm_enable = False

try:
    import setproctitle

    setproctitle.setproctitle("tauonmb")
except:
    print("Could not set process title.")

# try:
#     import rpc
#     discord_allow = True
# except:
#     pass
try:
    from pypresence import Presence
    import asyncio

    discord_allow = True
except:
    discord_allow = False

if snap_mode:
    discord_allow = False

if system == "windows":
    import win32con, win32api, win32gui, win32ui, comtypes
    import atexit

try:
    import pylast
    last_fm_enable = True
    if pyinstaller_mode:
        pylast.SSL_CONTEXT.load_verify_locations(os.path.join(install_directory, "certifi", "cacert.pem"))
except:
    last_fm_enable = False
    print("PyLast moduel not found, last fm will be disabled.")

use_cc = False
try:
    import opencc
    s2t = opencc.OpenCC('s2t')
    t2s = opencc.OpenCC('t2s')
    use_cc = True
except:
    print("OpenCC not found.")

use_natsort = False
try:
    import natsort

    use_natsort = True
except:
    print("Warning: Python module natsort not found")

import platform as py_platform
import time
import ctypes
import ctypes.util
import random
import threading
import logging
import io
import copy
import subprocess
import urllib.parse
import urllib.request
import datetime
import shlex
import math
import locale as py_locale
import webbrowser
import base64
import re
import zipfile
import warnings
import colorsys
import requests
import stat
import hashlib
import platform
import gettext
import secrets
import json
import glob
import xml.etree.ElementTree as ET
import musicbrainzngs
from pathlib import Path
from xml.sax.saxutils import escape, unescape
from ctypes import *
from send2trash import send2trash
from isounidecode import unidecode
from collections import OrderedDict

musicbrainzngs.set_useragent("TauonMusicBox", n_version, "https://github.com/Taiko2k/Tauon")

arch = platform.machine()
win_ver = platform.release()
try:
    win_ver = int(win_ver)
except:
    win_ver = 0


# print(arch)
# -----------------------------------------------------------
# Detect locale for translations (currently none available)

def _(message):
    return message


try:
    py_locale.setlocale(py_locale.LC_ALL, '')
except:
    print("SET LOCALE ERROR")

# ------------------------------------------------

if system == 'windows':
    os.environ["PYSDL2_DLL_PATH"] = install_directory + "\\lib"
elif not msys and not macos:
    try:
        gi.require_version('Notify', '0.7')
    except:
        gi.require_version('Notify', '0.8')
    from gi.repository import Notify

# Other imports

from PIL import Image, ImageDraw, ImageFilter, ImageEnhance

try:
    from jxlpy import JXLImagePlugin

    print("Found jxlpy for JPEG XL support")
except:
    pass

import mutagen
import mutagen.id3
import mutagen.flac
import mutagen.mp4
import mutagen.oggvorbis


def no_padding(info):
    # this will remove all padding
    return 0

wayland = True
if not os.environ.get('SDL_VIDEODRIVER') == "wayland":
    wayland = False
    os.environ['GDK_BACKEND'] = "x11"

from t_modules.t_tagscan import Flac
from t_modules.t_tagscan import Opus
from t_modules.t_tagscan import Ape
from t_modules.t_tagscan import Wav
from t_modules.t_tagscan import M4a
from t_modules.t_tagscan import parse_picture_block

from t_modules.t_stream import *
from t_modules.t_lyrics import *
from t_modules.t_themeload import *
from t_modules.t_spot import SpotCtl
from t_modules.t_search import *

if system == 'linux':
    from t_modules import t_topchart

if system == "linux" and not macos and not msys:
    from t_modules.t_dbus import Gnome

# Setting various timers

message_box_min_timer = Timer()
cursor_blink_timer = Timer()
animate_monitor_timer = Timer()
min_render_timer = Timer()
check_file_timer = Timer()
vis_rate_timer = Timer()
vis_decay_timer = Timer()
scroll_timer = Timer()
perf_timer = Timer()
quick_d_timer = Timer()
core_timer = Timer()
sleep_timer = Timer()
gallery_select_animate_timer = Timer()
gallery_select_animate_timer.force_set(10)
search_clear_timer = Timer()
gall_pl_switch_timer = Timer()
gall_pl_switch_timer.force_set(999)
d_click_timer = Timer()
d_click_timer.force_set(10)
lyrics_check_timer = Timer()
scroll_hide_timer = Timer(100)
scroll_gallery_hide_timer = Timer(100)
get_lfm_wait_timer = Timer(10)
lyrics_fetch_timer = Timer(10)
gallery_load_delay = Timer(10)
queue_add_timer = Timer(100)
toast_love_timer = Timer(100)
toast_mode_timer = Timer(100)
scrobble_warning_timer = Timer(1000)
sync_file_timer = Timer(1000)
sync_file_update_timer = Timer(1000)
sync_get_device_click_timer = Timer(100)

f_store = FunctionStore()

after_scan = []

search_string_cache = {}
search_dia_string_cache = {}

vis_update = False


# GUI Variables -------------------------------------------------------------------------------------------

# Variables now go in the gui, pctl, input and prefs class instances. The following just haven't been moved yet.

class DConsole:
    def __init__(self):
        self.messages = []
        self.show = False

    def print(self, message, level=0):

        if len(self.messages) > 50:
            del self.messages[0]

        dtime = datetime.datetime.now()
        self.messages.append((message, level, dtime, Timer()))
        if level > 0:
            print(message)


console = DConsole()

spot_cache_saved_albums = []

resize_mode = False

side_panel_text_align = 0

album_mode = False
spec_smoothing = True

# gui.offset_extra = 0

old_album_pos = -55

album_dex = []
album_artist_dict = {}
row_len = 5
last_row = 0
album_v_gap = 66
album_h_gap = 30
album_v_slide_value = 50

album_mode_art_size = int(200 * scale)

time_last_save = 0

b_info_y = int(window_size[1] * 0.7)  # For future possible panel below playlist

volume_store = 50  # Used to save the previous volume when muted

# row_alt = False

to_get = 0  # Used to store temporary import count display
to_got = 0

editline = ""
# gui.rsp = True
quick_drag = False

# Playlist Panel
pl_view_offset = 0
pl_rect = (2, 12, 10, 10)

theme = 7
scroll_enable = True
scroll_timer = Timer()
scroll_timer.set()
scroll_opacity = 0
break_enable = True

source = None

album_playlist_width = 430

update_title = False

playlist_hold_position = 0
playlist_hold = False
selection_stage = 0

selected_in_playlist = -1

shift_selection = []

gen_codes = {}
# Control Variables--------------------------------------------------------------------------

mouse_down = False
right_down = False
click_location = [200, 200]
last_click_location = [0, 0]
mouse_position = [0, 0]
mouse_up_position = [0, 0]

k_input = True
key_shift_down = False
drag_mode = False
side_drag = False
clicked = False

# Player Variables----------------------------------------------------------------------------

format_colours = {  # These are the colours used for the label icon in UI 'track info box'
    "MP3": [255, 130, 80, 255],  # Burnt orange
    "FLAC": [156, 249, 79, 255],  # Bright lime green
    "M4A": [81, 220, 225, 255],  # Soft cyan
    "OGG": [244, 244, 78, 255],  # Light yellow
    "OGA": [244, 244, 78, 255],  # Light yellow
    "WMA": [213, 79, 247, 255],  # Magenta
    "APE": [247, 79, 79, 255],  # Deep pink
    "TTA": [94, 78, 244, 255],  # Purple
    "OPUS": [247, 79, 146, 255],  # Pink
    "AAC": [79, 247, 168, 255],  # Teal
    "WV": [229, 23, 18, 255],  # Deep red
    "PLEX": [229, 160, 13, 255],  # Orange-brown
    "KOEL": [111, 98, 190, 255],  # Lavender
    "TAU": [111, 98, 190, 255],  # Lavender
    "SUB": [235, 140, 20, 255],  # Golden yellow
    "SPTY": [30, 215, 96, 255],  # Bright green
    "JELY": [190, 100, 210, 255],  # Fuchsia
    "XM": [50, 50, 50, 255],  # Grey
    "MOD": [50, 50, 50, 255],  # Grey
    "S3M": [50, 50, 50, 255],  # Grey
    "IT": [50, 50, 50, 255],  # Grey
    "MPTM": [50, 50, 50, 255],  # Grey
    "AY": [237, 212, 255, 255],  # Pastel purple
    "GBS": [255, 165, 0, 255],  # Vibrant orange
    "GYM": [0, 191, 255, 255],  # Bright blue
    "HES": [176, 224, 230, 255],  # Light blue-green
    "KSS": [255, 255, 153, 255],  # Bright yellow
    "NSF": [255, 140, 0, 255],  # Deep orange
    "NSFE": [255, 140, 0, 255],  # Deep orange
    "SAP": [152, 255, 152, 255],  # Light green
    "SPC": [255, 128, 0, 255],  # Bright orange
    "VGM": [0, 128, 255, 255],  # Deep blue
    "VGZ": [0, 128, 255, 255],  # Deep blue
}

# These will be the extensions of files to be added when importing
DA_Formats = {'mp3', 'wav', 'opus', 'flac', 'ape',
              'm4a', 'ogg', 'oga', 'aac', 'tta', 'wv', 'wma'}

VID_Formats = {'mp4', "webm"}

MOD_Formats = {'xm', 'mod', 's3m', 'it', 'mptm', "umx", "okt", "mtm", "669", "far", "wow", "dmf", "med", "mt2", "ult"}

GME_Formats = {'ay', 'gbs', 'gym', 'hes', 'kss', 'nsf', 'nsfe', 'sap', 'spc', 'vgm', 'vgz'}

DA_Formats |= MOD_Formats
DA_Formats |= GME_Formats

Archive_Formats = {'zip'}

if whicher('unrar'):
    Archive_Formats.add("rar")

if whicher('7z'):
    Archive_Formats.add("7z")

cargo = []

# ---------------------------------------------------------------------
# Player variables

# pl_follow = False

# List of encodings to check for with the fix mojibake function
encodings = ['cp932', 'utf-8', 'big5hkscs', 'gbk']  # These seem to be the most common for Japanese

track_box = False

transcode_list = []
transcode_state = ""

taskbar_progress = True
QUE = []

playing_in_queue = 0
draw_sep_hl = False

# -------------------------------------------------------------------------------
# Playlist Variables
playlist_view_position = 0
playlist_playing = -1

loading_in_progress = False

core_use = 0
dl_use = 0

random_mode = False
repeat_mode = False


# Functions to generate empty playlist
# Playlist is [Name, playing, playlist, position, hide folder title, selected, uid, last_folder, hidden(bool)]

# 0 Name (string)
# 1 Playing (int)
# 2 list  (list of int)
# 3 View Position (int)
# 4 hide playlist folder titles (bool)
# 5 selected (int)
# 6 Unique id (int)
# 7 last folder import path (string)
# 8 hidden (bool)
# 9 Locked (bool)
# 10 Filter parent playlist id (string)
# 11 Persist time positioning


def uid_gen():
    return random.randrange(1, 100000000)


notify_change = lambda: None


def pl_gen(title='Default',
           playing=0,
           playlist=None,
           position=0,
           hide_title=0,
           selected=0,
           parent="",
           hidden=False):
    if playlist == None:
        playlist = []

    notify_change()

    return copy.deepcopy(
        [title, playing, playlist, position, hide_title, selected, uid_gen(), [], hidden, False, parent, False])


multi_playlist = [pl_gen()]  # Create default playlist


def queue_item_gen(trackid, position, pl_id, type=0, album_stage=0):
    # type; 0 is track, 1 is album
    auto_stop = False

    return [trackid, position, pl_id, type, album_stage, uid_gen(), auto_stop]


default_playlist = multi_playlist[0][2]
playlist_active = 0

quick_search_mode = False
search_index = 0

# ----------------------------------------
# Playlist right click menu

r_menu_index = 0
r_menu_position = 0

# Library and loader Variables--------------------------------------------------------
master_library = {}

cue_list = []

LC_None = 0
LC_Done = 1
LC_Folder = 2
LC_File = 3

loaderCommand = LC_None
loaderCommandReady = False

master_count = 0

load_orders = []

volume = 75

folder_image_offsets = {}
db_version = 0.0

albums = []
album_position = 0


class Prefs:  # Used to hold any kind of settings

    def __init__(self):
        self.colour_from_image = False
        self.dim_art = False
        self.prefer_side = True  # Saves whether side panel is shown or not
        self.pause_fade_time = 400
        self.change_volume_fade_time = 400
        self.cross_fade_time = 700  # 700
        self.volume_wheel_increment = 2
        self.encoder_output = user_directory + '/encoder/'
        if music_directory is not None:
            self.encoder_output = music_directory + '/encode-output/'
        self.rename_folder_template = "<albumartist> - <album>"
        self.rename_tracks_template = "<tn>. <artist> - <title>.<ext>"

        self.enable_web = False
        self.allow_remote = False
        self.expose_web = True

        self.enable_transcode = True
        self.show_rym = False
        self.show_band = False
        self.show_wiki = False
        self.show_transfer = True
        self.show_queue = True
        self.prefer_bottom_title = True
        self.append_date = True

        self.transcode_codec = 'opus'
        self.transcode_mode = 'single'
        self.transcode_bitrate = 64

        # self.line_style = 1
        self.device = 1
        self.device_name = ""

        self.cache_gallery = True
        self.gallery_row_scroll = True
        self.gallery_scroll_wheel_px = 90

        self.playlist_font_size = 15
        self.playlist_row_height = 27

        self.tag_editor_name = ""
        self.tag_editor_target = ""
        self.tag_editor_path = ""

        self.use_title = False
        self.auto_extract = False
        self.auto_del_zip = False
        self.pl_thumb = False

        self.use_custom_fonts = False
        self.linux_font = "Noto Sans, Noto Sans CJK JP, Arial,"
        self.linux_font_semibold = "Noto Sans, Noto Sans CJK JP, Arial, Medium"
        self.linux_font_bold = "Noto Sans, Noto Sans CJK JP, Bold"
        self.linux_font_condensed = "Noto Sans, Extra-Condensed"
        self.linux_font_condensed_bold = "Noto Sans, Extra-Condensed Bold"

        self.spec2_scroll = True

        self.spec2_p_base = [10, 10, 100]
        self.spec2_p_multiply = [0.5, 1, 1]

        self.spec2_base = [10, 10, 100]
        self.spec2_multiply = [0.5, 1, 1]
        self.spec2_colour_setting = 'custom'

        self.auto_lfm = False
        self.scrobble_mark = False
        self.enable_mpris = True

        self.replay_gain = 0  # 0=off 1=track 2=album
        self.replay_preamp = 0  # db
        self.radio_page_lyrics = True

        self.show_gimage = False
        self.end_setting = "stop"
        self.show_gen = False
        self.show_lyrics_side = True

        self.log_vol = False

        self.ui_scale = scale

        # if flatpak_mode:

        self.transcode_opus_as = False

        self.discord_active = False
        self.discord_ready = False
        self.disconnect_discord = False

        self.monitor_downloads = True
        self.extract_to_music = False

        self.enable_lb = False
        self.lb_token = ""

        self.use_jump_crossfade = True
        self.use_transition_crossfade = False
        self.use_pause_fade = True

        self.show_notifications = True

        self.true_shuffle = True
        self.append_total_time = False
        self.backend = 4  # 2 gstreamer, 4 phazor

        self.album_repeat_mode = False  # passed to pctl
        self.album_shuffle_mode = False  # passed to pctl

        self.finish_current = False  # Finish current album when adding to queue

        self.reload_play_state = False  # Resume playback on app restart
        self.resume_play_wake = False  # Resume playback on wake
        self.reload_state = None

        self.mono = False

        self.last_fm_token = None
        self.last_fm_username = ""

        self.use_card_style = True

        self.plex_username = ""
        self.plex_password = ""
        self.plex_servername = ""

        self.koel_username = "admin@example.com"
        self.koel_password = "admin"
        self.koel_server_url = "http://localhost:8050"

        self.auto_lyrics = False  # Function has been disabled
        self.jelly_username = ""
        self.jelly_password = ""
        self.jelly_server_url = "http://localhost:8096"

        self.auto_lyrics_checked = []

        self.show_side_art = True
        self.always_pin_playlists = True

        self.user_directory = user_directory
        self.cache_directory = cache_directory

        self.window_opacity = window_opacity
        self.gallery_single_click = True
        self.custom_bg_opacity = 40

        self.tabs_on_top = True
        self.desktop = desktop

        self.dc_device = False  # (BASS) Disconnect device on pause
        if desktop == "KDE":
            self.dc_device = True

        self.showcase_vis = True
        self.show_lyrics_showcase = True

        self.spec2_colour_mode = 0
        self.flatpak_mode = flatpak_mode

        self.device_buffer = 80

        self.eq = [0.0] * 10
        self.use_eq = False

        self.bio_large = False
        self.discord_allow = discord_allow
        self.discord_show = False

        self.min_to_tray = False

        self.guitar_chords = False
        self.prefer_synced_lyrics = True
        self.sync_lyrics_time_offset = 0

        self.playback_follow_cursor = False
        self.short_buffer = False

        self.gst_output = "rgvolume pre-amp=-2 fallback-gain=-6 ! autoaudiosink"

        self.art_bg = False
        self.art_bg_stronger = 1
        self.art_bg_opacity = 10
        self.art_bg_blur = 9
        self.art_bg_always_blur = False

        self.random_mode = False
        self.repeat_mode = False

        self.failed_artists = []
        self.failed_background_artists = []

        self.artist_list = False
        self.auto_sort = False

        self.transcode_inplace = False

        self.bg_showcase_only = False

        self.lyrics_enables = []

        self.fatvap = "6b2a9499238ce6416783fc8129b8ac67"

        self.fanart_notify = True
        self.discogs_pat = ""

        self.artist_list_prefer_album_artist = True

        self.mini_mode_mode = 0
        self.dc_device_setting = "on"

        self.download_dir1 = ""
        self.dd_index = False

        self.metadata_page_port = 7590

        self.custom_encoder_output = ""
        self.column_aa_fallback_artist = False

        self.meta_persists_stop = False
        self.meta_shows_selected = False
        self.meta_shows_selected_always = False

        self.left_align_album_artist_title = False
        self.stop_notifications_mini_mode = False
        self.scale_want = 1
        self.x_scale = True
        self.hide_queue = True
        self.show_playlist_list = True
        self.thin_gallery_borders = False
        self.show_current_on_transition = False

        self.force_subpixel_text = False
        if gtk_settings:
            if gtk_settings.get_property("gtk-xft-rgba") == "rgb":
                self.force_subpixel_text = True

        self.chart_rows = 3
        self.chart_columns = 3
        self.chart_bg = [7, 7, 7]
        self.chart_text = True
        self.chart_font = "Monospace 10"
        self.chart_tile = False

        self.chart_cascade = False
        self.chart_c1 = 5
        self.chart_c2 = 6
        self.chart_c3 = 10
        self.chart_d1 = 2
        self.chart_d2 = 2
        self.chart_d3 = 2

        self.art_in_top_panel = True
        self.always_art_header = False

        # self.center_bg = True
        self.ui_lang = 'auto'
        self.side_panel_layout = 0
        self.use_absolute_track_index = False

        self.hide_bottom_title = True
        self.auto_goto_playing = False

        self.diacritic_search = True
        self.increase_gallery_row_spacing = False
        self.center_gallery_text = False

        self.tracklist_y_text_offset = 0
        self.theme_name = "Turbo"
        self.left_panel_mode = "playlist"

        self.folder_tree_codec_colours = False

        self.network_stream_bitrate = 0  # 0 is off

        self.show_side_lyrics_art_panel = True

        self.gst_use_custom_output = False

        self.notify_include_album = True

        self.auto_dl_artist_data = False

        self.enable_fanart_artist = False
        self.enable_fanart_bg = False
        self.enable_fanart_cover = False

        self.always_auto_update_playlists = False

        self.subsonic_server = "http://localhost:4040"
        self.subsonic_user = ""
        self.subsonic_password = ""
        self.subsonic_password_plain = False

        self.subsonic_playlists = {}

        self.write_ratings = False
        self.rating_playtime_stars = False

        self.lyrics_subs = {}

        self.radio_urls = []

        self.lyric_metadata_panel_top = False
        self.showcase_overlay_texture = False

        self.sync_target = ""
        self.sync_deletes = False
        self.sync_playlist = None
        self.download_playlist = None

        self.sep_genre_multi = False
        self.topchart_sorts_played = True

        self.spot_client = ""
        self.spot_secret = ""
        self.spot_username = ""
        self.spot_password = ""
        self.spot_mode = False
        self.launch_spotify_web = False
        self.launch_spotify_local = False
        self.remove_network_tracks = False
        self.bypass_transcode = False
        self.force_hide_max_button = False
        self.zoom_art = False
        self.auto_rec = False
        self.radio_record_codec = "OPUS"
        self.pa_fast_seek = False
        self.precache = False
        self.cache_list = []
        self.cache_limit = 2000  # in mb
        self.save_window_position = True
        self.spotify_token = ""
        self.always_ffmpeg = False

        self.use_libre_fm = False
        self.back_restarts = False

        self.old_playlist_box_position = 0
        self.listenbrainz_url = ""
        self.maloja_enable = False
        self.maloja_url = ""
        self.maloja_key = ""

        self.scrobble_hold = False

        self.artist_list_sort_mode = "alpha"

        self.phazor_device_selected = "Default"
        self.phazor_devices = ["Default"]
        self.bg_flips = set()
        self.use_tray = False
        self.tray_show_title = False
        self.drag_to_unpin = True
        self.enable_remote = False

        self.artist_list_style = 1
        self.discord_enable = False
        self.stop_end_queue = False

        self.block_suspend = False
        self.smart_bypass = True
        self.seek_interval = 15
        self.shuffle_lock = False
        self.album_shuffle_lock_mode = False
        self.premium = False
        self.power_save = False
        if macos or phone:
            self.power_save = True
        self.left_window_control = macos or left_window_control
        self.macstyle = macos or detect_macstyle
        self.radio_thumb_bans = []
        self.show_nag = False

        self.playlist_exports = {}
        self.show_chromecast = False

        self.samplerate = 48000
        self.resample = 1
        self.volume_power = 2

        self.tmp_cache = True

        self.sat_url = ""
        self.lyrics_font_size = 15

        self.use_gamepad = True
        self.avoid_resampling = False
        self.use_scancodes = False

        self.artist_list_threshold = 4
        self.allow_video_formats = True
        self.mini_mode_on_top = True
        self.tray_theme = "pink"

        self.lastfm_pull_love = False
        self.row_title_format = 1
        self.row_title_genre = False
        self.row_title_separator_type = 1
        self.search_on_letter = True

        self.gallery_combine_disc = False

prefs = Prefs()


def open_uri(uri):
    print("OPEN URI")
    load_order = LoadClass()

    for w in range(len(pctl.multi_playlist)):
        if pctl.multi_playlist[w][0] == "Default":
            load_order.playlist = pctl.multi_playlist[w][6]
            break
    else:
        pctl.multi_playlist.append(pl_gen())
        load_order.playlist = pctl.multi_playlist[len(pctl.multi_playlist) - 1][6]
        switch_playlist(len(pctl.multi_playlist) - 1)

    load_order.target = str(urllib.parse.unquote(uri)).replace("file:///", "/").replace("\r", "")

    if gui.auto_play_import is False:
        load_order.play = True
        gui.auto_play_import = True

    load_orders.append(copy.deepcopy(load_order))
    gui.update += 1


class GuiVar:  # Use to hold any variables for use in relation to UI
    def update_layout(self):
        global update_layout
        update_layout = True

    def show_message(self, line1, line2="", line3="", mode="info"):
        show_message(line1, line2, line3, mode=mode)

    def delay_frame(self, t):
        gui.frame_callback_list.append(TestTimer(t))

    def destroy_textures(self):
        SDL_DestroyTexture(self.spec4_tex)
        SDL_DestroyTexture(self.spec1_tex)
        SDL_DestroyTexture(self.spec2_tex)
        SDL_DestroyTexture(self.spec_level_tex)

    # def test_text_input(self):
    #     if self.text_input_request and not self.text_input_active:
    #         SDL_StartTextInput()
    #         self.update += 1
    #     if not self.text_input_request and self.text_input_active:
    #         SDL_StopTextInput()
    #     self.text_input_request = False

    def rescale(self):
        self.spec_y = int(round(5 * self.scale))
        self.spec_w = int(round(80 * self.scale))
        self.spec_h = int(round(20 * self.scale))
        self.spec1_rec = SDL_Rect(0, self.spec_y, self.spec_w, self.spec_h)

        self.spec4_y = int(round(200 * self.scale))
        self.spec4_w = int(round(322 * self.scale))
        self.spec4_h = int(round(100 * self.scale))
        self.spec4_rec = SDL_Rect(0, self.spec4_y, self.spec4_w, self.spec4_h)

        self.bar = SDL_Rect(10, 10, round(3 * self.scale), 10)  # spec bar bin
        self.bar4 = SDL_Rect(10, 10, round(3 * self.scale), 10)  # spec bar bin
        self.set_height = round(25 * self.scale)
        self.panelBY = round(51 * self.scale)
        self.panelY = round(30 * self.scale)
        self.panelY2 = round(30 * self.scale)
        self.playlist_top = self.panelY + (8 * self.scale)
        self.playlist_top_bk = self.playlist_top
        self.scroll_hide_box = (0, self.panelY, 28, window_size[1] - self.panelBY - self.panelY)

        self.spec2_y = int(round(22 * self.scale))
        self.spec2_w = int(round(140 * self.scale))
        self.spec2 = [0] * self.spec2_y
        self.spec2_phase = 0
        self.spec2_buffers = []
        self.spec2_rec = SDL_Rect(1230, round(4 * self.scale), self.spec2_w, self.spec2_y)
        self.spec2_source = SDL_Rect(900, round(4 * self.scale), self.spec2_w, self.spec2_y)
        self.spec2_dest = SDL_Rect(900, round(4 * self.scale), self.spec2_w, self.spec2_y)
        self.spec2_position = 0
        self.spec2_timer = Timer()
        self.spec2_timer.set()

        self.level_w = 5 * self.scale
        self.level_y = 16 * self.scale
        self.level_s = 1 * self.scale
        self.level_ww = round(79 * self.scale)
        self.level_hh = round(18 * self.scale)
        self.spec_level_rec = SDL_Rect(0, round(self.level_y - 10 * self.scale), round(self.level_ww),
                                       round(self.level_hh))

        self.spec2_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, self.spec2_w,
                                           self.spec2_y)
        self.spec4_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, self.spec4_w,
                                           self.spec4_y)
        self.spec1_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, self.spec_w,
                                           self.spec_h)
        self.spec_level_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET,
                                                self.level_ww, self.level_hh)
        SDL_SetTextureBlendMode(self.spec4_tex, SDL_BLENDMODE_BLEND)
        self.artist_panel_height = 320 * self.scale
        self.last_artist_panel_height = self.artist_panel_height

        self.window_control_hit_area_w = 100 * self.scale
        self.window_control_hit_area_h = 30 * self.scale

    def __init__(self):

        self.scale = prefs.ui_scale

        self.window_id = 0
        self.update = 2  # UPDATE
        self.turbo = True
        self.turbo_next = 0
        self.pl_update = 1
        self.lowered = False
        self.request_raise = False
        self.maximized = False

        self.message_box = False
        self.message_text = ""
        self.message_mode = 'info'
        self.message_subtext = ""
        self.message_subtext2 = ""
        self.message_box_confirm_reference = None
        self.message_box_use_reference = True
        self.message_box_confirm_callback = None

        self.save_size = [450, 310]
        self.show_playlist = True
        self.show_bottom_title = False
        # self.show_top_title = True
        self.search_error = False

        self.level_update = False
        self.level_time = Timer()
        self.level_peak = [0, 0]
        self.level = 0
        self.time_passed = 0
        self.level_meter_colour_mode = 3

        self.vis = 0  # visualiser mode actual
        self.vis_want = 2  # visualiser mode setting
        self.spec = None
        self.s_spec = [0] * 24
        self.s4_spec = [0] * 45
        self.update_spec = 0

        # self.spec_rect = [0, 5, 80, 20]  # x = 72 + 24 - 6 - 10

        self.spec4_array = []

        self.draw_spec4 = False

        self.combo_mode = False
        self.showcase_mode = False
        self.display_time_mode = 0

        self.pl_text_real_height = 12
        self.pl_title_real_height = 11

        self.row_extra = 0
        self.test = False
        self.light_mode = False

        self.level_2_click = False
        self.universal_y_text_offset = 0

        self.star_text_y_offset = 0
        if system == "windows":
            self.star_text_y_offset = -2

        self.set_bar = True
        self.set_mode = False
        self.set_hold = -1
        self.set_label_hold = -1
        self.set_label_point = (0, 0)
        self.set_point = 0
        self.set_old = 0
        self.pl_st = [['Artist', 156, False], ['Title', 188, False], ['T', 40, True], ['Album', 153, False],
                      ['P', 28, True], ['Starline', 86, True], ['Date', 48, True], ['Codec', 55, True],
                      ['Time', 53, True]]

        for item in self.pl_st:
            item[1] = item[1] * self.scale

        self.offset_extra = 0

        self.playlist_row_height = 16
        self.playlist_text_offset = 0
        self.row_font_size = 13
        self.compact_bar = False
        self.tracklist_texture_rect = tracklist_texture_rect
        self.tracklist_texture = tracklist_texture

        self.trunk_end = "..."  # "…"
        self.temp_themes = {}
        self.theme_temp_current = -1

        self.pl_title_y_offset = 0
        self.pl_title_font_offset = -1

        self.playlist_box_d_click = -1

        self.gallery_show_text = True
        self.bb_show_art = False

        self.rename_folder_box = False

        self.present = False
        self.drag_source_position = (0, 0)
        self.drag_source_position_persist = (0, 0)
        self.album_tab_mode = False
        self.main_art_box = (0, 0, 10, 10)
        self.gall_tab_enter = False

        self.lightning_copy = False

        self.gallery_animate_highlight_on = 0

        self.seek_cur_show = False
        self.cur_time = "0"
        self.force_showcase_index = -1

        self.frame_callback_list = []

        self.playlist_left = None
        self.image_downloading = False
        self.tc_cancel = False
        self.im_cancel = False
        self.force_search = False

        self.pl_pulse = False

        self.view_name = "S"
        self.restart_album_mode = False

        self.dtm3_index = -1
        self.dtm3_cum = 0
        self.dtm3_total = 0
        self.previous_playlist_id = ""

        self.star_mode = "line"
        self.heart_fields = []
        self.show_ratings = False

        self.web_running = False

        self.rsp = True
        if phone:
            self.rsp = False
        self.rspw = round(300 * self.scale)
        self.lsp = False
        self.lspw = round(220 * self.scale)
        self.plw = None

        self.pref_rspw = 300

        self.pref_gallery_w = 600

        self.artist_info_panel = False

        self.show_hearts = True

        self.cursor_is = 0
        self.cursor_want = 0
        # 0 standard
        # 1 drag horizontal
        # 2 text
        # 3 hand

        self.power_bar = None
        self.gallery_scroll_field_left = 1
        self.combo_was_album = False

        self.gallery_positions = {}

        self.remember_library_mode = False

        self.first_in_grid = None

        self.art_aspect_ratio = 1
        self.art_drawn_rect = None
        self.art_unlock_ratio = False
        self.art_max_ratio_lock = 1
        self.side_bar_drag_source = 0
        self.side_bar_drag_original = 0

        self.scroll_direction = 0
        self.add_music_folder_ready = False

        self.playlist_current_visible_tracks = 0
        self.playlist_current_visible_tracks_id = 0

        self.theme_name = ""
        self.rename_playlist_box = False
        self.queue_frame_draw = None  # Set when need draw frame later

        self.mode = 1

        self.save_position = [0, 0]

        self.draw_vis4_top = False
        # self.vis_4_colour = [0,0,0,255]
        self.vis_4_colour = None

        self.layer_focus = 0
        self.tab_menu_pl = 0

        self.tool_tip_lock_off_f = False
        self.tool_tip_lock_off_b = False

        self.auto_play_import = False

        self.transcoding_batch_total = 0
        self.transcoding_bach_done = 0

        self.seek_bar_rect = (0, 0, 0, 0)
        self.volume_bar_rect = (0, 0, 0, 0)

        self.mini_mode_return_maximized = False

        self.opened_config_file = False

        self.notify_main_id = None

        self.halt_image_rendering = False
        self.generating_chart = False

        self.top_bar_mode2 = False
        self.mode_toast_text = ""

        self.rescale()
        # self.smooth_scrolling = False

        self.compact_artist_list = False

        self.rsp_full_lock = False

        self.album_scroll_px = album_v_slide_value
        self.queue_toast_plural = False
        self.reload_theme = False
        self.theme_number = 0
        self.toast_queue_object = None
        self.toast_love_object = None
        self.toast_love_added = True

        self.force_side_on_drag = False
        self.last_left_panel_mode = "playlist"
        self.showing_l_panel = False

        self.downloading_bass = False
        self.d_click_ref = -1

        self.max_window_tex = max_window_tex
        self.main_texture = main_texture
        self.main_texture_overlay_temp = main_texture_overlay_temp

        self.preview_artist = ""
        self.preview_artist_location = (0, 0)
        self.preview_artist_loading = ""
        self.mouse_left_window = False

        self.rendered_playlist_position = 0

        self.console = console
        self.show_album_ratings = False
        self.gen_code_errors = False

        self.regen_single = -1
        self.regen_single_id = None

        self.tracklist_bg_is_light = False
        self.clear_image_cache_next = 0

        self.column_d_click_timer = Timer(10)
        self.column_d_click_on = -1
        self.column_sort_ani_timer = Timer(10)
        self.column_sort_down_icon = asset_loader("sort-down.png", True)
        self.column_sort_up_icon = asset_loader("sort-up.png", True)
        self.column_sort_ani_direction = 1
        self.column_sort_ani_x = 0

        self.restore_showcase_view = False
        self.restore_radio_view = False

        self.tracklist_center_mode = False
        self.tracklist_inset_left = 0
        self.tracklist_inset_width = 0
        self.tracklist_highlight_width = 0
        self.tracklist_highlight_left = 0

        self.hide_tracklist_in_gallery = False

        self.saved_prime_tab = 0
        self.saved_prime_direction = 0

        self.stop_sync = False
        self.sync_progress = ""
        self.sync_speed = ""

        self.bar_hover_timer = Timer()

        self.level_decay_timer = Timer()

        self.showed_title = False

        self.to_get = 0
        self.to_got = 0
        self.switch_showcase_off = False

        self.backend_reloading = False

        self.spot_info_icon = asset_loader("spot-info.png", True)
        self.tray_active = False
        self.buffering = False
        self.buffering_text = ""

        self.update_on_drag = False
        self.pl_update_on_drag = False
        self.drop_playlist_target = 0
        self.discord_status = "Standby"
        self.mouse_unknown = False
        self.macstyle = prefs.macstyle
        if macos or detect_macstyle:
            self.macstyle = True
        self.radio_view = False
        self.window_size = window_size
        self.box_over = False
        self.suggest_clean_db = False
        self.style_worker_timer = Timer()

        self.shuffle_was_showcase = False
        self.shuffle_was_random = True
        self.shuffle_was_repeat = False

        self.was_radio = False
        self.fullscreen = False
        self.mouse_in_window = True

        self.write_tag_in_progress = False
        self.tag_write_count = 0
        # self.text_input_request = False
        # self.text_input_active = False
        self.center_blur_pixel = (0, 0, 0)


gui = GuiVar()


def toast(text):
    gui.mode_toast_text = text
    toast_mode_timer.set()
    gui.frame_callback_list.append(TestTimer(1.5))


def set_artist_preview(path, artist, x, y):
    m = min(round(500 * gui.scale), window_size[1] - (gui.panelY + gui.panelBY + 50 * gui.scale))
    artist_preview_render.load(path, box_size=(m, m))
    artist_preview_render.show = True
    ah = artist_preview_render.size[1]
    ay = round(y) - (ah // 2)
    if ay < gui.panelY + 20 * gui.scale:
        ay = gui.panelY + round(20 * gui.scale)
    if ay + ah > window_size[1] - (gui.panelBY + 5 * gui.scale):
        ay = window_size[1] - (gui.panelBY + ah + round(5 * gui.scale))
    gui.preview_artist = artist
    gui.preview_artist_location = (x + 15 * gui.scale,
                                   ay)


def get_artist_preview(artist, x, y):
    # show_message(_("Loading artist image..."))

    gui.preview_artist_loading = artist
    artist_info_box.get_data(artist, force_dl=True)
    path = artist_info_box.get_data(artist, get_img_path=True)
    if not path:
        show_message(_("No artist image found."))
        if not prefs.enable_fanart_artist and not verify_discogs():
            show_message(_("No artist image found."), _("No providers are enabled in settings!"), mode='warning')
        gui.preview_artist_loading = ""
        return
    set_artist_preview(path, artist, x, y)
    gui.message_box = False
    gui.preview_artist_loading = ""


def set_drag_source():
    gui.drag_source_position = tuple(click_location)
    gui.drag_source_position_persist = tuple(click_location)


# Functions for reading and setting play counts
class StarStore:

    def __init__(self):

        self.db = {}

    def key(self, track_id):

        track_object = pctl.master_library[track_id]
        return track_object.artist, track_object.title, track_object.filename

    def object_key(self, track):

        return track.artist, track.title, track.filename

    # Increments the play time
    def add(self, index, value):

        track_object = pctl.master_library[index]

        if after_scan:
            if track_object in after_scan:
                return

        key = track_object.artist, track_object.title, track_object.filename

        if key in self.db:
            self.db[key][0] += value
            if value < 0 and self.db[key][0] < 0:
                self.db[key][0] = 0
        else:
            self.db[key] = [value, "", 0, 0]  # Playtime in s, flags, rating, love timestamp

    # Returns the track play time
    def get(self, index):
        if index < 0:
            return 0
        return self.db.get(self.key(index), (0,))[0]

    # Returns the track user rating
    def get_rating(self, index):
        key = self.key(index)
        if key in self.db:
            # self.db[key]
            return self.db[key][2]
        return 0

    # Sets the track user rating
    def set_rating(self, index, value, write=False):
        key = self.key(index)
        if key not in self.db:
            self.db[key] = self.new_object()
        self.db[key][2] = value

        tr = pctl.g(index)
        if tr.file_ext == "SUB":
            self.db[key][2] = math.ceil(value / 2) * 2
            shooter(subsonic.set_rating, (tr, value))

        if prefs.write_ratings and write:
            print("Writing rating..")
            assert value <= 10
            assert value >= 0

            if tr.file_ext == "OGG" or tr.file_ext == "OPUS":
                tag = mutagen.oggvorbis.OggVorbis(tr.fullpath)
                if value == 0:
                    if "FMPS_RATING" in tag:
                        del tag["FMPS_RATING"]
                        tag.save()
                else:
                    tag["FMPS_RATING"] = ['{:.2f}'.format(value / 10)]
                    tag.save()

            elif tr.file_ext == "MP3":
                tag = mutagen.id3.ID3(tr.fullpath)

                # if True:
                #     if value == 0:
                #         tag.delall("POPM")
                #     else:
                #         p_rating = 0
                #
                #     tag.add(mutagen.id3.POPM(email="Windows Media Player 9 Series", rating=int))

                if value == 0:
                    changed = False
                    frames = tag.getall("TXXX")
                    for i in reversed(range(len(frames))):
                        if frames[i].desc.lower() == "fmps_rating":
                            changed = True
                    if changed:
                        tag.delall("TXXX:FMPS_RATING")
                        tag.save()
                else:
                    changed = False
                    frames = tag.getall("TXXX")
                    for i in reversed(range(len(frames))):
                        if frames[i].desc.lower() == "fmps_rating":
                            frames[i].text = '{:.2f}'.format(value / 10)
                            changed = True
                    if not changed:
                        tag.add(mutagen.id3.TXXX(encoding=mutagen.id3.Encoding.UTF8, text='{:.2f}'.format(value / 10),
                                                 desc="FMPS_RATING"))
                    tag.save()

            elif tr.file_ext == "FLAC":
                audio = mutagen.flac.FLAC(tr.fullpath)
                tags = audio.tags
                if value == 0:
                    if "FMPS_Rating" in tags:
                        del tags["FMPS_Rating"]
                        audio.save()
                else:
                    tags["FMPS_Rating"] = '{:.2f}'.format(value / 10)
                    audio.save()

            tr.misc["FMPS_Rating"] = float(value / 10)
            if value == 0:
                del tr.misc["FMPS_Rating"]

    def new_object(self):
        return [0, "", 0, 0]

    def get_by_object(self, track):

        return self.db.get(self.object_key(track), (0,))[0]

    def get_total(self):

        return sum(item[0] for item in self.db.values())

    def full_get(self, index):
        return self.db.get(self.key(index))

    def remove(self, index):
        key = self.key(index)
        if key in self.db:
            del self.db[key]

    def insert(self, index, object):
        key = self.key(index)
        self.db[key] = object

    def merge(self, index, object):
        if object is None or object == self.new_object():
            return
        key = self.key(index)
        if key not in self.db:
            self.db[key] = object
        else:
            self.db[key][0] += object[0]
            self.db[key][2] = object[2]
            for cha in object[1]:
                if cha not in self.db[key][1]:
                    self.db[key][1] += cha


star_store = StarStore()


class AlbumStarStore:

    def __init__(self):
        self.db = {}

    def get_key(self, track_object):
        artist = track_object.album_artist
        if not artist:
            artist = track_object.artist
        return artist + ":" + track_object.album

    def get_rating(self, track_object):
        return self.db.get(self.get_key(track_object), 0)

    def set_rating(self, track_object, rating):
        self.db[self.get_key(track_object)] = rating
        if track_object.file_ext == "SUB":
            self.db[self.get_key(track_object)] = math.ceil(rating / 2) * 2
            subsonic.set_album_rating(track_object, rating)

    def set_rating_artist_title(self, artist, album, rating):
        self.db[artist + ":" + album] = rating

    def get_rating_artist_title(self, artist, album):
        return self.db.get(artist + ":" + album, 0)


album_star_store = AlbumStarStore()


class Fonts:  # Used to hold font sizes (I forget to use this)

    def __init__(self):
        self.tabs = 211
        self.panel_title = 213

        self.side_panel_line1 = 214
        self.side_panel_line2 = 13

        self.bottom_panel_time = 212

        # if system == 'windows':
        #     self.bottom_panel_time = 12  # The Arial bold font is too big so just leaving this as normal. (lazy)


fonts = Fonts()


class Input:  # Used to keep track of button states (or should be)

    def __init__(self):
        self.mouse_click = False
        # self.right_click = False
        self.level_2_enter = False
        self.key_return_press = False
        self.key_tab_press = False
        self.backspace_press = 0

        self.media_key = ""

    def m_key_play(self):
        self.media_key = "Play"
        gui.update += 1

    def m_key_pause(self):
        self.media_key = "Pause"
        gui.update += 1

    def m_key_stop(self):
        self.media_key = "Stop"
        gui.update += 1

    def m_key_next(self):
        self.media_key = "Next"
        gui.update += 1

    def m_key_previous(self):
        self.media_key = "Previous"
        gui.update += 1


inp = Input()


class KeyMap:

    def __init__(self):

        self.hits = []  # The keys hit this frame
        self.maps = {}  # Loaded from input.txt

    def load(self):

        path = os.path.join(config_directory, "input.txt")
        with open(path, encoding="utf_8") as f:
            content = f.read().splitlines()
            for p in content:
                if len(p) == 0 or len(p) > 100:
                    continue
                if p[0] == " " or p[0] == "#":
                    continue

                items = p.split()
                if 1 < len(items) < 5:
                    function = items[0]

                    if items[1] in ("MB4", "MB5"):
                        key = items[1]
                    else:
                        if prefs.use_scancodes:
                            key = SDL_GetScancodeFromName(items[1].encode())
                        else:
                            key = SDL_GetKeyFromName(items[1].encode())
                        if key == 0:
                            continue

                    mod = []

                    if len(items) > 2:
                        mod.append(items[2].lower())
                    if len(items) > 3:
                        mod.append(items[3].lower())

                    if function in self.maps:
                        self.maps[function].append((key, mod))
                    else:
                        self.maps[function] = [(key, mod)]

    def test(self, function):

        if not self.hits:
            return False
        if function not in self.maps:
            return False

        for code, mod in self.maps[function]:

            if code in self.hits:

                ctrl = (key_ctrl_down or key_rctrl_down) * 1
                shift = (key_shift_down or key_shiftr_down) * 10
                alt = (key_lalt or key_ralt) * 100

                if ctrl + shift + alt == ("ctrl" in mod) * 1 + ("shift" in mod) * 10 + ("alt" in mod) * 100:
                    return True

        return False


keymaps = KeyMap()


def update_set():  # This is used to scale columns when windows is resized or items added/removed

    wid = gui.plw - round(16 * gui.scale)
    if gui.tracklist_center_mode:
        wid = gui.tracklist_highlight_width - round(16 * gui.scale)

    total = 0
    for item in gui.pl_st:
        if item[2] is False:
            total += item[1]
        else:
            wid -= item[1]

    if wid <= 75:
        wid = 75

    for i in range(len(gui.pl_st)):
        if gui.pl_st[i][2] is False and total:
            gui.pl_st[i][1] = int(round((gui.pl_st[i][1] / total) * wid))  # + 1


def auto_size_columns():
    fixed_n = 0

    wid = gui.plw - round(16 * gui.scale)
    if gui.tracklist_center_mode:
        wid = gui.tracklist_highlight_width - round(16 * gui.scale)

    total = wid
    for item in gui.pl_st:

        if item[2]:
            fixed_n += 1

        if item[0] == "Lyrics":
            item[1] = round(50 * gui.scale)
            total -= round(50 * gui.scale)

        if item[0] == "Rating":
            item[1] = round(80 * gui.scale)
            total -= round(80 * gui.scale)

        if item[0] == "Starline":
            item[1] = round(78 * gui.scale)
            total -= round(78 * gui.scale)

        if item[0] == "Time":
            item[1] = round(58 * gui.scale)
            total -= round(58 * gui.scale)

        if item[0] == "Codec":
            item[1] = round(58 * gui.scale)
            total -= round(58 * gui.scale)

        if item[0] == "P" or item[0] == "S" or item[0] == "#":
            item[1] = round(32 * gui.scale)
            total -= round(32 * gui.scale)

        if item[0] == "Date":
            item[1] = round(55 * gui.scale)
            total -= round(55 * gui.scale)

        if item[0] == "Bitrate":
            item[1] = round(67 * gui.scale)
            total -= round(67 * gui.scale)

        if item[0] == "❤":
            item[1] = round(27 * gui.scale)
            total -= round(27 * gui.scale)

    vr = len(gui.pl_st) - fixed_n

    if vr > 0 and total > 50:

        space = round(total / vr)

        for item in gui.pl_st:
            if not item[2]:
                item[1] = space

    gui.pl_update += 1
    update_set()


class ColoursClass:  # Used to store colour values for UI elements. These are changed for themes.
    def grey(self, value):
        return [value, value, value, 255]

    def alpha_grey(self, value):
        return [255, 255, 255, value]

    def grey_blend_bg(self, value):
        return alpha_blend((255, 255, 255, value), self.box_background)

    def __init__(self):

        self.deco = None
        self.column_colours = {}
        self.column_colours_playing = {}

        self.last_album = ""
        self.link_text = [100, 200, 252, 255]

        self.tb_line = self.grey(21)  # not currently used
        self.art_box = self.grey(24)

        self.volume_bar_background = self.grey(30)
        self.volume_bar_fill = self.grey(125)
        self.seek_bar_background = self.grey(30)
        self.seek_bar_fill = self.grey(80)

        self.tab_text_active = self.grey(230)
        self.tab_text = self.grey(215)
        self.tab_background = self.grey(25)
        self.tab_highlight = self.grey(40)
        self.tab_background_active = self.grey(45)

        self.title_text = [190, 190, 190, 255]
        self.index_text = self.grey(70)
        self.time_text = self.grey(180)
        self.artist_text = [195, 255, 104, 255]
        self.album_text = [245, 240, 90, 255]

        self.index_playing = self.grey(190)
        self.artist_playing = [195, 255, 104, 255]
        self.album_playing = [245, 240, 90, 255]
        self.title_playing = self.grey(230)

        self.time_playing = [180, 194, 107, 255]

        self.playlist_text_missing = self.grey(85)
        self.bar_time = self.grey(70)

        self.top_panel_background = self.grey(15)
        self.status_text_over = rgb_add_hls(self.top_panel_background, 0, 0.83, 0)
        self.status_text_normal = rgb_add_hls(self.top_panel_background, 0, 0.30, -0.15)

        self.side_panel_background = self.grey(18)
        self.gallery_background = self.side_panel_background
        self.playlist_panel_background = self.grey(21)
        self.bottom_panel_colour = self.grey(15)

        self.row_playing_highlight = [255, 255, 255, 4]
        self.row_select_highlight = [255, 255, 255, 5]

        self.side_bar_line1 = self.grey(230)
        self.side_bar_line2 = self.grey(210)

        self.mode_button_off = self.grey(50)
        self.mode_button_over = self.grey(200)
        self.mode_button_active = self.grey(190)

        self.media_buttons_over = self.grey(220)
        self.media_buttons_active = self.grey(220)
        self.media_buttons_off = self.grey(55)

        self.star_line = [100, 100, 100, 255]
        self.star_line_playing = None
        self.folder_title = [130, 130, 130, 255]
        self.folder_line = [40, 40, 40, 255]

        self.scroll_colour = [45, 45, 45, 255]

        self.level_1_bg = [0, 30, 0, 255]
        self.level_2_bg = [30, 30, 0, 255]
        self.level_3_bg = [30, 0, 0, 255]
        self.level_green = [20, 120, 20, 255]
        self.level_red = [190, 30, 30, 255]
        self.level_yellow = [135, 135, 30, 255]

        self.vis_colour = self.grey(200)
        self.vis_bg = [0, 0, 0, 255]

        self.menu_background = None  # self.grey(12)
        self.menu_highlight_background = None
        self.menu_text = [230, 230, 230, 255]
        self.menu_text_disabled = self.grey(50)
        self.menu_icons = [255, 255, 255, 25]
        self.menu_tab = self.grey(30)

        self.gallery_highlight = self.artist_playing

        self.status_info_text = [245, 205, 0, 255]
        self.streaming_text = [220, 75, 60, 255]
        self.lyrics = self.grey(245)

        self.corner_button = [255, 255, 255, 50]  # [60, 60, 60, 255]
        self.corner_button_active = [255, 255, 255, 230]  # [230, 230, 230, 255]

        self.window_buttons_bg = [0, 0, 0, 50]
        self.window_buttons_bg_over = [255, 255, 255, 10]  # [80, 80, 80, 120]
        self.window_buttons_icon_over = (255, 255, 255, 60)
        self.window_button_icon_off = (255, 255, 255, 40)
        self.window_button_x_on = None
        self.window_button_x_off = self.window_button_icon_off

        self.message_box_bg = self.grey(0)
        self.message_box_text = self.grey(230)

        self.sys_title = self.grey(220)
        self.sys_title_strong = self.grey(230)
        self.lm = False

        self.pluse_colour = [244, 212, 66, 255]

        self.mini_mode_background = [19, 19, 19, 255]
        self.mini_mode_border = [45, 45, 45, 255]
        self.mini_mode_text_1 = [255, 255, 255, 240]
        self.mini_mode_text_2 = [255, 255, 255, 77]

        self.queue_drag_indicator_colour = [200, 50, 240, 255]

        self.playlist_box_background = self.side_panel_background

        self.bar_title_text = None

        self.corner_icon = [40, 40, 40, 255]
        self.queue_background = None  # self.side_panel_background #self.grey(18) # 18
        self.queue_card_background = self.grey(23)

        self.column_bar_background = [30, 30, 30, 255]
        self.column_grip = [255, 255, 255, 14]
        self.column_bar_text = [240, 240, 240, 255]

        self.window_frame = [30, 30, 30, 255]

        self.box_background = [16, 16, 16, 255]
        self.box_border = rgb_add_hls(self.box_background, 0, 0.17, 0)
        self.box_text_border = rgb_add_hls(self.box_background, 0, 0.1, 0)
        self.box_text_label = rgb_add_hls(self.box_background, 0, 0.32, -0.1)
        self.box_sub_highlight = rgb_add_hls(self.box_background, 0, 0.07, -0.05)  # 58, 47, 85
        self.box_check_border = [255, 255, 255, 18]

        self.box_title_text = self.grey(245)
        self.box_text = self.grey(240)
        self.box_sub_text = self.grey_blend_bg(225)
        self.box_input_text = self.grey(225)
        self.box_button_text_highlight = self.grey(250)
        self.box_button_text = self.grey(225)
        self.box_button_background = alpha_blend([255, 255, 255, 11], self.box_background)
        self.box_thumb_background = None
        self.box_button_background_highlight = alpha_blend([255, 255, 255, 20], self.box_background)

        self.artist_bio_background = [27, 27, 27, 255]
        self.artist_bio_text = [230, 230, 230, 255]

    def post_config(self):

        if self.box_thumb_background is None:
            self.box_thumb_background = alpha_mod(self.box_button_background, 175)

        # Pre calculate alpha blend for spec background
        self.vis_bg[0] = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background[0])
        self.vis_bg[1] = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background[1])
        self.vis_bg[2] = int(0.05 * 255 + (1 - 0.05) * self.top_panel_background[2])

        self.message_box_bg = self.box_background
        self.sys_tab_bg = self.tab_background
        self.sys_tab_hl = self.tab_background_active
        self.toggle_box_on = self.folder_title
        self.toggle_box_on = [255, 150, 100, 255]
        self.toggle_box_on = self.artist_playing
        if colour_value(self.toggle_box_on) < 150:
            self.toggle_box_on = [160, 160, 160, 255]
        # self.time_sub = [255, 255, 255, 80]#alpha_blend([255, 255, 255, 80], self.bottom_panel_colour)

        self.time_sub = rgb_add_hls(self.bottom_panel_colour, 0, 0.29, 0)

        if test_lumi(colours.bottom_panel_colour) < 0.2:
            # self.time_sub = [0, 0, 0, 80]
            self.time_sub = rgb_add_hls(self.bottom_panel_colour, 0, -0.15, -0.3)
        elif test_lumi(colours.bottom_panel_colour) < 0.8:
            self.time_sub = [255, 255, 255, 135]
        # self.time_sub = self.mode_button_off

        if self.bar_title_text is None:
            self.bar_title_text = self.side_bar_line1

        self.gallery_artist_line = alpha_mod(self.side_bar_line2, 120)

        if self.menu_highlight_background is None:
            self.menu_highlight_background = [40, 40, 40, 255]

        if not self.queue_background:
            self.queue_background = self.side_panel_background

        if test_lumi(self.queue_background) > 0.8:
            self.queue_card_background = alpha_blend([255, 255, 255, 10], self.queue_background)

        if self.menu_background is None and not self.lm:
            self.menu_background = self.bottom_panel_colour

        self.message_box_text = self.box_text
        self.message_box_border = self.box_border

        if self.window_button_x_on is None:
            self.window_button_x_on = self.artist_playing

        if test_lumi(self.column_bar_background) < 0.4:
            self.column_bar_text = [40, 40, 40, 200]
            self.column_grip = [255, 255, 255, 20]

    def light_mode(self):

        self.lm = True
        self.star_line_playing = [255, 255, 255, 255]
        self.sys_tab_bg = self.grey(25)
        self.sys_tab_hl = self.grey(45)
        # self.box_background = self.grey(30)
        self.toggle_box_on = self.tab_background_active
        # if colour_value(self.tab_background_active) < 250:
        #    self.toggle_box_on = [255, 255, 255, 200]

        # self.time_sub = [0, 0, 0, 200]
        self.gallery_artist_line = self.grey(40)
        # self.bar_title_text = self.grey(30)
        self.status_text_normal = self.grey(70)
        self.status_text_over = self.grey(40)
        self.status_info_text = [40, 40, 40, 255]

        # self.bar_title_text = self.grey(255)
        self.vis_bg = [235, 235, 235, 255]
        # self.menu_background = [240, 240, 240, 250]
        # self.menu_text = self.grey(40)
        # self.menu_text_disabled = self.grey(180)
        # self.menu_highlight_background = [200, 200, 200, 250]
        if self.menu_background is None:
            self.menu_background = [15, 15, 15, 250]
        if not self.menu_icons:
            self.menu_icons = [0, 0, 0, 40]

        # self.menu_background = [40, 40, 40, 250]
        # self.menu_text = self.grey(220)
        # self.menu_text_disabled = self.grey(120)
        # self.menu_highlight_background = [120, 80, 220, 250]

        self.corner_button = self.grey(160)
        self.corner_button_active = self.grey(35)
        # self.window_buttons_bg = [0, 0, 0, 5]
        self.message_box_bg = [245, 245, 245, 255]
        self.message_box_text = self.grey(20)
        self.message_box_border = self.grey(40)
        self.gallery_background = self.grey(230)
        self.gallery_artist_line = self.grey(40)
        self.pluse_colour = [212, 66, 244, 255]

        # view_box.off_colour = self.grey(200)


colours = ColoursClass()
colours.post_config()


def set_colour(colour):
    SDL_SetRenderDrawColor(renderer, colour[0], colour[1], colour[2], colour[3])


def get_themes(deco=False):
    themes = []  # full, name
    decos = {}
    direcs = [install_directory + '/theme']
    if user_directory != install_directory:
        direcs.append(user_directory + '/theme')

    def scan_folders(folders):
        for folder in folders:
            if not os.path.isdir(folder):
                continue
            paths = [os.path.join(folder, f) for f in os.listdir(folder)]
            for path in paths:
                if os.path.isfile(path):
                    if path[-7:] == '.ttheme':
                        themes.append((path, os.path.basename(path).split(".")[0]))
                    elif path[-6:] == '.tdeco':
                        decos[os.path.basename(path).split(".")[0]] = path
                elif os.path.isdir(path):
                    scan_folders([path])

    scan_folders(direcs)
    themes.sort()
    if deco:
        return decos
    return themes


# This is legacy. New settings are added straight to the save list (need to overhaul)
view_prefs = {

    'split-line': True,
    'update-title': False,
    'star-lines': False,
    'side-panel': True,
    'dim-art': False,
    'pl-follow': False,
    'scroll-enable': True
}


class TrackClass:  # This is the fundamental object/data structure of a track

    def __init__(self):
        self.index = 0
        self.subtrack = 0
        self.fullpath = ""
        self.filename = ""
        self.parent_folder_path = ""
        self.parent_folder_name = ""
        self.file_ext = ""
        self.size = 0
        self.modified_time = 0

        self.is_network = False
        self.url_key = ""
        self.art_url_key = ""

        self.artist = ""
        self.album_artist = ""
        self.title = ""
        self.composer = ""
        self.length = 0
        self.bitrate = 0
        self.samplerate = 0
        self.bit_depth = 0
        self.album = ""
        self.date = ""
        self.track_number = ""
        self.track_total = ""
        self.start_time = 0
        self.is_cue = False
        self.is_embed_cue = False
        self.cue_sheet = ""
        self.genre = ""
        self.found = True
        self.skips = 0
        self.comment = ""
        self.disc_number = ""
        self.disc_total = ""
        self.lyrics = ""

        self.lfm_friend_likes = set()
        self.lfm_scrobbles = 0
        self.misc = {}

def get_end_folder(direc):
    for w in range(len(direc)):
        if direc[-w - 1] == '\\' or direc[-w - 1] == '/':
            direc = direc[-w:]
            return direc
    return None
def set_path(nt, path):
    nt.fullpath = path.replace('\\', '/')
    nt.filename = os.path.basename(path)
    nt.parent_folder_path = os.path.dirname(path.replace('\\', '/'))
    nt.parent_folder_name = get_end_folder(os.path.dirname(path))
    nt.file_ext = os.path.splitext(os.path.basename(path))[1][1:].upper()

class LoadClass:  # Object for import track jobs (passed to worker thread)
    def __init__(self):
        self.target = ""
        self.playlist = 0  # Playlist UID
        self.tracks = []
        self.stage = 0
        self.playlist_position = None
        self.replace_stem = False
        self.notify = False
        self.play = False
        self.force_scan = False


# url_saves = []
rename_files_previous = ""
rename_folder_previous = ""
p_force_queue = []

reload_state = None


def show_message(line1, line2="", line3="", mode='info'):
    gui.message_box = True
    gui.message_text = line1
    gui.message_mode = mode
    gui.message_subtext = line2
    gui.message_subtext2 = line3
    message_box_min_timer.set()
    console.print("Message: " + line1)
    gui.update = 1


# -----------------------------------------------------
# STATE LOADING
# Loading of program data from previous run
import gc as gbc

gbc.disable()
ggc = 2

try:

    sp1 = user_directory + "/star.p"
    sp2 = user_directory + "/star.p.backup"

    s1 = 0
    s2 = 0

    if os.path.isfile(sp1):
        s1 = os.path.getsize(sp1)
    if os.path.isfile(sp2):
        s2 = os.path.getsize(sp2)
    to_load = sp1
    if s2 > s1:
        print("Loading backup star.p")
        to_load = sp2

    star_store.db = pickle.load(open(to_load, "rb"))

except:
    print('No existing star.p file')

try:
    album_star_store.db = pickle.load(open(user_directory + "/album-star.p", "rb"))

except:
    print('No existing album-star.p file')

try:
    if os.path.isfile(user_directory + "/lyrics_substitutions.json"):
        with open(user_directory + "/lyrics_substitutions.json", 'r') as f:
            prefs.lyrics_subs = json.load(f)
except:
    print("Error loading lyrics_substitutions.json")

perf_timer.set()

radio_playlists = [{"uid": uid_gen(), "name": "Default", "items": []}]

primary_stations = []
station = {
    'title': "SomaFM Groove Salad",
    "stream_url": "http://ice3.somafm.com/groovesalad-128-mp3",
    'country': 'USA',
    'website_url': 'http://somafm.com/groovesalad',
    'icon': 'https://somafm.com/logos/120/groovesalad120.png'
}
primary_stations.append(station)
station = {
    'title': "SomaFM PopTron",
    "stream_url": "http://ice3.somafm.com/poptron-128-mp3",
    'country': 'USA',
    'website_url': 'http://somafm.com/poptron/',
    'icon': 'https://somafm.com/logos/120/poptron120.jpg'
}
primary_stations.append(station)
station = {
    'title': "SomaFM Vaporwaves",
    "stream_url": "http://ice4.somafm.com/vaporwaves-128-mp3",
    'country': 'USA',
    'website_url': 'https://somafm.com/vaporwaves',
    'icon': 'https://somafm.com/img3/vaporwaves400.png'
}
primary_stations.append(station)

station = {
    'title': "DKFM Shoegaze Radio",
    "stream_url": "https://kathy.torontocast.com:2005/stream",
    'country': 'Canada',
    'website_url': 'https://decayfm.com',
    'icon': 'https://cdn-profiles.tunein.com/s193842/images/logod.png'
}
primary_stations.append(station)

for item in primary_stations:
    radio_playlists[0]["items"].append(item)

radio_playlist_viewing = 0

pump = True


def pumper():
    if macos:
        return
    while pump:
        time.sleep(0.005)
        SDL_PumpEvents()


shoot_pump = threading.Thread(target=pumper)
shoot_pump.daemon = True
shoot_pump.start()

for t in range(2):
    try:

        # if os.path.isfile(user_directory + "/state.p.backup") and (
        #
        #     not os.path.isfile(user_directory + "/state.p") or
        #     os.path.getsize(user_directory + "/state.p") < 100
        # )
        if t == 0:
            state_file = open(user_directory + "/state.p", "rb")
        if t == 1:
            state_file = open(user_directory + "/state.p.backup", "rb")

        # def tt():
        #     while True:
        #         print(state_file.tell())
        #         time.sleep(0.01)
        # shooter(tt)

        save = pickle.load(state_file)

        if t == 1:
            print("Using backup state")

        if save[63] is not None:
            prefs.ui_scale = save[63]
            # prefs.ui_scale = 1.3
            # gui.__init__()

        if save[0] is not None:
            master_library = save[0]
        master_count = save[1]
        playlist_playing = save[2]
        playlist_active = save[3]
        playlist_view_position = save[4]
        multi_playlist = save[5]
        volume = save[6]
        QUE = save[7]
        playing_in_queue = save[8]
        default_playlist = save[9]
        # playlist_playing = save[10]
        # cue_list = save[11]
        # radio_field_text = save[12]
        theme = save[13]
        folder_image_offsets = save[14]
        # lfm_username = save[15]
        # lfm_hash = save[16]
        db_version = save[17]
        view_prefs = save[18]
        # window_size = save[19]
        gui.save_size = copy.copy(save[19])
        gui.rspw = save[20]
        # savetime = save[21]
        gui.vis_want = save[22]
        selected_in_playlist = save[23]
        if save[24] is not None:
            album_mode_art_size = save[24]
        if save[25] is not None:
            draw_border = save[25]
        if save[26] is not None:
            prefs.enable_web = save[26]
        if save[27] is not None:
            prefs.allow_remote = save[27]
        if save[28] is not None:
            prefs.expose_web = save[28]
        if save[29] is not None:
            prefs.enable_transcode = save[29]
        if save[30] is not None:
            prefs.show_rym = save[30]
        # if save[31] is not None:
        #     combo_mode_art_size = save[31]
        if save[32] is not None:
            gui.maximized = save[32]
        if save[33] is not None:
            prefs.prefer_bottom_title = save[33]
        if save[34] is not None:
            gui.display_time_mode = save[34]
        # if save[35] is not None:
        #     prefs.transcode_mode = save[35]
        if save[36] is not None:
            prefs.transcode_codec = save[36]
        if save[37] is not None:
            prefs.transcode_bitrate = save[37]
        # if save[38] is not None:
        #     prefs.line_style = save[38]
        # if save[39] is not None:
        #     prefs.cache_gallery = save[39]
        if save[40] is not None:
            prefs.playlist_font_size = save[40]
        if save[41] is not None:
            prefs.use_title = save[41]
        if save[42] is not None:
            gui.pl_st = save[42]
        # if save[43] is not None:
        #     gui.set_mode = save[43]
        #     gui.set_bar = gui.set_mode
        if save[45] is not None:
            prefs.playlist_row_height = save[45]
        if save[46] is not None:
            prefs.show_wiki = save[46]
        if save[47] is not None:
            prefs.auto_extract = save[47]
        if save[48] is not None:
            prefs.colour_from_image = save[48]
        if save[49] is not None:
            gui.set_bar = save[49]
        if save[50] is not None:
            gui.gallery_show_text = save[50]
        if save[51] is not None:
            gui.bb_show_art = save[51]
        # if save[52] is not None:
        #     gui.show_stars = save[52]
        if save[53] is not None:
            prefs.auto_lfm = save[53]
        if save[54] is not None:
            prefs.scrobble_mark = save[54]
        if save[55] is not None:
            prefs.replay_gain = save[55]
        # if save[56] is not None:
        #     prefs.radio_page_lyrics = save[56]
        if save[57] is not None:
            prefs.show_gimage = save[57]
        if save[58] is not None:
            prefs.end_setting = save[58]
        if save[59] is not None:
            prefs.show_gen = save[59]
        # if save[60] is not None:
        #     url_saves = save[60]
        if save[61] is not None:
            prefs.auto_del_zip = save[61]
        if save[62] is not None:
            gui.level_meter_colour_mode = save[62]
        if save[64] is not None:
            prefs.show_lyrics_side = save[64]
        # if save[65] is not None:
        #     prefs.last_device = save[65]
        if save[66] is not None:
            gui.restart_album_mode = save[66]
        if save[67] is not None:
            album_playlist_width = save[67]
        if save[68] is not None:
            prefs.transcode_opus_as = save[68]
        if save[69] is not None:
            gui.star_mode = save[69]
        if save[70] is not None:
            gui.rsp = save[70]
        if save[71] is not None:
            gui.lsp = save[71]
        if save[72] is not None:
            gui.rspw = save[72]
        if save[73] is not None:
            gui.pref_gallery_w = save[73]
        if save[74] is not None:
            gui.pref_rspw = save[74]
        if save[75] is not None:
            gui.show_hearts = save[75]
        if save[76] is not None:
            prefs.monitor_downloads = save[76]
        if save[77] is not None:
            gui.artist_info_panel = save[77]
        if save[78] is not None:
            prefs.extract_to_music = save[78]
        if save[79] is not None:
            prefs.enable_lb = save[79]
        # if save[80] is not None:
        #     prefs.lb_token = save[80]
        #     if prefs.lb_token is None:
        #         prefs.lb_token = ""
        if save[81] is not None:
            rename_files_previous = save[81]
        if save[82] is not None:
            rename_folder_previous = save[82]
        if save[83] is not None:
            prefs.use_jump_crossfade = save[83]
        if save[84] is not None:
            prefs.use_transition_crossfade = save[84]
        if save[85] is not None:
            prefs.show_notifications = save[85]
        # if save[86] is not None:
        #     prefs.true_shuffle = save[86]
        if save[87] is not None:
            gui.remember_library_mode = save[87]
        # if save[88] is not None:
        #     prefs.show_queue = save[88]
        # if save[89] is not None:
        #     prefs.show_transfer = save[89]
        if save[90] is not None:
            p_force_queue = save[90]
        if save[91] is not None:
            prefs.use_pause_fade = save[91]
        if save[92] is not None:
            prefs.append_total_time = save[92]
        if save[93] is not None:
            prefs.backend = save[93]  # moved to config file
        if save[94] is not None:
            prefs.album_shuffle_mode = save[94]
        if save[95] is not None:
            prefs.album_repeat_mode = save[95]
        # if save[96] is not None:
        #     prefs.finish_current = save[96]
        if save[97] is not None:
            reload_state = save[97]
        # if save[98] is not None:
        #     prefs.reload_play_state = save[98]
        if save[99] is not None:
            prefs.last_fm_token = save[99]
        if save[100] is not None:
            prefs.last_fm_username = save[100]
        # if save[101] is not None:
        #     prefs.use_card_style = save[101]
        # if save[102] is not None:
        #     prefs.auto_lyrics = save[102]
        if save[103] is not None:
            prefs.auto_lyrics_checked = save[103]
        if save[104] is not None:
            prefs.show_side_art = save[104]
        if save[105] is not None:
            prefs.window_opacity = save[105]
        if save[106] is not None:
            prefs.gallery_single_click = save[106]
        if save[107] is not None:
            prefs.tabs_on_top = save[107]
        if save[108] is not None:
            prefs.showcase_vis = save[108]
        if save[109] is not None:
            prefs.spec2_colour_mode = save[109]
        # if save[110] is not None:
        #     prefs.device_buffer = save[110]
        if save[111] is not None:
            prefs.use_eq = save[111]
        if save[112] is not None:
            prefs.eq = save[112]
        if save[113] is not None:
            prefs.bio_large = save[113]
        if save[114] is not None:
            prefs.discord_show = save[114]
        if save[115] is not None:
            prefs.min_to_tray = save[115]
        if save[116] is not None:
            prefs.guitar_chords = save[116]
        if save[117] is not None:
            prefs.playback_follow_cursor = save[117]
        if save[118] is not None:
            prefs.art_bg = save[118]
        if save[119] is not None:
            prefs.random_mode = save[119]
        if save[120] is not None:
            prefs.repeat_mode = save[120]
        if save[121] is not None:
            prefs.art_bg_stronger = save[121]
        if save[122] is not None:
            prefs.art_bg_always_blur = save[122]
        if save[123] is not None:
            prefs.failed_artists = save[123]
        if save[124] is not None:
            prefs.artist_list = save[124]
        if save[125] is not None:
            prefs.auto_sort = save[125]
        if save[126] is not None:
            prefs.lyrics_enables = save[126]
        if save[127] is not None:
            prefs.fanart_notify = save[127]
        if save[128] is not None:
            prefs.bg_showcase_only = save[128]
        if save[129] is not None:
            prefs.discogs_pat = save[129]
        if save[130] is not None:
            prefs.mini_mode_mode = save[130]
        if save[131] is not None:
            after_scan = save[131]
        if save[132] is not None:
            gui.gallery_positions = save[132]
        if save[133] is not None:
            prefs.chart_bg = save[133]
        if save[134] is not None:
            prefs.left_panel_mode = save[134]
        if save[135] is not None:
            gui.last_left_panel_mode = save[135]
        # if save[136] is not None:
        #     prefs.gst_device = save[136]
        if save[137] is not None:
            search_string_cache = save[137]
        if save[138] is not None:
            search_dia_string_cache = save[138]
        if save[139] is not None:
            gen_codes = save[139]
        if save[140] is not None:
            gui.show_ratings = save[140]
        if save[141] is not None:
            gui.show_album_ratings = save[141]
        if save[142] is not None:
            prefs.radio_urls = save[142]
        if save[143] is not None:
            gui.restore_showcase_view = save[143]
        if save[144] is not None:
            gui.saved_prime_tab = save[144]
        if save[145] is not None:
            gui.saved_prime_direction = save[145]
        if save[146] is not None:
            prefs.sync_playlist = save[146]
        if save[147] is not None:
            prefs.spot_client = save[147]
        if save[148] is not None:
            prefs.spot_secret = save[148]
        if save[149] is not None:
            prefs.show_band = save[149]
        if save[150] is not None:
            prefs.download_playlist = save[150]
        if save[151] is not None:
            spot_cache_saved_albums = save[151]
        if save[152] is not None:
            prefs.auto_rec = save[152]
        if save[153] is not None:
            prefs.spotify_token = save[153]
        if save[154] is not None:
            prefs.use_libre_fm = save[154]
        if save[155] is not None:
            prefs.old_playlist_box_position = save[155]
        if save[156] is not None:
            prefs.artist_list_sort_mode = save[156]
        if save[157] is not None:
            prefs.phazor_device_selected = save[157]
        if save[158] is not None:
            prefs.failed_background_artists = save[158]
        if save[159] is not None:
            prefs.bg_flips = save[159]
        if save[160] is not None:
            prefs.tray_show_title = save[160]
        if save[161] is not None:
            prefs.artist_list_style = save[161]
        if save[162] is not None:
            ds = save[162]
            for d in ds:
                nt = TrackClass()
                nt.__dict__.update(d)
                master_library[d["index"]] = nt
        if save[163] is not None:
            prefs.premium = save[163]
        if save[164] is not None:
            gui.restore_radio_view = save[164]
        if save[165] is not None:
            radio_playlists = save[165]
        if save[166] is not None:
            radio_playlist_viewing = save[166]
        if save[167] is not None:
            prefs.radio_thumb_bans = save[167]
        if save[168] is not None:
            prefs.playlist_exports = save[168]
        if save[169] is not None:
            prefs.show_chromecast = save[169]
        if save[170] is not None:
            prefs.cache_list = save[170]
        if save[171] is not None:
            prefs.shuffle_lock = save[171]
        if save[172] is not None:
            prefs.album_shuffle_lock_mode = save[172]
        if save[173] is not None:
            gui.was_radio = save[173]
        if save[174] is not None:
            prefs.spot_username = save[174]
        if save[175] is not None:
            prefs.spot_password = save[175]
        if save[176] is not None:
            prefs.artist_list_threshold = save[176]
        if save[177] is not None:
            prefs.tray_theme = save[177]
        if save[178] is not None:
            prefs.row_title_format = save[178]
        if save[179] is not None:
            prefs.row_title_genre = save[179]
        if save[180] is not None:
            prefs.row_title_separator_type = save[180]
        if save[181] is not None:
            prefs.replay_preamp = save[181]
        if save[182] is not None:
            prefs.gallery_combine_disc = save[182]

        state_file.close()
        del save
        break

    except IndexError:
        break
    except:
        if os.path.isfile(user_directory + "/state.p"):
            print('Error loading save file')

core_timer.set()
print(f"Database loaded in {round(perf_timer.get(), 3)} seconds.")

perf_timer.set()
keys = set(master_library.keys())
for pl in multi_playlist:
    keys -= set(pl[2])
if len(keys) > 5000:
    gui.suggest_clean_db = True
# print(f"Database scanned in {round(perf_timer.get(), 3)} seconds.")

pump = False
shoot_pump.join()

# temporary
if window_size is None:
    window_size = window_default_size
    gui.rspw = 200


def track_number_process(line):
    line = str(line).split("/", 1)[0].lstrip("0")
    if prefs.dd_index and len(line) == 1:
        return "0" + line
    return line


def advance_theme():
    global theme

    theme += 1
    gui.reload_theme = True


def get_theme_number(name):
    if name == "Mindaro":
        return 0
    themes = get_themes()
    for i, theme in enumerate(themes):
        if theme[1] == name:
            return i + 1
    return 0


def get_theme_name(number):
    if number == 0:
        return 'Mindaro'
    number -= 1
    themes = get_themes()
    print((number, themes))
    if len(themes) > number:
        return themes[number][1]
    return ""


# Upgrading from older versions
if db_version > 0:

    if db_version <= 0.8:
        print("Updating database from version 0.8 to 0.9")
        for key, value in master_library.items():
            setattr(master_library[key], 'skips', 0)

    if db_version <= 0.9:
        print("Updating database from version 0.9 to 1.1")
        for key, value in master_library.items():
            setattr(master_library[key], 'comment', "")

    if db_version <= 1.1:
        print("Updating database from version 1.1 to 1.2")
        for key, value in master_library.items():
            setattr(master_library[key], 'album_artist', "")

    if db_version <= 1.2:
        print("Updating database to version 1.3")
        for key, value in master_library.items():
            setattr(master_library[key], 'disc_number', "")
            setattr(master_library[key], 'disc_total', "")

    if db_version <= 1.3:
        print("Updating database to version 1.4")
        for key, value in master_library.items():
            setattr(master_library[key], 'lyrics', "")
            setattr(master_library[key], 'track_total', "")
        show_message(
            "Upgrade complete. Note: New attributes such as disk number won't show for existing tracks (delete state.p to reset)")

    if db_version <= 1.4:
        print("Updating database to version 1.5")
        for playlist in multi_playlist:
            playlist.append(uid_gen())

    if db_version <= 1.5:
        print("Updating database to version 1.6")
        for i in range(len(multi_playlist)):
            if len(multi_playlist[i]) == 7:
                multi_playlist[i].append("")

    if db_version <= 1.6:
        print("Updating preferences to 1.7")
        # gui.show_stars = False
        if install_mode:
            # shutil.copy(install_directory + "/config.txt", user_directory)
            print("Rewrote user config file")

    if db_version <= 1.7:
        print("Updating database to version 1.8")
        if install_mode:
            print(".... Overwriting user config file")
            # shutil.copy(install_directory + "/config.txt", user_directory)

        try:
            print(".... Updating playtime database")

            old = star_store.db
            # perf_timer.set()
            old_total = sum(old.values())
            # print(perf_timer.get())
            print("Old total: ", end='')
            print(old_total)
            star_store.db = {}

            new = {}
            for track in master_library.values():
                key = track.title + track.filename
                if key in old:
                    n_value = [old[key], ""]
                    n_key = star_store.object_key(track)
                    star_store.db[n_key] = n_value

            print("New total: ", end='')
            diff = old_total - star_store.get_total()
            print(int(diff), end='')
            print(" Secconds could not be matched to tracks. Total playtime won't be affected")
            star_store.db[("", "", "LOST")] = [diff, ""]
            print("Upgrade Complete")
        except:
            print("Error upgrading database")
            show_message("Error loading old database, did the program not exit properly after updating? Oh well.")

    if db_version <= 1.8:
        print("Updating database to 1.9")
        for key, value in master_library.items():
            setattr(master_library[key], 'track_gain', None)
            setattr(master_library[key], 'album_gain', None)
        show_message("Upgrade complete. Run a tag rescan if you want enable ReplayGain")

    if db_version <= 1.9:
        print("Updating database to version 2.0")
        for key, value in master_library.items():
            setattr(master_library[key], 'modified_time', 0)
        show_message("Upgrade complete. New sorting option may require tag rescan.")

    if db_version <= 2.0:
        print("Updating database to version 2.1")
        for key, value in master_library.items():
            setattr(master_library[key], 'is_embed_cue', False)
            setattr(master_library[key], 'cue_sheet', "")
        show_message("Updated to v2.6.3")

    if db_version <= 2.1:
        print("Updating database to version 2.1")
        for key, value in master_library.items():
            setattr(master_library[key], 'lfm_friend_likes', set())

    if db_version <= 2.2:
        for i in range(len(multi_playlist)):
            if len(multi_playlist[i]) < 9:
                multi_playlist[i].append(True)

    if db_version <= 2.3:
        print("Updating database to version 2.4")
        for key, value in master_library.items():
            setattr(master_library[key], 'bit_depth', 0)

    if db_version <= 2.4:
        if theme > 0:
            theme += 1

    if db_version <= 2.5:
        print("Updating database to version 2.6")
        for key, value in master_library.items():
            setattr(master_library[key], 'is_network', False)
        # for i in range(len(multi_playlist)):
        #     if len(multi_playlist[i]) < 10:
        #         multi_playlist[i].append(False)

    if db_version <= 26:
        print("Updating database to version 27")
        for i in range(len(multi_playlist)):
            if len(multi_playlist[i]) == 9:
                multi_playlist[i].append(False)

    if db_version <= 27:
        print("Updating database to version 28")
        for i in range(len(multi_playlist)):
            if len(multi_playlist[i]) <= 10:
                multi_playlist[i].append("")

    if db_version <= 29:
        print("Updating database to version 30")
        for key, value in master_library.items():
            setattr(master_library[key], 'composer', "")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("global-search G Ctrl\n")
                f.write("cycle-theme-reverse\n")
                f.write("reload-theme F10\n")

        show_message("Welcome to v4.4.0. Run a tag rescan if you want enable Composer metadata.")

    if db_version <= 30:
        for i, item in enumerate(p_force_queue):
            try:
                assert item[6]
            except:
                p_force_queue[i].append(False)

    if db_version <= 31:

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("love-selected\n")
        gui.set_bar = True

    if db_version <= 32:
        if theme > 1:
            theme += 1

    if db_version <= 33:
        print("Update to db 34")
        for key, value in master_library.items():
            if not hasattr(master_library[key], 'misc'):
                setattr(master_library[key], 'misc', {})

    if db_version <= 34:
        print("Update to dv 35")
        # Moved to after config load

    if db_version <= 35:
        print("Updating database to version 36")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("toggle-show-art H Ctrl\n")

    if db_version <= 37:
        print("Updating database to version 38")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("toggle-console `\n")

    if db_version <= 38:
        print("Updating database to version 39")

        for key, value in star_store.db.items():
            print(value)
            if len(value) == 2:
                value.append(0)
                star_store.db[key] = value

    if db_version <= 39:
        print("Updating database to version 40")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            f = open(os.path.join(config_directory, "input.txt"), 'r')
            text = f.read()
            f.close()
            lines = text.splitlines()
            if "l ctrl" not in text.lower():
                f = open(os.path.join(config_directory, "input.txt"), 'w')
                for line in lines:
                    line = line.strip()
                    if line == "love-selected":
                        line = "love-selected L Ctrl"
                    f.write(line + "\n")
                f.close()

    if db_version <= 40:
        print("Updating database to version 41")
        old = copy.deepcopy(prefs.lyrics_enables)
        prefs.lyrics_enables.clear()
        if "apiseeds" in old:
            prefs.lyrics_enables.append("Apiseeds")
        if "lyricwiki" in old:
            prefs.lyrics_enables.append("LyricWiki")
        if "genius" in old:
            prefs.lyrics_enables.append("Genius")

    if db_version <= 41:
        print("Updating database to version 42")

        for key, value in gen_codes.items():
            gen_codes[key] = value.replace("f\"", "p\"")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            f = open(os.path.join(config_directory, "input.txt"), 'r')
            text = f.read()
            f.close()
            lines = text.splitlines()

            f = open(os.path.join(config_directory, "input.txt"), 'w')
            for line in lines:
                line = line.strip()
                if "rename-playlist" in line:

                    f.write(line + "\n")

                    line = "new-playlist T Ctrl\n"
                    f.write(line)

                    line = "\nnew-generator-playlist\n"
                    f.write(line)
                    if "e ctrl" in text.lower():
                        line = "edit-generator\n\n"
                    else:
                        line = "edit-generator E Ctrl\n\n"
                    f.write(line)

                    line = "search-lyrics-selected\n"
                    f.write(line)
                    line = "substitute-search-selected"

                f.write(line + "\n")

            f.close()

    if db_version <= 42:
        print("Updating database to version 43")

    if db_version <= 43:
        print("Updating database to version 44")
        # Repair db
        for key, value in star_store.db.items():
            if len(value) == 2:
                value.append(0)
                star_store.db[key] = value

    if db_version <= 44:
        print("Updating database to version 45")
        print("Cleaning cache directory")
        for item in os.listdir(cache_directory):
            path = os.path.join(cache_directory, item)
            if "-lfm." in item or "-ftv." in item or "-dcg." in item:
                os.rename(path, os.path.join(a_cache_dir, item))
        for item in os.listdir(cache_directory):
            path = os.path.join(cache_directory, item)
            if os.path.isfile(path):
                os.remove(path)

    if db_version <= 45:
        print("Updating database to version 46")
        for p in multi_playlist:
            if type(p[7]) != list:
                p[7] = [p[7]]

    if db_version <= 46:
        print("Updating database to version 47")
        for p in multi_playlist:
            if type(p[7]) != list:
                p[7] = [p[7]]

    if db_version <= 47:
        print("Updating database to version 48")
        if os.path.isfile(os.path.join(user_directory, "spot-r-token")):
            show_message("Welcome to v6.1.0. Due to changes, please re-authorise Spotify",
                         "You can do this by clicking 'Forget Account', then 'Authroise' in Settings > Accounts > Spotify")

    if db_version <= 48:
        print("Fix bad upgrade, now 49")
        for key, value in master_library.items():
            if not hasattr(master_library[key], 'url_key'):
                setattr(master_library[key], 'url_key', "")
            if not hasattr(master_library[key], 'art_url_key'):
                setattr(master_library[key], 'art_url_key', "")

    if db_version <= 49:
        print("Updating database to version 50")
        if os.path.isfile(os.path.join(user_directory, "spot-r-token")):
            show_message("Welcome to v6.3.0. Due to an upgrade, please re-authorise Spotify",
                         "You can do this by clicking 'Authroise' in Settings > Accounts > Spotify")
            os.remove(os.path.join(user_directory, "spot-r-token"))

    if db_version <= 54:
        print("Updating database to version 55")
        for key, value in master_library.items():
            setattr(master_library[key], 'lfm_scrobbles', 0)

    if db_version <= 55:
        print("Update to db 56")
        for key, value in master_library.items():

            if hasattr(value, "track_gain"):
                if value.track_gain != 0:
                    value.misc["replaygain_track_gain"] = value.track_gain
                del value.track_gain

            if hasattr(value, "album_gain"):
                if value.album_gain != 0:
                    value.misc["replaygain_album_gain"] = value.album_gain
                del value.album_gain

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("toggle-right-panel MB5\n")
                f.write("toggle-gallery MB4\n")

    if db_version <= 56:
        print("Update to db 57")
        if "Apiseeds" in prefs.lyrics_enables:
            prefs.lyrics_enables.remove("Apiseeds")
            prefs.lyrics_enables.append("Happi")

    if db_version <= 57:
        print("Updating database to version 58")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("\nregenerate-playlist R Alt\n")
                f.write("clear-queue Q Shift Alt\n")
                f.write("resize-window-16:9 F11 Alt\n")
                f.write("delete-playlist-force W Shift Ctrl\n")

    if db_version <= 58:
        print("Updating database to version 59")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("\nrandom-album ; Alt\n")

    if db_version <= 59:
        print("Updating database to version 60")

        if prefs.spotify_token:
            show_message("Upgrade to v6.5.1. It looks like you are using Spotify.",
                         "Please click \"Authorise\" again in the settings")
        prefs.spotify_token = ""

    if db_version <= 60:
        print("Updating database to version 61")

        token_path = os.path.join(user_directory, "spot-token-pkce")
        if os.path.exists(token_path):
            prefs.spotify_token = ""
            os.remove(token_path)
            show_message("Upgrade to v6.5.3 complete",
                         "It looks like you are using Spotify. Please re-setup Spotify again in the settings")

    if db_version <= 61:
        print("Updating database to version 62")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("\ntransfer-playtime-to P Ctrl Shift\n")

    if db_version <= 62:
        print("Updating database to version 63")
        for item in gui.pl_st:
            if item[0] == "T":
                item[0] = "#"

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'r') as f:
                lines = f.readlines()
            with open(os.path.join(config_directory, "input.txt"), 'w') as f:
                for line in lines:
                    if line == "vol-up Up Shift\n" or line == "vol-down Down Shift\n":
                        continue
                    f.write(line)
                f.write("\n")
                f.write("shift-up Up Shift\n")
                f.write("shift-down Down Shift\n")
                f.write("vol-up Up Ctrl\n")
                f.write("vol-down Down Ctrl\n")

    if db_version <= 63:
        print("Updating database to version 64")
        if prefs.radio_urls:
            radio_playlists[0]["items"].extend(prefs.radio_urls)
            prefs.radio_urls = []
        # prefs.show_nag = True

    if db_version <= 64:
        print("Updating database to version 65")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("\nescape Escape\n")
                f.write("toggle-mute M Ctrl\n")

    if db_version <= 65:
        print("Updating database to version 66")

        if install_directory != config_directory and os.path.isfile(os.path.join(config_directory, "input.txt")):
            with open(os.path.join(config_directory, "input.txt"), 'a') as f:
                f.write("\ntoggle-artistinfo O Ctrl\n")
                f.write("cycle-theme ] Ctrl\n")
                f.write("cycle-theme-reverse [ Ctrl\n")

    if db_version <= 66:
        print("Updating database to version 67")
        for key, value in star_store.db.items():
            if len(value) == 3:
                value.append(0)
                star_store.db[key] = value

    if db_version <= 67:
        print("Updating database to version 68")
        for p in multi_playlist:
            if len(p) == 11:
                p.append(False)

if playing_in_queue > len(QUE) - 1:
    playing_in_queue = len(QUE) - 1

shoot = threading.Thread(target=keymaps.load)
shoot.daemon = True
shoot.start()

# Loading Config -----------------

download_directories = []

if os.path.isdir(download_directory):
    download_directories.append(download_directory)

if music_directory is not None and os.path.isdir(music_directory):
    download_directories.append(music_directory)

from t_modules.t_config import Config

cf = Config()


def save_prefs():
    cf.update_value("sync-bypass-transcode", prefs.bypass_transcode)
    cf.update_value("sync-bypass-low-bitrate", prefs.smart_bypass)
    cf.update_value("radio-record-codec", prefs.radio_record_codec)

    cf.update_value("plex-username", prefs.plex_username)
    cf.update_value("plex-password", prefs.plex_password)
    cf.update_value("plex-servername", prefs.plex_servername)

    cf.update_value("subsonic-username", prefs.subsonic_user)
    cf.update_value("subsonic-password", prefs.subsonic_password)
    cf.update_value("subsonic-password-plain", prefs.subsonic_password_plain)
    cf.update_value("subsonic-server-url", prefs.subsonic_server)

    cf.update_value("jelly-username", prefs.jelly_username)
    cf.update_value("jelly-password", prefs.jelly_password)
    cf.update_value("jelly-server-url", prefs.jelly_server_url)

    cf.update_value("koel-username", prefs.koel_username)
    cf.update_value("koel-password", prefs.koel_password)
    cf.update_value("koel-server-url", prefs.koel_server_url)
    cf.update_value("stream-bitrate", prefs.network_stream_bitrate)

    cf.update_value("display-language", prefs.ui_lang)
    # cf.update_value("decode-search", prefs.diacritic_search)

    # cf.update_value("use-log-volume-scale", prefs.log_vol)
    # cf.update_value("audio-backend", prefs.backend)
    cf.update_value("seek-interval", prefs.seek_interval)
    cf.update_value("pause-fade-time", prefs.pause_fade_time)
    cf.update_value("cross-fade-time", prefs.cross_fade_time)
    cf.update_value("device-buffer-ms", prefs.device_buffer)
    cf.update_value("output-samplerate", prefs.samplerate)
    cf.update_value("resample-quality", prefs.resample)
    cf.update_value("avoid_resampling", prefs.avoid_resampling)
    # cf.update_value("fast-scrubbing", prefs.pa_fast_seek)
    cf.update_value("precache-local-files", prefs.precache)
    cf.update_value("cache-use-tmp", prefs.tmp_cache)
    cf.update_value("cache-limit", prefs.cache_limit)
    cf.update_value("always-ffmpeg", prefs.always_ffmpeg)
    cf.update_value("volume-curve", prefs.volume_power)
    # cf.update_value("force-mono", prefs.mono)
    # cf.update_value("disconnect-device-pause", prefs.dc_device_setting)
    # cf.update_value("use-short-buffering", prefs.short_buffer)

    # cf.update_value("gst-output", prefs.gst_output)
    # cf.update_value("gst-use-custom-output", prefs.gst_use_custom_output)

    cf.update_value("separate-multi-genre", prefs.sep_genre_multi)

    cf.update_value("tag-editor-name", prefs.tag_editor_name)
    cf.update_value("tag-editor-target", prefs.tag_editor_target)

    cf.update_value("playback-follow-cursor", prefs.playback_follow_cursor)
    cf.update_value("spotify-prefer-web", prefs.launch_spotify_web)
    cf.update_value("spotify-allow-local", prefs.launch_spotify_local)
    cf.update_value("back-restarts", prefs.back_restarts)
    cf.update_value("end-queue-stop", prefs.stop_end_queue)
    cf.update_value("block-suspend", prefs.block_suspend)
    cf.update_value("allow-video-formats", prefs.allow_video_formats)

    cf.update_value("ui-scale", prefs.scale_want)
    cf.update_value("auto-scale", prefs.x_scale)
    cf.update_value("tracklist-y-text-offset", prefs.tracklist_y_text_offset)
    cf.update_value("theme-name", prefs.theme_name)
    cf.update_value("mac-style", prefs.macstyle)
    cf.update_value("allow-art-zoom", prefs.zoom_art)

    cf.update_value("scroll-gallery-by-row", prefs.gallery_row_scroll)
    cf.update_value("prefs.gallery_scroll_wheel_px", prefs.gallery_row_scroll)
    cf.update_value("scroll-spectrogram", prefs.spec2_scroll)
    cf.update_value("mascot-opacity", prefs.custom_bg_opacity)
    cf.update_value("synced-lyrics-time-offset", prefs.sync_lyrics_time_offset)

    cf.update_value("artist-list-prefers-album-artist", prefs.artist_list_prefer_album_artist)
    cf.update_value("side-panel-info-persists", prefs.meta_persists_stop)
    cf.update_value("side-panel-info-selected", prefs.meta_shows_selected)
    cf.update_value("side-panel-info-selected-always", prefs.meta_shows_selected_always)
    cf.update_value("mini-mode-avoid-notifications", prefs.stop_notifications_mini_mode)
    cf.update_value("hide-queue-when-empty", prefs.hide_queue)
    # cf.update_value("show-playlist-list", prefs.show_playlist_list)
    cf.update_value("enable-art-header-bar", prefs.art_in_top_panel)
    cf.update_value("always-art-header-bar", prefs.always_art_header)
    # cf.update_value("prefer-center-bg", prefs.center_bg)
    cf.update_value("showcase-texture-background", prefs.showcase_overlay_texture)
    cf.update_value("side-panel-style", prefs.side_panel_layout)
    cf.update_value("side-lyrics-art", prefs.show_side_lyrics_art_panel)
    cf.update_value("side-lyrics-art-on-top", prefs.lyric_metadata_panel_top)
    cf.update_value("absolute-track-indices", prefs.use_absolute_track_index)
    cf.update_value("auto-hide-bottom-title", prefs.hide_bottom_title)
    cf.update_value("auto-show-playing", prefs.auto_goto_playing)
    cf.update_value("notify-include-album", prefs.notify_include_album)
    cf.update_value("show-rating-hint", prefs.rating_playtime_stars)
    cf.update_value("drag-tab-to-unpin", prefs.drag_to_unpin)

    cf.update_value("gallery-thin-borders", prefs.thin_gallery_borders)
    cf.update_value("increase-row-spacing", prefs.increase_gallery_row_spacing)
    cf.update_value("gallery-center-text", prefs.center_gallery_text)

    cf.update_value("use-custom-fonts", prefs.use_custom_fonts)
    cf.update_value("font-main-standard", prefs.linux_font)
    cf.update_value("font-main-medium", prefs.linux_font_semibold)
    cf.update_value("font-main-bold", prefs.linux_font_bold)
    cf.update_value("font-main-condensed", prefs.linux_font_condensed)
    cf.update_value("font-main-condensed-bold", prefs.linux_font_condensed_bold)

    cf.update_value("force-subpixel-text", prefs.force_subpixel_text)

    cf.update_value("double-digit-indices", prefs.dd_index)
    cf.update_value("column-album-artist-fallsback", prefs.column_aa_fallback_artist)
    cf.update_value("left-aligned-album-artist-title", prefs.left_align_album_artist_title)
    cf.update_value("import-auto-sort", prefs.auto_sort)

    cf.update_value("encode-output-dir", prefs.custom_encoder_output)
    cf.update_value("sync-device-music-dir", prefs.sync_target)
    cf.update_value("add_download_directory", prefs.download_dir1)

    cf.update_value("use-system-tray", prefs.use_tray)
    cf.update_value("use-gamepad", prefs.use_gamepad)
    cf.update_value("enable-remote-interface", prefs.enable_remote)

    cf.update_value("enable-mpris", prefs.enable_mpris)
    cf.update_value("hide-maximize-button", prefs.force_hide_max_button)
    cf.update_value("restore-window-position", prefs.save_window_position)
    cf.update_value("mini-mode-always-on-top", prefs.mini_mode_on_top)
    cf.update_value("resume-playback-on-restart", prefs.reload_play_state)
    cf.update_value("resume-playback-on-wake", prefs.resume_play_wake)
    cf.update_value("auto-dl-artist-data", prefs.auto_dl_artist_data)

    cf.update_value("fanart.tv-cover", prefs.enable_fanart_cover)
    cf.update_value("fanart.tv-artist", prefs.enable_fanart_artist)
    cf.update_value("fanart.tv-background", prefs.enable_fanart_bg)
    cf.update_value("auto-update-playlists", prefs.always_auto_update_playlists)
    cf.update_value("write-ratings-to-tag", prefs.write_ratings)
    cf.update_value("enable-spotify", prefs.spot_mode)
    cf.update_value("enable-discord-rpc", prefs.discord_enable)
    cf.update_value("auto-search-lyrics", prefs.auto_lyrics)
    cf.update_value("shortcuts-ignore-keymap", prefs.use_scancodes)
    cf.update_value("alpha_key_activate_search", prefs.search_on_letter)

    cf.update_value("discogs-personal-access-token", prefs.discogs_pat)
    cf.update_value("listenbrainz-token", prefs.lb_token)
    cf.update_value("custom-listenbrainz-url", prefs.listenbrainz_url)

    cf.update_value("maloja-key", prefs.maloja_key)
    cf.update_value("maloja-url", prefs.maloja_url)
    cf.update_value("maloja-enable", prefs.maloja_enable)

    cf.update_value("tau-url", prefs.sat_url)

    cf.update_value("lastfm-pull-love", prefs.lastfm_pull_love)

    cf.update_value("broadcast-page-port", prefs.metadata_page_port)
    cf.update_value("show-current-on-transition", prefs.show_current_on_transition)

    cf.update_value("chart-columns", prefs.chart_columns)
    cf.update_value("chart-rows", prefs.chart_rows)
    cf.update_value("chart-uses-text", prefs.chart_text)
    cf.update_value("chart-font", prefs.chart_font)
    cf.update_value("chart-sorts-top-played", prefs.topchart_sorts_played)

    if os.path.isdir(config_directory):
        cf.dump(os.path.join(config_directory, "tauon.conf"))
    else:
        print("ERROR: Missing config directory")


def load_prefs():
    cf.reset()
    cf.load(os.path.join(config_directory, "tauon.conf"))

    cf.add_comment("Tauon Music Box configuration file")
    cf.br()
    cf.add_comment(
        "This file will be regenerated while app is running. Formatting and additional comments will be lost.")
    cf.add_comment("Tip: Use TOML syntax highlighting")

    cf.br()
    cf.add_text("[audio]")

    # prefs.backend = cf.sync_add("int", "audio-backend", prefs.backend, "4: Built in backend (Phazor), 2: GStreamer")
    prefs.seek_interval = cf.sync_add("int", "seek-interval", prefs.seek_interval,
                                      "In s. Interval to seek when using keyboard shortcut. Default is 15.")
    # prefs.pause_fade_time = cf.sync_add("int", "pause-fade-time", prefs.pause_fade_time, "In milliseconds. Default is 400. (GStreamer Only)")

    if prefs.pause_fade_time < 100:
        prefs.pause_fade_time = 100
    if prefs.pause_fade_time > 5000:
        prefs.pause_fade_time = 5000

    prefs.cross_fade_time = cf.sync_add("int", "cross-fade-time", prefs.cross_fade_time,
                                        "In ms. Min: 200, Max: 2000, Default: 700. Applies to track change crossfades. End of track is always gapless.")

    prefs.device_buffer = cf.sync_add("int", "device-buffer-ms", prefs.device_buffer, "Default: 80")
    #prefs.samplerate = cf.sync_add("int", "output-samplerate", prefs.samplerate,
    #                               "In hz. Default: 48000, alt: 44100. (restart app to apply change)")
    prefs.avoid_resampling = cf.sync_add("bool", "avoid_resampling", prefs.avoid_resampling,
                                 "Only implemented for FLAC, MP3, OGG, OPUS")
    prefs.resample = cf.sync_add("int", "resample-quality", prefs.resample,
                                 "0=best, 1=medium, 2=fast, 3=fastest. Default: 1. (applies on restart)")
    if prefs.resample < 0 or prefs.resample > 4:
        prefs.resample = 1
    # prefs.pa_fast_seek = cf.sync_add("bool", "fast-scrubbing", prefs.pa_fast_seek, "Seek without a delay but may cause audible popping")
    prefs.cache_limit = cf.sync_add("int", "cache-limit", prefs.cache_limit,
                                    "Limit size of network audio file cache. In MB.")
    prefs.tmp_cache = cf.sync_add("bool", "cache-use-tmp", prefs.tmp_cache,
                                  "Use /tmp for cache. When enabled, above setting overridden to a small value. (applies on restart)")
    prefs.precache = cf.sync_add("bool", "precache-local-files", prefs.precache,
                                 "Cache files from local sources too. (Useful for mounted network drives)")
    prefs.always_ffmpeg = cf.sync_add("bool", "always-ffmpeg", prefs.always_ffmpeg,
                                      "Prefer decoding using FFMPEG. Fixes stuttering on Raspberry Pi OS.")
    prefs.volume_power = cf.sync_add("int", "volume-curve", prefs.volume_power,
                                     "1=Linear volume control. Values above one give greater control bias over lower volume range. Default: 2")

    # prefs.mono = cf.sync_add("bool", "force-mono", prefs.mono, "This is a placeholder setting and currently has no effect.")
    # prefs.dc_device_setting = cf.sync_add("string", "disconnect-device-pause", prefs.dc_device_setting, "Can be \"on\" or \"off\". BASS only. When off, connection to device will he held open.")
    # prefs.short_buffer = cf.sync_add("bool", "use-short-buffering", prefs.short_buffer, "BASS only.")

    # cf.br()
    # cf.add_text("[audio (gstreamer only)]")
    #
    # prefs.gst_output = cf.sync_add("string", "gst-output", prefs.gst_output, "GStreamer output pipeline specification. Only used with GStreamer backend.")
    # prefs.gst_use_custom_output = cf.sync_add("bool", "gst-use-custom-output", prefs.gst_use_custom_output, "Set this to true to apply any manual edits of the above string.")

    if prefs.dc_device_setting == 'on':
        prefs.dc_device = True
    elif prefs.dc_device_setting == 'off':
        prefs.dc_device = False

    cf.br()
    cf.add_text("[locale]")
    prefs.ui_lang = cf.sync_add("string", "display-language", prefs.ui_lang, "Override display language to use if "
                                                                             "available. E.g. \"en\", \"ja\", \"zh_CH\". "
                                                                             "Default: \"auto\"")
    # prefs.diacritic_search = cf.sync_add("bool", "decode-search", prefs.diacritic_search, "Allow searching of diacritics etc using ascii in search functions. (Disablng may speed up search)")
    cf.br()
    cf.add_text("[search]")
    prefs.sep_genre_multi = cf.sync_add("bool", "separate-multi-genre", prefs.sep_genre_multi,
                                        "If true, the standard genre result will exclude results from multi-value tags. These will be included in a separate result.")

    cf.br()
    cf.add_text("[tag-editor]")
    if system == 'windows' or msys:
        prefs.tag_editor_name = cf.sync_add("string", "tag-editor-name", "Picard", "Name to display in UI.")
        prefs.tag_editor_target = cf.sync_add("string", "tag-editor-target",
                                              "C:\\Program Files (x86)\\MusicBrainz Picard\\picard.exe",
                                              "The path of the exe to run.")
    else:
        prefs.tag_editor_name = cf.sync_add("string", "tag-editor-name", "Picard", "Name to display in UI.")
        prefs.tag_editor_target = cf.sync_add("string", "tag-editor-target", "picard",
                                              "The name of the binary to call.")

    cf.br()
    cf.add_text("[playback]")
    prefs.playback_follow_cursor = cf.sync_add("bool", "playback-follow-cursor", prefs.playback_follow_cursor,
                                               "When advancing, always play the track that is selected.")
    prefs.launch_spotify_web = cf.sync_add("bool", "spotify-prefer-web", prefs.launch_spotify_web,
                                           "Launch the web client rather than attempting to launch the desktop client.")
    prefs.launch_spotify_local = cf.sync_add("bool", "spotify-allow-local", prefs.launch_spotify_local,
                                           "Play Spotify audio through Tauon.")
    prefs.back_restarts = cf.sync_add("bool", "back-restarts", prefs.back_restarts,
                                      "Pressing the back button restarts playing track on first press.")
    prefs.stop_end_queue = cf.sync_add("bool", "end-queue-stop", prefs.stop_end_queue,
                                       "Queue will always enable auto-stop on last track")
    prefs.block_suspend = cf.sync_add("bool", "block-suspend", prefs.block_suspend,
                                      "Prevent system suspend during playback")
    prefs.allow_video_formats = cf.sync_add("bool", "allow-video-formats", prefs.allow_video_formats,
                                      "Allow the import of MP4 and WEBM formats")
    if prefs.allow_video_formats:
        for item in VID_Formats:
            if item not in DA_Formats:
                DA_Formats.add(item)

    cf.br()
    cf.add_text("[HiDPI]")
    prefs.scale_want = cf.sync_add("float", "ui-scale", prefs.scale_want,
                                   "UI scale factor. Default is 1.0, try increase if using a HiDPI display.")
    prefs.x_scale = cf.sync_add("bool", "auto-scale", prefs.x_scale, "Automatically choose above setting")
    prefs.tracklist_y_text_offset = cf.sync_add("int", "tracklist-y-text-offset", prefs.tracklist_y_text_offset,
                                                "If you're using a UI scale, you may need to tweak this.")

    cf.br()
    cf.add_text("[ui]")

    prefs.theme_name = cf.sync_add("string", "theme-name", prefs.theme_name)
    macstyle = cf.sync_add("bool", "mac-style", prefs.macstyle, "Use macOS style window buttons")
    prefs.zoom_art = cf.sync_add("bool", "allow-art-zoom", prefs.zoom_art)
    prefs.gallery_row_scroll = cf.sync_add("bool", "scroll-gallery-by-row", True)
    prefs.gallery_scroll_wheel_px = cf.sync_add("int", "scroll-gallery-distance", 90,
                                                "Only has effect if scroll-gallery-by-row is false.")
    prefs.spec2_scroll = cf.sync_add("bool", "scroll-spectrogram", prefs.spec2_scroll)
    prefs.custom_bg_opacity = cf.sync_add("int", "mascot-opacity", prefs.custom_bg_opacity)
    if prefs.custom_bg_opacity < 0 or prefs.custom_bg_opacity > 100:
        prefs.custom_bg_opacity = 40
        print("Warning: Invalid value for mascot-opacity")

    prefs.sync_lyrics_time_offset = cf.sync_add("int", "synced-lyrics-time-offset", prefs.sync_lyrics_time_offset,
                                                "In milliseconds. May be negative.")
    prefs.artist_list_prefer_album_artist = cf.sync_add("bool", "artist-list-prefers-album-artist",
                                                        prefs.artist_list_prefer_album_artist,
                                                        "May require restart for change to take effect.")
    prefs.meta_persists_stop = cf.sync_add("bool", "side-panel-info-persists", prefs.meta_persists_stop,
                                           "Show album art and metadata of last played track when stopped.")
    prefs.meta_shows_selected = cf.sync_add("bool", "side-panel-info-selected", prefs.meta_shows_selected,
                                            "Show album art and metadata of selected track when stopped. (overides above setting)")
    prefs.meta_shows_selected_always = cf.sync_add("bool", "side-panel-info-selected-always",
                                                   prefs.meta_shows_selected_always,
                                                   "Show album art and metadata of selected track at all times. (overides the above 2 settings)")
    prefs.stop_notifications_mini_mode = cf.sync_add("bool", "mini-mode-avoid-notifications",
                                                     prefs.stop_notifications_mini_mode,
                                                     "Avoid sending track change notifications when in Mini Mode")
    prefs.hide_queue = cf.sync_add("bool", "hide-queue-when-empty", prefs.hide_queue)
    # prefs.show_playlist_list = cf.sync_add("bool", "show-playlist-list", prefs.show_playlist_list)

    prefs.show_current_on_transition = cf.sync_add("bool", "show-current-on-transition",
                                                   prefs.show_current_on_transition,
                                                   "Always jump to new playing track even with natural transition (broken setting, is always enabled")
    prefs.art_in_top_panel = cf.sync_add("bool", "enable-art-header-bar", prefs.art_in_top_panel,
                                         "Show art in top panel when window is narrow")
    prefs.always_art_header = cf.sync_add("bool", "always-art-header-bar", prefs.always_art_header,
                                          "Show art in top panel at any size. (Requires enable-art-header-bar)")

    # prefs.center_bg = cf.sync_add("bool", "prefer-center-bg", prefs.center_bg, "Always center art for the background art function")
    prefs.showcase_overlay_texture = cf.sync_add("bool", "showcase-texture-background", prefs.showcase_overlay_texture,
                                                 "Draw pattern over background art")
    prefs.side_panel_layout = cf.sync_add("int", "side-panel-style", prefs.side_panel_layout, "0:default, 1:centered")
    prefs.show_side_lyrics_art_panel = cf.sync_add("bool", "side-lyrics-art", prefs.show_side_lyrics_art_panel)
    prefs.lyric_metadata_panel_top = cf.sync_add("bool", "side-lyrics-art-on-top", prefs.lyric_metadata_panel_top)
    prefs.use_absolute_track_index = cf.sync_add("bool", "absolute-track-indices", prefs.use_absolute_track_index,
                                                 "For playlists with titles disabled only")
    prefs.hide_bottom_title = cf.sync_add("bool", "auto-hide-bottom-title", prefs.hide_bottom_title,
                                          "Hide title in bottom panel when already shown in side panel")
    prefs.auto_goto_playing = cf.sync_add("bool", "auto-show-playing", prefs.auto_goto_playing,
                                          "Show playing track in current playlist on track and playlist change even if not the playing playlist")

    prefs.notify_include_album = cf.sync_add("bool", "notify-include-album", prefs.notify_include_album,
                                             "Include album name in track change notifications")
    prefs.rating_playtime_stars = cf.sync_add("bool", "show-rating-hint", prefs.rating_playtime_stars,
                                              "Indicate playtime in rating stars")

    prefs.drag_to_unpin = cf.sync_add("bool", "drag-tab-to-unpin", prefs.drag_to_unpin,
                                      "Dragging a tab off the top-panel un-pins it")

    cf.br()
    cf.add_text("[gallery]")
    prefs.thin_gallery_borders = cf.sync_add("bool", "gallery-thin-borders", prefs.thin_gallery_borders)
    prefs.increase_gallery_row_spacing = cf.sync_add("bool", "increase-row-spacing", prefs.increase_gallery_row_spacing)
    prefs.center_gallery_text = cf.sync_add("bool", "gallery-center-text", prefs.center_gallery_text)

    # show-current-on-transition", prefs.show_current_on_transition)
    if system != 'windows':
        cf.br()
        cf.add_text("[fonts]")
        cf.add_comment("Changes will require app restart.")
        prefs.use_custom_fonts = cf.sync_add("bool", "use-custom-fonts", prefs.use_custom_fonts,
                                             "Setting to false will reset below settings to default on restart")
        if prefs.use_custom_fonts:
            prefs.linux_font = cf.sync_add("string", "font-main-standard", prefs.linux_font,
                                           "Suggested alternate: Liberation Sans")
            prefs.linux_font_semibold = cf.sync_add("string", "font-main-medium", prefs.linux_font_semibold)
            prefs.linux_font_bold = cf.sync_add("string", "font-main-bold", prefs.linux_font_bold)
            prefs.linux_font_condensed = cf.sync_add("string", "font-main-condensed", prefs.linux_font_condensed)
            prefs.linux_font_condensed_bold = cf.sync_add("string", "font-main-condensed-bold", prefs.linux_font_condensed_bold)

        else:
            cf.sync_add("string", "font-main-standard", prefs.linux_font, "Suggested alternate: Liberation Sans")
            cf.sync_add("string", "font-main-medium", prefs.linux_font_semibold)
            cf.sync_add("string", "font-main-bold", prefs.linux_font_bold)
            cf.sync_add("string", "font-main-condensed", prefs.linux_font_condensed)
            cf.sync_add("string", "font-main-condensed-bold", prefs.linux_font_condensed_bold)

        # prefs.force_subpixel_text = cf.sync_add("bool", "force-subpixel-text", prefs.force_subpixel_text, "(Subpixel rendering defaults to off with Flatpak)")

    cf.br()
    cf.add_text("[tracklist]")
    prefs.dd_index = cf.sync_add("bool", "double-digit-indices", prefs.dd_index)
    prefs.column_aa_fallback_artist = cf.sync_add("bool", "column-album-artist-fallsback",
                                                  prefs.column_aa_fallback_artist,
                                                  "'Album artist' column shows 'artist' if otherwise blank.")
    prefs.left_align_album_artist_title = cf.sync_add("bool", "left-aligned-album-artist-title",
                                                      prefs.left_align_album_artist_title,
                                                      "Show 'Album artist' in the folder/album title. Uses colour 'column-album-artist' from theme file")
    prefs.auto_sort = cf.sync_add("bool", "import-auto-sort", prefs.auto_sort,
                                  "This setting is deprecated and will be removed in a future version")

    cf.br()
    cf.add_text("[transcode]")
    prefs.bypass_transcode = cf.sync_add("bool", "sync-bypass-transcode", prefs.bypass_transcode,
                                         "Don't transcode files with sync function")
    prefs.smart_bypass = cf.sync_add("bool", "sync-bypass-low-bitrate", prefs.smart_bypass,
                                     "Skip transcode of <=128kbs folders")
    prefs.radio_record_codec = cf.sync_add("string", "radio-record-codec", prefs.radio_record_codec,
                                           "Can be OPUS, OGG, FLAC, or MP3. Default: OPUS")

    cf.br()
    cf.add_text("[directories]")
    cf.add_comment("Use full paths")
    prefs.sync_target = cf.sync_add("string", "sync-device-music-dir", prefs.sync_target)
    prefs.custom_encoder_output = cf.sync_add("string", "encode-output-dir", prefs.custom_encoder_output,
                                              "E.g. \"/home/example/music/output\". If left blank, encode-output in home music dir will be used.")
    if prefs.custom_encoder_output:
        prefs.encoder_output = prefs.custom_encoder_output
    prefs.download_dir1 = cf.sync_add("string", "add_download_directory", prefs.download_dir1,
                                      "Add another folder to monitor in addition to home downloads and music.")
    if prefs.download_dir1 and prefs.download_dir1 not in download_directories:
        if os.path.isdir(prefs.download_dir1):
            download_directories.append(prefs.download_dir1)
        else:
            print("Warning: Invalid download directory in config")

    cf.br()
    cf.add_text("[app]")
    prefs.enable_remote = cf.sync_add("bool", "enable-remote-interface", prefs.enable_remote,
                                      "For use with Tauon Music Remote for Android")
    prefs.use_gamepad = cf.sync_add("bool", "use-gamepad", prefs.use_gamepad, "Use game controller for UI control, restart on change.")
    prefs.use_tray = cf.sync_add("bool", "use-system-tray", prefs.use_tray)
    prefs.force_hide_max_button = cf.sync_add("bool", "hide-maximize-button", prefs.force_hide_max_button)
    prefs.save_window_position = cf.sync_add("bool", "restore-window-position", prefs.save_window_position,
                                             "Save and restore the last window position on desktop on open")
    prefs.mini_mode_on_top  = cf.sync_add("bool", "mini-mode-always-on-top", prefs.mini_mode_on_top)
    prefs.enable_mpris = cf.sync_add("bool", "enable-mpris", prefs.enable_mpris)
    prefs.reload_play_state = cf.sync_add("bool", "resume-playback-on-restart", prefs.reload_play_state)
    prefs.resume_play_wake = cf.sync_add("bool", "resume-playback-on-wake", prefs.resume_play_wake)
    prefs.auto_dl_artist_data = cf.sync_add("bool", "auto-dl-artist-data", prefs.auto_dl_artist_data,
                                            "Enable automatic downloading of thumbnails in artist list")
    prefs.enable_fanart_cover = cf.sync_add("bool", "fanart.tv-cover", prefs.enable_fanart_cover)
    prefs.enable_fanart_artist = cf.sync_add("bool", "fanart.tv-artist", prefs.enable_fanart_artist)
    prefs.enable_fanart_bg = cf.sync_add("bool", "fanart.tv-background", prefs.enable_fanart_bg)
    prefs.always_auto_update_playlists = cf.sync_add("bool", "auto-update-playlists",
                                                     prefs.always_auto_update_playlists,
                                                     "Automatically update generator playlists")
    prefs.write_ratings = cf.sync_add("bool", "write-ratings-to-tag", prefs.write_ratings,
                                      "This writes FMPS_Rating tags on disk. Only writing to MP3, OGG and FLAC files is currently supported.")
    prefs.spot_mode = cf.sync_add("bool", "enable-spotify", prefs.spot_mode, "Enable Spotify specific features")
    prefs.discord_enable = cf.sync_add("bool", "enable-discord-rpc", prefs.discord_enable,
                                       "Show track info in running Discord application")
    prefs.auto_lyrics = cf.sync_add("bool", "auto-search-lyrics", prefs.auto_lyrics,
                                    "Automatically search internet for lyrics when display is wanted")

    prefs.use_scancodes = cf.sync_add("bool", "shortcuts-ignore-keymap", prefs.use_scancodes,
                                    "When enabled, shortcuts will map to the physical keyboard layout")
    prefs.search_on_letter = cf.sync_add("bool", "alpha_key_activate_search", prefs.search_on_letter,
                                    "When enabled, pressing single letter keyboard key will activate the global search")

    cf.br()
    cf.add_text("[tokens]")
    temp = cf.sync_add("string", "discogs-personal-access-token", prefs.discogs_pat,
                       "Used for sourcing of artist thumbnails.")
    if not temp:
        prefs.discogs_pat = ""
    elif len(temp) != 40:
        print("Warning: Invalid discogs token in config")
    else:
        prefs.discogs_pat = temp

    prefs.listenbrainz_url = cf.sync_add("string", "custom-listenbrainz-url", prefs.listenbrainz_url,
                                         "Specify a custom Listenbrainz compatible api url. E.g. \"https://example.tld/apis/listenbrainz/\" Default: Blank")
    prefs.lb_token = cf.sync_add("string", "listenbrainz-token", prefs.lb_token)

    cf.br()
    cf.add_text("[tauon_satellite]")
    prefs.sat_url = cf.sync_add("string", "tau-url", prefs.sat_url, "Exclude the port")

    cf.br()
    cf.add_text("[lastfm]")
    prefs.lastfm_pull_love = cf.sync_add("bool", "lastfm-pull-love", prefs.lastfm_pull_love,
                                   "Overwrite local love status on scrobble")


    cf.br()
    cf.add_text("[maloja_account]")
    prefs.maloja_url = cf.sync_add("string", "maloja-url", prefs.maloja_url,
                                   "A Maloja server URL, e.g. http://localhost:32400")
    prefs.maloja_key = cf.sync_add("string", "maloja-key", prefs.maloja_key, "One of your Maloja API keys")
    prefs.maloja_enable = cf.sync_add("bool", "maloja-enable", prefs.maloja_enable)

    cf.br()
    cf.add_text("[plex_account]")
    prefs.plex_username = cf.sync_add("string", "plex-username", prefs.plex_username,
                                      "Probably the email address you used to make your PLEX account.")
    prefs.plex_password = cf.sync_add("string", "plex-password", prefs.plex_password,
                                      "The password associated with your PLEX account.")
    prefs.plex_servername = cf.sync_add("string", "plex-servername", prefs.plex_servername,
                                        "Probably your servers hostname.")

    cf.br()
    cf.add_text("[subsonic_account]")
    prefs.subsonic_user = cf.sync_add("string", "subsonic-username", prefs.subsonic_user)
    prefs.subsonic_password = cf.sync_add("string", "subsonic-password", prefs.subsonic_password)
    prefs.subsonic_password_plain = cf.sync_add("bool", "subsonic-password-plain", prefs.subsonic_password_plain)
    prefs.subsonic_server = cf.sync_add("string", "subsonic-server-url", prefs.subsonic_server)

    cf.br()
    cf.add_text("[koel_account]")
    prefs.koel_username = cf.sync_add("string", "koel-username", prefs.koel_username, "E.g. admin@example.com")
    prefs.koel_password = cf.sync_add("string", "koel-password", prefs.koel_password, "The default is admin")
    prefs.koel_server_url = cf.sync_add("string", "koel-server-url", prefs.koel_server_url,
                                        "The URL or IP:Port where the Koel server is hosted. E.g. http://localhost:8050 or https://localhost:8060")
    prefs.koel_server_url = prefs.koel_server_url.rstrip("/")

    cf.br()
    cf.add_text("[jellyfin_account]")
    prefs.jelly_username = cf.sync_add("string", "jelly-username", prefs.jelly_username, "")
    prefs.jelly_password = cf.sync_add("string", "jelly-password", prefs.jelly_password, "")
    prefs.jelly_server_url = cf.sync_add("string", "jelly-server-url", prefs.jelly_server_url,
                                         "The IP:Port where the jellyfin server is hosted.")
    prefs.jelly_server_url = prefs.jelly_server_url.rstrip("/")

    cf.br()
    cf.add_text("[network]")
    prefs.network_stream_bitrate = cf.sync_add("int", "stream-bitrate", prefs.network_stream_bitrate,
                                               "Optional bitrate koel/subsonic should transcode to (Server may need to be configured for this). Set to 0 to disable transcoding.")

    cf.br()
    cf.add_text("[listenalong]")
    prefs.metadata_page_port = cf.sync_add("int", "broadcast-page-port", prefs.metadata_page_port,
                                           "Change applies on app restart or setting re-enable")

    cf.br()
    cf.add_text("[chart]")
    prefs.chart_columns = cf.sync_add("int", "chart-columns", prefs.chart_columns)
    prefs.chart_rows = cf.sync_add("int", "chart-rows", prefs.chart_rows)
    prefs.chart_text = cf.sync_add("bool", "chart-uses-text", prefs.chart_text)
    prefs.topchart_sorts_played = cf.sync_add("bool", "chart-sorts-top-played", prefs.topchart_sorts_played)
    prefs.chart_font = cf.sync_add("string", "chart-font", prefs.chart_font,
                                   "Format is fontname + size. Default is Monospace 10")


load_prefs()
save_prefs()

# Temporary
if 0 < db_version <= 34:
    prefs.theme_name = get_theme_name(theme)
if 0 < db_version <= 66:
    prefs.device_buffer = 80
if 0 < db_version <= 53:
    print("Resetting fonts to defaults")
    prefs.linux_font = "Noto Sans"
    prefs.linux_font_semibold = "Noto Sans Medium"
    prefs.linux_font_bold = "Noto Sans Bold"
    save_prefs()

lang = ""

locale_dir = os.path.join(install_directory, "locale")

if flatpak_mode:
    locale_dir = "/app/share/locale"
elif install_directory.startswith("/opt/") or install_directory.startswith("/usr/"):
    locale_dir = "/usr/share/locale"

lang = []
if prefs.ui_lang != "auto" or prefs.ui_lang == "":
    lang = [prefs.ui_lang]

if lang:
    # Force set lang
    f = gettext.find('tauon', localedir=locale_dir, languages=lang)

    if f:
        translation = gettext.translation('tauon', localedir=locale_dir, languages=lang)
        translation.install()
        _ = translation.gettext

        print("Translation file loaded")
    else:
        print("No translation file available")

else:
    # Auto detect lang
    f = gettext.find('tauon', localedir=locale_dir)

    if f:
        translation = gettext.translation('tauon', localedir=locale_dir)
        translation.install()
        _ = translation.gettext

        print("Translation file loaded")
    # else:
    #     print("No translation file available")

# ----

sss = SDL_SysWMinfo()
SDL_GetWindowWMInfo(t_window, sss)

if prefs.use_gamepad:
    SDL_InitSubSystem(SDL_INIT_GAMECONTROLLER)

smtc = False

if msys and win_ver >= 10:
    
    #print(sss.info.win.window)
    try:
        sm = ctypes.cdll.LoadLibrary(os.path.join(install_directory, "lib", "TauonSMTC.dll"))

        def SMTC_button_callback(button):

            if button == 1:
                inp.media_key = 'Play'
            if button == 2:
                inp.media_key = 'Pause'
            if button == 3:
                inp.media_key = "Next"
            if button == 4:
                inp.media_key = "Previous"
            if button == 5:
                inp.media_key = "Stop"
            gui.update += 1
            tauon.wake()

        close_callback = ctypes.WINFUNCTYPE(ctypes.c_void_p, ctypes.c_int)(SMTC_button_callback)
        smtc = sm.init(close_callback) == 0
    except:
        print("Failed to load TauonSMTC.dll")

def auto_scale():

    old = prefs.scale_want

    if prefs.x_scale:
        if sss.subsystem in (SDL_SYSWM_WAYLAND, SDL_SYSWM_COCOA, SDL_SYSWM_UNKNOWN):
            prefs.scale_want = window_size[0] / logical_size[0]
            if old != prefs.scale_want:
                print("Applying scale based on buffer size")
        elif sss.subsystem == SDL_SYSWM_X11:
            if xdpi > 40:
                prefs.scale_want = xdpi / 96
                if old != prefs.scale_want:
                    print("Applying scale based on xft setting")

    prefs.scale_want = round(round(prefs.scale_want / 0.05) * 0.05, 2)

    if prefs.scale_want == 0.95:
        prefs.scale_want = 1.0
    if prefs.scale_want == 1.05:
        prefs.scale_want = 1.0
    if prefs.scale_want == 1.95:
        prefs.scale_want = 2.0
    if prefs.scale_want == 2.05:
        prefs.scale_want = 2.0

    if old != prefs.scale_want:
        print(f"Using UI scale: {prefs.scale_want}")

    if prefs.scale_want < 0.5:
        prefs.scale_want = 1.0

    if window_size[0] < (560 * prefs.scale_want) * 0.9 or window_size[1] < (330 * prefs.scale_want) * 0.9:
        print("Window overscale!")
        show_message("Detected unsuitable UI scaling.", "Scaling setting reset to 1x")
        prefs.scale_want = 1.0

auto_scale()


def scale_assets(scale_want, force=False):
    global scaled_asset_directory
    if scale_want != 1:
        scaled_asset_directory = os.path.join(user_directory, "scaled-icons")
        if not os.path.exists(scaled_asset_directory) or len(os.listdir(svg_directory)) != len(
                os.listdir(scaled_asset_directory)):
            print("Force rerender icons")
            force = True
    else:
        scaled_asset_directory = asset_directory

    if scale_want != prefs.ui_scale or force:

        if scale_want != 1:
            if os.path.isdir(scaled_asset_directory) and scaled_asset_directory != asset_directory:
                shutil.rmtree(scaled_asset_directory)
            from t_modules.t_svgout import render_icons

            if scaled_asset_directory != asset_directory:
                print("Rendering icons...")
                render_icons(svg_directory, scaled_asset_directory, scale_want)

        print("Done rendering icons")

        diff_ratio = scale_want / prefs.ui_scale
        prefs.ui_scale = scale_want
        prefs.playlist_row_height = round(22 * prefs.ui_scale)

        # Save user values
        column_backup = gui.pl_st
        rspw = gui.pref_rspw
        grspw = gui.pref_gallery_w

        gui.destroy_textures()
        gui.rescale()

        # Scale saved values
        gui.pl_st = column_backup
        for item in gui.pl_st:
            item[1] *= diff_ratio
        gui.pref_rspw = rspw * diff_ratio
        gui.pref_gallery_w = grspw * diff_ratio
        global album_mode_art_size
        album_mode_art_size = int(album_mode_art_size * diff_ratio)


scale_assets(scale_want=prefs.scale_want)

try:
    # star_lines = view_prefs['star-lines']
    update_title = view_prefs['update-title']
    prefs.prefer_side = view_prefs['side-panel']
    prefs.dim_art = False  # view_prefs['dim-art']
    #gui.turbo = view_prefs['level-meter']
    # pl_follow = view_prefs['pl-follow']
    scroll_enable = view_prefs['scroll-enable']
    break_enable = view_prefs['break-enable']
    # dd_index = view_prefs['dd-index']
    # custom_line_mode = view_prefs['custom-line']
    # thick_lines = view_prefs['thick-lines']
    prefs.append_date = view_prefs['append-date']
except:
    print("warning: error loading settings")

if prefs.prefer_side is False:
    gui.rsp = False


def get_global_mouse():
    i_y = pointer(c_int(0))
    i_x = pointer(c_int(0))
    SDL_GetGlobalMouseState(i_x, i_y)
    return i_x.contents.value, i_y.contents.value


def get_window_position():
    i_y = pointer(c_int(0))
    i_x = pointer(c_int(0))
    SDL_GetWindowPosition(t_window, i_x, i_y)
    return i_x.contents.value, i_y.contents.value


# Access functions from libopenmpt for scanning tracker files
class MOD(Structure):
    _fields_ = [('ctl', c_char_p),
                ('value', c_char_p)]


mpt = None
try:
    p = ctypes.util.find_library("libopenmpt")
    if p:
        mpt = ctypes.cdll.LoadLibrary(p)
    elif msys:
        mpt = ctypes.cdll.LoadLibrary("libopenmpt-0.dll")
    else:
        mpt = ctypes.cdll.LoadLibrary("libopenmpt.so")

    mpt.openmpt_module_create_from_memory.restype = c_void_p
    mpt.openmpt_module_get_metadata.restype = c_char_p
    mpt.openmpt_module_get_duration_seconds.restype = c_double
except:
    print("Failed to load libopenmpt!")



class GMETrackInfo(Structure):
    _fields_ = [
        ("length", c_int),
        ("intro_length", c_int),
        ("loop_length", c_int),
        ("play_length", c_int),
        ("fade_length", c_int),
        ("i5", c_int),
        ("i6", c_int),
        ("i7", c_int),
        ("i8", c_int),
        ("i9", c_int),
        ("i10", c_int),
        ("i11", c_int),
        ("i12", c_int),
        ("i13", c_int),
        ("i14", c_int),
        ("i15", c_int),
        ("system", c_char_p),
        ("game", c_char_p),
        ("song", c_char_p),
        ("author", c_char_p),
        ("copyright", c_char_p),
        ("comment", c_char_p),
        ("dumper", c_char_p),
        ("s7", c_char_p),
        ("s8", c_char_p),
        ("s9", c_char_p),
        ("s10", c_char_p),
        ("s11", c_char_p),
        ("s12", c_char_p),
        ("s13", c_char_p),
        ("s14", c_char_p),
        ("s15", c_char_p)
    ]


gme = None
p = None
try:
    p = ctypes.util.find_library("libgme")
    if p:
        gme = ctypes.cdll.LoadLibrary(p)
    elif msys:
        gme = ctypes.cdll.LoadLibrary("libgme-0.dll")
    else:
        gme = ctypes.cdll.LoadLibrary("libgme.so")

    gme.gme_free_info.argtypes = [ctypes.POINTER(GMETrackInfo)]
    gme.gme_track_info.argtypes = [ctypes.c_void_p, ctypes.POINTER(ctypes.POINTER(GMETrackInfo)), ctypes.c_int]
    gme.gme_track_info.restype = ctypes.c_char_p
    gme.gme_open_file.argtypes = [ctypes.c_char_p, ctypes.POINTER(ctypes.c_void_p), ctypes.c_int]
    gme.gme_open_file.restype = ctypes.c_char_p

except:
    print("Cannont find libgme")

def use_id3(tags, nt):
    def natural_get(tag, track, frame, attr):
        frames = tag.getall(frame)
        if frames and frames[0].text:
            if track is None:
                return str(frames[0].text[0])
            setattr(track, attr, str(frames[0].text[0]))
        elif track is None:
            return ""
        else:
            setattr(track, attr, "")

    tag = tags

    natural_get(tags, nt, "TIT2", "title")
    natural_get(tags, nt, "TPE1", "artist")
    natural_get(tags, nt, "TPE2", "album_artist")
    natural_get(tags, nt, "TCON", "genre")  # content type
    natural_get(tags, nt, "TALB", "album")
    natural_get(tags, nt, "TDRC", "date")
    natural_get(tags, nt, "TCOM", "composer")
    natural_get(tags, nt, "COMM", "comment")

    process_odat(nt, natural_get(tags, None, "TDOR", None))

    frames = tag.getall("POPM")
    rating = 0
    if frames:
        for frame in frames:
            if frame.rating:
                rating = frame.rating
                nt.misc['POPM'] = frame.rating

    if len(nt.comment) > 4 and nt.comment[2] == "+":
        nt.comment = ""
    if nt.comment[0:3] == "000":
        nt.comment = ""

    frames = tag.getall("USLT")
    if frames:
        nt.lyrics = frames[0].text
        if 0 < len(nt.lyrics) < 150:
            if "unavailable" in nt.lyrics or ".com" in nt.lyrics or "www." in nt.lyrics:
                nt.lyrics = ""

    frames = tag.getall("TPE1")
    if frames:
        d = []
        for frame in frames:
            for t in frame.text:
                d.append(t)
        if len(d) > 1:
            nt.misc['artists'] = d
            nt.artist = "; ".join(d)

    frames = tag.getall("TCON")
    if frames:
        d = []
        for frame in frames:
            for t in frame.text:
                d.append(t)
        if len(d) > 1:
            nt.misc['genres'] = d
        nt.genre = " / ".join(d)

    track_no = natural_get(tags, None, "TRCK", None)
    nt.track_total = ""
    nt.track_number = ""
    if track_no and track_no != "null":
        if "/" in track_no:
            a, b = track_no.split("/")
            nt.track_number = a
            nt.track_total = b
        else:
            nt.track_number = track_no

    disc = natural_get(tags, None, "TPOS", None)  # set ? or ?/?
    nt.disc_total = ""
    nt.disc_number = ""
    if disc:
        if "/" in disc:
            a, b = disc.split("/")
            nt.disc_number = a
            nt.disc_total = b
        else:
            nt.disc_number = disc

    tx = tags.getall("UFID")
    if tx:
        for item in tx:
            if item.owner == "http://musicbrainz.org":
                nt.misc['musicbrainz_recordingid'] = item.data.decode()

    tx = tags.getall("TSOP")
    if tx:
        nt.misc["artist_sort"] = tx[0].text[0]

    tx = tags.getall("TXXX")
    if tx:
        for item in tx:
            if item.desc == "MusicBrainz Release Track Id":
                nt.misc['musicbrainz_trackid'] = item.text[0]
            if item.desc == "MusicBrainz Album Id":
                nt.misc['musicbrainz_albumid'] = item.text[0]
            if item.desc == "MusicBrainz Release Group Id":
                nt.misc['musicbrainz_releasegroupid'] = item.text[0]
            if item.desc == "MusicBrainz Artist Id":
                nt.misc['musicbrainz_artistids'] = list(item.text)

            try:
                desc = item.desc.lower()
                if desc == "replaygain_track_gain":
                    nt.misc['replaygain_track_gain'] = float(item.text[0].strip(" dB"))
                if desc == "replaygain_track_peak":
                    nt.misc['replaygain_track_peak'] = float(item.text[0])
                if desc == "replaygain_album_gain":
                    nt.misc['replaygain_album_gain'] = float(item.text[0].strip(" dB"))
                if desc == "replaygain_album_peak":
                    nt.misc['replaygain_album_peak'] = float(item.text[0])
            except:
                print("Tag Scan: Read Replay Gain MP3 error")
                print(nt.fullpath)

            if item.desc == "FMPS_RATING":
                nt.misc['FMPS_Rating'] = float(item.text[0])


def scan_ffprobe(nt):
    startupinfo = None
    if system == 'windows' or msys:
        startupinfo = subprocess.STARTUPINFO()
        startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
    try:
        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format=duration", "-of",
                                 "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
        nt.length = float(result.stdout.decode())
    except:
        print("FFPROBE couldn't supply a duration")
    try:
        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=title", "-of",
                                 "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
        nt.title = str(result.stdout.decode())
    except:
        print("FFPROBE couldn't supply a title")
    try:
        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=artist", "-of",
                                 "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
        nt.artist = str(result.stdout.decode())
    except:
        print("FFPROBE couldn't supply a artist")
    try:
        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=album", "-of",
                                 "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
        nt.album = str(result.stdout.decode())
    except:
        print("FFPROBE couldn't supply a album")
    try:
        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=date", "-of",
                                 "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
        nt.date = str(result.stdout.decode())
    except:
        print("FFPROBE couldn't supply a date")
    try:
        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format_tags=track", "-of",
                                 "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
        nt.track_number = str(result.stdout.decode())
    except:
        print("FFPROBE couldn't supply a track")


# This function takes a track object and scans metadata for it. (Filepath needs to be set)
def tag_scan(nt):
    if nt.is_embed_cue:
        return nt
    if nt.is_network or not nt.fullpath:
        return
    try:
        try:
            nt.modified_time = os.path.getmtime(nt.fullpath)
            nt.found = True
        except FileNotFoundError:
            nt.found = False
            return nt

        nt.misc.clear()

        nt.file_ext = os.path.splitext(os.path.basename(nt.fullpath))[1][1:].upper()

        if nt.file_ext.lower() in GME_Formats and gme:

            emu = ctypes.c_void_p()
            track_info = ctypes.POINTER(GMETrackInfo)()
            err = gme.gme_open_file(nt.fullpath.encode("utf-8"), ctypes.byref(emu), -1)
            #print(err)
            if not err:
                n = nt.subtrack
                err = gme.gme_track_info(emu, byref(track_info), n)
                #print(err)
                if not err:
                    nt.length = track_info.contents.play_length / 1000
                    nt.title = track_info.contents.song.decode("utf-8")
                    nt.artist = track_info.contents.author.decode("utf-8")
                    nt.album = track_info.contents.game.decode("utf-8")
                    nt.comment = track_info.contents.comment.decode("utf-8")
                    gme.gme_free_info(track_info)
                gme.gme_delete(emu)

                filepath = nt.fullpath  # this is the full file path
                filename = nt.filename  # this is the name of the file

                # Get the directory of the file
                dir_path = os.path.dirname(filepath)

                # Loop through all files in the directory to find any matching M3U
                for file in os.listdir(dir_path):
                    if file.endswith('.m3u'):
                        with open(os.path.join(dir_path, file), encoding='utf-8', errors='replace') as f:
                            content = f.read()
                            if '�' in content:  # Check for replacement marker
                                with open(os.path.join(dir_path, file), encoding='windows-1252') as b:
                                    content = b.read()
                            if "::" in content:
                                a, b = content.split("::")
                                if a == filename:
                                    s = re.split(r'(?<!\\),', b)
                                    try:
                                        st = int(s[1])
                                    except:
                                        continue
                                    if st == n:
                                        nt.title = s[2].split(' - ')[0].replace("\\", "")
                                        nt.artist = s[2].split(' - ')[1].replace("\\", "")
                                        nt.album = s[2].split(' - ')[2].replace("\\", "")
                                        nt.length = hms_to_seconds(s[3])
                                        break
            if not nt.title:
                nt.title = "Track " + str(nt.subtrack + 1)

        elif nt.file_ext in ("MOD", "IT", "XM", "S3M", "MPTM") and mpt:
            f = open(nt.fullpath, "rb")
            data = f.read()
            f.close()
            MOD1 = MOD.from_address(
                mpt.openmpt_module_create_from_memory(ctypes.c_char_p(data), ctypes.c_size_t(len(data)), None, None,
                                                      None))
            nt.length = mpt.openmpt_module_get_duration_seconds(byref(MOD1))
            nt.title = mpt.openmpt_module_get_metadata(byref(MOD1), ctypes.c_char_p(b"title")).decode()
            nt.artist = mpt.openmpt_module_get_metadata(byref(MOD1), ctypes.c_char_p(b"artist")).decode()
            nt.comment = mpt.openmpt_module_get_metadata(byref(MOD1), ctypes.c_char_p(b"message_raw")).decode()

            mpt.openmpt_module_destroy(byref(MOD1))
            del MOD1

        elif nt.file_ext == "FLAC":

            audio = Flac(nt.fullpath)
            audio.read()

            nt.length = audio.length
            nt.title = audio.title
            nt.artist = audio.artist
            nt.album = audio.album
            nt.composer = audio.composer
            nt.date = audio.date
            nt.samplerate = audio.sample_rate
            nt.bit_depth = audio.bit_depth
            nt.size = os.path.getsize(nt.fullpath)
            nt.track_number = audio.track_number
            nt.genre = audio.genre
            nt.album_artist = audio.album_artist
            nt.disc_number = audio.disc_number
            nt.lyrics = audio.lyrics
            if nt.length:
                nt.bitrate = int(nt.size / nt.length * 8 / 1024)
            nt.track_total = audio.track_total
            nt.disc_total = audio.disc_total
            nt.comment = audio.comment
            nt.cue_sheet = audio.cue_sheet
            nt.misc = audio.misc

        elif nt.file_ext == "WAV":

            try:
                audio = Wav(nt.fullpath)
                audio.read()

                nt.samplerate = audio.sample_rate
                nt.length = audio.length
                nt.title = audio.title
                nt.artist = audio.artist
                nt.album = audio.album
                nt.track_number = audio.track_number

            except:
                audio = mutagen.File(nt.fullpath)
                nt.samplerate = audio.info.sample_rate
                nt.bitrate = audio.info.bitrate // 1000
                nt.length = audio.info.length
                nt.size = os.path.getsize(nt.fullpath)
            audio = mutagen.File(nt.fullpath)
            if audio.tags and type(audio.tags) == mutagen.wave._WaveID3:
                use_id3(audio.tags, nt)

        elif nt.file_ext == "OPUS" or nt.file_ext == "OGG" or nt.file_ext == "OGA":

            # print("get opus")
            audio = Opus(nt.fullpath)
            audio.read()

            # print(audio.title)

            nt.length = audio.length
            nt.title = audio.title
            nt.artist = audio.artist
            nt.album = audio.album
            nt.composer = audio.composer
            nt.date = audio.date
            nt.samplerate = audio.sample_rate
            nt.size = os.path.getsize(nt.fullpath)
            nt.track_number = audio.track_number
            nt.genre = audio.genre
            nt.album_artist = audio.album_artist
            nt.bitrate = audio.bit_rate
            nt.lyrics = audio.lyrics
            nt.disc_number = audio.disc_number
            nt.track_total = audio.track_total
            nt.disc_total = audio.disc_total
            nt.comment = audio.comment
            nt.misc = audio.misc
            if nt.bitrate == 0 and nt.length > 0:
                nt.bitrate = int(nt.size / nt.length * 8 / 1024)

        elif nt.file_ext == "APE":
            
            audio = mutagen.File(nt.fullpath)
            nt.length = audio.info.length
            nt.bit_depth = audio.info.bits_per_sample
            nt.samplerate = audio.info.sample_rate
            nt.size = os.path.getsize(nt.fullpath)
            if nt.length > 0:
                nt.bitrate = int(nt.size / nt.length * 8 / 1024)

            # # def getter(audio, key, type):
            # #     if
            # t = audio.tags
            # print(t.keys())
            # nt.size = os.path.getsize(nt.fullpath)
            # nt.title = str(t.get("title", ""))
            # nt.album = str(t.get("album", ""))
            # nt.date = str(t.get("year", ""))
            # nt.disc_number = str(t.get("discnumber", ""))
            # nt.comment = str(t.get("comment", ""))
            # nt.artist = str(t.get("artist", ""))
            # nt.composer = str(t.get("composer", ""))
            # nt.composer = str(t.get("composer", ""))

            audio = Ape(nt.fullpath)
            audio.read()

            # print(audio.title)

            # nt.length = audio.length
            nt.title = audio.title
            nt.artist = audio.artist
            nt.album = audio.album
            nt.date = audio.date
            nt.composer = audio.composer
            # nt.bit_depth = audio.bit_depth
            nt.track_number = audio.track_number
            nt.genre = audio.genre
            nt.album_artist = audio.album_artist
            nt.disc_number = audio.disc_number
            nt.lyrics = audio.lyrics
            nt.track_total = audio.track_total
            nt.disc_total = audio.disc_total
            nt.comment = audio.comment
            nt.misc = audio.misc

        elif nt.file_ext == "WV" or nt.file_ext == "TTA":

            audio = Ape(nt.fullpath)
            audio.read()

            # print(audio.title)

            nt.length = audio.length
            nt.title = audio.title
            nt.artist = audio.artist
            nt.album = audio.album
            nt.date = audio.date
            nt.composer = audio.composer
            nt.samplerate = audio.sample_rate
            nt.bit_depth = audio.bit_depth
            nt.size = os.path.getsize(nt.fullpath)
            nt.track_number = audio.track_number
            nt.genre = audio.genre
            nt.album_artist = audio.album_artist
            nt.disc_number = audio.disc_number
            nt.lyrics = audio.lyrics
            if nt.length > 0:
                nt.bitrate = int(nt.size / nt.length * 8 / 1024)
            nt.track_total = audio.track_total
            nt.disc_total = audio.disc_total
            nt.comment = audio.comment
            nt.misc = audio.misc

        else:

            # Use MUTAGEN
            try:
                if nt.file_ext.lower() in VID_Formats:
                    scan_ffprobe(nt)
                    return nt

                try:
                    audio = mutagen.File(nt.fullpath)
                except:
                    print("Mutagen scan failed, falling back to FFPROBE")
                    scan_ffprobe(nt)
                    return nt

                nt.samplerate = audio.info.sample_rate
                nt.bitrate = audio.info.bitrate // 1000
                nt.length = audio.info.length
                nt.size = os.path.getsize(nt.fullpath)

                if not nt.length:
                    try:
                        startupinfo = None
                        if system == 'windows' or msys:
                            startupinfo = subprocess.STARTUPINFO()
                            startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW
                        result = subprocess.run([tauon.get_ffprobe(), "-v", "error", "-show_entries", "format=duration", "-of", "default=noprint_wrappers=1:nokey=1", nt.fullpath], stdout=subprocess.PIPE, startupinfo=startupinfo)
                        nt.length = float(result.stdout.decode())
                    except:
                        print("FFPROBE couldn't supply a duration")

                if type(audio.tags) == mutagen.mp4.MP4Tags:
                    tags = audio.tags

                    def in_get(key, tags):
                        if key in tags:
                            return tags[key][0]
                        return ""

                    nt.title = in_get("\xa9nam", tags)
                    nt.album = in_get("\xa9alb", tags)
                    nt.artist = in_get("\xa9ART", tags)
                    nt.album_artist = in_get("aART", tags)
                    nt.composer = in_get("\xa9wrt", tags)
                    nt.date = in_get("\xa9day", tags)
                    nt.comment = in_get("\xa9cmt", tags)
                    nt.genre = in_get("\xa9gen", tags)
                    if "\xa9lyr" in tags:
                        nt.lyrics = in_get("\xa9lyr", tags)
                    nt.track_total = ""
                    nt.track_number = ""
                    t = in_get("trkn", tags)
                    if t:
                        nt.track_number = str(t[0])
                        if t[1]:
                            nt.track_total = str(t[1])

                    nt.disc_total = ""
                    nt.disc_number = ""
                    t = in_get("disk", tags)
                    if t:
                        nt.disc_number = str(t[0])
                        if t[1]:
                            nt.disc_total = str(t[1])

                    if '----:com.apple.iTunes:MusicBrainz Track Id' in tags:
                        nt.misc['musicbrainz_recordingid'] = in_get("----:com.apple.iTunes:MusicBrainz Track Id",
                                                                    tags).decode()
                    if '----:com.apple.iTunes:MusicBrainz Release Track Id' in tags:
                        nt.misc['musicbrainz_trackid'] = in_get("----:com.apple.iTunes:MusicBrainz Release Track Id",
                                                                tags).decode()
                    if '----:com.apple.iTunes:MusicBrainz Album Id' in tags:
                        nt.misc['musicbrainz_albumid'] = in_get("----:com.apple.iTunes:MusicBrainz Album Id",
                                                                tags).decode()
                    if '----:com.apple.iTunes:MusicBrainz Release Group Id' in tags:
                        nt.misc['musicbrainz_releasegroupid'] = in_get(
                            "----:com.apple.iTunes:MusicBrainz Release Group Id", tags).decode()
                    if '----:com.apple.iTunes:MusicBrainz Artist Id' in tags:
                        nt.misc['musicbrainz_artistids'] = [x.decode() for x in
                                                            tags.get("----:com.apple.iTunes:MusicBrainz Artist Id")]


                elif type(audio.tags) == mutagen.id3.ID3:
                    use_id3(audio.tags, nt)


            except Exception as e:
                raise


        # Parse any multiple artists into list
        artists = nt.artist.split(";")
        if len(artists) > 1:
            for a in artists:
                a = a.strip()
                if a:
                    if "artists" not in nt.misc:
                        nt.misc["artists"] = []
                    if a not in nt.misc["artists"]:
                        nt.misc["artists"].append(a)


    except Exception as err:
        #raise
        try:
            if Exception is UnicodeDecodeError:
                print("Unicode decode error on file:", nt.fullpath, "\n", err)
            else:
                print("Error: Tag read failed on file:", nt.fullpath, "\n", err)
        except:
            print("Error printing error. Non utf8 not allowed:", nt.fullpath.encode('utf-8', 'surrogateescape').decode('utf-8', 'replace'), "\n", err)
        return nt

    return nt


def get_radio_art():
    if radiobox.loaded_url in radiobox.websocket_source_urls:
        return
    elif "ggdrasil" in radiobox.playing_title:
        time.sleep(3)
        url = "https://yggdrasilradio.net/data.php?"
        response = requests.get(url)
        if response.status_code == 200:
            lines = response.content.decode().split("|")
            if len(lines) > 11 and lines[11]:
                art_id = lines[11].strip().strip("*")
                art_url = "https://yggdrasilradio.net/images/albumart/" + art_id
                art_response = requests.get(art_url)
                if art_response.status_code == 200:
                    if pctl.radio_image_bin:
                        pctl.radio_image_bin.close()
                        pctl.radio_image_bin = None
                    pctl.radio_image_bin = io.BytesIO(art_response.content)
                    pctl.radio_image_bin.seek(0)
                    radiobox.dummy_track.art_url_key = "ok"
            pctl.update_tag_history()

    elif "gensokyoradio.net" in radiobox.loaded_url:

        response = requests.get("https://gensokyoradio.net/api/station/playing/")

        if response.status_code == 200:
            d = json.loads(response.text)
            song_info = d.get("SONGINFO")
            if song_info:
                radiobox.dummy_track.artist = song_info.get("ARTIST", "")
                radiobox.dummy_track.title = song_info.get("TITLE", "")
                radiobox.dummy_track.album = song_info.get("ALBUM", "")

            misc = d.get("MISC")
            if misc:
                art = misc.get("ALBUMART")
                if art:
                    art_url = "https://gensokyoradio.net/images/albums/500/" + art
                    art_response = requests.get(art_url)
                    if art_response.status_code == 200:
                        if pctl.radio_image_bin:
                            pctl.radio_image_bin.close()
                            pctl.radio_image_bin = None
                        pctl.radio_image_bin = io.BytesIO(art_response.content)
                        pctl.radio_image_bin.seek(0)
                        radiobox.dummy_track.art_url_key = "ok"
            pctl.update_tag_history()

    elif "radio.plaza.one" in radiobox.loaded_url:
        time.sleep(3)
        console.print("Fetching plaza art")
        response = requests.get("https://api.plaza.one/status")
        if response.status_code == 200:
            d = json.loads(response.text)
            if "song" in d:
                tr = d["song"]["length"] - d["song"]["position"]
                tr += 1
                if tr < 10:
                    tr = 10
                pctl.radio_poll_timer.force_set(tr * -1)

                if "artist" in d["song"]:
                    radiobox.dummy_track.artist = d["song"]["artist"]
                if "title" in d["song"]:
                    radiobox.dummy_track.title = d["song"]["title"]
                if "album" in d["song"]:
                    radiobox.dummy_track.album = d["song"]["album"]
                if "artwork_src" in d["song"]:
                    art_url = d["song"]["artwork_src"]
                    art_response = requests.get(art_url)
                    if art_response.status_code == 200:
                        if pctl.radio_image_bin:
                            pctl.radio_image_bin.close()
                            pctl.radio_image_bin = None
                        pctl.radio_image_bin = io.BytesIO(art_response.content)
                        pctl.radio_image_bin.seek(0)
                        radiobox.dummy_track.art_url_key = "ok"
                pctl.update_tag_history()

    # Failure
    elif pctl.radio_image_bin:
        pctl.radio_image_bin.close()
        pctl.radio_image_bin = None

    gui.clear_image_cache_next += 1


# Main class that controls playback (play, pause, stepping, playlists, queue etc). Sends commands to backend.
class PlayerCtl:
    # C-PC
    def __init__(self):

        self.running = True
        self.system = system
        self.macos = macos
        self.windows_native = windows_native
        self.install_directory = install_directory
        self.user_directory = user_directory
        self.config_directory = config_directory

        # Database

        self.master_count = master_count
        self.total_playtime = 0
        self.master_library = master_library
        self.db_inc = random.randint(0, 10000)
        # self.star_library = star_library
        self.LoadClass = LoadClass

        self.gen_codes = gen_codes

        self.shuffle_pools = {}
        self.after_import_flag = False
        self.quick_add_target = None

        self.album_mbid_release_cache = {}
        self.album_mbid_release_group_cache = {}
        self.mbid_image_url_cache = {}

        # Misc player control

        self.url = ""
        # self.save_urls = url_saves
        self.tag_meta = ""
        self.found_tags = {}
        self.encoder_pause = 0

        # Playback

        self.track_queue = QUE
        self.queue_step = playing_in_queue
        self.playing_time = 0
        self.playlist_playing_position = playlist_playing  # track in playlist that is playing
        if self.playlist_playing_position == None:
            self.playlist_playing_position = -1
        self.playlist_view_position = playlist_view_position
        self.selected_in_playlist = selected_in_playlist
        self.target_open = ""
        self.target_object = None
        self.start_time = 0
        self.b_start_time = 0
        self.playerCommand = ""
        self.playerSubCommand = ""
        self.playerCommandReady = False
        self.playing_state = 0
        self.playing_length = 0
        self.jump_time = 0
        self.random_mode = prefs.random_mode
        self.repeat_mode = prefs.repeat_mode
        self.album_repeat_mode = prefs.album_repeat_mode
        self.album_shuffle_mode = prefs.album_shuffle_mode
        # self.album_shuffle_pool = []
        # self.album_shuffle_id = ""
        self.last_playing_time = 0
        self.multi_playlist = multi_playlist
        self.active_playlist_viewing = playlist_active  # the playlist index that is being viewed
        self.active_playlist_playing = playlist_active  # the playlist index that is playing from
        self.force_queue = p_force_queue  # []
        self.pause_queue = False
        self.left_time = 0
        self.left_index = 0
        self.player_volume = volume
        self.new_time = 0
        self.time_to_get = []
        self.a_time = 0
        self.b_time = 0
        # self.playlist_backup = []
        self.active_replaygain = 0
        self.auto_stop = False

        self.record_stream = False
        self.record_title = ""

        # Bass

        self.bass_devices = []
        self.set_device = 0

        self.gst_devices = []  # Display names
        self.gst_outputs = {}  # Display name : (sink, device)

        self.mpris = None
        self.tray_update = None
        self.eq = [0] * 2  # not used
        self.enable_eq = True  # not used

        self.playing_time_int = 0  # playing time but with no decimel

        self.windows_progress = None

        self.finish_transition = False
        # self.queue_target = 0
        self.start_time_target = 0

        self.decode_time = 0
        self.download_time = 0

        self.radio_meta_on = ""

        self.radio_scrobble_trip = True
        self.radio_scrobble_timer = Timer()

        self.radio_image_bin = None
        self.radio_rate_timer = Timer(2)
        self.radio_poll_timer = Timer(2)

        self.volume_update_timer = Timer()
        self.wake_past_time = 0

        self.regen_in_progress = False
        self.notify_in_progress = False

        self.radio_playlists = radio_playlists
        self.radio_playlist_viewing = radio_playlist_viewing
        self.tag_history = {}

        self.commit = None
        self.spot_playing = False

    def notify_change(self):
        self.db_inc += 1
        tauon.bg_save()

    def update_tag_history(self):
        if prefs.auto_rec:
            self.tag_history[radiobox.song_key] = {
                "title": radiobox.dummy_track.title,
                "artist": radiobox.dummy_track.artist,
                "album": radiobox.dummy_track.album,
                # "image": pctl.radio_image_bin
            }

    def radio_progress(self):
        if radiobox.loaded_url and "radio.plaza.one" in radiobox.loaded_url and self.radio_poll_timer.get() > 0:
            self.radio_poll_timer.force_set(-10)
            response = requests.get("https://api.plaza.one/status")

            if response.status_code == 200:
                d = json.loads(response.text)
                if "song" in d:
                    if "artist" in d["song"] and "title" in d["song"]:
                        self.tag_meta = d["song"]["artist"] + " - " + d["song"]["title"]

        if self.tag_meta:
            if self.radio_rate_timer.get() > 7 and self.radio_meta_on != self.tag_meta:
                self.radio_rate_timer.set()
                self.radio_scrobble_trip = False
                self.radio_meta_on = self.tag_meta

                radiobox.dummy_track.art_url_key = ""
                radiobox.dummy_track.title = ""
                radiobox.dummy_track.date = ""
                radiobox.dummy_track.artist = ""
                radiobox.dummy_track.album = ""
                radiobox.dummy_track.lyrics = ""
                radiobox.dummy_track.date = ""

                tags = pctl.found_tags
                if "title" in tags:
                    radiobox.dummy_track.title = tags["title"]
                    if "artist" in tags:
                        radiobox.dummy_track.artist = tags["artist"]
                    if "year" in tags:
                        radiobox.dummy_track.date = tags["year"]
                    if "album" in tags:
                        radiobox.dummy_track.album = tags["album"]

                elif self.tag_meta.count(
                        "-") == 1 and not ":" in self.tag_meta and not "advert" in self.tag_meta.lower():
                    artist, title = self.tag_meta.split("-")
                    radiobox.dummy_track.title = title.strip()
                    radiobox.dummy_track.artist = artist.strip()

                if self.tag_meta:
                    radiobox.song_key = self.tag_meta
                else:
                    radiobox.song_key = radiobox.dummy_track.artist + " - " + radiobox.dummy_track.title

                self.update_tag_history()
                if radiobox.loaded_url not in radiobox.websocket_source_urls:
                    pctl.radio_image_bin = None
                print("NEXT RADIO TRACK")

                try:
                    get_radio_art()
                except:
                    # raise
                    print("Get art error")

                pctl.notify_update(mpris=False)
                if pctl.mpris:
                    pctl.mpris.update(force=True)

                lfm_scrobbler.listen_track(radiobox.dummy_track)
                lfm_scrobbler.start_queue()

            if self.radio_scrobble_trip is False and self.radio_scrobble_timer.get() > 45:
                self.radio_scrobble_trip = True
                lfm_scrobbler.scrob_full_track(copy.deepcopy(radiobox.dummy_track))

    def update_shuffle_pool(self, pl_id):

        new_pool = copy.deepcopy(self.multi_playlist[id_to_pl(pl_id)][2])
        random.shuffle(new_pool)
        self.shuffle_pools[pl_id] = new_pool
        console.print("Refill shuffle pool")

    def notify_update_fire(self):
        if self.mpris is not None:
            self.mpris.update()
        if tauon.update_play_lock is not None:
            tauon.update_play_lock()
        # if self.tray_update is not None:
        #     self.tray_update()
        self.notify_in_progress = False

    def notify_update(self, mpris=True):
        tauon.tray_releases += 1
        try:
            tauon.tray_lock.release()
        except:
            pass

        if mpris and smtc:
            tr = pctl.playing_object()
            if tr:
                state = 0
                if pctl.playing_state == 1:
                    state = 1
                if pctl.playing_state == 2:
                    state = 2
                image_path = ""
                try:
                    image_path = tauon.thumb_tracks.path(tr)
                except:
                    pass
                    #raise

                if image_path is None:
                    image_path = ""

                image_path = image_path.replace("/", "\\")
                #print(image_path)

                sm.update(state, tr.title.encode("utf-16"), len(tr.title), tr.artist.encode("utf-16"), len(tr.artist),
                          image_path.encode("utf-16"), len(image_path))


        if self.mpris is not None and mpris is True:
            while self.notify_in_progress:
                time.sleep(0.01)
            self.notify_in_progress = True
            shoot = threading.Thread(target=self.notify_update_fire)
            shoot.daemon = True
            shoot.start()
        if prefs.art_bg or (gui.mode == 3 and prefs.mini_mode_mode == 5):
            tm.ready("style")

    def get_url(self, track_object):
        if track_object.file_ext == "PLEX":
            return plex.resolve_stream(track_object.url_key), None

        if track_object.file_ext == "JELY":
            return jellyfin.resolve_stream(track_object.url_key)

        if track_object.file_ext == "KOEL":
            return koel.resolve_stream(track_object.url_key)

        if track_object.file_ext == "SUB":
            return subsonic.resolve_stream(track_object.url_key)

        if track_object.file_ext == "TAU":
            return tau.resolve_stream(track_object.url_key), None

        return None, None

    def playing_playlist(self):
        return self.multi_playlist[self.active_playlist_playing][2]

    def playing_ready(self):
        return len(self.track_queue) > 0

    def selected_ready(self):
        return default_playlist and pctl.selected_in_playlist < len(default_playlist)

    def render_playlist(self):

        if taskbar_progress and msys and self.windows_progress:
            self.windows_progress.update(True)
        gui.pl_update = 1

    def show_selected(self):

        if gui.playlist_view_length < 1:
            return 0

        global shift_selection

        for i in range(len(self.multi_playlist[self.active_playlist_viewing][2])):

            if i == pctl.selected_in_playlist:

                if i < pctl.playlist_view_position:
                    pctl.playlist_view_position = i - random.randint(2, int((gui.playlist_view_length / 3) * 2) + int(
                        gui.playlist_view_length / 6))
                    console.print("DEBUG: Position changed show selected (a)")
                elif abs(pctl.playlist_view_position - i) > gui.playlist_view_length:
                    pctl.playlist_view_position = i
                    console.print("DEBUG: Position changed show selected (b)")
                    if i > 6:
                        pctl.playlist_view_position -= 5
                        console.print("DEBUG: Position changed show selected (c)")
                    if i > gui.playlist_view_length * 1 and i + (gui.playlist_view_length * 2) < len(
                            self.multi_playlist[self.active_playlist_viewing][2]) and i > 10:
                        pctl.playlist_view_position = i - random.randint(2, int(gui.playlist_view_length / 3) * 2)
                        console.print("DEBUG: Position changed show selected (d)")
                    break

        self.render_playlist()

        return 0

    # Get track object by id
    def g(self, id):
        return self.master_library[id]
    # Get track object by playlist and index
    def sg(self, i, pl):
        if pl == -1:
            pl = self.active_playlist_viewing
        try:
            playlist = self.multi_playlist[pl][2]
            return self.g(playlist[i])
        except IndexError:
            pass
        return None

    def show_object(self):  # The track to show in the metadata side panel

        target_track = None

        if self.playing_state == 3:
            return radiobox.dummy_track

        if 3 > self.playing_state > 0:
            target_track = self.playing_object()

        elif self.playing_state == 0 and prefs.meta_shows_selected:
            if -1 < pctl.selected_in_playlist < len(self.multi_playlist[self.active_playlist_viewing][2]):
                target_track = self.g(self.multi_playlist[self.active_playlist_viewing][2][pctl.selected_in_playlist])

        elif self.playing_state == 0 and prefs.meta_persists_stop:
            target_track = self.master_library[self.track_queue[self.queue_step]]

        if prefs.meta_shows_selected_always:
            if -1 < pctl.selected_in_playlist < len(self.multi_playlist[self.active_playlist_viewing][2]):
                target_track = self.g(self.multi_playlist[self.active_playlist_viewing][2][pctl.selected_in_playlist])

        return target_track

    def playing_object(self):

        if self.playing_state == 3:
            return radiobox.dummy_track

        if len(self.track_queue) > 0:
            return self.master_library[self.track_queue[self.queue_step]]
        else:
            return None

    def title_text(self):

        line = ""
        track = pctl.playing_object()
        if track:
            title = track.title
            artist = track.artist

            if not title:
                line = clean_string(track.filename)
            else:
                if artist != "":
                    line += artist
                if title != "":
                    if line != "":
                        line += "  -  "
                    line += title

            if pctl.playing_state == 3 and not title and not artist:
                return pctl.tag_meta

        return line

    def show(self):

        global shift_selection

        if not self.track_queue:
            return 0

    def show_current(self, select=True, playing=True, quiet=False, this_only=False, highlight=False, index=None,
                     no_switch=False, folder_list=True):

        # print("show------")
        # print(select)
        # print(playing)
        # print(quiet)
        # print(this_only)
        # print(highlight)
        # print("--------")
        console.print("DEBUG: Position set by show playing")

        global shift_selection

        if spot_ctl.coasting:
            sptr = tauon.dummy_track.misc.get("spotify-track-url")
            if sptr:

                for p in default_playlist:
                    tr = pctl.g(p)
                    if tr.misc.get("spotify-track-url") == sptr:
                        index = tr.index
                        break
                else:
                    for i, pl in enumerate(pctl.multi_playlist):
                        for p in pl[2]:
                            tr = pctl.g(p)
                            if tr.misc.get("spotify-track-url") == sptr:
                                index = tr.index
                                switch_playlist(i)
                                break
                        else:
                            continue
                        break
                    else:
                        return

        if not self.track_queue:
            return 0

        track_index = self.track_queue[self.queue_step]
        if index is not None:
            track_index = index

        # Switch to source playlist
        if not no_switch:
            if self.active_playlist_viewing != self.active_playlist_playing and (
                    track_index not in self.multi_playlist[self.active_playlist_viewing][2]):
                switch_playlist(self.active_playlist_playing)

        if gui.playlist_view_length < 1:
            return 0

        for i in range(len(self.multi_playlist[self.active_playlist_viewing][2])):
            if self.multi_playlist[self.active_playlist_viewing][2][i] == track_index:

                if self.playlist_playing_position < len(self.multi_playlist[self.active_playlist_viewing][2]) and \
                        self.active_playlist_viewing == self.active_playlist_playing and track_index == \
                        self.multi_playlist[self.active_playlist_viewing][2][self.playlist_playing_position] and \
                        i != self.playlist_playing_position:
                    # continue
                    i = self.playlist_playing_position

                if select:
                    pctl.selected_in_playlist = i

                if playing:
                    # Make the found track the playing track
                    self.playlist_playing_position = i
                    self.active_playlist_playing = self.active_playlist_viewing

                vl = gui.playlist_view_length
                if pctl.multi_playlist[pctl.active_playlist_viewing][6] == gui.playlist_current_visible_tracks_id:
                    vl = gui.playlist_current_visible_tracks

                if not (
                        quiet and self.playing_object().length < 15):  # or (abs(pctl.playlist_view_position - i) < vl - 1)):

                    # Align to album if in view range (and folder titles are active)
                    ap = get_album_info(i)[1][0]

                    if not (quiet and pctl.playlist_view_position <= i <= pctl.playlist_view_position + vl) and (
                    not abs(i - ap) > vl - 2) and not pctl.multi_playlist[pctl.active_playlist_viewing][4]:
                        pctl.playlist_view_position = ap

                    else:
                        # Move to a random offset ---

                        if i == pctl.playlist_view_position - 1 and pctl.playlist_view_position > 1:
                            pctl.playlist_view_position -= 1

                        # Move a bit if its just out of range
                        elif pctl.playlist_view_position + vl - 2 == i and i < len(
                                self.multi_playlist[self.active_playlist_viewing][2]) - 5:
                            pctl.playlist_view_position += 3

                        # We know its out of range if above view postion
                        elif i < pctl.playlist_view_position:
                            pctl.playlist_view_position = i - random.randint(2, int((
                                                                                                gui.playlist_view_length / 3) * 2) + int(
                                gui.playlist_view_length / 6))

                        # If its below we need to test if its in view. If playing track in view, don't jump.
                        elif abs(pctl.playlist_view_position - i) >= vl:
                            pctl.playlist_view_position = i
                            if i > 6:
                                pctl.playlist_view_position -= 5
                            if i > gui.playlist_view_length and i + (gui.playlist_view_length * 2) < len(
                                    self.multi_playlist[self.active_playlist_viewing][2]) and i > 10:
                                pctl.playlist_view_position = i - random.randint(2,
                                                                                 int(gui.playlist_view_length / 3) * 2)

                break

        else:  # Search other all other playlists
            if not this_only:
                for i, playlist in enumerate(self.multi_playlist):
                    if track_index in playlist[2]:
                        switch_playlist(i, quiet=True)
                        self.show_current(select, playing, quiet, this_only=True, index=track_index)
                        break

        if pctl.playlist_view_position < 0:
            pctl.playlist_view_position = 0

        # if pctl.playlist_view_position > len(self.multi_playlist[self.active_playlist_viewing][2]) - 1:
        #     print("Run Over")

        if select:
            shift_selection = []

        self.render_playlist()

        if album_mode and not quiet:
            if highlight:
                gui.gallery_animate_highlight_on = goto_album(pctl.selected_in_playlist)
                gallery_select_animate_timer.set()
            else:
                goto_album(pctl.selected_in_playlist)

        if prefs.left_panel_mode == "artist list" and gui.lsp and not quiet:
            artist_list_box.locate_artist(pctl.playing_object())

        if folder_list and prefs.left_panel_mode == "folder view" and gui.lsp and not quiet and not tree_view_box.lock_pl:
            tree_view_box.show_track(pctl.playing_object())

        return 0

    def toggle_mute(self):
        global volume_store
        if pctl.player_volume > 0:
            volume_store = pctl.player_volume
            pctl.player_volume = 0
        else:
            pctl.player_volume = volume_store

        pctl.set_volume()

    def set_volume(self, notify=True):

        if (spot_ctl.coasting or spot_ctl.playing) and not spot_ctl.local and mouse_down:
            # Rate limit network volume change
            t = self.volume_update_timer.get()
            if t < 0.3:
                return

        self.volume_update_timer.set()
        self.playerCommand = 'volume'
        self.playerCommandReady = True
        if notify:
            self.notify_update()

    def revert(self):

        if self.queue_step == 0:
            return

        prev = 0
        while len(self.track_queue) > prev + 1 and prev < 5:
            if self.track_queue[len(self.track_queue) - 1 - prev] == self.left_index:
                self.queue_step = len(self.track_queue) - 1 - prev
                self.jump_time = self.left_time
                self.playing_time = self.left_time
                self.decode_time = self.left_time
                break
            prev += 1
        else:
            self.queue_step -= 1
            self.jump_time = 0
            self.playing_time = 0
            self.decode_time = 0

        if not len(self.track_queue) > self.queue_step >= 0:
            print("ERROR - there is no previous track?")
            return

        self.target_open = pctl.master_library[self.track_queue[self.queue_step]].fullpath
        self.target_object = pctl.master_library[self.track_queue[self.queue_step]]
        self.start_time = pctl.master_library[self.track_queue[self.queue_step]].start_time
        self.start_time_target = self.start_time
        self.playing_length = pctl.master_library[self.track_queue[self.queue_step]].length
        self.playerCommand = 'open'
        self.playerCommandReady = True
        self.playing_state = 1

        if tauon.stream_proxy.download_running:
            tauon.stream_proxy.stop()

        self.show_current()
        self.render_playlist()

    def deduct_shuffle(self, track_id):
        if pctl.multi_playlist and self.random_mode:
            pl = pctl.multi_playlist[pctl.active_playlist_playing]
            id = pl[6]

            if id not in pctl.shuffle_pools:
                self.update_shuffle_pool(pl[6])

            pool = pctl.shuffle_pools[id]
            if not pool:
                del pctl.shuffle_pools[id]
                self.update_shuffle_pool(pl[6])
            pool = pctl.shuffle_pools[id]

            if track_id in pool:
                pool.remove(track_id)


    def play_target_rr(self):
        tm.ready_playback()
        self.playing_length = pctl.master_library[self.track_queue[self.queue_step]].length

        if self.playing_length > 2:
            random_start = random.randrange(1, int(self.playing_length) - 45 if self.playing_length > 50 else int(
                self.playing_length))
        else:
            random_start = 0

        self.playing_time = random_start
        self.target_open = pctl.master_library[self.track_queue[self.queue_step]].fullpath
        self.target_object = pctl.master_library[self.track_queue[self.queue_step]]
        self.start_time = pctl.master_library[self.track_queue[self.queue_step]].start_time
        self.start_time_target = self.start_time
        self.jump_time = random_start
        self.playerCommand = 'open'
        if not prefs.use_jump_crossfade:
            self.playerSubCommand = 'now'
        self.playerCommandReady = True
        self.playing_state = 1
        radiobox.loaded_station = None

        if tauon.stream_proxy.download_running:
            tauon.stream_proxy.stop()

        if update_title:
            update_title_do()

        self.deduct_shuffle(self.target_object.index)

    def play_target(self, gapless=False, jump=False):

        tm.ready_playback()

        # print(self.track_queue)
        self.playing_time = 0
        self.decode_time = 0
        target = pctl.master_library[self.track_queue[self.queue_step]]
        self.target_open = target.fullpath
        self.target_object = target
        self.start_time = target.start_time
        self.start_time_target = self.start_time
        self.playing_length = target.length
        self.last_playing_time = 0
        self.commit = None
        radiobox.loaded_station = None

        if tauon.stream_proxy and tauon.stream_proxy.download_running:
            tauon.stream_proxy.stop()

        if pctl.multi_playlist[pctl.active_playlist_playing][11]:
            t = target.misc.get("position", 0)
            if t:
                self.playing_time = 0
                self.decode_time = 0
                self.jump_time = t

        self.playerCommand = 'open'
        if jump:  # and not prefs.use_jump_crossfade:
            self.playerSubCommand = 'now'

        self.playerCommandReady = True

        self.playing_state = 1
        self.update_change()
        self.deduct_shuffle(target.index)

    def update_change(self):
        if update_title:
            update_title_do()
        self.notify_update()
        hit_discord()
        self.render_playlist()

        if lfm_scrobbler.a_sc:
            lfm_scrobbler.a_sc = False
            self.a_time = 0

        lfm_scrobbler.start_queue()

        if (album_mode or not gui.rsp) and (gui.theme_name == "Carbon" or prefs.colour_from_image):
            target = self.playing_object()
            if target and prefs.colour_from_image and target.parent_folder_path == colours.last_album:
                return

            album_art_gen.display(target, (0, 0), (50, 50), theme_only=True)

    def jump(self, index, pl_position=None, jump=True):

        lfm_scrobbler.start_queue()
        pctl.auto_stop = False

        if self.force_queue and not pctl.pause_queue:
            if self.force_queue[0][4] == 1:
                if pctl.g(self.force_queue[0][0]).parent_folder_path != pctl.g(index).parent_folder_path:
                    del self.force_queue[0]

        if len(self.track_queue) > 0:
            self.left_time = self.playing_time
            self.left_index = self.track_queue[self.queue_step]

            if self.playing_state == 1 and self.left_time > 5 and self.playing_length - self.left_time > 15:
                pctl.master_library[self.left_index].skips += 1

        global playlist_hold
        gui.update_spec = 0
        self.active_playlist_playing = self.active_playlist_viewing
        self.track_queue.append(index)
        self.queue_step = len(self.track_queue) - 1
        playlist_hold = False
        self.play_target(jump=jump)

        if pl_position is not None:
            self.playlist_playing_position = pl_position

        gui.pl_update = 1

    def back(self):

        if self.playing_state < 3 and prefs.back_restarts and pctl.playing_time > 6:
            self.seek_time(0)
            self.render_playlist()
            return

        if spot_ctl.coasting:
            spot_ctl.control("previous")
            spot_ctl.update_timer.set()
            self.playing_time = -2
            self.decode_time = -2
            return

        if len(self.track_queue) > 0:
            self.left_time = self.playing_time
            self.left_index = self.track_queue[self.queue_step]

        gui.update_spec = 0
        # Move up
        if self.random_mode is False and len(self.playing_playlist()) > self.playlist_playing_position > 0:

            if len(self.track_queue) > 0 and self.playing_playlist()[self.playlist_playing_position] != \
                    self.track_queue[
                        self.queue_step]:

                try:
                    p = self.playing_playlist().index(self.track_queue[self.queue_step])
                except:
                    p = random.randrange(len(self.playing_playlist()))
                if p is not None:
                    self.playlist_playing_position = p

            self.playlist_playing_position -= 1
            self.track_queue.append(self.playing_playlist()[self.playlist_playing_position])
            self.queue_step = len(self.track_queue) - 1
            self.play_target(jump=True)

        elif self.random_mode is True and self.queue_step > 0:
            self.queue_step -= 1
            self.play_target(jump=True)
        else:
            print("BACK: NO CASE!")
            self.show_current()

        if self.active_playlist_viewing == self.active_playlist_playing:
            self.show_current(False, True)

        if album_mode:
            goto_album(self.playlist_playing_position)
        if gui.combo_mode and self.active_playlist_viewing == self.active_playlist_playing:
            self.show_current()

        self.render_playlist()
        self.notify_update()
        notify_song()
        lfm_scrobbler.start_queue()
        gui.pl_update += 1

    def stop(self, block=False, run=False):

        self.playerCommand = 'stop'
        if run:
            self.playerCommand = 'runstop'
        if block:
            self.playerSubCommand = "return"

        self.playerCommandReady = True

        try:
            tm.player_lock.release()
        except:
            pass

        self.record_stream = False
        if len(self.track_queue) > 0:
            self.left_time = self.playing_time
            self.left_index = self.track_queue[self.queue_step]
        previous_state = self.playing_state
        self.playing_time = 0
        self.decode_time = 0
        self.playing_state = 0
        self.render_playlist()

        gui.update_spec = 0
        # gui.update_level = True  # Allows visualiser to enter decay sequence
        gui.update = True
        if update_title:
            update_title_do()  # Update title bar text

        if tauon.stream_proxy and tauon.stream_proxy.download_running:
            tauon.stream_proxy.stop()

        if block:
            loop = 0
            sleep_timeout(lambda: self.playerSubCommand != "stopped", 2)
            if tauon.stream_proxy.download_running:
                sleep_timeout(lambda: tauon.stream_proxy.download_running, 2)

        if spot_ctl.playing or spot_ctl.coasting:
            print("Spotify stop")
            spot_ctl.control("stop")

        self.notify_update()
        lfm_scrobbler.start_queue()
        return previous_state

    def pause(self):

        if tauon.spotc and tauon.spotc.running and spot_ctl.playing:
            if self.playing_state == 1:
                self.playerCommand = 'pauseon'
                self.playerCommandReady = True
            elif self.playing_state == 2:
                self.playerCommand = 'pauseoff'
                self.playerCommandReady = True

        if self.playing_state == 3:
            if spot_ctl.coasting:
                if spot_ctl.paused:
                    spot_ctl.control("resume")
                else:
                    spot_ctl.control("pause")
            return

        if spot_ctl.playing:
            if self.playing_state == 2:
                spot_ctl.control("resume")
                self.playing_state = 1
            elif self.playing_state == 1:
                spot_ctl.control("pause")
                self.playing_state = 2
            self.render_playlist()
            return

        if self.playing_state == 1:
            self.playerCommand = 'pauseon'
            self.playing_state = 2
        elif self.playing_state == 2:
            self.playerCommand = 'pauseoff'
            self.playing_state = 1
            notify_song()

        self.playerCommandReady = True

        self.render_playlist()
        self.notify_update()

    def pause_only(self):
        if self.playing_state == 1:
            self.playerCommand = 'pauseon'
            self.playing_state = 2

            self.playerCommandReady = True
            self.render_playlist()
            self.notify_update()

    def play_pause(self):
        if self.playing_state == 3:
            self.stop()
        elif self.playing_state > 0:
            self.pause()
        else:
            self.play()

    def seek_decimal(self, decimal):
        # if self.commit:
        #     return
        if self.playing_state == 1 or self.playing_state == 2 or (self.playing_state == 3 and spot_ctl.coasting):
            if decimal > 1:
                decimal = 1
            elif decimal < 0:
                decimal = 0
            self.new_time = pctl.playing_length * decimal
            # print('seek to:' + str(pctl.new_time))
            self.playerCommand = 'seek'
            self.playerCommandReady = True
            self.playing_time = self.new_time

            if msys and taskbar_progress and self.windows_progress:
                self.windows_progress.update(True)

            if self.mpris is not None:
                self.mpris.seek_do(self.playing_time)

    def seek_time(self, new):
        # if self.commit:
        #     return
        if self.playing_state == 1 or self.playing_state == 2 or (self.playing_state == 3 and spot_ctl.coasting):

            if new > self.playing_length - 0.5:
                self.advance()
                return

            if new < 0.4:
                new = 0

            self.new_time = new
            self.playing_time = new

            self.playerCommand = 'seek'
            self.playerCommandReady = True

            if self.mpris is not None:
                self.mpris.seek_do(self.playing_time)

    def play(self):

        if spot_ctl.playing:
            if self.playing_state == 2:
                self.play_pause()
            return

        # Unpause if paused
        if self.playing_state == 2:
            self.playerCommand = 'pauseoff'
            self.playerCommandReady = True
            self.playing_state = 1
            self.notify_update()

        # If stopped...
        elif pctl.playing_state == 0:

            if radiobox.loaded_station:
                radiobox.start(radiobox.loaded_station)
                return

            # If the queue is empty
            if self.track_queue == [] and len(self.multi_playlist[self.active_playlist_playing][2]) > 0:
                self.track_queue.append(self.multi_playlist[self.active_playlist_playing][2][0])
                self.queue_step = 0
                self.playlist_playing_position = 0
                self.active_playlist_playing = 0

                self.play_target()

            # If the queue is not empty, play?
            elif len(self.track_queue) > 0:
                self.play_target()

        self.render_playlist()

    def spot_test_progress(self):

        if (self.playing_state == 1 or self.playing_state == 2) and spot_ctl.playing:
            th = 5  # the rate to poll the spotify API
            if self.playing_time > self.playing_length:
                th = 1
            if not spot_ctl.paused:
                if spot_ctl.start_timer.get() < 0.5:
                    spot_ctl.progress_timer.set()
                    return
                add_time = spot_ctl.progress_timer.get()
                if add_time > 5:
                    add_time = 0
                self.playing_time += add_time
                self.decode_time = self.playing_time
                # self.test_progress()
                spot_ctl.progress_timer.set()
                if len(self.track_queue) > 0 and 2 > add_time > 0:
                    star_store.add(self.track_queue[self.queue_step], add_time)
            if spot_ctl.update_timer.get() > th:
                spot_ctl.update_timer.set()
                shooter(spot_ctl.monitor)
            else:
                self.test_progress()

        elif self.playing_state == 3 and spot_ctl.coasting:
            th = 7
            if self.playing_time > self.playing_length or self.playing_time < 2.5:
                th = 1
            if spot_ctl.update_timer.get() < th:
                if not spot_ctl.paused:
                    self.playing_time += spot_ctl.progress_timer.get()
                    self.decode_time = self.playing_time
                spot_ctl.progress_timer.set()

            else:
                tauon.spot_ctl.update_timer.set()
                tauon.spot_ctl.update()

    def purge_track(self, track_id, fast=False):  # Remove a track from the database
        # Remove from all playlists
        if not fast:
            for playlist in self.multi_playlist:
                while track_id in playlist[2]:
                    album_dex.clear()
                    playlist[2].remove(track_id)
        # Stop if track is playing track
        if self.track_queue and self.track_queue[self.queue_step] == track_id and self.playing_state != 0:
            self.stop(block=True)
        # Remove from playback history
        while track_id in self.track_queue:
            self.track_queue.remove(track_id)
            self.queue_step -= 1
        # Remove track from force queue
        for i in reversed(range(len(self.force_queue))):
            if self.force_queue[i][0] == track_id:
                del self.force_queue[i]
        del self.master_library[track_id]

    def test_progress(self):

        # Fuzzy reload lastfm for rescrobble
        if lfm_scrobbler.a_sc and self.playing_time < 1:
            lfm_scrobbler.a_sc = False
            self.a_time = 0

        # Update the UI if playing time changes a whole number
        # next_round = int(pctl.playing_time)
        # if self.playing_time_int != next_round:
        #     #if not prefs.power_save:
        #     #gui.update += 1
        #     self.playing_time_int = next_round

        gap_extra = 2  # 2

        if spot_ctl.playing or tauon.chrome_mode:
            gap_extra = 3

        if msys and taskbar_progress and self.windows_progress:
            self.windows_progress.update(True)

        if self.commit is not None:
            return

        if self.playing_state == 1 and pctl.multi_playlist[pctl.active_playlist_playing][11]:
            tr = pctl.playing_object()
            if tr:
                tr.misc["position"] = pctl.decode_time

        if self.playing_state == 1 and self.decode_time + gap_extra >= self.playing_length and self.decode_time > 0.2:

            # Allow some time for spotify playing time to update?
            if spot_ctl.playing and spot_ctl.start_timer.get() < 3:
                return

            # Allow some time for backend to provide a length
            if self.playing_time < 6 and self.playing_length == 0:
                return
            if not spot_ctl.playing and pctl.a_time < 2:
                return

            self.decode_time = 0

            pp = self.playing_playlist()

            if pctl.auto_stop:  # and not pctl.force_queue and not (pctl.force_queue and pctl.pause_queue):
                self.stop(run=True)
                if pctl.force_queue or (not pctl.force_queue and not pctl.random_mode and not pctl.repeat_mode):
                    self.advance(play=False)
                gui.update += 2
                pctl.auto_stop = False

            elif self.force_queue and not self.pause_queue:
                id = self.advance(end=True, quiet=True, dry=True)
                if id is not None:
                    self.start_commit(id)
                    return
                else:
                    self.advance(end=True, quiet=True)



            elif self.repeat_mode is True:

                if self.album_repeat_mode:

                    if self.playlist_playing_position > len(pp) - 1:
                        self.playlist_playing_position = 0  # Hack fix, race condition bug?

                    ti = self.g(pp[self.playlist_playing_position])

                    i = self.playlist_playing_position

                    # Test if next track is in same folder
                    if i + 1 < len(pp):
                        nt = self.g(pp[i + 1])
                        if ti.parent_folder_path == nt.parent_folder_path:
                            # The next track is in the same folder
                            # so advance normally
                            self.advance(quiet=True, end=True)
                            return

                    # We need to backtrack to see where the folder begins
                    i -= 1
                    while i >= 0:
                        nt = self.g(pp[i])
                        if ti.parent_folder_path != nt.parent_folder_path:
                            i += 1
                            break
                        i -= 1
                    if i < 0:
                        i = 0

                    pctl.selected_in_playlist = i
                    shift_selection = [i]

                    self.jump(pp[i], i, jump=False)

                elif prefs.playback_follow_cursor and self.playing_ready() \
                        and self.multi_playlist[pctl.active_playlist_viewing][2][
                    pctl.selected_in_playlist] != self.playing_object().index \
                        and -1 < pctl.selected_in_playlist < len(default_playlist):

                    print("Repeat follow cursor")

                    self.playing_time = 0
                    self.decode_time = 0
                    self.active_playlist_playing = self.active_playlist_viewing
                    self.playlist_playing_position = pctl.selected_in_playlist

                    self.track_queue.append(default_playlist[pctl.selected_in_playlist])
                    self.queue_step = len(self.track_queue) - 1
                    self.play_target(jump=False)
                    self.render_playlist()
                    lfm_scrobbler.start_queue()

                else:
                    id = self.track_queue[self.queue_step]
                    self.commit = id
                    target = self.g(id)
                    self.target_open = target.fullpath
                    self.target_object = target
                    self.start_time = target.start_time
                    self.start_time_target = self.start_time
                    self.playerCommand = 'open'
                    self.playerSubCommand = 'repeat'
                    self.playerCommandReady = True

                    #self.render_playlist()
                    lfm_scrobbler.start_queue()

                    # Reload lastfm for rescrobble
                    if lfm_scrobbler.a_sc:
                        lfm_scrobbler.a_sc = False
                        self.a_time = 0

            elif self.random_mode is False and len(pp) > self.playlist_playing_position + 1 and \
                    self.master_library[pp[self.playlist_playing_position]].is_cue is True \
                    and self.master_library[pp[self.playlist_playing_position + 1]].filename == \
                    self.master_library[pp[self.playlist_playing_position]].filename and int(
                self.master_library[pp[self.playlist_playing_position]].track_number) == int(
                self.master_library[pp[self.playlist_playing_position + 1]].track_number) - 1:

                #  not (self.force_queue and not self.pause_queue) and \

                # We can shave it closer
                if not self.playing_time + 0.1 >= self.playing_length:
                    return

                print("Do transition CUE")
                self.playlist_playing_position += 1
                self.queue_step += 1
                self.track_queue.append(pp[self.playlist_playing_position])
                self.playing_state = 1
                self.playing_time = 0
                self.decode_time = 0
                self.playing_length = self.master_library[self.track_queue[self.queue_step]].length
                self.start_time = self.master_library[self.track_queue[self.queue_step]].start_time
                self.start_time_target = self.start_time
                lfm_scrobbler.start_queue()

                gui.update += 1
                gui.pl_update = 1

                if update_title:
                    update_title_do()
                self.notify_update()
            else:
                # self.advance(quiet=True, end=True)

                id = self.advance(quiet=True, end=True, dry=True)
                if id is not None and not spot_ctl.playing:
                    #print("Commit")
                    self.start_commit(id)
                    return

                self.advance(quiet=True, end=True)
                self.playing_time = 0
                self.decode_time = 0

    def start_commit(self, id, repeat=False):
        self.commit = id
        target = self.g(id)
        self.target_open = target.fullpath
        self.target_object = target
        self.start_time = target.start_time
        self.start_time_target = self.start_time
        self.playerCommand = 'open'
        if repeat:
            self.playerSubCommand = 'repeat'
        self.playerCommandReady = True

    def advance(self, rr=False, quiet=False, inplace=False, end=False, force=False, play=True, dry=False):

        # Spotify remote control mode
        if not dry:
            if spot_ctl.coasting:
                spot_ctl.control("next")
                spot_ctl.update_timer.set()
                self.playing_time = -2
                self.decode_time = -2
                return

        # Temporary Workaround for UI block causing unwanted dragging
        if not dry:
            quick_d_timer.set()

        if prefs.show_current_on_transition:
            quiet = False

        # Trim the history if it gets too long
        while len(self.track_queue) > 250:
            self.queue_step -= 1
            del self.track_queue[0]

        # Save info about the track we are leaving
        if not dry:
            if len(self.track_queue) > 0:
                self.left_time = self.playing_time
                self.left_index = self.track_queue[self.queue_step]

        # Test to register skip (not currently used for anything)
        if not dry:
            if self.playing_state == 1 and 1 < self.left_time < 45:
                pctl.master_library[self.left_index].skips += 1
                # print('skip registered')

        if not dry:
            pctl.playing_time = 0
            pctl.decode_time = 0
            pctl.playing_length = 100
            gui.update_spec = 0

        old = self.queue_step
        end_of_playlist = False

        # Force queue (middle click on track)
        if len(self.force_queue) > 0 and not self.pause_queue:

            q = self.force_queue[0]
            target_index = q[0]

            if q[3] == 1:
                # This is an album type

                if q[4] == 0:
                    # We have not started playing the album yet
                    # So we go to that track
                    # (This is a copy of the track code, but we don't delete the item)

                    if not dry:

                        pl = id_to_pl(q[2])
                        if pl is not None:
                            self.active_playlist_playing = pl

                        if target_index not in self.playing_playlist():
                            del self.force_queue[0]
                            self.advance()
                            return

                    if dry:
                        return target_index

                    self.playlist_playing_position = q[1]
                    self.track_queue.append(target_index)
                    self.queue_step = len(self.track_queue) - 1
                    # self.queue_target = len(self.track_queue) - 1
                    if play:
                        self.play_target(jump=not end)

                    #  Set the flag that we have entered the album
                    self.force_queue[0][4] = 1

                    # This code is mirrored below -------
                    ok_continue = True

                    # Check if we are at end of playlist
                    pl = pctl.multi_playlist[pctl.active_playlist_playing][2]
                    if self.playlist_playing_position > len(pl) - 3:
                        ok_continue = False

                    # Check next song is in album
                    if ok_continue:
                        if self.g(pl[self.playlist_playing_position + 1]).parent_folder_path != pctl.g(
                                target_index).parent_folder_path:
                            ok_continue = False

                    # -----------


                elif q[4] == 1:
                    # We have previously started playing this album

                    # Check to see if we still are:
                    ok_continue = True

                    if pctl.g(target_index).parent_folder_path != pctl.playing_object().parent_folder_path:
                        # Remember to set jumper check this too (leave album if we jump to some other track, i.e. double click))
                        ok_continue = False

                    pl = pctl.multi_playlist[pctl.active_playlist_playing][2]

                    # Check next song is in album
                    if ok_continue:

                        # Check if we are at end of playlist, or already at end of album
                        if self.playlist_playing_position >= len(pl) - 1 or self.playlist_playing_position < len(
                                pl) - 1 and \
                                self.g(pl[self.playlist_playing_position + 1]).parent_folder_path != pctl.g(
                            target_index).parent_folder_path:

                            if dry:
                                return None

                            del self.force_queue[0]
                            self.advance()
                            return


                        # Check if 2 songs down is in album, remove entry in queue if not
                        elif self.playlist_playing_position < len(pl) - 2 and \
                                self.g(pl[self.playlist_playing_position + 2]).parent_folder_path != pctl.g(
                            target_index).parent_folder_path:
                            ok_continue = False

                    # if ok_continue:
                    # We seem to be still in the album. Step down one and play
                    if not dry:
                        self.playlist_playing_position += 1

                    if len(pl) <= self.playlist_playing_position:
                        if dry:
                            return None
                        print("END OF PLAYLIST!")
                        del self.force_queue[0]
                        self.advance()
                        return

                    if dry:
                        return pl[self.playlist_playing_position + 1]
                    self.track_queue.append(pl[self.playlist_playing_position])
                    self.queue_step = len(self.track_queue) - 1
                    # self.queue_target = len(self.track_queue) - 1
                    if play:
                        self.play_target(jump=not end)

                if not ok_continue:
                    # It seems this item has expired, remove it and call advance again

                    if dry:
                        return None

                    print("Remove expired album from queue")
                    del self.force_queue[0]

                    if q[6]:
                        pctl.auto_stop = True
                    if prefs.stop_end_queue and not self.force_queue:
                        pctl.auto_stop = True

                    if queue_box.scroll_position > 0:
                        queue_box.scroll_position -= 1

                        # self.advance()
                        # return

            else:
                # This is track type
                pl = id_to_pl(q[2])
                if not dry:
                    if pl is not None:
                        self.active_playlist_playing = pl

                if target_index not in self.playing_playlist():
                    if dry:
                        return None
                    del self.force_queue[0]
                    self.advance()
                    return

                if dry:
                    return target_index

                self.playlist_playing_position = q[1]
                self.track_queue.append(target_index)
                self.queue_step = len(self.track_queue) - 1
                # self.queue_target = len(self.track_queue) - 1
                if play:
                    self.play_target(jump=not end)
                del self.force_queue[0]
                if q[6]:
                    pctl.auto_stop = True
                if prefs.stop_end_queue and not self.force_queue:
                    pctl.auto_stop = True
                if queue_box.scroll_position > 0:
                    queue_box.scroll_position -= 1

        # Stop if playlist is empty
        elif len(self.playing_playlist()) == 0:
            if dry:
                return None
            self.stop()
            return 0

        # Playback follow cursor
        elif prefs.playback_follow_cursor and self.playing_ready() \
                and self.multi_playlist[pctl.active_playlist_viewing][2][
            pctl.selected_in_playlist] != self.playing_object().index \
                and -1 < pctl.selected_in_playlist < len(default_playlist):

            if dry:
                return default_playlist[pctl.selected_in_playlist]

            self.active_playlist_playing = self.active_playlist_viewing
            self.playlist_playing_position = pctl.selected_in_playlist

            self.track_queue.append(default_playlist[pctl.selected_in_playlist])
            self.queue_step = len(self.track_queue) - 1
            if play:
                self.play_target(jump=not end)

        # If random, jump to random track
        elif (self.random_mode or rr) and len(self.playing_playlist()) > 0 and not (
                self.album_shuffle_mode or prefs.album_shuffle_lock_mode):
            # self.queue_step += 1
            new_step = self.queue_step + 1

            if new_step == len(self.track_queue):

                if self.album_repeat_mode and self.repeat_mode:
                    # Album shuffle mode
                    pp = self.playing_playlist()
                    k = self.playlist_playing_position
                    # ti = self.g(pp[k])
                    ti = self.master_library[self.track_queue[self.queue_step]]

                    if ti.index not in pp:
                        if dry:
                            return None
                        print("No tracks to repeat!")
                        return 0

                    matches = []
                    for i, p in enumerate(pp):

                        if self.g(p).parent_folder_path == ti.parent_folder_path:
                            matches.append((i, p))

                    if matches:
                        # Avoid a repeat of same track
                        if len(matches) > 1 and (k, ti.index) in matches:
                            matches.remove((k, ti.index))

                        i, p = random.choice(matches)  # not used

                        if prefs.true_shuffle:

                            id = ti.parent_folder_path

                            while True:
                                if id in pctl.shuffle_pools:

                                    pool = pctl.shuffle_pools[id]

                                    if not pool:
                                        del pctl.shuffle_pools[id]  # Trigger a refill
                                        continue

                                    ref = pool.pop()
                                    if dry:
                                        pool.append(ref)
                                        return ref[1]
                                    # ref = random.choice(pool)
                                    # pool.remove(ref)

                                    if ref[1] not in pp:  # Check track still in the live playlist
                                        print("Track not in pool")
                                        continue

                                    i, p = ref  # Find position of reference in playlist
                                    break

                                else:
                                    # Refill the pool
                                    random.shuffle(matches)
                                    pctl.shuffle_pools[id] = matches

                                    print("Refill folder shuffle pool")

                        self.playlist_playing_position = i
                        self.track_queue.append(p)

                else:
                    # Normal select from playlist

                    if prefs.true_shuffle:
                        # True shuffle avoids repeats by using a pool

                        pl = pctl.multi_playlist[pctl.active_playlist_playing]
                        id = pl[6]

                        while True:

                            if id in pctl.shuffle_pools:

                                pool = pctl.shuffle_pools[id]

                                if not pool:
                                    del pctl.shuffle_pools[id]  # Trigger a refill
                                    continue

                                ref = pool.pop()
                                if dry:
                                    pool.append(ref)
                                    return ref
                                # ref = random.choice(pool)
                                # pool.remove(ref)

                                if ref not in pl[2]:  # Check track still in the live playlist
                                    continue

                                random_jump = pl[2].index(ref)  # Find position of reference in playlist
                                break

                            else:
                                # Refill the pool
                                self.update_shuffle_pool(pl[6])

                    else:
                        random_jump = random.randrange(len(self.playing_playlist()))  # not used

                    self.playlist_playing_position = random_jump
                    self.track_queue.append(self.playing_playlist()[random_jump])

            if inplace and self.queue_step > 1:
                del self.track_queue[self.queue_step]
            else:
                if dry:
                    return self.track_queue[new_step]
                self.queue_step = new_step

            if rr:
                if dry:
                    return None
                self.play_target_rr()
            else:
                if play:
                    self.play_target(jump=not end)


        # If not random mode, Step down 1 on the playlist
        elif self.random_mode is False and len(self.playing_playlist()) > 0:

            # Stop at end of playlist
            if self.playlist_playing_position == len(self.playing_playlist()) - 1:
                if dry:
                    return None
                if prefs.end_setting == 'stop':
                    self.playing_state = 0
                    self.playerCommand = 'runstop'
                    self.playerCommandReady = True
                    end_of_playlist = True

                elif prefs.end_setting == 'advance' or prefs.end_setting == 'cycle':

                    # If at end playlist and not cycle mode, stop playback
                    if pctl.active_playlist_playing == len(
                            pctl.multi_playlist) - 1 and not prefs.end_setting == 'cycle':
                        self.playing_state = 0
                        self.playerCommand = 'runstop'
                        self.playerCommandReady = True
                        end_of_playlist = True

                    else:

                        p = pctl.active_playlist_playing
                        for i in range(len(pctl.multi_playlist)):

                            k = (p + i + 1) % len(pctl.multi_playlist)

                            # Skip a playlist if empty
                            if not (pctl.multi_playlist[k][2]):
                                continue

                            # Skip a playlist if hidden
                            if pctl.multi_playlist[k][8] and prefs.tabs_on_top:
                                continue

                            # Set found playlist as playing the first track
                            pctl.active_playlist_playing = k
                            pctl.playlist_playing_position = -1
                            pctl.advance(end=end, force=True, play=play)
                            break

                        else:
                            # Restart current if no other eligible playlist found
                            pctl.playlist_playing_position = -1
                            pctl.advance(end=end, force=True, play=play)

                        return

                elif prefs.end_setting == 'repeat':
                    pctl.playlist_playing_position = -1
                    pctl.advance(end=end, force=True, play=play)
                    return

                gui.update += 3

            else:
                if self.playlist_playing_position > len(self.playing_playlist()) - 1:
                    if dry:
                        return None
                    self.playlist_playing_position = 0

                elif not force and len(self.track_queue) > 0 and self.playing_playlist()[
                    self.playlist_playing_position] != self.track_queue[
                    self.queue_step]:
                    try:
                        if dry:
                            return None
                        self.playlist_playing_position = self.playing_playlist().index(
                            self.track_queue[self.queue_step])
                    except:
                        pass

                if len(self.playing_playlist()) == self.playlist_playing_position + 1:
                    return

                if dry:
                    return self.playing_playlist()[self.playlist_playing_position + 1]
                self.playlist_playing_position += 1
                self.track_queue.append(self.playing_playlist()[self.playlist_playing_position])

                # print("standand advance")
                # self.queue_target = len(self.track_queue) - 1
                # if end:
                #     self.play_target_gapless(jump= not end)
                # else:
                self.queue_step = len(self.track_queue) - 1
                if play:
                    self.play_target(jump=not end)

        else:

            if self.random_mode and (self.album_shuffle_mode or prefs.album_shuffle_lock_mode):

                # Album shuffle mode
                print("Album shuffle mode")

                po = self.playing_object()

                redraw = False

                # Checks
                if po is not None and len(self.playing_playlist()) > 0:

                    # If we at end of playlist, we'll go to a new album
                    if len(self.playing_playlist()) == self.playlist_playing_position + 1:
                        redraw = True
                    # If the next track is a new album, go to a new album
                    elif po.parent_folder_path != pctl.g(
                            self.playing_playlist()[self.playlist_playing_position + 1]).parent_folder_path:
                        redraw = True
                    # Always redraw on press in album shuffle lockdown
                    if prefs.album_shuffle_lock_mode and not end:
                        redraw = True

                    if not redraw:
                        if dry:
                            return self.playing_playlist()[self.playlist_playing_position + 1]
                        self.playlist_playing_position += 1
                        self.track_queue.append(self.playing_playlist()[self.playlist_playing_position])
                        self.queue_step = len(self.track_queue) - 1
                        # self.queue_target = len(self.track_queue) - 1
                        if play:
                            self.play_target(jump=not end)

                    else:

                        if dry:
                            return None
                        albums = []
                        current_folder = ""
                        for i in range(len(self.playing_playlist())):
                            if i == 0:
                                albums.append(i)
                                current_folder = self.master_library[self.playing_playlist()[i]].parent_folder_path
                            else:
                                if pctl.master_library[self.playing_playlist()[i]].parent_folder_path != current_folder:
                                    current_folder = self.master_library[self.playing_playlist()[i]].parent_folder_path
                                    albums.append(i)

                        random.shuffle(albums)

                        for a in albums:

                            if self.g(self.playing_playlist()[
                                          a]).parent_folder_path != self.playing_object().parent_folder_path:
                                self.playlist_playing_position = a
                                self.track_queue.append(self.playing_playlist()[a])
                                self.queue_step = len(self.track_queue) - 1
                                # self.queue_target = len(self.track_queue) - 1
                                if play:
                                    self.play_target(jump=not end)
                                break
                            else:
                                a = 0
                                self.playlist_playing_position = a
                                self.track_queue.append(self.playing_playlist()[a])
                                self.queue_step = len(self.track_queue) - 1
                                if play:
                                    self.play_target(jump=not end)
                                # print("THERS ONLY ONE ALBUM IN THE PLAYLIST")
                                # self.stop()

            else:
                print("ADVANCE ERROR - NO CASE!")

        if dry:
            return None

        if self.active_playlist_viewing == self.active_playlist_playing:
            self.show_current(quiet=quiet)
        elif prefs.auto_goto_playing:
            self.show_current(quiet=quiet, this_only=True, playing=False, highlight=True, no_switch=True)

        # if album_mode:
        #     goto_album(self.playlist_playing)

        self.render_playlist()

        if spot_ctl.playing and end_of_playlist:
            spot_ctl.control("stop")

        self.notify_update()
        lfm_scrobbler.start_queue()
        if play:
            notify_song(end_of_playlist, delay=1.3)

    def reset_missing_flags(self):
        for value in self.master_library.values():
            value.found = True
        gui.pl_update += 1


pctl = PlayerCtl()

notify_change = pctl.notify_change


def auto_name_pl(target_pl):
    if not pctl.multi_playlist[target_pl][2]:
        return

    albums = []
    artists = []
    parents = []

    track = None

    for index in pctl.multi_playlist[target_pl][2]:
        track = pctl.g(index)
        albums.append(track.album)
        if track.album_artist:
            artists.append(track.album_artist)
        else:
            artists.append(track.artist)
        parents.append(track.parent_folder_path)

    nt = ""
    artist = ""

    if track:
        artist = track.artist
        if track.album_artist:
            artist = track.album_artist

    if track and albums and albums[0] and albums.count(albums[0]) == len(albums):
        nt = artist + " - " + track.album

    elif track and artists and artists[0] and artists.count(artists[0]) == len(artists):
        nt = artists[0]

    else:
        nt = os.path.basename(commonprefix(parents))

    pctl.multi_playlist[target_pl][0] = nt


def get_object(index):
    return pctl.master_library[index]


def update_title_do():
    if pctl.playing_state > 0:
        if len(pctl.track_queue) > 0:
            line = pctl.master_library[pctl.track_queue[pctl.queue_step]].artist + " - " + \
                   pctl.master_library[pctl.track_queue[pctl.queue_step]].title
            # line += "   : :   Tauon Music Box"
            line = line.encode('utf-8')
            SDL_SetWindowTitle(t_window, line)
    else:
        line = "Tauon Music Box"
        line = line.encode('utf-8')
        SDL_SetWindowTitle(t_window, line)


def open_encode_out():
    if system == 'windows' or msys:
        line = r'explorer ' + prefs.encoder_output.replace("/", "\\")
        subprocess.Popen(line)
    else:
        line = prefs.encoder_output
        line += "/"
        if macos:
            subprocess.Popen(['open', line])
        else:
            subprocess.Popen(['xdg-open', line])


def g_open_encode_out(a, b, c):
    open_encode_out()


#

if system == 'linux' and not macos and not msys:

    try:
        Notify.init("Tauon Music Box")
        g_tc_notify = Notify.Notification.new("Tauon Music Box",
                                              "Transcoding has finished.")
        value = GLib.Variant("s", t_id)
        g_tc_notify.set_hint("desktop-entry", value)

        g_tc_notify.add_action(
            "action_click",
            "Open Output Folder",
            g_open_encode_out,
            None
        )

        de_notify_support = True

    except:
        print("Failed init notifications")

    if de_notify_support:
        song_notification = Notify.Notification.new("Next track notification")
        value = GLib.Variant("s", t_id)
        song_notification.set_hint("desktop-entry", value)


def notify_song_fire(notification, delay, id):
    time.sleep(delay)
    notification.show()
    if id is None:
        return

    time.sleep(8)
    if id == gui.notify_main_id:
        notification.close()


def notify_song(notify_of_end=False, delay=0.0):
    if not de_notify_support:
        return

    if notify_of_end and prefs.end_setting != "stop":
        return

    if prefs.show_notifications and pctl.playing_object() is not None and not window_is_focused():
        if prefs.stop_notifications_mini_mode and gui.mode == 3:
            return

        track = pctl.playing_object()

        if not track or not (track.title or track.artist or track.album or track.filename):
            return  # only display if we have at least one piece of metadata avaliable

        i_path = ""
        try:
            if not notify_of_end:
                i_path = thumb_tracks.path(track)
        except:
            print(track.fullpath.encode('utf-8', 'replace').decode("utf-8"))
            print("Thumbnail error")

        top_line = track.title

        if prefs.notify_include_album:
            bottom_line = (track.artist + " | " + track.album).strip("| ")
        else:
            bottom_line = track.artist

        if not track.title:
            a, t = filename_to_metadata(clean_string(track.filename))
            if not track.artist:
                bottom_line = a
            top_line = t

        gui.notify_main_id = uid_gen()
        id = gui.notify_main_id

        if notify_of_end:
            bottom_line = "Tauon Music Box"
            top_line = _("End of playlist")
            id = None

        song_notification.update(top_line, bottom_line, i_path)

        shoot_dl = threading.Thread(target=notify_song_fire, args=([song_notification, delay, id]))
        shoot_dl.daemon = True
        shoot_dl.start()


# Last.FM -----------------------------------------------------------------
class LastFMapi:
    API_SECRET = "6e433964d3ff5e817b7724d16a9cf0cc"
    connected = False
    API_KEY = "bfdaf6357f1dddd494e5bee1afe38254"
    scanning_username = ""

    network = None
    lastfm_network = None
    tries = 0

    scanning_friends = False
    scanning_loves = False
    scanning_scrobbles = False

    def __init__(self):
        self.sg = None
        self.url = None

    def get_network(self):
        if prefs.use_libre_fm:
            return pylast.LibreFMNetwork
        else:
            return pylast.LastFMNetwork

    def auth1(self):
        if not last_fm_enable:
            show_message("Optional module python-pylast not installed", mode='warning')
            return
        # This is step one where the user clicks "login"

        if self.network is None:
            self.no_user_connect()

        self.sg = pylast.SessionKeyGenerator(self.network)
        self.url = self.sg.get_web_auth_url()
        show_message(_("Web auth page opened"), _("Once authorised click the 'done' button."), mode='arrow')
        webbrowser.open(self.url, new=2, autoraise=True)

    def auth2(self):

        # This is step 2 where the user clicks "Done"

        if self.sg is None:
            show_message(_("You need to log in first"))
            return

        try:
            # session_key = self.sg.get_web_auth_session_key(self.url)
            session_key, username = self.sg.get_web_auth_session_key_username(self.url)
            prefs.last_fm_token = session_key
            self.network = self.get_network()(api_key=self.API_KEY, api_secret=
            self.API_SECRET, session_key=prefs.last_fm_token)
            # user = self.network.get_authenticated_user()
            # username = user.get_name()
            prefs.last_fm_username = username

        except Exception as e:
            if 'Unauthorized Token' in str(e):
                show_message("Error - Not authorized", mode='error')
            else:
                show_message("Error", 'Unknown error.', mode='error')

        if not toggle_lfm_auto(mode=1):
            toggle_lfm_auto()

    def auth3(self):

        # This is used for "logout"

        prefs.last_fm_token = None
        prefs.last_fm_username = ""
        show_message("Logout will complete on app restart.")

    def connect(self, m_notify=True):

        if not last_fm_enable:
            return False

        if self.connected is True:
            if m_notify:
                show_message("Already connected to Last.fm")
            return True

        if prefs.last_fm_token is None:
            show_message("No Last.Fm account registered", "Authorise an account in settings", mode='info')
            return

        print('Attempting to connect to Last.fm network')

        try:

            self.network = self.get_network()(api_key=self.API_KEY, api_secret=
            self.API_SECRET, session_key=prefs.last_fm_token)  # , username=lfm_username, password_hash=lfm_hash)

            self.connected = True
            if m_notify:
                show_message("Connection to Last.fm was successful.", mode='done')

            print('Connection to lastfm appears successful')
            return True

        except Exception as e:
            show_message("Error connecting to Last.fm network", str(e), mode='warning')
            # print(e)
            return False

    def toggle(self):
        prefs.scrobble_hold ^= True

    def details_ready(self):
        if prefs.last_fm_token:
            return True
        else:
            return False

    def last_fm_only_connect(self):
        if not last_fm_enable:
            return False
        try:
            self.lastfm_network = pylast.LastFMNetwork(api_key=self.API_KEY, api_secret=self.API_SECRET)
            print('Connection appears successful')
            return True

        except Exception as e:
            show_message("Error communicating with Last.fm network", str(e), mode='warning')
            print(e)
            return False

    def no_user_connect(self):
        if not last_fm_enable:
            return False
        try:
            self.network = self.get_network()(api_key=self.API_KEY, api_secret=self.API_SECRET)
            print('Connection appears successful')
            return True

        except Exception as e:
            show_message("Error communicating with Last.fm network", str(e), mode='warning')
            print(e)
            return False

    def get_all_scrobbles_estimate_time(self):

        if not self.connected:
            self.connect(False)
        if not self.connected or not prefs.last_fm_username:
            return

        user = pylast.User(prefs.last_fm_username, self.network)
        total = user.get_playcount()

        if total:
            return 0.04364 * total
        return 0

    def get_all_scrobbles(self):

        if not self.connected:
            self.connect(False)
        if not self.connected or not prefs.last_fm_username:
            return

        try:
            self.scanning_scrobbles = True
            self.network.enable_rate_limit()
            user = pylast.User(prefs.last_fm_username, self.network)
            # username = user.get_name()
            perf_timer.set()
            tracks = user.get_recent_tracks(None)

            counts = {}

            # Count up the unique pairs
            for track in tracks:
                key = (str(track.track.artist), str(track.track.title))
                c = counts.get(key, 0)
                counts[key] = c + 1

            touched = []

            # Add counts to matching tracks
            for key, value in counts.items():
                artist, title = key
                artist = artist.lower()
                title = title.lower()

                for track in pctl.master_library.values():
                    t_artist = track.artist.lower()
                    artists = [x.lower() for x in get_split_artists(track)]
                    if t_artist == artist or artist in artists or (
                            track.album_artist and track.album_artist.lower() == artist):
                        if track.title.lower() == title:
                            if track.index in touched:
                                track.lfm_scrobbles += value
                            else:
                                track.lfm_scrobbles = value
                                touched.append(track.index)
        except:
            gui.pl_update += 1
            # raise
            self.scanning_scrobbles = False
            show_message(_("Scanning failed. Try again?"), mode="error")
            return

        print(perf_timer.get())
        gui.pl_update += 1
        self.scanning_scrobbles = False
        tauon.bg_save()
        show_message(_("Scanning scrobbles complete"), mode="done")

    def artist_info(self, artist):

        if self.lastfm_network is None:
            if self.last_fm_only_connect() is False:
                return False, "", ""

        try:
            if artist != "":
                l_artist = pylast.Artist(
                    artist.replace("/", "").replace("\\", "").replace(" & ", " and ").replace("&", " "),
                    self.lastfm_network)
                bio = l_artist.get_bio_content()
                # cover_link = l_artist.get_cover_image()
                mbid = l_artist.get_mbid()
                url = l_artist.get_url()

                return True, bio, "", mbid, url
        except:
            print("last.fm get artist info failed")

        return False, "", "", "", ""

    def artist_mbid(self, artist):

        if self.lastfm_network is None:
            if self.last_fm_only_connect() is False:
                return ""

        try:
            if artist != "":
                l_artist = pylast.Artist(
                    artist.replace("/", "").replace("\\", "").replace(" & ", " and ").replace("&", " "),
                    self.lastfm_network)
                mbid = l_artist.get_mbid()
                return mbid
        except:
            print("last.fm get artist mbid info failed")

        return ""

    def sync_pull_love(self, track_object):
        if not prefs.lastfm_pull_love or not (track_object.artist and track_object.title):
            return
        if not last_fm_enable:
            return
        if prefs.auto_lfm:
            self.connect(False)
        if not self.connected:
            return

        try:
            track = self.network.get_track(track_object.artist, track_object.title)
            if not track:
                print("Get love: track not found")
                return
            track.username = prefs.last_fm_username

            remote_loved = track.get_userloved()

            if track_object.title != track.get_correction() or track_object.artist != track.get_artist().get_correction():
                print(f"Pylast/lastfm bug workaround. API thought {track_object.artist} - {track_object.title} loved status was: {remote_loved}")
                return

            if remote_loved is None:
                print("Error getting loved status")
                return

            local_loved = love(set=False, track_id=track_object.index, notify=False, sync=False)

            if remote_loved != local_loved:
                love(set=True, track_id=track_object.index, notify=False, sync=False)
        except:
            print("Failed to pull love")

    def scrobble(self, track_object, timestamp=None):
        if not last_fm_enable:
            return True
        if prefs.scrobble_hold:
            return True
        if prefs.auto_lfm:
            self.connect(False)

        if timestamp is None:
            timestamp = int(time.time())

        # lastfm_user = self.network.get_user(self.username)

        title = track_object.title
        album = track_object.album
        artist = get_artist_strip_feat(track_object)
        album_artist = track_object.album_artist

        print("submitting scrobble...")

        # Act
        try:
            if title != "" and artist != "":
                if album != "":
                    if album_artist and album_artist != artist:
                        self.network.scrobble(artist=artist, title=title, album=album, album_artist=album_artist,
                                              timestamp=timestamp)
                    else:
                        self.network.scrobble(artist=artist, title=title, album=album, timestamp=timestamp)
                else:
                    self.network.scrobble(artist=artist, title=title, timestamp=timestamp)
                # print('Scrobbled')

                # Pull loved status

                self.sync_pull_love(track_object)


            else:
                print("Not sent, incomplete metadata")

        except Exception as e:

            if 'retry' in str(e):
                print("Retrying...")
                time.sleep(7)

                try:
                    self.network.scrobble(artist=artist, title=title, timestamp=timestamp)
                    # print('Scrobbled')
                    return True
                except:
                    pass

            # show_message("Error: Could not scrobble. ", str(e), mode='warning')
            console.print("Error connecting to last.fm", level=5)
            console.print("-- " + str(e), level=5)
            scrobble_warning_timer.set()
            gui.update += 1
            gui.delay_frame(5)

            # print(e)
            return False
        return True

    def get_bio(self, artist):

        if self.lastfm_network is None:
            if self.last_fm_only_connect() is False:
                return ""

        artist_object = pylast.Artist(artist, self.lastfm_network)
        bio = artist_object.get_bio_summary(language="en")
        # print(artist_object.get_cover_image())
        # print("\n\n")
        # print(bio)
        # print("\n\n")
        # print(artist_object.get_bio_content())
        return bio
        # else:
        #    return ""

    def love(self, artist, title):

        if not self.connected and prefs.auto_lfm:
            self.connect(False)
            prefs.scrobble_hold = True
        if self.connected and artist != "" and title != "":
            track = self.network.get_track(artist, title)
            track.love()

    def unlove(self, artist, title):
        if not last_fm_enable:
            return
        if not self.connected and prefs.auto_lfm:
            self.connect(False)
            prefs.scrobble_hold = True
        if self.connected and artist != "" and title != "":
            track = self.network.get_track(artist, title)
            track.love()
            track.unlove()

    def clear_friends_love(self):

        count = 0
        for index, tr in pctl.master_library.items():
            count += len(tr.lfm_friend_likes)
            tr.lfm_friend_likes.clear()

        show_message("Removed {} loves.".format(count))

    def get_friends_love(self):
        if not last_fm_enable:
            return
        self.scanning_friends = True

        try:
            username = prefs.last_fm_username
            print(f"Username is {username}")

            if not username:
                self.scanning_friends = False
                show_message("There was an error, try re-log in")
                return

            if self.network is None:
                self.no_user_connect()

            self.network.enable_rate_limit()
            lastfm_user = self.network.get_user(username)
            friends = lastfm_user.get_friends(limit=None)
            show_message(_("Getting friend data..."), _("This may take a very long time."), mode='info')
            for friend in friends:
                self.scanning_username = friend.name
                print("Getting friend loves: " + friend.name)

                try:
                    loves = friend.get_loved_tracks(limit=None)
                except:
                    continue

                for track in loves:
                    title = track.track.title.casefold()
                    artist = track.track.artist.name.casefold()
                    for index, tr in pctl.master_library.items():

                        if tr.title.casefold() == title and tr.artist.casefold() == artist:
                            tr.lfm_friend_likes.add(friend.name)
                            print("MATCH")
                            print("     " + artist + " - " + title)
                            print("      ----- " + friend.name)

        except:
            show_message("There was an error getting friends loves", "", mode='warning')

        self.scanning_friends = False

    def dl_love(self):
        if not last_fm_enable:
            return
        username = prefs.last_fm_username
        show_message(_("Scanning loved tracks for: %s" % username), mode="info")
        self.scanning_username = username

        if not username:
            show_message("No username found", mode='error')
            return

        if len(username) > 25:
            print("abort due to long username")
            return

        self.scanning_loves = True

        print("Connect for friend scan")

        try:
            if self.network is None:
                self.no_user_connect()

            self.network.enable_rate_limit()
            print("Get user...")
            lastfm_user = self.network.get_user(username)
            tracks = lastfm_user.get_loved_tracks(limit=None)

            matches = 0
            updated = 0

            for track in tracks:
                title = track.track.title.casefold()
                artist = track.track.artist.name.casefold()

                for index, tr in pctl.master_library.items():
                    if tr.title.casefold() == title and tr.artist.casefold() == artist:
                        matches += 1
                        print("MATCH:")
                        print("     " + artist + " - " + title)
                        star = star_store.full_get(index)
                        if star is None:
                            star = star_store.new_object()
                        if "L" not in star[1]:
                            updated += 1
                            print("     NEW LOVE")
                            star[1] += "L"

                        star_store.insert(index, star)

            self.scanning_loves = False
            if len(tracks) == 0:
                show_message("User has no loved tracks.")
                return
            if matches > 0 and updated == 0:
                show_message(str(matches) + " matched tracks are up to date.")
                return
            if matches > 0 and updated > 0:
                show_message(str(matches) + " tracks matched. " + str(updated) + " were updated.")
                return
            else:
                show_message("Of " + str(len(tracks)) + " loved tracks, no matches were found in local db")
                return
        except:
            show_message("This doesn't seem to be working :(", mode='error')
        self.scanning_loves = False

    def update(self, track_object):
        if not last_fm_enable:
            return
        if prefs.scrobble_hold:
            return 0
        if prefs.auto_lfm:
            if self.connect(False) is False:
                prefs.auto_lfm = False
        else:
            return 0

        # print('Updating Now Playing')

        title = track_object.title
        album = track_object.album
        artist = get_artist_strip_feat(track_object)

        try:
            if title != "" and artist != "":
                self.network.update_now_playing(
                    artist=artist, title=title, album=album)
                return 0
            else:
                print("Not sent, incomplete metadata")
                return 0
        except Exception as e:

            console.print("Error connecting to last.fm.", level=3)
            console.print("-- " + str(e), level=3)
            # print(e)
            if 'retry' in str(e):
                return 2
                # show_message("Could not update Last.fm. ", str(e), mode='warning')
            pctl.b_time -= 5000
            return 1


def get_backend_time(path):
    pctl.time_to_get = path

    pctl.playerCommand = 'time'
    pctl.playerCommandReady = True

    while pctl.playerCommand != 'done':
        time.sleep(0.005)

    return pctl.time_to_get


lastfm = LastFMapi()


class ListenBrainz:

    def __init__(self):

        self.enable = prefs.enable_lb
        # self.url = "https://api.listenbrainz.org/1/submit-listens"

    def url(self):
        url = prefs.listenbrainz_url
        if not url:
            url = "https://api.listenbrainz.org/"
        if not url.endswith("/"):
            url += "/"
        return url + "1/submit-listens"

    def listen_full(self, track_object, time):

        if self.enable is False:
            return True
        if prefs.scrobble_hold is True:
            return True
        if prefs.lb_token is None:
            show_message("ListenBrains is enabled but there is no token.", "How did this even happen.", mode='error')

        title = track_object.title
        album = track_object.album
        artist = get_artist_strip_feat(track_object)

        if title == "" or artist == "":
            return True

        data = {"listen_type": "single", "payload": []}
        metadata = {"track_name": title, "artist_name": artist}

        additional = {}

        # MusicBrainz Artist IDs
        if 'musicbrainz_artistids' in track_object.misc:
            additional['artist_mbids'] = track_object.misc['musicbrainz_artistids']

        # MusicBrainz Release ID
        if 'musicbrainz_albumid' in track_object.misc:
            additional['release_mbid'] = track_object.misc['musicbrainz_albumid']

        # MusicBrainz Recording ID
        if 'musicbrainz_recordingid' in track_object.misc:
            additional['recording_mbid'] = track_object.misc['musicbrainz_recordingid']

        # MusicBrainz Track ID
        if 'musicbrainz_trackid' in track_object.misc:
            additional['track_mbid'] = track_object.misc['musicbrainz_trackid']

        if additional:
            metadata['additional_info'] = additional

        # print(additional)
        data["payload"].append({"track_metadata": metadata})
        data["payload"][0]["listened_at"] = time

        r = requests.post(self.url(), headers={"Authorization": "Token " + prefs.lb_token}, data=json.dumps(data))
        if r.status_code != 200:
            show_message("There was an error submitting data to ListenBrainz", r.text, mode='warning')
            return False
        return True

    def listen_playing(self, track_object):
        if self.enable is False:
            return
        if prefs.scrobble_hold is True:
            return
        if prefs.lb_token is None:
            show_message("ListenBrains is enabled but there is no token.", "How did this even happen.", mode='error')
        title = track_object.title
        album = track_object.album
        artist = get_artist_strip_feat(track_object)

        if title == "" or artist == "":
            return

        data = {"listen_type": "playing_now", "payload": []}
        metadata = {"track_name": title, "artist_name": artist}

        additional = {}

        # MusicBrainz Artist IDs
        if 'musicbrainz_artistids' in track_object.misc:
            additional['artist_mbids'] = track_object.misc['musicbrainz_artistids']

        # MusicBrainz Release ID
        if 'musicbrainz_albumid' in track_object.misc:
            additional['release_mbid'] = track_object.misc['musicbrainz_albumid']

        # MusicBrainz Recording ID
        if 'musicbrainz_recordingid' in track_object.misc:
            additional['recording_mbid'] = track_object.misc['musicbrainz_recordingid']

        # MusicBrainz Track ID
        if 'musicbrainz_trackid' in track_object.misc:
            additional['track_mbid'] = track_object.misc['musicbrainz_trackid']

        if additional:
            metadata['additional_info'] = additional

        data["payload"].append({"track_metadata": metadata})
        # data["payload"][0]["listened_at"] = int(time.time())

        r = requests.post(self.url(), headers={"Authorization": "Token " + prefs.lb_token}, data=json.dumps(data))
        if r.status_code != 200:
            show_message("There was an error submitting data to ListenBrainz", r.text, mode='warning')
            print("error")
            print(r.status_code)
            print(r.json())

    def paste_key(self):

        text = copy_from_clipboard()
        if text == "":
            show_message("There is no text in the clipboard", mode="error")
            return

        if prefs.listenbrainz_url:
            prefs.lb_token = text
            return

        if len(text) == 36 and text[8] == "-":
            prefs.lb_token = text
        else:
            show_message("That is not a valid token.", mode='error')

    def clear_key(self):

        prefs.lb_token = ""
        save_prefs()
        self.enable = False


lb = ListenBrainz()


def get_love(track_object):
    star = star_store.full_get(track_object.index)
    if star is None:
        return False

    if 'L' in star[1]:
        return True
    else:
        return False


def get_love_index(index):
    star = star_store.full_get(index)
    if star is None:
        return False

    if 'L' in star[1]:
        return True
    else:
        return False

def get_love_timestamp_index(index):
    star = star_store.full_get(index)
    if star is None:
        return 0
    return star[3]

def love(set=True, track_id=None, no_delay=False, notify=False, sync=True):
    if len(pctl.track_queue) < 1:
        return False

    if track_id is not None and track_id < 0:
        return False

    if track_id is None:
        track_id = pctl.track_queue[pctl.queue_step]

    loved = False
    star = star_store.full_get(track_id)

    if star is not None:
        if 'L' in star[1]:
            loved = True

    if set is False:
        return loved

    # global lfm_username
    # if len(lfm_username) > 0 and not lastfm.connected and not prefs.auto_lfm:
    #     show_message("You have a last.fm account ready but it is not enabled.", 'info',
    #                  'Either connect, enable auto connect, or remove the account.')
    #     return

    if star is None:
        star = star_store.new_object()

    loved ^= True

    if notify:
        gui.toast_love_object = pctl.g(track_id)
        gui.toast_love_added = loved
        toast_love_timer.set()
        gui.delay_frame(1.81)

    delay = 0.3
    if no_delay or not sync or not lastfm.details_ready():
        delay = 0

    star[3] = time.time()

    if loved:
        time.sleep(delay)
        gui.update += 1
        gui.pl_update += 1
        star[1] = star[1] + "L" # = [star[0], star[1] + "L", star[2]]
        star_store.insert(track_id, star)
        if sync:
            if prefs.last_fm_token:
                try:
                    lastfm.love(pctl.master_library[track_id].artist, pctl.master_library[track_id].title)
                except:
                    show_message(_("Failed updating last.fm love status"), mode='warning')
                    star[1] = star[1].replace("L", "") # = [star[0], star[1].strip("L"), star[2]]
                    star_store.insert(track_id, star)
                    show_message(_("Error updating love to last.fm!"),
                                 _("Maybe check your internet connection and try again?"), mode="error")

            if pctl.master_library[track_id].file_ext == "JELY":
                jellyfin.favorite(pctl.master_library[track_id])

    else:
        time.sleep(delay)
        gui.update += 1
        gui.pl_update += 1
        star[1] = star[1].replace("L", "")
        star_store.insert(track_id, star)
        if sync:
            if prefs.last_fm_token:
                try:
                    lastfm.unlove(pctl.master_library[track_id].artist, pctl.master_library[track_id].title)
                except:
                    show_message("Failed updating last.fm love status", mode='warning')
                    star[1] = star[1] + "L"
                    star_store.insert(track_id, star)
            if pctl.master_library[track_id].file_ext == "JELY":
                jellyfin.favorite(pctl.master_library[track_id], un=True)

    gui.pl_update = 2
    gui.update += 1
    if sync and pctl.mpris is not None:
        pctl.mpris.update(force=True)


def maloja_get_scrobble_counts():
    if lastfm.scanning_scrobbles is True or not prefs.maloja_url:
        return

    url = prefs.maloja_url
    if not url.endswith("/"):
        url += "/"
    url += "apis/mlj_1/scrobbles"
    lastfm.scanning_scrobbles = True
    try:
        r = requests.get(url)

        if r.status_code != 200:
            show_message("There was an error with the Maloja server", r.text, mode='warning')
            lastfm.scanning_scrobbles = False
            return
    except:
        show_message("There was an error reaching the Maloja server", mode='warning')
        lastfm.scanning_scrobbles = False
        return

    try:
        data = json.loads(r.text)
        l = data["list"]

        counts = {}

        for item in l:
            artists = item.get("artists")
            title = item.get("title")
            if title and artists:
                key = (title, tuple(artists))
                c = counts.get(key, 0)
                counts[key] = c + 1

        touched = []

        for key, value in counts.items():
            title, artists = key
            artists = [x.lower() for x in artists]
            title = title.lower()
            for track in pctl.master_library.values():
                if track.artist.lower() in artists and track.title.lower() == title:
                    if track.index in touched:
                        track.lfm_scrobbles += value
                    else:
                        track.lfm_scrobbles = value
                        touched.append(track.index)
        show_message(_("Scanning scrobbles complete"), mode="done")

    except:
        show_message("There was an error parsing the data", mode="warning")

    gui.pl_update += 1
    lastfm.scanning_scrobbles = False
    tauon.bg_save()


def maloja_scrobble(track):
    url = prefs.maloja_url

    if not track.artist or not track.title:
        return

    if not url.endswith("/newscrobble"):
        if not url.endswith("/"):
            url += "/"
        url += "apis/mlj_1/newscrobble"

    d = {}
    d["artist"] = track.artist
    d["title"] = track.title
    d["key"] = prefs.maloja_key

    try:
        r = requests.post(url, data=d)
        if r.status_code != 200:
            show_message("There was an error submitting data to Maloja server", r.text, mode='warning')
            return False
    except:
        show_message("There was an error submitting data to Maloja server", mode='warning')
        return False
    return True


class LastScrob:

    def __init__(self):

        self.a_index = -1
        self.a_sc = False
        self.a_pt = False
        self.queue = []
        self.running = False

    def start_queue(self):

        self.running = True
        mini_t = threading.Thread(target=self.process_queue)
        mini_t.daemon = True
        mini_t.start()

    def process_queue(self):

        time.sleep(0.4)

        while self.queue:

            try:
                tr = self.queue.pop()

                gui.pl_update = 1
                print("Submit Scrobble " + tr[0].artist + " - " + tr[0].title)

                success = True

                if tr[2] == "lfm" and prefs.auto_lfm and (lastfm.connected or lastfm.details_ready()):
                    success = lastfm.scrobble(tr[0], tr[1])
                elif tr[2] == "lb" and lb.enable:
                    success = lb.listen_full(tr[0], tr[1])
                elif tr[2] == "maloja":
                    success = maloja_scrobble(tr[0])
                elif tr[2] == "air":
                    success = subsonic.listen(tr[0], submit=True)
                elif tr[2] == "koel":
                    success = koel.listen(tr[0], submit=True)

                if not success:
                    print("Re-queue scrobble")
                    self.queue.append(tr)
                    time.sleep(10)
                    break

            except:
                print("SCROBBLE QUEUE ERROR")
                # raise

        if not self.queue:
            scrobble_warning_timer.force_set(1000)

        self.running = False

    def update(self, add_time):

        if pctl.queue_step > len(pctl.track_queue) - 1:
            print("Queue step error 1")
            return

        if self.a_index != pctl.track_queue[pctl.queue_step]:
            pctl.a_time = 0
            pctl.b_time = 0
            self.a_index = pctl.track_queue[pctl.queue_step]
            self.a_pt = False
            self.a_sc = False
        if pctl.playing_time == 0 and self.a_sc is True:
            print("Reset scrobble timer")
            pctl.a_time = 0
            pctl.b_time = 0
            self.a_pt = False
            self.a_sc = False

        if pctl.a_time > 6 and self.a_pt is False and pctl.master_library[self.a_index].length > 30:
            self.a_pt = True
            self.listen_track(pctl.master_library[self.a_index])
            # if prefs.auto_lfm and (lastfm.connected or lastfm.details_ready()) and not prefs.scrobble_hold:
            #     mini_t = threading.Thread(target=lastfm.update, args=([pctl.master_library[self.a_index]]))
            #     mini_t.daemon = True
            #     mini_t.start()
            #
            # if lb.enable and not prefs.scrobble_hold:
            #     mini_t = threading.Thread(target=lb.listen_playing, args=([pctl.master_library[self.a_index]]))
            #     mini_t.daemon = True
            #     mini_t.start()

        if pctl.a_time > 6 and self.a_pt:
            pctl.b_time += add_time
            if pctl.b_time > 20:
                pctl.b_time = 0
                self.listen_track(pctl.master_library[self.a_index])

        send_full = False
        if pctl.master_library[self.a_index].length > 30 and pctl.a_time > pctl.master_library[self.a_index].length \
                * 0.50 and self.a_sc is False:
            self.a_sc = True
            send_full = True

        if self.a_sc is False and pctl.master_library[self.a_index].length > 30 and pctl.a_time > 240:
            self.a_sc = True
            send_full = True

        if send_full:
            self.scrob_full_track(pctl.master_library[self.a_index])

    def listen_track(self, track_object):
        # print("LISTEN")

        if track_object.is_network:
            if track_object.file_ext == "SUB":
                subsonic.listen(track_object, submit=False)

        if not prefs.scrobble_hold:
            if prefs.auto_lfm and (lastfm.connected or lastfm.details_ready()):
                mini_t = threading.Thread(target=lastfm.update, args=([track_object]))
                mini_t.daemon = True
                mini_t.start()

            if lb.enable:
                mini_t = threading.Thread(target=lb.listen_playing, args=([track_object]))
                mini_t.daemon = True
                mini_t.start()

    def scrob_full_track(self, track_object):
        # print("SCROBBLE")
        track_object.lfm_scrobbles += 1
        gui.pl_update += 1

        if track_object.is_network:
            if track_object.file_ext == "SUB":
                self.queue.append((track_object, int(time.time()), "air"))
            if track_object.file_ext == "KOEL":
                self.queue.append((track_object, int(time.time()), "koel"))

        if not prefs.scrobble_hold:
            if prefs.auto_lfm and (lastfm.connected or lastfm.details_ready()):
                self.queue.append((track_object, int(time.time()), "lfm"))
            if lb.enable:
                self.queue.append((track_object, int(time.time()), "lb"))
            if prefs.maloja_url and prefs.maloja_enable:
                self.queue.append((track_object, int(time.time()), "maloja"))


lfm_scrobbler = LastScrob()

from t_modules.t_draw import TDraw
from t_modules.t_draw import QuickThumbnail

QuickThumbnail.renderer = renderer


class Strings:

    def __init__(self):
        self.spotify_likes = _("Spotify Likes")
        self.spotify_albums = _("Spotify Albums")
        self.spotify_un_liked = _("Track removed from liked tracks")
        self.spotify_already_un_liked = _("Track was already un-liked")
        self.spotify_already_liked = _("Track is already liked")
        self.spotify_like_added = _("Track added to liked tracks")
        self.spotify_account_connected = _("Spotify account connected")
        self.spotify_not_playing = _("This Spotify account isn't currently playing anything")
        self.spotify_error_starting = _("Error starting Spotify")
        self.spotify_request_auth = _("Please authorise Spotify in settings!")
        self.spotify_need_enable = _("Please authorise and click the enable toggle first!")
        self.spotify_import_complete = _("Spotify import complete")

        self.day = _("day")
        self.days = _("days")

        self.scan_chrome = _("Scanning for Chromecasts...")
        self.cast_to = _("Cast to: %s")
        self.no_chromecasts = _("No Chromecast devices found")
        self.stop_cast = _("End Cast")

        self.web_server_stopped = _("Web server stopped.")

        self.menu_open_tauon = _("Open Tauon Music Box")
        self.menu_play_pause = _("Play/Pause")
        self.menu_next = _("Next Track")
        self.menu_previous = _("Previous Track")
        self.menu_quit = _("Quit")



strings = Strings()


def id_to_pl(id):
    for i, item in enumerate(pctl.multi_playlist):
        if item[6] == id:
            return i
    return None


def pl_to_id(pl):
    return pctl.multi_playlist[pl][6]


class Chunker:

    def __init__(self):
        self.master_count = 0
        self.chunks = {}
        self.header = None
        self.headers = []
        self.h2 = None

        self.clients = {}

from t_modules.t_webserve import webserve2
from t_modules.t_webserve import webserve
from t_modules.t_webserve import authserve
from t_modules.t_webserve import controller
from t_modules.t_webserve import stream_proxy

class MenuIcon:

    def __init__(self, asset):
        self.asset = asset
        self.colour = [170, 170, 170, 255]
        self.base_asset = None
        self.base_asset_mod = None
        self.colour_callback = None
        self.mode_callback = None
        self.xoff = 0
        self.yoff = 0

class MenuItem:
    __slots__ = [
        "title",           # 0
        "is_sub_menu",     # 1
        "func",            # 2
        "render_func",     # 3
        "no_exit",         # 4
        "pass_ref",        # 5
        "hint",            # 6
        "icon",            # 7
        "show_test",       # 8
        "pass_ref_deco",   # 9
        "disable_test",    # 10
        "set_ref",         # 11
        "args",            # 12
        "sub_menu_number", # 13
        "sub_menu_width",  # 14
    ]
    def __init__(self, title, func, render_func=None, no_exit=False, pass_ref=False, hint=None, icon=None, show_test=None,
            pass_ref_deco=False, disable_test=None, set_ref=None, is_sub_menu=False, args=None, sub_menu_number=None, sub_menu_width=0):
        self.title = title
        self.is_sub_menu = is_sub_menu
        self.func = func
        self.render_func = render_func
        self.no_exit = no_exit
        self.pass_ref = pass_ref
        self.hint = hint
        self.icon = icon
        self.show_test = show_test
        self.pass_ref_deco = pass_ref_deco
        self.disable_test = disable_test
        self.set_ref = set_ref
        self.args = args
        self.sub_menu_number = sub_menu_number
        self.sub_menu_width = sub_menu_width


class Tauon:

    def __init__(self):

        self.t_title = t_title
        self.t_version = t_version
        self.t_agent = t_agent
        self.t_id = t_id
        self.desktop = desktop
        self.device = socket.gethostname()

        self.cachement = None
        self.dummy_event = SDL_Event()
        self.translate = _
        self.strings = strings
        self.pctl = pctl
        self.lfm_scrobbler = lfm_scrobbler
        self.star_store = star_store
        self.gui = gui
        self.prefs = prefs
        self.cache_directory = cache_directory
        self.temp_audio = os.path.join(cache_directory, "stream-audio")
        self.user_directory = user_directory
        self.music_directory = music_directory
        self.worker_save_state = False
        self.launch_prefix = launch_prefix
        self.whicher = whicher
        self.load_orders = load_orders
        self.switch_playlist = None
        self.open_uri = open_uri
        self.love = love
        self.snap_mode = snap_mode
        self.console = console
        self.msys = msys
        self.TrackClass = TrackClass
        self.pl_gen = pl_gen
        self.QuickThumbnail = QuickThumbnail
        self.pl_to_id = pl_to_id
        self.id_to_pl = id_to_pl
        self.chunker = Chunker()
        self.stream_proxy = None
        self.stream_proxy = StreamEnc(self)
        self.level_train = []
        self.radio_server = None
        self.mod_formats = MOD_Formats
        self.listen_alongers = {}

        self.tray_lock = threading.Lock()
        self.tray_releases = 0

        self.play_lock = None
        self.update_play_lock = None
        self.sleep_lock = None
        self.shutdown_lock = None
        self.quick_close = False

        self.copied_track = None
        self.macos = macos
        self.aud = None

        self.recorded_songs = []
        self.ca = None
        if pyinstaller_mode:
            self.ca = os.path.join(install_directory, "certifi", "cacert.pem")

        self.chrome_mode = False
        self.web_running = False
        self.web_thread = None
        self.remote_limited = True
        self.enable_librespot = shutil.which("librespot")

        self.spotc = None
        self.librespot_p = None
        self.MenuItem = MenuItem
        self.tag_scan = tag_scan

        self.gme_formats = GME_Formats

    def start_remote(self):

        if not self.web_running:
            self.web_thread = threading.Thread(target=webserve2,
                                          args=[pctl, prefs, gui, album_art_gen, install_directory, strings, tauon])
            self.web_thread.daemon = True
            self.web_thread.start()
            self.web_running = True

    def download_ffmpeg(self, x):
        def go():
            url = "https://github.com/GyanD/codexffmpeg/releases/download/5.0.1/ffmpeg-5.0.1-essentials_build.zip"
            sha = "9e00da9100ae1bba22b1385705837392e8abcdfd2efc5768d447890d101451b5"
            show_message("Starting download...")
            try:
                f = io.BytesIO()
                r = requests.get(url, stream=True)

                dl = 0
                for data in r.iter_content(chunk_size=4096):
                    dl += len(data)
                    f.write(data)
                    mb = round(dl / 1000 / 1000)
                    if mb > 90:
                        break
                    if mb % 5 == 0:
                        show_message(f"Downloading... {mb}/80MB")

            except Exception as e:
                show_message("Download failed", str(e), mode="error")

            f.seek(0)
            if not hashlib.sha256(f.read()).hexdigest() == sha:
                show_message("Download completed but checksum failed", mode="error")
                return
            show_message("Download completed.. extracting")
            f.seek(0)
            z = zipfile.ZipFile(f, mode="r")
            exe = z.open("ffmpeg-5.0.1-essentials_build/bin/ffmpeg.exe")
            ff = open(os.path.join(user_directory, "ffmpeg.exe"), 'wb')
            ff.write(exe.read())
            ff.close()

            exe = z.open("ffmpeg-5.0.1-essentials_build/bin/ffprobe.exe")
            ff = open(os.path.join(user_directory, "ffprobe.exe"), 'wb')
            ff.write(exe.read())
            ff.close()

            exe.close()
            show_message("FFMPEG fetch complete", mode="done")

        shooter(go)

    def set_tray_icons(self, force=False):

        indicator_icon_play = os.path.join(pctl.install_directory, "assets/svg/tray-indicator-play.svg")
        indicator_icon_pause = os.path.join(pctl.install_directory, "assets/svg/tray-indicator-pause.svg")
        indicator_icon_default = os.path.join(pctl.install_directory, "assets/svg/tray-indicator-default.svg")

        if prefs.tray_theme == "gray":
            indicator_icon_play = os.path.join(pctl.install_directory, "assets/svg/tray-indicator-play-g1.svg")
            indicator_icon_pause = os.path.join(pctl.install_directory, "assets/svg/tray-indicator-pause-g1.svg")
            indicator_icon_default = os.path.join(pctl.install_directory, "assets/svg/tray-indicator-default-g1.svg")

        user_icon_dir = os.path.join(self.cache_directory, "icon-export")
        def install_tray_icon(src, name):
            alt = os.path.join(user_icon_dir, f"{name}.svg")
            if not os.path.isfile(alt) or force:
                shutil.copy(src, alt)

        if not os.path.isdir(user_icon_dir):
            os.makedirs(user_icon_dir)

        install_tray_icon(indicator_icon_play, "tray-indicator-play")
        install_tray_icon(indicator_icon_pause, "tray-indicator-pause")
        install_tray_icon(indicator_icon_default, "tray-indicator-default")

    def get_tray_icon(self, name):
        return os.path.join(self.cache_directory, f"icon-export/{name}.svg")

    def test_ffmpeg(self):
        if self.get_ffmpeg():
            return True
        if msys:
            show_message("This feature requires FFMPEG. Shall I can download that for you? (80MB)", mode="confirm")
            gui.message_box_confirm_callback = self.download_ffmpeg
            gui.message_box_confirm_reference = (None,)
        else:
            show_message("FFMPEG could not be found")

    def get_ffmpeg(self):
        p = shutil.which("ffmpeg")
        if p: return p
        p = os.path.join(user_directory, "ffmpeg.exe")
        if msys and os.path.isfile(p): return p
        return None

    def get_ffprobe(self):
        p = shutil.which("ffprobe")
        if p: return p
        p = os.path.join(user_directory, "ffprobe.exe")
        if msys and os.path.isfile(p): return p
        return None

    def bg_save(self):
        self.worker_save_state = True
        tm.ready("worker")

    def exit(self, reason):
        print("Shutting down. Reason: " + reason)
        pctl.running = False
        self.wake()

    def min_to_tray(self):
        SDL_HideWindow(t_window)
        gui.mouse_unknown = True

    def raise_window(self):
        SDL_ShowWindow(t_window)
        SDL_RaiseWindow(t_window)
        SDL_RestoreWindow(t_window)
        gui.lowered = False
        gui.update += 1

    def focus_window(self):
        SDL_RaiseWindow(t_window)

    def get_playing_playlist_id(self):
        return pl_to_id(pctl.active_playlist_playing)

    def wake(self):
        SDL_PushEvent(ctypes.byref(self.dummy_event))


tauon = Tauon()

deco = Deco(tauon)
deco.get_themes = get_themes
deco.renderer = renderer

if prefs.backend != 4:
    prefs.backend = 4

chrome = None

try:
    from t_modules.t_chrome import Chrome

    chrome = Chrome(tauon)
except:
    print("Pychromecast not found")
tauon.chrome = chrome

class PlexService:

    def __init__(self):
        self.connected = False
        self.resource = None
        self.scanning = False

    def connect(self):

        if not prefs.plex_username or not prefs.plex_password or not prefs.plex_servername:
            show_message(_("Missing username, password and/or server name"), mode='warning')
            self.scanning = False
            return

        try:
            from plexapi.myplex import MyPlexAccount
        except:
            show_message("Error importing python-plexapi", mode='error')
            self.scanning = False
            return

        try:
            account = MyPlexAccount(prefs.plex_username, prefs.plex_password)
            self.resource = account.resource(prefs.plex_servername).connect()  # returns a PlexServer instance
        except:
            show_message(_("Error connecting to PLEX server"),
                         _("Try check login credentials and that server is accessible."), mode='error')
            self.scanning = False
            return

        # from plexapi.server import PlexServer
        # baseurl = 'http://localhost:32400'
        # token = ''

        # self.resource = PlexServer(baseurl, token)

        self.connected = True

    def resolve_stream(self, location):
        print("Get plex stream")
        if not self.connected:
            self.connect()

        # return self.resource.url(location, True)
        return self.resource.library.fetchItem(location).getStreamURL()

    def resolve_thumbnail(self, location):

        if not self.connected:
            self.connect()
        if self.connected:
            return self.resource.url(location, True)
        return None

    def get_albums(self, return_list=False):

        gui.update += 1
        self.scanning = True

        if not self.connected:
            self.connect()

        if not self.connected:
            self.scanning = False
            return []

        playlist = []

        existing = {}
        for track_id, track in pctl.master_library.items():
            if track.is_network and track.file_ext == "PLEX":
                existing[track.url_key] = track_id

        albums = self.resource.library.section('Music').albums()
        gui.to_got = 0

        for album in albums:
            year = album.year
            album_artist = album.parentTitle
            album_title = album.title

            parent = (album_artist + " - " + album_title).strip("- ")

            for track in album.tracks():

                if not track.duration:
                    print(
                        "Warning: Skipping track with invalid duration - " + track.title + " - " + track.grandparentTitle)
                    continue

                id = pctl.master_count
                replace_existing = False

                e = existing.get(track.key)
                if e is not None:
                    id = e
                    replace_existing = True

                title = track.title
                track_artist = track.grandparentTitle
                duration = track.duration / 1000

                nt = TrackClass()
                nt.index = id
                nt.track_number = track.index
                nt.file_ext = "PLEX"
                nt.parent_folder_path = parent
                nt.parent_folder_name = parent
                nt.album_artist = album_artist
                nt.artist = track_artist
                nt.title = title
                nt.album = album_title
                nt.length = duration
                if hasattr(track, "locations") and track.locations:
                    nt.fullpath = track.locations[0]

                nt.is_network = True

                if track.thumb:
                    nt.art_url_key = track.thumb

                nt.url_key = track.key
                nt.date = str(year)

                pctl.master_library[id] = nt

                if not replace_existing:
                    pctl.master_count += 1

                playlist.append(nt.index)

            gui.to_got += 1
            gui.update += 1
            gui.pl_update += 1

        self.scanning = False

        if return_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="PLEX Collection", playlist=playlist))
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "plex path"
        switch_playlist(len(pctl.multi_playlist) - 1)


plex = PlexService()
tauon.plex = plex

from t_modules.t_jellyfin import Jellyfin

jellyfin = Jellyfin(tauon)
tauon.jellyfin = jellyfin


class SubsonicService:

    def __init__(self):
        self.scanning = False
        self.playlists = prefs.subsonic_playlists

    def r(self, point, p=None, binary=False, get_url=False):
        salt = secrets.token_hex(8)
        server = prefs.subsonic_server.rstrip("/") + "/"

        params = {
            "u": prefs.subsonic_user,
            'v': "1.13.0",
            'c': t_title,
            'f': "json"
        }

        if prefs.subsonic_password_plain:
            params["p"] = prefs.subsonic_password
        else:
            params["t"] = hashlib.md5((prefs.subsonic_password + salt).encode()).hexdigest()
            params['s'] = salt

        if p:
            params.update(p)

        point = "rest/" + point

        url = server + point

        if get_url:
            return url, params

        response = requests.get(url, params=params)

        if binary:
            return response.content

        d = json.loads(response.text)
        # print(d)

        if d["subsonic-response"]["status"] != "ok":
            show_message("Subsonic Error: " + response.text, mode="warning")
            print("Subsonic Error: " + response.text)

        return d

    def get_cover(self, track_object):
        response = self.r("getCoverArt", p={"id": track_object.art_url_key}, binary=True)
        return io.BytesIO(response)

    def resolve_stream(self, key):

        p = {"id": key}
        if prefs.network_stream_bitrate > 0:
            p['maxBitRate'] = prefs.network_stream_bitrate

        return self.r("stream", p={"id": key}, get_url=True)
        # print(responce.content)

    def listen(self, track_object, submit=False):

        try:
            a = self.r("scrobble", p={"id": track_object.url_key, "submission": submit})
        except:
            print("Error connect for scrobble on airsonic")
        return True

    def set_rating(self, track_object, rating):

        try:
            a = self.r("setRating", p={"id": track_object.url_key, "rating": math.ceil(rating / 2)})
        except:
            print("Error connect for set rating on airsonic")
        return True

    def set_album_rating(self, track_object, rating):
        id = track_object.misc.get("subsonic-folder-id")
        if id is not None:
            try:
                a = self.r("setRating", p={"id": id, "rating": math.ceil(rating / 2)})
            except:
                print("Error connect for set rating on airsonic")
        return True

    def get_music3(self, return_list=False):

        self.scanning = True
        gui.to_got = 0

        existing = {}

        for track_id, track in pctl.master_library.items():
            if track.is_network and track.file_ext == "SUB":
                existing[track.url_key] = track_id

        try:
            a = self.r("getIndexes")
        except:
            show_message("Error connecting to Airsonic server", mode="error")
            self.scanning = False
            return []

        b = a["subsonic-response"]["indexes"]["index"]

        folders = []

        for letter in b:
            artists = letter["artist"]
            for artist in artists:
                folders.append((
                    artist["id"],
                    artist["name"]
                ))

        playlist = []

        songsets = []
        for i in range(len(folders)):
            songsets.append([])
        statuses = [0] * len(folders)
        dupes = []

        def getsongs(index, folder_id, name, inner=False, parent=None):

            try:
                d = self.r("getMusicDirectory", p={"id": folder_id})
                if "child" not in d["subsonic-response"]["directory"]:
                    if not inner:
                        statuses[index] = 2
                    return

            except json.decoder.JSONDecodeError:
                print("Error reading Airsonic directory")
                if not inner:
                    statuses[index] = 2
                show_message("Error reading Airsonic directory!", mode="warning")
                return

            items = d["subsonic-response"]["directory"]["child"]

            gui.update = 2

            for item in items:

                if item["isDir"]:

                    if "userRating" in item and "artist" in item:
                        rating = item["userRating"]
                        if album_star_store.get_rating_artist_title(item["artist"], item["title"]) == 0 and rating == 0:
                            pass
                        else:
                            album_star_store.set_rating_artist_title(item["artist"], item["title"], int(rating * 2))

                    getsongs(index, item["id"], item["title"], inner=True, parent=item)
                    continue

                gui.to_got += 1
                song = item
                nt = TrackClass()

                if parent and "artist" in parent:
                    nt.album_artist = parent["artist"]

                if "title" in song:
                    nt.title = song["title"]
                if "artist" in song:
                    nt.artist = song["artist"]
                if "album" in song:
                    nt.album = song["album"]
                if "track" in song:
                    nt.track_number = song["track"]
                if "year" in song:
                    nt.date = str(song["year"])
                if "duration" in song:
                    nt.length = song["duration"]

                nt.file_ext = "SUB"
                nt.parent_folder_name = name
                if "path" in song:
                    nt.fullpath = song["path"]
                    nt.parent_folder_path = os.path.dirname(song["path"])
                if "coverArt" in song:
                    nt.art_url_key = song["id"]
                nt.url_key = song["id"]
                nt.misc["subsonic-folder-id"] = folder_id
                nt.is_network = True

                rating = 0
                if "userRating" in song:
                    rating = int(song["userRating"])

                songsets[index].append((nt, name, song["id"], rating))

            if inner:
                return
            statuses[index] = 2

        i = -1
        for id, name in folders:
            i += 1
            while statuses.count(1) > 3:
                time.sleep(0.1)

            statuses[i] = 1
            t = threading.Thread(target=getsongs, args=([i, id, name]))
            t.daemon = True
            t.start()

        while statuses.count(2) != len(statuses):
            time.sleep(0.1)

        for sset in songsets:
            for nt, name, song_id, rating in sset:

                id = pctl.master_count

                replace_existing = False
                ex = existing.get(song_id)
                if ex is not None:
                    id = ex
                    replace_existing = True

                nt.index = id
                pctl.master_library[id] = nt
                if not replace_existing:
                    pctl.master_count += 1

                playlist.append(nt.index)

                if star_store.get_rating(nt.index) == 0 and rating == 0:
                    pass
                else:
                    star_store.set_rating(nt.index, rating * 2)

        self.scanning = False
        if return_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="Airsonic Collection", playlist=playlist))
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "air"
        switch_playlist(len(pctl.multi_playlist) - 1)

    # def get_music2(self, return_list=False):
    #
    #     self.scanning = True
    #     gui.to_got = 0
    #
    #     existing = {}
    #
    #     for track_id, track in pctl.master_library.items():
    #         if track.is_network and track.file_ext == "SUB":
    #             existing[track.url_key] = track_id
    #
    #     try:
    #         a = self.r("getIndexes")
    #     except:
    #         show_message("Error connecting to Airsonic server", mode="error")
    #         self.scanning = False
    #         return []
    #
    #     b = a["subsonic-response"]["indexes"]["index"]
    #
    #     folders = []
    #
    #     for letter in b:
    #         artists = letter["artist"]
    #         for artist in artists:
    #             folders.append((
    #                 artist["id"],
    #                 artist["name"]
    #             ))
    #
    #     playlist = []
    #
    #     def get(folder_id, name):
    #
    #         try:
    #             d = self.r("getMusicDirectory", p={"id": folder_id})
    #             if "child" not in d["subsonic-response"]["directory"]:
    #                 return
    #
    #         except json.decoder.JSONDecodeError:
    #             print("Error reading Airsonic directory")
    #             show_message("Error reading Airsonic directory!", mode="warning")
    #             return
    #
    #         items = d["subsonic-response"]["directory"]["child"]
    #
    #         gui.update = 1
    #
    #         for item in items:
    #
    #             gui.to_got += 1
    #
    #             if item["isDir"]:
    #                 get(item["id"], item["title"])
    #                 continue
    #
    #             song = item
    #             id = pctl.master_count
    #
    #             replace_existing = False
    #             ex = existing.get(song["id"])
    #             if ex is not None:
    #                 id = ex
    #                 replace_existing = True
    #
    #             nt = TrackClass()
    #
    #             if "title" in song:
    #                 nt.title = song["title"]
    #             if "artist" in song:
    #                 nt.artist = song["artist"]
    #             if "album" in song:
    #                 nt.album = song["album"]
    #             if "track" in song:
    #                 nt.track_number = song["track"]
    #             if "year" in song:
    #                 nt.date = str(song["year"])
    #             if "duration" in song:
    #                 nt.length = song["duration"]
    #
    #             # if "bitRate" in song:
    #             #     nt.bitrate = song["bitRate"]
    #
    #             nt.file_ext = "SUB"
    #
    #             nt.index = id
    #
    #             nt.parent_folder_name = name
    #             if "path" in song:
    #                 nt.fullpath = song["path"]
    #                 nt.parent_folder_path = os.path.dirname(song["path"])
    #
    #             if "coverArt" in song:
    #                 nt.art_url_key = song["id"]
    #
    #             nt.url_key = song["id"]
    #             nt.is_network = True
    #
    #             pctl.master_library[id] = nt
    #
    #             if not replace_existing:
    #                 pctl.master_count += 1
    #
    #             playlist.append(nt.index)
    #
    #     for id, name in folders:
    #         get(id, name)
    #
    #     self.scanning = False
    #     if return_list:
    #         return playlist
    #
    #     pctl.multi_playlist.append(pl_gen(title="Airsonic Collection", playlist=playlist))
    #     pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "air"
    #     switch_playlist(len(pctl.multi_playlist) - 1)


subsonic = SubsonicService()


class KoelService:

    def __init__(self):
        self.connected = False
        self.resource = None
        self.scanning = False
        self.server = ""

        self.token = ""

    def connect(self):

        print("Connect to koel...")
        if not prefs.koel_username or not prefs.koel_password or not prefs.koel_server_url:
            show_message(_("Missing username, password and/or server URL"), mode='warning')
            self.scanning = False
            return

        if self.token:
            self.connected = True
            print("Already authorised")
            return

        password = prefs.koel_password
        username = prefs.koel_username
        server = prefs.koel_server_url
        self.server = server

        target = server + "/api/me"

        headers = {
            "Accept": "application/json",
            "Content-Type": "application/json",
        }
        body = {
            "email": username,
            "password": password,
        }

        try:
            r = requests.post(target, json=body, headers=headers)
        except:
            gui.show_message(_("Could not establish connection"), mode="error")
            print("Could not establish connection")
            return

        if r.status_code == 200:
            # print(r.json())
            self.token = r.json()["token"]
            if self.token:
                print("GOT KOEL TOKEN")
                self.connected = True

            else:
                print("AUTH ERROR")

        else:
            error = ""
            j = r.json()
            if "message" in j:
                error = j["message"]

            gui.show_message(_("Could not establish connection/authorisation"), error, mode="error")


    def resolve_stream(self, id):

        if not self.connected:
            self.connect()

        if prefs.network_stream_bitrate > 0:
            target = f"{self.server}/api/{id}/play/1/{prefs.network_stream_bitrate}"
        else:
            target = f"{self.server}/api/{id}/play/0/0"
        params = {"jwt-token": self.token, }

        # if prefs.network_stream_bitrate > 0:
        #     target = f"{self.server}/api/play/{id}/1/{prefs.network_stream_bitrate}"
        # else:
        #target = f"{self.server}/api/play/{id}/0/0"
        #target = f"{self.server}/api/{id}/play"

        #params = {"token": self.token, }

        #target = f"{self.server}/api/download/songs"
        #params["songs"] = [id,]
        print(target)
        print(urllib.parse.urlencode(params))

        return target, params

    def listen(self, track_object, submit=False):
        if submit:
            try:
                target = self.server + "/api/interaction/play"
                headers = {
                    "Authorization": "Bearer " + self.token,
                    "Accept": "application/json",
                    "Content-Type": "application/json",
                }

                r = requests.post(target, headers=headers, json={"song": track_object.url_key})
                # print(r.status_code)
                # print(r.text)
            except:
                print("error submitting listen to koel")

    def get_albums(self, return_list=False):

        gui.update += 1
        self.scanning = True

        if not self.connected:
            self.connect()

        if not self.connected:
            self.scanning = False
            return []

        playlist = []

        target = self.server + "/api/data"
        headers = {
            "Authorization": "Bearer " + self.token,
            "Accept": "application/json",
            "Content-Type": "application/json",
        }

        r = requests.get(target, headers=headers)
        data = r.json()

        artists = data["artists"]
        albums = data["albums"]
        songs = data["songs"]

        artist_ids = {}
        for artist in artists:
            id = artist["id"]
            if id not in artist_ids:
                artist_ids[id] = artist["name"]

        album_ids = {}
        covers = {}
        for album in albums:
            id = album["id"]
            if id not in album_ids:
                album_ids[id] = album["name"]
                if "cover" in album:
                    covers[id] = album["cover"]

        existing = {}

        for track_id, track in pctl.master_library.items():
            if track.is_network and track.file_ext == "KOEL":
                existing[track.url_key] = track_id

        for song in songs:

            id = pctl.master_count
            replace_existing = False

            e = existing.get(song["id"])
            if e is not None:
                id = e
                replace_existing = True

            nt = TrackClass()

            nt.title = song["title"]
            nt.index = id
            if "track" in song and song["track"] is not None:
                nt.track_number = song["track"]
            if "disc" in song and song["disc"] is not None:
                nt.disc = song["disc"]
            nt.length = float(song["length"])

            nt.artist = artist_ids.get(song["artist_id"], "")
            nt.album = album_ids.get(song["album_id"], "")
            nt.parent_folder_name = (nt.artist + " - " + nt.album).strip("- ")
            nt.parent_folder_path = nt.album + "/" + nt.parent_folder_name

            nt.art_url_key = covers.get(song["album_id"], "")
            nt.url_key = song["id"]

            nt.is_network = True
            nt.file_ext = "KOEL"

            pctl.master_library[id] = nt

            if not replace_existing:
                pctl.master_count += 1

            playlist.append(nt.index)

        self.scanning = False

        if return_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="Koel Collection", playlist=playlist))
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "koel path tn"
        standard_sort(len(pctl.multi_playlist) - 1)
        switch_playlist(len(pctl.multi_playlist) - 1)


koel = KoelService()
tauon.koel = koel


class TauService:
    def __init__(self):
        self.processing = False

    def resolve_stream(self, key):
        return "http://" + prefs.sat_url + ":7814/api1/file/" + key

    def resolve_picture(self, key):
        return "http://" + prefs.sat_url + ":7814/api1/pic/medium/" + key

    def get(self, point):
        url = "http://" + prefs.sat_url + ":7814/api1/"
        data = None
        try:
            r = requests.get(url + point)
            data = r.json()
        except Exception as e:
            print("Error")
            show_message("Network error", str(e), mode="error")
        return data

    def get_playlist(self, playlist_name=None, return_list=False):

        p = self.get("playlists")

        if not p or not p["playlists"]:
            self.processing = False
            return []

        if playlist_name is None:
            playlist_name = text_sat_playlist.text.strip()
        if not playlist_name:
            show_message("No playlist name")
            return []

        id = None
        name = ""
        for pp in p["playlists"]:
            if pp["name"].lower() == playlist_name.lower():
                id = pp["id"]
                name = pp["name"]

        if id is None:
            show_message("Playlist not found on target", mode="error")
            self.processing = False
            return []

        try:
            t = self.get("tracklist/" + id)
        except:
            print("error getting tracklist")
            return []
        at = t["tracks"]

        exist = {}
        for k, v in pctl.master_library.items():
            if v.is_network and v.file_ext == "TAU":
                exist[v.url_key] = k

        playlist = []
        for item in at:
            replace_existing = True

            tid = item["id"]
            id = exist.get(str(tid))
            if id is None:
                id = pctl.master_count
                replace_existing = False

            nt = TrackClass()
            nt.index = id
            nt.title = item.get("title", "")
            nt.artist = item.get("artist", "")
            nt.album = item.get("album", "")
            nt.album_artist = item.get("album_artist", "")
            nt.length = int(item.get("duration", 0) / 1000)
            nt.track_number = item.get("track_number", 0)

            nt.fullpath = item.get("path", "")
            nt.filename = os.path.basename(nt.fullpath)
            nt.parent_folder_name = os.path.basename(os.path.dirname(nt.fullpath))
            nt.parent_folder_path = os.path.dirname(nt.fullpath)

            nt.url_key = str(tid)
            nt.art_url_key = str(tid)

            nt.is_network = True
            nt.file_ext = "TAU"
            pctl.master_library[id] = nt

            if not replace_existing:
                pctl.master_count += 1
            playlist.append(nt.index)

        if return_list:
            self.processing = False
            return playlist

        pctl.multi_playlist.append(pl_gen(title=name, playlist=playlist))
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "tau path tn"
        standard_sort(len(pctl.multi_playlist) - 1)
        switch_playlist(len(pctl.multi_playlist) - 1)
        self.processing = False


tau = TauService()
tauon.tau = tau


def get_network_thumbnail_url(track_object):
    if track_object.file_ext == "SPTY":
        return track_object.art_url_key
    if track_object.file_ext == "PLEX":
        url = plex.resolve_thumbnail(track_object.art_url_key)
        assert url is not None
        return url
    if track_object.file_ext == "JELY":
        url = jellyfin.resolve_thumbnail(track_object.art_url_key)
        assert url is not None
        assert url != ""
        return url
    if track_object.file_ext == "KOEL":
        url = track_object.art_url_key
        assert url
        return url
    if track_object.file_ext == "TAU":
        url = tau.resolve_picture(track_object.art_url_key)
        assert url
        return url

    return None


def jellyfin_get_playlists_thread():
    if jellyfin.scanning:
        inp.mouse_click = False
        show_message("Job already in progress!")
        return
    jellyfin.scanning = True
    shoot_dl = threading.Thread(target=jellyfin.get_playlists)
    shoot_dl.daemon = True
    shoot_dl.start()

def jellyfin_get_library_thread():
    pref_box.close()
    save_prefs()
    if jellyfin.scanning:
        inp.mouse_click = False
        show_message("Job already in progress!")
        return

    jellyfin.scanning = True
    shoot_dl = threading.Thread(target=jellyfin.ingest_library)
    shoot_dl.daemon = True
    shoot_dl.start()


def plex_get_album_thread():
    pref_box.close()
    save_prefs()
    if plex.scanning:
        inp.mouse_click = False
        show_message("Already scanning!")
        return
    plex.scanning = True

    shoot_dl = threading.Thread(target=plex.get_albums)
    shoot_dl.daemon = True
    shoot_dl.start()


def sub_get_album_thread():
    # if prefs.backend != 1:
    #     show_message("This feature is currently only available with the BASS backend")
    #     return

    pref_box.close()
    save_prefs()
    if subsonic.scanning:
        inp.mouse_click = False
        show_message("Already scanning!")
        return
    subsonic.scanning = True

    shoot_dl = threading.Thread(target=subsonic.get_music3)
    shoot_dl.daemon = True
    shoot_dl.start()


def koel_get_album_thread():
    # if prefs.backend != 1:
    #     show_message("This feature is currently only available with the BASS backend")
    #     return

    pref_box.close()
    save_prefs()
    if koel.scanning:
        inp.mouse_click = False
        show_message("Already scanning!")
        return
    koel.scanning = True

    shoot_dl = threading.Thread(target=koel.get_albums)
    shoot_dl.daemon = True
    shoot_dl.start()


if system == "windows" or msys:
    from infi.systray import SysTrayIcon


class STray:

    def __init__(self):
        self.active = False

    def up(self, systray):
        SDL_ShowWindow(t_window)
        SDL_RaiseWindow(t_window)
        SDL_RestoreWindow(t_window)
        gui.lowered = False

    def down(self):
        if self.active:
            SDL_HideWindow(t_window)

    def advance(self, systray):
        pctl.advance()

    def back(self, systray):
        pctl.back()

    def pause(self, systray):
        pctl.play_pause()

    def track_stop(self, systray):
        pctl.stop()

    def on_quit_callback(self, systray):
        tauon.exit("Exit called from tray.")

    def start(self):
        menu_options = (("Show", None, self.up),
                        ("Play/Pause", None, self.pause),
                        ("Stop", None, self.track_stop),
                        ("Forward", None, self.advance),
                        ("Back", None, self.back))
        self.systray = SysTrayIcon(install_directory + "\\assets\\" + "icon.ico", "Tauon Music Box", menu_options,
                                   on_quit=self.on_quit_callback)
        self.systray.start()
        self.active = True
        gui.tray_active = True

    def stop(self):
        self.systray.shutdown()
        self.active = False


tray = STray()

if system == "linux" and not macos and not msys:

    gnome = Gnome(tauon)

    try:
        gnomeThread = threading.Thread(target=gnome.main)
        gnomeThread.daemon = True
        gnomeThread.start()
    except:
        print("ERROR: Could not start Dbus thread")

if (system == "windows" or msys):

    tray.start()

    if win_ver < 10:
        import keyboard

        def key_callback(event):

            if event.event_type == "down":
                if event.scan_code == -179:
                    inp.media_key = 'Play'
                elif event.scan_code == -178:
                    inp.media_key = 'Stop'
                elif event.scan_code == -177:
                    inp.media_key = 'Previous'
                elif event.scan_code == -176:
                    inp.media_key = 'Next'
                gui.update += 1
                tauon.wake()

        keyboard.hook_key(-179, key_callback)
        keyboard.hook_key(-178, key_callback)
        keyboard.hook_key(-177, key_callback)
        keyboard.hook_key(-176, key_callback)


class GStats:
    def __init__(self):

        self.last_db = 0
        self.last_pl = 0
        self.artist_list = []
        self.album_list = []
        self.genre_list = []
        self.genre_dict = {}

    def update(self, playlist):

        pt = 0

        if pctl.master_count != self.last_db or self.last_pl != playlist:
            self.last_db = pctl.master_count
            self.last_pl = playlist

            artists = {}

            for index in pctl.multi_playlist[playlist][2]:
                artist = pctl.master_library[index].artist

                if artist == "":
                    artist = "<Artist Unspecified>"

                pt = int(star_store.get(index))
                if pt < 30:
                    continue

                if artist in artists:
                    artists[artist] += pt
                else:
                    artists[artist] = pt

            art_list = artists.items()

            sorted_list = sorted(art_list, key=lambda x: x[1], reverse=True)

            self.artist_list = copy.deepcopy(sorted_list)

            genres = {}
            genre_dict = {}

            for index in pctl.multi_playlist[playlist][2]:
                genre_r = pctl.master_library[index].genre

                pt = int(star_store.get(index))

                gn = []
                if ',' in genre_r:
                    for g in genre_r.split(","):
                        g = g.rstrip(" ").lstrip(" ")
                        if len(g) > 0:
                            gn.append(g)
                elif ';' in genre_r:
                    for g in genre_r.split(";"):
                        g = g.rstrip(" ").lstrip(" ")
                        if len(g) > 0:
                            gn.append(g)
                elif '/' in genre_r:
                    for g in genre_r.split("/"):
                        g = g.rstrip(" ").lstrip(" ")
                        if len(g) > 0:
                            gn.append(g)
                elif ' & ' in genre_r:
                    for g in genre_r.split(" & "):
                        g = g.rstrip(" ").lstrip(" ")
                        if len(g) > 0:
                            gn.append(g)
                else:
                    gn = [genre_r]

                pt = int(pt / len(gn))

                for genre in gn:

                    if genre.lower() in {"", 'other', 'unknown', 'misc'}:
                        genre = "<Genre Unspecified>"
                    if genre.lower() in {'jpop', 'japanese pop'}:
                        genre = 'J-Pop'
                    if genre.lower() in {'jrock', 'japanese rock'}:
                        genre = 'J-Rock'
                    if genre.lower() in {'alternative music', 'alt-rock', 'alternative', 'alternrock', 'alt'}:
                        genre = 'Alternative Rock'
                    if genre.lower() in {'jpunk', 'japanese punk'}:
                        genre = 'J-Punk'
                    if genre.lower() in {'post rock', 'post-rock'}:
                        genre = 'Post-Rock'
                    if genre.lower() in {'video game', 'game', 'game music', 'video game music', 'game ost'}:
                        genre = "Video Game Soundtrack"
                    if genre.lower() in {'general soundtrack', 'ost', 'Soundtracks'}:
                        genre = "Soundtrack"
                    if genre.lower() in ('anime', 'アニメ', 'anime ost'):
                        genre = 'Anime Soundtrack'
                    if genre.lower() in {'同人'}:
                        genre = 'Doujin'
                    if genre.lower() in {'chill, chill out', 'chill-out'}:
                        genre = 'Chillout'

                    genre = genre.title()

                    if len(genre) == 3 and genre[2] == 'm':
                        genre = genre.upper()

                    if genre in genres:

                        genres[genre] += pt
                    else:
                        genres[genre] = pt

                    if genre in genre_dict:
                        genre_dict[genre].append(index)
                    else:
                        genre_dict[genre] = [index]

            art_list = genres.items()
            sorted_list = sorted(art_list, key=lambda x: x[1], reverse=True)

            self.genre_list = copy.deepcopy(sorted_list)
            self.genre_dict = genre_dict

            # print('\n-----------------------\n')

            g_albums = {}

            for index in pctl.multi_playlist[playlist][2]:
                album = pctl.master_library[index].album

                if album == "":
                    album = "<Album Unspecified>"

                pt = int(star_store.get(index))

                if pt < 30:
                    continue

                if album in g_albums:
                    g_albums[album] += pt
                else:
                    g_albums[album] = pt

            art_list = g_albums.items()

            sorted_list = sorted(art_list, key=lambda x: x[1], reverse=True)

            self.album_list = copy.deepcopy(sorted_list)


stats_gen = GStats()


def do_exit_button():
    if mouse_up or ab_click:
        if gui.tray_active and prefs.min_to_tray:
            if key_shift_down:
                tauon.exit("User clicked X button with shift key")
                return
            tauon.min_to_tray()
        elif gui.sync_progress and not gui.stop_sync:
            show_message(_("Stop the sync before exiting!"))
        else:
            tauon.exit("User clicked X button")


def do_maximize_button():
    global mouse_down
    global drag_mode
    if gui.fullscreen:
        gui.fullscreen = False
        SDL_SetWindowFullscreen(t_window, 0)
    elif gui.maximized:
        gui.maximized = False
        SDL_RestoreWindow(t_window)
    else:
        gui.maximized = True
        SDL_MaximizeWindow(t_window)

    mouse_down = False
    inp.mouse_click = False
    drag_mode = False


def do_minimize_button():

    global mouse_down
    global drag_mode
    if macos:
        # hack
        SDL_SetWindowBordered(t_window, True)
        SDL_MinimizeWindow(t_window)
        SDL_SetWindowBordered(t_window, False)
    else:
        SDL_MinimizeWindow(t_window)

    mouse_down = False
    inp.mouse_click = False
    drag_mode = False


mac_circle = asset_loader("macstyle.png", True)


def draw_window_tools():
    global mouse_down
    global drag_mode

    # rect = (window_size[0] - 55 * gui.scale, window_size[1] - 35 * gui.scale, 53 * gui.scale, 33 * gui.scale)
    # fields.add(rect)
    # prefs.left_window_control = not key_shift_down
    macstyle = gui.macstyle

    bg_off = colours.window_buttons_bg
    bg_on = colours.window_buttons_bg_over
    fg_off = colours.window_button_icon_off
    fg_on = colours.window_buttons_icon_over
    x_on = colours.window_button_x_on
    x_off = colours.window_button_x_off

    h = round(28 * gui.scale)
    y = round(1 * gui.scale)
    if macstyle:
        y = round(9 * gui.scale)

    x_width = round(26 * gui.scale)
    ma_width = round(33 * gui.scale)
    mi_width = round(35 * gui.scale)
    re_width = round(30 * gui.scale)
    last_width = 0

    xx = 0
    l = prefs.left_window_control
    r = not l
    focused = window_is_focused()

    # Close
    if r:
        xx = window_size[0] - x_width
        xx -= round(2 * gui.scale)

    if macstyle:
        xx = window_size[0] - 27 * gui.scale
        if l:
            xx = round(4 * gui.scale)
        rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)
        fields.add(rect)
        colour = mac_close
        if not focused:
            colour = (86, 85, 86, 255)
        mac_circle.render(xx + 6 * gui.scale, y, colour)
        if coll(rect) and not gui.mouse_unknown:
            if coll_point(last_click_location, rect):
                do_exit_button()
    else:
        rect = (xx, y, x_width, h)
        last_width = x_width
        ddt.rect((rect[0], rect[1], rect[2], rect[3]), bg_off)
        fields.add(rect)
        if coll(rect) and not gui.mouse_unknown:
            ddt.rect((rect[0], rect[1], rect[2], rect[3]), bg_on)
            top_panel.exit_button.render(rect[0] + 8 * gui.scale, rect[1] + 8 * gui.scale, x_on)
            if coll_point(last_click_location, rect):
                do_exit_button()
        else:
            top_panel.exit_button.render(rect[0] + 8 * gui.scale, rect[1] + 8 * gui.scale, x_off)

    # Macstyle restore
    if gui.mode == 3:
        if macstyle:
            if r:
                xx -= round(20 * gui.scale)
            if l:
                xx += round(20 * gui.scale)
            rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)

            fields.add(rect)
            colour = (160, 55, 225, 255)
            if not focused:
                colour = (86, 85, 86, 255)
            mac_circle.render(xx + 6 * gui.scale, y, colour)
            if coll(rect) and not gui.mouse_unknown:
                if (mouse_up or ab_click) and coll_point(last_click_location, rect):
                    restore_full_mode()
                    gui.update += 2

    # maximize

    if draw_max_button and not gui.mode == 3:
        if macstyle:
            if r:
                xx -= round(20 * gui.scale)
            if l:
                xx += round(20 * gui.scale)
            rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)

            fields.add(rect)
            colour = mac_maximize
            if not focused:
                colour = (86, 85, 86, 255)
            mac_circle.render(xx + 6 * gui.scale, y, colour)
            if coll(rect) and not gui.mouse_unknown:
                if (mouse_up or ab_click) and coll_point(last_click_location, rect):
                    do_minimize_button()

        else:
            if r:
                xx -= ma_width
            if l:
                xx += last_width
            rect = (xx, y, ma_width, h)
            last_width = ma_width
            ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_off)
            fields.add(rect)
            if coll(rect):
                ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_on)
                top_panel.maximize_button.render(rect[0] + 10 * gui.scale, rect[1] + 10 * gui.scale, fg_on)
                if (mouse_up or ab_click) and coll_point(last_click_location, rect):
                    do_maximize_button()
            else:
                top_panel.maximize_button.render(rect[0] + 10 * gui.scale, rect[1] + 10 * gui.scale, fg_off)

    # minimize

    if draw_min_button:

        # x = window_size[0] - round(65 * gui.scale)
        # if draw_max_button and not gui.mode == 3:
        #     x -= round(34 * gui.scale)
        if macstyle:
            if r:
                xx -= round(20 * gui.scale)
            if l:
                xx += round(20 * gui.scale)
            rect = (xx + 5, y - 1, 14 * gui.scale, 14 * gui.scale)

            fields.add(rect)
            colour = mac_minimize
            if not focused:
                colour = (86, 85, 86, 255)
            mac_circle.render(xx + 6 * gui.scale, y, colour)
            if coll(rect) and not gui.mouse_unknown:
                if (mouse_up or ab_click) and coll_point(last_click_location, rect):
                    do_maximize_button()

        else:
            if r:
                xx -= mi_width
            if l:
                xx += last_width

            rect = (xx, y, mi_width, h)
            last_width = mi_width
            ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_off)
            fields.add(rect)
            if coll(rect):
                ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_on)
                ddt.rect_a((rect[0] + 11 * gui.scale, rect[1] + 16 * gui.scale), (14 * gui.scale, 3 * gui.scale), fg_on)
                if (mouse_up or ab_click) and coll_point(last_click_location, rect):
                    do_minimize_button()
            else:
                ddt.rect_a((rect[0] + 11 * gui.scale, rect[1] + 16 * gui.scale), (14 * gui.scale, 3 * gui.scale),
                           fg_off)

    # restore

    if gui.mode == 3:

        # bg_off = [0, 0, 0, 50]
        # bg_on = [255, 255, 255, 10]
        # fg_off =(255, 255, 255, 40)
        # fg_on = (255, 255, 255, 60)
        if macstyle:
            pass
        else:
            if r:
                xx -= re_width
            if l:
                xx += last_width

            rect = (xx, y, re_width, h)
            ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_off)
            fields.add(rect)
            if coll(rect):
                ddt.rect_a((rect[0], rect[1]), (rect[2], rect[3]), bg_on)
                top_panel.restore_button.render(rect[0] + 8 * gui.scale, rect[1] + 9 * gui.scale, fg_on)
                if (inp.mouse_click or ab_click) and coll_point(click_location, rect):
                    restore_full_mode()
                    gui.update += 2
            else:
                top_panel.restore_button.render(rect[0] + 8 * gui.scale, rect[1] + 9 * gui.scale, fg_off)


def draw_window_border():
    corner_icon.render(window_size[0] - corner_icon.w, window_size[1] - corner_icon.h, colours.corner_icon)

    corner_rect = (window_size[0] - 20 * gui.scale, window_size[1] - 20 * gui.scale, 20, 20)
    fields.add(corner_rect)

    right_rect = (window_size[0] - 3 * gui.scale, 20 * gui.scale, 10, window_size[1] - 40 * gui.scale)
    fields.add(right_rect)

    # top_rect = (20 * gui.scale, 0, window_size[0] - 40 * gui.scale, 2 * gui.scale)
    # fields.add(top_rect)

    left_rect = (0, 10 * gui.scale, 4 * gui.scale, window_size[1] - 50 * gui.scale)
    fields.add(left_rect)

    bottom_rect = (20 * gui.scale, window_size[1] - 4, window_size[0] - 40 * gui.scale, 7 * gui.scale)
    fields.add(bottom_rect)

    if coll(corner_rect):
        gui.cursor_want = 4
    elif coll(right_rect):
        gui.cursor_want = 8
    # elif coll(top_rect):
    #     gui.cursor_want = 9
    elif coll(left_rect):
        gui.cursor_want = 10
    elif coll(bottom_rect):
        gui.cursor_want = 11

    colour = colours.window_frame

    ddt.rect((0, 0, window_size[0], 1 * gui.scale), colour)
    ddt.rect((0, 0, 1 * gui.scale, window_size[1]), colour)
    ddt.rect((0, window_size[1] - 1 * gui.scale, window_size[0], 1 * gui.scale), colour)
    ddt.rect((window_size[0] - 1 * gui.scale, 0, 1 * gui.scale, window_size[1]), colour)


# -------------------------------------------------------------------------------------------
# initiate SDL2 --------------------------------------------------------------------C-IS-----

cursor_hand = SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_HAND)
cursor_standard = SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_ARROW)
cursor_shift = SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_SIZEWE)
cursor_text = SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_IBEAM)

cursor_br_corner = cursor_standard
cursor_right_side = cursor_standard
cursor_top_side = cursor_standard
cursor_left_side = cursor_standard
cursor_bottom_side = cursor_standard

if msys:
    cursor_br_corner = SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_SIZENWSE)
    cursor_right_side = cursor_shift
    cursor_left_side = cursor_shift
    cursor_top_side = SDL_CreateSystemCursor(SDL_SYSTEM_CURSOR_SIZENS)
    cursor_bottom_side = cursor_top_side
elif not msys and system == "linux":
    try:
        class XcursorImage(ctypes.Structure):
            _fields_ = [
                        ("version", c_uint32),
                        ("size", c_uint32),
                        ('width', c_uint32),
                        ('height', c_uint32),
                        ('xhot', c_uint32),
                        ('yhot', c_uint32),
                        ('delay', c_uint32),
                        ('pixels', c_void_p),
                        ]

        try:
            xcu = ctypes.cdll.LoadLibrary("libXcursor.so")
        except:
            xcu = ctypes.cdll.LoadLibrary("libXcursor.so.1")
        xcu.XcursorLibraryLoadImage.restype = ctypes.POINTER(XcursorImage)

        def get_xcursor(name):
            c1 = xcu.XcursorLibraryLoadImage(c_char_p(name.encode()), c_char_p(os.environ["XCURSOR_THEME"].encode()), c_int(int(os.environ["XCURSOR_SIZE"]))).contents
            sdl_surface = SDL_CreateRGBSurfaceWithFormatFrom(c1.pixels, c1.width, c1.height, 32, c1.width * 4, SDL_PIXELFORMAT_ARGB8888)
            cursor = SDL_CreateColorCursor(sdl_surface, round(c1.xhot), round(c1.yhot))
            xcu.XcursorImageDestroy(ctypes.byref(c1))
            SDL_FreeSurface(sdl_surface)
            return cursor

        cursor_br_corner = get_xcursor("se-resize")
        cursor_right_side = get_xcursor("right_side")
        cursor_top_side = get_xcursor("top_side")
        cursor_left_side = get_xcursor("left_side")
        cursor_bottom_side = get_xcursor("bottom_side")

        if SDL_GetCurrentVideoDriver() == b'wayland':
            cursor_standard = get_xcursor("left_ptr")
            cursor_text = get_xcursor("xterm")
            cursor_shift = get_xcursor("sb_h_double_arrow")
            cursor_hand = get_xcursor("hand2")
            SDL_SetCursor(cursor_standard)

    except:
        print("Error loading xcursor")


if not maximized and gui.maximized:
    SDL_MaximizeWindow(t_window)

# print(SDL_GetError())

# t_window = SDL_CreateShapedWindow(window_title,
#                              SDL_WINDOWPOS_CENTERED, SDL_WINDOWPOS_CENTERED,
#                              window_size[0], window_size[1],
#                              flags)

# print(SDL_GetError())

if system == 'windows' or msys:
    gui.window_id = sss.info.win.window


# try:
#     SDL_SetHint(SDL_HINT_MOUSE_FOCUS_CLICKTHROUGH, b"1")
#
# except:
#     print("old version of SDL detected")

# get window surface and set up renderer
# renderer = SDL_CreateRenderer(t_window, 0, SDL_RENDERER_ACCELERATED | SDL_RENDERER_PRESENTVSYNC)

# renderer = SDL_CreateRenderer(t_window, 0, SDL_RENDERER_ACCELERATED)
#
# # window_surface = SDL_GetWindowSurface(t_window)
#
# SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND)
#
# display_index = SDL_GetWindowDisplayIndex(t_window)
# display_bounds = SDL_Rect(0, 0)
# SDL_GetDisplayBounds(display_index, display_bounds)
#
# icon = IMG_Load(os.path.join(asset_directory, "icon-64.png").encode())
# SDL_SetWindowIcon(t_window, icon)
# SDL_SetHint(SDL_HINT_RENDER_SCALE_QUALITY, "best".encode())
#
# SDL_SetWindowMinimumSize(t_window, round(560 * gui.scale), round(330 * gui.scale))
#
#
# gui.max_window_tex = 1000
# if window_size[0] > gui.max_window_tex or window_size[1] > gui.max_window_tex:
#
#     while window_size[0] > gui.max_window_tex:
#         gui.max_window_tex += 1000
#     while window_size[1] > gui.max_window_tex:
#         gui.max_window_tex += 1000
#
# gui.ttext = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.max_window_tex, gui.max_window_tex)
#
# # gui.pl_surf = SDL_CreateRGBSurfaceWithFormat(0, gui.max_window_tex, gui.max_window_tex, 32, SDL_PIXELFORMAT_RGB888)
#
# SDL_SetTextureBlendMode(gui.ttext, SDL_BLENDMODE_BLEND)
#
# gui.spec2_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.spec2_w, gui.spec2_y)
# gui.spec1_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.spec_w, gui.spec_h)
# gui.spec4_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.spec4_w, gui.spec4_h)
# gui.spec_level_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.level_ww, gui.level_hh)
#
# SDL_SetTextureBlendMode(gui.spec4_tex, SDL_BLENDMODE_BLEND)
#
# SDL_SetRenderTarget(renderer, None)
#
# gui.main_texture = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.max_window_tex, gui.max_window_tex)
# gui.main_texture_overlay_temp = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.max_window_tex, gui.max_window_tex)
#
# SDL_SetRenderTarget(renderer, gui.main_texture)
# SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255)
#
# SDL_SetRenderTarget(renderer, gui.main_texture_overlay_temp)
# SDL_SetTextureBlendMode(gui.main_texture_overlay_temp, SDL_BLENDMODE_BLEND)
# SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255)
#
# SDL_RenderClear(renderer)
#
# gui.abc = SDL_Rect(0, 0, gui.max_window_tex, gui.max_window_tex)
# gui.pl_update = 2
#
# SDL_SetWindowOpacity(t_window, prefs.window_opacity)

# gui.spec1_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.spec_w, gui.spec_h)
# gui.spec4_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.spec4_w, gui.spec4_h)
# gui.spec_level_tex = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET, gui.level_ww, gui.level_hh)
# SDL_SetTextureBlendMode(gui.spec4_tex, SDL_BLENDMODE_BLEND)


def bass_player_thread(player):
    # logging.basicConfig(filename=user_directory + '/crash.log', level=logging.ERROR,
    #                     format='%(asctime)s %(levelname)s %(name)s %(message)s')

    try:
        player(pctl, gui, prefs, lfm_scrobbler, star_store, tauon)
    except:
        # logging.exception('Exception on player thread')
        show_message("Playback thread has crashed. Sorry about that.", "App will need to be restarted.", mode='error')
        time.sleep(1)
        show_message("Playback thread has crashed. Sorry about that.", "App will need to be restarted.", mode='error')
        time.sleep(1)
        show_message("Playback thread has crashed. Sorry about that.", "App will need to be restarted.", mode='error')
        raise


if (system == 'windows' or msys) and taskbar_progress:

    class WinTask:

        def __init__(self, ):
            self.start = time.time()
            self.updated_state = 0
            self.window_id = gui.window_id
            import comtypes.client as cc
            cc.GetModule(install_directory + "\\TaskbarLib.tlb")
            import comtypes.gen.TaskbarLib as tbl
            self.taskbar = cc.CreateObject(
                "{56FDF344-FD6D-11d0-958A-006097C9A090}",
                interface=tbl.ITaskbarList3)
            self.taskbar.HrInit()

            self.d_timer = Timer()

        def update(self, force=False):
            if self.d_timer.get() > 2 or force:
                self.d_timer.set()

                if pctl.playing_state == 1 and self.updated_state != 1:
                    self.taskbar.SetProgressState(self.window_id, 0x2)

                if pctl.playing_state == 1:
                    self.updated_state = 1
                    if pctl.playing_length > 2:
                        perc = int(pctl.playing_time * 100 / int(pctl.playing_length))
                        if perc < 2:
                            perc = 1
                        elif perc > 100:
                            prec = 100
                    else:
                        perc = 0

                    self.taskbar.SetProgressValue(self.window_id, perc, 100)

                elif pctl.playing_state == 2 and self.updated_state != 2:
                    self.updated_state = 2
                    self.taskbar.SetProgressState(self.window_id, 0x8)

                elif pctl.playing_state == 0 and self.updated_state != 0:
                    self.updated_state = 0
                    self.taskbar.SetProgressState(self.window_id, 0x2)
                    self.taskbar.SetProgressValue(self.window_id, 0, 100)


    if os.path.isfile(install_directory + "/TaskbarLib.tlb"):
        print("Taskbar progress enabled")
        pctl.windows_progress = WinTask()

    else:
        pctl.taskbar_progress = False
        print("Could not find TaskbarLib.tlb")


# ---------------------------------------------------------------------------------------------
# ABSTRACT SDL DRAWING FUNCTIONS -----------------------------------------------------


def coll_point(l, r):
    # rect point collision detection
    return r[0] < l[0] <= r[0] + r[2] and r[1] <= l[1] <= r[1] + r[3]


def coll(r):
    return r[0] < mouse_position[0] <= r[0] + r[2] and r[1] <= mouse_position[1] <= r[1] + r[3]


ddt = TDraw(renderer)
ddt.scale = gui.scale
ddt.force_subpixel_text = prefs.force_subpixel_text

from t_modules.t_launch import *

launch = Launch(tauon, pctl, gui, ddt)


class Drawing:

    def button(self, text, x, y, w=None, h=None, font=212, text_highlight_colour=None, text_colour=None,
               background_colour=None, background_highlight_colour=None, press=None, tooltip=""):

        if w is None:
            w = ddt.get_text_w(text, font) + 18 * gui.scale
        if h is None:
            h = 22 * gui.scale

        rect = (x, y, w, h)
        fields.add(rect)

        if text_highlight_colour is None:
            text_highlight_colour = colours.box_button_text_highlight
        if text_colour is None:
            text_colour = colours.box_button_text
        if background_colour is None:
            background_colour = colours.box_button_background
        if background_highlight_colour is None:
            background_highlight_colour = colours.box_button_background_highlight

        click = False

        if press is None:
            press = inp.mouse_click

        if coll(rect):
            if tooltip:
                tool_tip.test(x + 15 * gui.scale, y - 28 * gui.scale, tooltip)
            ddt.rect(rect, background_highlight_colour)

            # if background_highlight_colour[3] != 255:
            #     background_highlight_colour = None

            ddt.text((rect[0] + int(rect[2] / 2), rect[1] + 2 * gui.scale, 2), text, text_highlight_colour, font,
                     bg=background_highlight_colour)
            if press:
                click = True
        else:
            ddt.rect(rect, background_colour)
            if background_highlight_colour[3] != 255:
                background_colour = None
            ddt.text((rect[0] + int(rect[2] / 2), rect[1] + 2 * gui.scale, 2), text, text_colour, font,
                     bg=background_colour)
        return click


draw = Drawing()


def prime_fonts():
    standard_font = prefs.linux_font
    # if msys:
    #     standard_font = prefs.linux_font + ", Sans"  # The CJK ones dont appear to be working
    ddt.prime_font(standard_font, 8, 9)
    ddt.prime_font(standard_font, 8, 10)
    ddt.prime_font(standard_font, 8.5, 11)
    ddt.prime_font(standard_font, 8.7, 11.5)
    ddt.prime_font(standard_font, 9, 12)
    ddt.prime_font(standard_font, 10, 13)
    ddt.prime_font(standard_font, 10, 14)
    ddt.prime_font(standard_font, 10.2, 14.5)
    ddt.prime_font(standard_font, 11, 15)
    ddt.prime_font(standard_font, 12, 16)
    ddt.prime_font(standard_font, 12, 17)
    ddt.prime_font(standard_font, 12, 18)
    ddt.prime_font(standard_font, 13, 19)
    ddt.prime_font(standard_font, 14, 20)
    ddt.prime_font(standard_font, 24, 30)

    ddt.prime_font(standard_font, 9, 412)
    ddt.prime_font(standard_font, 10, 413)

    standard_font = prefs.linux_font_semibold
    # if msys:
    #     standard_font = prefs.linux_font_semibold + ", Noto Sans Med, Sans" #, Noto Sans CJK JP Medium, Noto Sans CJK Medium, Sans"

    ddt.prime_font(standard_font, 8, 309)
    ddt.prime_font(standard_font, 8, 310)
    ddt.prime_font(standard_font, 8.5, 311)
    ddt.prime_font(standard_font, 9, 312)
    ddt.prime_font(standard_font, 10, 313)
    ddt.prime_font(standard_font, 10.5, 314)
    ddt.prime_font(standard_font, 11, 315)
    ddt.prime_font(standard_font, 12, 316)
    ddt.prime_font(standard_font, 12, 317)
    ddt.prime_font(standard_font, 12, 318)
    ddt.prime_font(standard_font, 13, 319)
    ddt.prime_font(standard_font, 24, 330)

    standard_font = prefs.linux_font_bold
    # if msys:
    #     standard_font = prefs.linux_font_bold + ", Noto Sans, Sans Bold"

    ddt.prime_font(standard_font, 6, 209)
    ddt.prime_font(standard_font, 7, 210)
    ddt.prime_font(standard_font, 8, 211)
    ddt.prime_font(standard_font, 9, 212)
    ddt.prime_font(standard_font, 10, 213)
    ddt.prime_font(standard_font, 11, 214)
    ddt.prime_font(standard_font, 12, 215)
    ddt.prime_font(standard_font, 13, 216)
    ddt.prime_font(standard_font, 14, 217)
    ddt.prime_font(standard_font, 17, 218)
    ddt.prime_font(standard_font, 19, 219)
    ddt.prime_font(standard_font, 20, 220)
    ddt.prime_font(standard_font, 25, 228)

    standard_font = prefs.linux_font_condensed
    # if msys:
    #     standard_font = "Noto Sans ExtCond, Sans"
    ddt.prime_font(standard_font, 10, 413)
    ddt.prime_font(standard_font, 11, 414)
    ddt.prime_font(standard_font, 12, 415)
    ddt.prime_font(standard_font, 13, 416)

    standard_font = prefs.linux_font_condensed_bold  # "Noto Sans, ExtraCondensed Bold"
    # if msys:
    #     standard_font = "Noto Sans ExtCond, Sans Bold"
    # ddt.prime_font(standard_font, 9, 512)
    ddt.prime_font(standard_font, 10, 513)
    ddt.prime_font(standard_font, 11, 514)
    ddt.prime_font(standard_font, 12, 515)
    ddt.prime_font(standard_font, 13, 516)


if system == "linux":
    prime_fonts()

else:
    # standard_font = "Meiryo"
    standard_font = "Arial"
    # semibold_font = "Meiryo Semibold"
    semibold_font = "Arial Bold"
    standard_weight = 500
    bold_weight = 600
    ddt.win_prime_font(standard_font, 14, 10, weight=standard_weight, y_offset=0)
    ddt.win_prime_font(standard_font, 15, 11, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 15, 11.5, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 15, 12, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 15, 13, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 16, 14, weight=standard_weight, y_offset=0)
    ddt.win_prime_font(standard_font, 16, 14.5, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 17, 15, weight=standard_weight, y_offset=-1)
    ddt.win_prime_font(standard_font, 20, 16, weight=standard_weight, y_offset=-2)
    ddt.win_prime_font(standard_font, 20, 17, weight=standard_weight, y_offset=-1)

    ddt.win_prime_font(standard_font, 30 + 4, 30, weight=standard_weight, y_offset=-12)
    ddt.win_prime_font(semibold_font, 9, 209, weight=bold_weight, y_offset=1)
    ddt.win_prime_font('Arial', 10 + 4, 210, weight=600, y_offset=2)
    ddt.win_prime_font('Arial', 11 + 3, 211, weight=600, y_offset=2)
    ddt.win_prime_font(semibold_font, 12 + 4, 212, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 13 + 3, 213, weight=bold_weight, y_offset=-1)
    ddt.win_prime_font(semibold_font, 14 + 2, 214, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 15 + 2, 215, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 16 + 2, 216, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 17 + 2, 218, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 18 + 2, 218, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 19 + 2, 220, weight=bold_weight, y_offset=1)
    ddt.win_prime_font(semibold_font, 28 + 2, 228, weight=bold_weight, y_offset=1)

    standard_weight = 550
    ddt.win_prime_font(standard_font, 14, 310, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 15, 311, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 16, 312, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 17, 313, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 18, 314, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 19, 315, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 20, 316, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 21, 317, weight=standard_weight, y_offset=1)

    standard_font = "Arial Narrow"
    standard_weight = 500

    ddt.win_prime_font(standard_font, 14, 410, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 15, 411, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 16, 412, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 17, 413, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 18, 414, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 19, 415, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 20, 416, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 21, 417, weight=standard_weight, y_offset=1)

    standard_weight = 600

    ddt.win_prime_font(standard_font, 14, 510, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 15, 511, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 16, 512, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 17, 513, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 18, 514, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 19, 515, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 20, 516, weight=standard_weight, y_offset=1)
    ddt.win_prime_font(standard_font, 21, 517, weight=standard_weight, y_offset=1)


class DropShadow:

    def __init__(self):
        self.readys = {}
        self.underscan = int(15 * gui.scale)
        self.radius = 4
        self.grow = 2 * gui.scale
        self.opacity = 90

    def prepare(self, w, h):
        fh = h + self.underscan
        fw = w + self.underscan

        im = Image.new("RGBA", (round(fw), round(fh)), 0x00000000)
        draw = ImageDraw.Draw(im)
        draw.rectangle(((self.underscan, self.underscan), (w + 2, h + 2)), fill="black")

        im = im.filter(ImageFilter.GaussianBlur(self.radius))

        g = io.BytesIO()
        g.seek(0)
        im.save(g, 'PNG')
        g.seek(0)

        wop = rw_from_object(g)
        s_image = IMG_Load_RW(wop, 0)
        c = SDL_CreateTextureFromSurface(renderer, s_image)
        SDL_SetTextureAlphaMod(c, self.opacity)

        tex_w = pointer(c_int(0))
        tex_h = pointer(c_int(0))
        SDL_QueryTexture(c, None, None, tex_w, tex_h)

        dst = SDL_Rect(0, 0)
        dst.w = int(tex_w.contents.value)
        dst.h = int(tex_h.contents.value)

        SDL_FreeSurface(s_image)
        g.close()
        im.close()

        unit = (dst, c)
        self.readys[(w, h)] = unit

    def render(self, x, y, w, h):
        if (w, h) not in self.readys:
            self.prepare(w, h)

        unit = self.readys[(w, h)]
        unit[0].x = round(x) - round(self.underscan)
        unit[0].y = round(y) - round(self.underscan)
        SDL_RenderCopy(renderer, unit[1], None, unit[0])


drop_shadow = DropShadow()


class LyricsRenMini:

    def __init__(self):
        self.index = -1
        self.text = ""

        self.lyrics_position = 0

    def generate(self, index, w):
        self.text = pctl.master_library[index].lyrics
        self.lyrics_position = 0

    def render(self, index, x, y, w, h, p):
        if index != self.index or self.text != pctl.master_library[index].lyrics:
            self.index = index
            self.generate(index, w)

        colour = colours.side_bar_line1

        # if key_ctrl_down:
        #     if mouse_wheel < 0:
        #         prefs.lyrics_font_size += 1
        #     if mouse_wheel > 0:
        #         prefs.lyrics_font_size -= 1

        ddt.text((x, y, 4, w), self.text, colour, prefs.lyrics_font_size, w - (w % 2), colours.side_panel_background)


lyrics_ren_mini = LyricsRenMini()


class LyricsRen:

    def __init__(self):

        self.index = -1
        self.text = ""

        self.lyrics_position = 0

    def test_update(self, track_object):

        if track_object.index != self.index or self.text != track_object.lyrics:
            self.index = track_object.index
            self.text = track_object.lyrics
            self.lyrics_position = 0

    def render(self, x, y, w, h, p):

        colour = colours.lyrics
        if test_lumi(colours.gallery_background) < 0.5:
            colour = colours.grey(40)

        ddt.text((x, y, 4, w), self.text, colour, 17, w, colours.playlist_panel_background)


lyrics_ren = LyricsRen()


def find_synced_lyric_data(track):
    if track.is_network:
        return None

    direc = track.parent_folder_path
    name = os.path.splitext(track.filename)[0] + ".lrc"

    if len(track.lyrics) > 20 and track.lyrics[0] == "[" and ":" in track.lyrics[:20] and "." in track.lyrics[:20]:
        return track.lyrics.splitlines()

    try:
        if os.path.isfile(os.path.join(direc, name)):
            with open(os.path.join(direc, name), 'r', encoding='utf-8') as f:
                data = f.readlines()
        else:
            return None
    except:
        print("Read lyrics file error")
        return None

    return data


class TimedLyricsToStatic:

    def __init__(self):
        self.cache_key = None
        self.cache_lyrics = ""

    def get(self, track):
        if track.lyrics:
            return track.lyrics
        if track.is_network:
            return ""
        if track == self.cache_key:
            return self.cache_lyrics
        else:
            data = find_synced_lyric_data(track)

            if data is None:
                self.cache_lyrics = ""
                self.cache_key = track
                return ""
            text = ""

            for line in data:
                if len(line) < 10:
                    continue

                if line[0] != "[" or line[9] != "]" or ":" not in line or "." not in line:
                    continue

                text += line.split("]")[-1].rstrip("\n") + "\n"

            self.cache_lyrics = text
            self.cache_key = track
            return text


tauon.synced_to_static_lyrics = TimedLyricsToStatic()


def get_real_time():
    offset = pctl.decode_time - (prefs.sync_lyrics_time_offset / 1000)
    if prefs.backend == 4:
        offset -= (prefs.device_buffer - 120) / 1000
    elif prefs.backend == 2:
        offset += 0.1
    return max(0, offset)


class TimedLyricsRen:

    def __init__(self):

        self.index = -1

        self.scanned = {}
        self.ready = False
        self.data = []

        self.scroll_position = 0

    def generate(self, track):

        if self.index == track.index:
            return self.ready

        self.ready = False
        self.index = track.index
        self.scroll_position = 0
        self.data.clear()

        data = find_synced_lyric_data(track)
        if data is None:
            return

        for line in data:
            if len(line) < 10:
                continue

            if line[0] != "[" or "]" not in line or ":" not in line or "." not in line:
                continue

            try:

                text = line.split("]")[-1].rstrip("\n")
                t = line

                while t[0] == "[" and t[9] == "]" and ":" in t and "." in t:

                    a = t.lstrip("[")
                    t = t.split("]")[1] + "]"

                    a = a.split("]")[0]
                    mm, b = a.split(":")
                    ss, ms = b.split(".")

                    s = int(mm) * 60 + int(ss)
                    if len(ms) == 2:
                        s += int(ms) / 100
                    elif len(ms) == 3:
                        s += int(ms) / 1000

                    self.data.append((s, text))

                    if len(t) < 10:
                        break
            except:
                continue

        self.data = sorted(self.data, key=lambda x: x[0])
        # print(self.data)

        self.ready = True
        return True

    def render(self, index, x, y, side_panel=False, w=0, h=0):

        if index != self.index:
            self.ready = False
            self.generate(pctl.master_library[index])
            
        if right_click and x and y and coll((x, y, w, h)):
            showcase_menu.activate(pctl.master_library[index])

        if not self.ready:
            return False

        if mouse_wheel and (pctl.playing_state != 1 or pctl.track_queue[pctl.queue_step] != index):
            if side_panel:
                if coll((x, y, w, h)):
                    self.scroll_position += int(mouse_wheel * 30 * gui.scale)
            else:
                self.scroll_position += int(mouse_wheel * 30 * gui.scale)

        line_active = -1
        last = -1

        highlight = True

        if side_panel:
            bg = colours.top_panel_background
            font_size = 15
            spacing = round(17 * gui.scale)
        else:
            bg = colours.playlist_panel_background
            font_size = 17
            spacing = round(23 * gui.scale)

        test_time = get_real_time()

        if pctl.track_queue[pctl.queue_step] == index:

            for i, line in enumerate(self.data):
                if line[0] < test_time:
                    last = i

                if line[0] > test_time:
                    pctl.wake_past_time = line[0]
                    line_active = last
                    break
            else:
                line_active = len(self.data) - 1

            if pctl.playing_state == 1:
                self.scroll_position = (max(0, line_active)) * spacing * -1

        yy = y + self.scroll_position

        for i, line in enumerate(self.data):

            if 0 < yy < window_size[1]:

                colour = colours.lyrics
                if test_lumi(colours.gallery_background) < 0.5:
                    colour = colours.grey(40)

                if i == line_active and highlight:
                    colour = [255, 210, 50, 255]
                    if colours.lm:
                        colour = [180, 130, 210, 255]

                h = ddt.text((x, yy, 4, w - 20 * gui.scale), line[1], colour, font_size, w - 20 * gui.scale, bg)
                yy += max(h - round(6 * gui.scale), spacing)
            else:
                yy += spacing


timed_lyrics_ren = TimedLyricsRen()


def draw_internel_link(x, y, text, colour, font):
    tweak = font
    while tweak > 100:
        tweak -= 100

    if gui.scale == 2:
        tweak *= 2
        tweak += 4
    if gui.scale == 1.25:
        tweak = round(tweak * 1.25)
        tweak += 1

    sp = ddt.text((x, y), text, colour, font)

    rect = [x - 5 * gui.scale, y - 2 * gui.scale, sp + 11 * gui.scale, 23 * gui.scale]
    fields.add(rect)

    if coll(rect):
        if not inp.mouse_click:
            gui.cursor_want = 3
        ddt.line(x, y + tweak + 2, x + sp, y + tweak + 2, alpha_mod(colour, 180))
        if inp.mouse_click:
            return True
    return False


# No hit detect
def draw_linked_text(location, text, colour, font, force=False, replace=""):
    base = ""
    link_text = ""
    rest = ""
    on_base = True

    if force:
        on_base = False
        base = ""
        link_text = text
        rest = ""
    else:
        for i in range(len(text)):
            if text[i:i + 7] == "http://" or text[i:i + 4] == "www." or text[i:i + 8] == "https://":
                on_base = False
            if on_base:
                base += text[i]
            else:
                if i == len(text) or text[i] in '\\) "\'':
                    rest = text[i:]
                    break
                else:
                    link_text += text[i]

    target_link = link_text
    if replace:
        link_text = replace

    left = ddt.get_text_w(base, font)
    right = ddt.get_text_w(base + link_text, font)

    x = location[0]
    y = location[1]

    ddt.text((x, y), base, colour, font)
    ddt.text((x + left, y), link_text, colours.link_text, font)
    ddt.text((x + right, y), rest, colour, font)

    tweak = font
    while tweak > 100:
        tweak -= 100

    if gui.scale == 2:
        tweak *= 2
        tweak += 4
    elif gui.scale != 1:
        tweak = round(tweak * gui.scale)
        tweak += 2

    if system == "windows":
        tweak += 1

    # ddt.line(x + left, y + tweak + 2, x + right, y + tweak + 2, alpha_mod(colours.link_text, 120))
    ddt.rect((x + left, y + tweak + 2, right - left, round(1 * gui.scale)), alpha_mod(colours.link_text, 120))

    return left, right - left, target_link


def draw_linked_text2(x, y, text, colour, font, click=False, replace=""):
    link_pa = draw_linked_text((x, y), text,
                               colour, font, replace=replace)
    link_rect = [x + link_pa[0], y, link_pa[1], 18 * gui.scale]
    if coll(link_rect):
        if not click:
            gui.cursor_want = 3
        if click:
            webbrowser.open(link_pa[2], new=2, autoraise=True)
    fields.add(link_rect)


def link_activate(x, y, link_pa, click=None):
    link_rect = [x + link_pa[0], y - 2 * gui.scale, link_pa[1], 20 * gui.scale]

    if click is None:
        click = inp.mouse_click

    fields.add(link_rect)
    if coll(link_rect):
        if not click:
            gui.cursor_want = 3
        if click:
            webbrowser.open(link_pa[2], new=2, autoraise=True)
            track_box = True


text_box_canvas_rect = SDL_Rect(0, 0, round(2000 * gui.scale), round(40 * gui.scale))
text_box_canvas_hide_rect = SDL_Rect(0, 0, round(2000 * gui.scale), round(40 * gui.scale))
text_box_canvas = SDL_CreateTexture(renderer, SDL_PIXELFORMAT_ARGB8888, SDL_TEXTUREACCESS_TARGET,
                                    text_box_canvas_rect.w, text_box_canvas_rect.h)
SDL_SetTextureBlendMode(text_box_canvas, SDL_BLENDMODE_BLEND)


class TextBox2:
    cursor = True

    def __init__(self):

        self.text = ""
        self.cursor_position = 0
        self.selection = 0
        self.offset = 0
        self.down_lock = False
        self.paste_text = ""

    def paste(self):

        if SDL_HasClipboardText():
            clip = SDL_GetClipboardText().decode('utf-8')
            self.paste_text = clip

    def copy(self):

        text = self.get_selection()
        if not text:
            text = self.text
        if text != "":
            SDL_SetClipboardText(text.encode('utf-8'))

    def set_text(self, text):

        self.text = text
        if self.cursor_position > len(text):
            self.cursor_position = 0
            self.selection = 0
        else:
            self.selection = self.cursor_position

    def clear(self):
        self.text = ""
        #self.cursor_position = 0
        self.selection = self.cursor_position

    def highlight_all(self):

        self.selection = len(self.text)
        self.cursor_position = 0

    def eliminate_selection(self):
        if self.selection != self.cursor_position:
            if self.selection > self.cursor_position:
                self.text = self.text[0: len(self.text) - self.selection] + self.text[
                                                                            len(self.text) - self.cursor_position:]
                self.selection = self.cursor_position
            else:
                self.text = self.text[0: len(self.text) - self.cursor_position] + self.text[
                                                                                  len(self.text) - self.selection:]
                self.cursor_position = self.selection

    def get_selection(self, p=1):
        if self.selection != self.cursor_position:
            if p == 1:
                if self.selection > self.cursor_position:
                    return self.text[len(self.text) - self.selection: len(self.text) - self.cursor_position]

                else:
                    return self.text[len(self.text) - self.cursor_position: len(self.text) - self.selection]
            if p == 0:
                return self.text[0: len(self.text) - max(self.cursor_position, self.selection)]
            if p == 2:
                return self.text[len(self.text) - min(self.cursor_position, self.selection):]

        else:
            return ""

    def draw(self, x, y, colour, active=True, secret=False, font=13, width=0, click=False, selection_height=18,
             big=False):

        # A little bit messy.
        # For now, this is set up so where 'width' is set > 0, the cursor position becomes editable,
        # otherwise it is fixed to end

        SDL_SetRenderTarget(renderer, text_box_canvas)
        SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_NONE)
        SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)

        text_box_canvas_rect.x = 0
        text_box_canvas_rect.y = 0
        SDL_RenderFillRect(renderer, text_box_canvas_rect)

        SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND)

        selection_height *= gui.scale

        if click is False:
            click = inp.mouse_click
        if mouse_down:
            gui.update = 2  # todo, more elegant fix

        rect = (x - 3, y - 2, width - 3, 21 * gui.scale)
        select_rect = (x - 20 * gui.scale, y - 2, width + 20 * gui.scale, 21 * gui.scale)

        fields.add(rect)

        # Activate Menu
        if coll(rect):
            if right_click or level_2_right_click:
                field_menu.activate(self)

        if width > 0 and active:

            if click and field_menu.active:
                # field_menu.click()
                click = False

            # Add text from input
            if input_text != "":
                self.eliminate_selection()
                self.text = self.text[0: len(self.text) - self.cursor_position] + input_text + self.text[len(
                    self.text) - self.cursor_position:]

            def g():
                if len(self.text) == 0 or self.cursor_position == len(self.text):
                    return None
                return self.text[len(self.text) - self.cursor_position - 1]

            def g2():
                if len(self.text) == 0 or self.cursor_position == 0:
                    return None
                return self.text[len(self.text) - self.cursor_position]

            def d():
                self.text = self.text[0: len(self.text) - self.cursor_position - 1] + self.text[
                                                                                      len(self.text) - self.cursor_position:]
                self.selection = self.cursor_position

            # Ctrl + Backspace to delete word
            if inp.backspace_press and (key_ctrl_down or key_rctrl_down) and \
                    self.cursor_position == self.selection and len(self.text) > 0 and self.cursor_position < len(
                self.text):
                while g() == " ":
                    d()
                while g() != " " and g() != None:
                    d()

            # Ctrl + left to move cursor back a word
            elif (key_ctrl_down or key_rctrl_down) and key_left_press:
                while g() == " ":
                    self.cursor_position += 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                while g() != None and g() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
                    self.cursor_position += 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                    if g() == " ":
                        self.cursor_position -= 1
                        if not key_shift_down:
                            self.selection = self.cursor_position
                        break

            # Ctrl + right to move cursor forward a word
            elif (key_ctrl_down or key_rctrl_down) and key_right_press:
                while g2() == " ":
                    self.cursor_position -= 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                while g2() != None and g2() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
                    self.cursor_position -= 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                    if g2() == " ":
                        self.cursor_position += 1
                        if not key_shift_down:
                            self.selection = self.cursor_position
                        break

            # Handle normal backspace
            elif inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
                while inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
                    if self.selection != self.cursor_position:
                        self.eliminate_selection()
                    else:
                        self.text = self.text[0:len(self.text) - self.cursor_position - 1] + self.text[len(
                            self.text) - self.cursor_position:]
                    inp.backspace_press -= 1
            elif inp.backspace_press and len(self.get_selection()) > 0:
                self.eliminate_selection()

            # Left and right arrow keys to move cursor
            if key_right_press:
                if self.cursor_position > 0:
                    self.cursor_position -= 1
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position

            if key_left_press:
                if self.cursor_position < len(self.text):
                    self.cursor_position += 1
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position

            if self.paste_text:
                if 'http://' in self.text and 'http://' in self.paste_text:
                    self.text = ""

                self.paste_text = self.paste_text.rstrip(" ").lstrip(" ")
                self.paste_text = self.paste_text.replace('\n', ' ').replace('\r', '')

                self.eliminate_selection()
                self.text = self.text[0: len(self.text) - self.cursor_position] + self.paste_text + self.text[len(
                    self.text) - self.cursor_position:]
                self.paste_text = ""

            # Paste via ctrl-v
            if key_ctrl_down and key_v_press:
                clip = SDL_GetClipboardText().decode('utf-8')
                self.eliminate_selection()
                self.text = self.text[0: len(self.text) - self.cursor_position] + clip + self.text[len(
                    self.text) - self.cursor_position:]

            if key_ctrl_down and key_c_press:
                self.copy()

            if key_ctrl_down and key_x_press:
                if len(self.get_selection()) > 0:
                    text = self.get_selection()
                    if text != "":
                        SDL_SetClipboardText(text.encode('utf-8'))
                    self.eliminate_selection()

            if key_ctrl_down and key_a_press:
                self.cursor_position = 0
                self.selection = len(self.text)

            # ddt.rect(rect, [255, 50, 50, 80], True)
            if coll(rect) and not field_menu.active:
                gui.cursor_want = 2

            # Delete key to remove text in front of cursor
            if key_del:
                if self.selection != self.cursor_position:
                    self.eliminate_selection()
                else:
                    self.text = self.text[0:len(self.text) - self.cursor_position] + self.text[len(
                        self.text) - self.cursor_position + 1:]
                    if self.cursor_position > 0:
                        self.cursor_position -= 1
                    self.selection = self.cursor_position

            if key_home_press:
                self.cursor_position = len(self.text)
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position
            if key_end_press:
                self.cursor_position = 0
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position

            width -= round(15 * gui.scale)
            t_len = ddt.get_text_w(self.text, font)
            if active and editline and editline != input_text:
                t_len += ddt.get_text_w(editline, font)
            if not click and not self.down_lock:
                cursor_x = ddt.get_text_w(self.text[:len(self.text) - self.cursor_position], font)
                if self.cursor_position == 0 or cursor_x < self.offset + round(
                        15 * gui.scale) or cursor_x > self.offset + width:
                    if t_len > width:
                        self.offset = t_len - width

                        if cursor_x < self.offset:
                            self.offset = cursor_x - round(15 * gui.scale)

                            if self.offset < 0:
                                self.offset = 0
                    else:
                        self.offset = 0

            x -= self.offset

            if coll(select_rect):  # coll((x - 15, y, width + 16, selection_height + 1)):
                # ddt.rect_r((x - 15, y, width + 16, 19), [50, 255, 50, 50], True)
                if click:
                    pre = 0
                    post = 0
                    if mouse_position[0] < x + 1:
                        self.cursor_position = len(self.text)
                    else:
                        for i in range(len(self.text)):
                            post = ddt.get_text_w(self.text[0:i + 1], font)
                            # pre_half = int((post - pre) / 2)

                            if x + pre - 0 <= mouse_position[0] <= x + post + 0:
                                diff = post - pre
                                if mouse_position[0] >= x + pre + int(diff / 2):
                                    self.cursor_position = len(self.text) - i - 1
                                else:
                                    self.cursor_position = len(self.text) - i
                                break
                            pre = post
                        else:
                            self.cursor_position = 0
                    self.selection = 0
                    self.down_lock = True

            if mouse_up:
                self.down_lock = False
            if self.down_lock:
                pre = 0
                post = 0
                text = self.text
                if secret:
                    text = '●' * len(self.text)
                if mouse_position[0] < x + 1:
                    self.selection = len(text)
                else:

                    for i in range(len(text)):
                        post = ddt.get_text_w(text[0:i + 1], font)
                        # pre_half = int((post - pre) / 2)

                        if x + pre - 0 <= mouse_position[0] <= x + post + 0:
                            diff = post - pre

                            if mouse_position[0] >= x + pre + int(diff / 2):
                                self.selection = len(text) - i - 1

                            else:
                                self.selection = len(text) - i

                            break
                        pre = post

                    else:
                        self.selection = 0

            text = self.text[0: len(self.text) - self.cursor_position]
            if secret:
                text = '●' * len(text)
            a = ddt.get_text_w(text, font)

            text = self.text[0: len(self.text) - self.selection]
            if secret:
                text = '●' * len(text)
            b = ddt.get_text_w(text, font)

            top = y
            if big:
                top -= 12 * gui.scale

            ddt.rect([a, 0, b - a, selection_height], [40, 120, 180, 255])

            if self.selection != self.cursor_position:
                inf_comp = 0
                text = self.get_selection(0)
                if secret:
                    text = '●' * len(text)
                space = ddt.text((0, 0), text, colour, font)
                text = self.get_selection(1)
                if secret:
                    text = '●' * len(text)
                space += ddt.text((0 + space - inf_comp, 0), text, [240, 240, 240, 255], font,
                                  bg=[40, 120, 180, 255], )
                text = self.get_selection(2)
                if secret:
                    text = '●' * len(text)
                ddt.text((0 + space - (inf_comp * 2), 0), text, colour, font)
            else:
                text = self.text
                if secret:
                    text = '●' * len(text)
                ddt.text((0, 0), text, colour, font)

            text = self.text[0: len(self.text) - self.cursor_position]
            if secret:
                text = '●' * len(text)
            space = ddt.get_text_w(text, font)

            if TextBox.cursor and self.selection == self.cursor_position:
                # ddt.line(x + space, y + 2, x + space, y + 15, colour)

                ddt.rect((0 + space, 0 + 2, 1 * gui.scale, 14 * gui.scale), colour)

            if click:
                self.selection = self.cursor_position

        else:
            width -= round(15 * gui.scale)
            text = self.text
            if secret:
                text = '●' * len(text)
            t_len = ddt.get_text_w(text, font)
            ddt.text((0, 0), text, colour, font)
            self.offset = 0
            if coll(rect) and not field_menu.active:
                gui.cursor_want = 2

        if active and editline != "" and editline != input_text:
            ex = ddt.text((space + 4, 0), editline, [240, 230, 230, 255], font)
            tw, th = ddt.get_text_wh(editline, font, max_x=2000)
            ddt.rect((space + round(4 * gui.scale), th + round(2 * gui.scale), ex, round(1 * gui.scale)),
                     [245, 245, 245, 255])

            rect = SDL_Rect(round(x + space + tw + 5 * gui.scale), round(y + th + 4 * gui.scale), 1, 1)
            SDL_SetTextInputRect(rect)

        animate_monitor_timer.set()

        text_box_canvas_hide_rect.x = 0
        text_box_canvas_hide_rect.y = 0

        # if self.offset:
        SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_NONE)

        text_box_canvas_hide_rect.w = round(self.offset)
        SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
        SDL_RenderFillRect(renderer, text_box_canvas_hide_rect)

        text_box_canvas_hide_rect.w = round(t_len)
        text_box_canvas_hide_rect.x = round(self.offset + width + round(5 * gui.scale))
        SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
        SDL_RenderFillRect(renderer, text_box_canvas_hide_rect)

        SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND)
        SDL_SetRenderTarget(renderer, gui.main_texture)

        text_box_canvas_rect.x = round(x)
        text_box_canvas_rect.y = round(y)
        SDL_RenderCopy(renderer, text_box_canvas, None, text_box_canvas_rect)


class TextBox:
    cursor = True

    def __init__(self):

        self.text = ""
        self.cursor_position = 0
        self.selection = 0
        self.down_lock = False

    def paste(self):

        if SDL_HasClipboardText():
            clip = SDL_GetClipboardText().decode('utf-8')

            if 'http://' in self.text and 'http://' in clip:
                self.text = ""

            clip = clip.rstrip(" ").lstrip(" ")
            clip = clip.replace('\n', ' ').replace('\r', '')

            self.eliminate_selection()
            self.text = self.text[0: len(self.text) - self.cursor_position] + clip + self.text[len(
                self.text) - self.cursor_position:]

    def copy(self):

        text = self.get_selection()
        if not text:
            text = self.text
        if text != "":
            SDL_SetClipboardText(text.encode('utf-8'))

    def set_text(self, text):

        self.text = text
        self.cursor_position = 0
        self.selection = 0

    def clear(self):
        self.text = ""

    def highlight_all(self):

        self.selection = len(self.text)
        self.cursor_position = 0

    def highlight_none(self):
        self.selection = 0
        self.cursor_position = 0

    def eliminate_selection(self):
        if self.selection != self.cursor_position:
            if self.selection > self.cursor_position:
                self.text = self.text[0: len(self.text) - self.selection] + self.text[
                                                                            len(self.text) - self.cursor_position:]
                self.selection = self.cursor_position
            else:
                self.text = self.text[0: len(self.text) - self.cursor_position] + self.text[
                                                                                  len(self.text) - self.selection:]
                self.cursor_position = self.selection

    def get_selection(self, p=1):
        if self.selection != self.cursor_position:
            if p == 1:
                if self.selection > self.cursor_position:
                    return self.text[len(self.text) - self.selection: len(self.text) - self.cursor_position]

                else:
                    return self.text[len(self.text) - self.cursor_position: len(self.text) - self.selection]
            if p == 0:
                return self.text[0: len(self.text) - max(self.cursor_position, self.selection)]
            if p == 2:
                return self.text[len(self.text) - min(self.cursor_position, self.selection):]

        else:
            return ""

    def draw(self, x, y, colour, active=True, secret=False, font=13, width=0, click=False, selection_height=18,
             big=False):

        # A little bit messy.
        # For now, this is set up so where 'width' is set > 0, the cursor position becomes editable,
        # otherwise it is fixed to end

        selection_height *= gui.scale

        if click is False:
            click = inp.mouse_click

        if width > 0 and active:

            rect = (x - 3, y - 2, width - 3, 21 * gui.scale)
            select_rect = (x - 20 * gui.scale, y - 2, width + 20 * gui.scale, 21 * gui.scale)
            if big:
                rect = (x - 3, y - 15 * gui.scale, width - 3, 35 * gui.scale)
                select_rect = (x - 50 * gui.scale, y - 15 * gui.scale, width + 50 * gui.scale, 35 * gui.scale)

            # Activate Menu
            if coll(rect):
                if right_click or level_2_right_click:
                    field_menu.activate(self)

            if click and field_menu.active:
                # field_menu.click()
                click = False

            # Add text from input
            if input_text != "":
                self.eliminate_selection()
                self.text = self.text[0: len(self.text) - self.cursor_position] + input_text + self.text[
                                                                                               len(self.text) - self.cursor_position:]

            def g():
                if len(self.text) == 0 or self.cursor_position == len(self.text):
                    return None
                return self.text[len(self.text) - self.cursor_position - 1]

            def g2():
                if len(self.text) == 0 or self.cursor_position == 0:
                    return None
                return self.text[len(self.text) - self.cursor_position]

            def d():
                self.text = self.text[0: len(self.text) - self.cursor_position - 1] + self.text[
                                                                                      len(self.text) - self.cursor_position:]
                self.selection = self.cursor_position

            # Ctrl + Backspace to delete word
            if inp.backspace_press and (key_ctrl_down or key_rctrl_down) and \
                    self.cursor_position == self.selection and len(self.text) > 0 and self.cursor_position < len(
                self.text):
                while g() == " ":
                    d()
                while g() != " " and g() != None:
                    d()

            # Ctrl + left to move cursor back a word
            elif (key_ctrl_down or key_rctrl_down) and key_left_press:
                while g() == " ":
                    self.cursor_position += 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                while g() != None and g() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
                    self.cursor_position += 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                    if g() == " ":
                        self.cursor_position -= 1
                        if not key_shift_down:
                            self.selection = self.cursor_position
                        break

            # Ctrl + right to move cursor forward a word
            elif (key_ctrl_down or key_rctrl_down) and key_right_press:
                while g2() == " ":
                    self.cursor_position -= 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                while g2() != None and g2() not in " !\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~":
                    self.cursor_position -= 1
                    if not key_shift_down:
                        self.selection = self.cursor_position
                    if g2() == " ":
                        self.cursor_position += 1
                        if not key_shift_down:
                            self.selection = self.cursor_position
                        break

            # Handle normal backspace
            elif inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
                while inp.backspace_press and len(self.text) > 0 and self.cursor_position < len(self.text):
                    if self.selection != self.cursor_position:
                        self.eliminate_selection()
                    else:
                        self.text = self.text[0:len(self.text) - self.cursor_position - 1] + self.text[
                                                                                             len(self.text) - self.cursor_position:]
                    inp.backspace_press -= 1
            elif inp.backspace_press and len(self.get_selection()) > 0:
                self.eliminate_selection()

            # Left and right arrow keys to move cursor
            if key_right_press:
                if self.cursor_position > 0:
                    self.cursor_position -= 1
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position

            if key_left_press:
                if self.cursor_position < len(self.text):
                    self.cursor_position += 1
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position

            # Paste via ctrl-v
            if key_ctrl_down and key_v_press:
                clip = SDL_GetClipboardText().decode('utf-8')
                self.eliminate_selection()
                self.text = self.text[0: len(self.text) - self.cursor_position] + clip + self.text[len(
                    self.text) - self.cursor_position:]

            if key_ctrl_down and key_c_press:
                self.copy()

            if key_ctrl_down and key_x_press:
                if len(self.get_selection()) > 0:
                    text = self.get_selection()
                    if text != "":
                        SDL_SetClipboardText(text.encode('utf-8'))
                    self.eliminate_selection()

            if key_ctrl_down and key_a_press:
                self.cursor_position = 0
                self.selection = len(self.text)

            # ddt.rect_r(rect, [255, 50, 50, 80], True)
            if coll(rect) and not field_menu.active:
                gui.cursor_want = 2

            fields.add(rect)

            # Delete key to remove text in front of cursor
            if key_del:
                if self.selection != self.cursor_position:
                    self.eliminate_selection()
                else:
                    self.text = self.text[0:len(self.text) - self.cursor_position] + self.text[len(
                        self.text) - self.cursor_position + 1:]
                    if self.cursor_position > 0:
                        self.cursor_position -= 1
                    self.selection = self.cursor_position

            if key_home_press:
                self.cursor_position = len(self.text)
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position
            if key_end_press:
                self.cursor_position = 0
                if not key_shift_down and not key_shiftr_down:
                    self.selection = self.cursor_position

            if coll(select_rect):
                # ddt.rect_r((x - 15, y, width + 16, 19), [50, 255, 50, 50], True)
                if click:
                    pre = 0
                    post = 0
                    if mouse_position[0] < x + 1:
                        self.cursor_position = len(self.text)
                    else:
                        for i in range(len(self.text)):
                            post = ddt.get_text_w(self.text[0:i + 1], font)
                            # pre_half = int((post - pre) / 2)

                            if x + pre - 0 <= mouse_position[0] <= x + post + 0:
                                diff = post - pre
                                if mouse_position[0] >= x + pre + int(diff / 2):
                                    self.cursor_position = len(self.text) - i - 1
                                else:
                                    self.cursor_position = len(self.text) - i
                                break
                            pre = post
                        else:
                            self.cursor_position = 0
                    self.selection = 0
                    self.down_lock = True

            if mouse_up:
                self.down_lock = False
            if self.down_lock:
                pre = 0
                post = 0
                if mouse_position[0] < x + 1:

                    self.selection = len(self.text)
                else:

                    for i in range(len(self.text)):
                        post = ddt.get_text_w(self.text[0:i + 1], font)
                        # pre_half = int((post - pre) / 2)

                        if x + pre - 0 <= mouse_position[0] <= x + post + 0:
                            diff = post - pre

                            if mouse_position[0] >= x + pre + int(diff / 2):
                                self.selection = len(self.text) - i - 1

                            else:
                                self.selection = len(self.text) - i

                            break
                        pre = post

                    else:
                        self.selection = 0

            a = ddt.get_text_w(self.text[0: len(self.text) - self.cursor_position], font)
            # print("")
            # print(self.selection)
            # print(self.cursor_position)

            b = ddt.get_text_w(self.text[0: len(self.text) - self.selection], font)

            # rint((a, b))

            top = y
            if big:
                top -= 12 * gui.scale

            ddt.rect([x + a, top, b - a, selection_height], [40, 120, 180, 255])

            if self.selection != self.cursor_position:
                inf_comp = 0
                space = ddt.text((x, y), self.get_selection(0), colour, font)
                space += ddt.text((x + space - inf_comp, y), self.get_selection(1), [240, 240, 240, 255], font,
                                  bg=[40, 120, 180, 255], )
                ddt.text((x + space - (inf_comp * 2), y), self.get_selection(2), colour, font)
            else:
                ddt.text((x, y), self.text, colour, font)

            space = ddt.get_text_w(self.text[0: len(self.text) - self.cursor_position], font)

            if TextBox.cursor and self.selection == self.cursor_position:
                # ddt.line(x + space, y + 2, x + space, y + 15, colour)

                if big:
                    # ddt.rect_r((xx + 1 , yy - 12 * gui.scale, 2 * gui.scale, 27 * gui.scale), colour, True)
                    ddt.rect((x + space, y - 15 * gui.scale + 2, 1 * gui.scale, 30 * gui.scale), colour)
                else:
                    ddt.rect((x + space, y + 2, 1 * gui.scale, 14 * gui.scale), colour)

            if click:
                self.selection = self.cursor_position

        else:
            if active:
                self.text += input_text
                if input_text != "":
                    self.cursor = True

                while inp.backspace_press and len(self.text) > 0:
                    self.text = self.text[:-1]
                    inp.backspace_press -= 1

                if key_ctrl_down and key_v_press:
                    self.paste()

            if secret:
                space = ddt.text((x, y), '●' * len(self.text), colour, font)
            else:
                space = ddt.text((x, y), self.text, colour, font)

            if active and TextBox.cursor:
                xx = x + space + 1
                yy = y + 3
                if big:
                    ddt.rect((xx + 1, yy - 12 * gui.scale, 2 * gui.scale, 27 * gui.scale), colour)
                else:
                    ddt.rect((xx, yy, 1 * gui.scale, 14 * gui.scale), colour)

        if active and editline != "" and editline != input_text:
            ex = ddt.text((x + space + 4, y), editline, [240, 230, 230, 255], font)
            tw, th = ddt.get_text_wh(editline, font, max_x=2000)
            ddt.rect((x + space + round(4 * gui.scale), (y + th) - round(4 * gui.scale), ex, round(1 * gui.scale)),
                     [245, 245, 245, 255])

            rect = SDL_Rect(round(round(x + space + tw + 5 * gui.scale)), round(y + th + 4 * gui.scale), 1, 1)
            SDL_SetTextInputRect(rect)

        animate_monitor_timer.set()


rename_text_area = TextBox()
gst_output_field = TextBox2()
gst_output_field.text = prefs.gst_output
search_text = TextBox()
rename_files = TextBox2()
sub_lyrics_a = TextBox2()
sub_lyrics_b = TextBox2()
sync_target = TextBox2()
edit_artist = TextBox2()
edit_album = TextBox2()
edit_title = TextBox2()
edit_album_artist = TextBox2()

rename_files.text = prefs.rename_tracks_template
if rename_files_previous:
    rename_files.text = rename_files_previous

text_plex_usr = TextBox2()
text_plex_pas = TextBox2()
text_plex_ser = TextBox2()

text_jelly_usr = TextBox2()
text_jelly_pas = TextBox2()
text_jelly_ser = TextBox2()

text_koel_usr = TextBox2()
text_koel_pas = TextBox2()
text_koel_ser = TextBox2()

text_air_usr = TextBox2()
text_air_pas = TextBox2()
text_air_ser = TextBox2()

text_spot_client = TextBox2()
text_spot_secret = TextBox2()
text_spot_username = TextBox2()
text_spot_password = TextBox2()

text_maloja_url = TextBox2()
text_maloja_key = TextBox2()

text_sat_url = TextBox2()
text_sat_playlist = TextBox2()

rename_folder = TextBox2()
rename_folder.text = prefs.rename_folder_template
if rename_folder_previous:
    rename_folder.text = rename_folder_previous

temp_dest = SDL_Rect(0, 0)


class GallClass:
    def __init__(self, size=250, save_out=True):
        self.gall = {}
        self.size = size
        self.queue = []
        self.key_list = []
        self.save_out = save_out
        self.i = 0
        self.lock = threading.Lock()
        self.limit = 60

    def get_file_source(self, track_object):

        global album_art_gen

        sources = album_art_gen.get_sources(track_object)

        if len(sources) == 0:
            return False, 0

        offset = album_art_gen.get_offset(track_object.fullpath, sources)
        return sources[offset], offset

    def worker_render(self):

        self.lock.acquire()
        # time.sleep(0.1)

        if search_over.active:
            while QuickThumbnail.queue:
                img = QuickThumbnail.queue.pop(0)
                response = urllib.request.urlopen(img.url, cafile=tauon.ca)
                source_image = io.BytesIO(response.read())
                img.read_and_thumbnail(source_image, img.size, img.size)
                gui.update += 1

        while len(self.queue) > 0:

            if gui.halt_image_rendering:
                self.queue.clear()
                break

            self.i += 1

            try:
                # key = self.queue[0]
                key = self.queue.pop(0)
            except:
                print("thumb queue empty")
                break

            if key not in self.gall:
                order = [1, None, None, None]
                self.gall[key] = order
            else:
                order = self.gall[key]

            size = key[1]

            slow_load = False
            cache_load = False

            try:

                if True:
                    offset = 0
                    parent_folder = key[0].parent_folder_path
                    if parent_folder in folder_image_offsets:
                        offset = folder_image_offsets[parent_folder]
                    img_name = str(key[2]) + "-" + str(size) + '-' + str(key[0].index) + "-" + str(offset)
                    if prefs.cache_gallery and os.path.isfile(os.path.join(g_cache_dir, img_name + '.jpg')):
                        source_image = open(os.path.join(g_cache_dir, img_name + '.jpg'), 'rb')
                        # print('load from cache')
                        cache_load = True
                    else:
                        slow_load = True

                if slow_load:

                    source, c_offset = self.get_file_source(key[0])

                    if source is False:
                        order[0] = 0
                        self.gall[key] = order
                        # del self.queue[0]
                        continue

                    img_name = str(key[2]) + "-" + str(size) + '-' + str(key[0].index) + "-" + str(c_offset)

                    # gall_render_last_timer.set()

                    if prefs.cache_gallery and os.path.isfile(os.path.join(g_cache_dir, img_name + '.jpg')):
                        source_image = open(os.path.join(g_cache_dir, img_name + '.jpg'), 'rb')
                        print("slow load image")
                        cache_load = True

                    # elif source[0] == 1:
                    #     # print('tag')
                    #     source_image = io.BytesIO(album_art_gen.get_embed(key[0]))
                    #
                    # elif source[0] == 2:
                    #     try:
                    #         url = get_network_thumbnail_url(key[0])
                    #         response = urllib.request.urlopen(url)
                    #         source_image = response
                    #     except:
                    #         print("IMAGE NETWORK LOAD ERROR")
                    # else:
                    #     source_image = open(source[1], 'rb')
                    source_image = album_art_gen.get_source_raw(0, 0, key[0], subsource=source)

                g = io.BytesIO()
                g.seek(0)

                if cache_load:
                    g.write(source_image.read())

                else:
                    error = False
                    try:
                        # Process image
                        im = Image.open(source_image)
                        if im.mode != "RGB":
                            im = im.convert("RGB")
                        im.thumbnail((size, size), Image.Resampling.LANCZOS)
                    except:
                        im = album_art_gen.get_error_img(size)
                        error = True

                    im.save(g, 'BMP')

                    if not error and self.save_out and prefs.cache_gallery and not os.path.isfile(
                            os.path.join(g_cache_dir, img_name + '.jpg')):
                        im.save(os.path.join(g_cache_dir, img_name + '.jpg'), 'JPEG', quality=95)

                g.seek(0)

                # source_image.close()

                order = [2, g, None, None]
                self.gall[key] = order

                gui.update += 1
                # del self.queue[0]

                time.sleep(0.001)

            except:
                # raise
                # print('ERROR: Image load failed on track: ' + key[0].fullpath)
                console.print('ERROR: Image load failed on track: ')
                console.print("- " + key[0].fullpath)
                order = [0, None, None, None]
                self.gall[key] = order
                gui.update += 1
                # del self.queue[0]

            if size < 150:
                random.shuffle(self.queue)

        if self.i > 0:
            self.i = 0
            return True
        else:
            return False

    def render(self, track, location, size=None, force_offset=None):

        if gallery_load_delay.get() < 0.5:
            return

        x = round(location[0])
        y = round(location[1])

        # time.sleep(0.1)
        if size is None:
            size = self.size

        size = round(size)

        # offset = self.get_offset(pctl.master_library[index].fullpath, self.get_sources(index))
        if track.parent_folder_path in folder_image_offsets:
            offset = folder_image_offsets[track.parent_folder_path]
        else:
            offset = 0

        if force_offset is not None:
            offset = force_offset

        key = (track, size, offset)

        if key in self.gall:
            # print("old")

            order = self.gall[key]

            if order[0] == 0:
                # broken
                return False

            if order[0] == 1:
                # not done yet
                return False

            if order[0] == 2:
                # finish processing

                wop = rw_from_object(order[1])
                s_image = IMG_Load_RW(wop, 0)
                c = SDL_CreateTextureFromSurface(renderer, s_image)
                SDL_FreeSurface(s_image)
                tex_w = pointer(c_int(size))
                tex_h = pointer(c_int(size))
                SDL_QueryTexture(c, None, None, tex_w, tex_h)
                dst = SDL_Rect(x, y)
                dst.w = int(tex_w.contents.value)
                dst.h = int(tex_h.contents.value)

                order[0] = 3
                order[1] = None
                order[2] = c
                order[3] = dst
                self.gall[(track, size, offset)] = order

            if order[0] == 3:
                # ready

                order[3].x = x
                order[3].y = y
                order[3].x = int((size - order[3].w) / 2) + order[3].x
                order[3].y = int((size - order[3].h) / 2) + order[3].y
                SDL_RenderCopy(renderer, order[2], None, order[3])

                if (track, size, offset) in self.key_list:
                    self.key_list.remove((track, size, offset))
                self.key_list.append((track, size, offset))

                # Remove old images to conserve RAM usage
                if len(self.key_list) > self.limit:
                    gui.update += 1
                    key = self.key_list[0]
                    # while key in self.queue:
                    #     self.queue.remove(key)
                    if self.gall[key][2] is not None:
                        SDL_DestroyTexture(self.gall[key][2])
                    del self.gall[key]
                    del self.key_list[0]

                return True

        else:

            if key not in self.queue:
                self.queue.append(key)
                try:
                    self.lock.release()
                except:
                    pass

        return False


gall_ren = GallClass(album_mode_art_size)
tauon.gall_ren = gall_ren

pl_thumbnail = GallClass(save_out=False)


class ThumbTracks:
    def __init__(self):
        pass

    def path(self, track):

        source, offset = gall_ren.get_file_source(track)

        if source is False:  # No art
            return None

        image_name = track.album + track.parent_folder_path + str(offset)
        image_name = hashlib.md5(image_name.encode('utf-8', 'replace')).hexdigest()

        t_path = os.path.join(e_cache_dir, image_name + '.jpg')

        if os.path.isfile(t_path):
            return t_path

        source_image = album_art_gen.get_source_raw(0, 0, track, subsource=source)

        im = Image.open(source_image)
        if im.mode != "RGB":
            im = im.convert("RGB")
        im.thumbnail((1000, 1000), Image.Resampling.LANCZOS)

        im.save(t_path, 'JPEG')

        return t_path


thumb_tracks = ThumbTracks()
tauon.thumb_tracks = thumb_tracks


def img_slide_update_gall(value, pause=True):
    global album_mode_art_size
    gui.halt_image_rendering = True

    album_mode_art_size = value

    clear_img_cache(False)
    if pause:
        gallery_load_delay.set()
        gui.frame_callback_list.append(TestTimer(0.6))
    gui.halt_image_rendering = False

    # Update sizes
    gall_ren.size = album_mode_art_size

    if album_mode_art_size > 150:
        prefs.thin_gallery_borders = False


def clear_img_cache(delete_disk=True):
    global album_art_gen
    album_art_gen.clear_cache()
    prefs.failed_artists.clear()
    prefs.failed_background_artists.clear()
    gall_ren.key_list = []

    i = 0
    while len(gall_ren.queue) > 0:
        time.sleep(0.01)
        i += 1
        if i > 5 / 0.01:
            break

    for key, value in gall_ren.gall.items():
        SDL_DestroyTexture(value[2])
    gall_ren.gall = {}

    if delete_disk:
        dirs = [g_cache_dir, n_cache_dir, e_cache_dir]
        for direc in dirs:
            if os.path.isdir(direc):
                for item in os.listdir(direc):
                    path = os.path.join(direc, item)
                    os.remove(path)

    prefs.failed_artists.clear()
    for key, value in artist_list_box.thumb_cache.items():
        if value:
            SDL_DestroyTexture(value[0])
    artist_list_box.thumb_cache.clear()
    gui.update += 1


def clear_track_image_cache(track):
    gui.halt_image_rendering = True
    if gall_ren.queue:
        time.sleep(0.05)
    if gall_ren.queue:
        time.sleep(0.2)
    if gall_ren.queue:
        time.sleep(0.5)

    direc = os.path.join(g_cache_dir)
    if os.path.isdir(direc):
        for item in os.listdir(direc):
            n = item.split("-")
            if len(n) > 2 and n[2] == str(track.index):
                os.remove(os.path.join(direc, item))
                print("Cleared cache thumbnail: " + os.path.join(direc, item))

    keys = set()
    for key, value in gall_ren.gall.items():
        if key[0] == track:
            SDL_DestroyTexture(value[2])
            if key not in keys:
                keys.add(key)
    for key in keys:
        del gall_ren.gall[key]
        if key in gall_ren.key_list:
            gall_ren.key_list.remove(key)

    gui.halt_image_rendering = False
    album_art_gen.clear_cache()


class ImageObject():
    def __init__(self):
        self.index = 0
        self.texture = None
        self.rect = None
        self.request_size = (0, 0)
        self.original_size = (0, 0)
        self.actual_size = (0, 0)
        self.source = ""
        self.offset = 0
        self.stats = True
        self.format = ""


class AlbumArt():
    def __init__(self):
        self.image_types = {'jpg', 'JPG', 'jpeg', 'JPEG', 'PNG', 'png', 'BMP', 'bmp', 'GIF', 'gif', "jxl", "JXL"}
        self.art_folder_names = {'art', 'scans', 'scan', 'booklet', 'images', 'image', 'cover',
                                 'covers', 'coverart', 'albumart', 'gallery', 'jacket', 'artwork',
                                 'bonus', 'bk', 'cover artwork', 'cover art'}
        self.source_cache = {}
        self.image_cache = []
        self.current_wu = None

        self.blur_texture = None
        self.blur_rect = None
        self.loaded_bg_type = 0

        self.download_in_progress = False
        self.downloaded_image = None
        self.downloaded_track = None

        self.base64cache = (0, 0, "")
        self.processing64on = None

        self.bin_cached = (None, None, None)  # track, subsource, bin

        self.embed_cached = (None, None)

    def async_download_image(self, track, subsource):

        self.downloaded_image = album_art_gen.get_source_raw(0, 0, track, subsource=subsource)
        self.downloaded_track = track
        self.download_in_progress = False
        gui.update += 1

    def get_info(self, track_object):

        sources = self.get_sources(track_object)
        if len(sources) == 0:
            return None

        offset = self.get_offset(track_object.fullpath, sources)

        o_size = (0, 0)
        format = "ERROR"

        for item in self.image_cache:
            if item.index == track_object.index and item.offset == offset:
                o_size = item.original_size
                format = item.format
                break

        else:
            # Hacky fix
            # A quirk is the index stays of the cached image.
            # This workaround can be done since (currently) cache has max size of 1
            if self.image_cache:
                o_size = self.image_cache[0].original_size
                format = self.image_cache[0].format

        return [sources[offset][0], len(sources), offset, o_size, format]

    def get_sources(self, tr):

        filepath = tr.fullpath
        ext = tr.file_ext

        # Check if source list already exists, if not, make it
        if tr.index in self.source_cache:
            return self.source_cache[tr.index]
        else:
            pass

        source_list = []  # istag,

        # Source type the is first element in list
        # 0 = File
        # 1 = Embedded in tag
        # 2 = Network location

        if tr.is_network:
            # Add url if network target
            if tr.art_url_key:
                source_list.append([2, tr.art_url_key])
        else:
            # Check for local image files
            try:
                direc = os.path.dirname(filepath)
                items_in_dir = os.listdir(direc)
            except:
                print(f"Error loading directory: {direc}")
                return []

        # Check for embedded image
        try:
            pic = self.get_embed(tr)
            if pic:
                source_list.append([1, filepath])
        except:
            pass

        if not tr.is_network:

            dirs_in_dir = [subdirec for subdirec in items_in_dir if
                           os.path.isdir(os.path.join(direc, subdirec)) and subdirec.lower() in self.art_folder_names]

            ins = len(source_list)
            for i in range(len(items_in_dir)):
                if os.path.splitext(items_in_dir[i])[1][1:] in self.image_types:
                    dir_path = os.path.join(direc, items_in_dir[i]).replace('\\', "/")
                    # The image name "Folder" is likely desired to be prioritised over other names
                    if os.path.splitext(os.path.basename(dir_path))[0] in ("Folder", "folder", "Cover", "cover"):
                        source_list.insert(ins, [0, dir_path])
                    else:
                        source_list.append([0, dir_path])

            for i in range(len(dirs_in_dir)):
                subdirec = os.path.join(direc, dirs_in_dir[i])
                items_in_dir2 = os.listdir(subdirec)

                for y in range(len(items_in_dir2)):
                    if os.path.splitext(items_in_dir2[y])[1][1:] in self.image_types:
                        dir_path = os.path.join(subdirec, items_in_dir2[y]).replace('\\', "/")
                        source_list.append([0, dir_path])

        self.source_cache[tr.index] = source_list

        return source_list

    def get_error_img(self, size):
        im = Image.open(os.path.join(install_directory, "assets", "load-error.png"))
        im.thumbnail((size, size), Image.Resampling.LANCZOS)
        return im

    def fast_display(self, index, location, box, source, offset):

        # Renders cached image only by given size for faster performance

        found_unit = None
        max_h = 0

        for unit in self.image_cache:
            if unit.source == source[offset][1]:
                if unit.actual_size[1] > max_h:
                    max_h = unit.actual_size[1]
                    found_unit = unit

        if found_unit == None:
            return 1

        unit = found_unit

        temp_dest.x = round(location[0])
        temp_dest.y = round(location[1])

        temp_dest.w = unit.original_size[0]  # round(box[0])
        temp_dest.h = unit.original_size[1]  # round(box[1])

        bh = round(box[1])
        bw = round(box[0])

        if prefs.zoom_art:
            temp_dest.w, temp_dest.h = fit_box((unit.original_size[0], unit.original_size[1]), box)
        else:

            # Constrain image to given box
            if temp_dest.w > bw:
                temp_dest.w = bw
                temp_dest.h = int(bw * (unit.original_size[1] / unit.original_size[0]))

            if temp_dest.h > bh:
                temp_dest.h = bh
                temp_dest.w = int(temp_dest.h * (unit.original_size[0] / unit.original_size[1]))

            # prevent scaling larger than original image size
            if temp_dest.w > unit.original_size[0] or temp_dest.h > unit.original_size[1]:
                temp_dest.w = unit.original_size[0]
                temp_dest.h = unit.original_size[1]

        # center the image
        temp_dest.x = int((box[0] - temp_dest.w) / 2) + temp_dest.x
        temp_dest.y = int((box[1] - temp_dest.h) / 2) + temp_dest.y

        # render the image
        SDL_RenderCopy(renderer, unit.texture, None, temp_dest)
        style_overlay.hole_punches.append(temp_dest)

        gui.art_drawn_rect = (temp_dest.x, temp_dest.y, temp_dest.w, temp_dest.h)

        return 0

    def open_external(self, track_object):

        index = track_object.index

        source = self.get_sources(track_object)
        if len(source) == 0:
            return 0

        offset = self.get_offset(track_object.fullpath, source)

        if track_object.is_network:
            show_message("Saving network images not implemented")
            return 0
        if source[offset][0] > 0:
            pic = album_art_gen.get_embed(track_object)
            if not pic:
                show_message("Image save error.", "No embedded album art.", mode='warning')
                return 0

            source_image = io.BytesIO(pic)
            im = Image.open(source_image)
            source_image.close()

            ext = "." + im.format.lower()
            if im.format == "JPEG":
                ext = ".jpg"
            target = os.path.join(cache_directory, "open-image")
            if not os.path.exists(target):
                os.makedirs(target)
            target = os.path.join(target, "embed-" + str(im.height) + "px-" + str(track_object.index) + ext)

            if len(pic) > 30:
                with open(target, 'wb') as w:
                    w.write(pic)

        else:
            target = source[offset][1]

        if system == "windows" or msys:
            os.startfile(target)
        elif macos:
            subprocess.call(["open", target])
        else:
            subprocess.call(["xdg-open", target])

        return 0

    def cycle_offset(self, track_object, reverse=False):

        filepath = track_object.fullpath
        sources = self.get_sources(track_object)
        if len(sources) == 0:
            return 0
        parent_folder = os.path.dirname(filepath)
        # Find cached offset
        if parent_folder in folder_image_offsets:

            if reverse:
                folder_image_offsets[parent_folder] -= 1
            else:
                folder_image_offsets[parent_folder] += 1

            folder_image_offsets[parent_folder] %= len(sources)
        return 0

    def cycle_offset_reverse(self, track_object):
        self.cycle_offset(track_object, True)

    def get_offset(self, filepath, source):

        # Check if folder offset already exsts, if not, make it
        parent_folder = os.path.dirname(filepath)

        if parent_folder in folder_image_offsets:

            # Reset the offset if greater than number of images available
            if folder_image_offsets[parent_folder] > len(source) - 1:
                folder_image_offsets[parent_folder] = 0
        else:
            folder_image_offsets[parent_folder] = 0

        return folder_image_offsets[parent_folder]

    def get_embed(self, track):

        # cached = self.embed_cached
        # if cached[0] == track:
        #    # print("used cached")
        #    return cached[1]

        filepath = track.fullpath

        # Use cached file if present
        if prefs.precache and tauon.cachement:
            path = tauon.cachement.get_file_cached_only(track)
            if path:
                filepath = path

        pic = None

        if track.file_ext == 'MP3':
            try:
                tag = mutagen.id3.ID3(filepath)
                frame = tag.getall("APIC")
                pic = frame[0].data
            except Exception as e:
                pass

            if len(pic) < 30:
                pic = None

        elif track.file_ext == 'FLAC':
            tag = Flac(filepath)
            tag.read(True)
            if tag.has_picture and len(tag.picture) > 30:
                pic = tag.picture

        elif track.file_ext == 'APE':
            tag = Ape(filepath)
            tag.read()
            if tag.has_picture and len(tag.picture) > 30:
                pic = tag.picture

        elif track.file_ext == 'M4A':
            tag = M4a(filepath)
            tag.read(True)
            if tag.has_picture and len(tag.picture) > 30:
                pic = tag.picture

        elif track.file_ext == 'OPUS' or track.file_ext == 'OGG' or track.file_ext == 'OGA':
            tag = Opus(filepath)
            tag.read()
            if tag.has_picture and len(tag.picture) > 30:
                a = io.BytesIO(base64.b64decode(tag.picture))
                a.seek(0)
                image = parse_picture_block(a)
                a.close()
                pic = image

        # self.embed_cached = (track, pic)
        return pic

    def get_source_raw(self, offset, sources, track, subsource=None):

        source_image = None

        if subsource is None:
            subsource = sources[offset]

        if subsource[0] == 1:
            # Target is a embedded image\\\
            pic = self.get_embed(track)
            assert pic
            source_image = io.BytesIO(pic)

        elif subsource[0] == 2:
            try:
                if track.file_ext == "RADIO" or track.file_ext == "Spotify":
                    if pctl.radio_image_bin:
                        return pctl.radio_image_bin

                cached_path = os.path.join(n_cache_dir, hashlib.md5(track.art_url_key.encode()).hexdigest()[:12])
                if os.path.isfile(cached_path):
                    source_image = open(cached_path, 'rb')
                else:
                    if track.file_ext == "SUB":
                        source_image = subsonic.get_cover(track)
                    elif track.file_ext == "JELY":
                        source_image = jellyfin.get_cover(track)
                    else:
                        response = urllib.request.urlopen(get_network_thumbnail_url(track), cafile=tauon.ca)
                        source_image = io.BytesIO(response.read())
                    if source_image:
                        f = open(cached_path, 'wb')
                        f.write(source_image.read())
                        f.close()
                        source_image.seek(0)

            except:
                pass

        else:
            source_image = open(subsource[1], 'rb')

        return source_image

    def get_base64(self, track, size):

        # Wait if an identical track is already being processed
        if self.processing64on == track:
            t = 0
            while True:
                if self.processing64on is None:
                    break
                time.sleep(0.05)
                t += 1
                if t > 20:
                    break

        cahced = self.base64cache
        if track == cahced[0] and size == cahced[1]:
            return cahced[2]

        self.processing64on = track

        filepath = track.fullpath
        sources = self.get_sources(track)

        if len(sources) == 0:
            self.processing64on = None
            return False

        offset = self.get_offset(filepath, sources)

        # Get source IO
        source_image = self.get_source_raw(offset, sources, track)

        if source_image is None:
            self.processing64on = None
            return ""

        im = Image.open(source_image)
        if im.mode != "RGB":
            im = im.convert("RGB")
        im.thumbnail(size, Image.Resampling.LANCZOS)
        buff = io.BytesIO()
        im.save(buff, format="JPEG")
        sss = base64.b64encode(buff.getvalue())

        self.base64cache = (track, size, sss)
        self.processing64on = None
        return sss

    def get_background(self, track):
        #print("Find background...")
        # Determine artist name to use
        artist = get_artist_safe(track)
        if not artist:
            return None

        # Check cache for existing image
        path = os.path.join(b_cache_dir, artist)
        if os.path.isfile(path):
            print("Load cached background")
            return open(path, "rb")

        else:
            # Try last.fm background
            path = artist_info_box.get_data(artist, get_img_path=True)
            if os.path.isfile(path):
                print("Load cached background lfm")
                return open(path, "rb")

        # Check we've not already attempted a search for this artist
        if artist in prefs.failed_background_artists:
            return None

        # Get artist MBID
        try:
            s = musicbrainzngs.search_artists(artist, limit=1)
            artist_id = s['artist-list'][0]['id']
        except:
            print("Failed to find artist MBID for: %s" % artist)
            prefs.failed_background_artists.append(artist)
            return None

        # Search fanart.tv for background
        try:

            r = requests.get("http://webservice.fanart.tv/v3/music/" \
                             + artist_id + "?api_key=" + prefs.fatvap, timeout=(4, 10))

            artlink = r.json()['artistbackground'][0]['url']

            response = urllib.request.urlopen(artlink, cafile=tauon.ca)
            info = response.info()

            assert info.get_content_maintype() == 'image'

            t = io.BytesIO()
            t.seek(0)
            t.write(response.read())
            t.seek(0, 2)
            l = t.tell()
            t.seek(0)

            assert l > 1000

            # Cache image for future use
            path = os.path.join(a_cache_dir, artist + '-ftv-full.jpg')
            with open(path, "wb") as f:
                f.write(t.read())
            t.seek(0)
            return t

        except:
            #raise
            print("Failed to find fanart background for: %s" % artist)
            if not gui.artist_info_panel:
                artist_info_box.get_data(artist)
                path = artist_info_box.get_data(artist, get_img_path=True)
                if os.path.isfile(path):
                    print("Downloaded background lfm")
                    return open(path, "rb")


            prefs.failed_background_artists.append(artist)
            return None

    def get_blur_im(self, track):

        source_image = None
        self.loaded_bg_type = 0
        if prefs.enable_fanart_bg:
            source_image = self.get_background(track)
            if source_image:
                self.loaded_bg_type = 1

        if source_image is None:
            filepath = track.fullpath
            sources = self.get_sources(track)

            if len(sources) == 0:
                return False

            offset = self.get_offset(filepath, sources)

            source_image = self.get_source_raw(offset, sources, track)

        if source_image is None:
            return None

        im = Image.open(source_image)

        ox_size = im.size[0]
        oy_size = im.size[1]

        format = im.format
        if im.format == "JPEG":
            format = "JPG"

        # print(im.size)
        if im.mode != "RGB":
            im = im.convert("RGB")

        ratio = window_size[0] / ox_size
        ratio += 0.2

        if (oy_size * ratio) - ((oy_size * ratio) // 4) < window_size[1]:
            print("Adjust bg vertical")
            ratio = window_size[1] / (oy_size - (oy_size // 4))
            ratio += 0.2

        new_x = round(ox_size * ratio)
        new_y = round(oy_size * ratio)

        im = im.resize((new_x, new_y))

        if self.loaded_bg_type == 1:
            artist = get_artist_safe(track)
            if artist and artist in prefs.bg_flips:
                im = im.transpose(Image.FLIP_LEFT_RIGHT)

        if (ox_size < 500 or prefs.art_bg_always_blur) or gui.mode == 3:
            blur = prefs.art_bg_blur
            if prefs.mini_mode_mode == 5 and gui.mode == 3:
                blur = 160
                pix = im.getpixel((new_x // 2, new_y // 4 * 3))
                pixel_sum = sum(pix) / (255 * 3)
                if pixel_sum > 0.6:
                    enhancer = ImageEnhance.Brightness(im)
                    deduct = 1 - ((pixel_sum - 0.6) * 1.5)
                    im = enhancer.enhance(deduct)
                    print(deduct)

                gui.center_blur_pixel = im.getpixel((new_x // 2, new_y // 4 * 3))

            im = im.filter(ImageFilter.GaussianBlur(blur))


        gui.center_blur_pixel = im.getpixel((new_x // 2, new_y // 2))

        g = io.BytesIO()
        g.seek(0)

        a_channel = Image.new('L', im.size, 255)  # 'L' 8-bit pixels, black and white
        im.putalpha(a_channel)

        im.save(g, 'PNG')
        g.seek(0)

        # source_image.close()

        return g

    def save_thumb(self, track_object, size, save_path, png=False, zoom=False):

        filepath = track_object.fullpath
        sources = self.get_sources(track_object)

        if len(sources) == 0:
            print("Error thumbnailing; no source images found")
            return False

        offset = self.get_offset(filepath, sources)
        source_image = self.get_source_raw(offset, sources, track_object)

        im = Image.open(source_image)
        if im.mode != "RGB":
            im = im.convert("RGB")

        if not zoom:
            im.thumbnail(size, Image.Resampling.LANCZOS)
        else:
            w, h = im.size
            if w != h:
                m = min(w, h)
                im = im.crop((
                    (w - m) / 2,
                    (h - m) / 2,
                    (w + m) / 2,
                    (h + m) / 2,
                ))

            im = im.resize(size, Image.Resampling.LANCZOS)

        if not save_path:
            g = io.BytesIO()
            g.seek(0)
            if png:
                im.save(g, 'PNG')
            else:
                im.save(g, 'JPEG')
            g.seek(0)
            return g

        if png:
            im.save(save_path + '.png', 'PNG')
        else:
            im.save(save_path + '.jpg', 'JPEG')

    def display(self, track, location, box, fast=False, theme_only=False):

        index = track.index
        filepath = track.fullpath

        if prefs.colour_from_image and track.album != gui.theme_temp_current and box[0] != 115:
            if track.album in gui.temp_themes:
                global colours
                colours = gui.temp_themes[track.album]
                gui.theme_temp_current = track.album

        source = self.get_sources(track)

        if len(source) == 0:
            return 1

        offset = self.get_offset(filepath, source)

        if not theme_only:
            # Check if request matches previous
            if self.current_wu is not None and self.current_wu.source == source[offset][1] and \
                    self.current_wu.request_size == box:
                self.render(self.current_wu, location)
                return 0

            if fast:
                return self.fast_display(track, location, box, source, offset)

            # Check if cached
            for unit in self.image_cache:
                if unit.index == index and unit.request_size == box and unit.offset == offset:
                    self.render(unit, location)
                    return 0

        close = True
        # Render new...
        try:
            # Get source IO
            if source[offset][0] == 1:
                # Target is a embedded image
                # source_image = io.BytesIO(self.get_embed(track))
                source_image = self.get_source_raw(0, 0, track, source[offset])

            elif source[offset][0] == 2:
                idea = os.path.join(prefs.encoder_output, encode_folder_name(track), "cover.jpg")
                if os.path.isfile(idea):
                    source_image = open(idea, "rb")
                else:
                    try:
                        close = False
                        # We want to download the image asynchronously as to not block the UI
                        if self.downloaded_image and self.downloaded_track == track:
                            source_image = self.downloaded_image

                        elif self.download_in_progress:
                            return 0

                        else:
                            self.download_in_progress = True
                            shoot_dl = threading.Thread(target=self.async_download_image,
                                                        args=([track, source[offset]]))
                            shoot_dl.daemon = True
                            shoot_dl.start()

                            # We'll block with a small timeout to avoid unwanted flashing between frames
                            s = 0
                            while self.download_in_progress:
                                s += 1
                                time.sleep(0.01)
                                if s > 20:  # 200 ms
                                    break

                            if self.downloaded_track != track:
                                return

                            assert self.downloaded_image
                            source_image = self.downloaded_image


                    except:
                        print("IMAGE NETWORK LOAD ERROR")
                        raise

            else:
                # source_image = open(source[offset][1], 'rb')
                source_image = self.get_source_raw(0, 0, track, source[offset])

            # Generate
            g = io.BytesIO()
            g.seek(0)
            im = Image.open(source_image)
            o_size = im.size

            format = im.format

            try:
                if im.format == "JPEG":
                    format = "JPG"

                if im.mode != "RGB":
                    im = im.convert("RGB")
            except:
                if theme_only:
                    return
                im = Image.open(os.path.join(install_directory, "assets", "load-error.png"))
                o_size = im.size


            if not theme_only:

                if prefs.zoom_art:
                    new_size = fit_box(o_size, box)
                    try:
                        im = im.resize(new_size, Image.Resampling.LANCZOS)
                    except:
                        im = Image.open(os.path.join(install_directory, "assets", "load-error.png"))
                        o_size = im.size
                        new_size = fit_box(o_size, box)
                        im = im.resize(new_size, Image.Resampling.LANCZOS)
                else:
                    try:
                        im.thumbnail((box[0], box[1]), Image.Resampling.LANCZOS)
                    except:
                        im = Image.open(os.path.join(install_directory, "assets", "load-error.png"))
                        o_size = im.size
                        im.thumbnail((box[0], box[1]), Image.Resampling.LANCZOS)
                im.save(g, 'BMP')
                g.seek(0)

            # Processing for "Carbon" theme
            if track == pctl.playing_object() and gui.theme_name == "Carbon" and track.parent_folder_path != colours.last_album:

                # Find main image colours
                try:
                    im.thumbnail((50, 50), Image.Resampling.LANCZOS)
                except:
                    print("theme gen error")
                    return
                pixels = im.getcolors(maxcolors=2500)
                pixels = sorted(pixels, key=lambda x: x[0], reverse=True)[:]
                colour = pixels[0][1]

                # Try and find a colour that is not grayscale
                for c in pixels:
                    cc = c[1]
                    av = sum(cc) / 3
                    if abs(cc[0] - av) > 10 or abs(cc[1] - av) > 10 or abs(cc[2] - av) > 10:
                        colour = cc
                        break

                h_colour = rgb_to_hls(colour[0], colour[1], colour[2])

                l = .51
                s = .44

                hh = h_colour[0]
                if 0.14 < hh < 0.3:  # Yellow and green are hard to read text on, so lower the luminance for those
                    l = .45
                if check_equal(colour):  # Default to theme purple if source colour was grayscale
                    hh = 0.72

                colours.bottom_panel_colour = hls_to_rgb(hh, l, s)
                colours.last_album = track.parent_folder_path

            # Processing for "Auto-theme" setting
            if prefs.colour_from_image and box[0] != 115 and track.album != gui.theme_temp_current \
                    and track.album not in gui.temp_themes:  # and pctl.master_library[index].parent_folder_path != colours.last_album: #mark2233
                colours.last_album = track.parent_folder_path

                colours = copy.deepcopy(colours)

                im.thumbnail((50, 50), Image.Resampling.LANCZOS)
                pixels = im.getcolors(maxcolors=2500)
                # print(pixels)
                pixels = sorted(pixels, key=lambda x: x[0], reverse=True)[:]
                # print(pixels)

                min_colour_varience = 75

                x_colours = []
                for item in pixels:
                    colour = item[1]
                    for cc in x_colours:
                        if abs(colour[0] - cc[0]) < min_colour_varience and abs(
                                colour[1] - cc[1]) < min_colour_varience and abs(
                            colour[2] - cc[2]) < min_colour_varience:
                            break
                    else:
                        x_colours.append(colour)

                # print(x_colours)
                colours.playlist_panel_bg = colours.side_panel_background
                colours.playlist_box_background = colours.side_panel_background

                colours.playlist_panel_background = x_colours[0] + (255,)
                if len(x_colours) > 1:
                    colours.side_panel_background = x_colours[1] + (255,)
                    colours.playlist_box_background = colours.side_panel_background
                    if len(x_colours) > 2:
                        colours.title_text = x_colours[2] + (255,)
                        colours.title_playing = x_colours[2] + (255,)
                        if len(x_colours) > 3:
                            colours.artist_text = x_colours[3] + (255,)
                            colours.artist_playing = x_colours[3] + (255,)
                            if len(x_colours) > 4:
                                colours.playlist_box_background = x_colours[4] + (255,)

                colours.queue_background = colours.side_panel_background
                # Check artist text colour
                if contrast_ratio(colours.artist_text, colours.playlist_panel_background) < 1.9:

                    black = [25, 25, 25, 255]
                    white = [220, 220, 220, 255]

                    con_b = contrast_ratio(black, colours.playlist_panel_background)
                    con_w = contrast_ratio(white, colours.playlist_panel_background)

                    choice = black
                    if con_w > con_b:
                        choice = white

                    colours.artist_text = choice
                    colours.artist_playing = choice

                # Check title text colour
                if contrast_ratio(colours.title_text, colours.playlist_panel_background) < 1.9:

                    black = [60, 60, 60, 255]
                    white = [180, 180, 180, 255]

                    con_b = contrast_ratio(black, colours.playlist_panel_background)
                    con_w = contrast_ratio(white, colours.playlist_panel_background)

                    choice = black
                    if con_w > con_b:
                        choice = white

                    colours.title_text = choice
                    colours.title_playing = choice

                if test_lumi(colours.side_panel_background) < 0.50:
                    colours.side_bar_line1 = [25, 25, 25, 255]
                    colours.side_bar_line2 = [35, 35, 35, 255]
                else:
                    colours.side_bar_line1 = [250, 250, 250, 255]
                    colours.side_bar_line2 = [235, 235, 235, 255]

                colours.album_text = colours.title_text
                colours.album_playing = colours.title_playing

                gui.pl_update = 1

                prcl = 100 - int(test_lumi(colours.playlist_panel_background) * 100)

                if prcl > 45:
                    ce = alpha_blend([0, 0, 0, 180], colours.playlist_panel_background)  # [40, 40, 40, 255]
                    colours.index_text = ce
                    colours.index_playing = ce
                    colours.time_text = ce
                    colours.bar_time = ce
                    colours.folder_title = ce
                    colours.star_line = [60, 60, 60, 255]
                    colours.row_select_highlight = [0, 0, 0, 30]
                    colours.row_playing_highlight = [0, 0, 0, 20]
                    colours.gallery_background = rgb_add_hls(colours.playlist_panel_background, 0, -0.03, -0.03)
                else:
                    ce = alpha_blend([255, 255, 255, 160], colours.playlist_panel_background)  # [165, 165, 165, 255]
                    colours.index_text = ce
                    colours.index_playing = ce
                    colours.time_text = ce
                    colours.bar_time = ce
                    colours.folder_title = ce
                    colours.star_line = ce  # [150, 150, 150, 255]
                    colours.row_select_highlight = [255, 255, 255, 12]
                    colours.row_playing_highlight = [255, 255, 255, 8]
                    colours.gallery_background = rgb_add_hls(colours.playlist_panel_background, 0, 0.03, 0.03)

                gui.temp_themes[track.album] = copy.deepcopy(colours)
                colours = gui.temp_themes[track.album]
                gui.theme_temp_current = track.album

            if theme_only:
                return

            wop = rw_from_object(g)
            s_image = IMG_Load_RW(wop, 0)
            # print(IMG_GetError())

            c = SDL_CreateTextureFromSurface(renderer, s_image)

            tex_w = pointer(c_int(0))
            tex_h = pointer(c_int(0))

            SDL_QueryTexture(c, None, None, tex_w, tex_h)

            dst = SDL_Rect(round(location[0]), round(location[1]))
            dst.w = int(tex_w.contents.value)
            dst.h = int(tex_h.contents.value)

            # Clean uo
            SDL_FreeSurface(s_image)
            g.close()
            # if close:
            #     source_image.close()

            unit = ImageObject()
            unit.index = index
            unit.texture = c
            unit.rect = dst
            unit.request_size = box
            unit.original_size = o_size
            unit.actual_size = (dst.w, dst.h)
            unit.source = source[offset][1]
            unit.offset = offset
            unit.format = format

            self.current_wu = unit
            self.image_cache.append(unit)

            self.render(unit, location)

            if len(self.image_cache) > 5 or (prefs.colour_from_image and len(self.image_cache) > 1):
                SDL_DestroyTexture(self.image_cache[0].texture)
                del self.image_cache[0]

            # temp fix
            global move_on_title
            global playlist_hold
            global quick_drag
            quick_drag = False
            move_on_title = False
            playlist_hold = False

        except Exception as error:
            # raise
            # print("Image processing error: " + str(error))
            console.print("Image load error")
            console.print("-- Associated track: " + track.fullpath)
            console.print("-- Exception: " + str(error))

            self.current_wu = None
            try:
                del self.source_cache[index][offset]
            except:
                print(" -- Error, no source cache?")

            return 1

        return 0

    def render(self, unit, location):

        rect = unit.rect

        gui.art_aspect_ratio = unit.actual_size[0] / unit.actual_size[1]

        rect.x = round(int((unit.request_size[0] - unit.actual_size[0]) / 2) + location[0])
        rect.y = round(int((unit.request_size[1] - unit.actual_size[1]) / 2) + location[1])

        style_overlay.hole_punches.append(rect)

        SDL_RenderCopy(renderer, unit.texture, None, rect)

        gui.art_drawn_rect = (rect.x, rect.y, rect.w, rect.h)

    def clear_cache(self):

        for unit in self.image_cache:
            SDL_DestroyTexture(unit.texture)

        self.image_cache.clear()
        self.source_cache.clear()
        self.current_wu = None
        self.downloaded_track = None

        self.base64cahce = (0, 0, "")
        self.processing64on = None
        self.bin_cached = (None, None, None)
        self.loading_bin = (None, None)
        self.embed_cached = (None, None)

        gui.temp_themes.clear()
        gui.theme_temp_current = -1
        colours.last_album = ""


# from t_modules.t_art_render import AlbumArt

album_art_gen = AlbumArt()


# 0 - blank
# 1 - preparing first
# 2 - render first
# 3 - preparing 2nd

class StyleOverlay:

    def __init__(self):

        self.min_on_timer = Timer()
        self.fade_on_timer = Timer(0)
        self.fade_off_timer = Timer()

        self.stage = 0

        self.im = None

        self.a_texture = None
        self.a_rect = None

        self.b_texture = None
        self.b_rect = None

        self.a_type = 0
        self.b_type = 0

        self.window_size = None
        self.parent_path = None

        self.hole_punches = []
        self.hole_refills = []

        self.go_to_sleep = False

        self.current_track_album = "none"
        self.current_track_id = -1

    def worker(self):

        if self.stage == 0:

            if (gui.mode == 3 and prefs.mini_mode_mode == 5):
                pass
            elif prefs.bg_showcase_only and not gui.combo_mode:
                return

            if pctl.playing_ready() and self.min_on_timer.get() > 0:

                track = pctl.playing_object()

                self.window_size = copy.copy(window_size)
                self.parent_path = track.parent_folder_path
                self.current_track_id = track.index
                self.current_track_album = track.album

                try:
                    self.im = album_art_gen.get_blur_im(track)
                except Exception as e:
                    print("Blur blackground error")
                    print(str(e))
                    raise
                    #print(track.fullpath)

                if self.im is None or self.im is False:
                    if self.a_texture:
                        self.stage = 2
                        self.fade_off_timer.set()
                        self.go_to_sleep = True
                        return
                    else:
                        self.flush()
                        self.min_on_timer.force_set(-4)
                        return

                self.stage = 1
                gui.update += 1
                return

    def flush(self):

        if self.a_texture is not None:
            SDL_DestroyTexture(self.a_texture)
            self.a_texture = None
        if self.b_texture is not None:
            SDL_DestroyTexture(self.b_texture)
            self.b_texture = None
        self.min_on_timer.force_set(-0.2)
        self.parent_path = "None"
        self.stage = 0
        tm.ready("worker")
        gui.style_worker_timer.set()
        gui.delay_frame(0.25)
        gui.update += 1

    def display(self):

        if self.min_on_timer.get() < 0:
            return

        if self.stage == 1:

            wop = rw_from_object(self.im)
            s_image = IMG_Load_RW(wop, 0)

            c = SDL_CreateTextureFromSurface(renderer, s_image)

            tex_w = pointer(c_int(0))
            tex_h = pointer(c_int(0))

            SDL_QueryTexture(c, None, None, tex_w, tex_h)

            dst = SDL_Rect(round(-40, 0))
            dst.w = int(tex_w.contents.value)
            dst.h = int(tex_h.contents.value)

            # Clean uo
            SDL_FreeSurface(s_image)
            self.im.close()

            # SDL_SetTextureAlphaMod(c, 10)
            self.fade_on_timer.set()

            if self.a_texture is not None:
                self.b_texture = self.a_texture
                self.b_rect = self.a_rect
                self.b_type = self.a_type

            self.a_texture = c
            self.a_rect = dst
            self.a_type = album_art_gen.loaded_bg_type

            self.stage = 2
            self.radio_meta = None

            gui.update += 1

        if self.stage == 2:
            track = pctl.playing_object()

            if pctl.playing_state == 3 and not spot_ctl.coasting:
                if self.radio_meta != pctl.tag_meta:
                    self.radio_meta = pctl.tag_meta
                    self.current_track_id = -1
                    self.stage = 0

            elif not self.go_to_sleep and self.b_texture is None and self.current_track_id != track.index:
                self.radio_meta = None
                if not track.album:
                    self.stage = 0
                else:
                    self.current_track_id = track.index
                    if (
                            self.parent_path != pctl.playing_object().parent_folder_path or self.current_track_album != pctl.playing_object().album):
                        self.stage = 0

        if gui.mode == 3 and prefs.mini_mode_mode == 5:
            pass
        elif prefs.bg_showcase_only:
            if not gui.combo_mode:
                return

        t = self.fade_on_timer.get()
        SDL_SetRenderTarget(renderer, gui.main_texture_overlay_temp)
        SDL_SetRenderDrawColor(renderer, 0, 0, 0, 255)
        SDL_RenderClear(renderer)

        if self.a_texture is not None:
            if self.window_size != window_size:
                self.flush()

        if self.b_texture is not None:

            self.b_rect.y = 0 - self.b_rect.h // 4
            if self.b_type == 1:
                self.b_rect.y = 0

            if t < 0.4:

                SDL_RenderCopy(renderer, self.b_texture, None, self.b_rect)

            else:
                SDL_DestroyTexture(self.b_texture)
                self.b_texture = None
                self.b_rect = None

        if self.a_texture is not None:

            self.a_rect.y = 0 - self.a_rect.h // 4
            if self.a_type == 1:
                self.a_rect.y = 0

            if t < 0.4:
                fade = round(t / 0.4 * 255)
                gui.update += 1

            else:
                fade = 255

            if self.go_to_sleep:
                t = self.fade_off_timer.get()
                gui.update += 1

                if t < 1:
                    fade = 255
                elif t < 1.4:
                    fade = 255 - round((t - 1) / 0.4 * 255)
                else:
                    self.go_to_sleep = False
                    self.flush()
                    return

            if prefs.bg_showcase_only and not (prefs.mini_mode_mode == 5 and gui.mode == 3):
                tb = SDL_Rect(0, 0, window_size[0], gui.panelY)
                bb = SDL_Rect(0, window_size[1] - gui.panelBY, window_size[0], gui.panelBY)
                self.hole_punches.append(tb)
                self.hole_punches.append(bb)

            # Center image
            if window_size[0] < 900 * gui.scale:
                self.a_rect.x = (window_size[0] // 2) - self.a_rect.w // 2
            else:
                self.a_rect.x = -40

            SDL_SetRenderTarget(renderer, gui.main_texture_overlay_temp)

            SDL_SetTextureAlphaMod(self.a_texture, fade)
            SDL_RenderCopy(renderer, self.a_texture, None, self.a_rect)

            SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_NONE)

            SDL_SetRenderDrawColor(renderer, 0, 0, 0, 0)
            for rect in self.hole_punches:
                SDL_RenderFillRect(renderer, rect)

            SDL_SetRenderDrawBlendMode(renderer, SDL_BLENDMODE_BLEND)

            SDL_SetRenderTarget(renderer, gui.main_texture)
            opacity = prefs.art_bg_opacity
            if prefs.mini_mode_mode == 5 and gui.mode == 3:
                opacity = 255

            SDL_SetTextureAlphaMod(gui.main_texture_overlay_temp, opacity)
            SDL_RenderCopy(renderer, gui.main_texture_overlay_temp, None, None)

            SDL_SetRenderTarget(renderer, gui.main_texture)

        else:
            SDL_SetRenderTarget(renderer, gui.main_texture)


style_overlay = StyleOverlay()


def trunc_line(line, font, px, dots=True):  # This old function is slow and should be avoided

    if ddt.get_text_w(line, font) < px + 10:
        return line

    if dots:
        while ddt.get_text_w(line.rstrip(" ") + gui.trunk_end, font) > px:
            if len(line) == 0:
                return gui.trunk_end
            line = line[:-1]
        return line.rstrip(" ") + gui.trunk_end

    else:
        while ddt.get_text_w(line, font) > px:

            line = line[:-1]
            if len(line) < 2:
                break

        return line


def right_trunc(line, font, px, dots=True):
    if ddt.get_text_w(line, font) < px + 10:
        return line

    if dots:
        while ddt.get_text_w(line.rstrip(" ") + gui.trunk_end, font) > px:
            if len(line) == 0:
                return gui.trunk_end
            line = line[1:]
        return gui.trunk_end + line.rstrip(" ")

    else:
        while ddt.get_text_w(line, font) > px:
            # trunk = True
            line = line[1:]
            if len(line) < 2:
                break
        # if trunk and dots:
        #     line = line.rstrip(" ") + gui.trunk_end
        return line


# def trunc_line2(line, font, px):
#     trunk = False
#     p = ddt.get_text_w(line, font)
#     if p == 0 or p < px + 15:
#         return line
#
#     tl = line[0:(int(px / p * len(line)) + 3)]
#
#     if ddt.get_text_w(line.rstrip(" ") + gui.trunk_end, font) > px:
#         line = tl
#
#     while ddt.get_text_w(line.rstrip(" ") + gui.trunk_end, font) > px + 10:
#         trunk = True
#         line = line[:-1]
#         if len(line) < 1:
#             break
#
#     return line.rstrip(" ") + gui.trunk_end


click_time = time.time()
scroll_hold = False
scroll_point = 0
scroll_bpoint = 0
sbl = 50
sbp = 100

asbp = 50
album_scroll_hold = False


def fix_encoding(index, mode, enc):
    global default_playlist
    global enc_field

    todo = []

    if mode == 1:
        todo = [index]
    elif mode == 0:
        for b in range(len(default_playlist)):
            if pctl.master_library[default_playlist[b]].parent_folder_name == pctl.master_library[
                index].parent_folder_name:
                todo.append(default_playlist[b])

    for q in range(len(todo)):

        # key = pctl.master_library[todo[q]].title + pctl.master_library[todo[q]].filename
        old_star = star_store.full_get(todo[q])
        if old_star != None:
            star_store.remove(todo[q])

        if enc_field == 'All' or enc_field == 'Artist':
            line = pctl.master_library[todo[q]].artist
            line = line.encode("Latin-1", 'ignore')
            line = line.decode(enc, 'ignore')
            pctl.master_library[todo[q]].artist = line

        if enc_field == 'All' or enc_field == 'Album':
            line = pctl.master_library[todo[q]].album
            line = line.encode("Latin-1", 'ignore')
            line = line.decode(enc, 'ignore')
            pctl.master_library[todo[q]].album = line

        if enc_field == 'All' or enc_field == 'Title':
            line = pctl.master_library[todo[q]].title
            line = line.encode("Latin-1", 'ignore')
            line = line.decode(enc, 'ignore')
            pctl.master_library[todo[q]].title = line

        if old_star != None:
            star_store.insert(todo[q], old_star)

        # if key in pctl.star_library:
        #     newkey = pctl.master_library[todo[q]].title + pctl.master_library[todo[q]].filename
        #     if newkey not in pctl.star_library:
        #         pctl.star_library[newkey] = copy.deepcopy(pctl.star_library[key])
        #         # del pctl.star_library[key]


def transfer_tracks(index, mode, to):
    todo = []

    if mode == 0:
        todo = [index]
    elif mode == 1:
        for b in range(len(default_playlist)):
            if pctl.master_library[default_playlist[b]].parent_folder_name == pctl.master_library[
                index].parent_folder_name:
                todo.append(default_playlist[b])
    elif mode == 2:
        todo = default_playlist

    pctl.multi_playlist[to][2] += todo


def prep_gal():
    global albums
    albums = []

    folder = ""

    for index in default_playlist:

        if folder != pctl.master_library[index].parent_folder_name:
            albums.append([index, 0])
            folder = pctl.master_library[index].parent_folder_name


def add_stations(stations, name):
    if len(stations) == 1:
        for i, s in enumerate(pctl.radio_playlists):
            if s["name"] == "Default":
                s["items"].insert(0, stations[0])
                s["scroll"] = 0
                pctl.radio_playlist_viewing = i
                break
        else:
            r = {}
            r["uid"] = uid_gen()
            r["name"] = 'Default'
            r["items"] = stations
            r["scroll"] = 0
            pctl.radio_playlists.append(r)
            pctl.radio_playlist_viewing = len(pctl.radio_playlists) - 1
    else:
        r = {}
        r["uid"] = uid_gen()
        r["name"] = name
        r["items"] = stations
        r["scroll"] = 0
        pctl.radio_playlists.append(r)
        pctl.radio_playlist_viewing = len(pctl.radio_playlists) - 1
    if not gui.radio_view:
        enter_radio_view()


def load_m3u(path):
    name = os.path.basename(path)[:-4]
    playlist = []
    stations = []

    location_dict = {}
    titles = {}

    if not os.path.isfile(path):
        return

    f = open(path)
    lines = f.readlines()
    f.close()

    for i, line in enumerate(lines):
        line = line.strip("\r\n").strip()
        if not line.startswith("#"):  # line.startswith("http"):

            # Get title if present
            line_title = ""
            if i > 0:
                bline = lines[i - 1]
                if "," in bline and bline.startswith("#EXTINF:"):
                    line_title = bline.split(",", 1)[1].strip("\r\n").strip()

            if line.startswith("http"):
                radio = {}
                radio["stream_url"] = line

                if line_title:
                    radio["title"] = line_title
                else:
                    radio["title"] = os.path.splitext(os.path.basename(path))[0].strip()

                stations.append(radio)

                if gui.auto_play_import:
                    gui.auto_play_import = False
                    radiobox.start(radio)
            else:
                line = uri_parse(line)
                # Join file path if possibly relative
                if not line.startswith("/"):
                    line = os.path.join(os.path.dirname(path), line)

                # Cache datbase file paths for quick lookup
                if not location_dict:
                    for key, value in pctl.master_library.items():
                        if value.fullpath:
                            location_dict[value.fullpath] = value
                        if value.title:
                            titles[value.artist + " - " + value.title] = value

                # Is file path already imported?
                print(line)
                if line in location_dict:
                    playlist.append(location_dict[line].index)
                    print("found imported")
                # Or... does the file exist? Then import it
                elif os.path.isfile(line):
                    nt = TrackClass()
                    nt.index = pctl.master_count
                    set_path(nt, line)
                    nt = tag_scan(nt)
                    pctl.master_library[pctl.master_count] = nt
                    playlist.append(pctl.master_count)
                    pctl.master_count += 1
                    print("found file")
                # Last resort, guess based on title
                elif line_title in titles:
                    playlist.append(titles[line_title].index)
                    print("found title")
                else:
                    print("not found")

    if playlist:
        pctl.multi_playlist.append(pl_gen(title=name,
                                          playlist=playlist))
    if stations:
        add_stations(stations, name)

    gui.update = 1


def read_pls(lines, path, followed=False):
    ids = []
    urls = {}
    titles = {}

    for line in lines:
        line = line.strip("\r\n")
        if "=" in line and line.startswith("File") and "http" in line:
            # Get number
            n = line.split("=")[0][4:]
            if n.isdigit():
                if n not in ids:
                    ids.append(n)
                urls[n] = line.split("=", 1)[1].strip()

        if "=" in line and line.startswith("Title"):
            # Get number
            n = line.split("=")[0][5:]
            if n.isdigit():
                if n not in ids:
                    ids.append(n)
                titles[n] = line.split("=", 1)[1].strip()

    stations = []
    for id in ids:
        if id in urls:
            radio = {}
            radio["stream_url"] = urls[id]
            radio["title"] = os.path.splitext(os.path.basename(path))[0]
            radio["scroll"] = 0
            if id in titles:
                radio["title"] = titles[id]

            if ".pls" in radio["stream_url"]:
                if not followed:
                    try:
                        print("Download .pls")
                        response = requests.get(radio["stream_url"], stream=True)
                        if int(response.headers["Content-Length"]) < 2000:
                            read_pls(response.content.decode().splitlines(), path, followed=True)
                    except:
                        print("Failed to retrieve .pls")
            else:
                stations.append(radio)
                if gui.auto_play_import:
                    gui.auto_play_import = False
                    radiobox.start(radio)
    if stations:
        add_stations(stations, os.path.basename(path))


def load_pls(path):
    if os.path.isfile(path):
        f = open(path)
        lines = f.readlines()
        read_pls(lines, path)
        f.close()


def load_xspf(path):
    global to_got

    name = os.path.basename(path)[:-5]
    # tauon.log("Importing XSPF playlist: " + path, title=True)
    console.print("Importing XSPF playlist: " + path)

    try:
        parser = ET.XMLParser(encoding="utf-8")
        e = ET.parse(path, parser).getroot()

        a = []
        b = {}
        info = ""

        for top in e:

            if top.tag.endswith("info"):
                info = top.text
            if top.tag.endswith("title"):
                name = top.text
            if top.tag.endswith("trackList"):
                for track in top:
                    if track.tag.endswith("track"):
                        for field in track:
                            print(field.tag)
                            print(field.text)
                            if 'title' in field.tag and field.text:
                                b['title'] = field.text
                            if 'location' in field.tag and field.text:
                                l = field.text
                                if l[:5] == "file:":
                                    l = l.replace('file:', "")
                                    l = l.lstrip("/")
                                    l = "/" + l
                                    l = str(urllib.parse.unquote(l))

                                b['location'] = l
                            if 'creator' in field.tag and field.text:
                                b['artist'] = field.text
                            if 'album' in field.tag and field.text:
                                b['album'] = field.text
                            if 'duration' in field.tag and field.text:
                                b['duration'] = field.text

                        b["info"] = info
                        b["name"] = name
                        a.append(copy.deepcopy(b))
                        b = {}

    except:
        show_message("Error importing XSPF playlist.", "Sorry about that.", mode='warning')
        # tauon.log("-- Error parsing XSPF file")
        console.print("-- Error parsing XSPF file")
        return

    # Extract internet streams first
    stations = []
    for i in reversed(range(len(a))):
        item = a[i]
        if item["location"].startswith("http"):
            radio = {}
            radio["stream_url"] = item["location"]
            radio["title"] = item["name"]
            radio["scroll"] = 0
            if item["info"].startswith("http"):
                radio["website_url"] = item["info"]

            stations.append(radio)

            if gui.auto_play_import:
                gui.auto_play_import = False
                radiobox.start(radio)

            del a[i]
    if stations:
        add_stations(stations, os.path.basename(path))
    playlist = []
    missing = 0

    if len(a) > 5000:
        to_got = 'xspfl'

    # Generate location dict
    location_dict = {}
    base_names = {}
    r_base_names = {}
    titles = {}
    for key, value in pctl.master_library.items():
        if value.fullpath != "":
            location_dict[value.fullpath] = key
        if value.filename != "":
            base_names[value.filename] = 0
            r_base_names[key] = value.filename
        if value.title != "":
            titles[value.title] = 0

    for track in a:
        found = False

        # Check if we already have a track with full file path in database
        if not found and 'location' in track:

            location = track['location']
            if location in location_dict:
                playlist.append(location_dict[location])
                if not os.path.isfile(location):
                    missing += 1
                found = True

            if found is True:
                continue

        # Then check for title, artist and filename match
        if not found and 'location' in track and 'duration' in track and 'title' in track and 'artist' in track:
            base = os.path.basename(track['location'])
            if base in base_names:
                for index, bn in r_base_names.items():
                    va = pctl.master_library[index]
                    if va.artist == track['artist'] and va.title == track['title'] and \
                            os.path.isfile(va.fullpath) and \
                            va.filename == base:
                        playlist.append(index)
                        if not os.path.isfile(va.fullpath):
                            missing += 1
                        found = True
                        break
                if found is True:
                    continue

        # Then check for just title and artist match
        if not found and 'title' in track and 'artist' in track and track['title'] in titles:
            for key, value in pctl.master_library.items():
                if value.artist == track['artist'] and value.title == track['title'] and os.path.isfile(value.fullpath):
                    playlist.append(key)
                    if not os.path.isfile(value.fullpath):
                        missing += 1
                    found = True
                    break
            if found is True:
                continue

        if not found and 'location' in track or 'title' in track:
            nt = TrackClass()
            nt.index = pctl.master_count
            nt.found = False

            if 'location' in track:
                location = track['location']
                set_path(nt, location)
                if os.path.isfile(location):
                    nt.found = True
            elif 'album' in track:
                nt.parent_folder_name = track['album']
            if 'artist' in track:
                nt.artist = track['artist']
            if 'title' in track:
                nt.title = track['title']
            if 'duration' in track:
                nt.length = int(float((track['duration'])) / 1000)
            if 'album' in track:
                nt.album = track['album']
            nt.is_cue = False
            if nt.found:
                nt = tag_scan(nt)

            pctl.master_library[pctl.master_count] = nt
            playlist.append(pctl.master_count)
            pctl.master_count += 1
            if nt.found:
                continue

        missing += 1
        console.print("-- Failed to locate track", level=2)
        if 'location' in track:
            console.print("-- -- Expected path: " + track['location'], level=2)
        if 'title' in track:
            console.print("-- -- Title: " + track['title'], level=2)
        if 'artist' in track:
            console.print("-- -- Artist: " + track['artist'], level=2)
        if 'album' in track:
            console.print("-- -- Album: " + track['album'], level=2)

    if missing > 0:
        show_message('Failed to locate ' + str(missing) + ' out of ' + str(len(a)) + ' tracks.')

    # print(playlist)
    if playlist:
        pctl.multi_playlist.append(pl_gen(title=name,
                                          playlist=playlist))
    gui.update = 1

    # tauon.log("Finished importing XSPF")


bb_type = 0

# gui.scroll_hide_box = (0, gui.panelY, 28, window_size[1] - gui.panelBY - gui.panelY)

encoding_menu = False
enc_index = 0
enc_setting = 0
enc_field = 'All'

gen_menu = False

transfer_setting = 0

b_panel_size = 300
b_info_bar = False

message_info_icon = asset_loader("notice.png")
message_warning_icon = asset_loader("warning.png")
message_tick_icon = asset_loader("done.png")
message_arrow_icon = asset_loader("ext.png")
message_error_icon = asset_loader("error.png")
message_bubble_icon = asset_loader("bubble.png")
message_download_icon = asset_loader("ddl.png")


class ToolTip:

    def __init__(self):
        self.text = ""
        self.h = 24 * gui.scale
        self.w = 62 * gui.scale
        self.x = 0
        self.y = 0
        self.timer = Timer()
        self.trigger = 1.1
        self.font = 13
        self.called = False
        self.a = False

    def test(self, x, y, text):

        if self.text != text or x != self.x or y != self.y:
            self.text = text
            # self.timer.set()
            self.a = False

            self.x = x
            self.y = y
            self.w = ddt.get_text_w(text, self.font) + 20 * gui.scale

        self.called = True

        if self.a is False:
            self.timer.set()
            gui.frame_callback_list.append(TestTimer(self.trigger))
        self.a = True

    def render(self):

        if self.called is True:

            if self.timer.get() > self.trigger:

                ddt.rect((self.x, self.y, self.w, self.h), colours.box_button_background)
                # ddt.rect((self.x, self.y, self.w, self.h), colours.grey(45))
                ddt.text((self.x + int(self.w / 2), self.y + 4 * gui.scale, 2), self.text, colours.menu_text, self.font,
                         bg=colours.box_button_background)
            else:
                # gui.update += 1
                pass
        else:
            self.timer.set()
            self.a = False

        self.called = False


tool_tip = ToolTip()
tool_tip2 = ToolTip()
tool_tip2.trigger = 1.8
track_box_path_tool_timer = Timer()


def ex_tool_tip(x, y, text1_width, text, font):
    text2_width = ddt.get_text_w(text, font)
    if text2_width == text1_width:
        return

    y -= 10 * gui.scale

    w = ddt.get_text_w(text, 312) + 24 * gui.scale
    h = 24 * gui.scale

    x -= int(w / 2)

    border = 1 * gui.scale
    ddt.rect((x - border, y - border, w + border * 2, h + border * 2), colours.grey(60))
    ddt.rect((x, y, w, h), colours.menu_background)
    p = ddt.text((x + int(w / 2), y + 3 * gui.scale, 2), text, colours.menu_text, 312, bg=colours.menu_background)


class ToolTip3:

    def __init__(self):
        self.x = 0
        self.y = 0
        self.text = ""
        self.font = None
        self.show = False
        self.width = 0
        self.height = 24 * gui.scale
        self.timer = Timer()
        self.pl_position = 0
        self.click_exclude_point = (0, 0)

    def set(self, x, y, text, font, rect):

        y -= round(11 * gui.scale)
        if self.show == False or self.y != y or x != self.x or self.pl_position != pctl.playlist_view_position:
            self.timer.set()

        if point_proximity_test(self.click_exclude_point, mouse_position, 20 * gui.scale):
            self.timer.set()
            return

        if inp.mouse_click:
            self.click_exclude_point = copy.copy(mouse_position)
            self.timer.set()
            return

        self.x = x
        self.y = y
        self.text = text
        self.font = font
        self.show = True
        self.rect = rect
        self.pl_position = pctl.playlist_view_position

    def render(self):

        if not self.show:
            return

        if not point_proximity_test(self.click_exclude_point, mouse_position, 20 * gui.scale):
            self.click_exclude_point = (0, 0)

        if not coll(
                self.rect) or inp.mouse_click or gui.level_2_click or self.pl_position != pctl.playlist_view_position:
            self.show = False

        gui.frame_callback_list.append(TestTimer(0.02))

        if self.timer.get() < 0.6:
            return

        w = ddt.get_text_w(self.text, 312) + self.height
        x = self.x  # - int(self.width / 2)
        y = self.y
        h = self.height

        border = 1 * gui.scale

        ddt.rect((x - border, y - border, w + border * 2, h + border * 2), colours.grey(60))
        ddt.rect((x, y, w, h), colours.menu_background)
        p = ddt.text((x + int(w / 2), y + 3 * gui.scale, 2), self.text, colours.menu_text, 312,
                     bg=colours.menu_background)

        if not coll(self.rect):
            self.show = False


columns_tool_tip = ToolTip3()

tool_tip_instant = ToolTip3()


# Right click context menu generator



class Menu:
    switch = 0
    count = switch + 1
    instances = []
    active = False

    def rescale(self):
        self.vertical_size = round(self.base_v_size * gui.scale)
        self.h = self.vertical_size
        self.w = self.request_width * gui.scale
        if gui.scale == 2:
            self.w += 15

    def __init__(self, width, show_icons=False):

        self.base_v_size = 22
        self.active = False
        self.request_width = width
        self.close_next_frame = False
        self.clicked = False
        self.pos = [0, 0]
        self.rescale()

        self.reference = 0
        self.items = []
        self.subs = []
        self.selected = -1
        self.up = False
        self.down = False
        self.font = 412
        self.show_icons = show_icons
        self.sub_arrow = MenuIcon(asset_loader("sub.png", True))

        self.id = Menu.count
        self.break_height = round(4 * gui.scale)

        Menu.count += 1

        self.sub_number = 0
        self.sub_active = -1
        self.sub_y_postion = 0
        Menu.instances.append(self)

    @staticmethod
    def deco(_=_):
        return [colours.menu_text, colours.menu_background, None]

    def click(self):
        self.clicked = True
        # cheap hack to prevent scroll bar from being activated when closing menu
        global click_location
        click_location = [0, 0]

    def add(self, menu_item):
        if menu_item.render_func is None:
            menu_item.render_func = self.deco
        self.items.append(menu_item)

    def br(self):
        self.items.append(None)

    def add_sub(self, title, width, show_test=None):
        self.items.append(MenuItem(title, self.deco, sub_menu_width=width, show_test=show_test, is_sub_menu=True, sub_menu_number=self.sub_number))
        self.sub_number += 1
        self.subs.append([])

    def add_to_sub(self, sub_menu_index, menu_item):
        if menu_item.render_func is None:
            menu_item.render_func = self.deco
        self.subs[sub_menu_index].append(menu_item)

    def test_item_active(self, item):
        if item.show_test is not None:
            if item.show_test(1) is False:
                return False
        return True

    def is_item_disabled(self, item):
        if item.disable_test is not None:
            if item.pass_ref_deco:
                return item.disable_test(self.reference)
            else:
                return item.disable_test()

    def render_icon(self, x, y, icon, selected, fx):

        if colours.lm:
            selected = True

        if icon is not None:

            x += icon.xoff * gui.scale
            y += icon.yoff * gui.scale

            colour = None

            if icon.base_asset is None:
                # Colourise mode

                if icon.colour_callback is not None:  # and icon.colour_callback() is not None:
                    colour = icon.colour_callback()

                elif selected and not fx[0] == colours.menu_text_disabled:
                    colour = icon.colour

                if colour is None and icon.base_asset_mod:
                    colour = colours.menu_icons
                    # if colours.lm:
                    #     colour = [160, 160, 160, 255]
                    icon.base_asset_mod.render(x, y, colour)
                    return

                if colour is None:
                    # colour = [145, 145, 145, 70]
                    colour = colours.menu_icons  # [255, 255, 255, 35]
                    # colour = [50, 50, 50, 255]

                icon.asset.render(x, y, colour)

            else:
                if not is_grey(colours.menu_background):
                    return  # Since these are currently pre-rendered greyscale, they are
                    # Incompatible with coloured backgrounds. Fix todo.
                if selected and fx[0] == colours.menu_text_disabled:
                    icon.base_asset.render(x, y)
                    return

                # Pre-rendered mode
                if icon.mode_callback is not None:
                    if icon.mode_callback():
                        icon.asset.render(x, y)
                    else:
                        icon.base_asset.render(x, y)
                else:
                    if selected:
                        icon.asset.render(x, y)
                    else:
                        icon.base_asset.render(x, y)

    def render(self):
        if self.active:

            if Menu.switch != self.id:
                self.active = False

                for menu in Menu.instances:
                    if menu.active:
                        break
                else:
                    Menu.active = False

                return

            # ytoff = 3
            y_run = round(self.pos[1])
            to_call = None

            # if window_size[1] < 250 * gui.scale:
            #     self.h = round(14 * gui.scale)
            #     ytoff = -1 * gui.scale
            # else:
            self.h = self.vertical_size
            ytoff = round(self.h * 0.71 - 13 * gui.scale)

            x_run = self.pos[0]

            for i in range(len(self.items)):
                # print(self.items[i])

                # Draw menu break
                if self.items[i] is None:

                    if is_light(colours.menu_background):
                        break_colour = rgb_add_hls(colours.menu_background, 0, -0.1, -0.1)
                    else:
                        break_colour = rgb_add_hls(colours.menu_background, 0, 0.06, 0)

                    rect = (x_run, y_run, self.w, self.break_height - 1)
                    if coll(rect):
                        self.clicked = False

                    ddt.rect_a((x_run, y_run), (self.w, self.break_height), colours.menu_background)

                    ddt.rect_a((x_run, y_run + 2 * gui.scale), (self.w, 2 * gui.scale), break_colour)

                    # Draw tab
                    ddt.rect_a((x_run, y_run), (4 * gui.scale, self.break_height), colours.menu_tab)
                    y_run += self.break_height

                    continue

                if self.test_item_active(self.items[i]) is False:
                    continue
                # if self.items[i][1] is False and self.items[i][8] is not None:
                #     if self.items[i][8](1) == False:
                #         continue

                # Get properties for menu item
                if self.items[i].render_func is not None:
                    if self.items[i].pass_ref_deco:
                        fx = self.items[i].render_func(self.reference)
                    else:
                        fx = self.items[i].render_func()
                else:
                    fx = self.deco()

                if fx[2] is not None:
                    label = fx[2]
                else:
                    label = self.items[i].title

                # Show text as disabled if disable_test() passes
                if self.is_item_disabled(self.items[i]):
                    fx[0] = colours.menu_text_disabled

                # Draw item background, black by default
                ddt.rect_a((x_run, y_run), (self.w, self.h), fx[1])
                bg = fx[1]

                # Detect if mouse is over this item
                selected = False
                rect = (x_run, y_run, self.w, self.h - 1)
                fields.add(rect)

                if coll_point(mouse_position,
                              (x_run, y_run, self.w, self.h - 1)):
                    ddt.rect_a((x_run, y_run), (self.w, self.h), colours.menu_highlight_background)  # [15, 15, 15, 255]
                    selected = True
                    bg = alpha_blend(colours.menu_highlight_background, bg)

                    # Call menu items callback if clicked
                    if self.clicked:

                        if self.items[i].is_sub_menu is False:
                            to_call = i
                            if self.items[i].set_ref is not None:
                                self.reference = self.items[i].set_ref
                            global mouse_down
                            mouse_down = False

                        else:
                            self.clicked = False
                            self.sub_active = self.items[i].sub_menu_number
                            self.sub_y_postion = y_run

                # Draw tab
                ddt.rect_a((x_run, y_run), (4 * gui.scale, self.h), colours.menu_tab)

                # Draw Icon
                x = 12 * gui.scale
                if self.items[i].is_sub_menu is False and self.show_icons:
                    icon = self.items[i].icon
                    self.render_icon(x_run + x, y_run + 5 * gui.scale, icon, selected, fx)

                if self.show_icons:
                    x += 25 * gui.scale

                # Draw arrow icon for sub menu
                if self.items[i].is_sub_menu is True:

                    if is_light(bg) or colours.lm:
                        colour = rgb_add_hls(bg, 0, -0.6, -0.1)
                    else:
                        colour = rgb_add_hls(bg, 0, 0.1, 0)

                    if self.sub_active == self.items[i].func:
                        if is_light(bg) or colours.lm:
                            colour = rgb_add_hls(bg, 0, -0.8, -0.1)
                        else:
                            colour = rgb_add_hls(bg, 0, 0.40, 0)

                    # colour = [50, 50, 50, 255]
                    # if selected:
                    #     colour = [150, 150, 150, 255]
                    # if self.sub_active == self.items[i][2]:
                    #     colour = [150, 150, 150, 255]
                    self.sub_arrow.asset.render(x_run + self.w - 13 * gui.scale, y_run + 7 * gui.scale, colour)

                # Render the items label
                ddt.text((x_run + x, y_run + ytoff), label, fx[0], self.font, max_w=self.w - (x + 9 * gui.scale), bg=bg)

                # Render the items hint
                if self.items[i].hint != None:

                    if is_light(bg) or colours.lm:
                        hint_colour = rgb_add_hls(bg, 0, -0.30, -0.3)
                    else:
                        hint_colour = rgb_add_hls(bg, 0, 0.15, 0)

                    # colo = alpha_blend([255, 255, 255, 50], bg)
                    ddt.text((x_run + self.w - 5, y_run + ytoff, 1), self.items[i].hint,
                             hint_colour, self.font, bg=bg)

                y_run += self.h

                if y_run > window_size[1] - self.h:
                    direc = 1
                    if self.pos[0] > window_size[0] // 2:
                        direc = -1
                    x_run += self.w * direc
                    y_run = self.pos[1]

                # Render sub menu if active
                if self.sub_active > -1 and self.items[i].is_sub_menu and self.sub_active == self.items[i].sub_menu_number:

                    # sub_pos = [x_run + self.w, self.pos[1] + i * self.h]
                    sub_pos = [x_run + self.w, self.sub_y_postion]
                    sub_w = self.items[i].sub_menu_width * gui.scale

                    if sub_pos[0] + sub_w > window_size[0]:
                        sub_pos[0] = x_run - sub_w
                        if view_box.active:
                            sub_pos[0] -= view_box.w

                    fx = self.deco()

                    minY = window_size[1] - self.h * len(self.subs[self.sub_active]) - 15 * gui.scale
                    sub_pos[1] = min(sub_pos[1], minY)

                    xoff = 0
                    for i in self.subs[self.sub_active]:
                        if i.icon is not None:
                            xoff = 24 * gui.scale
                            break

                    for w in range(len(self.subs[self.sub_active])):

                        if self.subs[self.sub_active][w].show_test is not None:
                            if not self.subs[self.sub_active][w].show_test(self.reference):
                                continue

                        # Get item colours
                        if self.subs[self.sub_active][w].render_func is not None:
                            if self.subs[self.sub_active][w].pass_ref_deco:
                                fx = self.subs[self.sub_active][w].render_func(self.reference)
                            else:
                                fx = self.subs[self.sub_active][w].render_func()

                        # Item background
                        ddt.rect_a((sub_pos[0], sub_pos[1] + w * self.h), (sub_w, self.h), fx[1])

                        # Detect if mouse is over this item
                        rect = (sub_pos[0], sub_pos[1] + w * self.h, sub_w, self.h - 1)
                        fields.add(rect)
                        this_select = False
                        bg = colours.menu_background
                        if coll_point(mouse_position,
                                      (sub_pos[0], sub_pos[1] + w * self.h, sub_w, self.h - 1)):
                            ddt.rect_a((sub_pos[0], sub_pos[1] + w * self.h), (sub_w, self.h),
                                       colours.menu_highlight_background)
                            bg = alpha_blend(colours.menu_highlight_background, bg)
                            this_select = True

                            # Call Callback
                            if self.clicked and not self.is_item_disabled(self.subs[self.sub_active][w]):

                                # If callback needs args
                                if self.subs[self.sub_active][w].args is not None:
                                    self.subs[self.sub_active][w].func(self.reference, self.subs[self.sub_active][w].args)

                                # If callback just need ref
                                elif self.subs[self.sub_active][w].pass_ref:
                                    self.subs[self.sub_active][w].func(self.reference)

                                else:
                                    self.subs[self.sub_active][w].func()

                        if fx[2] is not None:
                            label = fx[2]
                        else:
                            label = self.subs[self.sub_active][w].title

                        # Show text as disabled if disable_test() passes
                        if self.is_item_disabled(self.subs[self.sub_active][w]):
                            fx[0] = colours.menu_text_disabled

                        # Render sub items icon
                        icon = self.subs[self.sub_active][w].icon
                        self.render_icon(sub_pos[0] + 11 * gui.scale, sub_pos[1] + w * self.h + 5 * gui.scale, icon,
                                         this_select, fx)

                        # Render the items label
                        ddt.text((sub_pos[0] + 10 * gui.scale + xoff, sub_pos[1] + ytoff + w * self.h), label, fx[0],
                                 self.font, bg=bg)

                        # Draw tab
                        ddt.rect_a((sub_pos[0], sub_pos[1] + w * self.h), (4 * gui.scale, self.h), colours.menu_tab)

                        # Render the menu outline
                        # ddt.rect_a(sub_pos, (sub_w, self.h * len(self.subs[self.sub_active])), colours.grey(40))

            # Process Click Actions
            if to_call is not None:

                if not self.is_item_disabled(self.items[to_call]):
                    if self.items[to_call].pass_ref:
                        self.items[to_call].func(self.reference)
                    else:
                        self.items[to_call].func()

            if self.clicked or key_esc_press or self.close_next_frame:
                self.close_next_frame = False
                self.active = False
                self.clicked = False

                last_click_location[0] = 0
                last_click_location[1] = 0

                for menu in Menu.instances:
                    if menu.active:
                        break
                else:
                    Menu.active = False

                # Render the menu outline
                # ddt.rect_a(self.pos, (self.w, self.h * len(self.items)), colours.grey(40))

    def activate(self, in_reference=0, position=None):

        Menu.active = True

        if position != None:
            self.pos = [position[0], position[1]]
        else:
            self.pos = [copy.deepcopy(mouse_position[0]), copy.deepcopy(mouse_position[1])]

        self.reference = in_reference
        Menu.switch = self.id
        self.sub_active = -1

        # Reposition the menu if it would otherwise intersect with far edge of window
        if not position:
            if self.pos[0] + self.w > window_size[0]:
                self.pos[0] -= round(self.w + 3 * gui.scale)

        # Get height size of menu
        full_h = 0
        shown_h = 0
        for item in self.items:
            if item is None:
                full_h += self.break_height
                shown_h += self.break_height
            else:
                full_h += self.h
                if self.test_item_active(item) is True:
                    shown_h += self.h

        # Flip menu up if would intersect with bottom of window
        if self.pos[1] + full_h > window_size[1]:
            self.pos[1] -= shown_h

            # Prevent moving outside top of window
            if self.pos[1] < gui.panelY:
                self.pos[1] = gui.panelY
                self.pos[0] += 5 * gui.scale

        self.active = True


def close_all_menus():
    for menu in Menu.instances:
        menu.active = False
    Menu.active = False


def menu_standard_or_grey(bool):
    if bool:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


# Create empty area menu
playlist_menu = Menu(130)
radio_entry_menu = Menu(125)
showcase_menu = Menu(135)
center_info_menu = Menu(125)
cancel_menu = Menu(100)
gallery_menu = Menu(175, show_icons=True)
artist_info_menu = Menu(135)
queue_menu = Menu(150)
repeat_menu = Menu(120)
shuffle_menu = Menu(120)
artist_list_menu = Menu(165, show_icons=True)
lightning_menu = Menu(165)
lsp_menu = Menu(145)
folder_tree_menu = Menu(175, show_icons=True)
folder_tree_stem_menu = Menu(190, show_icons=True)
overflow_menu = Menu(175)
spotify_playlist_menu = Menu(175)
radio_context_menu = Menu(175)
#chrome_menu = Menu(175)




def enable_artist_list():
    if prefs.left_panel_mode != "artist list":
        gui.last_left_panel_mode = prefs.left_panel_mode
    prefs.left_panel_mode = "artist list"
    gui.lsp = True
    gui.update_layout()


def enable_playlist_list():
    if prefs.left_panel_mode != "playlist":
        gui.last_left_panel_mode = prefs.left_panel_mode
    prefs.left_panel_mode = "playlist"
    gui.lsp = True
    gui.update_layout()


def enable_queue_panel():
    if prefs.left_panel_mode != "queue":
        gui.last_left_panel_mode = prefs.left_panel_mode
    prefs.left_panel_mode = "queue"
    gui.lsp = True
    gui.update_layout()


def enable_folder_list():
    if prefs.left_panel_mode != "folder view":
        gui.last_left_panel_mode = prefs.left_panel_mode
    prefs.left_panel_mode = "folder view"
    gui.lsp = True
    gui.update_layout()


def lsp_menu_test_queue():
    if not gui.lsp:
        return False
    return prefs.left_panel_mode == "queue"


def lsp_menu_test_playlist():
    if not gui.lsp:
        return False
    return prefs.left_panel_mode == "playlist"


def lsp_menu_test_tree():
    if not gui.lsp:
        return False
    return prefs.left_panel_mode == "folder view"


def lsp_menu_test_artist():
    if not gui.lsp:
        return False
    return prefs.left_panel_mode == "artist list"


def toggle_left_last():
    gui.lsp = True
    t = prefs.left_panel_mode
    if t != gui.last_left_panel_mode:
        prefs.left_panel_mode = gui.last_left_panel_mode
        gui.last_left_panel_mode = t


# . Menu entry: A side panel view layout.

lsp_menu.add(MenuItem(_("Playlists + Queue"), enable_playlist_list, disable_test=lsp_menu_test_playlist))
lsp_menu.add(MenuItem(_("Queue"), enable_queue_panel, disable_test=lsp_menu_test_queue))
# . Menu entry: Side panel view layout showing a list of artists with thumbnails.
lsp_menu.add(MenuItem(_("Artist List"), enable_artist_list, disable_test=lsp_menu_test_artist))
# . Menu entry: A side panel view layout. Alternative name: Folder Tree.
lsp_menu.add(MenuItem(_("Folder Navigator"), enable_folder_list, disable_test=lsp_menu_test_tree))


class RenameTrackBox:

    def __init__(self):

        self.active = False
        self.target_track_id = None
        self.single_only = False

    def activate(self, track_id):

        self.active = True
        self.target_track_id = track_id
        if key_shift_down or key_shiftr_down:
            self.single_only = True
        else:
            self.single_only = False

    def disable_test(self, track_id):
        if key_shift_down or key_shiftr_down:
            single_only = True
        else:
            single_only = False

        if not single_only:
            for item in default_playlist:
                if pctl.master_library[item].parent_folder_path == pctl.master_library[track_id].parent_folder_path:

                    if pctl.master_library[item].is_network is True:
                        return True
        return False

    def render(self):

        if not self.active:
            return

        if gui.level_2_click:
            inp.mouse_click = True
        gui.level_2_click = False

        w = 420 * gui.scale
        h = 155 * gui.scale
        x = int(window_size[0] / 2) - int(w / 2)
        y = int(window_size[1] / 2) - int(h / 2)

        ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale), colours.box_border)
        ddt.rect_a((x, y), (w, h), colours.box_background)
        ddt.text_background_colour = colours.box_background

        if key_esc_press or ((inp.mouse_click or right_click or level_2_right_click) and not coll((x, y, w, h))):
            rename_track_box.active = False

        r_todo = []

        # Find matching folder tracks in playlist
        if not self.single_only:
            for item in default_playlist:
                if pctl.master_library[item].parent_folder_path == pctl.master_library[
                    self.target_track_id].parent_folder_path:

                    # Close and display error if any tracks are not single local files
                    if pctl.master_library[item].is_network is True:
                        rename_track_box.active = False
                        show_message("Cannot rename", "One or more tracks is from a network location!", mode='info')
                    if pctl.master_library[item].is_cue is True:
                        rename_track_box.active = False
                        show_message("This function does not support renaming CUE Sheet tracks.")
                    else:
                        r_todo.append(item)
        else:
            r_todo = [self.target_track_id]

        ddt.text((x + 10 * gui.scale, y + 8 * gui.scale,), _("Track Renaming"), colours.grey(230), 213)

        # if draw.button("Default", x + 230 * gui.scale, y + 8 * gui.scale,
        if rename_files.text != prefs.rename_tracks_template and draw.button(_("Default"), x + w - 85 * gui.scale,
                                                                             y + h - 35 * gui.scale, 70 * gui.scale):
            rename_files.text = prefs.rename_tracks_template

        # ddt.draw_text((x + 14, y + 40,), NRN + cursor, colours.grey(150), 12)
        rename_files.draw(x + 14 * gui.scale, y + 39 * gui.scale, colours.box_input_text, width=300)
        NRN = rename_files.text

        ddt.rect_s((x + 8 * gui.scale, y + 36 * gui.scale, 300 * gui.scale, 22 * gui.scale), colours.box_text_border,
                   1 * gui.scale)

        afterline = ""
        warn = False
        underscore = False

        for item in r_todo:

            if pctl.master_library[item].track_number == "" or pctl.master_library[item].artist == "" or \
                    pctl.master_library[item].title == "" or pctl.master_library[item].album == "":
                warn = True

            if item == self.target_track_id:
                afterline = parse_template2(NRN, pctl.master_library[item])

        ddt.text((x + 10 * gui.scale, y + 68 * gui.scale), _("BEFORE"), colours.box_text_label, 212)
        line = trunc_line(pctl.master_library[self.target_track_id].filename, 12, 335)
        ddt.text((x + 70 * gui.scale, y + 68 * gui.scale), line, colours.grey(210), 211, max_w=340)

        ddt.text((x + 10 * gui.scale, y + 83 * gui.scale), _("AFTER"), colours.box_text_label, 212)
        ddt.text((x + 70 * gui.scale, y + 83 * gui.scale), afterline, colours.grey(210), 211, max_w=340)

        if (len(NRN) > 3 and len(pctl.master_library[self.target_track_id].filename) > 3 and afterline[-3:].lower() !=
            pctl.master_library[self.target_track_id].filename[-3:].lower()) or len(NRN) < 4 or "." not in afterline[
                                                                                                           -5:]:
            ddt.text((x + 10 * gui.scale, y + 108 * gui.scale,), "Warning: This may change the file extension",
                     [245, 90, 90, 255],
                     13)

        colour_warn = [143, 186, 65, 255]
        if not unique_template(NRN):
            ddt.text((x + 10 * gui.scale, y + 123 * gui.scale,), "Warning: The filename might not be unique",
                     [245, 90, 90, 255],
                     13)
        if warn:
            ddt.text((x + 10 * gui.scale, y + 135 * gui.scale,), "Warning: A track has incomplete metadata",
                     [245, 90, 90, 255], 13)
            colour_warn = [180, 60, 60, 255]

        label = "Write (" + str(len(r_todo)) + ")"

        if draw.button(label, x + (8 + 300 + 10) * gui.scale, y + 36 * gui.scale, 80 * gui.scale,
                       text_highlight_colour=colours.grey(255), background_highlight_colour=colour_warn,
                       tooltip="Physically renames all the tracks in the folder") or inp.level_2_enter:
            inp.mouse_click = False
            total_todo = len(r_todo)
            pre_state = 0

            for item in r_todo:

                if pctl.playing_state > 0 and item == pctl.track_queue[pctl.queue_step]:
                    pre_state = pctl.stop(True)

                try:

                    afterline = parse_template2(NRN, pctl.master_library[item], strict=True)

                    oldname = pctl.master_library[item].filename
                    oldpath = pctl.master_library[item].fullpath

                    print('Renaming...')

                    star = star_store.full_get(item)
                    star_store.remove(item)

                    oldpath = pctl.master_library[item].fullpath

                    oldsplit = os.path.split(oldpath)

                    if os.path.exists(os.path.join(oldsplit[0], afterline)):
                        print("A file with that name already exists")
                        total_todo -= 1
                        continue

                    if not afterline:
                        print("Rename Error")
                        total_todo -= 1
                        continue

                    if "." in afterline and not afterline.split(".")[0]:
                        print("A file does not have a target filename")
                        total_todo -= 1
                        continue

                    os.rename(pctl.master_library[item].fullpath, os.path.join(oldsplit[0], afterline))

                    pctl.master_library[item].fullpath = os.path.join(oldsplit[0], afterline)
                    pctl.master_library[item].filename = afterline

                    search_string_cache.pop(item, None)
                    search_dia_string_cache.pop(item, None)

                    if star is not None:
                        star_store.insert(item, star)

                except:
                    total_todo -= 1

            rename_track_box.active = False
            print('Done')
            if pre_state == 1:
                pctl.revert()

            if total_todo != len(r_todo):
                show_message("Rename complete." + "  " + str(total_todo) + "/" + str(
                    len(r_todo)) + " filenames written.", mode='warning')

            else:
                show_message(_("Rename complete."),
                             str(total_todo) + "/" + str(len(r_todo)) + _(" filenames were written."), mode='done')
            pctl.notify_change()


rename_track_box = RenameTrackBox()


class TransEditBox:

    def __init__(self):
        self.active = False
        self.active_field = 1
        self.selected = []
        self.playlist = -1

    def render(self):

        if not self.active:
            return

        if gui.level_2_click:
            inp.mouse_click = True
        gui.level_2_click = False

        w = 500 * gui.scale
        h = 255 * gui.scale
        x = int(window_size[0] / 2) - int(w / 2)
        y = int(window_size[1] / 2) - int(h / 2)

        ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale), colours.box_border)
        ddt.rect_a((x, y), (w, h), colours.box_background)
        ddt.text_background_colour = colours.box_background

        if key_esc_press or ((inp.mouse_click or right_click or level_2_right_click) and not coll((x, y, w, h))):
            self.active = False

        select = list(set(shift_selection))
        if not select and pctl.selected_ready():
            select = [pctl.selected_in_playlist]

        titles = [pctl.g(default_playlist[s]).title for s in select]
        artists = [pctl.g(default_playlist[s]).artist for s in select]
        albums = [pctl.g(default_playlist[s]).album for s in select]
        album_artists = [pctl.g(default_playlist[s]).album_artist for s in select]

        # print(select)
        if select != self.selected or pctl.active_playlist_viewing != self.playlist:
            # print("reset")
            self.selected = select
            self.playlist = pctl.active_playlist_viewing
            edit_album.clear()
            edit_artist.clear()
            edit_title.clear()
            edit_album_artist.clear()

            if len(select) == 0:
                return

            tr = pctl.g(default_playlist[select[0]])
            edit_title.set_text(tr.title)

            if check_equal(artists):
                edit_artist.set_text(artists[0])

            if check_equal(albums):
                edit_album.set_text(albums[0])

            if check_equal(album_artists):
                edit_album_artist.set_text(album_artists[0])

        x += round(20 * gui.scale)
        y += round(18 * gui.scale)

        ddt.text((x, y), _("Simple tag editor"), colours.box_title_text, 215)

        if draw.button(_("?"), x + 440 * gui.scale, y):
            show_message(_("Press Enter in each field to apply its changes to local database."),
                         _("When done, press WRITE TAGS to save to tags in actual files. (Optional but recommended)"),
                         mode="info")

        y += round(24 * gui.scale)
        ddt.text((x, y), _("Number of tracks selected: %d") % len(select), colours.box_title_text, 313)

        y += round(24 * gui.scale)

        if inp.key_tab_press:
            if key_shift_down or key_shiftr_down:
                self.active_field -= 1
            else:
                self.active_field += 1

        if self.active_field < 0:
            self.active_field = 3
        if self.active_field == 4:
            self.active_field = 0
            if len(select) > 1:
                self.active_field = 1

        def field_edit(x, y, label, field_number, names, text_box):
            changed = 0
            ddt.text((x, y), label, colours.box_text_label, 11)
            y += round(16 * gui.scale)
            rect1 = (x, y, round(370 * gui.scale), round(17 * gui.scale))
            fields.add(rect1)
            if (coll(rect1) and inp.mouse_click) or (inp.key_tab_press and self.active_field == field_number):
                self.active_field = field_number
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            tc = colours.box_input_text
            if names and check_equal(names) and text_box.text == names[0]:
                h, l, s = rgb_to_hls(tc[0], tc[1], tc[2])
                l *= 0.7
                tc = hls_to_rgb(h, l, s)
            else:
                changed = 1
            if not (names and check_equal(names)) and not text_box.text:
                changed = 0
                ddt.text((x + round(2 * gui.scale), y), _("<Multiple selected>"), colours.box_text_label, 12)
            text_box.draw(x + round(3 * gui.scale), y, tc, self.active_field == field_number, width=370 * gui.scale)
            if changed:
                ddt.text((x + 377 * gui.scale, y - 1 * gui.scale), "⮨", colours.box_title_text, 214)
            return changed

        changed = 0
        if len(select) == 1:
            changed = field_edit(x, y, _("Track title"), 0, titles, edit_title)
        y += round(40 * gui.scale)
        changed += field_edit(x, y, _("Album name"), 1, albums, edit_album)
        y += round(40 * gui.scale)
        changed += field_edit(x, y, _("Artist name"), 2, artists, edit_artist)
        y += round(40 * gui.scale)
        changed += field_edit(x, y, _("Album-artist name"), 3, album_artists, edit_album_artist)

        y += round(40 * gui.scale)
        for s in select:
            tr = pctl.g(default_playlist[s])
            if tr.is_network:
                ddt.text((x, y), _("Editing network tracks is not recommended!"), [245, 90, 90, 255], 312)

        if inp.key_return_press:

            gui.pl_update += 1
            if self.active_field == 0 and len(select) == 1:
                for s in select:
                    tr = pctl.g(default_playlist[s])
                    star = star_store.full_get(tr.index)
                    star_store.remove(tr.index)
                    tr.title = edit_title.text
                    star_store.merge(tr.index, star)

            if self.active_field == 1:
                for s in select:
                    tr = pctl.g(default_playlist[s])
                    tr.album = edit_album.text
            if self.active_field == 2:
                for s in select:
                    tr = pctl.g(default_playlist[s])
                    star = star_store.full_get(tr.index)
                    star_store.remove(tr.index)
                    tr.artist = edit_artist.text
                    star_store.merge(tr.index, star)
            if self.active_field == 3:
                for s in select:
                    tr = pctl.g(default_playlist[s])
                    tr.album_artist = edit_album_artist.text
            tauon.bg_save()


        ww = ddt.get_text_w(_("WRITE TAGS"), 212) + round(48 * gui.scale)
        if gui.write_tag_in_progress:
            text = f"{gui.tag_write_count}/{len(select)}"
        text = _("WRITE TAGS")
        if draw.button(text, (x + w) - ww, y - round(0) * gui.scale):
            if changed:
                show_message(_("Press enter on fields to apply your changes first!"))
                return
            try:
                import mutagen
            except:
                show_message("Please install package python-mutagen for this feature")
                return

            if gui.write_tag_in_progress:
                return

            def write_tag_go():


                for s in select:
                    tr = pctl.g(default_playlist[s])

                    if tr.is_network:
                        show_message(_("Writing to a network track is not applicable!"), mode="error")
                        gui.write_tag_in_progress = True
                        return
                    if tr.is_cue:
                        show_message(_("Cannot write CUE sheet types!"), mode="error")
                        gui.write_tag_in_progress = True
                        return

                    muta = mutagen.File(tr.fullpath, easy=True)

                    def write_tag(track, muta, field_name_tauon, field_name_muta):
                        item = muta.get(field_name_muta)
                        if item and len(item) > 1:
                            show_message(_("Cannot handle multi-field! Please use external tag editor"), mode="error")
                            return 0
                        if not getattr(tr, field_name_tauon):  # Want delete tag field
                            if item:
                                del muta[field_name_muta]
                        else:
                            muta[field_name_muta] = getattr(tr, field_name_tauon)
                        return 1

                    write_tag(tr, muta, "artist", "artist")
                    write_tag(tr, muta, "album", "album")
                    write_tag(tr, muta, "title", "title")
                    write_tag(tr, muta, "album_artist", "albumartist")

                    muta.save()
                    gui.tag_write_count += 1
                    gui.update += 1
                tauon.bg_save()
                if not gui.message_box:
                    show_message(_("%d files rewritten") % gui.tag_write_count, mode="done")
                gui.write_tag_in_progress = False
            if not gui.write_tag_in_progress:
                gui.tag_write_count = 0
                gui.write_tag_in_progress = True
                shooter(write_tag_go)

trans_edit_box = TransEditBox()


class SubLyricsBox:

    def __init__(self):

        self.active = False
        self.target_track = None
        self.active_field = 1

    def activate(self, track):

        self.active = True
        gui.box_over = True
        self.target_track = track

        sub_lyrics_a.text = prefs.lyrics_subs.get(self.target_track.artist, "")
        sub_lyrics_b.text = prefs.lyrics_subs.get(self.target_track.title, "")

        if not sub_lyrics_a.text:
            sub_lyrics_a.text = self.target_track.artist
        if not sub_lyrics_b.text:
            sub_lyrics_b.text = self.target_track.title

    def render(self):

        if not self.active:
            return

        if gui.level_2_click:
            inp.mouse_click = True
        gui.level_2_click = False

        w = 400 * gui.scale
        h = 155 * gui.scale
        x = int(window_size[0] / 2) - int(w / 2)
        y = int(window_size[1] / 2) - int(h / 2)

        ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale), colours.box_border)
        ddt.rect_a((x, y), (w, h), colours.box_background)
        ddt.text_background_colour = colours.box_background

        if key_esc_press or ((inp.mouse_click or right_click or level_2_right_click) and not coll((x, y, w, h))):
            self.active = False
            gui.box_over = False

            if sub_lyrics_a.text and sub_lyrics_a.text != self.target_track.artist:
                prefs.lyrics_subs[self.target_track.artist] = sub_lyrics_a.text
            else:
                if self.target_track.artist in prefs.lyrics_subs:
                    del prefs.lyrics_subs[self.target_track.artist]

            if sub_lyrics_b.text and sub_lyrics_b.text != self.target_track.title:
                prefs.lyrics_subs[self.target_track.title] = sub_lyrics_b.text
            else:
                if self.target_track.title in prefs.lyrics_subs:
                    del prefs.lyrics_subs[self.target_track.title]

        ddt.text((x + 10 * gui.scale, y + 8 * gui.scale,), _("Substitute Lyric Search"), colours.grey(230), 213)

        y += round(35 * gui.scale)
        x += round(23 * gui.scale)

        xx = x
        xx += ddt.text((x + round(0 * gui.scale), y + round(0 * gui.scale)), _("Substitute"), colours.box_text_label,
                       212)
        xx += round(6 * gui.scale)
        ddt.text((xx, y + round(0 * gui.scale)), self.target_track.artist, colours.box_sub_text, 312)

        y += round(19 * gui.scale)
        xx = x
        xx += ddt.text((xx + round(0 * gui.scale), y + round(0 * gui.scale)), _("with"), colours.box_text_label, 212)
        xx += round(6 * gui.scale)
        rect1 = (xx, y, round(250 * gui.scale), round(17 * gui.scale))
        fields.add(rect1)
        ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
        if (coll(rect1) and inp.mouse_click) or (inp.key_tab_press and self.active_field == 2):
            self.active_field = 1
            inp.key_tab_press = False

        sub_lyrics_a.draw(xx + round(4 * gui.scale), y, colours.box_input_text, self.active_field == 1,
                          width=rect1[2] - 8 * gui.scale)

        y += round(28 * gui.scale)

        xx = x
        xx += ddt.text((x + round(0 * gui.scale), y + round(0 * gui.scale)), _("Substitute"), colours.box_text_label,
                       212)
        xx += round(6 * gui.scale)
        ddt.text((xx, y + round(0 * gui.scale)), self.target_track.title, colours.box_sub_text, 312)

        y += round(19 * gui.scale)
        xx = x
        xx += ddt.text((xx + round(0 * gui.scale), y + round(0 * gui.scale)), _("with"), colours.box_text_label, 212)
        xx += round(6 * gui.scale)
        rect1 = (xx, y, round(250 * gui.scale), round(16 * gui.scale))
        fields.add(rect1)
        if (coll(rect1) and inp.mouse_click) or (inp.key_tab_press and self.active_field == 1):
            self.active_field = 2
        # ddt.rect(rect1, [40, 40, 40, 255], True)
        ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
        sub_lyrics_b.draw(xx + round(4 * gui.scale), y, colours.box_input_text, self.active_field == 2,
                          width=rect1[2] - 8 * gui.scale)


sub_lyrics_box = SubLyricsBox()


class ExportPlaylistBox:

    def __init__(self):

        self.active = False
        self.id = None
        self.directory_text_box = TextBox2()
        self.default = {
            "path": music_directory if music_directory else os.path.join(user_directory, 'playlists'),
            "type": "xspf",
            "relative": False,
            "auto": False,
        }

    def activate(self, playlist):

        self.active = True
        gui.box_over = True
        self.id = pl_to_id(playlist)

        # Prune old enteries
        ids = []
        for playlist in pctl.multi_playlist:
            ids.append(playlist[6])
        for key in list(prefs.playlist_exports.keys()):
            if key not in ids:
                del prefs.playlist_exports[key]

    def render(self):

        if not self.active:
            return

        w = 500 * gui.scale
        h = 220 * gui.scale
        x = int(window_size[0] / 2) - int(w / 2)
        y = int(window_size[1] / 2) - int(h / 2)

        ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale), colours.box_border)
        ddt.rect_a((x, y), (w, h), colours.box_background)
        ddt.text_background_colour = colours.box_background

        if key_esc_press or ((inp.mouse_click or gui.level_2_click or right_click or level_2_right_click) and not coll(
                (x, y, w, h))):
            self.active = False
            gui.box_over = False

        current = prefs.playlist_exports.get(self.id)
        if not current:
            current = copy.copy(self.default)

        ddt.text((x + 10 * gui.scale, y + 8 * gui.scale,), _("Export Playlist"), colours.grey(230), 213)

        x += round(15 * gui.scale)
        y += round(25 * gui.scale)

        ddt.text((x, y + 8 * gui.scale,), _("Save directory"), colours.grey(230), 11)
        y += round(30 * gui.scale)

        rect1 = (x, y, round(450 * gui.scale), round(16 * gui.scale))
        fields.add(rect1)
        # ddt.rect(rect1, [40, 40, 40, 255], True)
        ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
        self.directory_text_box.text = current["path"]
        self.directory_text_box.draw(x + round(4 * gui.scale), y, colours.box_input_text, True,
                                     width=rect1[2] - 8 * gui.scale, click=gui.level_2_click)
        current["path"] = self.directory_text_box.text

        y += round(30 * gui.scale)
        if pref_box.toggle_square(x, y, current["type"] == "xspf", "XSPF", gui.level_2_click):
            current["type"] = "xspf"
        if pref_box.toggle_square(x + round(80 * gui.scale), y, current["type"] == "m3u", "M3U", gui.level_2_click):
            current["type"] = "m3u"
        # pref_box.toggle_square(x + round(160 * gui.scale), y, False, "PLS", gui.level_2_click)
        y += round(35 * gui.scale)
        current["relative"] = pref_box.toggle_square(x, y, current["relative"], _("Use relative paths"),
                                                     gui.level_2_click)
        y += round(60 * gui.scale)
        current["auto"] = pref_box.toggle_square(x, y, current["auto"], _("Auto-export"), gui.level_2_click)

        y += round(0 * gui.scale)
        ww = ddt.get_text_w(_("Export"), 211)
        x = ((int(window_size[0] / 2) - int(w / 2)) + w) - (ww + round(40 * gui.scale))

        prefs.playlist_exports[self.id] = current

        if draw.button(_("Export"), x, y, press=gui.level_2_click):
            self.run_export(current, self.id, warnings=True)

    def run_export(self, current, id, warnings=True):
        print("Export playlist")
        path = current["path"]
        if not os.path.isdir(path):
            if warnings:
                show_message(_("Directory does not exist"), mode="warning")
            return
        target = ""
        if current["type"] == "xspf":
            target = export_xspf(id_to_pl(id), direc=path, relative=current["relative"], show=False)
        if current["type"] == "m3u":
            target = export_m3u(id_to_pl(id), direc=path, relative=current["relative"], show=False)

        if warnings and target != 1:
            show_message("Playlist exported", target, mode="done")


export_playlist_box = ExportPlaylistBox()


def toggle_repeat():
    gui.update += 1
    pctl.repeat_mode ^= True
    if pctl.mpris is not None:
        pctl.mpris.update_loop()


tauon.toggle_repeat = toggle_repeat


def menu_repeat_off():
    pctl.repeat_mode = False
    pctl.album_repeat_mode = False
    if pctl.mpris is not None:
        pctl.mpris.update_loop()


def menu_set_repeat():
    pctl.repeat_mode = True
    pctl.album_repeat_mode = False
    if pctl.mpris is not None:
        pctl.mpris.update_loop()


def menu_album_repeat():
    pctl.repeat_mode = True
    pctl.album_repeat_mode = True
    if pctl.mpris is not None:
        pctl.mpris.update_loop()


tauon.menu_album_repeat = menu_album_repeat
tauon.menu_repeat_off = menu_repeat_off
tauon.menu_set_repeat = menu_set_repeat

repeat_menu.add(MenuItem(_("Repeat OFF"), menu_repeat_off))
repeat_menu.add(MenuItem(_("Repeat Track"), menu_set_repeat))
repeat_menu.add(MenuItem(_("Repeat Album"), menu_album_repeat))


def toggle_random():
    gui.update += 1
    pctl.random_mode ^= True
    if pctl.mpris is not None:
        pctl.mpris.update_shuffle()


tauon.toggle_random = toggle_random


def toggle_random_on():
    pctl.random_mode = True
    if pctl.mpris is not None:
        pctl.mpris.update_shuffle()


def toggle_random_off():
    pctl.random_mode = False
    if pctl.mpris is not None:
        pctl.mpris.update_shuffle()


def menu_shuffle_off():
    pctl.random_mode = False
    pctl.album_shuffle_mode = False
    if pctl.mpris is not None:
        pctl.mpris.update_shuffle()


def menu_set_random():
    pctl.random_mode = True
    pctl.album_shuffle_mode = False
    if pctl.mpris is not None:
        pctl.mpris.update_shuffle()


def menu_album_random():
    pctl.random_mode = True
    pctl.album_shuffle_mode = True
    if pctl.mpris is not None:
        pctl.mpris.update_shuffle()


def toggle_shuffle_layout(albums=False):
    prefs.shuffle_lock ^= True
    if prefs.shuffle_lock:

        gui.shuffle_was_showcase = gui.showcase_mode
        gui.shuffle_was_random = pctl.random_mode
        gui.shuffle_was_repeat = pctl.repeat_mode

        if not gui.combo_mode:
            view_box.lyrics(hit=True)
        pctl.random_mode = True
        pctl.repeat_mode = False
        if albums:
            prefs.album_shuffle_lock_mode = True
        if pctl.playing_state == 0:
            pctl.advance()
    else:
        pctl.random_mode = gui.shuffle_was_random
        pctl.repeat_mode = gui.shuffle_was_repeat
        prefs.album_shuffle_lock_mode = False
        if not gui.shuffle_was_showcase:
            exit_combo()


def toggle_shuffle_layout_albums():
    toggle_shuffle_layout(albums=True)


def exit_shuffle_layout(_):
    return prefs.shuffle_lock


shuffle_menu.add(MenuItem(_("Shuffle Lockdown"), toggle_shuffle_layout))
shuffle_menu.add(MenuItem(_("Shuffle Lockdown Albums"), toggle_shuffle_layout_albums))
shuffle_menu.br()
shuffle_menu.add(MenuItem(_("Shuffle OFF"), menu_shuffle_off))
shuffle_menu.add(MenuItem(_("Shuffle Tracks"), menu_set_random))
shuffle_menu.add(MenuItem(_("Random Albums"), menu_album_random))


def bio_set_large():
    # if window_size[0] >= round(1000 * gui.scale):
    # gui.artist_panel_height = 320 * gui.scale
    prefs.bio_large = True
    if gui.artist_info_panel:
        artist_info_box.get_data(artist_info_box.artist_on)


def bio_set_small():
    # gui.artist_panel_height = 200 * gui.scale
    prefs.bio_large = False
    update_layout_do()
    if gui.artist_info_panel:
        artist_info_box.get_data(artist_info_box.artist_on)


def artist_info_panel_close():
    gui.artist_info_panel ^= True
    gui.update_layout()


def toggle_bio_size_deco():
    line = _("Make Large Size")
    if prefs.bio_large:
        line = _("Make Compact Size")

    return [colours.menu_text, colours.menu_background, line]


def toggle_bio_size():
    if prefs.bio_large:
        prefs.bio_large = False
        update_layout_do()
        # bio_set_small()

    else:
        prefs.bio_large = True
        update_layout_do()
        # bio_set_large()
    # gui.update_layout()


def flush_artist_bio(artist):
    if os.path.isfile(os.path.join(a_cache_dir, artist + '-lfm.txt')):
        os.remove(os.path.join(a_cache_dir, artist + '-lfm.txt'))
    artist_info_box.text = ""
    artist_info_box.artist_on = None


def test_shift(_):
    return key_shift_down or key_shiftr_down


def test_artist_dl(_):
    return not prefs.auto_dl_artist_data


artist_info_menu.add(MenuItem(_("Close Panel"), artist_info_panel_close))
artist_info_menu.add(MenuItem(_("Make Large"), toggle_bio_size, toggle_bio_size_deco))


def show_in_playlist():
    if album_mode and window_size[0] < 750 * gui.scale:
        toggle_album_mode()

    pctl.playlist_view_position = pctl.selected_in_playlist
    console.print("DEBUG: Position changed by show in playlist")
    shift_selection.clear()
    shift_selection.append(pctl.selected_in_playlist)
    pctl.render_playlist()


filter_icon = MenuIcon(asset_loader('filter.png', True))
filter_icon.colour = [43, 213, 255, 255]
filter_icon.xoff = 1

folder_icon = MenuIcon(asset_loader('folder.png', True))
info_icon = MenuIcon(asset_loader('info.png', True))

folder_icon.colour = [244, 220, 66, 255]
info_icon.colour = [61, 247, 163, 255]

power_bar_icon = asset_loader('power.png', True)


def open_folder_stem(path):
    if system == 'windows' or msys:
        line = r'explorer /select,"%s"' % (
            path.replace("/", "\\"))
        subprocess.Popen(line)
    else:
        line = path
        line += "/"
        if macos:
            subprocess.Popen(['open', line])
        else:
            subprocess.Popen(['xdg-open', line])


def open_folder_disable_test(index):
    track = pctl.master_library[index]
    return track.is_network and not os.path.isdir(track.parent_folder_path)

def open_folder(index):
    track = pctl.master_library[index]
    if open_folder_disable_test(index):
        show_message("Can't open folder of a network track.")
        return

    if system == 'windows' or msys:
        line = r'explorer /select,"%s"' % (
            track.fullpath.replace("/", "\\"))
        subprocess.Popen(line)
    else:
        line = track.parent_folder_path
        line += "/"
        if macos:
            line = track.fullpath
            subprocess.Popen(['open', '-R', line])
        else:
            subprocess.Popen(['xdg-open', line])


def tag_to_new_playlist(tag_item):
    path_stem_to_playlist(tag_item.path, tag_item.name)


def folder_to_new_playlist_by_track_id(track_id):
    track = pctl.g(track_id)
    path_stem_to_playlist(track.parent_folder_path, track.parent_folder_name)


def stem_to_new_playlist(path):
    path_stem_to_playlist(path, os.path.basename(path))


move_jobs = []
move_in_progress = False


def move_playing_folder_to_tree_stem(path):
    move_playing_folder_to_stem(path, pl_id=tree_view_box.get_pl_id())


def move_playing_folder_to_stem(path, pl_id=None):
    if not pl_id:
        pl_id = pctl.multi_playlist[pctl.active_playlist_viewing][6]

    track = pctl.playing_object()

    if not track or pctl.playing_state == 0:
        show_message("No item is currently playing")
        return

    move_folder = track.parent_folder_path

    # Stop playing track if its in the current folder
    if pctl.playing_state > 0:
        if move_folder in pctl.playing_object().parent_folder_path:
            pctl.stop(True)

    target_base = path

    # Determine name for artist folder
    artist = track.artist
    if track.album_artist:
        artist = track.album_artist

    # Make filename friendly
    artist = filename_safe(artist)
    if not artist:
        artist = "unknown artist"

    # Sanity checks
    if track.is_network:
        show_message("This track is a networked track.", mode="error")
        return

    if not os.path.isdir(move_folder):
        show_message("The source folder does not exist.", mode="error")
        return

    if not os.path.isdir(target_base):
        show_message("The destination folder does not exist.", mode="error")
        return

    if os.path.normpath(target_base) == os.path.normpath(move_folder):
        show_message("The destination and source folders are the same.", mode="error")
        return

    if len(target_base) < 4:
        show_message("Safety interupt! The source path seems oddly short.", target_base, mode='error')
        return

    protect = ("", "Documents", "Music", "Desktop", "Downloads")
    for fo in protect:
        if move_folder.strip('\\/') == os.path.join(os.path.expanduser('~'), fo).strip("\\/"):
            show_message("Better not do anything to that folder!", os.path.join(os.path.expanduser('~'), fo),
                         mode='warning')
            return

    if directory_size(move_folder) > 3000000000:
        show_message("Folder size safety limit reached! (3GB)", move_folder, mode='warning')
        return

    # Use target folder if it already is an artist folder
    if os.path.basename(target_base).lower() == artist.lower():
        artist_folder = target_base

    # Make artist folder if it does not exist
    else:
        artist_folder = os.path.join(target_base, artist)
        if not os.path.exists(artist_folder):
            os.makedirs(artist_folder)

    # Remove all tracks with the old paths
    for pl in pctl.multi_playlist:
        for i in reversed(range(len(pl[2]))):
            if pctl.g(pl[2][i]).parent_folder_path == track.parent_folder_path:
                del pl[2][i]

    # Find insert location
    pl = pctl.multi_playlist[id_to_pl(pl_id)][2]

    matches = []
    insert = 0

    for i, item in enumerate(pl):
        if pctl.g(item).fullpath.startswith(target_base):
            insert = i

    for i, item in enumerate(pl):
        if pctl.g(item).fullpath.startswith(artist_folder):
            insert = i

    print("The folder to be moved is: " + move_folder)
    load_order = LoadClass()
    load_order.target = os.path.join(artist_folder, track.parent_folder_name)
    load_order.playlist = pl_id
    load_order.playlist_position = insert

    print(artist_folder)
    print(os.path.join(artist_folder, track.parent_folder_name))
    move_jobs.append((move_folder, os.path.join(artist_folder, track.parent_folder_name), True,
                      track.parent_folder_name, load_order))
    tm.ready("worker")


def move_playing_folder_to_tag(tag_item):
    move_playing_folder_to_stem(tag_item.path)


def re_import4(id):
    p = None
    for i, idd in enumerate(default_playlist):
        if idd == id:
            p = i
            break

    load_order = LoadClass()

    if p is not None:
        load_order.playlist_position = p

    load_order.replace_stem = True
    load_order.target = pctl.g(id).parent_folder_path
    load_order.notify = True
    load_order.playlist = pctl.multi_playlist[pctl.active_playlist_viewing][6]
    load_orders.append(copy.deepcopy(load_order))
    show_message("Rescanning folder...", pctl.g(id).parent_folder_path, mode='info')


def re_import3(stem):
    p = None
    for i, id in enumerate(default_playlist):
        if pctl.g(id).fullpath.startswith(stem + "/"):
            p = i
            break

    load_order = LoadClass()

    if p is not None:
        load_order.playlist_position = p

    load_order.replace_stem = True
    load_order.target = stem
    load_order.notify = True
    load_order.playlist = pctl.multi_playlist[pctl.active_playlist_viewing][6]
    load_orders.append(copy.deepcopy(load_order))
    show_message("Rescanning folder...", stem, mode='info')


def collapse_tree_deco():
    pl_id = tree_view_box.get_pl_id()

    if tree_view_box.opens.get(pl_id):
        return [colours.menu_text, colours.menu_background, None]
    else:
        return [colours.menu_text_disabled, colours.menu_background, None]


def collapse_tree():
    tree_view_box.collapse_all()


def lock_folder_tree():
    if tree_view_box.lock_pl:
        tree_view_box.lock_pl = None
    else:
        tree_view_box.lock_pl = pctl.multi_playlist[pctl.active_playlist_viewing][6]


def lock_folder_tree_deco():
    if tree_view_box.lock_pl:
        return [colours.menu_text, colours.menu_background, _("Unlock Panel")]
    else:
        return [colours.menu_text, colours.menu_background, _("Lock Panel")]


folder_tree_stem_menu.add(MenuItem(_('Open Folder'), open_folder_stem, pass_ref=True, icon=folder_icon))
folder_tree_menu.add(MenuItem(_('Open Folder'), open_folder, pass_ref=True, pass_ref_deco=True, icon=folder_icon, disable_test=open_folder_disable_test))

lightning_menu.add(MenuItem(_("Filter to New Playlist"), tag_to_new_playlist, pass_ref=True, icon=filter_icon))
folder_tree_menu.add(MenuItem(_("Filter to New Playlist"), folder_to_new_playlist_by_track_id, pass_ref=True, icon=filter_icon))
folder_tree_stem_menu.add(MenuItem(_("Filter to New Playlist"), stem_to_new_playlist, pass_ref=True, icon=filter_icon))
folder_tree_stem_menu.add(MenuItem(_("Rescan Folder"), re_import3, pass_ref=True))
folder_tree_menu.add(MenuItem(_("Rescan Folder"), re_import4, pass_ref=True))
lightning_menu.add(MenuItem(_("Move Playing Folder Here"), move_playing_folder_to_tag, pass_ref=True))

folder_tree_stem_menu.add(MenuItem(_("Move Playing Folder Here"), move_playing_folder_to_tree_stem, pass_ref=True))

folder_tree_stem_menu.br()

folder_tree_stem_menu.add(MenuItem(_('Collapse All'), collapse_tree, collapse_tree_deco))

folder_tree_stem_menu.add(MenuItem("lock", lock_folder_tree, lock_folder_tree_deco))
# folder_tree_menu.add("lock", lock_folder_tree, lock_folder_tree_deco)

gallery_menu.add(MenuItem(_('Open Folder'), open_folder, pass_ref=True, pass_ref_deco=True, icon=folder_icon, disable_test=open_folder_disable_test))

gallery_menu.add(MenuItem(_("Show in Playlist"), show_in_playlist))


def finish_current():
    playing_object = pctl.playing_object()
    if playing_object is None:
        show_message("")

    if not pctl.force_queue:
        pctl.force_queue.insert(0, queue_item_gen(playing_object.index,
                                                  pctl.playlist_playing_position,
                                                  pl_to_id(pctl.active_playlist_playing), 1, 1))


def add_album_to_queue(ref, position=None, playlist_id=None):
    if position is None:
        position = r_menu_position
    if playlist_id is None:
        playlist_id = pl_to_id(pctl.active_playlist_viewing)

    partway = 0
    playing_object = pctl.playing_object()
    if not pctl.force_queue and playing_object is not None:
        if pctl.g(ref).parent_folder_path == playing_object.parent_folder_path:
            partway = 1

    queue_object = queue_item_gen(ref, position, playlist_id, 1, partway)
    pctl.force_queue.append(queue_object)
    queue_timer_set(queue_object=queue_object)
    if prefs.stop_end_queue:
        pctl.auto_stop = False


def add_album_to_queue_fc(ref):
    playing_object = pctl.playing_object()
    if playing_object is None:
        show_message("")

    queue_item = None

    if not pctl.force_queue:
        queue_item = queue_item_gen(playing_object.index,
                                    pctl.playlist_playing_position, pl_to_id(pctl.active_playlist_playing), 1, 1)
        pctl.force_queue.insert(0, queue_item)
        add_album_to_queue(ref)
        return

    if pctl.force_queue[0][4] == 1:
        queue_item = queue_item_gen(ref,
                                    pctl.playlist_playing_position, pl_to_id(pctl.active_playlist_playing), 1, 0)
        pctl.force_queue.insert(1, queue_item)
    else:

        p = pctl.g(ref).parent_folder_path
        p = ""
        if pctl.playing_ready():
            p = pctl.playing_object().parent_folder_path

        # fixme for network tracks

        for i, item in enumerate(pctl.force_queue):

            if p != pctl.g(item[0]).parent_folder_path:
                queue_item = queue_item_gen(ref,
                                            pctl.playlist_playing_position,
                                            pl_to_id(pctl.active_playlist_playing), 1, 0, )
                pctl.force_queue.insert(i, queue_item)
                break

        else:
            queue_item = queue_item_gen(ref,
                                        pctl.playlist_playing_position, pl_to_id(pctl.active_playlist_playing), 1, 0, )
            pctl.force_queue.insert(len(pctl.force_queue), queue_item)
    if queue_item:
        queue_timer_set(queue_object=queue_item)
    if prefs.stop_end_queue:
        pctl.auto_stop = False



gallery_menu.add_sub(_("Image…"), 160)
gallery_menu.add(MenuItem(_("Add Album to Queue"), add_album_to_queue, pass_ref=True))
gallery_menu.add(MenuItem(_("Enqueue Album Next"), add_album_to_queue_fc, pass_ref=True))


def cancel_import():
    if transcode_list:
        del transcode_list[1:]
        gui.tc_cancel = True
    if loading_in_progress:
        gui.im_cancel = True
    if gui.sync_progress:
        gui.stop_sync = True
        gui.sync_progress = _("Aborting Sync")


cancel_menu.add(MenuItem(_("Cancel"), cancel_import))


def toggle_lyrics_show(a):
    return not gui.combo_mode


def toggle_side_art_deco():
    colour = colours.menu_text
    if prefs.show_side_lyrics_art_panel:
        line = _("Hide Metadata Panel")
    else:
        line = _("Show Metadata Panel")

    if gui.combo_mode:
        colour = colours.menu_text_disabled

    return [colour, colours.menu_background, line]


def toggle_lyrics_panel_position_deco():
    colour = colours.menu_text
    if prefs.lyric_metadata_panel_top:
        line = _("Panel Below Lyrics")
    else:
        line = _("Panel Above Lyrics")

    if gui.combo_mode or not prefs.show_side_lyrics_art_panel:
        colour = colours.menu_text_disabled

    return [colour, colours.menu_background, line]


def toggle_lyrics_panel_position():
    prefs.lyric_metadata_panel_top ^= True


def lyrics_in_side_show(track_object):
    if gui.combo_mode or not prefs.show_lyrics_side:
        return False
    return True


def toggle_side_art():
    prefs.show_side_lyrics_art_panel ^= True


def toggle_lyrics_deco(track_object):
    colour = colours.menu_text

    if gui.combo_mode:
        if prefs.show_lyrics_showcase:
            line = _("Hide Lyrics")
        else:
            line = _("Show Lyrics")
        if not track_object or (track_object.lyrics == "" and not timed_lyrics_ren.generate(track_object)):
            colour = colours.menu_text_disabled
        return [colour, colours.menu_background, line]

    if prefs.side_panel_layout == 1:  # and prefs.show_side_art:

        if prefs.show_lyrics_side:
            line = _("Hide Lyrics")
        else:
            line = _("Show Lyrics")
        if (track_object.lyrics == "" and not timed_lyrics_ren.generate(track_object)):
            colour = colours.menu_text_disabled
        return [colour, colours.menu_background, line]

    if prefs.show_lyrics_side:
        line = _("Hide Lyrics")
    else:
        line = _("Show Lyrics")
    if (track_object.lyrics == "" and not timed_lyrics_ren.generate(track_object)):
        colour = colours.menu_text_disabled
    return [colour, colours.menu_background, line]


def toggle_lyrics(track_object):
    if not track_object:
        return

    if gui.combo_mode:
        prefs.show_lyrics_showcase ^= True
        if prefs.show_lyrics_showcase and track_object.lyrics == "" and timed_lyrics_ren.generate(track_object):
            prefs.prefer_synced_lyrics = True
        # if prefs.show_lyrics_showcase and track_object.lyrics == "":
        #     show_message(_("No lyrics for this track"))
    else:

        # Handling for alt panel layout
        # if prefs.side_panel_layout == 1 and prefs.show_side_art:
        #     #prefs.show_side_art = False
        #     prefs.show_lyrics_side = True
        #     return

        prefs.show_lyrics_side ^= True
        if prefs.show_lyrics_side and track_object.lyrics == "" and timed_lyrics_ren.generate(track_object):
            prefs.prefer_synced_lyrics = True
        # if prefs.show_lyrics_side and track_object.lyrics == "":
        #     show_message(_("No lyrics for this track"))


def get_lyric_fire(track_object, silent=False):
    lyrics_ren.lyrics_position = 0

    if not prefs.lyrics_enables:
        if not silent:
            show_message(_("There are no lyric sources enabled."),
                         "See 'lyrics settings' under 'functions' tab in settings.", mode='info')
        return

    t = lyrics_fetch_timer.get()
    print("Lyric rate limit timer is: " + str(t) + " / -60")
    if t < -40:
        print("Lets try again later")
        if not silent:
            show_message(_("Let's be polite and try later."))

            if t < -65:
                show_message("Stop requesting lyrics AAAAAA.", mode='error')

        # If the user keeps pressing, lets mess with them haha
        lyrics_fetch_timer.force_set(t - 5)

        return 'later'

    if t > 0:
        lyrics_fetch_timer.set()
        t = 0

    lyrics_fetch_timer.force_set(t - 10)

    if not silent:
        show_message(_("Searching..."))

    s_artist = track_object.artist
    s_title = track_object.title

    if s_artist in prefs.lyrics_subs:
        s_artist = prefs.lyrics_subs[s_artist]
    if s_title in prefs.lyrics_subs:
        s_title = prefs.lyrics_subs[s_title]

    console.print(f"Searching for lyrics: {s_artist} - {s_title}", level=1)

    found = False
    for name in prefs.lyrics_enables:

        if name in lyric_sources.keys():
            func = lyric_sources[name]

            try:
                lyrics = func(s_artist, s_title)
                if lyrics:
                    console.print(f"Found lyrics from {name}", level=1)
                    track_object.lyrics = lyrics
                    found = True
                    break
            except Exception as e:
                console.print(str(e))

            if not found:
                console.print(f"Could not find lyrics from source {name}", level=1)

    if not found:
        if not silent:
            show_message(_("No lyrics for this track were found"))
    else:
        gui.message_box = False
        if not gui.showcase_mode:
            prefs.show_lyrics_side = True
        gui.update += 1
        lyrics_ren.lyrics_position = 0
        pctl.notify_change()


def get_lyric_wiki(track_object):
    if track_object.artist == "" or track_object.title == "":
        show_message("Insufficient metadata to get lyrics", mode='warning')
        return

    shoot_dl = threading.Thread(target=get_lyric_fire, args=([track_object]))
    shoot_dl.daemon = True
    shoot_dl.start()

    print("..Done")


def get_lyric_wiki_silent(track_object):
    print("Searching for lyrics...")

    if track_object.artist == "" or track_object.title == "":
        return

    shoot_dl = threading.Thread(target=get_lyric_fire, args=([track_object, True]))
    shoot_dl.daemon = True
    shoot_dl.start()

    print("..Done")


def test_auto_lyrics(track_object):
    if not track_object:
        return

    if prefs.auto_lyrics and not track_object.lyrics and track_object.index not in prefs.auto_lyrics_checked:
        if lyrics_check_timer.get() > 5 and pctl.playing_time > 1:
            result = get_lyric_wiki_silent(track_object)
            if result == "later":
                pass
            else:
                lyrics_check_timer.set()
                prefs.auto_lyrics_checked.append(track_object.index)


def get_bio(track_object):
    if track_object.artist != "":
        lastfm.get_bio(track_object.artist)


def search_lyrics_deco(track_object):
    if not track_object.lyrics:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


showcase_menu.add(MenuItem(_('Search for Lyrics'), get_lyric_wiki, search_lyrics_deco, pass_ref=True, pass_ref_deco=True))


def toggle_synced_lyrics(tr):
    prefs.prefer_synced_lyrics ^= True

def toggle_synced_lyrics_deco(track):
    if prefs.prefer_synced_lyrics:
        text = _("Show static lyrics")
    else:
        text = _("Show synced lyrics")
    if timed_lyrics_ren.generate(track) and track.lyrics:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled
        if not track.lyrics:
            text = _("Show static lyrics")
        if not timed_lyrics_ren.generate(track):
            text = _("Show synced lyrics")

    return [line_colour, colours.menu_background, text]

showcase_menu.add(MenuItem("Toggle synced", toggle_synced_lyrics, toggle_synced_lyrics_deco, pass_ref=True, pass_ref_deco=True))


def search_guitarparty(track_object):
    if not track_object.title:
        show_message("Insufitent metadata to search")
    gc.fetch(track_object)


def search_guitarparty_showtest(_):
    return gui.combo_mode and prefs.guitar_chords


showcase_menu.add(MenuItem(_('Search GuitarParty'), search_guitarparty, pass_ref=True, show_test=search_guitarparty_showtest))


def paste_lyrics_deco():
    if SDL_HasClipboardText():
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


def paste_lyrics(track_object):
    if SDL_HasClipboardText():
        clip = SDL_GetClipboardText()
        # print(clip)
        track_object.lyrics = clip.decode('utf-8')

    else:
        print('NO TEXT TO PASTE')


def paste_chord_lyrics(track_object):
    if track_object.title:
        gc.save_format_b(track_object)


def chord_lyrics_paste_show_test(_):
    return gui.combo_mode and prefs.guitar_chords


def clear_chord_lyrics(track_object):
    if track_object.title:
        gc.clear(track_object)


showcase_menu.add(MenuItem(_('Paste Chord Lyrics'), paste_chord_lyrics, pass_ref=True, show_test=chord_lyrics_paste_show_test))
showcase_menu.add(MenuItem(_('Clear Chord Lyrics'), clear_chord_lyrics, pass_ref=True, show_test=chord_lyrics_paste_show_test))


def copy_lyrics_deco(track_object):
    if track_object.lyrics:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


def copy_lyrics(track_object):
    copy_to_clipboard(track_object.lyrics)


def clear_lyrics(track_object):
    track_object.lyrics = ""


def clear_lyrics_deco(track_object):
    if track_object.lyrics:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


def split_lyrics(track_object):
    if track_object.lyrics != "":
        track_object.lyrics = track_object.lyrics.replace(". ", ". \n")
    else:
        pass


def show_sub_search(track_object):
    sub_lyrics_box.activate(track_object)


showcase_menu.add(MenuItem(_('Toggle Lyrics'), toggle_lyrics, toggle_lyrics_deco, pass_ref=True, pass_ref_deco=True))
showcase_menu.add_sub("Misc…", 150)
showcase_menu.add_to_sub(0, MenuItem(_('Substitute Search...'), show_sub_search, pass_ref=True))
showcase_menu.add_to_sub(0, MenuItem(_('Paste Lyrics'), paste_lyrics, paste_lyrics_deco, pass_ref=True))
showcase_menu.add_to_sub(0, MenuItem(_('Copy Lyrics'), copy_lyrics, copy_lyrics_deco, pass_ref=True, pass_ref_deco=True))
showcase_menu.add_to_sub(0, MenuItem(_('Clear Lyrics'), clear_lyrics, clear_lyrics_deco, pass_ref=True, pass_ref_deco=True))
showcase_menu.add_to_sub(0, MenuItem('Toggle art panel', toggle_side_art, toggle_side_art_deco, show_test=lyrics_in_side_show))
showcase_menu.add_to_sub(0, MenuItem('Toggle art position', toggle_lyrics_panel_position, toggle_lyrics_panel_position_deco,
                         show_test=lyrics_in_side_show))

center_info_menu.add(MenuItem(_('Search for Lyrics'), get_lyric_wiki, search_lyrics_deco, pass_ref=True, pass_ref_deco=True))
center_info_menu.add(MenuItem(_('Toggle Lyrics'), toggle_lyrics, toggle_lyrics_deco, pass_ref=True, pass_ref_deco=True))
center_info_menu.add_sub("Misc…", 150)
center_info_menu.add_to_sub(0, MenuItem(_('Substitute Search...'), show_sub_search, pass_ref=True))
center_info_menu.add_to_sub(0, MenuItem(_('Paste Lyrics'), paste_lyrics, paste_lyrics_deco, pass_ref=True))
center_info_menu.add_to_sub(0, MenuItem(_('Copy Lyrics'), copy_lyrics, copy_lyrics_deco, pass_ref=True, pass_ref_deco=True))
center_info_menu.add_to_sub(0, MenuItem(_('Clear Lyrics'), clear_lyrics, clear_lyrics_deco, pass_ref=True, pass_ref_deco=True))
center_info_menu.add_to_sub(0, MenuItem('Toggle art panel', toggle_side_art, toggle_side_art_deco, show_test=lyrics_in_side_show))
center_info_menu.add_to_sub(0, MenuItem('Toggle art position', toggle_lyrics_panel_position, toggle_lyrics_panel_position_deco,
                            show_test=lyrics_in_side_show))

def save_embed_img_disable_test(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    return track_object.is_network

def save_embed_img(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    filepath = track_object.fullpath
    folder = track_object.parent_folder_path
    ext = track_object.file_ext

    if save_embed_img_disable_test(track_object):
        show_message("Saving network images not implemented")
        return

    try:
        pic = album_art_gen.get_embed(track_object)

        if not pic:
            show_message("Image save error.", "No embedded album art found file.", mode='warning')
            return

        source_image = io.BytesIO(pic)
        im = Image.open(source_image)

        source_image.close()

        ext = "." + im.format.lower()
        if im.format == "JPEG":
            ext = ".jpg"

        target = os.path.join(folder, "embed-" + str(im.height) + "px-" + str(track_object.index) + ext)

        if len(pic) > 30:
            with open(target, 'wb') as w:
                w.write(pic)

        open_folder(track_object.index)

    except:
        show_message("Image save error.", "A mysterious error occurred", mode='error')


picture_menu = Menu(175)


def open_image_deco(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    info = album_art_gen.get_info(track_object)

    if info is None:
        return [colours.menu_text_disabled, colours.menu_background, None]

    line_colour = colours.menu_text

    return [line_colour, colours.menu_background, None]


def open_image_disable_test(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    return track_object.is_network

def open_image(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    album_art_gen.open_external(track_object)


def extract_image_deco(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    info = album_art_gen.get_info(track_object)

    if info is None:
        return [colours.menu_text_disabled, colours.menu_background, None]

    if info[0] == 1:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


picture_menu.add(MenuItem(_("Open Image"), open_image, open_image_deco, pass_ref=True, pass_ref_deco=True, disable_test=open_image_disable_test))


def cycle_image_deco(track_object):
    info = album_art_gen.get_info(track_object)

    if pctl.playing_state != 0 and (info is not None and info[1] > 1):
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]

def cycle_image_gal_deco(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    info = album_art_gen.get_info(track_object)

    if info is not None and info[1] > 1:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]

def cycle_offset(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    album_art_gen.cycle_offset(track_object)


def cycle_offset_back(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    album_art_gen.cycle_offset_reverse(track_object)


# Next and previous pictures
picture_menu.add(MenuItem(_("Next Image"), cycle_offset, cycle_image_deco, pass_ref=True, pass_ref_deco=True))
#picture_menu.add(_("Previous"), cycle_offset_back, cycle_image_deco, pass_ref=True, pass_ref_deco=True)

# Extract embedded artwork from file
picture_menu.add(MenuItem(_('Extract Image'), save_embed_img, extract_image_deco, pass_ref=True, pass_ref_deco=True, disable_test=save_embed_img_disable_test))


def dl_art_deco(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    if not track_object.album or not track_object.artist:
        return [colours.menu_text_disabled, colours.menu_background, None]
    return [colours.menu_text, colours.menu_background, None]


def download_art1(tr):
    if tr.is_network:
        show_message(_("Cannot download art for network tracks."))
        return

    # Determine noise of folder ----------------
    siblings = []
    parent = tr.parent_folder_path

    for pl in pctl.multi_playlist:
        for ti in pl[2]:
            tr = pctl.g(ti)
            if tr.parent_folder_path == parent:
                siblings.append(tr)

    album_tags = []
    date_tags = []

    for tr in siblings:
        album_tags.append(tr.album)
        date_tags.append(tr.date)

    album_tags = set(album_tags)
    date_tags = set(date_tags)

    if len(album_tags) > 2 or len(date_tags) > 2:
        show_message(_("It doesn't look like this folder belongs to a single album, sorry"))
        return

    # -------------------------------------------

    if not os.path.isdir(tr.parent_folder_path):
        show_message("Directory missing.")
        return

    try:
        show_message(_("Looking up MusicBrainz ID..."))

        if 'musicbrainz_releasegroupid' not in tr.misc or 'musicbrainz_artistids' not in tr.misc or not tr.misc[
            'musicbrainz_artistids']:

            print("MusicBrainz ID lookup...")

            artist = tr.album_artist
            if not tr.album:
                return
            if not artist:
                artist = tr.artist

            s = musicbrainzngs.search_release_groups(tr.album, artist=artist, limit=1)

            album_id = s['release-group-list'][0]['id']
            artist_id = s['release-group-list'][0]['artist-credit'][0]['artist']['id']

            print("Found release group ID: " + album_id)
            print("Found artist ID: " + artist_id)

        else:

            album_id = tr.misc['musicbrainz_releasegroupid']
            artist_id = tr.misc['musicbrainz_artistids'][0]

            print("Using tagged release group ID: " + album_id)
            print("Using tagged artist ID: " + artist_id)

        if prefs.enable_fanart_cover:
            try:
                show_message("Searching fanart.tv for cover art...")

                r = requests.get("http://webservice.fanart.tv/v3/music/albums/" \
                                 + artist_id + "?api_key=" + prefs.fatvap, timeout=(4, 10))

                artlink = r.json()['albums'][album_id]['albumcover'][0]['url']
                id = r.json()['albums'][album_id]['albumcover'][0]['id']

                response = urllib.request.urlopen(artlink, cafile=tauon.ca)
                info = response.info()

                t = io.BytesIO()
                t.seek(0)
                t.write(response.read())
                t.seek(0, 2)
                l = t.tell()
                t.seek(0)

                if info.get_content_maintype() == 'image' and l > 1000:

                    if info.get_content_subtype() == 'jpeg':
                        filepath = os.path.join(tr.parent_folder_path, "cover-" + id + ".jpg")
                    elif info.get_content_subtype() == 'png':
                        filepath = os.path.join(tr.parent_folder_path, "cover-" + id + ".png")
                    else:
                        show_message("Could not detect downloaded filetype.", mode='error')
                        return

                    f = open(filepath, 'wb')
                    f.write(t.read())
                    f.close()

                    show_message(_("Cover art downloaded from fanart.tv"), mode='done')
                    # clear_img_cache()
                    for track_id in default_playlist:
                        if tr.parent_folder_path == pctl.g(track_id).parent_folder_path:
                            clear_track_image_cache(pctl.g(track_id))
                    return
            except:
                print("Failed to get from fanart.tv")

        show_message("Searching MusicBrainz for cover art...")
        t = io.BytesIO(musicbrainzngs.get_release_group_image_front(album_id, size=None))
        l = 0
        t.seek(0, 2)
        l = t.tell()
        t.seek(0)
        if l > 1000:
            filepath = os.path.join(tr.parent_folder_path, album_id + ".jpg")
            f = open(filepath, 'wb')
            f.write(t.read())
            f.close()

            show_message(_("Cover art downloaded from MusicBrainz"), mode='done')
            # clear_img_cache()
            clear_track_image_cache(tr)

            for track_id in default_playlist:
                if tr.parent_folder_path == pctl.g(track_id).parent_folder_path:
                    clear_track_image_cache(pctl.g(track_id))

            return

    except:
        show_message(_("Matching cover art or ID could not be found."))


def download_art1_fire_disable_test(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    return track_object.is_network

def download_art1_fire(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    shoot_dl = threading.Thread(target=download_art1, args=[track_object])
    shoot_dl.daemon = True
    shoot_dl.start()


def remove_embed_picture(track_object, dry=True):
    index = track_object.index

    if key_shift_down or key_shiftr_down:
        tracks = [index]
        if track_object.is_cue or track_object.is_network:
            show_message("Error - No handling for this kind of track", mode='warning')
            return
    else:
        tracks = []
        original_parent_folder = track_object.parent_folder_name
        for k in default_playlist:
            tr = pctl.g(k)
            if original_parent_folder == tr.parent_folder_name:
                tracks.append(k)

    removed = 0
    if not dry:
        pr = pctl.stop(True)
    try:
        for item in tracks:

            tr = pctl.g(item)

            if tr.is_cue:
                continue

            if tr.is_network:
                continue

            if dry:
                removed += 1
            else:
                if "MP3" == tr.file_ext:
                    try:
                        tag = mutagen.id3.ID3(tr.fullpath)
                        tag.delall("APIC")
                        remove = True
                        tag.save(padding=no_padding)
                        removed += 1
                    except Exception as e:
                        print("No APIC found")

                if tr.file_ext == "M4A":
                    try:
                        tag = mutagen.mp4.MP4(tr.fullpath)
                        del tag.tags["covr"]
                        tag.save(padding=no_padding)
                        removed += 1
                    except:
                        pass

                if tr.file_ext in ("OGA", "OPUS", "OGG"):
                    show_message("Removing vorbis image not implemented")
                    # try:
                    #     tag = mutagen.File(tr.fullpath).tags
                    #     print(tag)
                    #     removed += 1
                    # except:
                    #     pass

                if "FLAC" == tr.file_ext:
                    try:
                        tag = mutagen.flac.FLAC(tr.fullpath)
                        tag.clear_pictures()
                        tag.save(padding=no_padding)
                        removed += 1
                    except:
                        pass

                clear_track_image_cache(tr)

    except Exception as e:
        show_message("Image remove error", mode='error')
        return

    if dry:
        return removed

    if removed == 0:
        show_message(_("Image removal failed."), mode='error')
        return
    elif removed == 1:
        show_message(_("Deleted embedded picture from file"), mode='done')
    else:
        show_message(_("%d files processed") % removed, mode='done')
    if pr == 1:
        pctl.revert()


del_icon = asset_loader('del.png', True)
delete_icon = MenuIcon(del_icon)


def delete_file_image(track_object):
    try:
        showc = album_art_gen.get_info(track_object)
        if showc is not None and showc[0] == 0:
            source = album_art_gen.get_sources(track_object)[showc[2]][1]
            os.remove(source)
            # clear_img_cache()
            clear_track_image_cache(track_object)
            print("Deleted file: " + source)
    except:
        show_message("Something went wrong", mode='error')


def delete_track_image_deco(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    info = album_art_gen.get_info(track_object)

    text = _("Delete Image File")
    line_colour = colours.menu_text

    if info is None or track_object.is_network:
        return [colours.menu_text_disabled, colours.menu_background, None]

    elif info and info[0] == 0:
        text = _("Delete Image File")

    elif info and info[0] == 1:
        if pctl.playing_state > 0 and track_object.file_ext in ("MP3", "FLAC", "M4A"):
            line_colour = colours.menu_text
        else:
            line_colour = colours.menu_text_disabled

        text = _("Delete Embedded | Folder")
        if key_shift_down or key_shiftr_down:
            text = _("Delete Embedded | Track")

    return [line_colour, colours.menu_background, text]


def delete_track_image(track_object):
    if type(track_object) is int:
        track_object = pctl.master_library[track_object]
    if track_object.is_network:
        return
    info = album_art_gen.get_info(track_object)
    if info and info[0] == 0:
        delete_file_image(track_object)
    elif info and info[0] == 1:
        n = remove_embed_picture(track_object, dry=True)
        gui.message_box_confirm_callback = remove_embed_picture
        gui.message_box_confirm_reference = (track_object, False)
        show_message(_("This will erase any embedded image in %d files. Are you sure?" % n), mode="confirm")



picture_menu.add(MenuItem(_("Delete Image File"), delete_track_image, delete_track_image_deco, pass_ref=True,
                 pass_ref_deco=True, icon=delete_icon))

picture_menu.add(MenuItem(_('Quick-Fetch Cover Art'), download_art1_fire, dl_art_deco, pass_ref=True, pass_ref_deco=True, disable_test=download_art1_fire_disable_test))


def toggle_gimage(mode=0):
    if mode == 1:
        return prefs.show_gimage
    prefs.show_gimage ^= True


def search_image_deco(track_object):
    if track_object.artist and track_object.album:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


def ser_gimage(track_object):
    if track_object.artist and track_object.album:
        line = "https://www.google.com/search?tbm=isch&q=" + urllib.parse.quote(
            track_object.artist + " " + track_object.album)
        webbrowser.open(line, new=2, autoraise=True)


# picture_menu.add(_('Search Google for Images'), ser_gimage, search_image_deco, pass_ref=True, pass_ref_deco=True, show_test=toggle_gimage)

# picture_menu.add(_('Toggle art box'), toggle_side_art, toggle_side_art_deco)

picture_menu.add(MenuItem(_('Search for Lyrics'), get_lyric_wiki, search_lyrics_deco, pass_ref=True, pass_ref_deco=True))
picture_menu.add(MenuItem(_('Toggle Lyrics'), toggle_lyrics, toggle_lyrics_deco, pass_ref=True, pass_ref_deco=True))

gallery_menu.add_to_sub(0, MenuItem(_("Next"), cycle_offset, cycle_image_gal_deco, pass_ref=True, pass_ref_deco=True))
gallery_menu.add_to_sub(0, MenuItem(_("Previous"), cycle_offset_back, cycle_image_gal_deco, pass_ref=True, pass_ref_deco=True))
gallery_menu.add_to_sub(0, MenuItem(_("Open Image"), open_image, open_image_deco, pass_ref=True, pass_ref_deco=True, disable_test=open_image_disable_test))
gallery_menu.add_to_sub(0, MenuItem(_('Extract Image'), save_embed_img, extract_image_deco, pass_ref=True, pass_ref_deco=True, disable_test=save_embed_img_disable_test))
gallery_menu.add_to_sub(0, MenuItem('Delete Image <combined>', delete_track_image, delete_track_image_deco, pass_ref=True,
                 pass_ref_deco=True)) #, icon=delete_icon)
gallery_menu.add_to_sub(0, MenuItem(_('Quick-Fetch Cover Art'), download_art1_fire, dl_art_deco, pass_ref=True, pass_ref_deco=True, disable_test=download_art1_fire_disable_test))

def append_here():
    global cargo
    global default_playlist
    default_playlist += cargo


def paste_deco():
    active = False
    line = None
    if len(cargo) > 0:
        active = True
    elif SDL_HasClipboardText():
        text = copy_from_clipboard()
        if text.startswith("/") or "file://" in text or text.startswith("spotify"):
            active = True
        elif prefs.spot_mode and text.startswith(
                "https://open.spotify.com/album/"):  # or text.startswith("https://open.spotify.com/track/"):
            active = True
            line = _("Paste Spotify Album")

    if active:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, line]


def lightning_move_test(discard):
    return gui.lightning_copy and prefs.show_transfer


# def copy_deco():
#     line = "Copy"
#     if key_shift_down:
#         line = "Copy" #Folder From Library"
#     else:
#         line = "Copy"
#
#
#     return [colours.menu_text, colours.menu_background, line]


# playlist_menu.add('Paste', append_here, paste_deco)

def unique_template(string):
    return "<t>" in string or \
           "<title>" in string or \
           "<n>" in string or \
           "<number>" in string or \
           "<tracknumber>" in string or \
           "<tn>" in string or \
           "<sn>" in string or \
           "<singlenumber>" in string or \
           "<s>" in string or "%t" in string or "%tn" in string


def re_template_word(word, tr):
    if word == "aa" or word == "albumartist":

        if tr.album_artist:
            return tr.album_artist
        else:
            return tr.artist

    if word == "a" or word == "artist":
        return tr.artist

    if word == "t" or word == "title":
        return tr.title

    if word == "n" or word == "number" or word == "tracknumber" or word == "tn":
        if len(str(tr.track_number)) < 2:
            return "0" + str(tr.track_number)
        else:
            return str(tr.track_number)

    if word == "sn" or word == "singlenumber" or word == "singletracknumber" or word == "s":
        return str(tr.track_number)

    if word == "d" or word == "date" or word == "year":
        return str(tr.date)

    if word == "b" or "album" in word:
        return str(tr.album)

    if word == "g" or word == "genre":
        return tr.genre

    if word == "x" or "ext" in word or "file" in word:
        return tr.file_ext.lower()

    if word == "ux" or "upper" in word:
        return tr.file_ext.upper()

    if word == "c" or "composer" in word:
        return tr.composer

    if "comment" in word:
        return tr.comment.replace("\n", "").replace("\r", "")

    return ""


def parse_template2(string, track_object, strict=False):
    temp = ""
    out = ""

    mode = 0

    for c in string:

        if mode == 0:

            if c == "<":
                mode = 1
            else:
                out += c

        else:

            if c == ">":

                test = re_template_word(temp, track_object)
                if strict:
                    assert test
                out += test

                mode = 0
                temp = ""

            else:

                temp += c

    if "<und" in string:
        out = out.replace(" ", "_")

    return parse_template(out, track_object, strict=strict)


def parse_template(string, track_object, up_ext=False, strict=False):
    set = 0
    underscore = False
    output = ""

    while set < len(string):
        if string[set] == "%" and set < len(string) - 1:
            set += 1
            if string[set] == 'n':
                if len(str(track_object.track_number)) < 2:
                    output += "0"
                if strict:
                    assert str(track_object.track_number)
                output += str(track_object.track_number)
            elif string[set] == 'a':
                if up_ext and track_object.album_artist != "":  # Context of renaming a folder
                    output += track_object.album_artist
                else:
                    if strict:
                        assert track_object.artist
                    output += track_object.artist
            elif string[set] == 't':
                if strict:
                    assert track_object.title
                output += track_object.title
            elif string[set] == 'c':
                if strict:
                    assert track_object.composer
                output += track_object.composer
            elif string[set] == 'd':
                if strict:
                    assert track_object.date
                output += track_object.date
            elif string[set] == 'b':
                if strict:
                    assert track_object.album
                output += track_object.album
            elif string[set] == 'x':
                if up_ext:
                    output += track_object.file_ext.upper()
                else:
                    output += "." + track_object.file_ext.lower()
            elif string[set] == 'u':
                underscore = True
        else:
            output += string[set]
        set += 1

    output = output.rstrip(" -").lstrip(" -")

    if underscore:
        output = output.replace(' ', "_")

    # Attempt to ensure the output text is filename safe
    output = filename_safe(output)

    return output


# Create playlist tab menu
tab_menu = Menu(160, show_icons=True)
radio_tab_menu = Menu(160, show_icons=True)


def rename_playlist(index, generator=False):
    gui.rename_playlist_box = True
    rename_playlist_box.edit_generator = False
    rename_playlist_box.playlist_index = index
    rename_playlist_box.x = mouse_position[0]
    rename_playlist_box.y = mouse_position[1]

    if generator:
        rename_playlist_box.y = window_size[1] // 2 - round(200 * gui.scale)
        rename_playlist_box.x = window_size[0] // 2 - round(250 * gui.scale)

    if rename_playlist_box.y > round(350 * gui.scale):
        rename_playlist_box.y = round(350 * gui.scale)

    if rename_playlist_box.y < gui.panelY:
        rename_playlist_box.y = gui.panelY + 10 * gui.scale

    if gui.radio_view:
        rename_text_area.set_text(pctl.radio_playlists[index]["name"])
    else:
        rename_text_area.set_text(pctl.multi_playlist[index][0])
    rename_text_area.highlight_all()
    gui.gen_code_errors = False

    if generator:
        rename_playlist_box.toggle_edit_gen()


def edit_generator_box(index):
    rename_playlist(index, generator=True)


tab_menu.add(MenuItem(_('Rename'), rename_playlist, pass_ref=True, hint="Ctrl+R"))
radio_tab_menu.add(MenuItem(_('Rename'), rename_playlist, pass_ref=True, hint="Ctrl+R"))


def pin_playlist_toggle(pl):
    pctl.multi_playlist[pl][8] ^= True


def pl_pin_deco(pl):
    # if pctl.multi_playlist[pl][8] == True and tab_menu.pos[1] >

    if pctl.multi_playlist[pl][8] == True:
        return [colours.menu_text, colours.menu_background, _("Pin")]
    else:
        return [colours.menu_text, colours.menu_background, _('Unpin')]


tab_menu.add(MenuItem("Pin", pin_playlist_toggle, pl_pin_deco, pass_ref=True, pass_ref_deco=True))


def pl_lock_deco(pl):
    if pctl.multi_playlist[pl][9] == True:
        return [colours.menu_text, colours.menu_background, _("Unlock")]
    else:
        return [colours.menu_text, colours.menu_background, _('Lock')]


def view_pl_is_locked(_):
    return pctl.multi_playlist[pctl.active_playlist_viewing][9]


def pl_is_locked(pl):
    if not pctl.multi_playlist:
        return False
    return pctl.multi_playlist[pl][9]


def lock_playlist_toggle(pl):
    pctl.multi_playlist[pl][9] ^= True


def lock_colour_callback():
    if pctl.multi_playlist[gui.tab_menu_pl][9]:
        if colours.lm:
            return [230, 180, 60, 255]
        return [240, 190, 10, 255]
    else:
        return None


lock_asset = asset_loader('lock.png', True)
lock_icon = MenuIcon(lock_asset)
lock_icon.base_asset_mod = asset_loader('unlock.png', True)
lock_icon.colour = [240, 190, 10, 255]
lock_icon.colour_callback = lock_colour_callback
lock_icon.xoff = 4
lock_icon.yoff = -1

tab_menu.add(MenuItem(_('Lock'), lock_playlist_toggle, pl_lock_deco, pass_ref=True, pass_ref_deco=True, icon=lock_icon,
             show_test=test_shift))


def export_m3u(pl, direc=None, relative=False, show=True):
    if len(pctl.multi_playlist[pl][2]) < 1:
        show_message("There are no tracks in this playlist. Nothing to export")
        return 1

    if not direc:
        direc = os.path.join(user_directory, 'playlists')
        if not os.path.exists(direc):
            os.makedirs(direc)
    target = os.path.join(direc, pctl.multi_playlist[pl][0] + '.m3u')

    f = open(target, 'w', encoding='utf-8')
    f.write("#EXTM3U")
    for number in pctl.multi_playlist[pl][2]:
        track = pctl.master_library[number]
        title = track.artist
        if title:
            title += " - "
        title += track.title

        if not track.is_network:
            f.write("\n#EXTINF:")
            f.write(str(round(track.length)))
            if title:
                f.write(f",{title}")
            path = track.fullpath
            if relative:
                path = os.path.relpath(path, start=direc)
            f.write(f"\n{path}")
    f.close()

    if show:
        line = direc
        line += "/"
        if system == "windows" or msys:
            os.startfile(line)
        elif macos:
            subprocess.Popen(['open', line])
        else:
            subprocess.Popen(['xdg-open', line])
    return target


def export_xspf(pl, direc=None, relative=False, show=True):
    if len(pctl.multi_playlist[pl][2]) < 1:
        show_message("There are no tracks in this playlist. Nothing to export")
        return 1

    if not direc:
        direc = os.path.join(user_directory, 'playlists')
        if not os.path.exists(direc):
            os.makedirs(direc)

    target = os.path.join(direc, pctl.multi_playlist[pl][0] + '.xspf')

    xport = open(target, 'w', encoding='utf-8')
    xport.write('<?xml version="1.0" encoding="UTF-8"?>\n')
    xport.write('<playlist version="1" xmlns="http://xspf.org/ns/0/">\n')
    xport.write('  <trackList>\n')

    for number in pctl.multi_playlist[pl][2]:
        track = pctl.master_library[number]
        path = track.fullpath
        if relative:
            path = os.path.relpath(path, start=direc)

        xport.write('    <track>\n')
        if track.title != "":
            xport.write('      <title>' + escape(track.title) + '</title>\n')
        if track.is_cue is False and track.fullpath != "":
            xport.write('      <location>' + escape(path) + '</location>\n')
        if track.artist != "":
            xport.write('      <creator>' + escape(track.artist) + '</creator>\n')
        if track.album != "":
            xport.write('      <album>' + escape(track.album) + '</album>\n')
        xport.write('      <duration>' + str(int(track.length * 1000)) + '</duration>\n')
        xport.write('    </track>\n')
    xport.write('  </trackList>\n')
    xport.write('</playlist>\n\n')
    xport.close()

    if show:
        line = direc
        line += "/"
        if system == "windows" or msys:
            os.startfile(line)
        elif macos:
            subprocess.Popen(['open', line])
        else:
            subprocess.Popen(['xdg-open', line])

    return target


def reload():
    if album_mode:
        reload_albums(quiet=True)

    # tree_view_box.clear_all()
    # elif gui.combo_mode:
    #     reload_albums(quiet=True)
    #     combo_pl_render.prep()


def clear_playlist(index):
    global default_playlist

    if pl_is_locked(index):
        show_message("Playlist is locked to prevent accidental erasure")
        return

    pctl.multi_playlist[index][7].clear()  # clear import folder list

    if not pctl.multi_playlist[index][2]:
        print("Playlist is already empty")
        return

    li = []
    for i, ref in enumerate(pctl.multi_playlist[index][2]):
        li.append((i, ref))

    undo.bk_tracks(index, list(reversed(li)))

    del pctl.multi_playlist[index][2][:]
    if pctl.active_playlist_viewing == index:
        default_playlist = pctl.multi_playlist[index][2]
        reload()

    # pctl.playlist_playing = 0
    pctl.multi_playlist[index][3] = 0
    if index == pctl.active_playlist_viewing:
        pctl.playlist_view_position = 0

    gui.pl_update = 1


def convert_playlist(pl, get_list=False):
    global transcode_list

    if not tauon.test_ffmpeg():
        return

    paths = []
    folders = []

    for track in pctl.multi_playlist[pl][2]:
        if pctl.master_library[track].parent_folder_path not in paths:
            paths.append(pctl.master_library[track].parent_folder_path)

    for path in paths:
        folder = []
        for track in pctl.multi_playlist[pl][2]:
            if pctl.master_library[track].parent_folder_path == path:
                folder.append(track)
                if prefs.transcode_codec == 'flac' and pctl.master_library[track].file_ext.lower() in ('mp3', 'opus',
                                                                                                       'm4a', 'mp4',
                                                                                                       'ogg', 'aac'):
                    show_message("This includes the conversion of a lossy codec to a lossless one!")

        folders.append(folder)

    if get_list:
        return folders

    transcode_list.extend(folders)


def get_folder_tracks_local(pl_in):
    selection = []
    parent = os.path.normpath(pctl.master_library[default_playlist[pl_in]].parent_folder_path)
    while pl_in < len(default_playlist) and parent == os.path.normpath(
            pctl.master_library[default_playlist[pl_in]].parent_folder_path):
        selection.append(pl_in)
        pl_in += 1
    return selection


def test_pl_tab_locked(pl):
    if gui.radio_view:
        return False
    return pctl.multi_playlist[pl][9]


# Clear playlist
tab_menu.add(MenuItem(_('Clear'), clear_playlist, pass_ref=True, disable_test=test_pl_tab_locked, pass_ref_deco=True))


def move_radio_playlist(source, dest):
    if dest > source:
        dest += 1
    try:
        temp = pctl.radio_playlists[source]
        pctl.radio_playlists[source] = "old"
        pctl.radio_playlists.insert(dest, temp)
        pctl.radio_playlists.remove("old")
        pctl.radio_playlist_viewing = pctl.radio_playlists.index(temp)
    except:
        print("Warning: Playlist move error")


def move_playlist(source, dest):
    global default_playlist
    if dest > source:
        dest += 1
    try:
        active = pctl.multi_playlist[pctl.active_playlist_playing]
        view = pctl.multi_playlist[pctl.active_playlist_viewing]

        temp = pctl.multi_playlist[source]
        pctl.multi_playlist[source] = "old"
        pctl.multi_playlist.insert(dest, temp)
        pctl.multi_playlist.remove("old")

        pctl.active_playlist_playing = pctl.multi_playlist.index(active)
        pctl.active_playlist_viewing = pctl.multi_playlist.index(view)
        default_playlist = default_playlist = pctl.multi_playlist[pctl.active_playlist_viewing][2]
    except:
        print("Warning: Playlist move error")


def delete_playlist(index, force=False, check_lock=False):
    if gui.radio_view:
        del pctl.radio_playlists[index]
        if not pctl.radio_playlists:
            pctl.radio_playlists = [{"uid": uid_gen(), "name": "Default", "items": []}]
        return

    global default_playlist

    if check_lock and pl_is_locked(index):
        show_message("Playlist is locked to prevent accidental deletion")
        return

    if not force:
        if pl_is_locked(index):
            show_message("Playlist is locked to prevent accidental deletion")
            return

        gen = pctl.gen_codes.get(pl_to_id(index), "")
        if (gen == "" or gen.startswith("self ")) and pctl.multi_playlist[index][2]:
            if not (key_shift_down or key_shiftr_down):
                show_message(_("Are you sure you want to delete this playlist?"),
                             _("Try again while holding shift to confirm"))
                return

    if gui.rename_playlist_box:
        return

    # Set screen to be redrawn
    gui.pl_update = 1
    gui.update += 1

    # Backup the playlist to be deleted
    # pctl.playlist_backup.append(pctl.multi_playlist[index])
    # pctl.playlist_backup.append(pctl.multi_playlist[index])
    undo.bk_playlist(index)

    # If we're deleting the final playlist, delete it and create a blank one in place
    if len(pctl.multi_playlist) == 1:
        pctl.multi_playlist.clear()
        pctl.multi_playlist.append(pl_gen())
        default_playlist = pctl.multi_playlist[0][2]
        pctl.active_playlist_playing = 0
        return

    # Take note of the id of the playing playlist
    old_playing_id = pctl.multi_playlist[pctl.active_playlist_playing][6]

    # Take note of the id of the viewed open playlist
    old_view_id = pctl.multi_playlist[pctl.active_playlist_viewing][6]

    # Delete the requested playlist
    del pctl.multi_playlist[index]

    # Re-set the open viewed playlist number by uid
    for i, pl in enumerate(pctl.multi_playlist):

        if pl[6] == old_view_id:
            pctl.active_playlist_viewing = i
            break
    else:
        # print("Lost the viewed playlist!")
        # Try find the playing playlist and make it the viewed playlist
        for i, pl in enumerate(pctl.multi_playlist):
            if pl[6] == old_playing_id:
                pctl.active_playlist_viewing = i
                break
        else:
            # Playing playlist was deleted, lets just move down one playlist
            if pctl.active_playlist_viewing > 0:
                pctl.active_playlist_viewing -= 1

    # Re-initiate the now viewed playlist
    if old_view_id != pctl.multi_playlist[pctl.active_playlist_viewing][6]:
        default_playlist = pctl.multi_playlist[pctl.active_playlist_viewing][2]
        pctl.playlist_view_position = pctl.multi_playlist[pctl.active_playlist_viewing][3]
        console.print("DEBUG: Position reset by playlist delete")
        pctl.selected_in_playlist = pctl.multi_playlist[pctl.active_playlist_viewing][5]
        shift_selection = [pctl.selected_in_playlist]

        if album_mode:
            reload_albums(True)
            goto_album(pctl.playlist_view_position)

    # Re-set the playing playlist number by uid
    for i, pl in enumerate(pctl.multi_playlist):

        if pl[6] == old_playing_id:
            pctl.active_playlist_playing = i
            break
    else:
        print("Lost the playing playlist!")
        pctl.active_playlist_playing = pctl.active_playlist_viewing
        pctl.playlist_playing_position = -1

    test_show_add_home_music()

    # Cleanup
    ids = []
    for p in pctl.multi_playlist:
        ids.append(p[6])

    for key in list(gui.gallery_positions.keys()):
        if key not in ids:
            del gui.gallery_positions[key]
    for key in list(pctl.gen_codes.keys()):
        if key not in ids:
            del pctl.gen_codes[key]

    pctl.db_inc += 1


to_scan = []


def delete_playlist_force(index):
    delete_playlist(index, force=True, check_lock=True)


def delete_playlist_by_id(id, force=False, check_lock=False):
    delete_playlist(id_to_pl(id), force=force, check_lock=check_lock)


def delete_playlist_ask(index):
    if gui.radio_view:
        delete_playlist_force(index)
        return
    gen = pctl.gen_codes.get(pl_to_id(index), "")
    if (gen and not gen.startswith("self ")) or len(pctl.multi_playlist[index][2]) < 2:
        delete_playlist(index)
        return

    gui.message_box_confirm_callback = delete_playlist_by_id
    gui.message_box_confirm_reference = (pl_to_id(index), True, True)
    show_message(_("Are you sure you want to delete playlist: %s?") % pctl.multi_playlist[index][0], mode="confirm")


def rescan_tags(pl):
    for track in pctl.multi_playlist[pl][2]:
        if pctl.master_library[track].is_cue is False:
            to_scan.append(track)
    tm.ready("worker")


# def re_import(pl):
#
#     path = pctl.multi_playlist[pl][7]
#     if path == "":
#         return
#     for i in reversed(range(len(pctl.multi_playlist[pl][2]))):
#         if path.replace('\\', '/') in pctl.master_library[pctl.multi_playlist[pl][2][i]].parent_folder_path:
#             del pctl.multi_playlist[pl][2][i]
#
#     load_order = LoadClass()
#     load_order.replace_stem = True
#     load_order.target = path
#     load_order.playlist = pctl.multi_playlist[pl][6]
#     load_orders.append(copy.deepcopy(load_order))


def re_import2(pl):
    paths = pctl.multi_playlist[pl][7]

    reduce_paths(paths)

    for path in paths:
        if os.path.isdir(path):
            load_order = LoadClass()
            load_order.replace_stem = True
            load_order.target = path
            load_order.notify = True
            load_order.playlist = pctl.multi_playlist[pl][6]
            load_orders.append(copy.deepcopy(load_order))

    if paths:
        show_message(_("Rescanning folders..."), mode='info')


def rescan_all_folders():
    for i, p in enumerate(pctl.multi_playlist):
        re_import2(i)

def s_append(index):
    paste(playlist_no=index)


def append_playlist(index):
    global cargo
    pctl.multi_playlist[index][2] += cargo

    gui.pl_update = 1
    reload()


def tryint(s):
    try:
        return int(s)
    except:
        return s


def index_key(index):
    tr = pctl.master_library[index]
    s = str(tr.track_number)
    d = str(tr.disc_number)

    if "/" in d:
        d = d.split("/")[0]

    # Make sure the value for disc number is an int, make 1 if 0, otherwise ignore
    if d:
        try:
            dd = int(d)
            if dd < 2:
                dd = 1
            d = str(dd)
        except:
            d = ""


    # Add the disc number for sorting by CD, make it '1' if theres isnt one
    if s or d:
        if not d:
            s = "1" + "d" + s
        else:
            s = d + "d" + s

    # Use the filename if we dont have any metadata to sort by,
    # since it could likely have the track number in it
    else:
        s = tr.filename

    if (not tr.disc_number or tr.disc_number == "0") and tr.is_cue:
        s = tr.filename + "-" + s

    # This splits the line by groups of numbers, causing the sorting algorithum to sort
    # by those numbers. Should work for filenames, even with the disc number in the name.
    try:
        return [tryint(c) for c in re.split('([0-9]+)', s)]
    except:
        return "a"


def sort_tracK_numbers_album_only(pl, custom_list=None):
    current_folder = ""
    albums = []
    if custom_list is None:
        playlist = pctl.multi_playlist[pl][2]
    else:
        playlist = custom_list

    for i in range(len(playlist)):
        if i == 0:
            albums.append(i)
            current_folder = pctl.master_library[playlist[i]].album
        else:
            if pctl.master_library[playlist[i]].album != current_folder:
                current_folder = pctl.master_library[playlist[i]].album
                albums.append(i)

    i = 0
    while i < len(albums) - 1:
        playlist[albums[i]:albums[i + 1]] = sorted(playlist[albums[i]:albums[i + 1]], key=index_key)
        i += 1
    if len(albums) > 0:
        playlist[albums[i]:] = sorted(playlist[albums[i]:], key=index_key)

    gui.pl_update += 1


def sort_track_2(pl, custom_list=None):
    current_folder = ""
    current_album = ""
    current_date = ""
    albums = []
    if custom_list is None:
        playlist = pctl.multi_playlist[pl][2]
    else:
        playlist = custom_list

    for i in range(len(playlist)):
        tr = pctl.master_library[playlist[i]]
        if i == 0:
            albums.append(i)
            current_folder = tr.parent_folder_path
            current_album = tr.album
            current_date = tr.date
        else:
            if tr.parent_folder_path != current_folder:
                if tr.album == current_album and tr.album and tr.date == current_date and tr.disc_number:
                    continue
                else:
                    current_folder = tr.parent_folder_path
                    current_album = tr.album
                    current_date = tr.date
                    albums.append(i)

    i = 0
    while i < len(albums) - 1:
        playlist[albums[i]:albums[i + 1]] = sorted(playlist[albums[i]:albums[i + 1]], key=index_key)
        i += 1
    if len(albums) > 0:
        playlist[albums[i]:] = sorted(playlist[albums[i]:], key=index_key)

    gui.pl_update += 1


tauon.sort_track_2 = sort_track_2


def key_filepath(index):
    track = pctl.master_library[index]
    return track.parent_folder_path.lower(), track.filename


def key_fullpath(index):
    return pctl.master_library[index].fullpath


def key_filename(index):
    track = pctl.master_library[index]
    return track.filename


def sort_path_pl(pl, custom_list=None):
    if custom_list is not None:
        target = custom_list
    else:
        target = pctl.multi_playlist[pl][2]

    if use_natsort and False:
        target[:] = natsort.os_sorted(target, key=key_fullpath)
    else:
        target.sort(key=key_filepath)


def append_current_playing(index):
    if spot_ctl.coasting:
        spot_ctl.append_playing(index)
        gui.pl_update = 1
        return

    if pctl.playing_state > 0 and len(pctl.track_queue) > 0:
        pctl.multi_playlist[index][2].append(pctl.track_queue[pctl.queue_step])
        gui.pl_update = 1


def export_stats(pl):
    playlist_time = 0
    play_time = 0
    total_size = 0
    tracks_in_playlist = len(pctl.multi_playlist[pl][2])

    seen_files = {}
    seen_types = {}

    mp3_bitrates = {}
    ogg_bitrates = {}
    m4a_bitrates = {}

    are_cue = 0

    for index in pctl.multi_playlist[pl][2]:
        track = pctl.g(index)

        playlist_time += int(track.length)
        play_time += star_store.get(index)

        if track.is_cue:
            are_cue += 1

        if track.file_ext == "MP3":
            mp3_bitrates[track.bitrate] = mp3_bitrates.get(track.bitrate, 0) + 1
        if track.file_ext == "OGG" or track.file_ext == "OGA":
            ogg_bitrates[track.bitrate] = ogg_bitrates.get(track.bitrate, 0) + 1
        if track.file_ext == "M4A":
            m4a_bitrates[track.bitrate] = m4a_bitrates.get(track.bitrate, 0) + 1

        type = track.file_ext
        if type == "OGA":
            type = "OGG"
        seen_types[type] = seen_types.get(type, 0) + 1

        if track.fullpath and not track.is_network:
            if track.fullpath not in seen_files:
                size = track.size
                if not size and os.path.isfile(track.fullpath):
                    size = os.path.getsize(track.fullpath)
                seen_files[track.fullpath] = size

    total_size = sum(seen_files.values())

    stats_gen.update(pl)
    line = 'Playlist:\n' + pctl.multi_playlist[pl][0] + "\n\n"
    line += 'Generated:\n' + time.strftime("%c") + "\n\n"
    line += 'Tracks in playlist:\n' + str(tracks_in_playlist)
    line += "\n\n"
    line += "Repeats in playlist:\n"
    unique = len(set(pctl.multi_playlist[pl][2]))
    line += str(tracks_in_playlist - unique)
    line += "\n\n"
    line += 'Total local size:\n' + get_filesize_string(total_size) + "\n\n"
    line += 'Playlist duration:\n' + str(datetime.timedelta(seconds=int(playlist_time))) + "\n\n"
    line += 'Total playtime:\n' + str(datetime.timedelta(seconds=int(play_time))) + "\n\n"

    line += "Track types:\n"
    if tracks_in_playlist:
        types = sorted(seen_types, key=seen_types.get, reverse=True)
        for type in types:
            perc = round((seen_types.get(type) / tracks_in_playlist) * 100, 1)
            if perc < 0.1:
                perc = "<0.1"
            if type == "SPOT":
                type = "SPOTIFY"
            if type == "SUB":
                type = "AIRSONIC"
            line += f"{type} ({perc}%); "
    line = line.rstrip("; ")
    line += "\n\n"

    if tracks_in_playlist:
        line += "Percent of tracks are CUE type:\n"
        perc = are_cue / tracks_in_playlist
        if perc == 0:
            perc = 0
        if 0 < perc < 0.01:
            perc = "<0.01"
        else:
            perc = round(perc, 2)

        line += str(perc) + "%"
        line += "\n\n"

    if tracks_in_playlist and mp3_bitrates:
        line += "MP3 bitrates (kbps):\n"
        rates = sorted(mp3_bitrates, key=mp3_bitrates.get, reverse=True)
        others = 0
        for rate in rates:
            perc = round((mp3_bitrates.get(rate) / sum(mp3_bitrates.values())) * 100, 1)
            if perc < 1:
                others += perc
            else:
                line += f"{rate} ({perc}%); "

        if others:
            others = round(others, 1)
            if others < 0.1:
                others = "<0.1"
            line += f"Others ({others}%);"
        line = line.rstrip("; ")
        line += "\n\n"

    if tracks_in_playlist and ogg_bitrates:
        line += "OGG bitrates (kbps):\n"
        rates = sorted(ogg_bitrates, key=ogg_bitrates.get, reverse=True)
        others = 0
        for rate in rates:
            perc = round((ogg_bitrates.get(rate) / sum(ogg_bitrates.values())) * 100, 1)
            if perc < 1:
                others += perc
            else:
                line += f"{rate} ({perc}%); "

        if others:
            others = round(others, 1)
            if others < 0.1:
                others = "<0.1"
            line += f"Others ({others}%);"
        line = line.rstrip("; ")
        line += "\n\n"

    # if tracks_in_playlist and m4a_bitrates:
    #     line += "M4A bitrates (kbps):\n"
    #     rates = sorted(m4a_bitrates, key=m4a_bitrates.get, reverse=True)
    #     others = 0
    #     for rate in rates:
    #         perc = round((m4a_bitrates.get(rate) / sum(m4a_bitrates.values())) * 100, 1)
    #         if perc < 1:
    #             others += perc
    #         else:
    #             line += f"{rate} ({perc}%); "
    #
    #     if others:
    #         others = round(others, 1)
    #         if others < 0.1:
    #             others = "<0.1"
    #         line += f"Others ({others}%);"
    #
    #     line = line.rstrip("; ")
    #     line += "\n\n"

    line += "\n-------------- Top Artists --------------------\n\n"

    ls = stats_gen.artist_list
    for i, item in enumerate(ls[:50]):
        line += str(i + 1) + ".\t" + stt2(item[1]) + "\t" + item[0] + "\n"

    line += "\n\n-------------- Top Albums --------------------\n\n"
    ls = stats_gen.album_list
    for i, item in enumerate(ls[:50]):
        line += str(i + 1) + ".\t" + stt2(item[1]) + "\t" + item[0] + "\n"
    line += "\n\n-------------- Top Genres --------------------\n\n"
    ls = stats_gen.genre_list
    for i, item in enumerate(ls[:50]):
        line += str(i + 1) + ".\t" + stt2(item[1]) + "\t" + item[0] + "\n"

    line = line.encode('utf-8')
    xport = open(user_directory + '/stats.txt', 'wb')
    xport.write(line)
    xport.close()
    target = os.path.join(user_directory, "stats.txt")
    if system == "windows" or msys:
        os.startfile(target)
    elif macos:
        subprocess.call(['open', target])
    else:
        subprocess.call(["xdg-open", target])


def imported_sort(pl):
    if pl_is_locked(pl):
        show_message(_("Playlist is locked"))
        return

    og = pctl.multi_playlist[pl][2]
    og.sort(key=lambda x: pctl.g(x).index)

    reload_albums()
    tree_view_box.clear_target_pl(pl)

def imported_sort_folders(pl):
    if pl_is_locked(pl):
        show_message(_("Playlist is locked"))
        return

    og = pctl.multi_playlist[pl][2]
    og.sort(key=lambda x: pctl.g(x).index)

    first_occurrences = {}
    for i, x in enumerate(og):
        b = pctl.g(x).parent_folder_path
        if b not in first_occurrences:
            first_occurrences[b] = i

    og.sort(key=lambda x: first_occurrences[pctl.g(x).parent_folder_path])

    reload_albums()
    tree_view_box.clear_target_pl(pl)

def standard_sort(pl):
    if pl_is_locked(pl):
        show_message(_("Playlist is locked"))
        return

    sort_path_pl(pl)
    sort_track_2(pl)
    reload_albums()
    tree_view_box.clear_target_pl(pl)


def year_s(plt):
    sorted_temp = sorted(plt, key=lambda x: x[1])
    temp = []

    for album in sorted_temp:
        temp += album[0]
    return temp


def year_sort(pl, custom_list=None):
    if custom_list:
        playlist = custom_list
    else:
        playlist = pctl.multi_playlist[pl][2]
    plt = []
    pl2 = []
    artist = ""
    album_artist = ""

    p = 0
    while p < len(playlist):

        track = get_object(playlist[p])

        if track.artist != artist:
            if album_artist and track.album_artist and album_artist == track.album_artist:
                pass
            elif len(artist) > 5 and artist.lower() in track.parent_folder_name.lower():
                pass
            else:
                artist = track.artist
                pl2 += year_s(plt)
                plt = []

        if track.album_artist:
            album_artist = track.album_artist

        if p > len(playlist) - 1:
            break

        album = []
        on = get_object(playlist[p]).parent_folder_path
        album.append(playlist[p])
        t = 1

        while t + p < len(playlist) - 1 and get_object(playlist[p + t]).parent_folder_path == on:
            album.append(playlist[p + t])
            t += 1

        date = get_object(playlist[p]).date

        # If date is xx-xx-yyyy format, just grab the year from the end
        # so that the M and D don't interfere with the sorter
        if len(date) > 4 and date[-4:].isnumeric():
            date = date[-4:]

        # If we don't have a date, see if we can grab one from the folder name
        # following the format: (XXXX)
        if date == "":
            pfn = get_object(playlist[p]).parent_folder_name
            if len(pfn) > 6 and pfn[-1] == ")" and pfn[-6] == "(":
                date = pfn[-5:-1]

        plt.append((album, date, artist + " " + get_object(playlist[p]).album))
        p += len(album)
        # print(album)

    if plt:
        pl2 += year_s(plt)
        plt = []

    if custom_list is not None:
        return pl2

    # We can't just assign the playlist because it may disconnect the 'pointer' default_playlist
    pctl.multi_playlist[pl][2][:] = pl2[:]
    reload_albums()
    tree_view_box.clear_target_pl(pl)


def pl_toggle_playlist_break(ref):
    pctl.multi_playlist[ref][4] ^= 1
    gui.pl_update = 1


delete_icon.xoff = 3
delete_icon.colour = [249, 70, 70, 255]

tab_menu.add(MenuItem(_('Delete'), delete_playlist_force, pass_ref=True, hint="Ctrl+W", icon=delete_icon,
             disable_test=test_pl_tab_locked, pass_ref_deco=True))
radio_tab_menu.add(MenuItem(_('Delete'), delete_playlist_force, pass_ref=True, hint="Ctrl+W", icon=delete_icon,
                   disable_test=test_pl_tab_locked, pass_ref_deco=True))


def gen_unique_pl_title(base, extra="", start=1):
    ex = start
    title = base
    while ex < 100:
        for playlist in pctl.multi_playlist:
            if playlist[0] == title:
                ex += 1
                if ex == 1:
                    title = base + " (" + extra.rstrip(" ") + ")"
                else:
                    title = base + " (" + extra + str(ex) + ")"
                break
        else:
            break

    return title


def new_playlist(switch=True):
    if gui.radio_view:
        r = {}
        r["uid"] = uid_gen()
        r["name"] = "New Radio List"
        r["items"] = []  # copy.copy(prefs.radio_urls)
        r["scroll"] = 0
        pctl.radio_playlists.append(r)
        return

    title = gen_unique_pl_title("New Playlist")

    top_panel.prime_side = 1
    top_panel.prime_tab = len(pctl.multi_playlist)

    pctl.multi_playlist.append(pl_gen(title=title))  # [title, 0, [], 0, 0, 0])
    if switch:
        switch_playlist(len(pctl.multi_playlist) - 1)
    return len(pctl.multi_playlist) - 1


heartx_icon = MenuIcon(asset_loader('heart-menu.png', True))
spot_heartx_icon = MenuIcon(asset_loader('heart-menu.png', True))
transcode_icon = MenuIcon(asset_loader('transcode.png', True))
mod_folder_icon = MenuIcon(asset_loader('mod_folder.png', True))
settings_icon = MenuIcon(asset_loader('settings2.png', True))
rename_tracks_icon = MenuIcon(asset_loader('pen.png', True))
add_icon = MenuIcon(asset_loader('new.png', True))
spot_asset = asset_loader('spot.png', True)
spot_icon = MenuIcon(spot_asset)
spot_icon.colour = [30, 215, 96, 255]
spot_icon.xoff = 5
spot_icon.yoff = 2

jell_icon = MenuIcon(spot_asset)
jell_icon.colour = [190, 100, 210, 255]
jell_icon.xoff = 5
jell_icon.yoff = 2

tab_menu.br()


def append_deco():
    if pctl.playing_state > 0:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    text = None
    if spot_ctl.coasting:
        text = _("Add Spotify Album")

    return [line_colour, colours.menu_background, text]


def rescan_deco(pl):
    if pctl.multi_playlist[pl][7]:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    # base = os.path.basename(pctl.multi_playlist[pl][7])

    return [line_colour, colours.menu_background, None]


def regenerate_deco(pl):
    id = pl_to_id(pl)
    value = pctl.gen_codes.get(id)

    if value:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


column_names = (
    "Artist",
    "Album Artist",
    "Album",
    "Title",
    "Composer",
    "Time",
    "Date",
    "Genre",
    "#",
    "P",
    "Starline",
    "Rating",
    "Comment",
    "Codec",
    "Lyrics",
    "Bitrate",
    "S",
    "Filename",
    "Disc",
    "CUE"
)


def parse_generator(string):
    cmds = []
    quotes = []
    current = ""
    q_string = ""
    inquote = False
    for cha in string:
        if not inquote and cha == " ":
            if current:
                cmds.append(current)
                quotes.append(q_string)
            q_string = ""
            current = ""
            continue
        elif cha == "\"":
            inquote ^= True

        current += cha

        if inquote and cha != "\"":
            q_string += cha

    if current:
        cmds.append(current)
        quotes.append(q_string)

    return cmds, quotes, inquote


def upload_spotify_playlist(pl):
    p_id = pl_to_id(pl)
    string = pctl.gen_codes.get(p_id)
    id = None
    if string:
        cmds, quotes, inquote = parse_generator(string)
        for i, cm in enumerate(cmds):
            if cm.startswith("spl\""):
                id = quotes[i]
                break

    urls = []
    playlist = pctl.multi_playlist[pl][2]

    warn = False
    for track_id in playlist:
        tr = pctl.g(track_id)
        url = tr.misc.get("spotify-track-url")
        if not url:
            warn = True
            continue
        urls.append(url)

    if warn:
        show_message(_("Playlist contains non-Spotify tracks"), mode="error")
        return

    new = False
    if id is None:
        name = pctl.multi_playlist[pl][0].split(" by ")[0]
        show_message(_("Created new Spotify playlist"), name, mode="done")
        id = spot_ctl.create_playlist(name)
        if id:
            new = True
            pctl.gen_codes[p_id] = "spl\"" + id + "\""
    if id is None:
        show_message(_("Error creating Spotify playlist"))
        return
    if not new:
        show_message(_("Updated Spotify playlist"), mode="done")
    spot_ctl.upload_playlist(id, urls)


def regenerate_playlist(pl=-1, silent=False, id=None):
    if id is None and pl == -1:
        return

    if id is None:
        id = pl_to_id(pl)

    if pl == -1:
        pl = id_to_pl(id)
        if pl is None:
            return

    source_playlist = pctl.multi_playlist[pl][2]

    string = pctl.gen_codes.get(id)
    if not string:
        if not silent:
            show_message("This playlist has no generator")
        return

    cmds, quotes, inquote = parse_generator(string)

    if inquote:
        gui.gen_code_errors = "close"
        return

    playlist = []
    selections = []
    errors = False
    selections_searched = 0

    def is_source_type(code):
        return code is None or \
            code == "" or \
            code.startswith("self") or \
            code.startswith("jelly") or \
            code.startswith("plex") or \
            code.startswith("koel") or \
            code.startswith("tau") or \
            code.startswith("air") or \
            code.startswith("sal")

    #
    # print(cmds)
    # print(quotes)

    pctl.regen_in_progress = True

    for i, cm in enumerate(cmds):

        quote = quotes[i]

        if cm.startswith("\"") and (cm.endswith(">") or cm.endswith("<")):
            cm_found = False

            for col in column_names:

                if quote.lower() == col.lower() or _(quote).lower() == col.lower():
                    cm_found = True

                    if cm[-1] == ">":
                        sort_ass(0, invert=False, custom_list=playlist, custom_name=col)
                    elif cm[-1] == "<":
                        sort_ass(0, invert=True, custom_list=playlist, custom_name=col)
                    break
            if cm_found:
                continue

        elif cm == "self":
            selections.append(pctl.multi_playlist[pl][2])

        elif cm == "auto":
            pass

        elif cm.startswith("spl\""):
            playlist.extend(spot_ctl.playlist(quote, return_list=True))

        elif cm == "sal":
            playlist.extend(spot_ctl.get_library_albums(return_list=True))

        elif cm == "slt":
            playlist.extend(spot_ctl.get_library_likes(return_list=True))

        elif cm == "plex":
            if not plex.scanning:
                playlist.extend(plex.get_albums(return_list=True))

        elif cm.startswith("jelly\""):
            if not jellyfin.scanning:
                playlist.extend(jellyfin.get_playlist(quote, return_list=True))

        elif cm == "jelly":
            if not jellyfin.scanning:
                playlist.extend(jellyfin.ingest_library(return_list=True))

        elif cm == "koel":
            if not koel.scanning:
                playlist.extend(koel.get_albums(return_list=True))

        elif cm == "tau":
            if not tau.processing:
                playlist.extend(tau.get_playlist(pctl.multi_playlist[pl][0], return_list=True))

        elif cm == "air":
            if not subsonic.scanning:
                playlist.extend(subsonic.get_music3(return_list=True))

        elif cm == "a":
            if not selections and not selections_searched:
                for plist in pctl.multi_playlist:
                    code = pctl.gen_codes.get(plist[6])
                    if is_source_type(code):
                        selections.append(plist[2])

            temp = []
            for selection in selections:
                temp += selection

            playlist += list(OrderedDict.fromkeys(temp))
            selections.clear()

        elif cm == "cue":

            for i in reversed(range(len(playlist))):
                tr = pctl.g(playlist[i])
                if not tr.is_cue:
                    del playlist[i]
            playlist = list(OrderedDict.fromkeys(playlist))

        elif cm == "today":
            d = datetime.date.today()
            for i in reversed(range(len(playlist))):
                tr = pctl.g(playlist[i])
                if not tr.date[5:7] == f"{d:%m}" or not tr.date[8:10] == f"{d:%d}":
                    del playlist[i]
            playlist = list(OrderedDict.fromkeys(playlist))

        elif cm.startswith("com\""):
            for i in reversed(range(len(playlist))):
                tr = pctl.g(playlist[i])
                if quote not in tr.comment:
                    del playlist[i]
            playlist = list(OrderedDict.fromkeys(playlist))

        elif cm.startswith("ext"):
            value = quote.upper()
            if value:
                if not selections:
                    for plist in pctl.multi_playlist:
                        selections.append(plist[2])

                temp = []
                for selection in selections:
                    for track in selection:
                        tr = pctl.g(track)
                        if tr.file_ext == value:
                            temp.append(track)

                playlist += list(OrderedDict.fromkeys(temp))

        elif cm == "ypa":
            playlist = year_sort(0, playlist)

        elif cm == "tn":
            sort_track_2(0, playlist)

        elif cm == "ia>":
            playlist = gen_last_imported_folders(0, playlist)

        elif cm == "ia<":
            playlist = gen_last_imported_folders(0, playlist, reverse=True)

        elif cm == "m>":
            playlist = gen_last_modified(0, playlist)

        elif cm == "m<":
            playlist = gen_last_modified(0, playlist, reverse=False)

        elif cm == "ly" or cm == "lyrics":
            playlist = gen_lyrics(0, playlist)

        elif cm == "l" or cm == "love" or cm == "loved":
            playlist = gen_love(0, playlist)

        elif cm == "clr":
            selections.clear()

        elif cm == "rv" or cm == "reverse":
            playlist = gen_reverse(0, playlist)

        elif cm == "rva":
            playlist = gen_folder_reverse(0, playlist)

        elif cm == "rata>":

            playlist = gen_folder_top_rating(0, custom_list=playlist)

        elif cm == "rat>":

            def rat_key(track_id):
                return star_store.get_rating(track_id)

            playlist = sorted(playlist, key=rat_key, reverse=True)

        elif cm == "rat<":

            def rat_key(track_id):
                return star_store.get_rating(track_id)

            playlist = sorted(playlist, key=rat_key)

        elif cm[:4] == "rat=":
            value = cm[4:]
            try:
                value = float(value) * 2
                temp = []
                for item in playlist:
                    if value == star_store.get_rating(item):
                        temp.append(item)
                playlist = temp
            except:
                errors = True
                pass
                # raise

        elif cm[:4] == "rat<":
            value = cm[4:]
            try:
                value = float(value) * 2
                temp = []
                for item in playlist:
                    if value > star_store.get_rating(item):
                        temp.append(item)
                playlist = temp
            except:
                errors = True
                pass

        elif cm[:4] == "rat>":
            value = cm[4:]
            try:
                value = float(value) * 2
                temp = []
                for item in playlist:
                    if value < star_store.get_rating(item):
                        temp.append(item)
                playlist = temp
            except:
                errors = True
                pass

        elif cm == "rat":
            temp = []
            for item in playlist:
                # tr = pctl.g(item)
                if star_store.get_rating(item) > 0:
                    temp.append(item)
            playlist = temp

        elif cm == "norat":
            temp = []
            for item in playlist:
                if star_store.get_rating(item) == 0:
                    temp.append(item)
            playlist = temp

        elif cm == "d>":
            playlist = gen_sort_len(0, custom_list=playlist)

        elif cm == "d<":
            playlist = gen_sort_len(0, custom_list=playlist)
            playlist = list(reversed(playlist))

        elif cm[:2] == "d<":
            value = cm[2:]
            if value and value.isdigit():
                value = int(value)
                for i in reversed(range(len(playlist))):
                    tr = pctl.g(playlist[i])
                    if not value > tr.length:
                        del playlist[i]

        elif cm[:2] == "d>":
            value = cm[2:]
            if value and value.isdigit():
                value = int(value)
                for i in reversed(range(len(playlist))):
                    tr = pctl.g(playlist[i])
                    if not value < tr.length:
                        del playlist[i]

        elif cm == "path":
            sort_path_pl(0, custom_list=playlist)

        elif cm == "pa>":
            playlist = gen_folder_top(0, custom_list=playlist)

        elif cm == "pa<":
            playlist = gen_folder_top(0, custom_list=playlist)
            playlist = gen_folder_reverse(0, playlist)

        elif cm == "pt>" or cm == "pc>":
            playlist = gen_top_100(0, custom_list=playlist)

        elif cm == "pt<" or cm == "pc<":
            playlist = gen_top_100(0, custom_list=playlist)
            playlist = list(reversed(playlist))

        elif cm[:3] == "pt>":
            value = cm[3:]
            if value and value.isdigit():
                value = int(value)
                for i in reversed(range(len(playlist))):
                    t_time = star_store.get(playlist[i])
                    if t_time < value:
                        del playlist[i]

        elif cm[:3] == "pt<":
            value = cm[3:]
            if value and value.isdigit():
                value = int(value)
                for i in reversed(range(len(playlist))):
                    t_time = star_store.get(playlist[i])
                    if t_time > value:
                        del playlist[i]

        elif cm[:3] == "pc>":
            value = cm[3:]
            if value and value.isdigit():
                value = int(value)
                for i in reversed(range(len(playlist))):
                    t_time = star_store.get(playlist[i])
                    tr = pctl.g(playlist[i])
                    if tr.length > 0:
                        if not value < t_time / tr.length:
                            del playlist[i]

        elif cm[:3] == "pc<":
            value = cm[3:]
            if value and value.isdigit():
                value = int(value)
                for i in reversed(range(len(playlist))):
                    t_time = star_store.get(playlist[i])
                    tr = pctl.g(playlist[i])
                    if tr.length > 0:
                        if not value > t_time / tr.length:
                            del playlist[i]

        elif cm == "y<":
            playlist = gen_sort_date(0, False, playlist)

        elif cm == "y>":
            playlist = gen_sort_date(0, True, playlist)

        elif cm[:2] == "y=":
            value = cm[2:]
            if value:
                temp = []
                for item in playlist:
                    if value in pctl.master_library[item].date:
                        temp.append(item)
                playlist = temp

        elif cm[:3] == "y>=":
            value = cm[3:]
            if value and value.isdigit():
                value = int(value)
                temp = []
                for item in playlist:
                    if pctl.master_library[item].date[:4].isdigit() and int(
                            pctl.master_library[item].date[:4]) >= value:
                        temp.append(item)
                playlist = temp

        elif cm[:3] == "y<=":
            value = cm[3:]
            if value and value.isdigit():
                value = int(value)
                temp = []
                for item in playlist:
                    if pctl.master_library[item].date[:4].isdigit() and int(
                            pctl.master_library[item].date[:4]) <= value:
                        temp.append(item)
                playlist = temp

        elif cm[:2] == "y>":
            value = cm[2:]
            if value and value.isdigit():
                value = int(value)
                temp = []
                for item in playlist:
                    if pctl.master_library[item].date[:4].isdigit() and int(pctl.master_library[item].date[:4]) > value:
                        temp.append(item)
                playlist = temp

        elif cm[:2] == "y<":
            value = cm[2:]
            if value and value.isdigit:
                value = int(value)
                temp = []
                for item in playlist:
                    if pctl.master_library[item].date[:4].isdigit() and int(pctl.master_library[item].date[:4]) < value:
                        temp.append(item)
                playlist = temp

        elif cm == "st" or cm == "rt" or cm == "r":
            random.shuffle(playlist)

        elif cm == "sf" or cm == "rf" or cm == "ra" or cm == "sa":
            playlist = gen_folder_shuffle(0, custom_list=playlist)

        elif cm.startswith("n"):
            value = cm[1:]
            if value.isdigit():
                playlist = playlist[:int(value)]

        # SEARCH FOLDER
        elif cm.startswith("p\"") and len(cm) > 3:

            if not selections:
                for plist in pctl.multi_playlist:
                    code = pctl.gen_codes.get(plist[6])
                    if is_source_type(code):
                        selections.append(plist[2])

            search = quote
            search_over.all_folders = True
            search_over.sip = True
            search_over.search_text.text = search
            try:
                worker2_lock.release()
            except:
                pass
            while search_over.sip:
                time.sleep(0.01)

            found_name = ""

            for result in search_over.results:
                if result[0] == 5:
                    found_name = result[1]
                    break
            else:
                print("No folder search result found")
                continue

            search_over.clear()

            playlist += search_over.click_meta(found_name, get_list=True, search_lists=selections)

        # SEARCH GENRE
        elif (cm.startswith("g\"") or cm.startswith("gm\"") or cm.startswith("g=\"")) and len(cm) > 3:

            if not selections:
                for plist in pctl.multi_playlist:
                    code = pctl.gen_codes.get(plist[6])
                    if is_source_type(code):
                        selections.append(plist[2])

            g_search = quote.lower().replace("-", "")  # .replace(" ", "")

            search = g_search
            search_over.sip = True
            search_over.search_text.text = search
            try:
                worker2_lock.release()
            except:
                pass
            while search_over.sip:
                time.sleep(0.01)

            found_name = ""

            if cm.startswith("g=\""):
                for result in search_over.results:
                    if result[0] == 3 and result[1].lower().replace("-", "").replace(" ", "") == g_search:  #
                        found_name = result[1]
                        break
            elif cm.startswith("g\"") or not prefs.sep_genre_multi:
                for result in search_over.results:
                    if result[0] == 3:
                        found_name = result[1]
                        break
            elif cm.startswith("gm\""):
                for result in search_over.results:
                    if result[0] == 3 and result[1].endswith("+"):  #
                        found_name = result[1]
                        break

            if not found_name:
                print("No genre search result found")
                continue

            search_over.clear()

            playlist += search_over.click_genre(found_name, get_list=True, search_lists=selections)

        # SEARCH ARTIST
        elif cm.startswith("a\"") and len(cm) > 3 and cm != "auto":
            if not selections:
                for plist in pctl.multi_playlist:
                    code = pctl.gen_codes.get(plist[6])
                    if is_source_type(code):
                        selections.append(plist[2])

            search = quote
            search_over.sip = True
            search_over.search_text.text = "artist " + search
            try:
                worker2_lock.release()
            except:
                pass
            while search_over.sip:
                time.sleep(0.01)

            found_name = ""

            for result in search_over.results:
                if result[0] == 0:
                    found_name = result[1]
                    break
            else:
                print("No artist search result found")
                continue

            search_over.clear()
            # for item in search_over.click_artist(found_name, get_list=True, search_lists=selections):
            #     playlist.append(item)
            playlist += search_over.click_artist(found_name, get_list=True, search_lists=selections)

        elif cm.startswith("ff\""):

            for i in reversed(range(len(playlist))):
                tr = pctl.g(playlist[i])
                line = " ".join([tr.title, tr.artist, tr.album, tr.fullpath, tr.composer, tr.comment])
                if not search_magic(quote.lower(), line.lower()):
                    del playlist[i]
            playlist = list(OrderedDict.fromkeys(playlist))

        elif cm.startswith("fx\""):

            for i in reversed(range(len(playlist))):
                tr = pctl.g(playlist[i])
                line = " ".join(
                    [tr.title, tr.artist, tr.album, tr.fullpath, tr.composer, tr.comment, tr.album_artist]).lower()
                if prefs.diacritic_search and all([ord(c) < 128 for c in quote]):
                    line = str(unidecode(line))

                if search_magic(quote.lower(), line):
                    del playlist[i]


        elif cm.startswith("find\"") or cm.startswith("f\"") or cm.startswith("fs\""):

            if not selections:
                for plist in pctl.multi_playlist:
                    code = pctl.gen_codes.get(plist[6])
                    if is_source_type(code):
                        selections.append(plist[2])

            cooldown = 0
            dones = {}
            for selection in selections:
                for track_id in selection:
                    if track_id not in dones:
                        tr = pctl.g(track_id)

                        if cm.startswith("fs\""):
                            line = "|".join([tr.title, tr.artist, tr.album, tr.fullpath, tr.composer, tr.comment,
                                             tr.album_artist]).lower()
                            if quote.lower() in line:
                                playlist.append(track_id)

                        else:
                            line = " ".join([tr.title, tr.artist, tr.album, tr.fullpath, tr.composer, tr.comment,
                                             tr.album_artist]).lower()

                            # if prefs.diacritic_search and all([ord(c) < 128 for c in quote]):
                            #     line = str(unidecode(line))

                            if search_magic(quote.lower(), line):
                                playlist.append(track_id)

                        cooldown += 1
                        if cooldown > 300:
                            time.sleep(0.005)
                            cooldown = 0

                        dones[track_id] = None

            playlist = list(OrderedDict.fromkeys(playlist))


        elif cm.startswith("s\"") or cm.startswith("px\""):
            pl_name = quote
            target = None
            for p in pctl.multi_playlist:
                if p[0].lower() == pl_name.lower():
                    target = p[2]
                    break
            else:
                for p in pctl.multi_playlist:
                    # print(p[0].lower())
                    # print(pl_name.lower())
                    if p[0].lower().startswith(pl_name.lower()):
                        target = p[2]
                        break
            if target is None:
                print(f"not found: {pl_name}")
                print("Target playlist not found")
                if cm.startswith("s\""):
                    selections_searched += 1
                errors = "playlist"
                continue

            if cm.startswith("s\""):
                selections_searched += 1
                selections.append(target)
            elif cm.startswith("px\""):
                playlist[:] = [x for x in playlist if x not in target]

        else:
            errors = True

    gui.gen_code_errors = errors
    if not playlist and not errors:
        gui.gen_code_errors = "empty"

    if gui.rename_playlist_box and (not playlist or cmds.count("a") > 1):
        pass
    else:
        source_playlist[:] = playlist[:]

    tree_view_box.clear_target_pl(0, id)
    pctl.regen_in_progress = False
    gui.pl_update = 1
    reload()
    pctl.notify_change()

    # print(cmds)


def make_auto_sorting(pl):
    pctl.gen_codes[pl_to_id(pl)] = "self a path tn ypa auto"
    show_message(_("OK. This playlist will automatically sort on import from now on"),
                 _("You remove or edit this behavior by going \"Misc...\" > \"Edit generator...\""), mode="done")


extra_tab_menu = Menu(155, show_icons=True)

extra_tab_menu.add(MenuItem(_("New Playlist"), new_playlist, icon=add_icon))


def spotify_show_test(_):
    return prefs.spot_mode

def jellyfin_show_test(_):
    return prefs.jelly_password and prefs.jelly_username


tab_menu.add(MenuItem(_("Upload"), upload_spotify_playlist, pass_ref=True, pass_ref_deco=True, icon=jell_icon,
             show_test=spotify_show_test))

def upload_jellyfin_playlist(pl):
    if jellyfin.scanning:
        return
    shooter(jellyfin.upload_playlist, [pl])

tab_menu.add(MenuItem(_("Upload"), upload_jellyfin_playlist, pass_ref=True, pass_ref_deco=True, icon=spot_icon,
             show_test=jellyfin_show_test))


def regen_playlist_async(pl):
    if pctl.regen_in_progress:
        show_message("A regen is already in progress...")
        return
    shoot_dl = threading.Thread(target=regenerate_playlist, args=([pl]))
    shoot_dl.daemon = True
    shoot_dl.start()


tab_menu.add(MenuItem(_("Regenerate"), regen_playlist_async, regenerate_deco, pass_ref=True, pass_ref_deco=True, hint="Alt+R"))
tab_menu.add_sub(_("Generate…"), 150)
tab_menu.add_sub(_("Sort…"), 170)
extra_tab_menu.add_sub(_("From Current…"), 133)
# tab_menu.add(_("Sort by Filepath"), standard_sort, pass_ref=True, disable_test=test_pl_tab_locked, pass_ref_deco=True)
# tab_menu.add(_("Sort Track Numbers"), sort_track_2, pass_ref=True)
# tab_menu.add(_("Sort Year per Artist"), year_sort, pass_ref=True)

tab_menu.add_to_sub(1, MenuItem(_("Sort by Imported Tracks"), imported_sort, pass_ref=True))
tab_menu.add_to_sub(1, MenuItem(_("Sort by Imported Folders"), imported_sort_folders, pass_ref=True))
tab_menu.add_to_sub(1, MenuItem(_("Sort by Filepath"), standard_sort, pass_ref=True))
tab_menu.add_to_sub(1, MenuItem(_('Sort Track Numbers'), sort_track_2, pass_ref=True))
tab_menu.add_to_sub(1, MenuItem(_('Sort Year per Artist'), year_sort, pass_ref=True))
tab_menu.add_to_sub(1, MenuItem(_('Make Playlist Auto-Sorting'), make_auto_sorting, pass_ref=True))

tab_menu.br()

tab_menu.add(MenuItem(_('Rescan Folder'), re_import2, rescan_deco, pass_ref=True, pass_ref_deco=True))

tab_menu.add(MenuItem(_('Paste'), s_append, paste_deco, pass_ref=True))
tab_menu.add(MenuItem(_("Append Playing"), append_current_playing, append_deco, pass_ref=True))
tab_menu.br()

# tab_menu.add("Sort By Filepath", sort_path_pl, pass_ref=True)

tab_menu.add(MenuItem(_("Export…"), export_playlist_box.activate, pass_ref=True))

tab_menu.add_sub(_("Misc…"), 175)


def forget_pl_import_folder(pl):
    pctl.multi_playlist[pl][7] = []


def remove_duplicates(pl):
    playlist = []

    for item in pctl.multi_playlist[pl][2]:
        if item not in playlist:
            playlist.append(item)

    removed = len(pctl.multi_playlist[pl][2]) - len(playlist)
    if not removed:
        show_message(f"No duplicates were found")
    else:
        show_message(f"{removed} duplicates removed", mode="done")

    pctl.multi_playlist[pl][2][:] = playlist[:]


def start_quick_add(pl):
    pctl.quick_add_target = pl_to_id(pl)
    show_message("You can now add/remove albums to this playlist by right clicking in gallery of any playlist",
                 "To exit this mode, click \"Disengage\" from main MENU")


def auto_get_sync_targets():
    search_paths = ["/run/user/*/gvfs/*/*/[Mm]usic",
                    "/run/media/*/*/[Mm]usic", ]
    result_paths = []
    for item in search_paths:
        result_paths.extend(glob.glob(item))
    return result_paths


def auto_sync_thread(pl):
    if prefs.transcode_inplace:
        show_message("Cannot sync when in transcode inplace mode")
        return

    # Find target path
    gui.sync_progress = "Starting Sync..."
    gui.update += 1

    path = sync_target.text.strip().rstrip("/").rstrip("\\").replace("\n", "").replace("\r", "")
    if not path:
        show_message(_("No target folder selected"))
        gui.sync_progress = ""
        gui.stop_sync = False
        gui.update += 1
        return
    if not os.path.isdir(path):
        show_message(_("Target folder could not be found"))
        gui.sync_progress = ""
        gui.stop_sync = False
        gui.update += 1
        return

    prefs.sync_target = path

    # Get list of folder names on device
    console.print("Getting folder list from device...")
    d_folder_names = os.listdir(path)
    console.print("Got list")

    # Get list of folders we want
    folders = convert_playlist(pl, get_list=True)
    folder_names = []
    folder_dict = {}

    if gui.stop_sync:
        gui.sync_progress = ""
        gui.stop_sync = False
        gui.update += 1

    # Find the folder names the transcode function would name them
    for folder in folders:
        name = encode_folder_name(pctl.g(folder[0]))
        for item in folder:
            if pctl.g(item).album != pctl.g(folder[0]).album:
                name = os.path.basename(pctl.g(folder[0]).parent_folder_path)
                break
        folder_names.append(name)
        folder_dict[name] = folder

    # ------
    # Find deletes
    if prefs.sync_deletes:
        for d_folder in d_folder_names:
            if gui.stop_sync:
                break
            if d_folder not in folder_names:
                gui.sync_progress = _("Deleting folders...")
                gui.update += 1
                console.print(f"DELETING: {d_folder}")
                shutil.rmtree(os.path.join(path, d_folder))

    # -------
    # Find todos
    todos = []
    for folder in folder_names:
        if folder not in d_folder_names:
            todos.append(folder)
            console.print(f"Want to add: {folder}")
        else:
            console.print(f"Already exists: {folder}")

    gui.update += 1
    # -----
    # Prepare and copy
    for i, item in enumerate(todos):
        gui.sync_progress = _("Copying files to device")
        if gui.stop_sync:
            break

        free_space = shutil.disk_usage(path)[2] / 8 / 100000000  # in GB
        if free_space < 0.6:
            show_message(_("Sync aborted! Low disk space on target device"), mode="warning")
            break

        if prefs.bypass_transcode or (prefs.smart_bypass and 0 < pctl.g(folder_dict[item][0]).bitrate <= 128):
            print("Smart bypass...")

            source_parent = pctl.g(folder_dict[item][0]).parent_folder_path
            if os.path.exists(source_parent):
                if os.path.exists(os.path.join(path, item)):
                    show_message(_("Sync warning"), _("One or more folders to sync has the same name. Skipping."),
                                 mode="warning")
                    continue

                os.mkdir(os.path.join(path, item))
                encode_done = source_parent
            else:
                show_message("One or more folders is missing")
                continue

        else:

            encode_done = os.path.join(prefs.encoder_output, item)
            if not os.path.exists(encode_done):
                console.print("Need to transcode")
                remain = len(todos) - i
                if remain > 1:
                    gui.sync_progress = str(remain) + " " + _("Folders Remaining")
                else:
                    gui.sync_progress = str(remain) + " " + _("Folder Remaining")
                transcode_list.append(folder_dict[item])
                tm.ready("worker")
                while transcode_list:
                    time.sleep(1)
                if gui.stop_sync:
                    break
            else:
                console.print("A transcode is already done")

            if os.path.exists(encode_done):

                if os.path.exists(os.path.join(path, item)):
                    show_message(_("Sync warning"), _("One or more folders to sync has the same name. Skipping."),
                                 mode="warning")
                    continue

                os.mkdir(os.path.join(path, item))

        for file in os.listdir(encode_done):

            console.print("Copy file...")
            # gui.sync_progress += "."
            gui.update += 1

            if os.path.isfile(os.path.join(encode_done, file)):
                size = os.path.getsize(os.path.join(encode_done, file))
                sync_file_timer.set()
                shutil.copyfile(os.path.join(encode_done, file), os.path.join(os.path.join(path, item), file))
            if gui.sync_speed == 0 or sync_file_update_timer.get() > 1 and not file.endswith(".jpg"):
                sync_file_update_timer.set()
                gui.sync_speed = size / sync_file_timer.get()
                gui.sync_progress = _("Copying files to device") + " @ " + get_filesize_string_rounded(
                    gui.sync_speed) + "/s"
                if gui.stop_sync:
                    gui.sync_progress = _("Aborting Sync") + " @ " + get_filesize_string_rounded(gui.sync_speed) + "/s"

        console.print("Finished copying folder")

    gui.sync_speed = 0
    gui.sync_progress = ""
    gui.stop_sync = False
    gui.update += 1
    show_message(_("Sync completed"), mode="done")


def auto_sync(pl):
    shoot_dl = threading.Thread(target=auto_sync_thread, args=([pl]))
    shoot_dl.daemon = True
    shoot_dl.start()


def set_sync_playlist(pl):
    id = pl_to_id(pl)
    if prefs.sync_playlist == id:
        prefs.sync_playlist = None
    else:
        prefs.sync_playlist = pl_to_id(pl)


def sync_playlist_deco(pl):
    text = _("Set as Sync Playlist")
    id = pl_to_id(pl)
    if id == prefs.sync_playlist:
        text = _("Un-set as Sync Playlist")
    return [colours.menu_text, colours.menu_background, text]


def set_download_playlist(pl):
    id = pl_to_id(pl)
    if prefs.download_playlist == id:
        prefs.download_playlist = None
    else:
        prefs.download_playlist = pl_to_id(pl)

def set_podcast_playlist(pl):
    pctl.multi_playlist[pl][11] ^= True


def set_download_deco(pl):
    text = _("Set as Downloads Playlist")
    if id == prefs.download_playlist:
        text = _("Un-set as Downloads Playlist")
    return [colours.menu_text, colours.menu_background, text]

def set_podcast_deco(pl):
    text = _("Set Use Persistent Time")
    if pctl.multi_playlist[pl][11]:
        text = _("Un-set Use Persistent Time")
    return [colours.menu_text, colours.menu_background, text]


def csv_string(item):
    item = str(item)
    item.replace("\"", "\"\"")
    return f"\"{item}\""


def export_playlist_albums(pl):
    p = pctl.multi_playlist[pl]
    name = p[0]
    playlist = p[2]

    albums = []
    playtimes = {}
    last_folder = None
    for i, id in enumerate(playlist):
        track = pctl.g(id)
        if last_folder != track.parent_folder_path:
            last_folder = track.parent_folder_path
            if id not in albums:
                albums.append(id)

        playtimes[last_folder] = playtimes.get(last_folder, 0) + int(star_store.get(id))

    filename = f"{user_directory}/{name}.csv"
    xport = open(filename, 'w')

    xport.write("Album name;Artist;Release date;Genre;Rating;Playtime;Folder path")

    for id in albums:
        track = pctl.g(id)
        artist = track.album_artist
        if not artist:
            artist = track.artist

        xport.write("\n")
        xport.write(csv_string(track.album) + ",")
        xport.write(csv_string(artist) + ",")
        xport.write(csv_string(track.date) + ",")
        xport.write(csv_string(track.genre) + ",")
        xport.write(str(int(album_star_store.get_rating(track))))
        xport.write(",")
        xport.write(str(round(playtimes[track.parent_folder_path])))
        xport.write(",")
        xport.write(csv_string(track.parent_folder_path))

    xport.close()
    show_message("Export complete.", "Saved as: " + filename, mode='done')


tab_menu.add_to_sub(2, MenuItem(_("Export Playlist Stats"), export_stats, pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Export Albums CSV"), export_playlist_albums, pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_('Transcode All'), convert_playlist, pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_('Rescan Tags'), rescan_tags, pass_ref=True))
# tab_menu.add_to_sub(_('Forget Import Folder'), 2, forget_pl_import_folder, rescan_deco, pass_ref=True, pass_ref_deco=True)
# tab_menu.add_to_sub(_('Re-Import Last Folder'), 1, re_import, pass_ref=True)
# tab_menu.add_to_sub(_('Quick Export XSPF'), 2, export_xspf, pass_ref=True)
# tab_menu.add_to_sub(_('Quick Export M3U'), 2, export_m3u, pass_ref=True)
tab_menu.add_to_sub(2, MenuItem(_("Toggle Breaks"), pl_toggle_playlist_break, pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Edit Generator..."), edit_generator_box, pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Engage Gallery Quick Add"), start_quick_add, pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Set as Sync Playlist"), set_sync_playlist, sync_playlist_deco, pass_ref_deco=True,
                    pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Set as Downloads Playlist"), set_download_playlist, set_download_deco, pass_ref_deco=True,
                    pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Set podcast mode"), set_podcast_playlist, set_podcast_deco, pass_ref_deco=True,
                    pass_ref=True))
tab_menu.add_to_sub(2, MenuItem(_("Remove Duplicates"), remove_duplicates, pass_ref=True))


# tab_menu.add_to_sub("Empty Playlist", 0, new_playlist)

def best(index):
    # key = pctl.master_library[index].title + pctl.master_library[index].filename
    if pctl.master_library[index].length < 1:
        return 0
    return int(star_store.get(index))


def key_rating(index):
    return star_store.get_rating(index)

def key_scrobbles(index):
    return pctl.g(index).lfm_scrobbles

def key_disc(index):
    return pctl.g(index).disc_number

def key_cue(index):
    return pctl.g(index).is_cue

def key_playcount(index):
    # key = pctl.master_library[index].title + pctl.master_library[index].filename
    if pctl.master_library[index].length < 1:
        return 0
    return star_store.get(index) / pctl.master_library[index].length
    # if key in pctl.star_library:
    #     return pctl.star_library[key] / pctl.master_library[index].length
    # else:
    #     return 0


def add_pl_tag(text):
    return f" <{text}>"


def gen_top_rating(index, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]
    playlist = copy.deepcopy(source)
    playlist = sorted(playlist, key=key_rating, reverse=True)

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Top Rated Tracks")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=1))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a rat>"


def gen_top_100(index, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]
    playlist = copy.deepcopy(source)
    playlist = sorted(playlist, key=best, reverse=True)

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Top Played Tracks")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=1))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a pt>"


tab_menu.add_to_sub(0, MenuItem(_("Top Played Tracks"), gen_top_100, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Top Played Tracks"), gen_top_100, pass_ref=True))


def gen_folder_top(pl, get_sets=False, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[pl][2]

    if len(source) < 3:
        return []

    sets = []
    se = []
    tr = pctl.g(source[0])
    last = tr.parent_folder_path
    last_al = tr.album
    for track in source:
        if last != pctl.master_library[track].parent_folder_path or last_al != pctl.master_library[track].album:
            last = pctl.master_library[track].parent_folder_path
            last_al = pctl.master_library[track].album
            sets.append(copy.deepcopy(se))
            se = []
        se.append(track)
    sets.append(copy.deepcopy(se))

    def best(folder):
        # print(folder)
        total_star = 0
        for item in folder:
            # key = pctl.master_library[item].title + pctl.master_library[item].filename
            # if key in pctl.star_library:
            #     total_star += int(pctl.star_library[key])
            total_star += int(star_store.get(item))
        # print(total_star)
        return total_star

    if get_sets:
        r = []
        for item in sets:
            r.append((item, best(item)))
        return r

    sets = sorted(sets, key=best, reverse=True)

    playlist = []

    for se in sets:
        playlist += se

    # pctl.multi_playlist.append(
    #     [pctl.multi_playlist[pl][0] + " <Most Played Albums>", 0, copy.deepcopy(playlist), 0, 0, 0])
    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[pl][0] + add_pl_tag(_("Top Played Albums")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[pl][0] + "\" a pa>"


tab_menu.add_to_sub(0, MenuItem(_("Top Played Albums"), gen_folder_top, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Top Played Albums"), gen_folder_top, pass_ref=True))

tab_menu.add_to_sub(0, MenuItem(_("Top Rated Tracks"), gen_top_rating, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Top Rated Tracks"), gen_top_rating, pass_ref=True))


def gen_folder_top_rating(pl, get_sets=False, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[pl][2]

    if len(source) < 3:
        return []

    sets = []
    se = []
    tr = pctl.g(source[0])
    last = tr.parent_folder_path
    last_al = tr.album
    for track in source:
        if last != pctl.master_library[track].parent_folder_path or last_al != pctl.master_library[track].album:
            last = pctl.master_library[track].parent_folder_path
            last_al = pctl.master_library[track].album
            sets.append(copy.deepcopy(se))
            se = []
        se.append(track)
    sets.append(copy.deepcopy(se))

    def best(folder):
        return album_star_store.get_rating((pctl.g(folder[0])))

    if get_sets:
        r = []
        for item in sets:
            r.append((item, best(item)))
        return r

    sets = sorted(sets, key=best, reverse=True)

    playlist = []

    for se in sets:
        playlist += se

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[pl][0] + add_pl_tag(_("Top Rated Albums")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[pl][0] + "\" a rata>"


def gen_lyrics(pl, custom_list=None):
    playlist = []

    source = custom_list
    if source is None:
        source = pctl.multi_playlist[pl][2]

    for item in source:
        if pctl.master_library[item].lyrics != "":
            playlist.append(item)

    if custom_list is not None:
        return playlist

    if len(playlist) > 0:
        pctl.multi_playlist.append(pl_gen(title=_("Tracks with lyrics"),
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[pl][0] + "\" a ly"

    else:
        show_message(_("No tracks with lyrics were found."))


tab_menu.add_to_sub(0, MenuItem(_("Top Rated Albums"), gen_folder_top_rating, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Top Rated Albums"), gen_folder_top_rating, pass_ref=True))


def gen_incomplete(pl, custom_list=None):
    playlist = []

    source = custom_list
    if source is None:
        source = pctl.multi_playlist[pl][2]

    albums = {}
    nums = {}
    for id in source:
        track = pctl.g(id)
        if track.album and track.track_number:

            if type(track.track_number) is str and not track.track_number.isdigit():
                continue

            if track.album not in albums:
                albums[track.album] = []
                nums[track.album] = []

            if track not in albums[track.album]:
                albums[track.album].append(track)
                nums[track.album].append(int(track.track_number))

    for album, tracks in albums.items():
        numbers = nums[album]
        if len(numbers) > 2:
            mi = min(numbers)
            mx = max(numbers)
            for track in tracks:
                if type(track.track_total) is int or (type(track.track_total) is str and track.track_total.isdigit()):
                    mx = max(mx, int(track.track_total))
            r = list(range(int(mi), int(mx)))
            for track in tracks:
                if int(track.track_number) in r:
                    r.remove(int(track.track_number))
            if r or mi > 1:
                for tr in tracks:
                    playlist.append(tr.index)

    if custom_list is not None:
        return playlist

    if len(playlist) > 0:
        show_message(_("Note this may include albums that simply have tracks missing an album tag"))
        pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[pl][0] + add_pl_tag(_("Incomplete Albums")),
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        # pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[pl][0] + "\" a ly"

    else:
        show_message(_("No incomplete albums were found."))


def gen_codec_pl(codec):
    playlist = []

    for pl in pctl.multi_playlist:
        for item in pl[2]:
            if pctl.master_library[item].file_ext == codec and item not in playlist:
                playlist.append(item)

    if len(playlist) > 0:
        pctl.multi_playlist.append(pl_gen(title=_("Codec") + ": " + codec,
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))


def gen_last_imported_folders(index, custom_list=None, reverse=True):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    a_cache = {}

    def key_import(index):

        track = pctl.master_library[index]
        cached = a_cache.get((track.album, track.parent_folder_name))
        if cached is not None:
            return cached

        if track.album:
            a_cache[(track.album, track.parent_folder_name)] = index
        return index

    playlist = copy.deepcopy(source)
    playlist = sorted(playlist, key=key_import, reverse=reverse)
    sort_track_2(0, playlist)

    if custom_list is not None:
        return playlist


def gen_last_modified(index, custom_list=None, reverse=True):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    a_cache = {}

    def key_modified(index):

        track = pctl.master_library[index]
        cached = a_cache.get((track.album, track.parent_folder_name))
        if cached is not None:
            return cached

        if track.album:
            a_cache[(track.album, track.parent_folder_name)] = pctl.master_library[index].modified_time
        return pctl.master_library[index].modified_time

    playlist = copy.deepcopy(source)
    playlist = sorted(playlist, key=key_modified, reverse=reverse)
    sort_track_2(0, playlist)

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("File Modified")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a m>"


tab_menu.add_to_sub(0, MenuItem(_("File Modified"), gen_last_modified, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("File Modified"), gen_last_modified, pass_ref=True))


# tab_menu.add_to_sub(_("File Path"), 0, standard_sort, pass_ref=True)
# extra_tab_menu.add_to_sub(_("File Path"), 0, standard_sort, pass_ref=True)


def gen_love(pl, custom_list=None):
    playlist = []

    source = custom_list
    if source is None:
        source = pctl.multi_playlist[pl][2]

    for item in source:
        if get_love_index(item):
            playlist.append(item)

    playlist.sort(key=lambda x: get_love_timestamp_index(x), reverse=True)

    if custom_list is not None:
        return playlist

    if len(playlist) > 0:
        # pctl.multi_playlist.append(["Interesting Comments", 0, copy.deepcopy(playlist), 0, 0, 0])
        pctl.multi_playlist.append(pl_gen(title=_("Loved"),
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[pl][0] + "\" a l"
    else:
        show_message("No loved tracks were found.")


def gen_comment(pl):
    playlist = []

    for item in pctl.multi_playlist[pl][2]:
        cm = pctl.master_library[item].comment
        if len(cm) > 20 and \
                cm[0] != "0" and \
                'http://' not in cm and \
                'www.' not in cm and \
                'Release' not in cm and \
                'EAC' not in cm and \
                '@' not in cm and \
                '.com' not in cm and \
                'ipped' not in cm and \
                'ncoded' not in cm and \
                'ExactA' not in cm and \
                'WWW.' not in cm and \
                cm[2] != "+" and \
                cm[1] != "+":
            playlist.append(item)

    if len(playlist) > 0:
        # pctl.multi_playlist.append(["Interesting Comments", 0, copy.deepcopy(playlist), 0, 0, 0])
        pctl.multi_playlist.append(pl_gen(title=_("Interesting Comments"),
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))
    else:
        show_message("Nothing of interest was found.")


def gen_replay(pl):
    playlist = []

    for item in pctl.multi_playlist[pl][2]:
        if pctl.master_library[item].misc.get("replaygain_track_gain"):
            playlist.append(item)

    if len(playlist) > 0:
        pctl.multi_playlist.append(pl_gen(title="ReplayGain Tracks",
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))
    else:
        show_message("No replay gain tags were found.")


def gen_sort_len(index, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    def length(index):

        if pctl.master_library[index].length < 1:
            return 0
        else:
            return int(pctl.master_library[index].length)

    playlist = copy.deepcopy(source)
    playlist = sorted(playlist, key=length, reverse=True)

    if custom_list is not None:
        return playlist

    # pctl.multi_playlist.append(
    #     [pctl.multi_playlist[index][0] + " <Duration Sorted>", 0, copy.deepcopy(playlist), 0, 1, 0])

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Duration Sorted")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=1))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a d>"


tab_menu.add_to_sub(0, MenuItem(_("Longest Tracks"), gen_sort_len, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Longest Tracks"), gen_sort_len, pass_ref=True))


def gen_folder_duration(pl, get_sets=False):
    if len(pctl.multi_playlist[pl][2]) < 3:
        return

    sets = []
    se = []
    last = pctl.master_library[pctl.multi_playlist[pl][2][0]].parent_folder_path
    last_al = pctl.master_library[pctl.multi_playlist[pl][2][0]].album
    for track in pctl.multi_playlist[pl][2]:
        if last != pctl.master_library[track].parent_folder_path or last_al != pctl.master_library[track].album:
            last = pctl.master_library[track].parent_folder_path
            last_al = pctl.master_library[track].album
            sets.append(copy.deepcopy(se))
            se = []
        se.append(track)
    sets.append(copy.deepcopy(se))

    def best(folder):
        total_duration = 0
        for item in folder:
            total_duration += pctl.master_library[item].length
        return total_duration

    if get_sets:
        r = []
        for item in sets:
            r.append((item, best(item)))
        return r

    sets = sorted(sets, key=best, reverse=True)
    playlist = []

    for se in sets:
        playlist += se

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[pl][0] + add_pl_tag(_("Longest Albums")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))


tab_menu.add_to_sub(0, MenuItem(_("Longest Albums"), gen_folder_duration, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Longest Albums"), gen_folder_duration, pass_ref=True))


def gen_sort_date(index, rev=False, custom_list=None):
    def g_date(index):

        if pctl.master_library[index].date != "":
            return str(pctl.master_library[index].date)
        else:
            return "z"

    playlist = []
    lowest = 0
    highest = 0
    first = True

    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    for item in source:
        date = pctl.master_library[item].date
        if date != "":
            playlist.append(item)
            if len(date) > 4 and date[:4].isdigit():
                date = date[:4]
            if len(date) == 4 and date.isdigit():
                year = int(date)
                if first:
                    lowest = year
                    highest = year
                    first = False
                if year < lowest:
                    lowest = year
                if year > highest:
                    highest = year

    playlist = sorted(playlist, key=g_date, reverse=rev)

    if custom_list is not None:
        return playlist

    line = add_pl_tag(_("Year Sorted"))
    if lowest != highest and lowest != 0 and highest != 0:
        if rev:
            line = " <" + str(highest) + "-" + str(lowest) + ">"
        else:
            line = " <" + str(lowest) + "-" + str(highest) + ">"

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + line,
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    if rev:
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a y>"
    else:
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a y<"


tab_menu.add_to_sub(0, MenuItem(_("Year by Oldest"), gen_sort_date, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Year by Oldest"), gen_sort_date, pass_ref=True))


def gen_sort_date_new(index):
    gen_sort_date(index, True)


tab_menu.add_to_sub(0, MenuItem(_("Year by Latest"), gen_sort_date_new, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Year by Latest"), gen_sort_date_new, pass_ref=True))


# tab_menu.add_to_sub(_("Year by Artist"), 0, year_sort, pass_ref=True)
# extra_tab_menu.add_to_sub(_("Year by Artist"), 0, year_sort, pass_ref=True)

def gen_500_random(index):
    playlist = copy.deepcopy(pctl.multi_playlist[index][2])

    random.shuffle(playlist)

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Shuffled Tracks")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=1))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a st"


tab_menu.add_to_sub(0, MenuItem(_("Shuffled Tracks"), gen_500_random, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Shuffled Tracks"), gen_500_random, pass_ref=True))


def gen_folder_shuffle(index, custom_list=None):
    folders = []
    dick = {}

    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    for track in source:
        parent = pctl.master_library[track].parent_folder_path
        if parent not in folders:
            folders.append(parent)
        if parent not in dick:
            dick[parent] = []
        dick[parent].append(track)

    random.shuffle(folders)
    playlist = []

    for folder in folders:
        playlist += dick[folder]

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Shuffled Albums")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a ra"


tab_menu.add_to_sub(0, MenuItem(_("Shuffled Albums"), gen_folder_shuffle, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Shuffled Albums"), gen_folder_shuffle, pass_ref=True))


def gen_best_random(index):
    playlist = []

    for p in pctl.multi_playlist[index][2]:
        time = star_store.get(p)

        if time > 300:
            playlist.append(p)

    random.shuffle(playlist)

    if len(playlist) > 0:
        pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Lucky Random")),
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=1))

        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][
            0] + "\" a pt>300 rt"


tab_menu.add_to_sub(0, MenuItem(_("Lucky Random"), gen_best_random, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Lucky Random"), gen_best_random, pass_ref=True))


def gen_reverse(index, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    playlist = list(reversed(source))

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Reversed")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=pctl.multi_playlist[index][4]))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a rv"


tab_menu.add_to_sub(0, MenuItem(_("Reverse Tracks"), gen_reverse, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Reverse Tracks"), gen_reverse, pass_ref=True))


def gen_folder_reverse(index, custom_list=None):
    source = custom_list
    if source is None:
        source = pctl.multi_playlist[index][2]

    folders = []
    dick = {}
    for track in source:
        parent = pctl.master_library[track].parent_folder_path
        if parent not in folders:
            folders.append(parent)
        if parent not in dick:
            dick[parent] = []
        dick[parent].append(track)

    folders = list(reversed(folders))
    playlist = []

    for folder in folders:
        playlist += dick[folder]

    if custom_list is not None:
        return playlist

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Reversed Albums")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[index][0] + "\" a rva"


tab_menu.add_to_sub(0, MenuItem(_("Reverse Albums"), gen_folder_reverse, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Reverse Albums"), gen_folder_reverse, pass_ref=True))


def gen_dupe(index):
    playlist = pctl.multi_playlist[index][2]

    pctl.multi_playlist.append(pl_gen(title=gen_unique_pl_title(pctl.multi_playlist[index][0], _("Duplicate") + " ", 0),
                                      playing=pctl.multi_playlist[index][1],
                                      playlist=copy.deepcopy(playlist),
                                      position=pctl.multi_playlist[index][3],
                                      hide_title=pctl.multi_playlist[index][4],
                                      selected=pctl.multi_playlist[index][5]))


tab_menu.add_to_sub(0, MenuItem(_("Duplicate"), gen_dupe, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Duplicate"), gen_dupe, pass_ref=True))


def gen_sort_path(index):
    def path(index):
        return pctl.master_library[index].fullpath

    playlist = copy.deepcopy(pctl.multi_playlist[index][2])
    playlist = sorted(playlist, key=path)

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Filepath Sorted")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))


# tab_menu.add_to_sub("Filepath", 1, gen_sort_path, pass_ref=True)


def gen_sort_artist(index):
    def artist(index):
        return pctl.master_library[index].artist

    playlist = copy.deepcopy(pctl.multi_playlist[index][2])
    playlist = sorted(playlist, key=artist)

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Artist Sorted")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))


# tab_menu.add_to_sub("Artist → gui.abc", 0, gen_sort_artist, pass_ref=True)


def gen_sort_album(index):
    def album(index):
        return pctl.master_library[index].album

    playlist = copy.deepcopy(pctl.multi_playlist[index][2])
    playlist = sorted(playlist, key=album)

    pctl.multi_playlist.append(pl_gen(title=pctl.multi_playlist[index][0] + add_pl_tag(_("Album Sorted")),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))


# tab_menu.add_to_sub("Album → gui.abc", 0, gen_sort_album, pass_ref=True)
tab_menu.add_to_sub(0, MenuItem(_("Loved"), gen_love, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Loved"), gen_love, pass_ref=True))
tab_menu.add_to_sub(0, MenuItem(_("Has Comment"), gen_comment, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Has Comment"), gen_comment, pass_ref=True))
tab_menu.add_to_sub(0, MenuItem(_("Has Lyrics"), gen_lyrics, pass_ref=True))
extra_tab_menu.add_to_sub(0, MenuItem(_("Has Lyrics"), gen_lyrics, pass_ref=True))


def get_playing_line():
    if 3 > pctl.playing_state > 0:
        title = pctl.master_library[pctl.track_queue[pctl.queue_step]].title
        artist = pctl.master_library[pctl.track_queue[pctl.queue_step]].artist
        return artist + " - " + title
    else:
        return 'Stopped'



def reload_config_file():
    if transcode_list:
        show_message("Cannot reload while a transcode is in progress!", mode='error')
        return

    load_prefs()
    gui.opened_config_file = False

    ddt.force_subpixel_text = prefs.force_subpixel_text
    ddt.clear_text_cache()
    pctl.playerCommand = 'reload'
    pctl.playerCommandReady = True
    show_message(_("Configuration reloaded"), mode="done")
    gui.update_layout()


def open_config_file():
    save_prefs()
    target = os.path.join(config_directory, "tauon.conf")
    if system == "windows" or msys:
        os.startfile(target)
    elif macos:
        subprocess.call(['open', "-t", target])
    else:
        subprocess.call(["xdg-open", target])
    show_message(_("Config file opened."), _('Click "Reload" if you made any changes'), mode='arrow')
    # reload_config_file()
    # gui.message_box = False
    gui.opened_config_file = True


def open_keymap_file():
    target = os.path.join(config_directory, "input.txt")

    if not os.path.isfile(target):
        show_message("Input file missing")
        return

    if system == "windows" or msys:
        os.startfile(target)
    elif macos:
        subprocess.call(['open', target])
    else:
        subprocess.call(["xdg-open", target])


def open_file(target):
    if not os.path.isfile(target):
        show_message("Input file missing")
        return

    if system == "windows" or msys:
        os.startfile(target)
    elif macos:
        subprocess.call(['open', target])
    else:
        subprocess.call(["xdg-open", target])


def open_data_directory():
    target = user_directory
    if system == "windows" or msys:
        os.startfile(target)
    elif macos:
        subprocess.call(['open', target])
    else:
        subprocess.call(["xdg-open", target])


def remove_folder(index):
    global default_playlist

    for b in range(len(default_playlist) - 1, -1, -1):
        r_folder = pctl.master_library[index].parent_folder_name
        if pctl.master_library[default_playlist[b]].parent_folder_name == r_folder:
            del default_playlist[b]

    reload()


def convert_folder(index):
    global default_playlist
    global transcode_list

    if not tauon.test_ffmpeg():
        return

    folder = []
    if key_shift_down or key_shiftr_down:
        track_object = pctl.g(index)
        if track_object.is_network:
            show_message(_("Transcoding tracks from network locations is not supported"))
            return
        folder = [index]

        if prefs.transcode_codec == 'flac' and track_object.file_ext.lower() in ('mp3', 'opus',
                                                                                 'mp4', 'ogg',
                                                                                 'aac'):
            show_message("NO! Bad user!", "Im not going to let you transcode a lossy codec to a lossless one!",
                         mode='warning')

            return
        folder = [index]

    else:
        r_folder = pctl.master_library[index].parent_folder_path
        for item in default_playlist:
            if r_folder == pctl.master_library[item].parent_folder_path:

                track_object = pctl.g(item)
                if track_object.file_ext == "SPOT":  # track_object.is_network:
                    show_message(_("Transcoding spotify tracks not possible"))
                    return

                if item not in folder:
                    folder.append(item)
                # print(prefs.transcode_codec)
                # print(track_object.file_ext)
                if prefs.transcode_codec == 'flac' and track_object.file_ext.lower() in ('mp3', 'opus',
                                                                                         'mp4', 'ogg',
                                                                                         'aac'):
                    show_message("NO! Bad user!", "Im not going to let you transcode a lossy codec to a lossless one!",
                                 mode='warning')

                    return

    # print(folder)
    transcode_list.append(folder)
    tm.ready("worker")


def transfer(index, args):
    global cargo
    global default_playlist
    old_cargo = copy.deepcopy(cargo)

    if args[0] == 1 or args[0] == 0:  # copy
        if args[1] == 1:  # single track
            cargo.append(index)
            if args[0] == 0:  # cut
                del default_playlist[pctl.selected_in_playlist]

        elif args[1] == 2:  # folder
            for b in range(len(default_playlist)):
                if pctl.master_library[default_playlist[b]].parent_folder_name == pctl.master_library[
                    index].parent_folder_name:
                    cargo.append(default_playlist[b])
            if args[0] == 0:  # cut
                for b in reversed(range(len(default_playlist))):
                    if pctl.master_library[default_playlist[b]].parent_folder_name == pctl.master_library[
                        index].parent_folder_name:
                        del default_playlist[b]

        elif args[1] == 3:  # playlist
            cargo += default_playlist
            if args[0] == 0:  # cut
                default_playlist = []

    elif args[0] == 2:  # Drop
        if args[1] == 1:  # Before

            insert = pctl.selected_in_playlist
            while insert > 0 and pctl.master_library[default_playlist[insert]].parent_folder_name == \
                    pctl.master_library[index].parent_folder_name:
                insert -= 1
                if insert == 0:
                    break
            else:
                insert += 1

            while len(cargo) > 0:
                default_playlist.insert(insert, cargo.pop())

        elif args[1] == 2:  # After
            insert = pctl.selected_in_playlist

            while insert < len(default_playlist) and pctl.master_library[default_playlist[insert]].parent_folder_name == \
                    pctl.master_library[index].parent_folder_name:
                insert += 1

            while len(cargo) > 0:
                default_playlist.insert(insert, cargo.pop())
        elif args[1] == 3:  # End
            default_playlist += cargo
            # cargo = []

        cargo = old_cargo

    reload()


def temp_copy_folder(ref):
    global cargo
    cargo = []
    transfer(ref, args=[1, 2])


def activate_track_box(index):
    global track_box
    global r_menu_index
    r_menu_index = index
    track_box = True
    track_box_path_tool_timer.set()


def menu_paste(position):
    paste(None, position)


def s_copy():
    # Copy tracks to internal clipboard
    # gui.lightning_copy = False
    # if key_shift_down:
    gui.lightning_copy = True

    clip = copy_from_clipboard()
    if "file://" in clip:
        copy_to_clipboard("")

    global cargo
    cargo = []
    if default_playlist:
        for item in shift_selection:
            cargo.append(default_playlist[item])

    if not cargo and -1 < pctl.selected_in_playlist < len(default_playlist):
        cargo.append(default_playlist[pctl.selected_in_playlist])

    tauon.copied_track = None

    if len(cargo) == 1:
        tauon.copied_track = cargo[0]


def directory_size(path):
    total = 0
    for dirpath, dirname, filenames in os.walk(path):
        for file in filenames:
            path = os.path.join(dirpath, file)
            total += os.path.getsize(path)
    return total


def lightning_paste():
    move = True
    # if not key_shift_down:
    #     move = False

    move_track = pctl.g(cargo[0])
    move_path = move_track.parent_folder_path

    for item in cargo:
        if move_path != pctl.g(item).parent_folder_path:
            show_message("More than one folder is in the clipboard",
                         'This function can only move one folder at a time.', mode='info')
            return

    match_track = pctl.g(default_playlist[shift_selection[0]])
    match_path = match_track.parent_folder_path

    if pctl.playing_state > 0 and move:
        if pctl.playing_object().parent_folder_path == move_path:
            pctl.stop(True)

    p = Path(match_path)
    s = list(p.parts)
    base = s[0]
    c = base
    del s[0]

    to_move = []
    for pl in pctl.multi_playlist:
        for i in reversed(range(len(pl[2]))):
            if pctl.g(pl[2][i]).parent_folder_path == move_track.parent_folder_path:
                to_move.append(pl[2][i])

    to_move = list(set(to_move))

    for level in s:
        upper = c
        c = os.path.join(c, level)

        t_artist = match_track.artist
        ta_artist = match_track.album_artist

        t_artist = filename_safe(t_artist)
        ta_artist = filename_safe(ta_artist)

        if (len(t_artist) > 0 and t_artist in level) or \
                (len(ta_artist) > 0 and ta_artist in level):

            print("found target artist level")
            print(t_artist)
            print("Upper folder is: " + upper)

            if len(move_path) < 4:
                show_message("Safety interupt! The source path seems oddly short.", move_path, mode='error')
                return

            if not os.path.isdir(upper):
                show_message("The target directory is missing!", upper, mode='warning')
                return

            if not os.path.isdir(move_path):
                show_message("The source directory is missing!", move_path, mode='warning')
                return

            protect = ("", "Documents", "Music", "Desktop", "Downloads")
            for fo in protect:
                if move_path.strip('\\/') == os.path.join(os.path.expanduser('~'), fo).strip("\\/"):
                    show_message("Better not do anything to that folder!", os.path.join(os.path.expanduser('~'), fo),
                                 mode='warning')
                    return

            if directory_size(move_path) > 3000000000:
                show_message("Folder size safety limit reached! (3GB)", move_path, mode='warning')
                return

            if len(next(os.walk(move_path))[2]) > max(20, len(to_move) * 2):
                show_message("Safety interupt! The source folder seems to have many files.", move_path, mode='warning')
                return

            artist = move_track.artist
            if move_track.album_artist != "":
                artist = move_track.album_artist

            artist = filename_safe(artist)

            if artist == "":
                show_message("The track needs to have an artist name.")
                return

            artist_folder = os.path.join(upper, artist)

            print("Target will be: " + artist_folder)

            if os.path.isdir(artist_folder):
                print("The target artist folder already exists")
            else:
                print("Need to make artist folder")
                os.makedirs(artist_folder)

            print("The folder to be moved is: " + move_path)
            load_order = LoadClass()
            load_order.target = os.path.join(artist_folder, move_track.parent_folder_name)
            load_order.playlist = pctl.multi_playlist[pctl.active_playlist_viewing][6]

            insert = shift_selection[0]
            old_insert = insert
            while insert < len(default_playlist) and pctl.master_library[
                pctl.multi_playlist[pctl.active_playlist_viewing][2][insert]].parent_folder_name == \
                    pctl.master_library[
                        pctl.multi_playlist[pctl.active_playlist_viewing][2][old_insert]].parent_folder_name:
                insert += 1

            load_order.playlist_position = insert

            move_jobs.append((move_path, os.path.join(artist_folder, move_track.parent_folder_name), move,
                              move_track.parent_folder_name, load_order))
            tm.ready("worker")
            # Remove all tracks with the old paths
            for pl in pctl.multi_playlist:
                for i in reversed(range(len(pl[2]))):
                    if pctl.g(pl[2][i]).parent_folder_path == move_track.parent_folder_path:
                        del pl[2][i]

            break
    else:
        show_message("Could not find a folder with the artist's name to match level at.")
        return

    # for file in os.listdir(artist_folder):
    #

    if album_mode:
        prep_gal()
        reload_albums(True)

    cargo.clear()
    gui.lightning_copy = False


def paste(playlist_no=None, track_id=None):
    clip = copy_from_clipboard()
    if "spotify" in clip:
        cargo.clear()
        for link in clip.split("\n"):
            print(link)
            link = link.strip()
            if clip.startswith("https://open.spotify.com/track/") or clip.startswith("spotify:track:"):
                spot_ctl.append_track(link)
            elif clip.startswith("https://open.spotify.com/album/") or clip.startswith("spotify:album:"):
                l = spot_ctl.append_album(link, return_list=True)
                if l:
                    cargo.extend(l)
            elif clip.startswith("https://open.spotify.com/playlist/"):
                spot_ctl.playlist(link)
        if album_mode:
            reload_albums()
        gui.pl_update += 1
        clip = False

    found = False
    if clip:
        clip = clip.split("\n")
        for i, line in enumerate(clip):
            if line.startswith("file://") or line.startswith("/"):
                target = str(urllib.parse.unquote(line)).replace("file://", "").replace("\r", "")
                load_order = LoadClass()
                load_order.target = target
                load_order.playlist = pctl.multi_playlist[pctl.active_playlist_viewing][6]

                if playlist_no is not None:
                    load_order.playlist = pl_to_id(playlist_no)
                if track_id is not None:
                    load_order.playlist_position = r_menu_position

                load_orders.append(copy.deepcopy(load_order))
                found = True

    if not found:

        if playlist_no is None:
            if track_id is None:
                transfer(0, (2, 3))
            else:
                transfer(track_id, (2, 2))
        else:
            append_playlist(playlist_no)

    gui.pl_update += 1
    return


def s_cut():
    s_copy()
    del_selected()


playlist_menu.add(MenuItem('Paste', paste, paste_deco))


def paste_playlist_coast_fire():
    url = None
    if spot_ctl.coasting and pctl.playing_state == 3:
        url = spot_ctl.get_album_url_from_local(pctl.playing_object())
    elif pctl.playing_ready() and "spotify-album-url" in pctl.playing_object().misc:
        url = pctl.playing_object().misc["spotify-album-url"]
    if url:
        default_playlist.extend(spot_ctl.append_album(url, return_list=True))
    gui.pl_update += 1

def paste_playlist_track_coast_fire():
    url = None
    # if spot_ctl.coasting and pctl.playing_state == 3:
    #     url = spot_ctl.get_album_url_from_local(pctl.playing_object())
    if pctl.playing_ready() and "spotify-track-url" in pctl.playing_object().misc:
        url = pctl.playing_object().misc["spotify-track-url"]
    if url:
        spot_ctl.append_track(url)
    gui.pl_update += 1


def paste_playlist_coast_album():
    shoot_dl = threading.Thread(target=paste_playlist_coast_fire)
    shoot_dl.daemon = True
    shoot_dl.start()
def paste_playlist_coast_track():
    shoot_dl = threading.Thread(target=paste_playlist_track_coast_fire)
    shoot_dl.daemon = True
    shoot_dl.start()

def paste_playlist_coast_album_deco():
    if spot_ctl.coasting or spot_ctl.playing:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


playlist_menu.add(MenuItem(_('Add Playing Spotify Album'), paste_playlist_coast_album, paste_playlist_coast_album_deco,
                  show_test=spotify_show_test))
playlist_menu.add(MenuItem(_('Add Playing Spotify Track'), paste_playlist_coast_track, paste_playlist_coast_album_deco,
                  show_test=spotify_show_test))

def refind_playing():
    # Refind playing index
    if pctl.playing_ready():
        for i, n in enumerate(default_playlist):
            if pctl.track_queue[pctl.queue_step] == n:
                pctl.playlist_playing_position = i
                break


def del_selected(force_delete=False):
    global shift_selection

    gui.update += 1
    gui.pl_update = 1

    if not shift_selection:
        shift_selection = [pctl.selected_in_playlist]

    if not default_playlist:
        return

    li = []

    for item in reversed(shift_selection):
        if item > len(default_playlist) - 1:
            return

        li.append((item, default_playlist[item]))  # take note for force delete

        # Correct track playing position
        if pctl.active_playlist_playing == pctl.active_playlist_viewing:
            if 0 < pctl.playlist_playing_position + 1 > item:
                pctl.playlist_playing_position -= 1

        del default_playlist[item]

    if force_delete:
        for item in li:

            tr = pctl.g(item[1])
            if not tr.is_network:
                try:
                    send2trash(tr.fullpath)
                    show_message("Tracks sent to trash")
                except:
                    show_message("One or more tracks could not be sent to trash")

                    if force_delete:
                        try:
                            os.remove(tr.fullpath)
                            show_message("Files deleted", mode='info')
                        except:
                            show_message("Error deleting one or more files", mode='error')

    else:
        undo.bk_tracks(pctl.active_playlist_viewing, li)

    reload()
    tree_view_box.clear_target_pl(pctl.active_playlist_viewing)

    if pctl.selected_in_playlist > len(default_playlist) - 1:
        pctl.selected_in_playlist = len(default_playlist) - 1

    shift_selection = [pctl.selected_in_playlist]
    gui.pl_update += 1
    refind_playing()
    pctl.notify_change()


def force_del_selected():
    del_selected(force_delete=True)


def test_show(dummy):
    return album_mode


def show_in_gal(track, silent=False):
    # goto_album(pctl.playlist_selected)
    gui.gallery_animate_highlight_on = goto_album(pctl.selected_in_playlist)
    if not silent:
        gallery_select_animate_timer.set()


# Create track context menu
track_menu = Menu(195, show_icons=True)

track_menu.add(MenuItem(_('Open Folder'), open_folder, pass_ref=True, pass_ref_deco=True, icon=folder_icon, disable_test=open_folder_disable_test))
track_menu.add(MenuItem(_('Track Info…'), activate_track_box, pass_ref=True, icon=info_icon))


def last_fm_test(ignore):
    if lastfm.connected:
        return True
    else:
        return False


def heart_xmenu_colour():
    global r_menu_index
    if love(False, r_menu_index):
        return [245, 60, 60, 255]
    else:
        if colours.lm:
            return [255, 150, 180, 255]
        return None


heartx_icon.colour = [55, 55, 55, 255]
heartx_icon.xoff = 1
heartx_icon.yoff = 0
heartx_icon.colour_callback = heart_xmenu_colour


def spot_heart_xmenu_colour():
    if not (pctl.playing_state == 1 or pctl.playing_state == 2):
        return None
    tr = pctl.playing_object()
    if tr and "spotify-liked" in tr.misc:
        return [30, 215, 96, 255]
    else:
        return None


spot_heartx_icon.colour = [30, 215, 96, 255]
spot_heartx_icon.xoff = 3
spot_heartx_icon.yoff = 0
spot_heartx_icon.colour_callback = spot_heart_xmenu_colour


def love_decox():
    global r_menu_index

    if love(False, r_menu_index):
        return [colours.menu_text, colours.menu_background, _("Un-Love Track")]
    else:
        return [colours.menu_text, colours.menu_background, _("Love Track")]


def love_index():
    global r_menu_index

    notify = False
    if not gui.show_hearts:
        notify = True

    # love(True, r_menu_index)
    shoot_love = threading.Thread(target=love, args=[True, r_menu_index, False, notify])
    shoot_love.daemon = True
    shoot_love.start()


# Mark track as 'liked'
track_menu.add(MenuItem('Love', love_index, love_decox, icon=heartx_icon))

def toggle_spotify_like_ref():
    tr = pctl.g(r_menu_index)
    if tr:
        shoot_dl = threading.Thread(target=toggle_spotify_like_active2, args=([tr]))
        shoot_dl.daemon = True
        shoot_dl.start()

def toggle_spotify_like3():
    toggle_spotify_like_active2(pctl.g(r_menu_index))

def toggle_spotify_like_row_deco():
    tr = pctl.g(r_menu_index)
    text = _("Spotify Like Track")

    # if pctl.playing_state == 0 or not tr or not "spotify-track-url" in tr.misc:
    #     return [colours.menu_text_disabled, colours.menu_background, text]
    if "spotify-liked" in tr.misc:
        text = _("Un-like Spotify Track")

    return [colours.menu_text, colours.menu_background, text]

def spot_like_show_test(x):

    return spotify_show_test and pctl.g(r_menu_index).file_ext == "SPTY"

def spot_heart_menu_colour():
    tr = pctl.g(r_menu_index)
    if tr and "spotify-liked" in tr.misc:
        return [30, 215, 96, 255]
    else:
        return None

heart_spot_icon = MenuIcon(asset_loader('heart-menu.png', True))
heart_spot_icon.colour = [30, 215, 96, 255]
heart_spot_icon.xoff = 1
heart_spot_icon.yoff = 0
heart_spot_icon.colour_callback = spot_heart_menu_colour

track_menu.add(MenuItem('Spotify Like Track', toggle_spotify_like_ref, toggle_spotify_like_row_deco, show_test=spot_like_show_test, icon=heart_spot_icon))


def add_to_queue(ref):
    pctl.force_queue.append(queue_item_gen(ref, r_menu_position, pl_to_id(pctl.active_playlist_viewing)))
    queue_timer_set()
    if prefs.stop_end_queue:
        pctl.auto_stop = False


def add_selected_to_queue():
    gui.pl_update += 1
    if prefs.stop_end_queue:
        pctl.auto_stop = False
    if gui.album_tab_mode:
        add_album_to_queue(default_playlist[get_album_info(pctl.selected_in_playlist)[1][0]], pctl.selected_in_playlist)
        queue_timer_set()
    else:
        pctl.force_queue.append(queue_item_gen(default_playlist[pctl.selected_in_playlist],
                                               pctl.selected_in_playlist,
                                               pl_to_id(pctl.active_playlist_viewing)))
        queue_timer_set()


def add_selected_to_queue_multi():
    if prefs.stop_end_queue:
        pctl.auto_stop = False
    for index in shift_selection:
        pctl.force_queue.append(queue_item_gen(default_playlist[index],
                                               index,
                                               pl_to_id(pctl.active_playlist_viewing)))


def queue_timer_set(plural=False, queue_object=None):
    queue_add_timer.set()
    gui.frame_callback_list.append(TestTimer(2.51))
    gui.queue_toast_plural = plural
    if queue_object:
        gui.toast_queue_object = queue_object
    else:
        if pctl.force_queue:
            gui.toast_queue_object = pctl.force_queue[-1]


def split_queue_album(id):
    item = pctl.force_queue[0]

    pl = id_to_pl(item[2])
    if pl is None:
        return

    playlist = pctl.multi_playlist[pl][2]

    i = pctl.playlist_playing_position + 1
    parts = []
    album_parent_path = pctl.g(item[0]).parent_folder_path

    while i < len(playlist):
        if pctl.g(playlist[i]).parent_folder_path != album_parent_path:
            break

        parts.append((playlist[i], i))
        i += 1

    del pctl.force_queue[0]

    for part in reversed(parts):
        pctl.force_queue.insert(0, queue_item_gen(part[0], part[1], item[3]))
    return (len(parts))


def add_to_queue_next(ref):
    if pctl.force_queue and pctl.force_queue[0][4] == 1:
        split_queue_album(None)

    pctl.force_queue.insert(0, queue_item_gen(ref, r_menu_position, pl_to_id(pctl.active_playlist_viewing)))


# def toggle_queue(mode=0):
#     if mode == 1:
#         return prefs.show_queue
#     prefs.show_queue ^= True
#     prefs.show_queue ^= True


track_menu.add(MenuItem(_('Add to Queue'), add_to_queue, pass_ref=True, hint="MB3"))

track_menu.add(MenuItem(_('↳ After Current Track'), add_to_queue_next, pass_ref=True, show_test=test_shift))

track_menu.add(MenuItem(_('Show in Gallery'), show_in_gal, pass_ref=True, show_test=test_show))

track_menu.add_sub(_("Meta…"), 160)

track_menu.br()
# track_menu.add('Cut', s_cut, pass_ref=False)
# track_menu.add('Remove', del_selected)
track_menu.add(MenuItem(_('Copy'), s_copy, pass_ref=False))

# track_menu.add(_('Paste + Transfer Folder'), lightning_paste, pass_ref=False, show_test=lightning_move_test)

track_menu.add(MenuItem(_('Paste'), menu_paste, paste_deco, pass_ref=True))


def delete_track(track_ref):
    tr = pctl.g(track_ref)
    fullpath = tr.fullpath

    if system == "windows" or msys:
        fullpath = fullpath.replace("/", "\\")

    if tr.is_network:
        show_message(_("Cannot delete a network track"))
        return

    while track_ref in default_playlist:
        default_playlist.remove(track_ref)

    try:
        send2trash(fullpath)

        if os.path.exists(fullpath):
            try:
                os.remove(fullpath)
                show_message(_("File deleted"), fullpath, mode='info')
            except:
                show_message(_("Error deleting file"), fullpath, mode='error')
        else:
            show_message(_("File moved to trash"))

    except:
        try:
            os.remove(fullpath)
            show_message(_("File deleted"), fullpath, mode='info')
        except:
            show_message(_("Error deleting file"), fullpath, mode='error')

    reload()
    refind_playing()
    pctl.notify_change()


track_menu.add(MenuItem(_('Delete Track File'), delete_track, pass_ref=True, icon=delete_icon, show_test=test_shift))

track_menu.br()


def rename_tracks_deco(track_id):
    if key_shift_down or key_shiftr_down:
        return [colours.menu_text, colours.menu_background, _("Rename (Single track)")]
    else:
        return [colours.menu_text, colours.menu_background, _("Rename Tracks…")]


# rename_tracks_icon.colour = [244, 241, 66, 255]
# rename_tracks_icon.colour = [204, 255, 66, 255]
rename_tracks_icon.colour = [204, 100, 205, 255]
rename_tracks_icon.xoff = 1
track_menu.add_to_sub(0, MenuItem("Rename Tracks…", rename_track_box.activate, rename_tracks_deco, pass_ref=True,
                      pass_ref_deco=True, icon=rename_tracks_icon, disable_test=rename_track_box.disable_test))


def activate_trans_editor():
    trans_edit_box.active = True


track_menu.add_to_sub(0, MenuItem(_("Edit fields…"), activate_trans_editor))


def delete_folder(index, force=False):
    track = pctl.master_library[index]

    if track.is_network:
        show_message(_("Cannot physically delete"), _("One or more tracks is from a network location!"), mode='info')
        return

    old = track.parent_folder_path

    if len(old) < 5:
        show_message("This folder path seems short, I don't wanna try delete that", mode='warning')
        return

    if not os.path.exists(old):
        show_message("Error deleting folder. The folder seems to be missing.", "It's gone! Just gone!", mode='error')
        return

    protect = ("", "Documents", "Music", "Desktop", "Downloads")

    for fo in protect:
        if old.strip('\\/') == os.path.join(os.path.expanduser('~'), fo).strip("\\/"):
            show_message("Woah, careful there!", "I don't think we should delete that folder.", mode='warning')
            return

    if directory_size(old) > 1500000000:
        show_message(_("Delete size safety limit reached!") + " (1.5GB)", old, mode='warning')
        return

    try:

        if pctl.playing_state > 0 and os.path.normpath(
                pctl.master_library[pctl.track_queue[pctl.queue_step]].parent_folder_path) == os.path.normpath(old):
            pctl.stop(True)

        if force:
            shutil.rmtree(old)
        else:
            if system == "windows" or msys:
                send2trash(old.replace("/", "\\"))
            else:
                send2trash(old)

        for i in reversed(range(len(default_playlist))):

            if old == pctl.master_library[default_playlist[i]].parent_folder_path:
                del default_playlist[i]

        if not os.path.exists(old):
            if force:
                show_message("Folder deleted.", old, mode='done')
            else:
                show_message("Folder sent to trash.", old, mode='done')
        else:
            show_message("Hmm, its still there", old, mode='error')

        if album_mode:
            prep_gal()
            reload_albums()

    except:
        if force:
            show_message("Unable to comply.", "Could not delete folder. Try check permissions.", mode='error')
        else:
            show_message(_("Folder could not be trashed."), "Try again while holding shift to force delete.",
                         mode='error')

    tree_view_box.clear_target_pl(pctl.active_playlist_viewing)
    gui.pl_update += 1
    pctl.notify_change()


def rename_parent(index, template):
    # template = prefs.rename_folder_template
    template = template.strip("/\\")
    track = pctl.master_library[index]

    if track.is_network:
        show_message("Cannot rename", "One or more tracks is from a network location!", mode='info')
        return

    old = track.parent_folder_path
    # print(old)

    new = parse_template2(template, track)

    if len(new) < 1:
        show_message("Rename error.", "The generated name is too short", mode='warning')
        return

    if len(old) < 5:
        show_message("Rename error.", "This folder path seems short, I don't wanna try rename that", mode='warning')
        return

    if not os.path.exists(old):
        show_message("Rename Failed. The original folder is missing.", mode='warning')
        return

    protect = ("", "Documents", "Music", "Desktop", "Downloads")

    for fo in protect:
        if os.path.normpath(old) == os.path.normpath(os.path.join(os.path.expanduser('~'), fo)):
            show_message("Woah, careful there!", "I don't think we should rename that folder.", mode='warning')
            return

    print(track.parent_folder_path)
    re = os.path.dirname(track.parent_folder_path.rstrip("/\\"))
    print(re)
    new_parent_path = os.path.join(re, new)
    print(new_parent_path)

    pre_state = 0

    for key, object in pctl.master_library.items():

        if object.fullpath == "":
            continue

        if old == object.parent_folder_path:

            new_fullpath = os.path.join(new_parent_path, object.filename)

            if os.path.normpath(new_parent_path) == os.path.normpath(old):
                show_message("The folder already has that name.")
                return

            if os.path.exists(new_parent_path):
                show_message("Rename Failed.", "A folder with that name already exists", mode='warning')
                return

            if key == pctl.track_queue[pctl.queue_step] and pctl.playing_state > 0:
                pre_state = pctl.stop(True)

            object.parent_folder_name = new
            object.parent_folder_path = new_parent_path
            object.fullpath = new_fullpath

            search_string_cache.pop(object.index, None)
            search_dia_string_cache.pop(object.index, None)

        # Fix any other tracks paths that contain the old path
        if os.path.normpath(object.fullpath)[:len(old)] == os.path.normpath(old) \
                and os.path.normpath(object.fullpath)[len(old)] in ('/', '\\'):
            object.fullpath = os.path.join(new_parent_path, object.fullpath[len(old):].lstrip('\\/'))
            object.parent_folder_path = os.path.join(new_parent_path,
                                                     object.parent_folder_path[len(old):].lstrip('\\/'))

            search_string_cache.pop(object.index, None)
            search_dia_string_cache.pop(object.index, None)

    if new_parent_path is not None:
        try:
            os.rename(old, new_parent_path)
            print(new_parent_path)
        except:

            show_message("Rename Failed!", mode='error' "Something went wrong, sorry.")
            return

    show_message("Folder renamed.", "Renamed to: " + new, mode='done')

    if pre_state == 1:
        pctl.revert()

    tree_view_box.clear_target_pl(pctl.active_playlist_viewing)
    pctl.notify_change()


def rename_folders_disable_test(index):
    return pctl.g(index).is_network

def rename_folders(index):
    global track_box
    global rename_index
    global input_text

    track_box = False
    rename_index = index

    if rename_folders_disable_test(index):
        show_message("Not applicable for a network track.")
        return

    gui.rename_folder_box = True
    input_text = ""
    shift_selection.clear()

    global quick_drag
    global playlist_hold
    quick_drag = False
    playlist_hold = False


mod_folder_icon.colour = [229, 98, 98, 255]
track_menu.add_to_sub(0, MenuItem(_("Modify Folder…"), rename_folders, pass_ref=True, pass_ref_deco=True, icon=mod_folder_icon, disable_test=rename_folders_disable_test))


def move_folder_up(index, do=False):
    track = pctl.master_library[index]

    if track.is_network:
        show_message("Cannot move", "One or more tracks is from a network location!", mode='info')
        return

    parent_folder = os.path.dirname(track.parent_folder_path)
    folder_name = track.parent_folder_name
    move_target = track.parent_folder_path
    upper_folder = os.path.dirname(parent_folder)

    if not os.path.exists(track.parent_folder_path):
        if do:
            show_message("Error shifting directory", "The directory does not appear to exist", mode='warning')
        return False

    if len(os.listdir(parent_folder)) > 1:
        return False

    if do is False:
        return True

    pre_state = 0
    if pctl.playing_state > 0 and track.parent_folder_path in pctl.playing_object().parent_folder_path:
        pre_state = pctl.stop(True)

    try:

        # Rename the track folder to something temporary
        os.rename(move_target, os.path.join(parent_folder, "RMTEMP000"))

        # Move the temporary folder up 2 levels
        shutil.move(os.path.join(parent_folder, "RMTEMP000"), upper_folder)

        # Delete the old directory that contained the original folder
        shutil.rmtree(parent_folder)

        # Rename the moved folder back to its original name
        os.rename(os.path.join(upper_folder, "RMTEMP000"), os.path.join(upper_folder, folder_name))

    except Exception as e:
        show_message("System Error!", str(e), mode='error')

    # Fix any other tracks paths that contain the old path
    old = track.parent_folder_path
    new_parent_path = os.path.join(upper_folder, folder_name)
    for key, object in pctl.master_library.items():

        if os.path.normpath(object.fullpath)[:len(old)] == os.path.normpath(old) \
                and os.path.normpath(object.fullpath)[len(old)] in ('/', '\\'):
            object.fullpath = os.path.join(new_parent_path, object.fullpath[len(old):].lstrip('\\/'))
            object.parent_folder_path = os.path.join(new_parent_path,
                                                     object.parent_folder_path[len(old):].lstrip('\\/'))

            search_string_cache.pop(object.index, None)
            search_dia_string_cache.pop(object.index, None)

            print(object.fullpath)
            print(object.parent_folder_path)

    if pre_state == 1:
        pctl.revert()


def clean_folder(index, do=False):
    track = pctl.master_library[index]

    if track.is_network:
        show_message("Cannot clean", "One or more tracks is from a network location!", mode='info')
        return

    folder = track.parent_folder_path
    found = 0
    to_purge = []
    if not os.path.isdir(folder):
        return 0
    try:
        for item in os.listdir(folder):
            if ('AlbumArt' == item[:8] and '.jpg' in item.lower()) \
                    or 'desktop.ini' == item \
                    or 'Thumbs.db' == item \
                    or '.DS_Store' == item:

                to_purge.append(item)
                found += 1
            elif "__MACOSX" == item and os.path.isdir(os.path.join(folder, item)):
                found += 1
                found += 1
                if do:
                    print("Deleting Folder: " + os.path.join(folder, item))
                    shutil.rmtree(os.path.join(folder, item))

        if do:
            for item in to_purge:
                if os.path.isfile(os.path.join(folder, item)):
                    print('Deleting File: ' + os.path.join(folder, item))
                    os.remove(os.path.join(folder, item))
            # clear_img_cache()

            for track_id in default_playlist:
                if pctl.g(track_id).parent_folder_path == folder:
                    clear_track_image_cache(pctl.g(track_id))

    except Exception as e:
        # show_message(str(e))
        show_message("Error deleting files.", "May not have permission or file may be set to read-only", mode='warning')
        return 0

    return found


def reset_play_count(index):
    star_store.remove(index)


# track_menu.add_to_sub("Reset Track Play Count", 0, reset_play_count, pass_ref=True)


def vacuum_playtimes(index):
    todo = []
    for k in default_playlist:
        if pctl.master_library[index].parent_folder_name == pctl.master_library[k].parent_folder_name:
            todo.append(k)

    for track in todo:

        tr = pctl.g(track)

        total_playtime = 0
        flags = ""

        to_del = []

        for key, value in star_store.db.items():
            if key[0].lower() == tr.artist.lower() and tr.artist and key[1].lower().replace(" ",
                                                                                            "") == tr.title.lower().replace(
                    " ", "") and tr.title:
                to_del.append(key)
                total_playtime += value[0]
                flags = "".join(set(flags + value[1]))

        for key in to_del:
            del star_store.db[key]

        key = star_store.object_key(tr)
        value = [total_playtime, flags, 0]
        if key not in star_store.db:
            print("Saving value")
            star_store.db[key] = value
        else:
            print("ERROR KEY ALREADY HERE?")


def reload_metadata(input, keep_star=True):
    global todo

    # vacuum_playtimes(index)
    # return
    todo = []

    if isinstance(input, list):
        todo = input

    else:
        for k in default_playlist:
            if pctl.master_library[input].parent_folder_path == pctl.master_library[k].parent_folder_path:
                todo.append(pctl.master_library[k])

    for i in reversed(range(len(todo))):
        if todo[i].is_cue:
            del todo[i]

    for track in todo:

        search_string_cache.pop(track.index, None)
        search_dia_string_cache.pop(track.index, None)

        #print('Reloading Metadata for ' + track.filename)
        if keep_star:
            to_scan.append(track.index)
        else:
            # if keep_star:
            #     star = star_store.full_get(track.index)
            #     star_store.remove(track.index)

            pctl.master_library[track.index] = tag_scan(track)

            # if keep_star:
            #     if star is not None and (star[0] > 0 or star[1] or star[2] > 0):
            #         star_store.merge(track.index, star)

            pctl.notify_change()

    gui.pl_update += 1
    tm.ready("worker")


def reload_metadata_selection():
    cargo = []
    for item in shift_selection:
        cargo.append(default_playlist[item])

    for k in cargo:
        if pctl.master_library[k].is_cue == False:
            to_scan.append(k)
    tm.ready("worker")



def editor(index):
    todo = []
    obs = []

    if key_shift_down and index is not None:
        todo = [index]
        obs = [pctl.master_library[index]]
    else:
        if index is None:
            for item in shift_selection:
                todo.append(default_playlist[item])
                obs.append(pctl.master_library[default_playlist[item]])
            if len(todo) > 0:
                index = todo[0]
        else:
            for k in default_playlist:
                if pctl.master_library[index].parent_folder_path == pctl.master_library[k].parent_folder_path:
                    if pctl.master_library[k].is_cue == False:
                        todo.append(k)
                        obs.append(pctl.master_library[k])

    # Keep copy of play times
    old_stars = []
    for track in todo:
        item = []
        item.append(pctl.g(track))
        item.append(star_store.key(track))
        item.append(star_store.full_get(track))
        old_stars.append(item)

    file_line = ""
    for track in todo:
        file_line += ' "'
        file_line += pctl.master_library[track].fullpath
        file_line += '"'

    if system == "windows" or msys:
        file_line = file_line.replace("/", "\\")

    prefix = ""
    app = prefs.tag_editor_target

    if (system == "windows" or msys) and app:
        if app[0] != '"':
            app = '"' + app
        if app[-1] != '"':
            app = app + '"'

    app_switch = ""

    ok = False

    prefix = launch_prefix

    if system == "linux":
        ok = whicher(prefs.tag_editor_target)
    else:

        if not os.path.isfile(prefs.tag_editor_target.strip('"')):
            print(prefs.tag_editor_target)
            show_message("Application not found", prefs.tag_editor_target, mode='info')
            return

        ok = True

    if not ok:
        show_message(_("Tag editor app does not appear to be installed."), mode='warning')

        if flatpak_mode:
            show_message(_("App not found on host OR insufficient Flatpak permissions."),
                         'See https://github.com/Taiko2k/Tauon/wiki/Flatpak-Extra-Steps for details.',
                         mode='bubble')

        return

    if 'picard' in prefs.tag_editor_target:
        app_switch = " --d "

    line = prefix + app + app_switch + file_line

    show_message(prefs.tag_editor_name + " launched.", "Fields will be updated once application is closed.",
                 mode='arrow')
    gui.update = 1

    complete = subprocess.run(shlex.split(line), stdout=subprocess.PIPE, stderr=subprocess.PIPE)

    if 'picard' in prefs.tag_editor_target:
        r = complete.stderr.decode()
        for line in r.split("\n"):
            if 'file._rename' in line and ' Moving file ' in line:
                a, b = line.split(" Moving file ")[1].split(" => ")
                a = a.strip("'").strip('"')
                b = b.strip("'").strip('"')

                for track in todo:
                    if pctl.master_library[track].fullpath == a:
                        pctl.master_library[track].fullpath = b
                        pctl.master_library[track].filename = os.path.basename(b)
                        print("External Edit: File rename detected.")
                        print("    Renaming: " + a)
                        print("          To: " + b)
                        break
                else:
                    print("External Edit: A file rename was detected but track was not found.")

    gui.message_box = False
    reload_metadata(obs, keep_star=False)

    # Re apply playtime data in case file names change
    for item in old_stars:

        old_key = item[1]
        old_value = item[2]

        if not old_value:  # ignore if there was no old playcount metadata
            continue

        new_key = star_store.object_key(item[0])
        new_value = star_store.full_get(item[0].index)

        if old_key == new_key:
            continue

        if new_value is None:
            new_value = [0, "", 0]

        new_value[0] += old_value[0]
        new_value[1] = "".join(set(new_value[1] + old_value[1]))

        if old_key in star_store.db:
            del star_store.db[old_key]

        star_store.db[new_key] = new_value

    gui.pl_update = 1
    gui.update = 1
    pctl.notify_change()


def launch_editor(index):
    if snap_mode:
        show_message("Sorry, this feature isn't (yet) available with Snap.")
        return

    if launch_editor_disable_test(index):
        show_message("Cannot edit tags of a network track.")
        return

    mini_t = threading.Thread(target=editor, args=[index])
    mini_t.daemon = True
    mini_t.start()

def launch_editor_selection_disable_test(index):
    for position in shift_selection:
        if pctl.g(default_playlist[position]).is_network:
            return True
    return False

def launch_editor_selection(index):
    if launch_editor_selection_disable_test(index):
        show_message("Cannot edit tags of a network track.")
        return

    mini_t = threading.Thread(target=editor, args=[None])
    mini_t.daemon = True
    mini_t.start()


# track_menu.add('Reload Metadata', reload_metadata, pass_ref=True)
track_menu.add_to_sub(0, MenuItem(_("Rescan Tags"), reload_metadata, pass_ref=True))

mbp_icon = MenuIcon(asset_loader('mbp-g.png'))
mbp_icon.base_asset = asset_loader('mbp-gs.png')

mbp_icon.xoff = 2
mbp_icon.yoff = -1

if gui.scale == 1.25:
    mbp_icon.yoff = 0

edit_icon = None
if prefs.tag_editor_name == "Picard":
    edit_icon = mbp_icon


def edit_deco(index):
    if key_shift_down or key_shiftr_down:
        return [colours.menu_text, colours.menu_background, prefs.tag_editor_name + " (Single track)"]
    else:
        return [colours.menu_text, colours.menu_background, _("Edit with ") + prefs.tag_editor_name]

def launch_editor_disable_test(index):
    return pctl.g(index).is_network

track_menu.add_to_sub(0, MenuItem("Edit with", launch_editor, pass_ref=True, pass_ref_deco=True, icon=edit_icon, render_func=edit_deco, disable_test=launch_editor_disable_test))


def show_lyrics_menu(index):
    global track_box
    track_box = False
    enter_showcase_view(track_id=r_menu_index)
    inp.mouse_click = False


track_menu.add_to_sub(0, MenuItem(_("Lyrics..."), show_lyrics_menu, pass_ref=True))


def recode(text, enc):
    return text.encode("Latin-1", 'ignore').decode(enc, 'ignore')


def intel_moji(index):
    gui.pl_update += 1
    gui.update += 1

    track = pctl.master_library[index]

    lot = []

    for item in default_playlist:

        if track.album == pctl.master_library[item].album and \
                track.parent_folder_name == pctl.master_library[item].parent_folder_name:
            lot.append(item)

    lot = set(lot)

    l_artist = track.artist.encode("Latin-1", 'ignore')
    l_album = track.album.encode("Latin-1", 'ignore')
    detect = None

    if track.artist not in track.parent_folder_path:
        for enc in encodings:
            try:
                q_artist = l_artist.decode(enc, )
                if q_artist.strip(" ") in track.parent_folder_path.strip(" "):
                    detect = enc
                    break
            except:
                continue

    if detect is None and track.album not in track.parent_folder_path:
        for enc in encodings:
            try:
                q_album = l_album.decode(enc, )
                if q_album in track.parent_folder_path:
                    detect = enc
                    break
            except:
                continue

    for item in lot:
        t_track = pctl.master_library[item]

        if detect is None:
            for enc in encodings:
                test = recode(t_track.artist, enc)
                for cha in test:
                    if cha in j_chars:
                        detect = enc
                        print("This looks like Japanese: " + test)
                        break
                    if detect is not None:
                        break

        if detect is None:
            for enc in encodings:
                test = recode(t_track.title, enc)
                for cha in test:
                    if cha in j_chars:
                        detect = enc
                        print("This looks like Japanese: " + test)
                        break
                    if detect is not None:
                        break
        if detect is not None:
            break

    if detect is not None:
        print("Fix Mojibake: Detected encoding as: " + detect)
        for item in lot:
            track = pctl.master_library[item]
            # key = pctl.master_library[item].title + pctl.master_library[item].filename
            key = star_store.full_get(item)
            star_store.remove(item)

            track.title = recode(track.title, detect)
            track.album = recode(track.album, detect)
            track.artist = recode(track.artist, detect)
            track.album_artist = recode(track.album_artist, detect)
            track.genre = recode(track.genre, detect)
            track.comment = recode(track.comment, detect)
            track.lyrics = recode(track.lyrics, detect)

            if key != None:
                star_store.insert(item, key)

            search_string_cache.pop(track.index, None)
            search_dia_string_cache.pop(track.index, None)

    else:
        show_message("Autodetect failed")


track_menu.add_to_sub(0, MenuItem(_("Fix Mojibake"), intel_moji, pass_ref=True))


def sel_to_car():
    global default_playlist
    cargo = []

    for item in shift_selection:
        cargo.append(default_playlist[item])


# track_menu.add_to_sub("Copy Playlist", 1, transfer, pass_ref=True, args=[1, 3])
def cut_selection():
    sel_to_car()
    del_selected()


def clip_ar_al(index):
    line = pctl.master_library[index].artist + " - " + \
           pctl.master_library[index].album
    SDL_SetClipboardText(line.encode('utf-8'))


def clip_ar(index):
    if pctl.master_library[index].album_artist != "":
        line = pctl.master_library[index].album_artist
    else:
        line = pctl.master_library[index].artist
    SDL_SetClipboardText(line.encode('utf-8'))


def clip_title(index):
    n_track = pctl.master_library[index]

    if not prefs.use_title and n_track.album_artist != "" and n_track.album != "":
        line = n_track.album_artist + " - " + n_track.album
    else:
        line = n_track.parent_folder_name

    SDL_SetClipboardText(line.encode('utf-8'))


selection_menu = Menu(200, show_icons=False)
folder_menu = Menu(193, show_icons=True)

folder_menu.add(MenuItem(_('Open Folder'), open_folder, pass_ref=True, pass_ref_deco=True, icon=folder_icon, disable_test=open_folder_disable_test))

folder_menu.add(MenuItem(_("Modify Folder…"), rename_folders, pass_ref=True, pass_ref_deco=True, icon=mod_folder_icon, disable_test=rename_folders_disable_test))
folder_tree_menu.add(MenuItem(_("Modify Folder…"), rename_folders, pass_ref=True, pass_ref_deco=True, icon=mod_folder_icon, disable_test=rename_folders_disable_test))
# folder_menu.add(_("Add Album to Queue"), add_album_to_queue, pass_ref=True)
folder_menu.add(MenuItem(_("Add Album to Queue"), add_album_to_queue, pass_ref=True))
folder_menu.add(MenuItem(_("Enqueue Album Next"), add_album_to_queue_fc, pass_ref=True))

gallery_menu.add(MenuItem(_("Modify Folder…"), rename_folders, pass_ref=True, pass_ref_deco=True, icon=mod_folder_icon, disable_test=rename_folders_disable_test))

folder_menu.add(MenuItem(_("Rename Tracks…"), rename_track_box.activate, rename_tracks_deco, pass_ref=True,
                pass_ref_deco=True, icon=rename_tracks_icon, disable_test=rename_track_box.disable_test))
folder_tree_menu.add(MenuItem(_("Rename Tracks…"), rename_track_box.activate, pass_ref=True, pass_ref_deco=True, icon=rename_tracks_icon, disable_test=rename_track_box.disable_test))

if not snap_mode:
    folder_menu.add(MenuItem("Edit with", launch_editor_selection, pass_ref=True,
                    pass_ref_deco=True, icon=edit_icon, render_func=edit_deco, disable_test=launch_editor_selection_disable_test))

folder_tree_menu.add(MenuItem(_("Add Album to Queue"), add_album_to_queue, pass_ref=True))
folder_tree_menu.add(MenuItem(_("Enqueue Album Next"), add_album_to_queue_fc, pass_ref=True))

folder_tree_menu.br()
folder_tree_menu.add(MenuItem(_('Collapse All'), collapse_tree, collapse_tree_deco))
folder_tree_menu.add(MenuItem("lock", lock_folder_tree, lock_folder_tree_deco))


def lightning_copy():
    s_copy()
    gui.lightning_copy = True


# selection_menu.br()

def toggle_transcode(mode=0):
    if mode == 1:
        return prefs.enable_transcode
    prefs.enable_transcode ^= True


def toggle_chromecast(mode=0):
    if mode == 1:
        return prefs.show_chromecast
    prefs.show_chromecast ^= True


def toggle_transfer(mode=0):
    if mode == 1:
        return prefs.show_transfer
    prefs.show_transfer ^= True

    if prefs.show_transfer:
        show_message("Warning! Using this function moves physical folders.",
                     "This menu entry appears after selecting 'copy'. See manual (github wiki) for more info.",
                     mode='info')


transcode_icon.colour = [239, 74, 157, 255]


def transcode_deco():
    if key_shift_down or key_shiftr_down:
        return [colours.menu_text, colours.menu_background, _("Transcode Single")]
    else:
        return [colours.menu_text, colours.menu_background, _('Transcode Folder')]


folder_menu.add(MenuItem(_('Rescan Tags'), reload_metadata, pass_ref=True))
folder_menu.add(MenuItem(_("Edit fields…"), activate_trans_editor))
folder_menu.add(MenuItem(_('Vacuum Playtimes'), vacuum_playtimes, pass_ref=True, show_test=test_shift))
folder_menu.add(MenuItem(_('Transcode Folder'), convert_folder, transcode_deco, pass_ref=True, icon=transcode_icon,
                show_test=toggle_transcode))
gallery_menu.add(MenuItem(_('Transcode Folder'), convert_folder, transcode_deco, pass_ref=True, icon=transcode_icon,
                 show_test=toggle_transcode))
folder_menu.br()

spot_ctl = SpotCtl(tauon)
tauon.spot_ctl = spot_ctl

spot_ctl.cache_saved_albums = spot_cache_saved_albums

# Copy album title text to clipboard
folder_menu.add(MenuItem(_('Copy "Artist - Album"'), clip_title, pass_ref=True))


def get_album_spot_url(track_id):
    track_object = pctl.g(track_id)
    url = spot_ctl.get_album_url_from_local(track_object)
    if url:
        copy_to_clipboard(url)
        show_message(_("URL copied to clipboard"), mode="done")
    else:
        show_message(_("No results found"))


def get_album_spot_url_deco(track_id):
    track_object = pctl.g(track_id)
    if "spotify-album-url" in track_object.misc:
        text = _("Copy Spotify Album URL")
    else:
        text = _("Lookup Spotify Album URL")
    return [colours.menu_text, colours.menu_background, text]


folder_menu.add(MenuItem('Lookup Spotify Album URL', get_album_spot_url, get_album_spot_url_deco, pass_ref=True,
                pass_ref_deco=True, show_test=spotify_show_test, icon=spot_icon))


def add_to_spotify_library_deco(track_id):
    track_object = pctl.g(track_id)
    text = _("Save Album to Spotify")
    if track_object.file_ext != "SPTY":
        return (colours.menu_text_disabled, colours.menu_background, text)

    album_url = track_object.misc.get("spotify-album-url")
    if album_url and album_url in spot_ctl.cache_saved_albums:
        text = _("Un-save Spotify Album")

    return (colours.menu_text, colours.menu_background, text)


def add_to_spotify_library2(album_url):
    if album_url in spot_ctl.cache_saved_albums:
        spot_ctl.remove_album_from_library(album_url)
    else:
        spot_ctl.add_album_to_library(album_url)

    for i, p in enumerate(pctl.multi_playlist):
        code = pctl.gen_codes.get(p[6])
        if code and code.startswith("sal"):
            print("Fetching Spotify Library...")
            regenerate_playlist(i, silent=True)


def add_to_spotify_library(track_id):
    track_object = pctl.g(track_id)
    album_url = track_object.misc.get("spotify-album-url")
    if track_object.file_ext != "SPTY" or not album_url:
        return

    shoot_dl = threading.Thread(target=add_to_spotify_library2, args=([album_url]))
    shoot_dl.daemon = True
    shoot_dl.start()


folder_menu.add(MenuItem('Add to Spotify Library', add_to_spotify_library, add_to_spotify_library_deco, pass_ref=True,
                pass_ref_deco=True, show_test=spotify_show_test, icon=spot_icon))


# Copy artist name text to clipboard
# folder_menu.add(_('Copy "Artist"'), clip_ar, pass_ref=True)

def selection_queue_deco():
    total = 0
    for item in shift_selection:
        total += pctl.g(default_playlist[item]).length

    total = get_hms_time(total)

    text = (_('Queue %d') % len(shift_selection)) + f" [{total}]"

    return [colours.menu_text, colours.menu_background, text]


selection_menu.add(MenuItem(_('Add to queue'), add_selected_to_queue_multi, selection_queue_deco))

selection_menu.br()

selection_menu.add(MenuItem(_('Rescan Tags'), reload_metadata_selection))

selection_menu.add(MenuItem(_("Edit fields…"), activate_trans_editor))

selection_menu.add(MenuItem("Edit with ", launch_editor_selection, pass_ref=True, pass_ref_deco=True, icon=edit_icon, render_func=edit_deco, disable_test=launch_editor_selection_disable_test))

selection_menu.br()
folder_menu.br()

# It's complicated
# folder_menu.add(_('Copy Folder From Library'), lightning_copy)

selection_menu.add(MenuItem(_('Copy'), s_copy))
selection_menu.add(MenuItem(_('Cut'), s_cut))
selection_menu.add(MenuItem(_('Remove'), del_selected))
selection_menu.add(MenuItem(_('Delete Files'), force_del_selected, show_test=test_shift, icon=delete_icon))

folder_menu.add(MenuItem(_('Copy'), s_copy))
gallery_menu.add(MenuItem(_('Copy'), s_copy))
# folder_menu.add(_('Cut'), s_cut)
# folder_menu.add(_('Paste + Transfer Folder'), lightning_paste, pass_ref=False, show_test=lightning_move_test)
# gallery_menu.add(_('Paste + Transfer Folder'), lightning_paste, pass_ref=False, show_test=lightning_move_test)
folder_menu.add(MenuItem(_('Remove'), del_selected))
gallery_menu.add(MenuItem(_('Remove'), del_selected))


def toggle_rym(mode=0):
    if mode == 1:
        return prefs.show_rym
    prefs.show_rym ^= True


def toggle_band(mode=0):
    if mode == 1:
        return prefs.show_band
    prefs.show_band ^= True


def toggle_wiki(mode=0):
    if mode == 1:
        return prefs.show_wiki
    prefs.show_wiki ^= True


# def toggle_show_discord(mode=0):
#     if mode == 1:
#         return prefs.discord_show
#     if prefs.discord_show is False and discord_allow is False:
#         show_message("Warning: pypresence package not installed")
#     prefs.discord_show ^= True

def toggle_gen(mode=0):
    if mode == 1:
        return prefs.show_gen
    prefs.show_gen ^= True


def ser_band_done(result):
    if result:
        webbrowser.open(result, new=2, autoraise=True)
        gui.message_box = False
        gui.update += 1
    else:
        show_message(_("No matching artist result found"))


def ser_band(track_id):
    tr = pctl.g(track_id)
    if tr.artist:
        shoot_dl = threading.Thread(target=bandcamp_search, args=([tr.artist, ser_band_done]))
        shoot_dl.daemon = True
        shoot_dl.start()
        show_message(_("Searching..."))


def ser_rym(index):
    if len(pctl.master_library[index].artist) < 2:
        return
    line = "http://rateyourmusic.com/search?searchtype=a&searchterm=" + urllib.parse.quote(
        pctl.master_library[index].artist)
    webbrowser.open(line, new=2, autoraise=True)


def copy_to_clipboard(text):
    SDL_SetClipboardText(text.encode(errors='surrogateescape'))


def copy_from_clipboard():
    return SDL_GetClipboardText().decode()


def clip_aar_al(index):
    if pctl.master_library[index].album_artist == "":
        line = pctl.master_library[index].artist + " - " + \
               pctl.master_library[index].album
    else:
        line = pctl.master_library[index].album_artist + " - " + \
               pctl.master_library[index].album
    SDL_SetClipboardText(line.encode('utf-8'))


def ser_gen_thread(tr):
    s_artist = tr.artist
    s_title = tr.title

    if s_artist in prefs.lyrics_subs:
        s_artist = prefs.lyrics_subs[s_artist]
    if s_title in prefs.lyrics_subs:
        s_title = prefs.lyrics_subs[s_title]

    line = genius(s_artist, s_title, return_url=True)

    r = requests.head(line)

    if r.status_code != 404:
        webbrowser.open(line, new=2, autoraise=True)
        gui.message_box = False
    else:
        line = "https://genius.com/search?q=" + urllib.parse.quote(f"{s_artist} {s_title}")
        webbrowser.open(line, new=2, autoraise=True)
        gui.message_box = False


def ser_gen(track_id, get_lyrics=False):
    tr = pctl.master_library[track_id]
    if len(tr.title) < 1:
        return

    show_message(_("Searching..."))

    shoot = threading.Thread(target=ser_gen_thread, args=[tr])
    shoot.daemon = True
    shoot.start()


def ser_wiki(index):
    if len(pctl.master_library[index].artist) < 2:
        return
    line = "http://en.wikipedia.org/wiki/Special:Search?search=" + \
           urllib.parse.quote(pctl.master_library[index].artist)
    webbrowser.open(line, new=2, autoraise=True)


track_menu.add(MenuItem(_('Search Artist on Wikipedia'), ser_wiki, pass_ref=True, show_test=toggle_wiki))

track_menu.add(MenuItem(_('Search Track on Genius'), ser_gen, pass_ref=True, show_test=toggle_gen))

son_icon = MenuIcon(asset_loader('sonemic-g.png'))
son_icon.base_asset = asset_loader('sonemic-gs.png')

son_icon.xoff = 1
track_menu.add(MenuItem(_('Search Artist on Sonemic'), ser_rym, pass_ref=True, icon=son_icon, show_test=toggle_rym))

band_icon = MenuIcon(asset_loader('band.png', True))
band_icon.xoff = 0
band_icon.yoff = 1
band_icon.colour = [96, 147, 158, 255]

track_menu.add(MenuItem(_('Search Artist on Bandcamp'), ser_band, pass_ref=True, icon=band_icon, show_test=toggle_band))


def clip_ar_tr(index):
    line = pctl.master_library[index].artist + " - " + \
           pctl.master_library[index].title

    SDL_SetClipboardText(line.encode('utf-8'))


# Copy metadata to clipboard
# track_menu.add(_('Copy "Artist - Album"'), clip_aar_al, pass_ref=True)
# Copy metadata to clipboard
track_menu.add(MenuItem(_('Copy "Artist - Track"'), clip_ar_tr, pass_ref=True))


# def get_track_spot_url_show_test(_):
#     if pctl.g(r_menu_index).misc.get("spotify-track-url"):
#         return True
#     return False


def get_track_spot_url(track_id):
    track_object = pctl.g(track_id)
    url = track_object.misc.get("spotify-track-url")
    if url:
        copy_to_clipboard(url)
        show_message("Url copied to clipboard", mode="done")
    else:
        show_message("No results found")

def get_track_spot_url_deco():
    if pctl.g(r_menu_index).misc.get("spotify-track-url"):
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]

track_menu.add_sub(_("Spotify…"), 190, show_test=spotify_show_test)

def get_spot_artist_track(index):
    get_artist_spot(pctl.g(index))

track_menu.add_to_sub(1, MenuItem(_('Show Full Artist'), get_spot_artist_track, pass_ref=True, icon=spot_icon))

def get_album_spot_active(tr=None):
    if tr is None:
        tr = pctl.playing_object()
    if not tr:
        return
    url = spot_ctl.get_album_url_from_local(tr)
    if not url:
        show_message(_("No results found"))
        return
    l = spot_ctl.append_album(url, return_list=True)
    if len(l) < 2:
        show_message(_("Looks like that's the only track in the album"))
        return
    pctl.multi_playlist.append(pl_gen(title=f"{pctl.g(l[0]).artist} - {pctl.g(l[0]).album}",
                                      playlist=l,
                                      hide_title=0,
                                      ))
    switch_playlist(len(pctl.multi_playlist) - 1)


def get_spot_album_track(index):
    get_album_spot_active(pctl.g(index))

track_menu.add_to_sub(1, MenuItem(_('Show Full Album'), get_spot_album_track, pass_ref=True, icon=spot_icon))



track_menu.add_to_sub(1, MenuItem(_('Copy Track URL'), get_track_spot_url, get_track_spot_url_deco, pass_ref=True,
               icon=spot_icon))

def get_spot_recs(tr=None):
    if not tr:
        tr = pctl.playing_object()
    if not tr:
        return
    url = spot_ctl.get_artist_url_from_local(tr)
    if not url:
        show_message(_("No results found"))
        return
    track_url = tr.misc.get("spotify-track-url")

    show_message(_("Fetching..."))
    shooter(spot_ctl.rec_playlist, (url, track_url))

def get_spot_recs_track(index):
    get_spot_recs(pctl.g(index))

track_menu.add_to_sub(1, MenuItem(_('Get Recommended'), get_spot_recs_track, pass_ref=True,
               icon=spot_icon))


def drop_tracks_to_new_playlist(track_list, hidden=False):
    pl = new_playlist(switch=False)
    albums = []
    artists = []
    for item in track_list:
        albums.append(pctl.g(default_playlist[item]).album)
        artists.append(pctl.g(default_playlist[item]).artist)
        pctl.multi_playlist[pl][2].append(default_playlist[item])

    if len(track_list) > 1:
        if len(albums) > 0 and albums.count(albums[0]) == len(albums):
            track = pctl.g(default_playlist[track_list[0]])
            artist = track.artist
            if track.album_artist != "":
                artist = track.album_artist
            pctl.multi_playlist[pl][0] = artist + " - " + albums[0][:50]

    elif len(track_list) == 1 and artists:
        pctl.multi_playlist[pl][0] = artists[0]

    if tree_view_box.dragging_name:
        pctl.multi_playlist[pl][0] = tree_view_box.dragging_name

    pctl.notify_change()


def queue_deco():
    if len(pctl.force_queue) > 0:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled

    return [line_colour, colours.menu_background, None]


track_menu.br()
track_menu.add(MenuItem(_('Transcode Folder'), convert_folder, transcode_deco, pass_ref=True, icon=transcode_icon,
               show_test=toggle_transcode))


def bass_test(_):
    # return True
    return prefs.backend == 1


def gstreamer_test(_):
    # return True
    return prefs.backend == 2


# Create top menu
x_menu = Menu(190, show_icons=True)
view_menu = Menu(170)
set_menu = Menu(150)
set_menu_hidden = Menu(100)
vis_menu = Menu(140)
window_menu = Menu(140)
field_menu = Menu(140)
dl_menu = Menu(90)

window_menu = Menu(140)
window_menu.add(MenuItem(_("Minimize"), do_minimize_button))
window_menu.add(MenuItem(_("Maximize"), do_maximize_button))
window_menu.add(MenuItem(_("Exit"), do_exit_button))

def field_copy(text_field):
    text_field.copy()


def field_paste(text_field):
    text_field.paste()


def field_clear(text_field):
    text_field.clear()


# Copy text
field_menu.add(MenuItem(_("Copy"), field_copy, pass_ref=True))
# Paste text
field_menu.add(MenuItem(_("Paste"), field_paste, pass_ref=True))
# Clear text
field_menu.add(MenuItem(_("Clear"), field_clear, pass_ref=True))


def vis_off():
    gui.vis_want = 0
    gui.update_layout()
    # gui.turbo = False


vis_menu.add(MenuItem(_("Off"), vis_off))


def level_on():
    if gui.vis_want == 1 and gui.turbo is True:
        gui.level_meter_colour_mode += 1
        if gui.level_meter_colour_mode > 4:
            gui.level_meter_colour_mode = 0

    gui.vis_want = 1
    gui.update_layout()
    # if prefs.backend == 2:
    #     show_message("Visualisers not implemented in GStreamer mode")
    # gui.turbo = True


vis_menu.add(MenuItem(_("Level Meter"), level_on))


def spec_on():
    gui.vis_want = 2
    # if prefs.backend == 2:
    #     show_message("Not implemented")
    gui.update_layout()


vis_menu.add(MenuItem(_("Spectrum Visualizer"), spec_on))


def spec2_def():
    if gui.vis_want == 3:
        prefs.spec2_colour_mode += 1
        if prefs.spec2_colour_mode > 1:
            prefs.spec2_colour_mode = 0

    gui.vis_want = 3
    if prefs.backend == 2:
        show_message("Not implemented")
    # gui.turbo = True
    prefs.spec2_colour_setting = 'custom'
    gui.update_layout()


# vis_menu.add(_("Spectrogram"), spec2_def)

def sa_remove(h):
    if len(gui.pl_st) > 1:
        del gui.pl_st[h]
        gui.update_layout()
    else:
        show_message("Cannot remove the only column.")


def sa_artist():
    gui.pl_st.insert(set_menu.reference + 1, ["Artist", 220, False])
    gui.update_layout()


def sa_album_artist():
    gui.pl_st.insert(set_menu.reference + 1, ["Album Artist", 220, False])
    gui.update_layout()


def sa_composer():
    gui.pl_st.insert(set_menu.reference + 1, ["Composer", 220, False])
    gui.update_layout()


def sa_title():
    gui.pl_st.insert(set_menu.reference + 1, ["Title", 220, False])
    gui.update_layout()


def sa_album():
    gui.pl_st.insert(set_menu.reference + 1, ["Album", 220, False])
    gui.update_layout()


def sa_comment():
    gui.pl_st.insert(set_menu.reference + 1, ["Comment", 300, False])
    gui.update_layout()


def sa_track():
    gui.pl_st.insert(set_menu.reference + 1, ["#", 25, True])
    gui.update_layout()


def sa_count():
    gui.pl_st.insert(set_menu.reference + 1, ["P", 25, True])
    gui.update_layout()


def sa_scrobbles():
    gui.pl_st.insert(set_menu.reference + 1, ["S", 25, True])
    gui.update_layout()


def sa_time():
    gui.pl_st.insert(set_menu.reference + 1, ["Time", 55, True])
    gui.update_layout()


def sa_date():
    gui.pl_st.insert(set_menu.reference + 1, ["Date", 55, True])
    gui.update_layout()


def sa_genre():
    gui.pl_st.insert(set_menu.reference + 1, ["Genre", 150, False])
    gui.update_layout()


def sa_file():
    gui.pl_st.insert(set_menu.reference + 1, ["Filepath", 350, False])
    gui.update_layout()


def sa_filename():
    gui.pl_st.insert(set_menu.reference + 1, ["Filename", 300, False])
    gui.update_layout()


def sa_codec():
    gui.pl_st.insert(set_menu.reference + 1, ["Codec", 65, True])
    gui.update_layout()


def sa_bitrate():
    gui.pl_st.insert(set_menu.reference + 1, ["Bitrate", 65, True])
    gui.update_layout()


def sa_lyrics():
    gui.pl_st.insert(set_menu.reference + 1, ["Lyrics", 50, True])
    gui.update_layout()

def sa_cue():
    gui.pl_st.insert(set_menu.reference + 1, ["CUE", 50, True])
    gui.update_layout()

def sa_star():
    gui.pl_st.insert(set_menu.reference + 1, ["Starline", 80, True])
    gui.update_layout()

def sa_disc():
    gui.pl_st.insert(set_menu.reference + 1, ["Disc", 50, True])
    gui.update_layout()

def sa_rating():
    gui.pl_st.insert(set_menu.reference + 1, ["Rating", 80, True])
    gui.update_layout()


def sa_love():
    gui.pl_st.insert(set_menu.reference + 1, ["❤", 25, True])
    # gui.pl_st.append(["❤", 25, True])
    gui.update_layout()


def key_love(index):
    return get_love_index(index)


def key_artist(index):
    return pctl.master_library[index].artist.lower()


def key_album_artist(index):
    return pctl.master_library[index].album_artist.lower()


def key_composer(index):
    return pctl.master_library[index].composer.lower()


def key_comment(index):
    return pctl.master_library[index].comment


def key_title(index):
    return pctl.master_library[index].title.lower()


def key_album(index):
    return pctl.master_library[index].album.lower()


def key_duration(index):
    return pctl.master_library[index].length


def key_date(index):
    return pctl.master_library[index].date


def key_genre(index):
    return pctl.master_library[index].genre.lower()


def key_t(index):
    # return str(pctl.master_library[index].track_number)
    return index_key(index)


def key_codec(index):
    return pctl.master_library[index].file_ext


def key_bitrate(index):
    return pctl.master_library[index].bitrate


def key_p(index):
    return pctl.master_library[index].bitrate


def key_hl(index):
    if len(pctl.master_library[index].lyrics) > 5:
        return 0
    else:
        return 1


def sort_ass(h, invert=False, custom_list=None, custom_name=""):
    global default_playlist

    if custom_list is None:
        if pl_is_locked(pctl.active_playlist_viewing):
            show_message("Playlist is locked")
            return

        name = gui.pl_st[h][0]
        playlist = pctl.multi_playlist[pctl.active_playlist_viewing][2]
    else:
        name = custom_name
        playlist = custom_list

    key = None
    ns = False

    if name == "Filepath":
        key = key_filepath
        if use_natsort:
            key = key_fullpath
            ns = True
    if name == "Filename":
        key = key_filepath  # key_filename
        if use_natsort:
            key = key_fullpath
            ns = True
    if name == "Artist":
        key = key_artist
    if name == "Album Artist":
        key = key_album_artist
    if name == "Title":
        key = key_title
    if name == "Album":
        key = key_album
    if name == "Composer":
        key = key_composer
    if name == "Time":
        key = key_duration
    if name == "Date":
        key = key_date
    if name == "Genre":
        key = key_genre
    if name == "#":
        key = key_t
    if name == "S":
        key = key_scrobbles
    if name == "P":
        key = key_playcount
    if name == 'Starline':
        key = best
    if name == 'Rating':
        key = key_rating
    if name == 'Comment':
        key = key_comment
    if name == "Codec":
        key = key_codec
    if name == "Bitrate":
        key = key_bitrate
    if name == "Lyrics":
        key = key_hl
    if name == "❤":
        key = key_love
    if name == "Disc":
        key = key_disc
    if name == "CUE":
        key = key_cue

    if custom_list is None:
        if key is not None:

            if ns:
                key = natsort.natsort_keygen(key=key, alg=natsort.PATH)

            playlist.sort(key=key, reverse=invert)

            pctl.multi_playlist[pctl.active_playlist_viewing][2] = playlist
            default_playlist = pctl.multi_playlist[pctl.active_playlist_viewing][2]

            pctl.playlist_view_position = 0
            console.print("DEBUG: Position changed by sort")
            gui.pl_update = 1

    elif custom_list is not None:
        playlist.sort(key=key, reverse=invert)

    reload()


def sort_dec(h):
    sort_ass(h, True)


def hide_set_bar():
    gui.set_bar = False
    gui.update_layout()
    gui.pl_update = 1


def show_set_bar():
    gui.set_bar = True
    gui.update_layout()
    gui.pl_update = 1


# Mark for translation
_("Time")
_("Filepath")

#
# set_menu.add(_("Sort Ascending"), sort_ass, pass_ref=True, disable_test=view_pl_is_locked, pass_ref_deco=True)
# set_menu.add(_("Sort Decending"), sort_dec, pass_ref=True, disable_test=view_pl_is_locked, pass_ref_deco=True)
# set_menu.br()
set_menu.add(MenuItem(_("Auto Resize"), auto_size_columns))
set_menu.add(MenuItem(_("Hide bar"), hide_set_bar))
set_menu_hidden.add(MenuItem(_("Show bar"), show_set_bar))
set_menu.br()
set_menu.add(MenuItem("- " + _("Remove This"), sa_remove, pass_ref=True))
set_menu.br()
set_menu.add(MenuItem("+ " + _("Artist"), sa_artist))
set_menu.add(MenuItem("+ " + _("Title"), sa_title))
set_menu.add(MenuItem("+ " + _("Album"), sa_album))
set_menu.add(MenuItem("+ " + _("Duration"), sa_time))
set_menu.add(MenuItem("+ " + _("Date"), sa_date))
set_menu.add(MenuItem("+ " + _("Genre"), sa_genre))
set_menu.add(MenuItem("+ " + _("Track Number"), sa_track))
set_menu.add(MenuItem("+ " + _("Play Count"), sa_count))
set_menu.add(MenuItem("+ " + _("Codec"), sa_codec))
set_menu.add(MenuItem("+ " + _("Bitrate"), sa_bitrate))
set_menu.add(MenuItem("+ " + _("Filename"), sa_filename))
set_menu.add(MenuItem("+ " + _("Starline"), sa_star))
set_menu.add(MenuItem("+ " + _("Rating"), sa_rating))
set_menu.add(MenuItem("+ " + _("Loved"), sa_love))

set_menu.add_sub("+ " + _("More…"), 150)

set_menu.add_to_sub(0, MenuItem("+ " + _("Album Artist"), sa_album_artist))
set_menu.add_to_sub(0, MenuItem("+ " + _("Comment"), sa_comment))
set_menu.add_to_sub(0, MenuItem("+ " + _("Filepath"), sa_file))
set_menu.add_to_sub(0, MenuItem("+ " + _("Scrobble Count"), sa_scrobbles))
set_menu.add_to_sub(0, MenuItem("+ " + _("Composer"), sa_composer))
set_menu.add_to_sub(0, MenuItem("+ " + _("Disc Number"), sa_disc))
set_menu.add_to_sub(0, MenuItem("+ " + _("Has Lyrics"), sa_lyrics))
set_menu.add_to_sub(0, MenuItem("+ " + _("Is CUE Sheet"), sa_cue))

def bass_features_deco():
    line_colour = colours.menu_text
    if prefs.backend != 1:
        line_colour = colours.menu_text_disabled
    return [line_colour, colours.menu_background, None]


def toggle_dim_albums(mode=0):
    if mode == 1:
        return prefs.dim_art

    prefs.dim_art ^= True
    gui.pl_update = 1
    gui.update += 1


def toggle_gallery_combine(mode=0):
    if mode == 1:
        return prefs.gallery_combine_disc

    prefs.gallery_combine_disc ^= True
    reload_albums()
def toggle_gallery_click(mode=0):
    if mode == 1:
        return prefs.gallery_single_click

    prefs.gallery_single_click ^= True


def toggle_gallery_thin(mode=0):
    if mode == 1:
        return prefs.thin_gallery_borders

    prefs.thin_gallery_borders ^= True
    gui.update += 1
    update_layout_do()


def toggle_gallery_row_space(mode=0):
    if mode == 1:
        return prefs.increase_gallery_row_spacing

    prefs.increase_gallery_row_spacing ^= True
    gui.update += 1
    update_layout_do()


def toggle_galler_text(mode=0):
    if mode == 1:
        return gui.gallery_show_text

    gui.gallery_show_text ^= True
    gui.update += 1
    update_layout_do()

    # Jump to playing album
    if album_mode and gui.first_in_grid is not None:

        if gui.first_in_grid < len(default_playlist):
            goto_album(gui.first_in_grid, force=True)


def toggle_card_style(mode=0):
    if mode == 1:
        return prefs.use_card_style

    prefs.use_card_style ^= True
    gui.update += 1


def toggle_side_panel(mode=0):
    global update_layout
    global album_mode

    if mode == 1:
        return prefs.prefer_side

    prefs.prefer_side ^= True
    update_layout = True

    if album_mode:
        gui.rsp = True
    elif prefs.prefer_side is True:
        gui.rsp = True
    else:
        gui.rsp = False

    if prefs.prefer_side:
        gui.rspw = gui.pref_rspw


def force_album_view():
    toggle_album_mode(True)


def enter_combo():
    if not gui.combo_mode:
        gui.combo_was_album = album_mode
        gui.showcase_mode = False
        gui.radio_view = False
        if album_mode:
            toggle_album_mode()
        if gui.rsp:
            gui.rsp = False
        gui.combo_mode = True
        gui.update_layout()


def exit_combo(restore=False):
    if gui.combo_mode:
        if gui.combo_was_album and restore:
            force_album_view()
        gui.showcase_mode = False
        gui.radio_view = False
        if prefs.prefer_side:
            gui.rsp = True
        gui.update_layout()
        gui.combo_mode = False
        gui.was_radio = False


def enter_showcase_view(track_id=None):
    if not gui.combo_mode:
        enter_combo()
        gui.was_radio = False
    gui.showcase_mode = True
    gui.radio_view = False
    if track_id is None or pctl.playing_object() is None or pctl.playing_object().index == track_id:
        pass
    else:
        gui.force_showcase_index = track_id
    inp.mouse_click = False
    gui.update_layout()


def enter_radio_view():
    if not gui.combo_mode:
        enter_combo()
    gui.showcase_mode = False
    gui.radio_view = True
    inp.mouse_click = False
    gui.update_layout()


def standard_size():
    global album_mode
    global window_size
    global update_layout

    global album_mode_art_size

    album_mode = False
    gui.rsp = True
    window_size = window_default_size
    SDL_SetWindowSize(t_window, logical_size[0], logical_size[1])

    gui.rspw = 80 + int(window_size[0] * 0.18)
    update_layout = True
    album_mode_art_size = 130
    # clear_img_cache()


def path_stem_to_playlist(path, title):  # Used with gallery power bar

    playlist = []

    # Hack for networked tracks
    if path.lstrip("/") == title:
        for item in pctl.multi_playlist[pctl.active_playlist_viewing][2]:
            if title == os.path.basename(pctl.master_library[item].parent_folder_path):
                playlist.append(item)

    else:
        for item in pctl.multi_playlist[pctl.active_playlist_viewing][2]:
            if path in pctl.master_library[item].parent_folder_path:
                playlist.append(item)

    pctl.multi_playlist.append(pl_gen(title=os.path.basename(title).upper(),
                                      playlist=copy.deepcopy(playlist),
                                      hide_title=0))

    pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "s\"" + pctl.multi_playlist[pctl.active_playlist_viewing][
        0] + "\" f\"" + path + "\""

    switch_playlist(len(pctl.multi_playlist) - 1)


def goto_album(playlist_no, down=False, force=False):
    console.print("DEBUG: Postion set by album locate")

    if core_timer.get() < 0.5:
        return

    global album_dex

    # ----
    w = gui.rspw
    if window_size[0] < 750 * gui.scale:
        w = window_size[0] - 20 * gui.scale
        if gui.lsp:
            w -= gui.lspw
    area_x = w + 38 * gui.scale
    row_len = int((area_x - album_h_gap) / (album_mode_art_size + album_h_gap))
    global last_row
    last_row = row_len
    # ----

    px = 0
    row = 0
    re = 0

    for i in range(len(album_dex)):
        if i == len(album_dex) - 1:
            re = i
            break
        if album_dex[i + 1] - 1 > playlist_no - 1:
            re = i
            break
        row += 1
        if row > row_len - 1:
            row = 0
            px += album_mode_art_size + album_v_gap

    # If the album is within the view port already, dont jump to it
    # (unless we really want to with force)
    if not force and gui.album_scroll_px + album_v_slide_value < px < gui.album_scroll_px + window_size[1]:

        # Dont chance the view since its alread in the view port
        # But if the album is just out of view on the bottom, bring it into view on to bottom row
        if window_size[1] > (album_mode_art_size + album_v_gap) * 2:
            while not gui.album_scroll_px - 20 < px + (album_mode_art_size + album_v_gap + 3) < gui.album_scroll_px + \
                      window_size[
                          1] - 40:
                gui.album_scroll_px += 1

    else:
        # Set the view to the calculated position
        gui.album_scroll_px = px
        gui.album_scroll_px -= album_v_slide_value

        if gui.album_scroll_px < 0 - album_v_slide_value:
            gui.album_scroll_px = 0 - album_v_slide_value

    if len(album_dex) > 0:
        return album_dex[re]
    else:
        return 0

    gui.update += 1


def toggle_album_mode(force_on=False):
    global album_mode
    global window_size
    global update_layout
    global album_playlist_width
    global old_album_pos

    gui.gall_tab_enter = False

    if album_mode is True:

        album_mode = False
        # album_playlist_width = gui.playlist_width
        # old_album_pos = gui.album_scroll_px
        gui.rspw = gui.pref_rspw
        gui.rsp = prefs.prefer_side
        gui.album_tab_mode = False
    else:
        album_mode = True
        if gui.combo_mode:
            exit_combo()

        gui.rsp = True

        gui.rspw = gui.pref_gallery_w

    space = window_size[0] - gui.rspw
    if gui.lsp:
        space -= gui.lspw

    if album_mode and gui.set_mode and len(gui.pl_st) > 6 and space < 600 * gui.scale:
        gui.set_mode = False
        gui.pl_update = True
        gui.update_layout()

    reload_albums(quiet=True)

    # if pctl.active_playlist_playing == pctl.active_playlist_viewing:
    # goto_album(pctl.playlist_playing_position)

    if album_mode:
        if pctl.selected_in_playlist < len(pctl.playing_playlist()):
            goto_album(pctl.selected_in_playlist)


def toggle_gallery_keycontrol(always_exit=False):
    if is_level_zero():
        if not album_mode:
            toggle_album_mode()
            gui.gall_tab_enter = True
            gui.album_tab_mode = True
            show_in_gal(pctl.selected_in_playlist, silent=True)
        elif gui.gall_tab_enter or always_exit:
            # Exit gallery and tab mode
            toggle_album_mode()
        else:
            gui.album_tab_mode ^= True
            if gui.album_tab_mode:
                show_in_gal(pctl.selected_in_playlist, silent=True)


def check_auto_update_okay(code, pl=None):
    try:
        cmds = shlex.split(code)
    except:
        print("Malformed generator code!")
        return False
    return "auto" in cmds or (prefs.always_auto_update_playlists and
                              pctl.active_playlist_playing != pl and
                              not "sf" in cmds and
                              not "rf" in cmds and
                              not "ra" in cmds and
                              not "sa" in cmds and
                              not "st" in cmds and
                              not "rt" in cmds and
                              not "plex" in cmds and
                              not "jelly" in cmds and
                              not "koel" in cmds and
                              not "tau" in cmds and
                              not "air" in cmds and
                              not "sal" in cmds and
                              not "slt" in cmds and
                              not "spl\"" in code and
                              not "r" in cmds)


def switch_playlist(number, cycle=False, quiet=False):
    global default_playlist

    global search_index
    global shift_selection

    # Close any active menus
    # for instance in Menu.instances:
    #     instance.active = False
    close_all_menus()
    if gui.radio_view:
        if cycle:
            pctl.radio_playlist_viewing += number
        else:
            pctl.radio_playlist_viewing = number
        if pctl.radio_playlist_viewing > len(pctl.radio_playlists) - 1:
            pctl.radio_playlist_viewing = 0
        return

    gui.previous_playlist_id = pctl.multi_playlist[pctl.active_playlist_viewing][6]

    gui.pl_update = 1
    search_index = 0
    gui.column_d_click_on = -1
    gui.search_error = False
    if quick_search_mode:
        gui.force_search = True

    # if pl_follow:
    #     pctl.multi_playlist[pctl.playlist_active][1] = copy.deepcopy(pctl.playlist_playing)

    if gui.showcase_mode and gui.combo_mode and not quiet:
        view_standard()

    pctl.multi_playlist[pctl.active_playlist_viewing][2] = default_playlist
    pctl.multi_playlist[pctl.active_playlist_viewing][3] = pctl.playlist_view_position
    pctl.multi_playlist[pctl.active_playlist_viewing][5] = pctl.selected_in_playlist

    if gall_pl_switch_timer.get() > 240:
        gui.gallery_positions.clear()
    gall_pl_switch_timer.set()

    gui.gallery_positions[gui.previous_playlist_id] = gui.album_scroll_px

    if cycle:
        pctl.active_playlist_viewing += number
    else:
        pctl.active_playlist_viewing = number

    while pctl.active_playlist_viewing > len(pctl.multi_playlist) - 1:
        pctl.active_playlist_viewing -= len(pctl.multi_playlist)
    while pctl.active_playlist_viewing < 0:
        pctl.active_playlist_viewing += len(pctl.multi_playlist)

    default_playlist = pctl.multi_playlist[pctl.active_playlist_viewing][2]
    pctl.playlist_view_position = pctl.multi_playlist[pctl.active_playlist_viewing][3]
    pctl.selected_in_playlist = pctl.multi_playlist[pctl.active_playlist_viewing][5]
    console.print("DEBUG: Position changed by playlist change")
    shift_selection = [pctl.selected_in_playlist]

    id = pctl.multi_playlist[pctl.active_playlist_viewing][6]

    code = pctl.gen_codes.get(id)
    if code is not None and check_auto_update_okay(code, pctl.active_playlist_viewing):
        gui.regen_single_id = id
        tm.ready("worker")

    if album_mode:
        reload_albums(True)
        if id in gui.gallery_positions:
            gui.album_scroll_px = gui.gallery_positions[id]
        else:
            goto_album(pctl.playlist_view_position)

    if prefs.auto_goto_playing:
        pctl.show_current(this_only=True, playing=False, highlight=True, no_switch=True)

    if prefs.shuffle_lock:
        view_box.lyrics(hit=True)
        if pctl.active_playlist_viewing:
            pctl.active_playlist_playing = pctl.active_playlist_viewing
            random_track()


def cycle_playlist_pinned(step):
    if gui.radio_view:

        pctl.radio_playlist_viewing += step * -1
        if pctl.radio_playlist_viewing > len(pctl.radio_playlists) - 1:
            pctl.radio_playlist_viewing = 0
        if pctl.radio_playlist_viewing < 0:
            pctl.radio_playlist_viewing = len(pctl.radio_playlists) - 1
        return

    if step > 0:
        p = pctl.active_playlist_viewing
        le = len(pctl.multi_playlist)
        on = p
        on -= 1
        while True:
            if on < 0:
                on = le - 1
            if on == p:
                break
            if pctl.multi_playlist[on][8] is False or not prefs.tabs_on_top or (
                    gui.lsp and prefs.left_panel_mode == "playlist"):
                switch_playlist(on)
                break
            on -= 1

    elif step < 0:
        p = pctl.active_playlist_viewing
        le = len(pctl.multi_playlist)
        on = p
        on += 1
        while True:
            if on == le:
                on = 0
            if on == p:
                break
            if pctl.multi_playlist[on][8] is False or not prefs.tabs_on_top or (
                    gui.lsp and prefs.left_panel_mode == "playlist"):
                switch_playlist(on)
                break
            on += 1


def activate_info_box():
    fader.rise()
    pref_box.enabled = True


def activate_radio_box():
    radiobox.active = True
    radiobox.radio_field.clear()
    radiobox.radio_field_title.clear()


def new_playlist_colour_callback():
    if gui.radio_view:
        return [120, 90, 245, 255]
    else:
        return [237, 80, 221, 255]


add_icon.xoff = 3
add_icon.yoff = 0
add_icon.colour = [237, 80, 221, 255]
add_icon.colour_callback = new_playlist_colour_callback


def new_playlist_deco():
    if gui.radio_view:
        text = _("New Radio List")
    else:
        text = _("New Playlist")
    return [colours.menu_text, colours.menu_background, text]


x_menu.add(MenuItem(_("New Playlist"), new_playlist, new_playlist_deco, icon=add_icon))


def clean_db_show_test(_):
    return gui.suggest_clean_db


def clean_db_fast():
    keys = set(pctl.master_library.keys())
    for pl in pctl.multi_playlist:
        keys -= set(pl[2])
    for item in keys:
        pctl.purge_track(item, fast=True)
    gui.show_message(f"Done! {len(keys)} old items were removed.", mode="done")
    gui.suggest_clean_db = False


def clean_db_deco():
    return [colours.menu_text, [30, 150, 120, 255], _("Clean Database!")]


x_menu.add(MenuItem(_("Clean Database!"), clean_db_fast, clean_db_deco, show_test=clean_db_show_test))

# x_menu.add(_("Internet Radio…"), activate_radio_box)

tauon.switch_playlist = switch_playlist


def import_spotify_playlist():
    clip = copy_from_clipboard()
    for line in clip.split("\n"):
        if line.startswith("https://open.spotify.com/playlist/") or line.startswith("spotify:playlist:"):
            clip = clip.strip()
            spot_ctl.playlist(line)

    if album_mode:
        reload_albums()
    gui.pl_update += 1


def import_spotify_playlist_deco():
    clip = copy_from_clipboard()
    if clip.startswith("https://open.spotify.com/playlist/") or clip.startswith("spotify:playlist:"):
        return [colours.menu_text, colours.menu_background, None]
    return [colours.menu_text_disabled, colours.menu_background, None]


x_menu.add(MenuItem(_("Paste Spotify Playlist"), import_spotify_playlist, import_spotify_playlist_deco, icon=spot_icon,
           show_test=spotify_show_test))


def show_import_music(_):
    return gui.add_music_folder_ready


def import_music():
    pl = pl_gen(_("Music"))
    pl[7] = [music_directory]
    pctl.multi_playlist.append(pl)
    load_order = LoadClass()
    load_order.target = music_directory
    load_order.playlist = pl[6]
    load_orders.append(load_order)
    switch_playlist(len(pctl.multi_playlist) - 1)
    gui.add_music_folder_ready = False


x_menu.add(MenuItem(_("Import Music Folder"), import_music, show_test=show_import_music))

x_menu.br()

settings_icon.xoff = 0
settings_icon.yoff = 2
settings_icon.colour = [232, 200, 96, 255]  # [230, 152, 118, 255]#[173, 255, 47, 255] #[198, 237, 56, 255]
# settings_icon.colour = [180, 140, 255, 255]
x_menu.add(MenuItem(_("Settings"), activate_info_box, icon=settings_icon))
x_menu.add_sub(_("Database…"), 190)
if dev_mode:
    def dev_mode_enable_save_state():
        global should_save_state
        should_save_state = True
        show_message("Enabled saving state")

    def dev_mode_disable_save_state():
        global should_save_state
        should_save_state = False
        show_message("Disabled saving state")

    x_menu.add_sub(_("Dev Mode"), 190)
    x_menu.add_to_sub(1, MenuItem(_("Enable Saving State"), dev_mode_enable_save_state))
    x_menu.add_to_sub(1, MenuItem(_("Disable Saving State"), dev_mode_disable_save_state))
x_menu.br()


# x_menu.add('Toggle Side panel', toggle_combo_view, combo_deco)

def stt2(sec):
    days, rem = divmod(sec, 86400)
    hours, rem = divmod(rem, 3600)
    min, sec = divmod(rem, 60)

    s_day = str(days) + 'd'
    if s_day == '0d':
        s_day = "  "

    s_hours = str(hours) + 'h'
    if s_hours == '0h' and s_day == '  ':
        s_hours = "  "

    s_min = str(min) + 'm'

    return s_day.rjust(3) + ' ' + s_hours.rjust(3) + ' ' + s_min.rjust(3)


def export_database():
    path = user_directory + '/DatabaseExport.csv'
    xport = open(path, 'w')

    xport.write("Artist;Title;Album;Album artist;Track number;Type;Duration;Release date;Genre;Playtime;File path")

    for index, track in pctl.master_library.items():

        xport.write("\n")

        xport.write(csv_string(track.artist) + ",")
        xport.write(csv_string(track.title) + ",")
        xport.write(csv_string(track.album) + ",")
        xport.write(csv_string(track.album_artist) + ",")
        xport.write(csv_string(track.track_number) + ",")
        type = "File"
        if track.is_network:
            type = "Network"
        elif track.is_cue:
            type = "CUE File"
        xport.write(type + ",")
        xport.write(str(track.length) + ",")
        xport.write(csv_string(track.date) + ",")
        xport.write(csv_string(track.genre) + ",")
        xport.write(str(int(star_store.get_by_object(track))) + ",")
        xport.write(csv_string(track.fullpath))

    xport.close()
    show_message("Export complete.", "Saved as: " + path, mode='done')


def q_to_playlist():
    pctl.multi_playlist.append(pl_gen(title="Play History",
                                      playing=0,
                                      playlist=list(reversed(copy.deepcopy(pctl.track_queue))),
                                      position=0,
                                      hide_title=1,
                                      selected=0))


x_menu.add_to_sub(0, MenuItem(_("Export as CSV"), export_database))
x_menu.add_to_sub(0, MenuItem(_('Rescan All Folders'), rescan_all_folders))
x_menu.add_to_sub(0, MenuItem(_("Play History to Playlist"), q_to_playlist))
x_menu.add_to_sub(0, MenuItem(_("Reset Image Cache"), clear_img_cache))

cm_clean_db = False


def clean_db():
    global cm_clean_db
    prefs.remove_network_tracks = False
    cm_clean_db = True
    tm.ready("worker")


def clean_db2():
    global cm_clean_db
    prefs.remove_network_tracks = True
    cm_clean_db = True
    tm.ready("worker")


x_menu.add_to_sub(0, MenuItem(_("Remove Network Tracks"), clean_db2))
x_menu.add_to_sub(0, MenuItem(_("Remove Missing Tracks"), clean_db))



def import_fmps():
    unique = set()
    for playlist in pctl.multi_playlist:
        for id in playlist[2]:
            tr = pctl.g(id)
            if "FMPS_Rating" in tr.misc:
                rating = round(tr.misc["FMPS_Rating"] * 10)
                star_store.set_rating(tr.index, rating)
                unique.add(tr.index)

    show_message(str(len(unique)) + " ratings imported", mode="done")

    gui.pl_update += 1

x_menu.add_to_sub(0, MenuItem(_("Import FMPS Ratings"), import_fmps))


def import_popm():
    unique = set()
    skipped = set()
    for playlist in pctl.multi_playlist:
        for id in playlist[2]:
            tr = pctl.g(id)
            if "POPM" in tr.misc:
                rating = tr.misc["POPM"]
                t_rating = 0
                if rating <= 1:
                    t_rating = 2
                elif rating <= 64:
                    t_rating = 4
                elif rating <= 128:
                    t_rating = 6
                elif rating <= 196:
                    t_rating = 8
                elif rating <= 255:
                    t_rating = 10

                if star_store.get_rating(tr.index) == 0:
                    star_store.set_rating(tr.index, t_rating)
                    unique.add(tr.index)
                else:
                    print("Won't import POPM because track is already rated")
                    skipped.add(tr.index)

    s = str(len(unique)) + " ratings imported"
    if len(skipped) > 0:
        s += f", {len(skipped)} skipped"
    show_message(s, mode="done")

    gui.pl_update += 1

x_menu.add_to_sub(0, MenuItem(_("Import POPM Ratings"), import_popm))


def clear_ratings():
    if not key_shift_down:
        show_message(_("This will delete all track and album ratings from the local database!"),
                     _("Press button again while holding shift key if you're sure you want to do that."),
                     mode='warning')
        return
    else:
        for key, star in star_store.db.items():
            star[2] = 0
        album_star_store.db.clear()
    gui.pl_update += 1


x_menu.add_to_sub(0, MenuItem(_("Reset User Ratings"), clear_ratings))


def find_incomplete():
    gen_incomplete(pctl.active_playlist_viewing)


x_menu.add_to_sub(0, MenuItem(_("Find Incomplete Albums"), find_incomplete))
x_menu.add_to_sub(0, MenuItem("Mark Missing as Found", pctl.reset_missing_flags, show_test=test_shift))


def cast_deco():
    line_colour = colours.menu_text
    if tauon.chrome_mode:
       return [line_colour, colours.menu_background, _("Stop Cast")]  # [24, 25, 60, 255]
    return [line_colour, colours.menu_background, None]


def cast_search2():
    chrome.rescan()

def cast_search():

    if tauon.chrome_mode:
        pctl.stop()
        chrome.end()
    else:
        if not chrome:
            show_message("pychromecast not found")
            return
        show_message("Searching for Chomecasts...")
        shooter(cast_search2)


if chrome:
    x_menu.add_sub(_("Chromecast…"), 220)
    shooter(cast_search2)

tauon.chrome_menu = x_menu

#x_menu.add(_("Cast…"), cast_search, cast_deco)


def clear_queue():
    pctl.force_queue = []
    gui.pl_update = 1
    pctl.pause_queue = False


mode_menu = Menu(175)


def set_mini_mode_A1():
    prefs.mini_mode_mode = 0
    set_mini_mode()


def set_mini_mode_B1():
    prefs.mini_mode_mode = 1
    set_mini_mode()


def set_mini_mode_A2():
    prefs.mini_mode_mode = 2
    set_mini_mode()


def set_mini_mode_C1():
    prefs.mini_mode_mode = 5
    set_mini_mode()

def set_mini_mode_B2():
    prefs.mini_mode_mode = 3
    set_mini_mode()


def set_mini_mode_D():
    prefs.mini_mode_mode = 4
    set_mini_mode()


mode_menu.add(MenuItem(_('Tab'), set_mini_mode_D))
mode_menu.add(MenuItem(_('Mini'), set_mini_mode_A1))
# mode_menu.add(_('Mini Mode Large'), set_mini_mode_A2)
mode_menu.add(MenuItem(_('Slate'), set_mini_mode_C1))
mode_menu.add(MenuItem(_('Square'), set_mini_mode_B1))
mode_menu.add(MenuItem(_('Square Large'), set_mini_mode_B2))


def copy_bb_metadata():
    tr = pctl.playing_object()
    if not tr.title and not tr.artist and pctl.playing_state == 3:
        return pctl.tag_meta
    text = f"{tr.artist} - {tr.title}".strip(" -")
    if text:
        copy_to_clipboard(text)
    else:
        show_message(_("No metadata available to copy"))


mode_menu.br()
mode_menu.add(MenuItem(_('Copy Title to Clipboard'), copy_bb_metadata))

extra_menu = Menu(175, show_icons=True)


def stop():
    pctl.stop()


def random_track():
    playlist = pctl.multi_playlist[pctl.active_playlist_playing][2]
    if playlist:
        random_position = random.randrange(0, len(playlist))
        track_id = playlist[random_position]
        pctl.jump(track_id, random_position)
        pctl.show_current()


extra_menu.add(MenuItem(_('Random Track'), random_track, hint=';'))


def random_album():
    folders = {}
    playlist = pctl.multi_playlist[pctl.active_playlist_playing][2]
    if playlist:
        for i, id in enumerate(playlist):
            track = pctl.g(id)
            if track.parent_folder_path not in folders:
                folders[track.parent_folder_path] = (id, i)

        key = random.choice(list(folders.keys()))
        result = folders[key]
        pctl.jump(*result)
        pctl.show_current()


def radio_random():
    pctl.advance(rr=True)


radiorandom_icon = MenuIcon(asset_loader('radiorandom.png', True))
revert_icon = MenuIcon(asset_loader('revert.png', True))

radiorandom_icon.xoff = 1
radiorandom_icon.yoff = 0
radiorandom_icon.colour = [153, 229, 133, 255]
extra_menu.add(MenuItem(_('Radio Random'), radio_random, hint='/', icon=radiorandom_icon))

revert_icon.xoff = 1
revert_icon.yoff = 0
revert_icon.colour = [229, 102, 59, 255]
extra_menu.add(MenuItem(_('Revert'), pctl.revert, hint='Shift+/', icon=revert_icon))

# extra_menu.add('Toggle Repeat', toggle_repeat, hint='COMMA')


# extra_menu.add('Toggle Random', toggle_random, hint='PERIOD')
extra_menu.add(MenuItem(_('Clear Queue'), clear_queue, queue_deco, hint="Alt+Shift+Q"))


def heart_menu_colour():
    if not (pctl.playing_state == 1 or pctl.playing_state == 2):
        if colours.lm:
            return [255, 150, 180, 255]
        return None
    if love(False):
        return [245, 60, 60, 255]
    else:
        if colours.lm:
            return [255, 150, 180, 255]
        return None


heart_icon = MenuIcon(asset_loader('heart-menu.png', True))
heart_row_icon = asset_loader('heart-track.png', True)
heart_notify_icon = asset_loader('heart-notify.png', True)
heart_notify_break_icon = asset_loader('heart-notify-break.png', True)
# spotify_row_icon = asset_loader('spotify-row.png', True)
star_pc_icon = asset_loader('star-pc.png', True)
star_row_icon = asset_loader('star.png', True)
star_half_row_icon = asset_loader('star-half.png', True)


def draw_rating_widget(x, y, n_track, album=False):
    if album:
        rat = album_star_store.get_rating(n_track)
    else:
        rat = star_store.get_rating(n_track.index)

    rect = (x - round(5 * gui.scale), y - round(4 * gui.scale), round(80 * gui.scale), round(16 * gui.scale))
    gui.heart_fields.append(rect)

    if coll(rect) and (inp.mouse_click or (is_level_zero() and not quick_drag)):
        gui.pl_update = 2
        pp = mouse_position[0] - x

        if pp < 5 * gui.scale:
            rat = 0
        elif pp > 70 * gui.scale:
            rat = 10
        else:
            rat = pp // (star_row_icon.w // 2)

        if inp.mouse_click:
            rat = min(rat, 10)
            if album:
                album_star_store.set_rating(n_track, rat)
            else:
                star_store.set_rating(n_track.index, rat, write=True)

    # bg = colours.grey(40)
    bg = [255, 255, 255, 17]
    fg = colours.grey(210)

    if gui.tracklist_bg_is_light:
        bg = [0, 0, 0, 25]
        fg = colours.grey(70)

    playtime_stars = 0
    if prefs.rating_playtime_stars and rat == 0 and not album:
        playtime_stars = star_count3(star_store.get(n_track.index), n_track.length)
        if gui.tracklist_bg_is_light:
            fg2 = alpha_blend([0, 0, 0, 70], ddt.text_background_colour)
        else:
            fg2 = alpha_blend([255, 255, 255, 50], ddt.text_background_colour)

    for ss in range(5):

        xx = x + ss * star_row_icon.w

        if playtime_stars:
            if playtime_stars - 1 < ss * 2:
                star_row_icon.render(xx, y, bg)
            elif playtime_stars - 1 == ss * 2:
                star_row_icon.render(xx, y, bg)
                star_half_row_icon.render(xx, y, fg2)
            else:
                star_row_icon.render(xx, y, fg2)
        else:

            if rat - 1 < ss * 2:
                star_row_icon.render(xx, y, bg)
            elif rat - 1 == ss * 2:
                star_row_icon.render(xx, y, bg)
                star_half_row_icon.render(xx, y, fg)
            else:
                star_row_icon.render(xx, y, fg)


heart_colours = ColourGenCache(0.7, 0.7)

heart_icon.colour = [245, 60, 60, 255]
heart_icon.xoff = 3
heart_icon.yoff = 0



if gui.scale == 1.25:
    heart_icon.yoff = 1

heart_icon.colour_callback = heart_menu_colour


def love_deco():
    if love(False):
        return [colours.menu_text, colours.menu_background, _("Un-Love Track")]
    else:
        if pctl.playing_state == 1 or pctl.playing_state == 2:
            return [colours.menu_text, colours.menu_background, _("Love Track")]
        else:
            return [colours.menu_text_disabled, colours.menu_background, _("Love Track")]


def bar_love(notify=False):
    shoot_love = threading.Thread(target=love, args=[True, None, False, notify])
    shoot_love.daemon = True
    shoot_love.start()


def bar_love_notify():
    bar_love(notify=True)


def select_love(notify=False):
    selected = pctl.selected_in_playlist
    playlist = pctl.multi_playlist[pctl.active_playlist_viewing][2]
    if -1 < selected < len(playlist):
        track_id = playlist[selected]

        shoot_love = threading.Thread(target=love, args=[True, track_id, False, notify])
        shoot_love.daemon = True
        shoot_love.start()


extra_menu.add(MenuItem('Love', bar_love_notify, love_deco, icon=heart_icon))


def toggle_spotify_like_active2(tr):
    if "spotify-track-url" in tr.misc:
        if "spotify-liked" in tr.misc:
            spot_ctl.unlike_track(tr)
        else:
            spot_ctl.like_track(tr)
    gui.pl_update += 1
    for i, p in enumerate(pctl.multi_playlist):
        code = pctl.gen_codes.get(p[6])
        if code and code.startswith("slt"):
            print("Fetching Spotify likes...")
            regenerate_playlist(i, silent=True)
    gui.pl_update += 1

def toggle_spotify_like_active():
    tr = pctl.playing_object()
    if tr:
        shoot_dl = threading.Thread(target=toggle_spotify_like_active2, args=([tr]))
        shoot_dl.daemon = True
        shoot_dl.start()


def toggle_spotify_like_active_deco():
    tr = pctl.playing_object()
    text = _("Spotify Like Track")

    if pctl.playing_state == 0 or not tr or not "spotify-track-url" in tr.misc:
        return [colours.menu_text_disabled, colours.menu_background, text]
    if "spotify-liked" in tr.misc:
        text = _("Un-like Spotify Track")

    return [colours.menu_text, colours.menu_background, text]


def locate_artist():
    track = pctl.playing_object()
    if not track:
        return

    artist = track.artist
    if track.album_artist:
        artist = track.album_artist

    block_starts = []
    current = False
    for i in range(len(default_playlist)):
        track = pctl.g(default_playlist[i])
        if current is False:
            if track.artist == artist or track.album_artist == artist or (
                    'artists' in track.misc and artist in track.misc['artists']):
                block_starts.append(i)
                current = True
        else:
            if track.artist != artist and track.album_artist != artist or (
                    'artists' in track.misc and artist in track.misc['artists']):
                current = False

    if block_starts:

        next = False
        for start in block_starts:

            if next:
                pctl.selected_in_playlist = start
                pctl.playlist_view_position = start
                shift_selection.clear()
                break

            if pctl.selected_in_playlist == start:
                next = True
                continue

        else:
            pctl.selected_in_playlist = block_starts[0]
            pctl.playlist_view_position = block_starts[0]
            shift_selection.clear()

        tree_view_box.show_track(pctl.g(default_playlist[pctl.selected_in_playlist]))
    else:
        show_message("No exact matching artist could be found in this playlist")

    console.print("DEBUG: Position changed by artist locate")

    gui.pl_update += 1


def activate_search_overlay():
    if cm_clean_db:
        show_message("Please wait for cleaning process to finish")
        return
    search_over.active = True
    search_over.delay_enter = False
    search_over.search_text.selection = 0
    search_over.search_text.cursor_position = 0
    search_over.spotify_mode = False


extra_menu.add(MenuItem(_('Global Search'), activate_search_overlay, hint="Ctrl+G"))


def get_album_spot_url_active():
    tr = pctl.playing_object()
    if tr:
        url = spot_ctl.get_album_url_from_local(tr)

        if url:
            copy_to_clipboard(url)
            show_message(_("URL copied to clipboard"), mode="done")
        else:
            show_message(_("No results found"))


def get_album_spot_url_actove_deco():
    tr = pctl.playing_object()
    text = _("Copy Album URL")
    if not tr:
        return [colours.menu_text_disabled, colours.menu_background, text]
    if not "spotify-album-url" in tr.misc:
        text = _("Lookup Spotify Album")

    return [colours.menu_text, colours.menu_background, text]



def goto_playing_extra():
    pctl.show_current(highlight=True)


extra_menu.add(MenuItem(_("Locate Artist"), locate_artist))

extra_menu.add(MenuItem(_("Go To Playing"), goto_playing_extra, hint="'"))

def show_spot_playing_deco():
    if not (spot_ctl.coasting or spot_ctl.playing):
        return [colours.menu_text, colours.menu_background, None]
    else:
        return [colours.menu_text_disabled, colours.menu_background, None]

def show_spot_coasting_deco():
    if spot_ctl.coasting:
        return [colours.menu_text, colours.menu_background, None]
    else:
        return [colours.menu_text_disabled, colours.menu_background, None]


def show_spot_playing():
    if pctl.playing_state != 0 and pctl.playing_state != 3 and not spot_ctl.coasting and not spot_ctl.playing:
        pctl.stop()
    spot_ctl.update(start=True)


def spot_transfer_playback_here():
    tauon.spot_ctl.preparing_spotify = True
    if not (spot_ctl.playing or spot_ctl.coasting):
        spot_ctl.update(start=True)
    pctl.playerCommand = 'spotcon'
    pctl.playerCommandReady = True
    pctl.playing_state = 3
    shooter(spot_ctl.transfer_to_tauon)


extra_menu.br()
extra_menu.add(MenuItem('Spotify Like Track', toggle_spotify_like_active, toggle_spotify_like_active_deco,
               show_test=spotify_show_test, icon=spot_heartx_icon))

def spot_import_albums():
    if not spot_ctl.spotify_com:
        spot_ctl.spotify_com = True
        shoot = threading.Thread(target=spot_ctl.get_library_albums)
        shoot.daemon = True
        shoot.start()
    else:
        show_message(_("Please wait until current job is finished"))

extra_menu.add_sub(_("Import Spotify…"), 140, show_test=spotify_show_test)

extra_menu.add_to_sub(0, MenuItem(_("Liked Albums"), spot_import_albums, show_test=spotify_show_test, icon=spot_icon))

def spot_import_tracks():
    if not spot_ctl.spotify_com:
        spot_ctl.spotify_com = True
        shoot = threading.Thread(target=spot_ctl.get_library_likes)
        shoot.daemon = True
        shoot.start()
    else:
        show_message(_("Please wait until current job is finished"))

extra_menu.add_to_sub(0, MenuItem(_("Liked Tracks"), spot_import_tracks, show_test=spotify_show_test, icon=spot_icon))

def spot_import_playlists():
    if not spot_ctl.spotify_com:
        show_message(_("Importing Spotify playlists..."))
        shoot_dl = threading.Thread(target=spot_ctl.import_all_playlists)
        shoot_dl.daemon = True
        shoot_dl.start()
    else:
        show_message(_("Please wait until current job is finished"))


#extra_menu.add_to_sub(_("Import All Playlists"), 0, spot_import_playlists, show_test=spotify_show_test, icon=spot_icon)

def spot_import_playlist_menu():
    if not spot_ctl.spotify_com:
        playlists = spot_ctl.get_playlist_list()
        spotify_playlist_menu.items.clear()
        if playlists:
            for item in playlists:
                spotify_playlist_menu.add(MenuItem(item[0], spot_ctl.playlist, pass_ref=True, set_ref=item[1]))

            spotify_playlist_menu.add(MenuItem(_("> Import All Playlists"), spot_import_playlists))
            spotify_playlist_menu.activate(position=(extra_menu.pos[0], window_size[1] - gui.panelBY))
    else:
        show_message(_("Please wait until current job is finished"))

extra_menu.add_to_sub(0, MenuItem(_("Playlist…"), spot_import_playlist_menu, show_test=spotify_show_test, icon=spot_icon))


def spot_import_context():
    shooter(spot_ctl.import_context)

extra_menu.add_to_sub(0, MenuItem(_("Current Context"), spot_import_context, show_spot_coasting_deco, show_test=spotify_show_test, icon=spot_icon))


def get_album_spot_deco():
    tr = pctl.playing_object()
    text = _("Show Full Album")
    if not tr:
        return [colours.menu_text_disabled, colours.menu_background, text]
    if not "spotify-album-url" in tr.misc:
        text = _("Lookup Spotify Album")

    return [colours.menu_text, colours.menu_background, text]


extra_menu.add(MenuItem("Show Full Album", get_album_spot_active, get_album_spot_deco,
               show_test=spotify_show_test, icon=spot_icon))


def get_artist_spot(tr=None):
    if not tr:
        tr = pctl.playing_object()
    if not tr:
        return
    url = spot_ctl.get_artist_url_from_local(tr)
    if not url:
        show_message(_("No results found"))
        return
    show_message(_("Fetching..."))
    shooter(spot_ctl.artist_playlist, (url,))

extra_menu.add(MenuItem(_("Show Full Artist"), get_artist_spot,
               show_test=spotify_show_test, icon=spot_icon))

extra_menu.add(MenuItem(_("Start Spotify Remote"), show_spot_playing, show_spot_playing_deco, show_test=spotify_show_test,
           icon=spot_icon))

# def spot_transfer_playback_here_deco():
#     tr = pctl.playing_state == 3:
#     text = _("Show Full Album")
#     if not tr:
#         return [colours.menu_text_disabled, colours.menu_background, text]
#     if not "spotify-album-url" in tr.misc:
#         text = _("Lookup Spotify Album")
#
#     return [colours.menu_text, colours.menu_background, text]


extra_menu.add(MenuItem("Transfer audio here", spot_transfer_playback_here, show_test=lambda x:spotify_show_test(0) and tauon.enable_librespot and prefs.launch_spotify_local and not pctl.spot_playing and (spot_ctl.coasting or spot_ctl.playing),
           icon=spot_icon))

def toggle_auto_theme(mode=0):
    if mode == 1:
        return prefs.colour_from_image

    prefs.colour_from_image ^= True
    gui.theme_temp_current = -1

    gui.reload_theme = True

    # if prefs.colour_from_image and prefs.art_bg and not key_shift_down:
    #     toggle_auto_bg()


def toggle_auto_bg(mode=0):
    if mode == 1:
        return prefs.art_bg
    prefs.art_bg ^= True

    if prefs.art_bg:
        gui.update = 60

    style_overlay.flush()
    tm.ready("style")

    # if prefs.colour_from_image and prefs.art_bg and not key_shift_down:
    #     toggle_auto_theme()


def toggle_auto_bg_strong(mode=0):
    if mode == 1:
        return prefs.art_bg_stronger == 2

    if prefs.art_bg_stronger == 2:
        prefs.art_bg_stronger = 1
    else:
        prefs.art_bg_stronger = 2
    gui.update_layout()


def toggle_auto_bg_strong1(mode=0):
    if mode == 1:
        return prefs.art_bg_stronger == 1
    prefs.art_bg_stronger = 1
    gui.update_layout()


def toggle_auto_bg_strong2(mode=0):
    if mode == 1:
        return prefs.art_bg_stronger == 2
    prefs.art_bg_stronger = 2
    gui.update_layout()
    if prefs.art_bg:
        gui.update = 60


def toggle_auto_bg_strong3(mode=0):
    if mode == 1:
        return prefs.art_bg_stronger == 3
    prefs.art_bg_stronger = 3
    gui.update_layout()
    if prefs.art_bg:
        gui.update = 60


def toggle_auto_bg_blur(mode=0):
    if mode == 1:
        return prefs.art_bg_always_blur
    prefs.art_bg_always_blur ^= True
    style_overlay.flush()
    tm.ready("style")


def toggle_auto_bg_showcase(mode=0):
    if mode == 1:
        return prefs.bg_showcase_only
    prefs.bg_showcase_only ^= True
    gui.update_layout()


def toggle_notifications(mode=0):
    if mode == 1:
        return prefs.show_notifications

    prefs.show_notifications ^= True

    if prefs.show_notifications:
        if not de_notify_support:
            show_message("Notifications for this DE not supported", '', mode='warning')


# def toggle_al_pref_album_artist(mode=0):
#
#     if mode == 1:
#         return prefs.artist_list_prefer_album_artist
#
#     prefs.artist_list_prefer_album_artist ^= True
#     artist_list_box.saves.clear()


def toggle_mini_lyrics(mode=0):
    if mode == 1:
        return prefs.show_lyrics_side

    prefs.show_lyrics_side ^= True


def toggle_showcase_vis(mode=0):
    if mode == 1:
        return prefs.showcase_vis

    prefs.showcase_vis ^= True
    gui.update_layout()


def toggle_level_meter(mode=0):
    if mode == 1:
        return gui.vis_want != 0

    if gui.vis_want == 0:
        gui.vis_want = 1
    else:
        gui.vis_want = 0

    gui.update_layout()


# def toggle_force_subpixel(mode=0):
#
#     if mode == 1:
#         return prefs.force_subpixel_text != 0
#
#     prefs.force_subpixel_text ^= True
#     ddt.force_subpixel_text = prefs.force_subpixel_text
#     ddt.clear_text_cache()


def level_meter_special_2():
    gui.level_meter_colour_mode = 2


theme_files = os.listdir(install_directory + '/theme')
theme_files.sort()


def last_fm_menu_deco():
    if prefs.scrobble_hold:
        if not prefs.auto_lfm and lb.enable:
            line = _("ListenBrainz is Paused")
        else:
            line = _("Scrobbling is Paused")
        bg = colours.menu_background
    else:
        if not prefs.auto_lfm and lb.enable:
            line = _("ListenBrainz is Active")
        else:
            line = _("Scrobbling is Active")

        bg = colours.menu_background

    return [colours.menu_text, bg, line]


def lastfm_colour():
    if not prefs.scrobble_hold:
        return [250, 50, 50, 255]
    else:
        return None


last_fm_icon = asset_loader('as.png', True)
lastfm_icon = MenuIcon(last_fm_icon)

if gui.scale == 2:
    lastfm_icon.xoff = 0
elif gui.scale == 1.25:
    lastfm_icon.xoff = 0
else:
    lastfm_icon.xoff = -1

lastfm_icon.yoff = 1

lastfm_icon.colour = [249, 70, 70, 255]
lastfm_icon.colour_callback = lastfm_colour


def lastfm_menu_test(a):
    if (prefs.auto_lfm and prefs.last_fm_token is not None) or prefs.enable_lb or prefs.maloja_enable:
        return True
    return False


lb_icon = MenuIcon(asset_loader('lb-g.png'))
lb_icon.base_asset = asset_loader('lb-gs.png')


def lb_mode():
    return prefs.enable_lb


lb_icon.mode_callback = lb_mode

lb_icon.xoff = 3
lb_icon.yoff = -1

if gui.scale == 1.25:
    lb_icon.yoff = 0

if prefs.auto_lfm:
    listen_icon = lastfm_icon
elif lb.enable:
    listen_icon = lb_icon
else:
    listen_icon = None

x_menu.add(MenuItem("LFM", lastfm.toggle, last_fm_menu_deco, icon=listen_icon, show_test=lastfm_menu_test))



def get_album_art_url(tr):

    artist = tr.album_artist
    if not tr.album:
        return
    if not artist:
        artist = tr.artist
    if not artist:
        return

    release_id = None
    release_group_id = None
    if (artist, tr.album) in pctl.album_mbid_release_cache or (artist, tr.album) in pctl.album_mbid_release_group_cache:
        release_id = pctl.album_mbid_release_cache[(artist, tr.album)]
        release_group_id = pctl.album_mbid_release_group_cache[(artist, tr.album)]
        if release_id is None and release_group_id is None:
            return

    if not release_group_id:
        release_group_id = tr.misc.get('musicbrainz_releasegroupid')

    if not release_id:
        release_id = tr.misc.get('musicbrainz_albumid')

    if not release_group_id:
        try:
            #print("lookup release group id")
            s = musicbrainzngs.search_release_groups(tr.album, artist=artist, limit=1)
            release_group_id = s['release-group-list'][0]['id']
            tr.misc['musicbrainz_releasegroupid'] = release_group_id
            #print("got release group id")
        except:
            #print("Error lookup mbid for discord")
            pctl.album_mbid_release_group_cache[(artist, tr.album)] = None

    if not release_id:
        try:
            #print("lookup release id")
            s = musicbrainzngs.search_releases(tr.album, artist=artist, limit=1)
            release_id = s['release-list'][0]['id']
            tr.misc['musicbrainz_albumid'] = release_id
            #print("got release group id")
        except:
            #print("Error lookup mbid for discord")
            pctl.album_mbid_release_cache[(artist, tr.album)] = None

    image_data = None
    final_id = None
    if release_group_id:
        url = pctl.mbid_image_url_cache.get(release_group_id)
        if url:
            return url

        base_url = "http://coverartarchive.org/release-group/"
        url = f"{base_url}{release_group_id}"

        try:
            #print("lookup image url from release group")
            response = requests.get(url)
            response.raise_for_status()
            image_data = response.json()
            final_id = release_group_id
        except (requests.RequestException, ValueError):
            #print("no image found for release group")
            pctl.album_mbid_release_group_cache[(artist, tr.album)] = None

    if release_id and not image_data:
        url = pctl.mbid_image_url_cache.get(release_id)
        if url:
            return url

        base_url = "http://coverartarchive.org/release/"
        url = f"{base_url}{release_id}"

        try:
            #print("lookup image url from album id")
            response = requests.get(url)
            response.raise_for_status()
            image_data = response.json()
            final_id = release_id
        except (requests.RequestException, ValueError):
            #print("no image found for album id")
            pctl.album_mbid_release_cache[(artist, tr.album)] = None

    if image_data:
        for image in image_data["images"]:
            if image.get("front") and ("250" in image["thumbnails"] or "small" in image["thumbnails"]):
                pctl.album_mbid_release_cache[(artist, tr.album)] = release_id
                pctl.album_mbid_release_group_cache[(artist, tr.album)] = release_group_id

                url = image["thumbnails"].get("250")
                if url is None:
                    url = image["thumbnails"].get("small")

                if url:
                    print("got mb image url for discord")
                    pctl.mbid_image_url_cache[final_id] = url
                    return url

    pctl.album_mbid_release_cache[(artist, tr.album)] = None
    pctl.album_mbid_release_group_cache[(artist, tr.album)] = None

    return None


def discord_loop():
    prefs.discord_active = True

    if not pctl.playing_ready():
        # show_message("Please start playing a track first")
        return

    asyncio.set_event_loop(asyncio.new_event_loop())

    try:
        # print("Attempting to connect to Discord...")
        client_id = '954253873160286278'
        RPC = Presence(client_id)
        RPC.connect()

        print("Discord RPC connection successful.")
        time.sleep(1)
        start_time = time.time()
        idle_time = Timer()

        state = 0
        index = -1
        br = False
        gui.discord_status = "Connected"
        gui.update += 1
        current_state = 0

        while True:
            while True:

                current_index = pctl.playing_object().index
                if pctl.playing_state == 3:
                    current_index = radiobox.song_key

                if current_state == 0 and pctl.playing_state in (1, 3):
                    current_state = 1
                elif current_state == 1 and pctl.playing_state not in (1, 3):
                    current_state = 0
                    idle_time.set()

                if state != current_state or index != current_index:
                    if pctl.playing_time > 4 or current_state != 1:
                        state = current_state
                        index = current_index
                        start_time = time.time() - pctl.playing_time

                        break

                if current_state == 0 and idle_time.get() > 13:
                    print("Pause discord RPC...")
                    gui.discord_status = "Idle"
                    RPC.clear(pid)
                    # RPC.close()

                    while True:
                        if prefs.disconnect_discord:
                            break
                        if pctl.playing_state == 1:
                            print("Reconnect discord...")
                            RPC.connect()
                            gui.discord_status = "Connected"
                            break
                        time.sleep(2)

                    if not prefs.disconnect_discord:
                        continue

                time.sleep(2)

                if prefs.disconnect_discord:
                    RPC.clear(pid)
                    RPC.close()
                    prefs.disconnect_discord = False
                    gui.discord_status = "Not connected"
                    br = True
                    break

            if br:
                break

            title = "Unknown Track"
            tr = pctl.playing_object()
            if tr.artist != "" and tr.title != "":
                title = tr.artist + " - " + tr.title
                if len(title) > 150:
                    title = "Unknown Track"

            if tr.album:
                album = tr.album
            else:
                album = "Unknown Album"
                if pctl.playing_state == 3:
                    album = radiobox.loaded_station["title"]

            if len(album) == 1:
                album += " "

            if state == 1:
                # print("PLAYING: " + title)
                # print(start_time)
                url = get_album_art_url(pctl.playing_object())

                large_image = "tauon-standard"
                small_image = None
                if url:
                    large_image = url
                    small_image = "tauon-standard"
                RPC.update(pid=pid,
                           state=album,
                           details=title,
                           start=int(start_time),
                           large_image=large_image,
                           small_image=small_image,)

            else:
                # print("Discord RPC - Stop")
                RPC.update(pid=pid,
                           state="Idle",
                           large_image="tauon-standard", )

            time.sleep(15)

            if prefs.disconnect_discord:
                RPC.clear(pid)
                RPC.close()
                prefs.disconnect_discord = False
                break

    except:
        # show_message("Error connecting to Discord", mode='error')
        gui.discord_status = "Error - Discord not running?"
        prefs.disconnect_discord = False

    prefs.discord_active = False


def hit_discord():
    if prefs.discord_enable and prefs.discord_allow and not prefs.discord_active:
        discord_t = threading.Thread(target=discord_loop)
        discord_t.daemon = True
        discord_t.start()



x_menu.add(MenuItem(_("Exit Shuffle Lockdown"), toggle_shuffle_layout, show_test=exit_shuffle_layout))

def open_donate_link():
    webbrowser.open("https://github.com/sponsors/Taiko2k", new=2, autoraise=True)


x_menu.add(MenuItem(_("Donate"), open_donate_link))

x_menu.add(MenuItem(_("Exit"), tauon.exit, hint="Alt+F4", set_ref="User clicked menu exit button", pass_ref=+True))


def stop_quick_add():
    pctl.quick_add_target = None


def show_stop_quick_add(_):
    return pctl.quick_add_target is not None


x_menu.add(MenuItem(_("Disengage Quick Add"), stop_quick_add, show_test=show_stop_quick_add, ))


def view_tracks():
    # if gui.show_playlist is False:
    #     gui.show_playlist = True
    if album_mode:
        toggle_album_mode()
    if gui.combo_mode:
        exit_combo()
    if gui.rsp:
        toggle_side_panel()


#
# def view_standard_full():
#     # if gui.show_playlist is False:
#     #     gui.show_playlist = True
#
#     if album_mode:
#         toggle_album_mode()
#     if gui.combo_mode:
#         toggle_combo_view(off=True)
#     if not gui.rsp:
#         toggle_side_panel()
#     global update_layout
#     update_layout = True
#     gui.rspw = window_size[0]


def view_standard_meta():
    # if gui.show_playlist is False:
    #     gui.show_playlist = True
    if album_mode:
        toggle_album_mode()

    if gui.combo_mode:
        exit_combo()

    if not gui.rsp:
        toggle_side_panel()

    global update_layout
    update_layout = True
    # gui.rspw = 80 + int(window_size[0] * 0.18)


def view_standard():
    # if gui.show_playlist is False:
    #     gui.show_playlist = True
    if album_mode:
        toggle_album_mode()
    if gui.combo_mode:
        exit_combo()
    if not gui.rsp:
        toggle_side_panel()


def standard_view_deco():
    if album_mode or gui.combo_mode or not gui.rsp:
        line_colour = colours.menu_text
    else:
        line_colour = colours.menu_text_disabled
    return [line_colour, colours.menu_background, None]


# def gallery_only_view():
#     if gui.show_playlist is False:
#         return
#     if not album_mode:
#         toggle_album_mode()
#     gui.show_playlist = False
#     global album_playlist_width
#     global update_layout
#     update_layout = True
#     gui.rspw = window_size[0]
#     album_playlist_width = gui.playlist_width
#     #gui.playlist_width = -19


def toggle_library_mode():
    if gui.set_mode:
        gui.set_mode = False
        # gui.set_bar = False
    else:
        gui.set_mode = True
        # gui.set_bar = True
    gui.update_layout()


def library_deco():
    tc = colours.menu_text
    if gui.combo_mode or (gui.show_playlist is False and album_mode):
        tc = colours.menu_text_disabled

    if gui.set_mode:
        return [tc, colours.menu_background, "Disable Columns"]
    else:
        return [tc, colours.menu_background, 'Enable Columns']


def break_deco():
    tex = colours.menu_text
    if gui.combo_mode or (gui.show_playlist is False and album_mode):
        tex = colours.menu_text_disabled
    if not break_enable:
        tex = colours.menu_text_disabled

    if pctl.multi_playlist[pctl.active_playlist_viewing][4] == 0:
        return [tex, colours.menu_background, "Disable Title Breaks"]
    else:
        return [tex, colours.menu_background, 'Enable Title Breaks']


def toggle_playlist_break():
    pctl.multi_playlist[pctl.active_playlist_viewing][4] ^= 1
    gui.pl_update = 1


# ---------------------------------------------------------------------------------------


def transcode_single(item, manual_directroy=None, manual_name=None):
    global core_use
    global dl_use

    if manual_directroy != None:
        codec = "opus"
        output = manual_directroy
        track = item
        core_use += 1
        bitrate = 48
    else:
        track = item[0]
        codec = prefs.transcode_codec
        output = prefs.encoder_output + item[1] + "/"
        bitrate = prefs.transcode_bitrate

    t = pctl.master_library[track]

    path = t.fullpath
    cleanup = False

    if t.is_network:
        while dl_use > 1:
            time.sleep(0.2)
        dl_use += 1
        try:
            url, params = pctl.get_url(t)
            assert url
            path = os.path.join(tmp_cache_dir(), str(t.index))
            if os.path.exists(path):
                os.remove(path)
            print("Downloading file...")
            with requests.get(url, params=params) as response, open(path, 'wb') as out_file:
                out_file.write(response.content)
            print("Download complete")
            cleanup = True
        except:
            print("Error downloading file")
        dl_use -= 1

    if not os.path.isfile(path):
        show_message("Encoding warning: Missing one or more files")
        core_use -= 1
        return

    out_line = encode_track_name(t)

    target_out = output + 'output' + str(track) + "." + codec

    command = tauon.get_ffmpeg() + " "

    if not t.is_cue:
        command += '-i "'
    else:
        command += '-ss ' + str(t.start_time)
        command += ' -t ' + str(t.length)

        command += ' -i "'

    command += path.replace('"', '\\"')

    command += '" '
    if pctl.master_library[track].is_cue:
        if t.title != "":
            command += '-metadata title="' + t.title.replace('"', "").replace("'", "") + '" '
        if t.artist != "":
            command += '-metadata artist="' + t.artist.replace('"', "").replace("'", "") + '" '
        if t.album != "":
            command += '-metadata album="' + t.album.replace('"', "").replace("'", "") + '" '
        if t.track_number != "":
            command += '-metadata track="' + str(t.track_number).replace('"', "").replace("'", "") + '" '
        if t.date != "":
            command += '-metadata year="' + str(t.date).replace('"', "").replace("'", "") + '" '

    if codec != 'flac':
        command += " -b:a " + str(bitrate) + "k -vn "

    command += '"' + target_out.replace('"', '\\"') + '"'

    # print(shlex.split(command))
    startupinfo = None
    if system == 'windows' or msys:
        startupinfo = subprocess.STARTUPINFO()
        startupinfo.dwFlags |= subprocess.STARTF_USESHOWWINDOW

    if not msys:
        command = shlex.split(command)

    subprocess.call(command, stdout=subprocess.PIPE, shell=False,
                    startupinfo=startupinfo)

    print("FFmpeg finished")
    if codec == "opus" and prefs.transcode_opus_as:
        codec = 'ogg'

    # print(target_out)

    if manual_name is None:
        final_out = output + out_line + "." + codec
        final_name = out_line + "." + codec
        os.rename(target_out, final_out)
    else:
        final_out = output + manual_name + "." + codec
        final_name = manual_name + "." + codec
        os.rename(target_out, final_out)

    if prefs.transcode_inplace and not t.is_network and not t.is_cue:
        print("MOVE AND REPLACE!")
        if os.path.isfile(final_out) and os.path.getsize(final_out) > 1000:
            new_name = os.path.join(t.parent_folder_path, final_name)
            print(new_name)
            shutil.move(final_out, new_name)

            old_key = star_store.key(track)
            old_star = star_store.full_get(track)

            try:
                send2trash(pctl.master_library[track].fullpath)
            except:
                print("File trash error")

            if os.path.isfile(pctl.master_library[track].fullpath):
                try:
                    os.remove(pctl.master_library[track].fullpath)
                except:
                    print("File detete error")

            pctl.master_library[track].fullpath = new_name
            pctl.master_library[track].file_ext = codec.upper()

            # Update and merge playtimes
            new_key = star_store.key(track)
            if old_star and (new_key != old_key):

                new_star = star_store.full_get(track)
                if new_star is None:
                    new_star = star_store.new_object()

                new_star[0] += old_star[0]
                if old_star[2] > 0 and new_star[2] == 0:
                    new_star[2] = old_star[2]
                new_star[1] = "".join(set(new_star[1] + old_star[1]))

                if old_key in star_store.db:
                    del star_store.db[old_key]

                star_store.db[new_key] = new_star

    gui.transcoding_bach_done += 1
    if cleanup:
        os.remove(path)
    core_use -= 1
    gui.update += 1


# ---------------------
added = []


def cue_scan(content, tn):
    # Get length from backend

    lasttime = tn.length

    content = content.replace("\r", "")
    content = content.split("\n")

    # print(content)

    global added

    cued = []

    LENGTH = 0
    PERFORMER = ""
    TITLE = ""
    START = 0
    DATE = ""
    ALBUM = ""
    GENRE = ""
    MAIN_PERFORMER = ""

    for LINE in content:
        if 'TITLE "' in LINE:
            ALBUM = LINE[7:len(LINE) - 2]

        if 'PERFORMER "' in LINE:
            while LINE[0] != "P":
                LINE = LINE[1:]

            MAIN_PERFORMER = LINE[11:len(LINE) - 2]

        if 'REM DATE' in LINE:
            DATE = LINE[9:len(LINE) - 1]

        if 'REM GENRE' in LINE:
            GENRE = LINE[10:len(LINE) - 1]

        if 'TRACK ' in LINE:
            break

    for LINE in reversed(content):
        if len(LINE) > 100:
            return 1
        if "INDEX 01 " in LINE:
            temp = ""
            pos = len(LINE)
            pos -= 1
            while LINE[pos] != ":":
                pos -= 1
                if pos < 8:
                    break

            START = int(LINE[pos - 2:pos]) + (int(LINE[pos - 5:pos - 3]) * 60)
            LENGTH = int(lasttime) - START
            lasttime = START

        elif 'PERFORMER "' in LINE:
            switch = 0
            for i in range(len(LINE)):
                if switch == 1 and LINE[i] == '"':
                    break
                if switch == 1:
                    PERFORMER += LINE[i]
                if LINE[i] == '"':
                    switch = 1

        elif 'TITLE "' in LINE:

            switch = 0
            for i in range(len(LINE)):
                if switch == 1 and LINE[i] == '"':
                    break
                if switch == 1:
                    TITLE += LINE[i]
                if LINE[i] == '"':
                    switch = 1

        elif 'TRACK ' in LINE:

            pos = 0
            while LINE[pos] != 'K':
                pos += 1
                if pos > 15:
                    return 1
            TN = LINE[pos + 2:pos + 4]

            TN = int(TN)

            # try:
            #     bitrate = audio.info.bitrate
            # except:
            #     bitrate = 0

            if PERFORMER == "":
                PERFORMER = MAIN_PERFORMER

            nt = copy.deepcopy(tn)  # TrackClass()

            nt.cue_sheet = ""
            nt.is_embed_cue = True

            nt.index = pctl.master_count
            # nt.fullpath = filepath.replace('\\', '/')
            # nt.filename = filename
            # nt.parent_folder_path = os.path.dirname(filepath.replace('\\', '/'))
            # nt.parent_folder_name = os.path.splitext(os.path.basename(filepath))[0]
            # nt.file_ext = os.path.splitext(os.path.basename(filepath))[1][1:].upper()
            if MAIN_PERFORMER:
                nt.album_artist = MAIN_PERFORMER
            if PERFORMER:
                nt.artist = PERFORMER
            if GENRE:
                nt.genre = GENRE
            nt.title = TITLE
            nt.length = LENGTH
            # nt.bitrate = source_track.bitrate
            if ALBUM:
                nt.album = ALBUM
            if DATE:
                nt.date = DATE.replace('"', '')
            nt.track_number = TN
            nt.start_time = START
            nt.is_cue = True
            nt.size = 0  # source_track.size
            # nt.samplerate = source_track.samplerate
            if TN == 1:
                nt.size = os.path.getsize(nt.fullpath)

            pctl.master_library[pctl.master_count] = nt

            cued.append(pctl.master_count)
            # loaded_pathes_cache[filepath.replace('\\', '/')] = pctl.master_count
            # added.append(pctl.master_count)

            pctl.master_count += 1
            LENGTH = 0
            PERFORMER = ""
            TITLE = ""
            START = 0
            TN = 0

    added += reversed(cued)

    # cue_list.append(filepath)


def get_album_from_first_track(track_position, track_id=None, pl_number=None, pl_id=None):
    if pl_number is None:

        if pl_id:
            pl_number = id_to_pl(pl_id)
        else:
            pl_number = pctl.active_playlist_viewing

    playlist = pctl.multi_playlist[pl_number][2]

    if track_id is None:
        track_id = playlist[track_position]

    if playlist[track_position] != track_id:
        return []

    tracks = []
    album_parent_path = pctl.g(track_id).parent_folder_path

    i = track_position

    while i < len(playlist):
        if pctl.g(playlist[i]).parent_folder_path != album_parent_path:
            break

        tracks.append(playlist[i])
        i += 1

    return tracks


class SearchOverlay:

    def __init__(self):

        self.active = False
        self.search_text = TextBox()

        self.results = []
        self.searched_text = ""
        self.on = 0
        self.force_select = -1
        self.old_mouse = [0, 0]
        self.sip = False
        self.delay_enter = False
        self.last_animate_time = 0
        self.animate_timer = Timer(100)
        self.input_timer = Timer(100)
        self.all_folders = False
        self.spotify_mode = False

    def clear(self):
        self.search_text.text = ""
        self.results.clear()
        self.searched_text = ""
        self.on = 0
        self.all_folders = False

    def click_artist(self, name, get_list=False, search_lists=None):

        playlist = []

        if search_lists is None:
            search_lists = []
            for pl in pctl.multi_playlist:
                search_lists.append(pl[2])

        for pl in search_lists:
            for item in pl:
                tr = pctl.master_library[item]
                n = name.lower()
                if tr.artist.lower() == n \
                        or tr.album_artist.lower() == n \
                        or ('artists' in tr.misc and name in tr.misc['artists']):
                    if item not in playlist:
                        playlist.append(item)

        if get_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="Artist: " + name,
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        if gui.combo_mode:
            exit_combo()
        switch_playlist(len(pctl.multi_playlist) - 1)
        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "a\"" + name + "\""

        inp.key_return_press = False

    def click_year(self, name, get_list=False):

        playlist = []
        for pl in pctl.multi_playlist:
            for item in pl[2]:
                if name in pctl.master_library[item].date:
                    if item not in playlist:
                        playlist.append(item)

        if get_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="Year: " + name,
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        if gui.combo_mode:
            exit_combo()

        switch_playlist(len(pctl.multi_playlist) - 1)

        inp.key_return_press = False

    def click_composer(self, name, get_list=False):

        playlist = []
        for pl in pctl.multi_playlist:
            for item in pl[2]:
                if pctl.master_library[item].composer.lower() == name.lower():
                    if item not in playlist:
                        playlist.append(item)

        if get_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="Composer: " + name,
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        if gui.combo_mode:
            exit_combo()

        switch_playlist(len(pctl.multi_playlist) - 1)

        inp.key_return_press = False

    def click_meta(self, name, get_list=False, search_lists=None):

        if search_lists is None:
            search_lists = []
            for pl in pctl.multi_playlist:
                search_lists.append(pl[2])

        playlist = []
        for pl in search_lists:
            for item in pl:
                if name in pctl.master_library[item].parent_folder_path:
                    if item not in playlist:
                        playlist.append(item)

        if get_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title=os.path.basename(name).upper(),
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        if gui.combo_mode:
            exit_combo()

        switch_playlist(len(pctl.multi_playlist) - 1)

        pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "p\"" + name + "\""

        inp.key_return_press = False

    def click_genre(self, name, get_list=False, search_lists=None):

        playlist = []

        if search_lists is None:
            search_lists = []
            for pl in pctl.multi_playlist:
                search_lists.append(pl[2])

        include_multi = False
        if name.endswith("+") or not prefs.sep_genre_multi:
            name = name.rstrip("+")
            include_multi = True

        for pl in search_lists:
            for item in pl:
                track = pctl.master_library[item]
                if track.genre.lower().replace("-", "") == name.lower().replace("-", ""):
                    if item not in playlist:
                        playlist.append(item)
                elif include_multi and ("/" in track.genre or "," in track.genre or ";" in track.genre):
                    for split in track.genre.replace(",", "/").replace(";", "/").split("/"):
                        split = split.strip()
                        if name.lower().replace("-", "") == split.lower().replace("-", ""):
                            if item not in playlist:
                                playlist.append(item)

        if get_list:
            return playlist

        pctl.multi_playlist.append(pl_gen(title="Genre: " + name,
                                          playlist=copy.deepcopy(playlist),
                                          hide_title=0))

        if gui.combo_mode:
            exit_combo()

        switch_playlist(len(pctl.multi_playlist) - 1)

        if include_multi:
            pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "gm\"" + name + "\""
        else:
            pctl.gen_codes[pl_to_id(len(pctl.multi_playlist) - 1)] = "g=\"" + name + "\""

        inp.key_return_press = False

    def click_album(self, index):

        pctl.jump(index)
        if gui.combo_mode:
            exit_combo()

        pctl.show_current()

        inp.key_return_press = False

    def render(self):
        global input_text
        if self.active is False:

            # Activate search overlay on key presses
            if prefs.search_on_letter and input_text != "" and gui.layer_focus == 0 and \
                    not key_lalt and not key_ralt and \
                    not key_ctrl_down and not radiobox.active and not rename_track_box.active and \
                    not quick_search_mode and not pref_box.enabled and not gui.rename_playlist_box \
                    and not gui.rename_folder_box and input_text.isalnum() and not gui.box_over \
                    and not trans_edit_box.active:

                # Divert to artist list if mouse over
                if gui.lsp and prefs.left_panel_mode == "artist list" and 2 < mouse_position[0] < gui.lspw \
                        and gui.panelY < mouse_position[1] < window_size[1] - gui.panelBY:
                    artist_list_box.locate_artist_letter(input_text)
                    return

                activate_search_overlay()
                self.old_mouse = copy.deepcopy(mouse_position)

        if self.active:

            x = 0
            y = 0
            w = window_size[0]
            h = window_size[1]

            if keymaps.test("add-to-queue"):
                input_text = ""

            if inp.backspace_press:
                # self.searched_text = ""
                # self.results.clear()

                if len(self.search_text.text) - inp.backspace_press < 1:
                    self.active = False
                    self.search_text.text = ""
                    self.results.clear()
                    self.searched_text = ""
                    return

            if key_esc_press:
                if self.delay_enter:
                    self.delay_enter = False
                else:
                    self.active = False
                    self.search_text.text = ""
                    self.results.clear()
                    self.searched_text = ""
                    return

            if gui.level_2_click and mouse_position[0] > 350 * gui.scale:
                self.active = False
                self.search_text.text = ""

            mouse_change = False
            if not point_proximity_test(self.old_mouse, mouse_position, 25):
                mouse_change = True
            # mouse_change = True

            ddt.rect((x, y, w, h), [3, 3, 3, 235])
            ddt.text_background_colour = [12, 12, 12, 255]


            input_text_x = 80 * gui.scale
            highlight_x = 30 * gui.scale
            thumbnail_rx = 100 * gui.scale
            text_lx = 120 * gui.scale

            s_font = 15
            s_b_font = 214
            b_font = 215

            if window_size[0] < 400 * gui.scale:
                input_text_x = 30 * gui.scale
                highlight_x = 4 * gui.scale
                thumbnail_rx = 65 * gui.scale
                text_lx = 80 * gui.scale
                s_font = 415
                s_b_font = 514
                d_font = 515

            #album_art_size_s = 0 * gui.scale

            # Search active animation
            if self.sip:
                x = round(15 * gui.scale)
                y = x
                s = round(7 * gui.scale)
                g = round(4 * gui.scale)

                t = self.animate_timer.get()
                if abs(t - self.last_animate_time) > 0.3:
                    self.animate_timer.set()
                    t = 0

                self.last_animate_time = t

                for item in range(4):
                    a = 100
                    if round((t * 14)) % 4 == item:
                        a = 255
                    if self.spotify_mode:
                        colour = (145, 245, 78, a)
                    else:
                        colour = (140, 100, 255, a)

                    ddt.rect((x, y, s, s), colour)
                    x += g + s

                gui.update += 1

            # No results found message
            elif not self.results and len(self.search_text.text) > 1:
                if self.input_timer.get() > 0.5 and not self.sip:
                    ddt.text((window_size[0] // 2, 200 * gui.scale, 2), "No results found", [250, 250, 250, 255], 216,
                             bg=[12, 12, 12, 255])

            # Spotify search text
            if prefs.spot_mode and not self.spotify_mode:
                text = _("Press Tab key to switch to Spotify search")
                ddt.text((window_size[0] // 2, window_size[1] - 30 * gui.scale, 2), text, [250, 250, 250, 255], 212,
                         bg=[12, 12, 12, 255])

            self.search_text.draw(input_text_x, 60 * gui.scale, [230, 230, 230, 255], True, False, 30,
                                  window_size[0] - 100, big=True, click=gui.level_2_click, selection_height=30)

            if inp.key_tab_press:
                search_over.spotify_mode ^= True
                self.sip = True
                search_over.searched_text = search_over.search_text.text
                try:
                    worker2_lock.release()
                except:
                    pass

            if input_text or key_backspace_press:
                self.input_timer.set()

                gui.update += 1
            else:
                if self.input_timer.get() >= 0.20 and \
                        (len(search_over.search_text.text) > 1 or (len(search_over.search_text.text) == 1 and ord(search_over.search_text.text) > 128)) \
                         and search_over.search_text.text != search_over.searched_text:
                    try:
                        self.sip = True
                        worker2_lock.release()
                    except:
                        pass

            if self.input_timer.get() < 10:
                gui.frame_callback_list.append(TestTimer(0.1))

            yy = 110 * gui.scale

            if key_down_press:

                self.force_select += 1
                if self.force_select > 4:
                    self.on = self.force_select - 4
                if self.force_select > len(self.results) - 1:
                    self.force_select = len(self.results) - 1
                self.old_mouse = copy.deepcopy(mouse_position)

            if key_up_press:

                if self.force_select > -1:
                    self.force_select -= 1
                    if self.force_select < 0:
                        self.force_select = 0

                    if self.force_select < self.on + 4:
                        self.on = self.force_select - 4
                        if self.on < 0:
                            self.on = 0

                self.old_mouse = copy.deepcopy(mouse_position)

            if mouse_wheel == -1:
                self.on += 1
                self.force_select += 1
            if mouse_wheel == 1 and self.on > -1:
                self.on -= 1
                self.force_select -= 1

            enter = False

            if self.delay_enter and not self.sip and self.search_text.text == self.searched_text:
                enter = True
                self.delay_enter = False

            elif inp.key_return_press:
                if self.results:
                    enter = True
                    self.delay_enter = False
                else:
                    if self.sip or self.input_timer.get() < 0.25:
                        self.delay_enter = True
                    else:
                        enter = True
                        self.delay_enter = False

            inp.key_return_press = False

            bar_colour = [140, 80, 240, 255]
            track_in_bar_colour = [244, 209, 66, 255]

            self.on = max(self.on, 0)
            self.on = min(len(self.results) - 1, self.on)

            full_count = 0

            sec = False

            p = -1

            if self.on > 4:
                p += self.on - 4
            p = self.on - 1
            clear = False

            for i, item in enumerate(self.results):

                p += 1

                if p > len(self.results) - 1:
                    break

                item = self.results[p]

                fade = 1
                selected = self.on
                if self.force_select > -1:
                    selected = self.force_select

                # print(selected)

                if selected != p:
                    fade = 0.8

                start = yy

                n = item[0]

                names = {
                    0: "Artist",
                    1: "Album",
                    2: "Track",
                    3: "Genre",
                    5: "Folder",
                    6: "Composer",
                    7: "Year",
                    8: "Playlist",
                    10: "Artist",
                    11: "Album",
                    12: "Track",
                }
                type_colours = {
                    0: [250, 140, 190, 255],  # Artist
                    1: [250, 140, 190, 255],  # Album
                    2: [250, 220, 190, 255],  # Track
                    3: [240, 240, 160, 255],  # Genre
                    5: [250, 100, 50, 255],   # Folder
                    6: [180, 250, 190, 255],  # Composer
                    7: [250, 50, 140, 255],   # Year
                    8: [100, 210, 250, 255],  # Playlist
                    10: [145, 245, 78, 255],  # Spotify Artist
                    11: [130, 237, 69, 255],  # Spotify Album
                    12: [200, 255, 150, 255]  # Spotify Track
                }
                if n not in names:
                    name = "NYI"
                    colour = [255, 255, 255, 255]
                else:
                    name = names[n]
                    colour = type_colours[n]
                    colour[3] = int(colour[3] * fade)

                pad = round(4 * gui.scale)
                height = round(25 * gui.scale)
                if n in (1, 11):
                    height = round(50 * gui.scale)
                album_art_size = height


                # Selection bar
                s_rect = (highlight_x, yy, 600 * gui.scale, height + pad + pad - 1)
                fields.add(s_rect)
                if fade == 1:
                    ddt.rect((highlight_x, yy + pad, 4 * gui.scale, height), bar_colour)
                if n in (2,):
                    if key_ctrl_down and item[2] in default_playlist:
                        ddt.rect((highlight_x + round(5 * gui.scale), yy + pad, 4 * gui.scale, height), track_in_bar_colour)

                # Type text
                if n in (0, 3, 5, 6, 7, 8, 10, 12):
                    ddt.text((thumbnail_rx, yy + pad + round(3 * gui.scale), 1), names[n], type_colours[n], 214)

                # Thumbnail
                if n in (1, 2):
                    thl = thumbnail_rx - album_art_size
                    ddt.rect((thl, yy + pad, album_art_size, album_art_size), [50, 50, 50, 150])
                    gall_ren.render(pctl.g(item[2]), (thl, yy + pad), album_art_size)
                    if fade != 1:
                        ddt.rect((thl, yy + pad, album_art_size, album_art_size), [0, 0, 0, 70])
                if n in (11,):
                    thl = thumbnail_rx - album_art_size
                    ddt.rect((thl, yy + pad, album_art_size, album_art_size), [50, 50, 50, 150])
                    # gall_ren.render(pctl.g(item[2]), (50 * gui.scale, yy + 5), 50 * gui.scale)
                    if not item[5].draw(thumbnail_rx - album_art_size, yy + pad):
                        try:
                            gall_ren.lock.release()
                        except:
                            pass

                # Result text
                if n in (0, 5, 6, 7, 8, 10):  # Bold
                    xx = ddt.text((text_lx, yy + pad + round(3 * gui.scale)), item[1], [255, 255, 255, int(255 * fade)], b_font)
                if n in (3,):  # Genre
                    xx = ddt.text((text_lx, yy + pad + round(3 * gui.scale)), item[1].rstrip("+"), [255, 255, 255, int(255 * fade)], b_font)
                    if item[1].endswith("+"):
                        ddt.text((xx + text_lx + 13 * gui.scale, yy + pad + round(3 * gui.scale)), "(Include multi-tag results)",
                                 [255, 255, 255, int(255 * fade) // 2], 313)
                if n == 11:  # Spotify Album
                    xx = ddt.text((text_lx, yy + round(5 * gui.scale)), item[1][0], [255, 255, 255, int(255 * fade)], s_b_font)
                    artist = item[1][1]
                    ddt.text((text_lx + 5 * gui.scale, yy + 30 * gui.scale), "BY", [250, 240, 110, int(255 * fade)], 212)
                    xx += 8 * gui.scale
                    xx += ddt.text((text_lx + 30 * gui.scale, yy + 30 * gui.scale), artist, [250, 250, 250, int(255 * fade)], s_font)
                if n in (12,):  # Spotify Track
                    yyy = yy
                    yyy += round(6 * gui.scale)
                    xx = ddt.text((text_lx, yyy), item[1][0], [255, 255, 255, int(255 * fade)], s_font)
                    xx += 9 * gui.scale
                    ddt.text((xx + text_lx, yyy), "BY", [250, 160, 110, int(255 * fade)], 212)
                    xx += 25 * gui.scale
                    xx += ddt.text((xx + text_lx, yyy), item[1][1], [255, 255, 255, int(255 * fade)], s_b_font)
                if n in (2, ):  # Track
                    yyy = yy
                    yyy += round(6 * gui.scale)
                    track = pctl.master_library[item[2]]
                    if track.artist == track.title == "":
                        text = os.path.splitext(track.filename)[0]
                        xx = ddt.text((text_lx, yyy + pad), text, [255, 255, 255, int(255 * fade)], s_font)
                    else:
                        xx = ddt.text((text_lx, yyy), item[1], [255, 255, 255, int(255 * fade)], s_font)
                        xx += 9 * gui.scale
                        ddt.text((xx + text_lx, yyy), "BY", [250, 160, 110, int(255 * fade)], 212)
                        xx += 25 * gui.scale
                        artist = track.artist
                        xx += ddt.text((xx + text_lx, yyy), artist, [255, 255, 255, int(255 * fade)], s_b_font)
                        if track.album:
                            xx += 9 * gui.scale
                            xx += ddt.text((xx + text_lx, yyy), "FROM", [120, 120, 120, int(255 * fade)], 212)
                            xx += 8 * gui.scale
                            xx += ddt.text((xx + text_lx, yyy), track.album, [80, 80, 80, int(255 * fade)], 212)

                if n in (1,):  # Two line album
                    track = pctl.master_library[item[2]]
                    artist = track.album_artist
                    if not artist:
                        artist = track.artist

                    xx = ddt.text((text_lx, yy + pad + round(5 * gui.scale)), item[1], [255, 255, 255, int(255 * fade)], s_b_font)

                    ddt.text((text_lx + 5 * gui.scale, yy + 30 * gui.scale), "BY", [250, 240, 110, int(255 * fade)], 212)
                    xx += 8 * gui.scale
                    xx += ddt.text((text_lx + 30 * gui.scale, yy + 30 * gui.scale), artist, [250, 250, 250, int(255 * fade)], s_font)


                yy += height + pad + pad

                show = False
                go = False
                extend = False
                if coll(s_rect) and mouse_change:
                    if self.force_select != p:
                        self.force_select = p
                        gui.update = 2

                    if gui.level_2_click:
                        if key_ctrl_down:
                            extend = True
                        else:
                            go = True
                            clear = True


                    if level_2_right_click:
                        show = True
                        clear = True

                if enter and key_shift_down and fade == 1:
                    show = True
                    clear = True

                elif enter and fade == 1:
                    if key_shift_down or key_shiftr_down:
                        show = True
                        clear = True
                    else:
                        go = True
                        clear = True

                if extend:
                    match n:
                        case 0:
                            default_playlist.extend(self.click_artist(item[1], get_list=True))
                        case 1:
                            for k, pl in enumerate(pctl.multi_playlist):
                                if item[2] in pl[2]:
                                    default_playlist.extend(
                                        get_album_from_first_track(pl[2].index(item[2]), item[2], k))
                                    break
                        case 2:
                            default_playlist.append(item[2])
                        case 3:
                            default_playlist.extend(self.click_genre(item[1], get_list=True))
                        case 5:
                            default_playlist.extend(self.click_meta(item[1], get_list=True))
                        case 6:
                            default_playlist.extend(self.click_composer(item[1], get_list=True))
                        case 7:
                            default_playlist.extend(self.click_year(item[1], get_list=True))
                        case 8:
                            default_playlist.extend(pctl.multi_playlist[pl][2])
                        case 12:
                            spot_ctl.append_track(item[2])
                            reload_albums()

                    gui.pl_update += 1
                elif show:
                    match n:
                        case 0 | 1 | 2 | 3 | 5 | 6 | 7 | 10:
                            pctl.show_current(index=item[2], playing=False)
                            if album_mode:
                                show_in_gal(0)
                        case 8:
                            pl = id_to_pl(item[3])
                            if pl:
                                switch_playlist(pl)

                elif go:
                    match n:
                        case 0:
                            self.click_artist(item[1])
                        case 10:
                            show_message(_("Searching for albums by artist: ") + item[1], _("This may take a moment"))
                            shoot = threading.Thread(target=spot_ctl.artist_playlist, args=([item[2]]))
                            shoot.daemon = True
                            shoot.start()
                        case 1 | 2:
                            self.click_album(item[2])
                            pctl.show_current(index=item[2])
                            pctl.playlist_view_position = pctl.selected_in_playlist
                        case 3:
                            self.click_genre(item[1])
                        case 5:
                            self.click_meta(item[1])
                        case 6:
                            self.click_composer(item[1])
                        case 7:
                            self.click_year(item[1])
                        case 8:
                            pl = id_to_pl(item[3])
                            if pl:
                                switch_playlist(pl)
                        case 11:
                            spot_ctl.album_playlist(item[2])
                            reload_albums()
                        case 12:
                            spot_ctl.append_track(item[2])
                            reload_albums()

                if n in (2,) and keymaps.test("add-to-queue") and fade == 1:
                    queue_object = queue_item_gen(item[2],
                                                  pctl.multi_playlist[id_to_pl(item[3])][2].index(item[2]),
                                                  item[3])
                    pctl.force_queue.append(queue_object)
                    queue_timer_set(queue_object=queue_object)

                # ----

                # ---
                if i > 40:
                    break
                if yy > window_size[1] - (100 * gui.scale):
                    break

                continue

            if clear:
                self.active = False
                self.search_text.text = ""
                self.results.clear()
                self.searched_text = ""



search_over = SearchOverlay()


class MessageBox:

    def __init__(self):
        pass

    def get_rect(self):

        w1 = ddt.get_text_w(gui.message_text, 15) + 74 * gui.scale
        w2 = ddt.get_text_w(gui.message_subtext, 12) + 74 * gui.scale
        w3 = ddt.get_text_w(gui.message_subtext2, 12) + 74 * gui.scale
        w = max(w1, w2, w3)

        if w < 210 * gui.scale:
            w = 210 * gui.scale

        h = round(60 * gui.scale)
        if gui.message_subtext2:
            h += round(15 * gui.scale)

        x = int(window_size[0] / 2) - int(w / 2)
        y = int(window_size[1] / 2) - int(h / 2)

        return x, y, w, h

    def render(self):

        if inp.mouse_click or inp.key_return_press or right_click or key_esc_press or inp.backspace_press \
                or keymaps.test("quick-find") or (k_input and message_box_min_timer.get() > 1.2):

            if not key_focused and message_box_min_timer.get() > 0.4:
                gui.message_box = False
                gui.update += 1
                inp.key_return_press = False

        x, y, w, h = self.get_rect()

        ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale),
                   colours.box_text_border)
        ddt.rect_a((x, y), (w, h), colours.message_box_bg)

        ddt.text_background_colour = colours.message_box_bg

        if gui.message_mode == 'info':
            message_info_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_info_icon.h / 2) - 1)
        elif gui.message_mode == 'warning':
            message_warning_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_info_icon.h / 2) - 1)
        elif gui.message_mode == 'done':
            message_tick_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_info_icon.h / 2) - 1)
        elif gui.message_mode == 'arrow':
            message_arrow_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_info_icon.h / 2) - 1)
        elif gui.message_mode == 'download':
            message_download_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_info_icon.h / 2) - 1)
        elif gui.message_mode == 'error':
            message_error_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_error_icon.h / 2) - 1)
        elif gui.message_mode == 'bubble':
            message_bubble_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_bubble_icon.h / 2) - 1)
        elif gui.message_mode == 'link':
            message_info_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_bubble_icon.h / 2) - 1)
        elif gui.message_mode == 'confirm':
            message_info_icon.render(x + 14 * gui.scale, y + int(h / 2) - int(message_info_icon.h / 2) - 1)
            ddt.text((x + 62 * gui.scale, y + 9 * gui.scale), gui.message_text, colours.message_box_text, 15)
            if draw.button("Yes", (w // 2 + x) - 70 * gui.scale, y + 32 * gui.scale, w=60*gui.scale):
                gui.message_box_confirm_callback(*gui.message_box_confirm_reference)
            if draw.button("No", (w // 2 + x) + 25 * gui.scale, y + 32 * gui.scale, w=60*gui.scale):
                gui.message_box = False
            return

        if gui.message_subtext:
            ddt.text((x + 62 * gui.scale, y + 11 * gui.scale), gui.message_text, colours.message_box_text, 15)
            if gui.message_mode == "bubble" or gui.message_mode == 'link':
                link_pa = draw_linked_text((x + 63 * gui.scale, y + (9 + 22) * gui.scale), gui.message_subtext,
                                           colours.message_box_text, 12)
                link_activate(x + 63 * gui.scale, y + (9 + 22) * gui.scale, link_pa)
            else:
                ddt.text((x + 63 * gui.scale, y + (9 + 22) * gui.scale), gui.message_subtext, colours.message_box_text,
                         12)

            if gui.message_subtext2:
                ddt.text((x + 63 * gui.scale, y + (9 + 42) * gui.scale), gui.message_subtext2, colours.message_box_text,
                         12)

        else:
            ddt.text((x + 62 * gui.scale, y + 20 * gui.scale), gui.message_text, colours.message_box_text, 15)


message_box = MessageBox()


class NagBox:
    def __init__(self):
        self.wiggle_timer = Timer(10)

    def draw(self):
        w = 485 * gui.scale
        h = 165 * gui.scale
        x = int(window_size[0] / 2) - int(w / 2)
        # if self.wiggle_timer.get() < 0.5:
        #     gui.update += 1
        #     x += math.sin(core_timer.get() * 40) * 4
        y = int(window_size[1] / 2) - int(h / 2)

        # xx = x - round(8 * gui.scale)
        # hh = 0.0 #349 / 360
        # while xx < x + w + round(8 * gui.scale):
        #     re = [xx, y - round(8 * gui.scale), 3, h + round(8 * gui.scale) + round(8 * gui.scale)]
        #     hh -= 0.0007
        #     c = hsl_to_rgb(hh, 0.9, 0.7)
        #     #c = hsl_to_rgb(hh, 0.63, 0.43)
        #     ddt.rect(re, c)
        #     xx += 3

        ddt.rect_a((x - 2 * gui.scale, y - 2 * gui.scale), (w + 4 * gui.scale, h + 4 * gui.scale),
                   colours.box_text_border)
        ddt.rect_a((x, y), (w, h), colours.message_box_bg)

        # if gui.level_2_click and not coll((x, y, w, h)):
        #     if core_timer.get() < 2:
        #         self.wiggle_timer.set()
        #     else:
        #         prefs.show_nag = False
        #
        #     gui.update += 1

        ddt.text_background_colour = colours.message_box_bg

        x += round(10 * gui.scale)
        y += round(13 * gui.scale)
        ddt.text((x, y), "Welcome to v7.2.0!", colours.message_box_text, 212)
        y += round(20 * gui.scale)

        link_pa = draw_linked_text((x, y),
                                   "You can check out the release notes on the https://github.com/Taiko2k/TauonMusicBox/releases",
                                   colours.message_box_text, 12, replace="Github release page.")
        link_activate(x, y, link_pa, click=gui.level_2_click)

        heart_notify_icon.render(x + round(425 * gui.scale), y + round(80 * gui.scale), [255, 90, 90, 255])

        y += round(30 * gui.scale)
        ddt.text((x, y), "New supporter bonuses!", colours.message_box_text, 212)

        y += round(20 * gui.scale)

        ddt.text((x, y), "A new supporter bonus theme is now available! Check it out at the above link!",
                 colours.message_box_text, 12)
        # link_activate(x, y, link_pa, click=gui.level_2_click)

        y += round(20 * gui.scale)
        ddt.text((x, y), "Your support means a lot! Love you!", colours.message_box_text, 12)

        y += round(30 * gui.scale)

        if draw.button("Close", x, y, press=gui.level_2_click):
            prefs.show_nag = False
            # show_message("Oh... :( 💔")
        # if draw.button("Show supporter page", x + round(304 * gui.scale), y, background_colour=[60, 140, 60, 255], background_highlight_colour=[60, 150, 60, 255], press=gui.level_2_click):
        #     webbrowser.open("https://github.com/sponsors/Taiko2k", new=2, autoraise=True)
        # prefs.show_nag = False
        # if draw.button("I already am!", x + round(360), y, press=gui.level_2_click):
        #     show_message("Oh hey, thanks! :)")
        #     prefs.show_nag = False


nagbox = NagBox()


def worker3():
    while True:
        # time.sleep(0.04)

        # if tm.exit_worker3:
        #     tm.exit_worker3 = False
        #     return
        # time.sleep(1)

        gall_ren.worker_render()


def worker4():
    gui.style_worker_timer.set()
    while True:
        if prefs.art_bg or (gui.mode == 3 and prefs.mini_mode_mode == 5):
            style_overlay.worker()

        time.sleep(0.01)
        if pctl.playing_state > 0 and pctl.playing_time < 5:
            gui.style_worker_timer.set()
        if gui.style_worker_timer.get() > 5:
            return


worker2_lock = threading.Lock()
spot_search_rate_timer = Timer()


def worker2():
    while True:
        worker2_lock.acquire()

        if search_over.search_text.text and not (len(search_over.search_text.text) == 1 and ord(search_over.search_text.text[0]) < 128):

            if search_over.spotify_mode:
                t = spot_search_rate_timer.get()
                if t < 1:
                    time.sleep(1 - t)
                    spot_search_rate_timer.set()
                print("Spotify search")
                search_over.results.clear()
                results = spot_ctl.search(search_over.search_text.text)
                if results is not None:
                    search_over.results = results
                else:
                    search_over.active = False
                    gui.show_message(
                        "Global search + Tab triggers Spotify search but Spotify is not enabled in settings!",
                        mode="warning")
                search_over.searched_text = search_over.search_text.text
                search_over.sip = False

            elif True:
                # perf_timer.set()

                temp_results = []

                search_over.searched_text = search_over.search_text.text

                artists = {}
                albums = {}
                genres = {}
                metas = {}
                composers = {}
                years = {}

                tracks = set()

                br = 0

                if search_over.searched_text in ('the', 'and'):
                    continue

                search_over.sip = True
                gui.update += 1

                o_text = search_over.search_text.text.lower().replace("-", "")

                dia_mode = False
                if all([ord(c) < 128 for c in o_text]):
                    dia_mode = True

                artist_mode = False
                if o_text.startswith("artist "):
                    o_text = o_text[7:]
                    artist_mode = True

                album_mode = False
                if o_text.startswith("album "):
                    o_text = o_text[6:]
                    album_mode = True

                composer_mode = False
                if o_text.startswith("composer "):
                    o_text = o_text[9:]
                    composer_mode = True

                year_mode = False
                if o_text.startswith("year "):
                    o_text = o_text[5:]
                    year_mode = True

                cn_mode = False
                if use_cc and re.search(r'[\u4e00-\u9fff\u3400-\u4dbf\u20000-\u2a6df\u2a700-\u2b73f\u2b740-\u2b81f\u2b820-\u2ceaf\uf900-\ufaff\u2f800-\u2fa1f]', o_text):
                    t_cn = s2t.convert(o_text)
                    s_cn = t2s.convert(o_text)
                    cn_mode = True

                s_text = o_text

                searched = set()

                for playlist in pctl.multi_playlist:

                    # if "<" in playlist[0]:
                    #     # print("Skipping search on derivative playlist: " + playlist[0])
                    #     continue

                    for track in playlist[2]:

                        if track in searched:
                            continue
                        else:
                            searched.add(track)


                        if cn_mode:
                            s_text = o_text
                            cache_string = search_string_cache.get(track)
                            if cache_string:
                                if search_magic_any(s_text, cache_string):
                                    pass
                                elif search_magic_any(t_cn, cache_string):
                                    s_text = t_cn
                                elif search_magic_any(s_cn, cache_string):
                                    s_text = s_cn

                        if dia_mode:
                            cache_string = search_dia_string_cache.get(track)
                            if cache_string is not None:
                                if not search_magic_any(s_text, cache_string):
                                    continue
                                # if s_text not in cache_string:
                                #     continue
                        else:
                            cache_string = search_string_cache.get(track)
                            if cache_string is not None:
                                if not search_magic_any(s_text, cache_string):
                                    continue

                        t = pctl.master_library[track]

                        title = t.title.lower().replace("-", "")
                        artist = t.artist.lower().replace("-", "")
                        album_artist = t.album_artist.lower().replace("-", "")
                        composer = t.composer.lower().replace("-", "")
                        date = t.date.lower().replace("-", "")
                        album = t.album.lower().replace("-", "")
                        genre = t.genre.lower().replace("-", "")
                        filename = t.filename.lower().replace("-", "")
                        stem = os.path.dirname(t.parent_folder_path).lower().replace("-", "")
                        sartist = t.misc.get("artist_sort", "").lower()

                        if cache_string is None:
                            if not dia_mode:
                                search_string_cache[
                                    track] = title + artist + album_artist + composer + date + album + genre + sartist + filename + stem

                            if cn_mode:
                                cache_string = search_string_cache.get(track)
                                if cache_string:
                                    if search_magic_any(s_text, cache_string):
                                        pass
                                    elif search_magic_any(t_cn, cache_string):
                                        s_text = t_cn
                                    elif search_magic_any(s_cn, cache_string):
                                        s_text = s_cn

                        if dia_mode:
                            title = unidecode(title).decode()

                            artist = unidecode(artist).decode()
                            album_artist = unidecode(album_artist).decode()
                            composer = unidecode(composer).decode()
                            album = unidecode(album).decode()
                            filename = unidecode(filename).decode()
                            sartist = unidecode(sartist).decode()

                            if cache_string is None:
                                search_dia_string_cache[
                                    track] = title + artist + album_artist + composer + date + album + genre + sartist + filename + stem

                        stem = os.path.dirname(t.parent_folder_path)

                        if len(s_text) > 2 and s_text in stem.replace("-", "").lower():
                            # if search_over.all_folders or (artist not in stem.lower() and album not in stem.lower()):

                            if stem in metas:
                                metas[stem] += 2
                            else:
                                temp_results.append([5, stem, track, playlist[6], 0])
                                metas[stem] = 2

                        if s_text in genre:

                            if "/" in genre or "," in genre or ";" in genre:

                                for split in genre.replace(";", "/").replace(",", "/").split("/"):
                                    if s_text in split:

                                        split = genre_correct(split)
                                        if prefs.sep_genre_multi:
                                            split += "+"
                                        if split in genres:
                                            genres[split] += 3
                                        else:
                                            temp_results.append([3, split, track, playlist[6], 0])
                                            genres[split] = 1
                            else:
                                name = genre_correct(t.genre)
                                if name in genres:
                                    genres[name] += 3
                                else:
                                    temp_results.append([3, name, track, playlist[6], 0])
                                    genres[name] = 1

                        if s_text in composer:

                            if t.composer in composers:
                                composers[t.composer] += 2
                            else:
                                temp_results.append([6, t.composer, track, playlist[6], 0])
                                composers[t.composer] = 2

                        if s_text in date:

                            year = get_year_from_string(date)
                            if year:

                                if year in years:
                                    years[year] += 1
                                else:
                                    temp_results.append([7, year, track, playlist[6], 0])
                                    years[year] = 1000

                        if search_magic(s_text, title + artist + filename + album + sartist + album_artist):

                            if 'artists' in t.misc and t.misc['artists']:
                                for a in t.misc['artists']:
                                    if search_magic(s_text, a.lower()):

                                        value = 1
                                        if a.lower().startswith(s_text):
                                            value = 5

                                        # Add artist
                                        if a in artists:
                                            artists[a] += value
                                        else:
                                            temp_results.append([0, a, track, playlist[6], 0])
                                            artists[a] = value

                                        if t.album in albums:
                                            albums[t.album] += 1
                                        else:
                                            temp_results.append([1, t.album, track, playlist[6], 0])
                                            albums[t.album] = 1

                            elif search_magic(s_text, artist + sartist):

                                value = 1
                                if artist.startswith(s_text):
                                    value = 10

                                # Add artist
                                if t.artist in artists:
                                    artists[t.artist] += value
                                else:
                                    temp_results.append([0, t.artist, track, playlist[6], 0])
                                    artists[t.artist] = value

                                if t.album in albums:
                                    albums[t.album] += 1
                                else:
                                    temp_results.append([1, t.album, track, playlist[6], 0])
                                    albums[t.album] = 1

                            elif search_magic(s_text, album_artist):

                                # Add album artist
                                value = 1
                                if t.album_artist.startswith(s_text):
                                    value = 5

                                if t.album_artist in artists:
                                    artists[t.album_artist] += value
                                else:
                                    temp_results.append([0, t.album_artist, track, playlist[6], 0])
                                    artists[t.album_artist] = value

                                if t.album in albums:
                                    albums[t.album] += 1
                                else:
                                    temp_results.append([1, t.album, track, playlist[6], 0])
                                    albums[t.album] = 1

                            if s_text in album:

                                value = 1
                                if s_text == album:
                                    value = 3

                                if t.album in albums:
                                    albums[t.album] += value
                                else:
                                    temp_results.append([1, t.album, track, playlist[6], 0])
                                    albums[t.album] = value

                            if search_magic(s_text, artist + sartist) or search_magic(s_text, album):

                                if t.album in albums:
                                    albums[t.album] += 3
                                else:
                                    temp_results.append([1, t.album, track, playlist[6], 0])
                                    albums[t.album] = 3

                            elif search_magic_any(s_text, artist + sartist) and search_magic_any(s_text, album):

                                if t.album in albums:
                                    albums[t.album] += 3
                                else:
                                    temp_results.append([1, t.album, track, playlist[6], 0])
                                    albums[t.album] = 3

                            if s_text in title:

                                if t not in tracks:

                                    value = 50
                                    if s_text == title:
                                        value = 200

                                    temp_results.append([2, t.title, track, playlist[6], value])

                                    tracks.add(t)

                            else:
                                if t not in tracks:
                                    temp_results.append([2, t.title, track, playlist[6], 1])

                                    tracks.add(t)

                        br += 1
                        if br > 800:
                            time.sleep(0.005)  # Throttle thread
                            br = 0
                            if search_over.searched_text != search_over.search_text.text:
                                break

                search_over.sip = False
                search_over.on = 0
                gui.update += 1

                # Remove results not matching any filter keyword

                if artist_mode:
                    for i in reversed(range(len(temp_results))):
                        if temp_results[i][0] != 0:
                            del temp_results[i]

                elif album_mode:
                    for i in reversed(range(len(temp_results))):
                        if temp_results[i][0] != 1:
                            del temp_results[i]

                elif composer_mode:
                    for i in reversed(range(len(temp_results))):
                        if temp_results[i][0] != 6:
                            del temp_results[i]

                elif year_mode:
                    for i in reversed(range(len(temp_results))):
                        if temp_results[i][0] != 7:
                            del temp_results[i]

                # Sort results by weightings
                for i, item in enumerate(temp_results):
                    if item[0] == 0:
                        temp_results[i][4] = artists[item[1]]
                    if item[0] == 1:
                        temp_results[i][4] = albums[item[1]]
                    if item[0] == 3:
                        temp_results[i][4] = genres[item[1]]
                    if item[0] == 5:
                        temp_results[i][4] = metas[item[1]]
                        if not search_over.all_folders:
                            if metas[item[1]] < 42:
                                temp_results[i] = None
                    if item[0] == 6:
                        temp_results[i][4] = composers[item[1]]
                    if item[0] == 7:
                        temp_results[i][4] = years[item[1]]
                    # 8 is playlists

                temp_results[:] = [item for item in temp_results if item is not None]
                search_over.results = sorted(temp_results, key=lambda x: x[4], reverse=True)
                # print(search_over.results)

                i = 0
                for playlist in pctl.multi_playlist:
                    if search_magic(s_text, playlist[0].lower()):
                        item = [8, playlist[0], None, playlist[6], 100000]
                        search_over.results.insert(0, item)
                        i += 1
                        if i > 3:
                            break

                search_over.on = 0
                search_over.force_select = 0
                # print(perf_timer.get())


def encode_track_name(t):
    if t.is_cue or not t.filename:
        out_line = str(t.track_number) + ". "
        out_line += t.artist + " - " + t.title
        return filename_safe(out_line)
    else:
        return os.path.splitext(t.filename)[0]


tauon.encode_track_name = encode_track_name


def encode_folder_name(track_object):
    folder_name = track_object.artist + " - " + track_object.album

    if folder_name == " - ":
        folder_name = track_object.parent_folder_name

    folder_name = filename_safe(folder_name).strip()

    if not folder_name:
        folder_name = str(track_object.index)

    if "cd" not in folder_name.lower() or "disc" not in folder_name.lower():
        if track_object.disc_total not in ("", "0", 0, "1", 1) or (
                str(track_object.disc_number).isdigit() and int(track_object.disc_number) > 1):
            folder_name += " CD" + str(track_object.disc_number)

    return folder_name


tauon.encode_folder_name = encode_folder_name


def worker1():
    global cue_list
    global loaderCommand
    global loaderCommandReady
    global DA_Formats
    global home
    global loading_in_progress
    global added
    global to_get
    global to_got

    loaded_pathes_cache = {}
    loaded_cue_cache = {}
    added = []

    def get_quoted_from_line(line):

        # e.g extract quoted file name from: 'FILE "01 - Track01.wav" WAVE'

        file_name = ""
        enable = False

        for cha in line:
            if not enable and cha == "\"":
                enable = True
            elif enable:
                if cha == "\"":
                    return file_name
                file_name += cha

        return file_name

    def add_from_cue(path):

        global added

        if not msys:  # Windows terminal doesn't like unicode
            console.print("Reading CUE file: " + path)

        try:

            try:
                with open(path, encoding="utf_8") as f:
                    content = f.readlines()
            except:
                try:
                    with open(path, encoding="utf_16") as f:
                        content = f.readlines()
                        print("CUE: Detected encoding as UTF-16")
                except:
                    try:
                        j = False
                        try:
                            with open(path, encoding='shiftjis') as f:
                                content = f.readlines()
                                for line in content:
                                    for c in j_chars:
                                        if c in line:
                                            j = True
                                            print("CUE: Detected encoding as SHIFT-JIS")
                                            break
                        except:
                            pass
                        if not j:
                            with open(path, encoding='windows-1251') as f:
                                content = f.readlines()
                            print("CUE: Detected encoding as windows-1251")

                    except:
                        print("WARNING: Can't detect encoding of CUE file")
                        return 1

            f.close()

            # We want to detect if this is a cue sheet that points to either a single file with subtracks, or multiple
            # files with mutiple subtracks, but not multiple files that are individual tracks.
            # i.e, is there really any splitting going on.

            files = 0
            files_with_subtracks = 0
            subtrack_count = 0
            for line in content:
                if line.startswith("FILE "):
                    files += 1
                    if subtrack_count > 2:  # A hack way to avoid non-compliant EAC CUE sheet
                        files_with_subtracks += 1
                    subtrack_count = 0
                elif line.strip().startswith("TRACK "):
                    subtrack_count += 1
            if subtrack_count > 2:
                files_with_subtracks += 1

            if files == 1:
                pass
            elif files_with_subtracks > 1:
                pass
            else:
                return 1

            cue_performer = ""
            cue_date = ""
            cue_album = ""
            cue_genre = ""
            cue_main_performer = ""
            cue_songwriter = ""
            cue_disc = 0
            cue_disc_total = 0

            cd = []
            cds = []

            file_name = ""
            file_path = ""

            in_header = True

            i = -1
            while True:
                i += 1

                if i > len(content) - 1:
                    break

                line = content[i]

                line = line.strip()

                if in_header:
                    if line.startswith("REM "):
                        line = line[4:]

                    if line.startswith("TITLE \""):
                        cue_album = get_quoted_from_line(line)
                    if line.startswith("PERFORMER \""):
                        cue_performer = get_quoted_from_line(line)
                    if line.startswith("MAIN PERFORMER \""):
                        cue_main_performer = get_quoted_from_line(line)
                    if line.startswith("SONGWRITER \""):
                        cue_songwriter = get_quoted_from_line(line)
                    if line.startswith("GENRE "):
                        cue_genre = line[5:].strip().replace("\"", "")
                    if line.startswith("DATE "):
                        cue_date = line[5:].strip().replace("\"", "")
                    if line.startswith("DISCNUMBER "):
                        cue_disc = line[11:].strip().replace("\"", "")
                    if line.startswith("TOTALDISCS "):
                        cue_disc_total = line[11:].strip().replace("\"", "")

                    if line.startswith("FILE "):
                        in_header = False
                    else:
                        continue

                if line.startswith("FILE "):

                    if cd:
                        cds.append(cd)
                        cd = []

                    file_name = get_quoted_from_line(line)
                    file_path = os.path.join(os.path.dirname(path), file_name)

                    if not os.path.isfile(file_path):
                        if files == 1:
                            print("CUE: The referenced source file wasn't found. Searching for matching file name...")
                            for item in os.listdir(os.path.dirname(path)):
                                if os.path.splitext(item)[0] == os.path.splitext(os.path.basename(path))[0]:
                                    if ".cue" not in item.lower() and item.split(".")[-1].lower() in DA_Formats:
                                        file_name = item
                                        file_path = os.path.join(os.path.dirname(path), file_name)
                                        print("CUE: Source found")
                                        break
                            else:
                                print("CUE: Source file not found")
                                return 1
                        else:
                            print("CUE: Source file not found")
                            return 1

                if line.startswith("TRACK "):
                    line = line[6:]
                    if line.endswith("AUDIO"):
                        line = line[:-5]

                    c = loaded_cue_cache.get((file_path.replace('\\', '/'), int(line.strip())))
                    if c is not None:
                        nt = c
                    else:
                        nt = TrackClass()
                        nt.index = pctl.master_count
                        pctl.master_count += 1

                    nt.fullpath = file_path
                    nt.filename = file_name
                    nt.parent_folder_path = os.path.dirname(file_path.replace('\\', '/'))
                    nt.parent_folder_name = os.path.splitext(os.path.basename(file_path))[0]
                    nt.file_ext = os.path.splitext(file_name)[1][1:].upper()
                    nt.is_cue = True

                    nt.album_artist = cue_main_performer
                    if not cue_main_performer:
                        nt.album_artist = cue_performer
                    nt.artist = cue_performer
                    nt.composer = cue_songwriter
                    nt.genre = cue_genre
                    nt.album = cue_album
                    nt.date = cue_date.replace('"', '')
                    nt.track_number = int(line.strip())
                    if nt.track_number == 1:
                        nt.size = os.path.getsize(nt.fullpath)
                    nt.misc["parent-size"] = os.path.getsize(nt.fullpath)

                    while True:
                        i += 1
                        if i > len(content) - 1 or content[i].startswith("FILE ") or content[i].strip().startswith(
                                "TRACK"):
                            break

                        line = content[i]
                        line = line.strip()

                        if line.startswith("TITLE"):
                            nt.title = get_quoted_from_line(line)
                        if line.startswith("PERFORMER"):
                            nt.artist = get_quoted_from_line(line)
                        if line.startswith("SONGWRITER"):
                            nt.composer = get_quoted_from_line(line)
                        if line.startswith("INDEX 01 ") and ":" in line:
                            line = line[9:]
                            times = line.split(":")
                            nt.start_time = int(times[0]) * 60 + int(times[1]) + int(times[2]) / 100

                    i -= 1
                    cd.append(nt)

            if cd:
                cds.append(cd)

            for cdn, cd in enumerate(cds):

                last_end = None
                end_track = TrackClass()
                end_track.fullpath = cd[-1].fullpath
                tag_scan(end_track)

                # Remove target track if already imported
                for i in reversed(range(len(added))):
                    if pctl.g(added[i]).fullpath == end_track.fullpath:
                        del added[i]

                # Update with proper length
                for track in reversed(cd):

                    if last_end == None:
                        last_end = end_track.length

                    track.length = last_end - track.start_time
                    track.samplerate = end_track.samplerate
                    track.bitrate = end_track.bitrate
                    track.bit_depth = end_track.bit_depth
                    track.misc["parent-length"] = end_track.length
                    last_end = track.start_time

                    # inherit missing metadata
                    if not track.date:
                        track.date = end_track.date
                    if not track.album_artist:
                        track.album_artist = end_track.album_artist
                    if not track.album:
                        track.album = end_track.album
                    if not track.artist:
                        track.artist = end_track.artist
                    if not track.genre:
                        track.genre = end_track.genre
                    if not track.comment:
                        track.comment = end_track.comment
                    if not track.composer:
                        track.composer = end_track.composer

                    if cue_disc:
                        track.disc_number = cue_disc
                    elif len(cds) == 0:
                        track.disc_number = ""
                    else:
                        track.disc_number = str(cdn)

                    if cue_disc_total:
                        track.disc_total = cue_disc_total
                    elif len(cds) == 0:
                        track.disc_total = ""
                    else:
                        track.disc_total = str(len(cds))


            # Add all tracks for import to playlist
            for cd in cds:
                for track in cd:
                    pctl.master_library[track.index] = track
                    if track.fullpath not in cue_list:
                        cue_list.append(track.fullpath)
                    loaded_pathes_cache[track.fullpath] = track.index
                    added.append(track.index)

        except:
            print("Error in processing CUE file")
            # raise

    def add_file(path, force_scan=False):
        # bm.get("add file start")
        global DA_Formats
        global to_got

        if not os.path.isfile(path):
            print("file to import missing")
            return 0

        if os.path.splitext(path)[1][1:] in {"CUE", 'cue'}:
            add_from_cue(path)
            return 0

        if path.lower().endswith('.xspf'):
            print('found XSPF file at: ' + path)
            load_xspf(path)
            return 0

        if path.lower().endswith(".m3u"):
            load_m3u(path)
            return 0

        if path.endswith(".pls"):
            load_pls(path)
            return 0

        if os.path.splitext(path)[1][1:].lower() not in DA_Formats:
            if os.path.splitext(path)[1][1:].lower() in Archive_Formats:
                if not prefs.auto_extract:
                    show_message("You attempted to drop an archive.",
                                 'However the "extract archive" function is not enabled.', mode='info')
                else:
                    type = os.path.splitext(path)[1][1:].lower()
                    split = os.path.splitext(path)
                    target_dir = split[0]
                    if prefs.extract_to_music and music_directory is not None:
                        target_dir = os.path.join(music_directory, os.path.basename(target_dir))
                    # print(os.path.getsize(path))
                    if os.path.getsize(path) > 4e+9:
                        print("Archive file is large!")
                        show_message("Skipping oversize zip file (>4GB)")
                        return 1
                    if not os.path.isdir(target_dir) and not os.path.isfile(target_dir):
                        if type == "zip":
                            try:
                                b = to_got
                                to_got = "ex"
                                gui.update += 1
                                zip_ref = zipfile.ZipFile(path, 'r')

                                zip_ref.extractall(target_dir)
                                zip_ref.close()
                            except RuntimeError as e:
                                to_got = b
                                print("Zip error")
                                if 'encrypted' in e:
                                    show_message("Failed to extract zip archive.",
                                                 "The archive is encrypted. You'll need to extract it manually with the password.",
                                                 mode='warning')
                                else:
                                    show_message("Failed to extract zip archive.",
                                                 "Maybe archive is corrupted? Does disk have enough space and have write permission?",
                                                 mode='warning')
                                return 1
                            except:
                                print("Zip error 2")
                                to_got = b
                                show_message("Failed to extract zip archive.",
                                             "Maybe archive is corrupted? Does disk have enough space and have write permission?",
                                             mode='warning')
                                return 1

                        elif type == 'rar':
                            b = to_got
                            try:
                                to_got = "ex"
                                gui.update += 1
                                line = launch_prefix + "unrar x -y -p- " + shlex.quote(path) + " " + shlex.quote(
                                    target_dir) + os.sep
                                result = subprocess.run(shlex.split(line))
                                print(result)
                            except:
                                to_got = b
                                show_message("Failed to extract rar archive.", mode='warning')

                                return 1

                        elif type == '7z':
                            b = to_got
                            try:
                                to_got = "ex"
                                gui.update += 1
                                line = launch_prefix + "7z x -y " + shlex.quote(path) + " -o" + shlex.quote(
                                    target_dir) + os.sep
                                result = subprocess.run(shlex.split(line))
                                print(result)
                            except:
                                to_got = b
                                show_message("Failed to extract 7z archive.", mode='warning')

                                return 1

                        upper = os.path.dirname(target_dir)
                        cont = os.listdir(target_dir)
                        new = upper + "/temporaryfolderd"
                        error = False
                        if len(cont) == 1 and os.path.isdir(split[0] + "/" + cont[0]):
                            print("one thing")
                            os.rename(target_dir, new)
                            try:
                                shutil.move(new + "/" + cont[0], upper)
                            except:
                                error = True
                            shutil.rmtree(new)
                            print(new)
                            target_dir = upper + "/" + cont[0]
                            if not os.path.isdir(target_dir):
                                print("Extract error, expected directory not found")

                        if True and not error and prefs.auto_del_zip:
                            print("Moving archive file to trash: " + path)
                            try:
                                send2trash(path)
                            except:
                                show_message("Could not move archive to trash", path, mode='info')

                        to_got = b
                        gets(target_dir)
                        quick_import_done.append(target_dir)
                    # gets(target_dir)

            return 1

        to_got += 1
        gui.update = 1

        path = path.replace('\\', '/')

        if path in loaded_pathes_cache:
            de = loaded_pathes_cache[path]

            if pctl.master_library[de].fullpath in cue_list:
                print("File has an associated .cue file... Skipping")
                return

            if pctl.master_library[de].file_ext.lower() in GME_Formats:
                # Skip cache for subtrack formats
                pass
            else:
                added.append(de)
                return

        time.sleep(0.002)

        # audio = auto.File(path)

        nt = TrackClass()

        nt.index = pctl.master_count
        set_path(nt, path)

        def commit_track(nt):
            pctl.master_library[pctl.master_count] = nt
            added.append(pctl.master_count)

            if prefs.auto_sort or force_scan:
                tag_scan(nt)
            else:
                after_scan.append(nt)
                tm.ready("worker")

            pctl.master_count += 1

        # nt = tag_scan(nt)
        if nt.cue_sheet != "":
            tag_scan(nt)
            cue_scan(nt.cue_sheet, nt)
            del nt

        elif nt.file_ext.lower() in GME_Formats and gme:

            emu = ctypes.c_void_p()
            err = gme.gme_open_file(nt.fullpath.encode("utf-8"), ctypes.byref(emu), -1)
            if not err:
                n = gme.gme_track_count(emu)
                for i in range(n):
                    nt = TrackClass()
                    set_path(nt, path)
                    nt.index = pctl.master_count
                    nt.subtrack = i
                    commit_track(nt)

                gme.gme_delete(emu)

        else:

            commit_track(nt)

        # bm.get("fill entry")
        if gui.auto_play_import:
            pctl.jump(pctl.master_count - 1)
            gui.auto_play_import = False

    # Count the approx number of files to be imported
    def pre_get(direc):

        global to_get

        to_get = 0
        for root, dirs, files in os.walk(direc):
            to_get += len(files)
            if gui.im_cancel:
                return
            gui.update = 3

    def gets(direc, force_scan=False):

        global DA_Formats

        if os.path.basename(direc) == "__MACOSX":
            return

        try:
            items_in_dir = os.listdir(direc)
            if use_natsort:
                items_in_dir = natsort.os_sorted(items_in_dir)
            else:
                items_in_dir.sort()
        except PermissionError:

            if snap_mode:
                show_message(_("Permission error accessing one or more files."),
                             _("If this location is on external media, see") + " https://github.com/Taiko2k/TauonMusicBox/wiki/Snap-Permissions",
                             mode='bubble')
            else:
                show_message(_("Permission error accessing one or more files"), mode='warning')

            return

        for q in range(len(items_in_dir)):
            if items_in_dir[q][0] == ".":
                continue
            if os.path.isdir(os.path.join(direc, items_in_dir[q])):
                gets(os.path.join(direc, items_in_dir[q]))
            if gui.im_cancel:
                return

        for q in range(len(items_in_dir)):
            if items_in_dir[q][0] == ".":
                continue
            if os.path.isdir(os.path.join(direc, items_in_dir[q])) is False:

                if os.path.splitext(items_in_dir[q])[1][1:].lower() in DA_Formats:

                    if len(items_in_dir[q]) > 2 and items_in_dir[q][0:2] == "._":
                        continue

                    add_file(os.path.join(direc, items_in_dir[q]).replace('\\', '/'), force_scan)

                elif os.path.splitext(items_in_dir[q])[1][1:] in {"CUE", 'cue'}:
                    add_from_cue(os.path.join(direc, items_in_dir[q]).replace('\\', '/'))

            if gui.im_cancel:
                return

    def cache_paths():
        dic = {}
        dic2 = {}
        for key, value in pctl.master_library.items():
            if value.is_network:
                continue
            dic[value.fullpath.replace('\\', '/')] = key
            if value.is_cue:
                dic2[(value.fullpath.replace('\\', '/'), value.track_number)] = value
        return dic, dic2


    # print(pctl.master_library)

    global transcode_list
    global transcode_state
    global album_art_gen
    global cm_clean_db
    global to_got
    global to_get
    global move_in_progress

    active_timer = Timer()
    while True:

        if not after_scan:
            time.sleep(0.1)

        if after_scan or load_orders or \
                artist_list_box.load or \
                artist_list_box.to_fetch or \
                gui.regen_single_id or \
                gui.regen_single > -1 or \
                pctl.after_import_flag or \
                tauon.worker_save_state or \
                move_jobs or \
                cm_clean_db or \
                transcode_list or \
                to_scan or \
                loaderCommandReady:
            active_timer.set()
        elif active_timer.get() > 5:
            return

        if after_scan:
            i = 0
            while after_scan:
                i += 1

                if i > 123:
                    break

                tag_scan(after_scan[0])

                gui.update = 2
                gui.pl_update = 1
                # time.sleep(0.001)
                if pctl.running:
                    del after_scan[0]
                else:
                    break

            album_artist_dict.clear()

        artist_list_box.worker()

        # Update smart playlists
        if gui.regen_single_id is not None:
            regenerate_playlist(pl=-1, silent=True, id=gui.regen_single_id)
            gui.regen_single_id = None

        # Update smart playlists
        if gui.regen_single > -1:
            target = gui.regen_single
            gui.regen_single = -1
            regenerate_playlist(target, silent=True)

        if pctl.after_import_flag and not after_scan and not search_over.active and not loading_in_progress:
            pctl.after_import_flag = False

            for i, plist in enumerate(pctl.multi_playlist):
                if pl_to_id(i) in pctl.gen_codes:
                    code = pctl.gen_codes[pl_to_id(i)]
                    try:
                        if check_auto_update_okay(code, pl=i):
                            if not pl_is_locked(i):
                                print("Reloading smart playlist: " + plist[0])
                                regenerate_playlist(i, silent=True)
                                time.sleep(0.02)
                    except:
                        pass
            tree_view_box.clear_all()

        if tauon.worker_save_state and \
                not gui.pl_pulse and \
                not loading_in_progress and \
                not to_scan and not after_scan and \
                not plex.scanning and \
                not jellyfin.scanning and \
                not cm_clean_db and \
                not lastfm.scanning_friends and \
                not move_in_progress and \
                (gui.lowered or not window_is_focused() or not gui.mouse_in_window):
            save_state()
            cue_list.clear()
            tauon.worker_save_state = False

        # Folder moving
        if len(move_jobs) > 0:
            gui.update += 1
            move_in_progress = True
            job = move_jobs[0]
            del move_jobs[0]

            if job[0].strip("\\/") == job[1].strip("\\/"):
                show_message("Folder copy error.", "The target and source are the same.", mode='info')
                gui.update += 1
                move_in_progress = False
                continue

            try:
                shutil.copytree(job[0], job[1])
            except:
                move_in_progress = False
                gui.update += 1
                show_message("The folder copy has failed!", 'Some files may have been written.', mode='warning')
                continue

            if job[2] == True:
                try:
                    shutil.rmtree(job[0])

                except:
                    show_message("Something has gone horribly wrong!.", "Could not delete " + job[0], mode='error')
                    gui.update += 1
                    move_in_progress = False
                    return

                show_message("Folder move complete.", "Folder name: " + job[3], mode='done')
            else:
                show_message("Folder copy complete.", "Folder name: " + job[3], mode='done')

            move_in_progress = False
            load_orders.append(job[4])
            gui.update += 1

        # Clean database
        if cm_clean_db is True:
            items_removed = 0

            # old_db = copy.deepcopy(pctl.master_library)
            to_got = 0
            to_get = len(pctl.master_library)
            search_over.results.clear()

            keys = set(pctl.master_library.keys())
            for index in keys:
                time.sleep(0.0001)
                track = pctl.master_library[index]
                to_got += 1

                if to_got % 100 == 0:
                    gui.update = 1

                if not prefs.remove_network_tracks and track.file_ext == "SPTY":

                    for playlist in pctl.multi_playlist:
                        if index in playlist[2]:
                            break
                    else:
                        pctl.purge_track(index)
                        items_removed += 1

                    continue

                if (prefs.remove_network_tracks is False and not track.is_network and not os.path.isfile(
                        track.fullpath)) or \
                        (prefs.remove_network_tracks is True and track.is_network):

                    if track.is_network and track.file_ext == "SPTY":
                        continue

                    pctl.purge_track(index)
                    items_removed += 1

            cm_clean_db = False
            show_message("Cleaning complete.", str(items_removed) + " items were removed from the database.",
                         mode='done')
            if album_mode:
                reload_albums(True)
            if gui.combo_mode:
                reload_albums()

            gui.update = 1
            gui.pl_update = 1
            pctl.notify_change()

            search_dia_string_cache.clear()
            search_string_cache.clear()
            search_over.results.clear()

            pctl.notify_change()

        # FOLDER ENC
        if transcode_list:

            try:
                transcode_state = ""
                gui.update += 1

                folder_items = transcode_list[0]

                ref_track_object = pctl.master_library[folder_items[0]]
                ref_album = ref_track_object.album

                # Generate a folder name based on artist and album of first track in batch
                folder_name = encode_folder_name(ref_track_object)

                # If folder contains tracks from multiple albums, use original folder name instead
                for item in folder_items:
                    test_object = pctl.master_library[item]
                    if test_object.album != ref_album:
                        folder_name = ref_track_object.parent_folder_name
                        break

                print("Transcoding folder: " + folder_name)

                # Remove any existing matching folder
                if os.path.isdir(prefs.encoder_output + folder_name):
                    shutil.rmtree(prefs.encoder_output + folder_name)

                # Create new empty folder to output tracks to
                os.makedirs(prefs.encoder_output + folder_name)

                full_wav_out_p = prefs.encoder_output + 'output.wav'
                full_target_out_p = prefs.encoder_output + 'output.' + prefs.transcode_codec
                if os.path.isfile(full_wav_out_p):
                    os.remove(full_wav_out_p)
                if os.path.isfile(full_target_out_p):
                    os.remove(full_target_out_p)

                cache_dir = tmp_cache_dir()
                if not os.path.isdir(cache_dir):
                    os.makedirs(cache_dir)

                if prefs.transcode_codec in ('opus', 'ogg', 'flac', 'mp3'):
                    global core_use
                    cores = os.cpu_count()

                    total = len(folder_items)
                    gui.transcoding_batch_total = total
                    gui.transcoding_bach_done = 0
                    dones = []

                    q = 0
                    while True:
                        if core_use < cores and q < len(folder_items):
                            agg = [[folder_items[q], folder_name]]
                            if agg not in dones:
                                core_use += 1
                                dones.append(agg)
                                loaderThread = threading.Thread(target=transcode_single, args=agg)
                                loaderThread.daemon = True
                                loaderThread.start()

                            q += 1
                            gui.update += 1
                        time.sleep(0.05)
                        if gui.tc_cancel:
                            while core_use > 0:
                                time.sleep(1)
                            break
                        if q == len(folder_items) and core_use == 0:
                            gui.update += 1
                            break

                else:
                    print("Codec error")

                output_dir = prefs.encoder_output + folder_name + "/"
                if prefs.transcode_inplace:
                    remove_target = output_dir.rstrip("/")
                    try:
                        os.remove(remove_target)
                    except:
                        print("Encode folder not removed")
                    reload_metadata(folder_items[0])
                else:
                    album_art_gen.save_thumb(pctl.g(folder_items[0]), (1080, 1080), output_dir + "cover")

                # print(transcode_list[0])

                del transcode_list[0]
                transcode_state = ""
                gui.update += 1

            except:
                transcode_state = "Transcode Error"
                time.sleep(0.2)
                show_message("Transcode failed.", "An error was encountered.", mode='error')
                gui.update += 1
                time.sleep(0.1)
                del transcode_list[0]

            if len(transcode_list) == 0:
                if gui.tc_cancel:
                    gui.tc_cancel = False
                    show_message("The transcode was canceled before completion.", "Incomplete files will remain.",
                                 mode='warning')
                else:
                    line = "Press F9 to show output."
                    if prefs.transcode_codec == 'flac':
                        line = "Note that any associated output picture is a thumbnail and not an exact copy."
                    if not gui.sync_progress:
                        if not gui.message_box:
                            show_message("Encoding complete.", line, mode='done')
                        if system == 'linux' and de_notify_support:
                            g_tc_notify.show()

        if to_scan:
            while to_scan:
                track = to_scan[0]
                star = star_store.full_get(track)
                star_store.remove(track)
                pctl.master_library[track] = tag_scan(pctl.master_library[track])
                star_store.merge(track, star)
                lastfm.sync_pull_love(pctl.master_library[track])
                del to_scan[0]
                gui.update += 1
            album_artist_dict.clear()
            pctl.notify_change()
            gui.pl_update += 1

        if loaderCommandReady is True:
            for order in load_orders:
                if order.stage == 1:
                    if loaderCommand == LC_Folder:
                        to_get = 0
                        to_got = 0
                        loaded_pathes_cache, loaded_cue_cache = cache_paths()
                        # pre_get(order.target)
                        if order.force_scan:
                            gets(order.target, force_scan=True)
                        else:
                            gets(order.target)
                    elif loaderCommand == LC_File:
                        loaded_pathes_cache, loaded_cue_cache = cache_paths()
                        add_file(order.target)

                    if gui.im_cancel:
                        gui.im_cancel = False
                        to_get = 0
                        to_got = 0
                        load_orders.clear()
                        added = []
                        loaderCommand = LC_Done
                        loaderCommandReady = False
                        break

                    loaderCommand = LC_Done
                    # print("LOAD ORDER")
                    order.tracks = added

                    # Double check for cue dupes
                    for i in reversed(range(len(order.tracks))):
                        if pctl.master_library[order.tracks[i]].fullpath in cue_list:
                            if pctl.master_library[order.tracks[i]].is_cue is False:
                                del order.tracks[i]

                    added = []
                    order.stage = 2
                    loaderCommandReady = False
                    # print("DONE LOADING")
                    break


album_info_cache = {}
perfs = []
album_info_cache_key = (-1, -1)


def get_album_info(position, pl=None):

    playlist = default_playlist
    if pl is not None:
        playlist = pctl.multi_playlist[pl][2]

    global album_info_cache_key

    if album_info_cache_key != (pctl.selected_in_playlist, pctl.playing_object()):  # Premature optimisation?
        album_info_cache.clear()
        album_info_cache_key = (pctl.selected_in_playlist, pctl.playing_object())

    if position in album_info_cache:
        return album_info_cache[position]

    if album_dex and album_mode and (pl is None or pl == pctl.active_playlist_viewing):
        dex = album_dex
    else:
        dex = reload_albums(custom_list=playlist)

    end = len(playlist)
    start = 0

    for i, p in enumerate(reversed(dex)):
        if p <= position:
            start = p
            break
        end = p

    album = list(range(start, end))

    playing = 0
    select = False

    if pctl.selected_in_playlist in album:
        select = True

    if len(pctl.track_queue) > 0 and p < len(playlist):
        if pctl.track_queue[pctl.queue_step] in playlist[start:end]:
            playing = 1

    album_info_cache[position] = playing, album, select
    return playing, album, select


tauon.get_album_info = get_album_info


def get_folder_list(index):
    playlist = []

    for item in default_playlist:
        if pctl.master_library[item].parent_folder_name == pctl.master_library[index].parent_folder_name and \
                pctl.master_library[item].album == pctl.master_library[index].album:
            playlist.append(item)
    return list(set(playlist))


def gal_jump_select(up=False, num=1):

    old_selected = pctl.selected_in_playlist
    old_num = num

    if not default_playlist:
        return

    on = pctl.selected_in_playlist
    if on > len(default_playlist) - 1:
        on = 0
        pctl.selected_in_playlist = 0

    if up is False:

        while num > 0:
            while pctl.master_library[
                default_playlist[on]].parent_folder_name == pctl.master_library[
                default_playlist[pctl.selected_in_playlist]].parent_folder_name:
                on += 1

                if on > len(default_playlist) - 1:
                    pctl.selected_in_playlist = old_selected
                    return

            pctl.selected_in_playlist = on
            num -= 1
    else:

        if num > 1:
            if pctl.selected_in_playlist > len(default_playlist) - 1:
                pctl.selected_in_playlist = old_selected
                return

            alb = get_album_info(pctl.selected_in_playlist)
            if alb[1][0] in album_dex[:num]:
                pctl.selected_in_playlist = old_selected
                return

        while num > 0:
            alb = get_album_info(pctl.selected_in_playlist)

            if alb[1][0] > -1:
                on = alb[1][0] - 1

            pctl.selected_in_playlist = max(get_album_info(on)[1][0], 0)
            num -= 1


power_tag_colours = ColourGenCache(0.5, 0.8)


class PowerTag:

    def __init__(self):
        self.name = "BLANK"
        self.path = ""
        self.position = 0
        self.colour = None

        self.peak_x = 0
        self.ani_timer = Timer()
        self.ani_timer.force_set(10)


gui.pt_on = Timer()
gui.pt_off = Timer()
gui.pt = 0


def gen_power2():
    tags = {}  # [tag name]: (first position, number of times we saw it)
    tag_list = []

    last = 'a'
    noise = 0

    def key(tag):
        return tags[tag][1]

    for position in album_dex:

        index = default_playlist[position]
        track = pctl.g(index)

        crumbs = track.parent_folder_path.split("/")

        for i, b in enumerate(crumbs):

            if i > 0 and (track.artist in b and track.artist):
                tag = crumbs[i - 1]

                if tag != last:
                    noise += 1
                last = tag

                if tag in tags:
                    tags[tag][1] += 1
                else:
                    tags[tag] = [position, 1, "/".join(crumbs[:i])]
                    tag_list.append(tag)
                break

    if noise > len(album_dex) / 2:
        # print("Playlist is too noisy for power bar.")
        return []

    tag_list_sort = sorted(tag_list, key=key, reverse=True)

    max_tags = round((window_size[1] - gui.panelY - gui.panelBY - 10) // 30 * gui.scale)

    tag_list_sort = tag_list_sort[:max_tags]

    for i in reversed(range(len(tag_list))):
        if tag_list[i] not in tag_list_sort:
            del tag_list[i]

    h = []

    for tag in tag_list:

        if tags[tag][1] > 2:
            t = PowerTag()
            t.path = tags[tag][2]
            t.name = tag.upper()
            t.position = tags[tag][0]
            h.append(t)

    cc = random.random()
    cj = 0.03
    if len(h) < 5:
        cj = 0.11

    cj = 0.5 / max(len(h), 2)

    for item in h:
        item.colour = hsl_to_rgb(cc, 0.8, 0.7)
        cc += cj

    return h


def reload_albums(quiet=False, return_playlist=-1, custom_list=None):
    global album_dex
    global update_layout
    global old_album_pos

    if cm_clean_db:
        # Doing reload while things are being removed may cause crash
        return

    dex = []
    current_folder = ""
    current_album = ""

    if custom_list is not None:
        playlist = custom_list
    else:
        target_pl_no = pctl.active_playlist_viewing
        if return_playlist > -1:
            target_pl_no = return_playlist

        playlist = pctl.multi_playlist[target_pl_no][2]

    for i in range(len(playlist)):
        tr = pctl.master_library[playlist[i]]

        split = False
        if i == 0:
            split = True
        elif tr.parent_folder_path != current_folder and tr.date and tr.date != current_date:
            split = True
        elif prefs.gallery_combine_disc and "Disc" in tr.album and "Disc" in current_album and tr.album.split("Disc")[0].rstrip(" ") == current_album.split("Disc")[0].rstrip(" "):
            split = False
        elif prefs.gallery_combine_disc and "CD" in tr.album and "CD" in current_album and tr.album.split("CD")[0].rstrip() == current_album.split("CD")[0].rstrip():
            split = False
        elif prefs.gallery_combine_disc and "cd" in tr.album and "cd" in current_album and tr.album.split("cd")[0].rstrip() == current_album.split("cd")[0].rstrip():
            split = False
        elif tr.album and tr.album == current_album and prefs.gallery_combine_disc:
            split = False
        elif tr.parent_folder_path != current_folder or current_title != tr.parent_folder_name:
            split = True

        if split:
            dex.append(i)
            current_folder = tr.parent_folder_path
            current_title = tr.parent_folder_name
            current_album = tr.album
            current_date = tr.date
            current_artist = tr.artist

    if return_playlist > -1 or custom_list:
        return dex

    album_dex = dex
    album_info_cache.clear()
    gui.update += 2
    gui.pl_update = 1
    update_layout = True

    if not quiet:
        goto_album(pctl.playlist_playing_position)

    # Generate POWER BAR
    gui.power_bar = gen_power2()
    gui.pt = 0


tauon.reload_albums = reload_albums

# ------------------------------------------------------------------------------------
# WEBSERVER
if prefs.enable_web is True:
    webThread = threading.Thread(target=webserve,
                                 args=[pctl, prefs, gui, album_art_gen, install_directory, strings, tauon])
    webThread.daemon = True
    webThread.start()

ctlThread = threading.Thread(target=controller, args=[tauon])
ctlThread.daemon = True
ctlThread.start()

if prefs.enable_remote:
    tauon.start_remote()
    tauon.remote_limited = False


# --------------------------------------------------------------

def star_line_toggle(mode=0):
    if mode == 1:
        return gui.star_mode == 'line'

    if gui.star_mode == 'line':
        gui.star_mode = 'none'
    else:
        gui.star_mode = 'line'

    gui.show_ratings = False

    gui.update += 1
    gui.pl_update = 1


def star_toggle(mode=0):
    if gui.show_ratings:
        if mode == 1:
            return prefs.rating_playtime_stars
        prefs.rating_playtime_stars ^= True

    else:
        if mode == 1:
            return gui.star_mode == 'star'

        if gui.star_mode == 'star':
            gui.star_mode = 'none'
        else:
            gui.star_mode = 'star'

    # gui.show_ratings = False
    gui.update += 1
    gui.pl_update = 1


def heart_toggle(mode=0):
    if mode == 1:
        return gui.show_hearts

    gui.show_hearts ^= True
    # gui.show_ratings = False

    gui.update += 1
    gui.pl_update = 1


def album_rating_toggle(mode=0):
    if mode == 1:
        return gui.show_album_ratings

    gui.show_album_ratings ^= True

    gui.update += 1
    gui.pl_update = 1


def rating_toggle(mode=0):
    if mode == 1:
        return gui.show_ratings

    gui.show_ratings ^= True

    if gui.show_ratings:
        # gui.show_hearts = False
        gui.star_mode = 'none'
        prefs.rating_playtime_stars = True
        if not prefs.write_ratings:
            show_message(_("Note that ratings are stored in the local database and not written to tags."))

    gui.update += 1
    gui.pl_update = 1


def toggle_titlebar_line(mode=0):
    global update_title
    if mode == 1:
        return update_title

    line = window_title
    SDL_SetWindowTitle(t_window, line)
    update_title ^= True
    if update_title:
        update_title_do()


def toggle_meta_persists_stop(mode=0):
    if mode == 1:
        return prefs.meta_persists_stop
    prefs.meta_persists_stop ^= True


def toggle_side_panel_layout(mode=0):
    if mode == 1:
        return prefs.side_panel_layout == 1

    if prefs.side_panel_layout == 1:
        prefs.side_panel_layout = 0
    else:
        prefs.side_panel_layout = 1


def toggle_meta_shows_selected(mode=0):
    if mode == 1:
        return prefs.meta_shows_selected_always
    prefs.meta_shows_selected_always ^= True


def scale1(mode=0):
    if mode == 1:
        if prefs.ui_scale == 1:
            return True
        else:
            return False

    prefs.ui_scale = 1
    pref_box.large_preset()

    if prefs.ui_scale != gui.scale:
        show_message(_("Change will be applied on restart."))


def scale125(mode=0):
    if mode == 1:
        if prefs.ui_scale == 1.25:
            return True
        else:
            return False

    prefs.ui_scale = 1.25
    pref_box.large_preset()

    if prefs.ui_scale != gui.scale:
        show_message(_("Change will be applied on restart."))


def toggle_use_tray(mode=0):
    if mode == 1:
        return prefs.use_tray
    prefs.use_tray ^= True
    if not prefs.use_tray:
        prefs.min_to_tray = False
        gnome.hide_indicator()
    else:
        gnome.show_indicator()


def toggle_text_tray(mode=0):
    if mode == 1:
        return prefs.tray_show_title
    prefs.tray_show_title ^= True
    pctl.notify_update()


def toggle_min_tray(mode=0):
    if mode == 1:
        return prefs.min_to_tray
    prefs.min_to_tray ^= True


def scale2(mode=0):
    if mode == 1:
        if prefs.ui_scale == 2:
            return True
        else:
            return False

    prefs.ui_scale = 2
    pref_box.large_preset()

    if prefs.ui_scale != gui.scale:
        show_message(_("Change will be applied on restart."))


def toggle_borderless(mode=0):
    global draw_border
    global update_layout

    if mode == 1:
        return draw_border

    update_layout = True
    draw_border ^= True

    if draw_border:
        SDL_SetWindowBordered(t_window, False)
    else:
        SDL_SetWindowBordered(t_window, True)


def toggle_break(mode=0):
    global break_enable
    if mode == 1:
        return break_enable ^ True
    else:
        break_enable ^= True
        gui.pl_update = 1


def toggle_scroll(mode=0):
    global scroll_enable
    global update_layout

    if mode == 1:
        if scroll_enable:
            return False
        else:
            return True

    else:
        scroll_enable ^= True
        gui.pl_update = 1
        update_layout = True


def toggle_hide_bar(mode=0):
    if mode == 1:
        return gui.set_bar ^ True
    gui.update_layout()
    gui.set_bar ^= True
    show_message(_("Tip: You can also toggle this from a right-click context menu"))


def toggle_append_total_time(mode=0):
    if mode == 1:
        return prefs.append_total_time
    prefs.append_total_time ^= True
    gui.pl_update = 1
    gui.update += 1


def toggle_append_date(mode=0):
    if mode == 1:
        return prefs.append_date
    prefs.append_date ^= True
    gui.pl_update = 1
    gui.update += 1


def toggle_true_shuffle(mode=0):
    if mode == 1:
        return prefs.true_shuffle
    prefs.true_shuffle ^= True


def toggle_auto_artist_dl(mode=0):
    if mode == 1:
        return prefs.auto_dl_artist_data
    prefs.auto_dl_artist_data ^= True
    for artist, value in list(artist_list_box.thumb_cache.items()):
        if value is None:
            del artist_list_box.thumb_cache[artist]


def toggle_enable_web(mode=0):
    if mode == 1:
        return prefs.enable_web

    prefs.enable_web ^= True

    if prefs.enable_web and not gui.web_running:
        webThread = threading.Thread(target=webserve,
                                     args=[pctl, prefs, gui, album_art_gen, install_directory, strings, tauon])
        webThread.daemon = True
        webThread.start()
        show_message(_("Web server starting"), _("External connections will be accepted."), mode='done')

    elif prefs.enable_web is False:
        if tauon.radio_server is not None:
            tauon.radio_server.shutdown()
            gui.web_running = False

        time.sleep(0.25)


def toggle_scrobble_mark(mode=0):
    if mode == 1:
        return prefs.scrobble_mark
    prefs.scrobble_mark ^= True


def toggle_lfm_auto(mode=0):
    if mode == 1:
        return prefs.auto_lfm
    prefs.auto_lfm ^= True
    if prefs.auto_lfm and not last_fm_enable:
        show_message("Optional module python-pylast not installed", mode='warning')
        prefs.auto_lfm = False
    # if prefs.auto_lfm:
    #     lastfm.hold = False
    # else:
    #     lastfm.hold = True


def toggle_lb(mode=0):
    if mode == 1:
        return lb.enable
    if not lb.enable and not prefs.lb_token:
        show_message("Can't enable this if there's no token.", mode='warning')
        return
    lb.enable ^= True


def toggle_maloja(mode=0):
    if mode == 1:
        return prefs.maloja_enable
    if not prefs.maloja_url or not prefs.maloja_key:
        show_message(_("One or more fields is missing."), mode='warning')
        return
    prefs.maloja_enable ^= True


def toggle_ex_del(mode=0):
    if mode == 1:
        return prefs.auto_del_zip
    prefs.auto_del_zip ^= True
    # if prefs.auto_del_zip is True:
    #     show_message("Caution! This function deletes things!", mode='info', "This could result in data loss if the process were to malfunction.")


def toggle_dl_mon(mode=0):
    if mode == 1:
        return prefs.monitor_downloads

    prefs.monitor_downloads ^= True


def toggle_music_ex(mode=0):
    if mode == 1:
        return prefs.extract_to_music

    prefs.extract_to_music ^= True


def toggle_extract(mode=0):
    if mode == 1:
        return prefs.auto_extract
    prefs.auto_extract ^= True
    if prefs.auto_extract is False:
        prefs.auto_del_zip = False


def toggle_top_tabs(mode=0):
    if mode == 1:
        return prefs.tabs_on_top
    prefs.tabs_on_top ^= True


def toggle_guitar_chords(mode=0):
    if mode == 1:
        return prefs.guitar_chords
    prefs.guitar_chords ^= True


# def toggle_auto_lyrics(mode=0):
#     if mode == 1:
#         return prefs.auto_lyrics
#     prefs.auto_lyrics ^= True


def switch_single(mode=0):
    if mode == 1:
        if prefs.transcode_mode == 'single':
            return True
        else:
            return False
    prefs.transcode_mode = 'single'


def switch_mp3(mode=0):
    if mode == 1:
        if prefs.transcode_codec == 'mp3':
            return True
        else:
            return False
    prefs.transcode_codec = 'mp3'


def switch_ogg(mode=0):
    if mode == 1:
        if prefs.transcode_codec == 'ogg':
            return True
        else:
            return False
    prefs.transcode_codec = 'ogg'


def switch_opus(mode=0):
    if mode == 1:
        if prefs.transcode_codec == 'opus':
            return True
        else:
            return False
    prefs.transcode_codec = 'opus'


def switch_opus_ogg(mode=0):
    if mode == 1:
        if prefs.transcode_opus_as:
            return True
        else:
            return False
    prefs.transcode_opus_as ^= True


def toggle_transcode_output(mode=0):
    if mode == 1:
        if prefs.transcode_inplace:
            return False
        else:
            return True
    prefs.transcode_inplace ^= True
    if prefs.transcode_inplace:
        transcode_icon.colour = [250, 20, 20, 255]
        show_message(
            _("DANGER! This will delete the original files. Keeping a backup is recommended in case of malfunction."),
            _("For safety, this setting will default to off. Embedded thumbnails are not kept so you may want to extract them first."),
            mode='warning')
    else:
        transcode_icon.colour = [239, 74, 157, 255]


def toggle_transcode_inplace(mode=0):
    if mode == 1:
        if prefs.transcode_inplace:
            return True
        else:
            return False

    if gui.sync_progress:
        prefs.transcode_inplace = False
        return

    prefs.transcode_inplace ^= True
    if prefs.transcode_inplace:
        transcode_icon.colour = [250, 20, 20, 255]
        show_message(
            _("DANGER! This will delete the original files. You may want to have backups in case of malfunction."),
            _("For safety, this setting will reset on restart. Embedded thumbnails are not kept so you may want to extract them first."),
            mode='warning')
    else:
        transcode_icon.colour = [239, 74, 157, 255]


def switch_flac(mode=0):
    if mode == 1:
        if prefs.transcode_codec == 'flac':
            return True
        else:
            return False
    prefs.transcode_codec = 'flac'


def toggle_sbt(mode=0):
    if mode == 1:
        return prefs.prefer_bottom_title
    prefs.prefer_bottom_title ^= True


def toggle_bba(mode=0):
    if mode == 1:
        return gui.bb_show_art
    gui.bb_show_art ^= True
    gui.update_layout()


def toggle_use_title(mode=0):
    if mode == 1:
        return prefs.use_title
    prefs.use_title ^= True


def switch_rg_off(mode=0):
    if mode == 1:
        return True if prefs.replay_gain == 0 else False
    prefs.replay_gain = 0


def switch_rg_track(mode=0):
    if mode == 1:
        return True if prefs.replay_gain == 1 else False
    prefs.replay_gain = 0 if prefs.replay_gain == 1 else 1
    # prefs.replay_gain = 1


def switch_rg_album(mode=0):
    if mode == 1:
        return True if prefs.replay_gain == 2 else False
    prefs.replay_gain = 0 if prefs.replay_gain == 2 else 2


def switch_rg_auto(mode=0):
    if mode == 1:
        return True if prefs.replay_gain == 3 else False
    prefs.replay_gain = 0 if prefs.replay_gain == 3 else 3


def toggle_jump_crossfade(mode=0):
    if mode == 1:
        return True if prefs.use_jump_crossfade else False
    prefs.use_jump_crossfade ^= True


def toggle_pause_fade(mode=0):
    if mode == 1:
        return True if prefs.use_pause_fade else False
    prefs.use_pause_fade ^= True


def toggle_transition_crossfade(mode=0):
    if mode == 1:
        return True if prefs.use_transition_crossfade else False
    prefs.use_transition_crossfade ^= True


def toggle_transition_gapless(mode=0):
    if mode == 1:
        return False if prefs.use_transition_crossfade else True
    prefs.use_transition_crossfade ^= True


def toggle_eq(mode=0):
    if mode == 1:
        return prefs.use_eq
    prefs.use_eq ^= True
    pctl.playerCommand = 'seteq'
    pctl.playerCommandReady = True


key_shiftr_down = False
key_ctrl_down = False
key_rctrl_down = False
key_meta = False
key_ralt = False
key_lalt = False


def reload_backend():
    gui.backend_reloading = True
    print("Reload backend...")
    wait = 0
    pre_state = pctl.stop(True)

    while pctl.playerCommandReady:
        time.sleep(0.01)
        wait += 1
        if wait > 20:
            break
    try:
        tm.player_lock.release()
    except:
        pass

    pctl.playerCommand = "unload"
    pctl.playerCommandReady = True

    wait = 0
    while pctl.playerCommand != 'done':
        time.sleep(0.01)
        wait += 1
        if wait > 200:
            break

    tm.ready_playback()

    if pre_state == 1:
        pctl.revert()
    gui.backend_reloading = False



def gen_chart():
    try:

        topchart = t_topchart.TopChart(tauon, album_art_gen)

        tracks = []

        source_tracks = pctl.multi_playlist[pctl.active_playlist_viewing][2]

        if prefs.topchart_sorts_played:
            source_tracks = gen_folder_top(0, custom_list=source_tracks)
            dex = reload_albums(quiet=True, custom_list=source_tracks)
        else:
            dex = reload_albums(quiet=True, return_playlist=pctl.active_playlist_viewing)

        for item in dex:
            tracks.append(pctl.g(source_tracks[item]))

        cascade = False
        if prefs.chart_cascade:
            cascade = ((prefs.chart_c1, prefs.chart_c2, prefs.chart_c3),
                       (prefs.chart_d1, prefs.chart_d2, prefs.chart_d3))

        path = topchart.generate(tracks, prefs.chart_bg, prefs.chart_rows, prefs.chart_columns, prefs.chart_text,
                                 prefs.chart_font, prefs.chart_tile, cascade)

    except:
        gui.generating_chart = False
        show_message(_("There was an error generating the chart"), "Sorry!", mode='error')
        return

    gui.generating_chart = False

    if path:
        open_file(path)
    else:
        show_message(_("There was an error generating the chart"), "Sorry!", mode='error')
        return

    show_message(_("Chart generated"), mode='done')


class Over:
    def __init__(self):

        global window_size

        self.init2done = False

        self.about_image = asset_loader('v4-a.png')
        self.about_image2 = asset_loader('v4-b.png')
        self.about_image3 = asset_loader('v4-c.png')
        self.about_image4 = asset_loader('v4-d.png')
        self.about_image5 = asset_loader('v4-e.png')
        self.about_image6 = asset_loader('v4-f.png')
        self.title_image = asset_loader("title.png", True)

        # self.tab_width = round(115 * gui.scale)
        self.w = 100
        self.h = 100

        self.box_x = 100
        self.box_y = 100
        self.item_x_offset = round(25 * gui.scale)

        self.current_path = os.path.expanduser('~')
        self.view_offset = 0
        self.ext_ratio = {}
        self.last_db_size = -1

        self.enabled = False
        self.click = False
        self.right_click = False
        self.scroll = 0
        self.lock = False

        self.drives = []

        self.temp_lastfm_user = ""
        self.temp_lastfm_pass = ""
        self.lastfm_input_box = 0

        self.func_page = 0
        self.tab_active = 0
        self.tabs = [
            [_("Function"), self.funcs],
            [_("Audio"), self.audio],
            [_("Tracklist"), self.config_v],
            [_("Theme"), self.theme],
            [_("Window"), self.config_b],
            [_("View"), self.view2],
            [_("Transcode"), self.codec_config],
            [_("Lyrics"), self.lyrics],
            [_("Accounts"), self.last_fm_box],
            [_("Stats"), self.stats],
            [_("About"), self.about]
        ]

        self.stats_timer = Timer()
        self.stats_timer.force_set(1000)
        self.stats_pl_timer = Timer()
        self.stats_pl_timer.force_set(1000)
        self.total_albums = 0
        self.stats_pl = 0
        self.stats_pl_albums = 0
        self.stats_pl_length = 0

        self.ani_cred = 0
        self.cred_page = 0
        self.ani_fade_on_timer = Timer(force=10)
        self.ani_fade_off_timer = Timer(force=10)

        self.device_scroll_bar_position = 0

        self.lyrics_panel = False
        self.account_view = 0
        self.view_view = 0
        self.chart_view = 0
        self.eq_view = False
        self.rg_view = False
        self.sync_view = False

        self.account_text_field = -1

        self.themes = []
        self.view_supporters = False
        self.key_box = TextBox2()
        self.key_box_focused = False

    def theme(self, x0, y0, w0, h0):

        global album_mode_art_size
        global update_layout

        y = y0 + 13 * gui.scale
        x = x0 + 25 * gui.scale

        ddt.text_background_colour = colours.box_background
        ddt.text((x, y), _("Theme"), colours.box_text_label, 12)

        y += 25 * gui.scale

        self.toggle_square(x, y, toggle_auto_bg, _("Use album art as background"))

        y += 23 * gui.scale

        old = prefs.enable_fanart_bg
        prefs.enable_fanart_bg = self.toggle_square(x + 10 * gui.scale, y, prefs.enable_fanart_bg,
                                                    _("Prefer artist backgrounds"))
        if prefs.enable_fanart_bg and prefs.enable_fanart_bg != old:
            if not prefs.auto_dl_artist_data:
                prefs.auto_dl_artist_data = True
                show_message("Also enabling \"auto-fech artist data\" to scrape last.fm.", "You can toggle this back off under Settings > Function")
        y += 23 * gui.scale

        self.toggle_square(x + 10 * gui.scale, y, toggle_auto_bg_strong, _("Stronger"))
        # self.toggle_square(x + 10 * gui.scale, y, toggle_auto_bg_strong1, _("Lo"))
        # self.toggle_square(x + 54 * gui.scale, y, toggle_auto_bg_strong2, _("Md"))
        # self.toggle_square(x + 105 * gui.scale, y, toggle_auto_bg_strong3, _("Hi"))

        #y += 23 * gui.scale
        self.toggle_square(x + 120 * gui.scale, y, toggle_auto_bg_blur, _("Blur"))

        y += 23 * gui.scale
        self.toggle_square(x + 10 * gui.scale, y, toggle_auto_bg_showcase, _("Showcase only"))

        y += 23 * gui.scale
        # prefs.center_bg = self.toggle_square(x + 10 * gui.scale, y, prefs.center_bg, _("Always center"))
        prefs.showcase_overlay_texture = self.toggle_square(x + 20 * gui.scale, y, prefs.showcase_overlay_texture,
                                                            _("Pattern style"))

        y += 25 * gui.scale

        self.toggle_square(x, y, toggle_auto_theme, _("Auto-theme from album art"))

        y += 55 * gui.scale

        square = round(8 * gui.scale)
        border = round(4 * gui.scale)
        outer_border = round(2 * gui.scale)

        # theme_files = get_themes()
        xx = x
        yy = y
        hover_name = None
        for c, theme_name, theme_number in self.themes:

            if theme_name == gui.theme_name:
                rect = [xx - outer_border, yy - outer_border, border * 2 + square * 2 + outer_border * 2,
                        border * 2 + square * 2 + outer_border * 2]
                ddt.rect(rect, colours.box_text_label)

            rect = [xx, yy, border * 2 + square * 2, border * 2 + square * 2]
            ddt.rect(rect, [5, 5, 5, 255])

            rect = grow_rect(rect, 3)
            fields.add(rect)
            if coll(rect):
                hover_name = theme_name
                if self.click:
                    global theme
                    theme = theme_number
                    gui.reload_theme = True

            c1 = c.playlist_panel_background
            c2 = c.artist_playing
            c3 = c.title_playing
            c4 = c.bottom_panel_colour

            if theme_name == "Carbon":
                c1 = c.title_playing
                c2 = c.playlist_panel_background
                c3 = c.top_panel_background

            if theme_name == "Lavender Light":
                c1 = c.tab_background_active

            if theme_name == "Neon Love":
                c2 = c.artist_text
                c4 = [118, 85, 194, 255]
                c1 = c4

            if theme_name == "Sky":
                c2 = c.artist_text

            if theme_name == "Sunken":
                c2 = c.title_text
                c3 = c.artist_text
                c4 = [59, 115, 109, 255]
                c1 = c4

            if c2 == c3 and colour_value(c1) < 200:
                rect = [(xx + border + square) - (square // 2), (yy + border + square) - (square // 2), square, square]
                ddt.rect(rect, c2)
            else:

                # tl
                rect = [xx + border, yy + border, square, square]
                ddt.rect(rect, c1)

                # tr
                rect = [xx + border + square, yy + border, square, square]
                ddt.rect(rect, c2)

                # bl
                rect = [xx + border, yy + border + square, square, square]
                ddt.rect(rect, c3)

                # br
                rect = [xx + border + square, yy + border + square, square, square]
                ddt.rect(rect, c4)

            yy += round(27 * gui.scale)
            if yy > y + 40 * gui.scale:
                yy = y
                xx += round(27 * gui.scale)

        name = gui.theme_name
        if hover_name:
            name = hover_name
        ddt.text((x, y - 23 * gui.scale), name, colours.box_text_label, 214)
        #
        if gui.theme_name == "Neon Love" and not hover_name:
            x += 95 * gui.scale
            y -= 23 * gui.scale
            # x += 165 * gui.scale
            # y += -19 * gui.scale

            link_pa = draw_linked_text((x, y), _("Based on") + " " + "https://love.holllo.cc/", colours.box_text_label,
                                       312, replace="love.holllo.cc")
            link_activate(x, y, link_pa, click=self.click)

    def rg(self, x0, y0, w0, h0):
        y = y0 + 55 * gui.scale
        x = x0 + 130 * gui.scale

        if self.button(x - 110 * gui.scale, y + 180 * gui.scale, _("Return"), width=75 * gui.scale):
            self.rg_view = False

        y = y0 + round(15 * gui.scale)
        x = x0 + round(50 * gui.scale)

        ddt.text((x, y), _("ReplayGain"), colours.box_text_label, 14)
        y += round(25 * gui.scale)

        self.toggle_square(x, y, switch_rg_off, _("Off"))
        self.toggle_square(x + round(80 * gui.scale), y, switch_rg_auto, _("Auto"))
        y += round(22 * gui.scale)
        self.toggle_square(x, y, switch_rg_album, _("Preserve album dynamics"))
        y += round(22 * gui.scale)
        self.toggle_square(x, y, switch_rg_track, _("Tracks equal loudness"))

        y += round(25 * gui.scale)
        ddt.text((x, y), _("Will only have effect if ReplayGain metadata is present."), colours.box_text_label, 12)
        y += round(26 * gui.scale)

        ddt.text((x, y), _("Pre-amp"), colours.box_text_label, 14)
        y += round(26 * gui.scale)

        sw = round(170 * gui.scale)
        sh = round(2 * gui.scale)

        slider = (x, y, sw, sh)

        gh = round(14 * gui.scale)
        gw = round(8 * gui.scale)
        grip = [0, y - (gh // 2), gw, gh]

        grip[0] = x

        bp = prefs.replay_preamp + 15

        grip[0] += (bp / 30 * sw)

        m1 = (x, y, sh, sh * 2)
        m2 = ((x + sw // 2), y, sh, sh * 2)
        m3 = ((x + sw), y, sh, sh * 2)

        if coll(grow_rect(slider, 15)) and mouse_down:
            bp = (mouse_position[0] - x) / sw * 30
            gui.update += 1

        bp = round(bp)
        bp = max(bp, 0)
        bp = min(bp, 30)
        prefs.replay_preamp = bp - 15

        # grip[0] += (bp / 30 * sw)

        ddt.rect(slider, colours.box_text_border)
        ddt.rect(m1, colours.box_text_border)
        ddt.rect(m2, colours.box_text_border)
        ddt.rect(m3, colours.box_text_border)
        ddt.rect(grip, colours.box_text_label)

        text = f"{prefs.replay_preamp} dB"
        if prefs.replay_preamp > 0:
            text = "+" + text

        colour = colours.box_sub_text
        if prefs.replay_preamp == 0:
            colour = colours.box_text_label
        ddt.text((x + sw + round(14 * gui.scale), y - round(8 * gui.scale)), text, colour, 11)
        # print(prefs.replay_preamp)

        y += round(18 * gui.scale)
        ddt.text((x, y, 4, 310 * gui.scale, 300 * gui.scale),
                 _("Lower pre-amp values improve normalisation but will require a higher system volume."),
                 colours.box_text_label, 12)

    def eq(self, x0, y0, w0, h0):

        y = y0 + 55 * gui.scale
        x = x0 + 130 * gui.scale

        if self.button(x - 110 * gui.scale, y + 180 * gui.scale, _("Return"), width=75 * gui.scale):
            self.eq_view = False

        base_dis = 160 * gui.scale
        center = base_dis // 2
        width = 25 * gui.scale

        range = 12

        self.toggle_square(x - 90 * gui.scale, y - 35 * gui.scale, toggle_eq, _("Enable"))

        ddt.text((x - 17 * gui.scale, y + 2 * gui.scale), "+", colours.grey(130), 16)
        ddt.text((x - 17 * gui.scale, y + base_dis - 15 * gui.scale), "-", colours.grey(130), 16)

        for i, q in enumerate(prefs.eq):

            bar = [x, y, width, base_dis]

            ddt.rect(bar, [255, 255, 255, 20])

            bar[0] -= 2 * gui.scale
            bar[1] -= 10 * gui.scale
            bar[2] += 4 * gui.scale
            bar[3] += 20 * gui.scale

            if coll(bar):

                if mouse_down:
                    target = mouse_position[1] - y - center
                    target = (target / center) * range
                    if target > range:
                        target = range
                    if target < range * -1:
                        target = range * -1
                    if -0.1 < target < 0.1:
                        target = 0

                    prefs.eq[i] = target

                    pctl.playerCommand = 'seteq'
                    pctl.playerCommandReady = True

                if self.right_click:
                    prefs.eq[i] = 0
                    pctl.playerCommand = 'seteq'
                    pctl.playerCommandReady = True

            start = (q / range) * center

            bar = [x, y + center, width, start]

            ddt.rect(bar, [100, 200, 100, 255])

            x += round(29 * gui.scale)

    def audio(self, x0, y0, w0, h0):

        global mouse_down

        ddt.text_background_colour = colours.box_background
        y = y0 + 40 * gui.scale
        x = x0 + 20 * gui.scale

        if self.eq_view:
            self.eq(x0, y0, w0, h0)
            return

        if self.rg_view:
            self.rg(x0, y0, w0, h0)
            return

        colour = colours.box_sub_text

        # if system == "linux":
        if not phazor_exists(tauon.pctl):
            x += round(20 * gui.scale)
            ddt.text((x, y - 25 * gui.scale), "PHAzOR DLL not found!", colour, 213)

        elif prefs.backend == 4:

            y = y0 + round(20 * gui.scale)
            x = x0 + 20 * gui.scale

            x += round(2 * gui.scale)

            self.toggle_square(x, y, toggle_pause_fade, _("Use fade on pause/stop"))
            y += round(23 * gui.scale)
            self.toggle_square(x, y, toggle_jump_crossfade, _("Use fade on track jump"))
            y += round(23 * gui.scale)
            prefs.back_restarts = self.toggle_square(x, y, prefs.back_restarts, _("Back restarts to beginning"))

            y += round(40 * gui.scale)
            if self.button(x, y, _("ReplayGain")):
                mouse_down = False
                self.rg_view = True

            y += round(45 * gui.scale)
            prefs.precache = self.toggle_square(x, y, prefs.precache, _("Cache local files (for smb/nfs)"))
            y += round(23 * gui.scale)
            old = prefs.tmp_cache
            prefs.tmp_cache = self.toggle_square(x, y, prefs.tmp_cache ^ True, _("Use persistent network cache")) ^ True
            if old != prefs.tmp_cache and tauon.cachement:
                tauon.cachement.__init__()

            y += round(22 * gui.scale)
            ddt.text((x + round(22 * gui.scale), y), _("Cache size"), colours.box_text, 312)
            y += round(18 * gui.scale)
            prefs.cache_limit = int(
                self.slide_control(x + round(22 * gui.scale), y, None, ' GB', prefs.cache_limit / 1000, 0.5,
                                   1000, 0.5) * 1000)

            y += round(30 * gui.scale)
            # prefs.device_buffer = self.slide_control(x + round(270 * gui.scale), y, _("Output buffer"), 'ms',
            #                                          prefs.device_buffer, 10,
            #                                          500, 10, self.reload_device)

            # if prefs.device_buffer > 100:
            #     prefs.pa_fast_seek = True
            # else:
            #     prefs.pa_fast_seek = False

            y = y0 + 37 * gui.scale
            x = x0 + 270 * gui.scale
            ddt.text_background_colour = colours.box_background
            ddt.text((x, y - 22 * gui.scale), _("Set audio output device"), colours.box_text_label, 212)

            old = prefs.avoid_resampling
            prefs.avoid_resampling = self.toggle_square(x, self.box_y + self.h - 27 * gui.scale, prefs.avoid_resampling, _("Avoid resampling"))
            if prefs.avoid_resampling != old:
                pctl.playerCommand = 'reload'
                pctl.playerCommandReady = True

            self.device_scroll_bar_position -= pref_box.scroll
            if self.device_scroll_bar_position < 0:
                self.device_scroll_bar_position = 0
            if self.device_scroll_bar_position > len(prefs.phazor_devices) - 11 > 11:
                self.device_scroll_bar_position = len(prefs.phazor_devices) - 11

            if len(prefs.phazor_devices) > 13:
                self.device_scroll_bar_position = device_scroll.draw(x + 250 * gui.scale, y, 11, 180,
                                                                     self.device_scroll_bar_position,
                                                                     len(prefs.phazor_devices) - 11, click=self.click)

            i = 0
            reload = False
            for name in prefs.phazor_devices:

                if i < self.device_scroll_bar_position:
                    continue
                if y > self.box_y + self.h - 40 * gui.scale:
                    break

                rect = (x, y + 4 * gui.scale, 245 * gui.scale, 13)

                if self.click and coll(rect):
                    prefs.phazor_device_selected = name
                    reload = True

                line = trunc_line(name, 10, 245 * gui.scale)

                fields.add(rect)

                if prefs.phazor_device_selected == name:
                    ddt.text((x, y), line, colours.box_sub_text, 10)
                    ddt.text((x - 12 * gui.scale, y + 1 * gui.scale), ">", colours.box_sub_text, 213)
                else:
                    if coll(rect):
                        ddt.text((x, y), line, colours.box_sub_text, 10)
                    else:
                        ddt.text((x, y), line, colours.box_text_label, 10)
                y += 14 * gui.scale
                i += 1

            if reload:
                pctl.playerCommand = "set-device"
                pctl.playerCommandReady = True

    def reload_device(self, _):

        pctl.playerCommand = 'reload'
        pctl.playerCommandReady = True

    def toggle_lyrics_view(self):
        self.lyrics_panel ^= True

    def lyrics(self, x0, y0, w0, h0):

        x = x0 + 25 * gui.scale
        y = y0 - 10 * gui.scale
        y += 30 * gui.scale

        ddt.text_background_colour = colours.box_background

        # self.toggle_square(x, y, toggle_auto_lyrics, _("Auto search lyrics"))
        if prefs.auto_lyrics:
            if prefs.auto_lyrics_checked:
                if self.button(x, y, "Reset failed list"):
                    prefs.auto_lyrics_checked.clear()
            y += 30 * gui.scale
        self.toggle_square(x, y, toggle_guitar_chords, _("Enable chord lyrics"))

        y += 40 * gui.scale
        ddt.text((x, y), _("Sources:"), colours.box_text_label, 11)
        y += 23 * gui.scale

        for name in lyric_sources.keys():
            enabled = name in prefs.lyrics_enables
            title = _(name)
            if name in uses_scraping:
                title += "*"
            new = self.toggle_square(x, y, enabled, title)
            y += round(23 * gui.scale)
            if new != enabled:
                if enabled:
                    prefs.lyrics_enables.clear()
                else:
                    prefs.lyrics_enables.append(name)

        y += round(6 * gui.scale)
        ddt.text((x + 12 * gui.scale, y), _("*Uses scraping. Enable at your own discretion."),
                 colours.box_text_label, 11)
        y += 20 * gui.scale
        ddt.text((x + 12 * gui.scale, y), _("Tip: The order enabled will be the order searched."),
                 colours.box_text_label, 11)
        y += 20 * gui.scale

    def view2(self, x0, y0, w0, h0):

        x = x0 + 25 * gui.scale
        y = y0 + 20 * gui.scale

        ddt.text_background_colour = colours.box_background

        ddt.text((x, y), _("Metadata side panel"), colours.box_text_label, 12)

        y += 25 * gui.scale
        self.toggle_square(x, y, toggle_side_panel_layout, _("Use centered style"))
        y += 25 * gui.scale
        old = prefs.zoom_art
        prefs.zoom_art = self.toggle_square(x, y, prefs.zoom_art, _("Zoom album art to fit"))
        if prefs.zoom_art != old:
            album_art_gen.clear_cache()

        global album_mode_art_size
        global update_layout
        y += 35 * gui.scale
        ddt.text((x, y), _("Gallery"), colours.box_text_label, 12)

        y += 25 * gui.scale
        # self.toggle_square(x, y, toggle_dim_albums, "Dim gallery when playing")
        self.toggle_square(x, y, toggle_gallery_click, _("Single click to play"))
        y += 25 * gui.scale
        self.toggle_square(x, y, toggle_gallery_combine, _("Combine multi-discs"))
        y += 25 * gui.scale
        self.toggle_square(x, y, toggle_galler_text, _("Show titles"))
        y += 25 * gui.scale
        # self.toggle_square(x, y, toggle_gallery_row_space, _("Increase row spacing"))
        # y += 25 * gui.scale
        prefs.center_gallery_text = self.toggle_square(x + round(10 * gui.scale), y, prefs.center_gallery_text,
                                                       _("Center alignment"))

        y += 30 * gui.scale

        # y += 25 * gui.scale

        x -= 80 * gui.scale
        x += ddt.get_text_w(_("Thumbnail size"), 312)
        # x += 20 * gui.scale

        if album_mode_art_size < 160:
            self.toggle_square(x + 235 * gui.scale, y + 2 * gui.scale, toggle_gallery_thin, _("Prefer thinner padding"))

        # ddt.text((x, y), _("Gallery art size"), colours.grey(220), 11)

        album_mode_art_size = self.slide_control(x + 25 * gui.scale, y, _("Thumbnail size"), "px", album_mode_art_size,
                                                 70, 400, 10, img_slide_update_gall)

    def funcs(self, x0, y0, w0, h0):

        x = x0 + 25 * gui.scale
        y = y0 - 10 * gui.scale

        ddt.text_background_colour = colours.box_background

        if self.func_page == 0:

            y += 23 * gui.scale

            self.toggle_square(x, y, toggle_enable_web,
                               _("Enable Listen Along"), subtitle=_("Start server for remote web playback"))

            if toggle_enable_web(1):

                link_pa2 = draw_linked_text((x + 300 * gui.scale, y - 1 * gui.scale),
                                            f"http://localhost:{str(prefs.metadata_page_port)}/listenalong",
                                            colours.grey_blend_bg(190), 13)
                link_rect2 = [x + 300 * gui.scale, y - 1 * gui.scale, link_pa2[1], 20 * gui.scale]
                fields.add(link_rect2)

                if coll(link_rect2):
                    if not self.click:
                        gui.cursor_want = 3

                    if self.click:
                        webbrowser.open(link_pa2[2], new=2, autoraise=True)

            y += 38 * gui.scale

            old = gui.artist_info_panel
            new = self.toggle_square(x, y, gui.artist_info_panel,
                                                       _("Show artist info panel"),
                                                       subtitle=_("You can also toggle this with ctrl+o"))
            if new != old:
                view_box.artist_info(True)

            y += 38 * gui.scale

            self.toggle_square(x, y, toggle_auto_artist_dl,
                               _("Auto fetch artist data"),
                               subtitle=_("Downloads data in background when artist panel is open"))

            y += 38 * gui.scale
            prefs.always_auto_update_playlists = self.toggle_square(x, y, prefs.always_auto_update_playlists,
                                                                    _("Auto regenerate playlists"),
                                                                    subtitle=_(
                                                                        "Generated playlists reload when re-entering"))

            y += 38 * gui.scale
            self.toggle_square(x, y, toggle_top_tabs, _("Tabs in top panel"),
                               subtitle=_("Uncheck to disable the tab pin function"))

            y += 45 * gui.scale
            # y += 30 * gui.scale

            wa = ddt.get_text_w(_("Open config file"), 211) + 10 * gui.scale
            # wb = ddt.get_text_w(_("Open keymap file"), 211) + 10 * gui.scale
            wc = ddt.get_text_w(_("Open data folder"), 211) + 10 * gui.scale

            ww = max(wa, wc)

            self.button(x, y, _("Open config file"), open_config_file, width=ww)
            bg = None
            if gui.opened_config_file:
                bg = [90, 50, 130, 255]
                self.button(x + ww + wc + 25 * gui.scale, y, _("Reload"), reload_config_file, bg=bg)

            self.button(x + wa + round(20 * gui.scale), y, _("Open data folder"), open_data_directory, ww)

        elif self.func_page == 1:
            y += 23 * gui.scale
            ddt.text((x, y), _("Enable/Disable track context menu functions:"), colours.box_text_label, 11)
            y += 25 * gui.scale

            self.toggle_square(x, y, toggle_wiki, _("Wikipedia artist search"))
            y += 23 * gui.scale
            self.toggle_square(x, y, toggle_rym, _("Sonemic artist search"))
            y += 23 * gui.scale
            self.toggle_square(x, y, toggle_band, _("Bandcamp artist page search"))
            # y += 23 * gui.scale
            # self.toggle_square(x, y, toggle_gimage, _("Google image search"))
            y += 23 * gui.scale
            self.toggle_square(x, y, toggle_gen, _("Genius track search"))
            y += 23 * gui.scale
            self.toggle_square(x, y, toggle_transcode, _("Transcode folder"))

            y += 28 * gui.scale

            x = x0 + self.item_x_offset

            ddt.text((x, y), _("End of playlist action"), colours.box_text_label, 12)

            y += 25 * gui.scale
            wa = ddt.get_text_w(_("Stop playback"), 13) + 10 * gui.scale
            wb = ddt.get_text_w(_("Repeat playlist"), 13) + 10 * gui.scale
            wc = max(wa, wb) + 20 * gui.scale

            self.toggle_square(x, y, self.set_playlist_stop, _("Stop playback"))
            y += 25 * gui.scale
            self.toggle_square(x, y, self.set_playlist_repeat, _("Repeat playlist"))
            # y += 25
            y -= 25 * gui.scale
            x += wc
            self.toggle_square(x, y, self.set_playlist_advance, _("Play next playlist"))
            y += 25 * gui.scale
            self.toggle_square(x, y, self.set_playlist_cycle, _("Cycle all playlists"))

        elif self.func_page == 2:
            y += 23 * gui.scale
            # ddt.text((x, y), _("Auto download monitor and archive extractor"), colours.box_text_label, 11)
            # y += 25 * gui.scale
            self.toggle_square(x, y, toggle_extract, _("Extract archives"),
                               subtitle=_("Extracts zip archives on drag and drop"))
            y += 38 * gui.scale
            self.toggle_square(x + 10 * gui.scale, y, toggle_dl_mon, _("Enable download monitor"),
                               subtitle=_("One click import new archives and folders from downloads folder"))
            y += 38 * gui.scale
            self.toggle_square(x + 10 * gui.scale, y, toggle_ex_del, _("Trash archive after extraction"))
            y += 23 * gui.scale
            self.toggle_square(x + 10 * gui.scale, y, toggle_music_ex, _("Always extract to Music folder"))

            y += 38 * gui.scale
            if not msys:
                self.toggle_square(x, y, toggle_use_tray, _("Show icon in system tray"))

                y += 25 * gui.scale
                self.toggle_square(x + round(10 * gui.scale), y, toggle_min_tray, _("Close to tray"))

                y += 25 * gui.scale
                self.toggle_square(x + round(10 * gui.scale), y, toggle_text_tray, _("Show title text"))

                old = prefs.tray_theme
                if not self.toggle_square(x + round(190 * gui.scale), y, prefs.tray_theme == "gray", _("Monochrome")):
                    prefs.tray_theme = "pink"
                else:
                    prefs.tray_theme = "gray"
                if prefs.tray_theme != old:
                    tauon.set_tray_icons(force=True)
                    show_message("Restart Tauon for change to take effect")

            else:
                self.toggle_square(x, y, toggle_min_tray, _("Close to tray"))



        elif self.func_page == 3:
            y += 23 * gui.scale
            old = prefs.enable_remote
            prefs.enable_remote = self.toggle_square(x, y, prefs.enable_remote, _("Enable remote control"),
                                                     subtitle=_("Change requires restart"))
            y += 37 * gui.scale

            if prefs.enable_remote and prefs.enable_remote != old:
                show_message("Notice: This API is not security hardened.",
                             "Only enable in a trusted LAN and do not expose port (7814) to the internet",
                             mode="warning")

            old = prefs.block_suspend
            prefs.block_suspend = self.toggle_square(x, y, prefs.block_suspend, _("Block suspend"),
                                                     subtitle=_("Prevent system suspend during playback"))
            y += 37 * gui.scale
            old = prefs.block_suspend
            prefs.resume_play_wake = self.toggle_square(x, y, prefs.resume_play_wake, _("Resume from suspend"),
                                                        subtitle=_("Continue playback when waking from sleep"))

            y += 37 * gui.scale
            old = prefs.auto_rec
            prefs.auto_rec = self.toggle_square(x, y, prefs.auto_rec, _("Record Radio"),
                                                subtitle=_("Record and split songs when playing internet radio"))
            if prefs.auto_rec != old and prefs.auto_rec:
                show_message(_("Tracks will now be recorded. Restart any playback for change to take effect."),
                             _("Tracks will be saved to \"Saved Radio Tracks\" playlist."),
                             mode="info")

            if tauon.update_play_lock is None:
                prefs.block_suspend = False
                # if flatpak_mode:
                #     show_message("Sandbox support not implemented")
            elif old != prefs.block_suspend:
                tauon.update_play_lock()

            y += 37 * gui.scale
            ddt.text((x, y), "Discord", colours.box_text_label, 11)
            y += 25 * gui.scale
            old = prefs.discord_enable
            prefs.discord_enable = self.toggle_square(x, y, prefs.discord_enable, _("Enable Discord Rich Presence"))

            if flatpak_mode:
                if self.button(x + 215 * gui.scale, y, _("?")):
                    show_message(_("For troubleshooting Discord RP"),
                                 "https://github.com/Taiko2k/TauonMusicBox/wiki/Discord-RP", mode="link")

            if prefs.discord_enable and not old:
                if snap_mode:
                    show_message("Sorry, this feature is unavailable with snap", mode="error")
                    prefs.discord_enable = False
                elif not discord_allow:
                    show_message("Missing dependency python-pypresence")
                    prefs.discord_enable = False
                else:
                    hit_discord()

            if old and not prefs.discord_enable:
                if prefs.discord_active:
                    prefs.disconnect_discord = True

            y += 22 * gui.scale
            text = "Disabled"
            if prefs.discord_enable:
                text = gui.discord_status
            ddt.text((x, y), f"Status: {text}", colours.box_text, 11)

        # Switcher
        pages = 4
        x = x0 + round(23 * gui.scale)
        y = (y0 + h0) - round(31 * gui.scale)
        ww = round(31 * gui.scale)

        for p in range(pages):
            if self.button2(x, y, str(p + 1), width=ww, center_text=True, force_on=self.func_page == p):
                self.func_page = p
            x += ww

        # self.button(x, y, _("Open keymap file"), open_keymap_file, width=wc)

    def button(self, x, y, text, plug=None, width=0, bg=None):

        w = width
        if w == 0:
            w = ddt.get_text_w(text, 211) + round(10 * gui.scale)

        h = round(20 * gui.scale)
        border_size = round(2 * gui.scale)

        rect = (round(x), round(y), round(w), round(h))
        rect2 = (rect[0] - border_size, rect[1] - border_size, rect[2] + border_size * 2, rect[3] + border_size * 2)

        if bg is None:
            bg = colours.box_background

        real_bg = bg
        hit = False

        ddt.rect(rect2, colours.box_check_border)
        ddt.rect(rect, bg)

        fields.add(rect)
        if coll(rect):
            ddt.rect(rect, [255, 255, 255, 15])
            real_bg = alpha_blend([255, 255, 255, 15], bg)
            ddt.text((x + int(w / 2), rect[1] + 1 * gui.scale, 2), text, colours.box_title_text, 211, bg=real_bg)
            if self.click:
                hit = True
                if plug is not None:
                    plug()
        else:
            ddt.text((x + int(w / 2), rect[1] + 1 * gui.scale, 2), text, colours.box_sub_text, 211, bg=real_bg)

        return hit

    def button2(self, x, y, text, width=0, center_text=False, force_on=False):
        w = width
        if w == 0:
            w = ddt.get_text_w(text, 211) + 10 * gui.scale
        rect = (x, y, w, 20 * gui.scale)

        bg_colour = colours.box_button_background
        real_bg = bg_colour

        ddt.rect(rect, bg_colour)
        fields.add(rect)
        hit = False

        text_position = (x + int(7 * gui.scale), rect[1] + 1 * gui.scale)
        if center_text:
            text_position = (x + rect[2] // 2, rect[1] + 1 * gui.scale, 2)

        if coll(rect) or force_on:
            ddt.rect(rect, colours.box_button_background_highlight)
            bg_colour = colours.box_button_background
            real_bg = alpha_blend(colours.box_button_background_highlight, bg_colour)
            ddt.text(text_position, text, colours.box_button_text_highlight, 211, bg=real_bg)
            if self.click and not force_on:
                hit = True
        else:
            ddt.text(text_position, text, colours.box_button_text, 211, bg=real_bg)
        return hit

    def toggle_square(self, x, y, function, text, click=False, subtitle=""):

        x = round(x)
        y = round(y)

        border = round(2 * gui.scale)
        gap = round(2 * gui.scale)
        inner_square = round(6 * gui.scale)

        full_w = border * 2 + gap * 2 + inner_square

        if subtitle:
            le = ddt.text((x + 20 * gui.scale, y - 1 * gui.scale), text, colours.box_text, 13)
            se = ddt.text((x + 20 * gui.scale, y + 14 * gui.scale), subtitle, colours.box_text_label, 13)
            hit_rect = (x - 10 * gui.scale, y - 3 * gui.scale, max(le, se) + 30 * gui.scale, 34 * gui.scale)
            y += round(8 * gui.scale)

        else:
            le = ddt.text((x + 20 * gui.scale, y - 1 * gui.scale), text, colours.box_text, 13)
            hit_rect = (x - 10 * gui.scale, y - 3 * gui.scale, le + 30 * gui.scale, 22 * gui.scale)

        # Border outline
        ddt.rect_a((x, y), (full_w, full_w), colours.box_check_border)
        # Inner background
        ddt.rect_a((x + border, y + border), (gap * 2 + inner_square, gap * 2 + inner_square),
                   alpha_blend([255, 255, 255, 14], colours.box_background))

        # Check if box clicked
        clicked = False
        if (self.click or click) and coll(hit_rect):
            clicked = True

        # There are two mode, function type, and passthrough bool type
        active = False
        if type(function) is bool:
            active = function
        else:
            active = function(1)

        if clicked:
            if type(function) is bool:
                active ^= True
            else:
                function()
                active = function(1)

        # Draw inner check mark if enabled
        if active:
            ddt.rect_a((x + border + gap, y + border + gap), (inner_square, inner_square), colours.toggle_box_on)

        return active

    def last_fm_box(self, x0, y0, w0, h0):

        x = x0 + round(20 * gui.scale)
        y = y0 + round(15 * gui.scale)

        ddt.text_background_colour = colours.box_background

        text = "Last.fm"
        if prefs.use_libre_fm:
            text = "Libre.fm"
        if self.button2(x, y, text, width=84 * gui.scale):
            self.account_view = 1
        self.toggle_square(x + 105 * gui.scale, y + 2 * gui.scale, toggle_lfm_auto, _("Enable"))

        y += 28 * gui.scale

        if self.button2(x, y, "ListenBrainz", width=84 * gui.scale):
            self.account_view = 2
        self.toggle_square(x + 105 * gui.scale, y + 2 * gui.scale, toggle_lb, _("Enable"))

        y += 28 * gui.scale

        if self.button2(x, y, "Maloja", width=84 * gui.scale):
            self.account_view = 9
        self.toggle_square(x + 105 * gui.scale, y + 2 * gui.scale, toggle_maloja, _("Enable"))

        # if self.button2(x, y, "Discogs", width=84*gui.scale):
        #     self.account_view = 3

        y += 28 * gui.scale

        if self.button2(x, y, "fanart.tv", width=84 * gui.scale):
            self.account_view = 4

        y += 28 * gui.scale
        y += 28 * gui.scale

        y += 15 * gui.scale

        if key_shift_down and self.button2(x + round(95 * gui.scale), y, "koel", width=84 * gui.scale):
            self.account_view = 6

        if self.button2(x, y, "Jellyfin", width=84 * gui.scale):
            self.account_view = 10

        y += 28 * gui.scale

        if self.button2(x, y, "Airsonic", width=84 * gui.scale):
            self.account_view = 7

        if self.button2(x + round(95 * gui.scale), y, "PLEX", width=84 * gui.scale):
            self.account_view = 5

        y += 28 * gui.scale

        if self.button2(x, y, "Spotify", width=84 * gui.scale):
            self.account_view = 8

        if self.button2(x + round(95 * gui.scale), y, "Satellite", width=84 * gui.scale):
            self.account_view = 11

        if self.account_view in (9, 2):
            self.toggle_square(x0 + 230 * gui.scale, y + 2 * gui.scale, toggle_scrobble_mark,
                               _("Show threshold marker"))

        x = x0 + 230 * gui.scale
        y = y0 + round(20 * gui.scale)

        if self.account_view == 11:
            ddt.text((x, y), 'Tauon Satellite', colours.box_sub_text, 213)

            y += round(30 * gui.scale)

            field_width = round(245 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("IP"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_sat_url.text = prefs.sat_url
            text_sat_url.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                              width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.sat_url = text_sat_url.text.strip()

            y += round(25 * gui.scale)

            y += round(30 * gui.scale)

            field_width = round(245 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Playlist name"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_sat_playlist.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                                   width=rect1[2] - 8 * gui.scale, click=self.click)

            y += round(25 * gui.scale)

            if self.button(x, y, _("Get playlist")):
                if tau.processing:
                    show_message("An opperation is already running")
                else:
                    shooter(tau.get_playlist())

        elif self.account_view == 9:

            ddt.text((x, y), _('Maloja Server'), colours.box_sub_text, 213)
            if self.button(x + 260 * gui.scale, y, _("?")):
                show_message(_("Maloja is a self-hosted scrobble server."),
                             _("See here to lean more: %s") % "https://github.com/krateng/maloja", mode="link")

            if inp.key_tab_press:
                self.account_text_field += 1
                if self.account_text_field > 2:
                    self.account_text_field = 0

            field_width = round(245 * gui.scale)

            y += round(25 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Server URL"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_maloja_url.text = prefs.maloja_url
            text_maloja_url.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                                 width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.maloja_url = text_maloja_url.text.strip()

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("API Key"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_maloja_key.text = prefs.maloja_key
            text_maloja_key.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                                 width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.maloja_key = text_maloja_key.text.strip()

            y += round(35 * gui.scale)

            if self.button(x, y, _("Test connectivity")):

                if not prefs.maloja_url or not prefs.maloja_key:
                    show_message(_("One or more fields is missing."))
                else:
                    url = prefs.maloja_url
                    if not url.endswith("/mlj_1"):
                        if not url.endswith("/"):
                            url += "/"
                        url += "apis/mlj_1"
                    url += "/test"

                    try:
                        r = requests.get(url, params={'key': prefs.maloja_key})
                        if r.status_code == 403:
                            show_message("Connection appeared successful but the API key was invalid", mode='warning')
                        elif r.status_code == 200:
                            show_message("Connection to Maloja server was successful.", mode='done')
                        else:
                            show_message("The Maloja server returned an error", r.text, mode='warning')
                    except:
                        show_message("Could not communicate with the Maloja server", mode='warning')

            y += round(30 * gui.scale)

            ws = ddt.get_text_w(_("Get scrobble counts"), 211) + 10 * gui.scale
            wcc = ddt.get_text_w(_("Clear"), 211) + 15 * gui.scale
            if self.button(x, y, _("Get scrobble counts")):
                shooter(maloja_get_scrobble_counts)
            self.button(x + ws + round(12 * gui.scale), y, _("Clear"), self.clear_scrobble_counts, width=wcc)

        if self.account_view == 8:

            ddt.text((x, y), 'Spotify', colours.box_sub_text, 213)

            prefs.spot_mode = self.toggle_square(x + 80 * gui.scale, y + 2 * gui.scale, prefs.spot_mode, _("Enable"))
            y += round(30 * gui.scale)

            if self.button(x, y, _("View setup instructions")):
                webbrowser.open("https://github.com/Taiko2k/Tauon/wiki/Spotify", new=2, autoraise=True)

            field_width = round(245 * gui.scale)

            y += round(26 * gui.scale)

            ddt.text((x + 0 * gui.scale, y), _("Client ID"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_spot_client.text = prefs.spot_client
            text_spot_client.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                                  width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.spot_client = text_spot_client.text.strip()

            y += round(19 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Client Secret"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_spot_secret.text = prefs.spot_secret
            text_spot_secret.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                              width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.spot_secret = text_spot_secret.text.strip()

            y += round(27 * gui.scale)

            if prefs.spotify_token:
                if self.button(x, y, _("Forget Account")):
                    spot_ctl.delete_token()
                    spot_ctl.cache_saved_albums.clear()
                    prefs.spot_username = ""
                    if not prefs.launch_spotify_local:
                        prefs.spot_password = ""
            else:
                if self.button(x, y, _("Authorise")):
                    webThread = threading.Thread(target=authserve, args=[tauon])
                    webThread.daemon = True
                    webThread.start()
                    time.sleep(0.1)

                    spot_ctl.auth()

            y += round(31 * gui.scale)
            prefs.launch_spotify_web = self.toggle_square(x, y, prefs.launch_spotify_web,
                                                          _("Prefer launching web player"))

            y += round(24 * gui.scale)

            prefs.launch_spotify_local = self.toggle_square(x, y, prefs.launch_spotify_local,
                                                              _("Enable local audio playback"))

            if prefs.launch_spotify_local and not tauon.enable_librespot:
                show_message("Librespot not installed?")
                prefs.launch_spotify_local = False
            x += round(22 * gui.scale)
            y += round(16 * gui.scale)
            field_width -= round(22 * gui.scale)

            if prefs.launch_spotify_local:
                # ddt.text((x + 0 * gui.scale, y), _("Spotify username"),
                #          colours.box_text_label, 11)
                # y += round(19 * gui.scale)
                # rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
                # fields.add(rect1)
                # if coll(rect1) and (self.click or level_2_right_click):
                #     self.account_text_field = 2
                # ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
                # text_spot_username.text = prefs.spot_username
                # text_spot_username.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
                #                       width=rect1[2] - 8 * gui.scale, click=self.click)
                # prefs.spot_username = text_spot_username.text.strip()

                ddt.text((x + 0 * gui.scale, y), _("Spofify password"),
                         colours.box_text_label, 11)
                y += round(19 * gui.scale)
                rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
                fields.add(rect1)
                if coll(rect1) and (self.click or level_2_right_click):
                    self.account_text_field = 3
                ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
                text_spot_password.text = prefs.spot_password
                text_spot_password.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 3, secret=True,
                                      width=rect1[2] - 8 * gui.scale, click=self.click)
                prefs.spot_password = text_spot_password.text.strip()

        if self.account_view == 7:

            ddt.text((x, y), _('Airsonic/Subsonic network streaming'), colours.box_sub_text, 213)

            if inp.key_tab_press:
                self.account_text_field += 1
                if self.account_text_field > 2:
                    self.account_text_field = 0

            field_width = round(245 * gui.scale)

            y += round(25 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Username / Email"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_air_usr.text = prefs.subsonic_user
            text_air_usr.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                              width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.subsonic_user = text_air_usr.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Password"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_air_pas.text = prefs.subsonic_password
            text_air_pas.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                              width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
            prefs.subsonic_password = text_air_pas.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Server URL"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 2
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_air_ser.text = prefs.subsonic_server
            text_air_ser.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
                              width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.subsonic_server = text_air_ser.text

            y += round(40 * gui.scale)
            self.button(x, y, _("Import music to playlist"), sub_get_album_thread)

            y += round(35 * gui.scale)
            prefs.subsonic_password_plain = self.toggle_square(x, y, prefs.subsonic_password_plain,
                                                               _("Use plain text authentication"),
                                                               subtitle=_("Needed for Nextcloud Music"))

        if self.account_view == 10:

            ddt.text((x, y), _('Jellyfin network streaming'), colours.box_sub_text, 213)

            if inp.key_tab_press:
                self.account_text_field += 1
                if self.account_text_field > 2:
                    self.account_text_field = 0

            field_width = round(245 * gui.scale)

            y += round(25 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Username"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_jelly_usr.text = prefs.jelly_username
            text_jelly_usr.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                                width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.jelly_username = text_jelly_usr.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Password"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_jelly_pas.text = prefs.jelly_password
            text_jelly_pas.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                                width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
            prefs.jelly_password = text_jelly_pas.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Server URL"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 2
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_jelly_ser.text = prefs.jelly_server_url
            text_jelly_ser.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
                                width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.jelly_server_url = text_jelly_ser.text

            y += round(30 * gui.scale)

            self.button(x, y, _("Import music to playlist"), jellyfin_get_library_thread)

            y += round(30 * gui.scale)
            if self.button(x, y, _("Import playlists")):
                found = False
                for item in pctl.gen_codes.values():
                    if item.startswith("jelly"):
                        found = True
                        break
                if not found:
                    gui.show_message("Run music import first")
                else:
                    jellyfin_get_playlists_thread()

            y += round(35 * gui.scale)
            if self.button(x, y, _("Test connectivity")):
                jellyfin.test()

        if self.account_view == 6:

            ddt.text((x, y), _('koel network streaming'), colours.box_sub_text, 213)

            if inp.key_tab_press:
                self.account_text_field += 1
                if self.account_text_field > 2:
                    self.account_text_field = 0

            field_width = round(245 * gui.scale)

            y += round(25 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Username / Email"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_koel_usr.text = prefs.koel_username
            text_koel_usr.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                               width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.koel_username = text_koel_usr.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Password"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_koel_pas.text = prefs.koel_password
            text_koel_pas.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                               width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
            prefs.koel_password = text_koel_pas.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Server URL"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 2
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_koel_ser.text = prefs.koel_server_url
            text_koel_ser.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
                               width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.koel_server_url = text_koel_ser.text

            y += round(40 * gui.scale)

            self.button(x, y, _("Import music to playlist"), koel_get_album_thread)

        if self.account_view == 5:

            ddt.text((x, y), _('PLEX network streaming'), colours.box_sub_text, 213)

            if inp.key_tab_press:
                self.account_text_field += 1
                if self.account_text_field > 2:
                    self.account_text_field = 0

            field_width = round(245 * gui.scale)

            y += round(25 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Username / Email"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 0
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_plex_usr.text = prefs.plex_username
            text_plex_usr.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 0,
                               width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.plex_username = text_plex_usr.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Password"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 1
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_plex_pas.text = prefs.plex_password
            text_plex_pas.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 1,
                               width=rect1[2] - 8 * gui.scale, click=self.click, secret=True)
            prefs.plex_password = text_plex_pas.text

            y += round(23 * gui.scale)
            ddt.text((x + 0 * gui.scale, y), _("Server name"),
                     colours.box_text_label, 11)
            y += round(19 * gui.scale)
            rect1 = (x + 0 * gui.scale, y, field_width, round(17 * gui.scale))
            fields.add(rect1)
            if coll(rect1) and (self.click or level_2_right_click):
                self.account_text_field = 2
            ddt.bordered_rect(rect1, colours.box_background, colours.box_text_border, round(1 * gui.scale))
            text_plex_ser.text = prefs.plex_servername
            text_plex_ser.draw(x + round(4 * gui.scale), y, colours.box_input_text, self.account_text_field == 2,
                               width=rect1[2] - 8 * gui.scale, click=self.click)
            prefs.plex_servername = text_plex_ser.text

            y += round(40 * gui.scale)
            self.button(x, y, _("Import music to playlist"), plex_get_album_thread)

        if self.account_view == 4:

            ddt.text((x, y), 'fanart.tv', colours.box_sub_text, 213)

            y += 25 * gui.scale
            ddt.text((x + 0 * gui.scale, y, 4, 270 * gui.scale, 600),
                     _("Fanart.tv can be used for sourcing of artist images and cover art."),
                     colours.box_text_label, 11)
            y += 17 * gui.scale

            y += 22 * gui.scale
            # . Limited space available. Limit 55 chars.
            link_pa2 = 