/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import aliview.messenges.Messenger;
import aliview.settings.Settings;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.JFrame;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;

public class HelpUtils {
    private static final Logger logger = Logger.getLogger(HelpUtils.class);
    public static final String EXTERNAL_COMMANDS = "EXTERNAL_COMMANDS";
    public static final String ALIGNER_SETTINGS_ALL = "ALIGNER_SETTINS_ALL";
    public static final String ALIGNER_SETTINGS_ADD = "ALIGNER_SETTINS_ADD";
    public static final String General_settings = "General_settings";
    public static final String Find_Primer_settings = "Find_Primer_settings";
    public static final String TOP_HELP = "TOP_HELP";
    public static final String DOWNLOAD = "DOWNLOAD";
    public static final String BUG_OR_FEATURE = "BUG_OR_FEATURE";
    public static final String MEMORY_SETTINGS = "memory_settings";
    public static final String EDIT_CHARSETS_DIALOG = "EDIT_CHARSETS_DIALOG";
    protected static String baseURL = Settings.getAliViewHelpWebPage();
    protected static String localBaseURL = "file:///home/anders/maven/AliView/web/help/help.html";

    public static void display(String bookmark, JFrame parentFrame) {
        URL location = HelpUtils.getURL(bookmark);
        try {
            HelpUtils.openWebpage(location);
        }
        catch (Exception e) {
            Messenger.showOKOnlyMessage(Messenger.COULD_NOT_OPEN_HELP_IN_BROWSER, parentFrame);
            e.printStackTrace();
        }
    }

    private static URL getURL(String bookmark) {
        String baseLocation = baseURL;
        String username = System.getenv("USERNAME");
        if (username != null && username.equals("anders-not-being-used")) {
            baseLocation = localBaseURL;
        }
        URL location = null;
        try {
            location = new URL(baseLocation + "#" + bookmark);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return location;
    }

    public static void openWebpage(URL url) throws Exception {
        ArrayList<String> cmds = new ArrayList<String>();
        if (OSNativeUtils.isMac()) {
            cmds.add("open");
            cmds.add(url.toString());
        } else if (OSNativeUtils.isWindows()) {
            cmds.add("cmd.exe");
            cmds.add("/c");
            cmds.add("start");
            cmds.add(url.toString());
        } else {
            cmds.add("xdg-open");
            cmds.add(url.toString());
        }
        ProcessBuilder builder = new ProcessBuilder(cmds);
        builder.start();
    }

    public static void displayVersionDownload(String version) {
        try {
            String versionDownloadURL = "http://www.ormbunkar.se/aliview/version.php?ver=" + version;
            URL location = new URL(versionDownloadURL);
            HelpUtils.openWebpage(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void displayVersionHistory() {
        try {
            String versionDownloadURL = "http://www.ormbunkar.se/aliview/version_history.txt";
            URL location = new URL(versionDownloadURL);
            HelpUtils.openWebpage(location);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

