/*
 * Decompiled with CFR 0.152.
 */
package aliview;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NucleotideUtilities {
    private static final Logger logger = Logger.getLogger(NucleotideUtilities.class);
    public static final int GAP = 0;
    public static final int A = 1;
    public static final int C = 2;
    public static final int G = 4;
    public static final int TU = 8;
    public static final int U = 8;
    public static final int T = 8;
    public static final int UNKNOWN = 32;
    public static final int R = 5;
    public static final int Y = 10;
    public static final int M = 3;
    public static final int K = 12;
    public static final int W = 9;
    public static final int S = 6;
    public static final int B = 14;
    public static final int D = 13;
    public static final int H = 11;
    public static final int V = 7;
    public static final int N = 15;
    static byte[] allResidues = new byte[256];

    public static final int baseValFromBase(byte base) {
        return NucleotideUtilities.baseValFromChar((char)base);
    }

    public static final byte complement(char base) {
        byte complement;
        switch (base) {
            case 'A': {
                complement = 84;
                break;
            }
            case 'C': {
                complement = 71;
                break;
            }
            case 'G': {
                complement = 67;
                break;
            }
            case 'T': 
            case 'U': {
                complement = 65;
                break;
            }
            case 'R': {
                complement = 89;
                break;
            }
            case 'Y': {
                complement = 82;
                break;
            }
            case 'M': {
                complement = 75;
                break;
            }
            case 'K': {
                complement = 77;
                break;
            }
            case 'W': {
                complement = 87;
                break;
            }
            case 'S': {
                complement = 83;
                break;
            }
            case 'B': {
                complement = 86;
                break;
            }
            case 'D': {
                complement = 72;
                break;
            }
            case 'H': {
                complement = 68;
                break;
            }
            case 'V': {
                complement = 66;
                break;
            }
            case 'N': {
                complement = 78;
                break;
            }
            case 'a': {
                complement = 116;
                break;
            }
            case 'c': {
                complement = 103;
                break;
            }
            case 'g': {
                complement = 99;
                break;
            }
            case 't': 
            case 'u': {
                complement = 97;
                break;
            }
            case 'r': {
                complement = 121;
                break;
            }
            case 'y': {
                complement = 114;
                break;
            }
            case 'm': {
                complement = 107;
                break;
            }
            case 'k': {
                complement = 115;
                break;
            }
            case 'w': {
                complement = 119;
                break;
            }
            case 's': {
                complement = 115;
                break;
            }
            case 'b': {
                complement = 118;
                break;
            }
            case 'd': {
                complement = 104;
                break;
            }
            case 'h': {
                complement = 100;
                break;
            }
            case 'v': {
                complement = 98;
                break;
            }
            case '.': 
            case '?': 
            case 'n': {
                complement = 110;
                break;
            }
            case '-': {
                complement = 45;
                break;
            }
            default: {
                complement = (byte)base;
            }
        }
        return complement;
    }

    public static final boolean isGap(byte base) {
        return NucleotideUtilities.baseValFromBase(base) == 0;
    }

    public static final boolean isNucleoticeOrIUPAC(byte base) {
        int baseVal = NucleotideUtilities.baseValFromBase(base);
        return baseVal != 0 && baseVal != 32;
    }

    public static final int baseValFromChar(char base) {
        int baseVal;
        switch (base) {
            case 'A': 
            case 'a': {
                baseVal = 1;
                break;
            }
            case 'C': 
            case 'c': {
                baseVal = 2;
                break;
            }
            case 'G': 
            case 'g': {
                baseVal = 4;
                break;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                baseVal = 8;
                break;
            }
            case 'R': 
            case 'r': {
                baseVal = 5;
                break;
            }
            case 'Y': 
            case 'y': {
                baseVal = 10;
                break;
            }
            case 'M': 
            case 'm': {
                baseVal = 3;
                break;
            }
            case 'K': 
            case 'k': {
                baseVal = 12;
                break;
            }
            case 'W': 
            case 'w': {
                baseVal = 9;
                break;
            }
            case 'S': 
            case 's': {
                baseVal = 6;
                break;
            }
            case 'B': 
            case 'b': {
                baseVal = 14;
                break;
            }
            case 'D': 
            case 'd': {
                baseVal = 13;
                break;
            }
            case 'H': 
            case 'h': {
                baseVal = 11;
                break;
            }
            case 'V': 
            case 'v': {
                baseVal = 7;
                break;
            }
            case '.': 
            case '?': 
            case 'N': 
            case 'n': {
                baseVal = 15;
                break;
            }
            case '\n': 
            case '\r': 
            case ' ': 
            case '-': 
            case '_': {
                baseVal = 0;
                break;
            }
            default: {
                baseVal = 32;
            }
        }
        return baseVal;
    }

    public static byte byteFromBaseVal(int consensusVal) {
        char charVal = NucleotideUtilities.charFromBaseVal(consensusVal);
        return (byte)charVal;
    }

    public static final char charFromBaseVal(int baseVal) {
        char base;
        switch (baseVal) {
            case 1: {
                base = 'A';
                break;
            }
            case 2: {
                base = 'C';
                break;
            }
            case 4: {
                base = 'G';
                break;
            }
            case 8: {
                base = 'T';
                break;
            }
            case 5: {
                base = 'R';
                break;
            }
            case 10: {
                base = 'Y';
                break;
            }
            case 3: {
                base = 'M';
                break;
            }
            case 12: {
                base = 'K';
                break;
            }
            case 9: {
                base = 'W';
                break;
            }
            case 6: {
                base = 'S';
                break;
            }
            case 14: {
                base = 'B';
                break;
            }
            case 13: {
                base = 'D';
                break;
            }
            case 11: {
                base = 'H';
                break;
            }
            case 7: {
                base = 'V';
                break;
            }
            case 15: {
                base = 'N';
                break;
            }
            case 0: {
                base = '-';
                break;
            }
            default: {
                base = '?';
            }
        }
        return base;
    }

    public static final int degenFoldFromChar(char base) {
        int degenFold;
        switch (base) {
            case 'A': 
            case 'C': 
            case 'G': 
            case 'T': 
            case 'U': 
            case 'a': 
            case 'c': 
            case 'g': 
            case 't': 
            case 'u': {
                degenFold = 1;
                break;
            }
            case 'K': 
            case 'M': 
            case 'R': 
            case 'S': 
            case 'W': 
            case 'Y': 
            case 'k': 
            case 'm': 
            case 'r': 
            case 's': 
            case 'w': 
            case 'y': {
                degenFold = 2;
                break;
            }
            case 'B': 
            case 'D': 
            case 'H': 
            case 'V': 
            case 'b': 
            case 'd': 
            case 'h': 
            case 'v': {
                degenFold = 3;
                break;
            }
            case '?': 
            case 'N': 
            case 'n': {
                degenFold = 4;
                break;
            }
            case '-': {
                degenFold = 1;
                break;
            }
            default: {
                degenFold = 1;
            }
        }
        return degenFold;
    }

    public static char[] nucleotideCharsFromBaseVal(int baseVal) {
        String nuces = "";
        if ((1 & baseVal) == 1) {
            nuces = nuces + "A";
        }
        if ((2 & baseVal) == 2) {
            nuces = nuces + "C";
        }
        if ((4 & baseVal) == 4) {
            nuces = nuces + "G";
        }
        if ((8 & baseVal) == 8) {
            nuces = nuces + "T";
        }
        return nuces.toCharArray();
    }

    public static ArrayList<String> regenerateDegenerated(String input) {
        ArrayList<String> replaced;
        String nextSeq;
        int n;
        ArrayList<String> sequences = new ArrayList<String>();
        sequences.add(input);
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "R", "AG");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "Y", "CT");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "M", "CA");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "K", "TG");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "W", "TA");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "S", "CG");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "B", "CTG");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "D", "ATG");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "H", "ATC");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = (String)sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "V", "TGC");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        for (n = 0; n < sequences.size(); ++n) {
            nextSeq = sequences.get(n);
            replaced = NucleotideUtilities.deUpac(nextSeq, "N", "ATGC");
            if (replaced == null || replaced.size() <= 0) continue;
            sequences.remove(n);
            sequences.addAll(replaced);
            --n;
        }
        return sequences;
    }

    private static ArrayList<String> deUpac(String input, String upac, String replace) {
        ArrayList<String> replaced = null;
        if (input.indexOf(upac) != -1) {
            replaced = new ArrayList<String>();
            for (int n = 0; n < replace.length(); ++n) {
                String replacedString = input.replace(upac.charAt(0), replace.charAt(n));
                replaced.add(replacedString);
            }
        }
        return replaced;
    }

    public static final String reverse(String input) {
        StringBuffer sb = new StringBuffer(input);
        String reverse = sb.reverse().toString();
        return reverse;
    }

    public static final String complement(String input) {
        String NORMAL = "AaCcGgTtUuRrYyKkMmSsWwBbDdHhVvNn-";
        String COMPLEMENT = "TtGgCcAaAaYyRrMmKkSsWwVvHhDdBbNn-";
        String output = "";
        for (int n = 0; n < input.length(); ++n) {
            char normChar = input.charAt(n);
            int nuclIndex = NORMAL.indexOf(normChar);
            output = nuclIndex > -1 ? output + COMPLEMENT.charAt(nuclIndex) : output + normChar;
        }
        return output;
    }

    public static final String revComp(String sequence) {
        return NucleotideUtilities.reverse(NucleotideUtilities.complement(sequence));
    }

    public static boolean containsA(char input) {
        int baseVal = NucleotideUtilities.baseValFromChar(input);
        return (1 & baseVal) == 1;
    }

    public static boolean containsC(char input) {
        int baseVal = NucleotideUtilities.baseValFromChar(input);
        return (2 & baseVal) == 2;
    }

    public static boolean containsT(char input) {
        int baseVal = NucleotideUtilities.baseValFromChar(input);
        return (8 & baseVal) == 8;
    }

    public static boolean containsG(char input) {
        int baseVal = NucleotideUtilities.baseValFromChar(input);
        return (4 & baseVal) == 4;
    }

    public static int getDimerBinding(char n1Char, char n2Char) {
        int degenerateFold;
        int n1Val = NucleotideUtilities.baseValFromChar(n1Char);
        int n2Val = NucleotideUtilities.baseValFromChar(n2Char);
        int bindVal = 0;
        int bindCount = 0;
        if (NucleotideUtilities.containsA(n1Char) && NucleotideUtilities.containsT(n2Char)) {
            bindVal += 2;
            ++bindCount;
        }
        if (NucleotideUtilities.containsT(n1Char) && NucleotideUtilities.containsA(n2Char)) {
            bindVal += 2;
            ++bindCount;
        }
        if (NucleotideUtilities.containsC(n1Char) && NucleotideUtilities.containsG(n2Char)) {
            bindVal += 4;
            ++bindCount;
        }
        if (NucleotideUtilities.containsG(n1Char) && NucleotideUtilities.containsC(n2Char)) {
            bindVal += 4;
            ++bindCount;
        }
        if ((degenerateFold = NucleotideUtilities.degenFoldFromChar(n1Char) * NucleotideUtilities.degenFoldFromChar(n2Char)) > 1) {
            bindVal = bindCount * 2 / degenerateFold;
        }
        return bindVal;
    }

    public static final String[] seqToDeUPACStringArray(String sequence) {
        char[][] matrix;
        for (char[] row : matrix = new char[4][sequence.length()]) {
            Arrays.fill(row, ' ');
        }
        for (int x = 0; x < sequence.length(); ++x) {
            char baseChar = sequence.charAt(x);
            int baseVal = NucleotideUtilities.baseValFromChar(baseChar);
            char[] nucleotidesInThisXpos = NucleotideUtilities.nucleotideCharsFromBaseVal(baseVal);
            for (int y = 0; y < nucleotidesInThisXpos.length; ++y) {
                matrix[y][x] = nucleotidesInThisXpos[y];
            }
        }
        String[] stringArray = new String[4];
        for (int n = 0; n < matrix.length; ++n) {
            stringArray[n] = new String(matrix[n]);
        }
        return stringArray;
    }

    public static void complement(byte[] byteSeq) {
        for (int n = 0; n < byteSeq.length; ++n) {
            byteSeq[n] = NucleotideUtilities.complement((char)byteSeq[n]);
        }
    }

    public static byte getConsensusFromBases(byte base1, byte base2) {
        int baseVal1 = NucleotideUtilities.baseValFromBase(base1);
        int baseVal2 = NucleotideUtilities.baseValFromBase(base2);
        int consensusVal = baseVal1 | baseVal2;
        byte consensus = NucleotideUtilities.byteFromBaseVal(consensusVal);
        return consensus;
    }

    public static byte getMinBase(byte base1, byte base2) {
        int baseVal1 = NucleotideUtilities.baseValFromBase(base1);
        int baseVal2 = NucleotideUtilities.baseValFromBase(base2);
        int minBaseVal = Math.min(baseVal1, baseVal2);
        return NucleotideUtilities.byteFromBaseVal(minBaseVal);
    }

    public static boolean isAtLeastOneGap(byte base1, byte base2) {
        return NucleotideUtilities.isGap(base1) || NucleotideUtilities.isGap(base2);
    }

    public static int baseValFromBaseOtherVer(byte residue) {
        return allResidues[residue];
    }
}

