/*
 * Decompiled with CFR 0.152.
 */
package aliview.aligner;

import aliview.aligner.MuscleWrapper;
import aliview.subprocesses.SubProcessWindow;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Scanner;
import org.apache.log4j.Logger;

public class Aligner {
    private static final Logger logger = Logger.getLogger(Aligner.class);
    private static final String LF = System.getProperty("line.separator");

    public static void muscleProfileAlign(File in1, File in2, File out) {
        Aligner.muscleProfileAlign(in1, in2, out, null);
    }

    public static void muscleProfileAlign(File in1, File in2, File out, SubProcessWindow subProcessWin) {
        boolean wasProcessInterrupted = false;
        try {
            String nextLine;
            String[] commandArray;
            for (String token : commandArray = new String[]{MuscleWrapper.getMusclePath().toString(), "-profile", "-in1", in1.toString(), "-in2", in2.toString(), "-out", out.toString()}) {
                logger.info(token);
            }
            String totalCommand = "";
            for (String token : commandArray) {
                totalCommand = totalCommand + token + " ";
            }
            logger.info(totalCommand);
            Process subprocess = Runtime.getRuntime().exec(commandArray);
            subProcessWin.setActiveProcess(subprocess);
            Scanner sc = new Scanner(subprocess.getInputStream());
            Scanner errorSc = new Scanner(subprocess.getErrorStream());
            while (errorSc.hasNext()) {
                nextLine = errorSc.nextLine();
                subProcessWin.appendOutput(nextLine + LF);
                System.out.println(nextLine);
            }
            while (sc.hasNext()) {
                nextLine = sc.nextLine();
                subProcessWin.appendOutput(nextLine + LF);
                System.out.println(nextLine);
            }
            try {
                subprocess.waitFor();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            subprocess.destroy();
            logger.info("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void mafftAlign(File in, File out, final SubProcessWindow subProcessWin) throws IOException {
        boolean wasProcessInterrupted = false;
        String[] commandArray = new String[]{"mafft", "--localpair", "--maxiterate", "1000", in.toString()};
        ProcessBuilder probuilder = new ProcessBuilder(commandArray);
        for (String token : commandArray) {
            logger.info(token);
        }
        String totalCommand = "";
        for (String token : commandArray) {
            totalCommand = totalCommand + token + " ";
        }
        logger.info(totalCommand);
        Process subprocess = probuilder.start();
        subProcessWin.setActiveProcess(subprocess);
        Scanner sc = new Scanner(subprocess.getInputStream());
        final Scanner errorSc = new Scanner(subprocess.getErrorStream());
        Thread errorReaderThread = new Thread(new Runnable(){

            public void run() {
                while (errorSc.hasNext()) {
                    String nextLine = errorSc.nextLine();
                    subProcessWin.appendOutput(nextLine + LF);
                    System.out.println(nextLine);
                }
                logger.info("errorReaderThread-finished");
            }
        });
        errorReaderThread.start();
        BufferedWriter buffOut = new BufferedWriter(new FileWriter(out));
        while (sc.hasNext()) {
            String nextLine = sc.nextLine();
            buffOut.append(nextLine + LF);
        }
        sc.close();
        buffOut.close();
        try {
            subprocess.waitFor();
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        subprocess.destroy();
        logger.info("done");
    }

    public static void muscleAlign(File in, File out, SubProcessWindow subProcessWin) {
        try {
            String nextLine;
            String[] commandArray;
            for (String token : commandArray = new String[]{MuscleWrapper.getMusclePath().toString(), "-in", in.toString(), "-out", out.toString()}) {
                logger.info(token);
            }
            String totalCommand = "";
            for (String token : commandArray) {
                totalCommand = totalCommand + token + " ";
            }
            logger.info(totalCommand);
            Process subprocess = Runtime.getRuntime().exec(commandArray);
            subProcessWin.setActiveProcess(subprocess);
            Scanner sc = new Scanner(subprocess.getInputStream());
            Scanner errorSc = new Scanner(subprocess.getErrorStream());
            while (errorSc.hasNext()) {
                nextLine = errorSc.nextLine();
                subProcessWin.appendOutput(nextLine + LF);
                System.err.println(nextLine);
            }
            while (sc.hasNext()) {
                nextLine = sc.nextLine();
                subProcessWin.appendOutput(nextLine + LF);
                System.out.println(nextLine);
            }
            try {
                subprocess.waitFor();
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
            subprocess.destroy();
            logger.info("done");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class AlignResult {
        private boolean wasDestroyedByUser;

        protected AlignResult() {
        }

        protected AlignResult(boolean wasDestroyedByUser) {
            this.wasDestroyedByUser = wasDestroyedByUser;
        }

        public boolean wasDestroyedByUser() {
            return this.wasDestroyedByUser;
        }

        public boolean isWasDestroyedByUser() {
            return this.wasDestroyedByUser;
        }

        public void setWasDestroyedByUser(boolean wasDestroyedByUser) {
            this.wasDestroyedByUser = wasDestroyedByUser;
        }
    }
}

