/*
 * Decompiled with CFR 0.152.
 */
package aliview.alignment;

import aliview.AminoAcid;
import aliview.GeneticCode;
import aliview.NucleotideUtilities;
import aliview.sequences.Sequence;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Arrays;
import org.apache.log4j.Logger;
import utils.nexus.CodonPos;
import utils.nexus.CodonPositions;

public class NotUsed_AATranslator {
    private static final Logger logger = Logger.getLogger(NotUsed_AATranslator.class);
    CodonPositions codonPositions;
    private Sequence sequence;
    private GeneticCode genCode;
    private int cachedClosestStartPos = -1;
    private int cachedAminoTripletAcidPos = -1;
    private AminoAcid cachedAminoAcid;

    public NotUsed_AATranslator(CodonPositions codonPositions, GeneticCode genCode) {
        this.codonPositions = codonPositions;
        this.genCode = genCode;
    }

    public void setCodonPos(CodonPositions codonPos) {
        this.codonPositions = codonPos;
    }

    public void setSequence(Sequence seq) {
        this.sequence = seq;
        this.cachedClosestStartPos = -1;
        this.cachedAminoTripletAcidPos = -1;
    }

    public void setGeneticCode(GeneticCode genCode) {
        this.genCode = genCode;
    }

    public boolean isFullCodonStartingAt(int x) {
        return this.codonPositions.isFullCodonStartingAt(x);
    }

    public AminoAcid getAminoAcidAtNucleotidePos(int x) {
        if (this.isFullCodonStartingAt(x)) {
            return this.getAminoAcidFromTripletStartingAt(x);
        }
        if (this.isFullCodonStartingAt(x - 1)) {
            return this.getAminoAcidFromTripletStartingAt(x - 1);
        }
        if (this.isFullCodonStartingAt(x - 2)) {
            return this.getAminoAcidFromTripletStartingAt(x - 2);
        }
        return AminoAcid.GAP;
    }

    public boolean isCodonSecondPos(int x) {
        return this.isFullCodonStartingAt(x - 1);
    }

    public byte[] getTripletAt(int x) {
        byte[] codon = new byte[3];
        for (int n = 0; n < 3; ++n) {
            codon[n] = x + n < this.sequence.getLength() ? this.sequence.getBaseAtPos(x + n) : (byte)45;
        }
        return codon;
    }

    public int getCachedClosestStartPos() {
        return this.cachedClosestStartPos;
    }

    public AminoAcid getNoGapAminoAcidAtNucleotidePos(int target) {
        int tripCount = 0;
        byte[] triplet = new byte[3];
        int seqLen = this.sequence.getLength();
        int startPos = 0;
        if (this.cachedClosestStartPos == -1) {
            int skipCount = 0;
            int readingFrame = this.codonPositions.getReadingFrame();
            if (readingFrame > 1) {
                for (int n = 0; n < seqLen; ++n) {
                    byte base = this.sequence.getBaseAtPos(n);
                    if (!NucleotideUtilities.isGap(base) && this.codonPositions.isCoding(n)) {
                        ++skipCount;
                    }
                    if (skipCount != readingFrame) continue;
                    startPos = n;
                }
            }
        } else {
            startPos = this.cachedClosestStartPos;
        }
        if (target >= startPos) {
            for (int n = startPos; n < seqLen; ++n) {
                byte base = this.sequence.getBaseAtPos(n);
                if (NucleotideUtilities.isGap(base) || this.codonPositions.isNonCoding(n)) {
                    if (n < target || tripCount != 0) continue;
                    return AminoAcid.GAP;
                }
                triplet[++tripCount - 1] = base;
                if (tripCount == 1) {
                    this.cachedClosestStartPos = n;
                }
                if (tripCount != 3) continue;
                if (n >= target) {
                    AminoAcid aa = AminoAcid.getAminoAcidFromCodon(triplet, this.genCode);
                    return aa;
                }
                triplet = new byte[3];
                tripCount = 0;
            }
            return AminoAcid.X;
        }
        return AminoAcid.GAP;
    }

    public AminoAcid getAminoAcidFromTripletStartingAt(int x) {
        if (this.cachedAminoTripletAcidPos != x) {
            this.cachedAminoTripletAcidPos = x;
            this.cachedAminoAcid = AminoAcid.getAminoAcidFromCodon(this.getTripletAt(this.cachedAminoTripletAcidPos), this.genCode);
        }
        return this.cachedAminoAcid;
    }

    public String getTranslatedAsString() {
        StringWriter out = new StringWriter(this.sequence.getLength() / 3);
        this.writeTranslation(out);
        return out.toString();
    }

    public void writeTranslation(Writer out) {
        int x = 0;
        int gap = 0;
        try {
            while (x < this.sequence.getLength()) {
                if (this.isFullCodonStartingAt(x)) {
                    byte[] codon = this.getTripletAt(x);
                    out.append(AminoAcid.getAminoAcidFromCodon(codon).getCodeCharVal());
                    gap = 0;
                    x += 3;
                    continue;
                }
                if (++gap % 3 == 1) {
                    out.append(AminoAcid.X.getCodeCharVal());
                }
                ++x;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int getTranslatedAminAcidSequenceLength() {
        return this.codonPositions.getAminoAcidPosFromNucleotidePos(this.sequence.getLength() - 1);
    }

    public int getMaximumTranslationLength() {
        return this.codonPositions.getAminoAcidPosFromNucleotidePos(this.sequence.getLength());
    }

    public AminoAcid getAAinNoGapTranslatedPos(int x) {
        return this.getNoGapAminoAcidAtNucleotidePos(x * 3);
    }

    public AminoAcid getAAinTranslatedPos(int x) {
        CodonPos codonPos = this.codonPositions.getCodonInTranslatedPos(x);
        if (codonPos == null) {
            return null;
        }
        if (!codonPos.isCoding()) {
            return AminoAcid.X;
        }
        byte[] codon = this.getTripletAt(codonPos.startPos);
        AminoAcid aa = AminoAcid.getAminoAcidFromCodon(codon, this.genCode);
        return aa;
    }

    public byte[] getGapPaddedCodonInTranslatedPos(int x) {
        byte[] codon = this.getCodonInTranslatedPos(x);
        byte[] padded = new byte[3];
        Arrays.fill(padded, (byte)45);
        for (int n = 0; n < codon.length; ++n) {
            padded[n] = codon[n];
        }
        return padded;
    }

    public byte[] getCodonInTranslatedPos(int x) {
        CodonPos codonPos = this.codonPositions.getCodonInTranslatedPos(x);
        if (codonPos.isOrfan()) {
            byte[] codon = this.sequence.getBasesBetween(codonPos.startPos, codonPos.endPos);
            return codon;
        }
        byte[] codon = this.getTripletAt(codonPos.startPos);
        return codon;
    }

    public int findFistPosSkipStop(int nextFindPos, AminoAcid target) {
        for (int n = nextFindPos; n < this.codonPositions.getAminoAcidPosFromNucleotidePos(this.sequence.getLength()); ++n) {
            AminoAcid nextAA = this.getAAinTranslatedPos(n);
            if (nextAA != null && nextAA == AminoAcid.STOP || nextAA == null || nextAA.getCodeCharVal() != target.getCodeCharVal()) continue;
            return n;
        }
        return -1;
    }

    public int findFistPos(int nextFindPos, AminoAcid target) {
        for (int n = nextFindPos; n < this.codonPositions.getAminoAcidPosFromNucleotidePos(this.sequence.getLength()); ++n) {
            AminoAcid nextAA = this.getAAinTranslatedPos(n);
            if (nextAA == null || nextAA.getCodeCharVal() != target.getCodeCharVal()) continue;
            return n;
        }
        return -1;
    }

    public int countStopCodon() {
        int counter = 0;
        int transLen = this.getTranslatedAminAcidSequenceLength();
        for (int n = 0; n < transLen; ++n) {
            AminoAcid aa = this.getAAinTranslatedPos(n);
            if (aa != AminoAcid.STOP) continue;
            ++counter;
        }
        return counter;
    }
}

