/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import aliview.AliView;
import aliview.AliViewWindow;
import aliview.GeneticCode;
import aliview.alignment.AlignmentEvent;
import aliview.alignment.AlignmentListener;
import aliview.color.ColorScheme;
import aliview.color.ColorSchemeFactory;
import aliview.externalcommands.CommandItem;
import aliview.gui.AppIcons;
import aliview.gui.NoneSelectedButtonGroup;
import aliview.importer.FileFormat;
import aliview.sequencelist.AlignmentDataEvent;
import aliview.sequencelist.AlignmentDataListener;
import aliview.sequencelist.AlignmentSelectionEvent;
import aliview.sequencelist.AlignmentSelectionListener;
import aliview.sequences.SequenceUtils;
import aliview.settings.Settings;
import aliview.settings.SettingsListener;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ButtonGroup;
import javax.swing.ButtonModel;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;
import utils.nexus.CharSet;
import utils.nexus.CharSets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AliViewJMenuBar
extends JMenuBar
implements AlignmentListener,
AlignmentDataListener,
AlignmentSelectionListener,
SettingsListener {
    private static final Logger logger = Logger.getLogger(AliViewJMenuBar.class);
    private AliViewWindow aliViewWindow;
    private ArrayList<AbstractButton> editFunctions = new ArrayList();
    private ArrayList<AbstractButton> alwaysAvailableFunctions = new ArrayList();
    private ArrayList<AbstractButton> loadedAlignmentFunctions = new ArrayList();
    private ArrayList<AbstractButton> nucleotideFunctions = new ArrayList();
    private ArrayList<AbstractButton> aminoAcidFunctions = new ArrayList();
    private ArrayList<AbstractButton> hasSelectionFunctions = new ArrayList();
    private ArrayList<AbstractButton> undoFunctions = new ArrayList();
    private ArrayList<AbstractButton> reorderAndDeleteFunctions = new ArrayList();
    private JMenu mnRecentFiles;
    private JMenu mnExternal;
    private JMenu mnFilePages;
    private JMenu mnGeneticCodeCode;
    private JMenuItem undoButton;
    private JMenuItem redoButton;
    private ButtonModel toggleTranslationButtonModel;
    private ButtonModel highlightConsButtonModel;
    private ButtonModel highlightNonConsButtonModel;
    private ButtonModel highlightDiffButtonModel;
    private ButtonModel decFontSizeButtonModel;
    private ButtonModel incFontSizeButtonModel;
    private ButtonModel drawCoonPosOnRulerButtonModel;
    private ButtonModel nonCodingButtonModel;
    private ButtonModel showAACodeButtonMoes;
    private ButtonModel coding1ButtonModel;
    private ButtonModel coding0ButtonModel;
    private ButtonModel coding2ButtonModel;
    private ButtonModel copyAsFastaButtonModel;
    private ButtonModel copyAsCharatersButtonModel;
    private ButtonModel realignSelectedBlockButtonModel;
    private ButtonModel realignSelectedSequencesButtonModel;
    private ButtonModel pasteAsFastaButtonModel;
    private ButtonModel editModeButtonModel;
    private boolean menuLock;
    private ButtonModel copyNameButtonModel;
    private ButtonModel renameButtonModel;
    private JMenu mnSelectCharset;
    private ButtonModel countCodonButtonModel;
    private ButtonModel addEmptySeqButtonModel;
    private ButtonModel deleteSequencesButtonModel;
    private Action transOnePosAction;

    public AliViewJMenuBar(AliViewWindow aliViewWin) {
        this.aliViewWindow = aliViewWin;
        logger.debug("create menubar");
        JMenu mnFile = new JMenu("File");
        mnFile.setMnemonic(70);
        this.add(mnFile);
        JMenuItem mntmNew = new JMenuItem("New");
        mntmNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliView.createNewWindow();
            }
        });
        mntmNew.setIcon(AppIcons.getNewIcon());
        mntmNew.setAccelerator(OSNativeUtils.getNewFileAccelerator());
        mnFile.add(mntmNew);
        this.alwaysAvailableFunctions.add(mntmNew);
        JMenuItem mntmOpenFile = new JMenuItem("Open File");
        mntmOpenFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliView.openAlignmentFileViaChooser(AliViewJMenuBar.this.aliViewWindow.getParent());
            }
        });
        mntmOpenFile.setAccelerator(OSNativeUtils.getOpenFileAccelerator());
        mnFile.add(mntmOpenFile);
        this.alwaysAvailableFunctions.add(mntmOpenFile);
        mnFile.add(new JSeparator());
        this.mnRecentFiles = new JMenu("Recent Files");
        mnFile.add(this.mnRecentFiles);
        this.rebuildRecentFilesSubmenu();
        this.alwaysAvailableFunctions.add(this.mnRecentFiles);
        mnFile.add(new JSeparator());
        JMenuItem mntmReloadFile = new JMenuItem("Reload file");
        mntmReloadFile.setAccelerator(OSNativeUtils.getReloadKeyAccelerator());
        mntmReloadFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.reloadCurrentFile();
            }
        });
        mnFile.add(mntmReloadFile);
        this.loadedAlignmentFunctions.add(mntmReloadFile);
        mnFile.add(new JSeparator());
        JMenuItem saveFileMenu = new JMenuItem("Save");
        saveFileMenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentFile();
            }
        });
        saveFileMenu.setAccelerator(OSNativeUtils.getSaveFileAccelerator());
        mnFile.add(saveFileMenu);
        this.loadedAlignmentFunctions.add(saveFileMenu);
        JMenuItem saveAlignmentAsFastaNebu = new JMenuItem("Save as Fasta");
        saveAlignmentAsFastaNebu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.FASTA, false);
            }
        });
        mnFile.add(saveAlignmentAsFastaNebu);
        this.loadedAlignmentFunctions.add(saveAlignmentAsFastaNebu);
        JMenuItem mntmSaveAlignmentAsNexus = new JMenuItem("Save as Nexus");
        mntmSaveAlignmentAsNexus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.NEXUS, false);
            }
        });
        mnFile.add(mntmSaveAlignmentAsNexus);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsNexus);
        JMenuItem mntmSaveAlignmentAsSimpleNexus = new JMenuItem("Save as Nexus (Illegal name chars replaced by _ (e.g. for MrBayes)");
        mntmSaveAlignmentAsSimpleNexus.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.NEXUS_SIMPLE, false);
            }
        });
        mnFile.add(mntmSaveAlignmentAsSimpleNexus);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsSimpleNexus);
        JMenuItem mntmSaveAlignmentAsNexusCodon = new JMenuItem("Save as codonpos Nexus (codonpos as charsets - excluded removed)");
        mntmSaveAlignmentAsNexusCodon.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.NEXUS_CODONPOS_CHARSET, false);
            }
        });
        mnFile.add(mntmSaveAlignmentAsNexusCodon);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsNexusCodon);
        this.nucleotideFunctions.add(mntmSaveAlignmentAsNexusCodon);
        JMenuItem mntmSaveAlignmentAsPhylipRelaxedPadded = new JMenuItem("Save as Phylip (full names & padded)");
        mntmSaveAlignmentAsPhylipRelaxedPadded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.PHYLIP_RELAXED_PADDED_AKA_LONG_NAME_SEQUENTIAL, false);
            }
        });
        mnFile.add(mntmSaveAlignmentAsPhylipRelaxedPadded);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsPhylipRelaxedPadded);
        JMenu menuPhylipSubmenu = new JMenu("Save as Phylip (other format versions)");
        mnFile.add(menuPhylipSubmenu);
        JMenuItem mntmSaveAlignmentAsPhylipRelaxedPaddedInterleaved = new JMenuItem("Save as Phylip (full names, padded & interleaved)");
        mntmSaveAlignmentAsPhylipRelaxedPaddedInterleaved.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.PHYLIP_RELAXED_PADDED_INTERLEAVED_AKA_LONG_NAME_INTERLEAVED, false);
            }
        });
        menuPhylipSubmenu.add(mntmSaveAlignmentAsPhylipRelaxedPaddedInterleaved);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsPhylipRelaxedPaddedInterleaved);
        JMenuItem mntmSaveAlignmentAsPhylip = new JMenuItem("Save as Phylip (full names)");
        mntmSaveAlignmentAsPhylip.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.PHYLIP_RELAXED, false);
            }
        });
        menuPhylipSubmenu.add(mntmSaveAlignmentAsPhylip);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsPhylip);
        JMenuItem mntmSaveAlignmentAsPhylipStrictSequential = new JMenuItem("Save as Phylip (strict 10 char names)");
        mntmSaveAlignmentAsPhylipStrictSequential.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.PHYLIP_STRICT_SEQUENTIAL_AKA_SHORT_NAME_SEQUENTIAL, false);
            }
        });
        menuPhylipSubmenu.add(mntmSaveAlignmentAsPhylipStrictSequential);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsPhylipStrictSequential);
        JMenuItem mntmSaveAlignmentAsClustal = new JMenuItem("Save as Clustal (aln)");
        mntmSaveAlignmentAsClustal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.CLUSTAL, false);
            }
        });
        mnFile.add(mntmSaveAlignmentAsClustal);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsClustal);
        JMenuItem mntmSaveAlignmentAsMSF = new JMenuItem("Save as MSF/GCG");
        mntmSaveAlignmentAsMSF.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.MSF, false);
            }
        });
        mnFile.add(mntmSaveAlignmentAsMSF);
        this.loadedAlignmentFunctions.add(mntmSaveAlignmentAsMSF);
        mnFile.add(new JSeparator());
        JMenuItem mntmSaveSelAsFasta = new JMenuItem("Save selection as Fasta");
        mntmSaveSelAsFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveSelectionAsFastaFileViaChooser();
            }
        });
        mnFile.add(mntmSaveSelAsFasta);
        this.hasSelectionFunctions.add(mntmSaveSelAsFasta);
        mnFile.add(new JSeparator());
        JMenuItem mntmSaveTranslatedAlignmentAsFasta = new JMenuItem("Save Translated alignment (Amino Acid) as Fasta");
        mntmSaveTranslatedAlignmentAsFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.FASTA_TRANSLATED_AMINO_ACID, false);
            }
        });
        mnFile.add(mntmSaveTranslatedAlignmentAsFasta);
        this.loadedAlignmentFunctions.add(mntmSaveTranslatedAlignmentAsFasta);
        this.nucleotideFunctions.add(mntmSaveTranslatedAlignmentAsFasta);
        mnFile.add(new JSeparator());
        JMenuItem mntmSaveFastaIndex = new JMenuItem("Save fasta index file (.fai)");
        mntmSaveFastaIndex.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveFastaIndex();
            }
        });
        mnFile.add(mntmSaveFastaIndex);
        this.loadedAlignmentFunctions.add(mntmSaveFastaIndex);
        mnFile.add(new JSeparator());
        JMenuItem mntmExportAlignmentAsImage = new JMenuItem("Export alignment as image");
        mntmExportAlignmentAsImage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.saveAlignmentAsFileViaChooser(FileFormat.IMAGE_PNG, true);
            }
        });
        mnFile.add(mntmExportAlignmentAsImage);
        this.loadedAlignmentFunctions.add(mntmExportAlignmentAsImage);
        mnFile.add(new JSeparator());
        JMenuItem mntmExportRaxMLFile = new JMenuItem("Export RaxML partition file");
        mntmExportRaxMLFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.exportRaxMLFile();
            }
        });
        mnFile.add(mntmExportRaxMLFile);
        this.loadedAlignmentFunctions.add(mntmExportRaxMLFile);
        mnFile.add(new JSeparator());
        JMenuItem mntmPrint = new JMenuItem("Print");
        mntmPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.printAlignment();
            }
        });
        mnFile.add(mntmPrint);
        mntmPrint.setAccelerator(OSNativeUtils.getPrintAccelerator());
        this.loadedAlignmentFunctions.add(mntmPrint);
        mnFile.add(new JSeparator());
        JMenuItem mntmLogFile = new JMenuItem("Show message log");
        mntmLogFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.showMessageLog();
            }
        });
        mnFile.add(mntmLogFile);
        this.alwaysAvailableFunctions.add(mntmLogFile);
        mnFile.add(new JSeparator());
        JMenuItem mntmShowStats = new JMenuItem("Show statistics");
        mntmShowStats.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.createStats();
            }
        });
        mnFile.add(mntmShowStats);
        this.alwaysAvailableFunctions.add(mntmShowStats);
        if (OSNativeUtils.isAnythingButMac()) {
            JMenuItem mntmExit = new JMenuItem("Exit");
            mntmExit.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliView.quitProgram();
                }
            });
            mntmExit.setIcon(AppIcons.getQuitIcon());
            mnFile.add(mntmExit);
            this.alwaysAvailableFunctions.add(mntmExit);
        }
        JMenu mnEdit = new JMenu("Edit");
        mnEdit.setMnemonic(69);
        this.add(mnEdit);
        this.undoButton = new JMenuItem("Undo");
        this.undoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.getUndoControler().undo();
            }
        });
        this.undoButton.setAccelerator(OSNativeUtils.getUndoKeyAccelerator());
        this.undoButton.setIcon(AppIcons.getUndoIcon());
        mnEdit.add(this.undoButton);
        this.undoFunctions.add(this.undoButton);
        this.redoButton = new JMenuItem("Redo");
        this.redoButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.getUndoControler().redo();
            }
        });
        this.redoButton.setAccelerator(OSNativeUtils.getRedoKeyAccelerator());
        this.redoButton.setIcon(AppIcons.getRedoIcon());
        mnEdit.add(this.redoButton);
        this.undoFunctions.add(this.redoButton);
        mnEdit.add(new JSeparator());
        JMenuItem mntmCopySelectionAsFasta = new JMenuItem("Copy selection as fasta");
        mntmCopySelectionAsFasta.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.copySelectionAsFasta();
            }
        });
        mntmCopySelectionAsFasta.setAccelerator(OSNativeUtils.getCopySelectionAsFastaKeyAccelerator());
        this.copyAsFastaButtonModel = mntmCopySelectionAsFasta.getModel();
        mnEdit.add(mntmCopySelectionAsFasta);
        this.hasSelectionFunctions.add(mntmCopySelectionAsFasta);
        JMenuItem mntmCopySelectionAsNucleotides = new JMenuItem("Copy selection as characters");
        mntmCopySelectionAsNucleotides.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.copySelectionAsNucleotides();
            }
        });
        mntmCopySelectionAsNucleotides.setAccelerator(OSNativeUtils.getCopyKeyAccelerator());
        this.copyAsCharatersButtonModel = mntmCopySelectionAsNucleotides.getModel();
        mnEdit.add(mntmCopySelectionAsNucleotides);
        this.hasSelectionFunctions.add(mntmCopySelectionAsNucleotides);
        JMenuItem mntmCopyName = new JMenuItem("Copy name(s) only");
        mntmCopyName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.copyNames();
            }
        });
        this.copyNameButtonModel = mntmCopyName.getModel();
        mnEdit.add(mntmCopyName);
        this.hasSelectionFunctions.add(mntmCopyName);
        JMenuItem mntmPasteClipboard = new JMenuItem("Paste (fasta-sequences)");
        mntmPasteClipboard.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.pasteFasta();
            }
        });
        mntmPasteClipboard.setAccelerator(OSNativeUtils.getPasteKeyAccelerator());
        this.pasteAsFastaButtonModel = mntmPasteClipboard.getModel();
        mnEdit.add(mntmPasteClipboard);
        this.editFunctions.add(mntmPasteClipboard);
        this.alwaysAvailableFunctions.add(mntmPasteClipboard);
        mnEdit.add(new JSeparator());
        JMenuItem mntmRename = new JMenuItem("Rename sequence");
        mntmRename.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.renameFirstSelected();
            }
        });
        mntmRename.setAccelerator(OSNativeUtils.getRenameKeyAccelerator());
        this.renameButtonModel = mntmRename.getModel();
        mnEdit.add(mntmRename);
        this.editFunctions.add(mntmRename);
        this.hasSelectionFunctions.add(mntmRename);
        mnEdit.add(new JSeparator());
        JMenuItem mntmAddFromFile = new JMenuItem("Add sequences from file");
        mntmAddFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.addSequencesFromFile(0);
            }
        });
        mnEdit.add(mntmAddFromFile);
        this.editFunctions.add(mntmAddFromFile);
        JMenuItem mntmAddNewSeq = new JMenuItem("Add new empty sequence");
        mntmAddNewSeq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.addNewSequence();
            }
        });
        this.addEmptySeqButtonModel = mntmAddNewSeq.getModel();
        mnEdit.add(mntmAddNewSeq);
        this.editFunctions.add(mntmAddNewSeq);
        mnEdit.add(new JSeparator());
        JCheckBoxMenuItem mntmEditMode = new JCheckBoxMenuItem("Edit mode");
        mntmEditMode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem cbxItem = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.setEditMode(cbxItem.isSelected());
            }
        });
        this.editModeButtonModel = mntmEditMode.getModel();
        mnEdit.add(mntmEditMode);
        this.editFunctions.add(mntmEditMode);
        this.loadedAlignmentFunctions.add(mntmEditMode);
        JMenuItem mntmClearSelectedItem = new JMenuItem("Clear selected bases");
        mntmClearSelectedItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.clearSelectedBases();
            }
        });
        mntmClearSelectedItem.setIcon(AppIcons.getClearIcon());
        mntmClearSelectedItem.setAccelerator(OSNativeUtils.getClearKeyAccelerator());
        mnEdit.add(mntmClearSelectedItem);
        this.editFunctions.add(mntmClearSelectedItem);
        this.hasSelectionFunctions.add(mntmClearSelectedItem);
        JMenuItem mntmDeleteSelectedItem = new JMenuItem("Delete selected");
        mntmDeleteSelectedItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteSelected();
            }
        });
        mntmDeleteSelectedItem.setAccelerator(OSNativeUtils.getDeleteKeyAccelerator());
        this.deleteSequencesButtonModel = mntmDeleteSelectedItem.getModel();
        mnEdit.add(mntmDeleteSelectedItem);
        this.reorderAndDeleteFunctions.add(mntmDeleteSelectedItem);
        JMenuItem mntmRemoveVerticalGaps = new JMenuItem("Delete gap-only columns");
        mntmRemoveVerticalGaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteVerticalGaps();
            }
        });
        mnEdit.add(mntmRemoveVerticalGaps);
        this.editFunctions.add(mntmRemoveVerticalGaps);
        this.loadedAlignmentFunctions.add(mntmRemoveVerticalGaps);
        JMenuItem mntmRemoveAllGaps = new JMenuItem("Delete all gaps in all sequences");
        mntmRemoveAllGaps.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteAllGaps();
            }
        });
        mnEdit.add(mntmRemoveAllGaps);
        this.editFunctions.add(mntmRemoveAllGaps);
        this.loadedAlignmentFunctions.add(mntmRemoveAllGaps);
        JMenuItem mntmTrim = new JMenuItem("Trim sequences");
        mntmTrim.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.trimSequences();
            }
        });
        mnEdit.add(mntmTrim);
        this.editFunctions.add(mntmTrim);
        this.loadedAlignmentFunctions.add(mntmTrim);
        JMenuItem mntmDeleteExcluded = new JMenuItem("Delete excluded bases");
        mntmDeleteExcluded.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteExludedBases();
            }
        });
        mnEdit.add(mntmDeleteExcluded);
        this.editFunctions.add(mntmDeleteExcluded);
        this.loadedAlignmentFunctions.add(mntmDeleteExcluded);
        JMenuItem mntmDeleteEmpty = new JMenuItem("Delete empty sequences");
        mntmDeleteEmpty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteEmptySequences();
            }
        });
        mnEdit.add(mntmDeleteEmpty);
        this.editFunctions.add(mntmDeleteEmpty);
        this.loadedAlignmentFunctions.add(mntmDeleteEmpty);
        mnEdit.add(new JSeparator());
        JMenuItem mntmTermGapToMissing = new JMenuItem("Replace terminal GAPs into missing char (?)");
        mntmTermGapToMissing.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.terminalGAPtoMissing();
            }
        });
        mnEdit.add(mntmTermGapToMissing);
        this.editFunctions.add(mntmTermGapToMissing);
        this.loadedAlignmentFunctions.add(mntmTermGapToMissing);
        JMenuItem mntmMissingToGap = new JMenuItem("Replace missing char (?) into GAP (-)");
        mntmMissingToGap.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.missingToGAP();
            }
        });
        mnEdit.add(mntmMissingToGap);
        this.editFunctions.add(mntmMissingToGap);
        this.loadedAlignmentFunctions.add(mntmMissingToGap);
        mnEdit.add(new JSeparator());
        JMenuItem mntmFind = new JMenuItem("Find");
        mntmFind.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmFind.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AliViewJMenuBar.this.aliViewWindow.find();
            }
        });
        mnEdit.add(mntmFind);
        this.loadedAlignmentFunctions.add(mntmFind);
        JMenuItem mntmFindDupes = new JMenuItem("Find and select duplicate sequences");
        mntmFindDupes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AliViewJMenuBar.this.aliViewWindow.selectDuplicates();
            }
        });
        mnEdit.add(mntmFindDupes);
        this.loadedAlignmentFunctions.add(mntmFindDupes);
        JMenuItem mntmFindClipboardNames = new JMenuItem("Find sequence names from clipboard");
        mntmFindClipboardNames.setAccelerator(KeyStroke.getKeyStroke(77, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        mntmFindClipboardNames.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AliViewJMenuBar.this.aliViewWindow.findNamesFromClipboard();
            }
        });
        mnEdit.add(mntmFindClipboardNames);
        this.loadedAlignmentFunctions.add(mntmFindClipboardNames);
        mnEdit.add(new JSeparator());
        JMenuItem mntmMerger = new JMenuItem("Merge 2 selected sequences");
        mntmMerger.setAccelerator(KeyStroke.getKeyStroke(77, 3));
        mntmMerger.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.merge2SelectedSequences();
            }
        });
        mnEdit.add(mntmMerger);
        this.editFunctions.add(mntmMerger);
        this.loadedAlignmentFunctions.add(mntmMerger);
        mnEdit.add(new JSeparator());
        JMenuItem mntmRevCompSequences = new JMenuItem("Reverse Complement Selected Sequences");
        mntmRevCompSequences.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                logger.info("action perf mntmRevCompSequences");
                AliViewJMenuBar.this.aliViewWindow.reverseComplementSelectedSequences();
            }
        });
        mnEdit.add(mntmRevCompSequences);
        this.editFunctions.add(mntmRevCompSequences);
        this.loadedAlignmentFunctions.add(mntmRevCompSequences);
        JMenuItem mntmRevCompAlignment = new JMenuItem("Reverse Complement Alignment");
        mntmRevCompAlignment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                logger.info("action perf");
                AliViewJMenuBar.this.aliViewWindow.reverseComplementAlignment();
            }
        });
        mnEdit.add(mntmRevCompAlignment);
        this.editFunctions.add(mntmRevCompAlignment);
        this.loadedAlignmentFunctions.add(mntmRevCompAlignment);
        JMenuItem mntmCompAlignment = new JMenuItem("Complement Alignment");
        mntmCompAlignment.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                logger.info("action perf");
                AliViewJMenuBar.this.aliViewWindow.complementAlignment();
            }
        });
        mnEdit.add(mntmCompAlignment);
        this.editFunctions.add(mntmCompAlignment);
        this.loadedAlignmentFunctions.add(mntmCompAlignment);
        JMenuItem mntmRevComp = new JMenuItem("Reverse Complement Clipboard");
        mntmRevComp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                logger.info("action perf");
                AliViewJMenuBar.this.aliViewWindow.reverseComplementClipboard();
            }
        });
        mnEdit.add(mntmRevComp);
        this.alwaysAvailableFunctions.add(mntmRevComp);
        mnEdit.add(new JSeparator());
        JMenuItem mntmEditCharsets = new JMenuItem("Edit charsets");
        mntmEditCharsets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                AliViewJMenuBar.this.aliViewWindow.editCharsets();
            }
        });
        mnEdit.add(mntmEditCharsets);
        this.loadedAlignmentFunctions.add(mntmEditCharsets);
        mnEdit.add(new JSeparator());
        JMenu mnAlignmentType = new JMenu("Set Alignment Sequence Type");
        ButtonGroup alignmentSeqTypeBG = new ButtonGroup();
        JCheckBoxMenuItem sequenceTypeNucSubmenu = new JCheckBoxMenuItem("Nucleoide");
        sequenceTypeNucSubmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.changeAlignmentType(SequenceUtils.TYPE_NUCLEIC_ACID);
            }
        });
        alignmentSeqTypeBG.add(sequenceTypeNucSubmenu);
        sequenceTypeNucSubmenu.setSelected(this.aliViewWindow.getAlignment().isNucleotideAlignment());
        mnAlignmentType.add(sequenceTypeNucSubmenu);
        JCheckBoxMenuItem sequenceTypeAASubmenu = new JCheckBoxMenuItem("Amino Acid");
        sequenceTypeAASubmenu.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.changeAlignmentType(SequenceUtils.TYPE_AMINO_ACID);
            }
        });
        alignmentSeqTypeBG.add(sequenceTypeAASubmenu);
        sequenceTypeAASubmenu.setSelected(this.aliViewWindow.getAlignment().isAAAlignment());
        mnAlignmentType.add(sequenceTypeAASubmenu);
        mnEdit.add(mnAlignmentType);
        this.loadedAlignmentFunctions.add(mnAlignmentType);
        mnEdit.add(new JSeparator());
        if (OSNativeUtils.isAnythingButMac()) {
            JMenuItem mntmPreferences = new JMenuItem("Preferences");
            mntmPreferences.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.openPreferencesGeneral();
                }
            });
            mnEdit.add(mntmPreferences);
        }
        JMenu mnSelection = new JMenu("Selection");
        mnSelection.setMnemonic(83);
        this.add(mnSelection);
        JMenuItem mntmSelectAll = new JMenuItem("Select all");
        mntmSelectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.selectAll();
            }
        });
        mntmSelectAll.setAccelerator(OSNativeUtils.getSelectAllKeyAccelerator());
        mnSelection.add(mntmSelectAll);
        this.loadedAlignmentFunctions.add(mntmSelectAll);
        JMenuItem mntmClearSelection = new JMenuItem("De-select");
        mntmClearSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.clearSelection();
            }
        });
        mnSelection.add(mntmClearSelection);
        this.hasSelectionFunctions.add(mntmClearSelection);
        JMenuItem mntmExpandSelectionRight = new JMenuItem("Expand selection Right");
        mntmExpandSelectionRight.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.expandSelectionRight();
            }
        });
        mntmExpandSelectionRight.setAccelerator(OSNativeUtils.getSelectionExpandRightKeyAccelerator());
        mnSelection.add(mntmExpandSelectionRight);
        this.hasSelectionFunctions.add(mntmExpandSelectionRight);
        JMenuItem mntmExpandSelectionLeft = new JMenuItem("Expand selection Left");
        mntmExpandSelectionLeft.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.expandSelectionLeft();
            }
        });
        mntmExpandSelectionLeft.setAccelerator(OSNativeUtils.getSelectionExpandLeftKeyAccelerator());
        mnSelection.add(mntmExpandSelectionLeft);
        this.hasSelectionFunctions.add(mntmExpandSelectionLeft);
        JMenuItem mntmExpandSelectionDown = new JMenuItem("Expand selection Down");
        mntmExpandSelectionDown.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.expandSelectionDown();
            }
        });
        mntmExpandSelectionDown.setAccelerator(OSNativeUtils.getSelectionExpandDownKeyAccelerator());
        mnSelection.add(mntmExpandSelectionDown);
        this.hasSelectionFunctions.add(mntmExpandSelectionDown);
        JMenuItem mntmExpandSelectionTop = new JMenuItem("Expand selection Up");
        mntmExpandSelectionTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.expandSelectionTop();
            }
        });
        mntmExpandSelectionTop.setAccelerator(OSNativeUtils.getSelectionExpandTopKeyAccelerator());
        mnSelection.add(mntmExpandSelectionTop);
        this.hasSelectionFunctions.add(mntmExpandSelectionTop);
        mnSelection.add(new JSeparator());
        AbstractAction meveSelUpAction = new AbstractAction("Move selected sequences up"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getMoveSelectionUpKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.moveSelectedUp();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getMoveSelectionUpKeyAccelerator(), "meveSelUpAction");
        aliViewWin.getRootPane().getActionMap().put("meveSelUpAction", meveSelUpAction);
        JMenuItem mntmMoveSelectionUp = new JMenuItem(meveSelUpAction);
        mnSelection.add(mntmMoveSelectionUp);
        mntmMoveSelectionUp.setIcon(AppIcons.getGoUpIcon());
        this.hasSelectionFunctions.add(mntmMoveSelectionUp);
        this.reorderAndDeleteFunctions.add(mntmMoveSelectionUp);
        AbstractAction moveSelDownAction = new AbstractAction("Move selected sequences down"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getMoveSelectionDownKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.moveSelectedDown();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getMoveSelectionDownKeyAccelerator(), "moveSelDownAction");
        aliViewWin.getRootPane().getActionMap().put("moveSelDownAction", moveSelDownAction);
        JMenuItem mntmMoveSelectionDown = new JMenuItem(moveSelDownAction);
        mntmMoveSelectionDown.setIcon(AppIcons.getGoDownIcon());
        mnSelection.add(mntmMoveSelectionDown);
        this.hasSelectionFunctions.add(mntmMoveSelectionDown);
        this.reorderAndDeleteFunctions.add(mntmMoveSelectionDown);
        JMenuItem mntmMoveSelectionToTop = new JMenuItem("Move selected sequences to top");
        mntmMoveSelectionToTop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.moveSelectedToTop();
            }
        });
        mntmMoveSelectionToTop.setAccelerator(KeyStroke.getKeyStroke(38, 8));
        mntmMoveSelectionToTop.setIcon(AppIcons.getGoTopIcon());
        mnSelection.add(mntmMoveSelectionToTop);
        this.hasSelectionFunctions.add(mntmMoveSelectionToTop);
        this.reorderAndDeleteFunctions.add(mntmMoveSelectionToTop);
        JMenuItem mntmMoveSelectionToBottom = new JMenuItem("Move selected sequences to bottom");
        mntmMoveSelectionToBottom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.moveSelectedToBottom();
            }
        });
        mntmMoveSelectionToBottom.setAccelerator(KeyStroke.getKeyStroke(40, 8));
        mntmMoveSelectionToBottom.setIcon(AppIcons.getGoBottomIcon());
        mnSelection.add(mntmMoveSelectionToBottom);
        this.hasSelectionFunctions.add(mntmMoveSelectionToBottom);
        this.reorderAndDeleteFunctions.add(mntmMoveSelectionToBottom);
        mnSelection.add(new JSeparator());
        JMenuItem mntmAddExcludes = new JMenuItem("Add or Remove selection to Excludes/Exset");
        mntmAddExcludes.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.addOrRemoveSelectionToExcludes();
            }
        });
        mntmAddExcludes.setAccelerator(OSNativeUtils.getAddOrRemoveExcludesKeyAccelerator());
        mnSelection.add(mntmAddExcludes);
        this.hasSelectionFunctions.add(mntmAddExcludes);
        mnSelection.add(new JSeparator());
        this.mnSelectCharset = new JMenu("Select Charset");
        mnSelection.add(this.mnSelectCharset);
        this.mnSelectCharset.setEnabled(false);
        mnSelection.add(new JSeparator());
        JMenuItem mntmSetSelectionAsCoding0 = new JMenuItem("Set selection as coding (selection starting with codon position=1)");
        mntmSetSelectionAsCoding0.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.setSelectionAsCoding(1);
            }
        });
        mnSelection.add(mntmSetSelectionAsCoding0);
        this.coding0ButtonModel = mntmSetSelectionAsCoding0.getModel();
        this.hasSelectionFunctions.add(mntmSetSelectionAsCoding0);
        this.nucleotideFunctions.add(mntmSetSelectionAsCoding0);
        JMenuItem mntmSetSelectionAsCoding1 = new JMenuItem("Set selection as coding (selection starting with codon position=2)");
        mntmSetSelectionAsCoding1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.setSelectionAsCoding(2);
            }
        });
        this.coding1ButtonModel = mntmSetSelectionAsCoding1.getModel();
        mnSelection.add(mntmSetSelectionAsCoding1);
        this.hasSelectionFunctions.add(mntmSetSelectionAsCoding1);
        this.nucleotideFunctions.add(mntmSetSelectionAsCoding1);
        JMenuItem mntmSetSelectionAsCoding2 = new JMenuItem("Set selection as coding (selection starting with codon position=3)");
        mntmSetSelectionAsCoding2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.setSelectionAsCoding(3);
            }
        });
        this.coding2ButtonModel = mntmSetSelectionAsCoding2.getModel();
        mnSelection.add(mntmSetSelectionAsCoding2);
        this.hasSelectionFunctions.add(mntmSetSelectionAsCoding2);
        this.nucleotideFunctions.add(mntmSetSelectionAsCoding2);
        JMenuItem mntmSetSelectionAsNonCoding = new JMenuItem("Set selection as Non-coding");
        mntmSetSelectionAsNonCoding.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.setSelectionAsNonCoding();
            }
        });
        this.nonCodingButtonModel = mntmSetSelectionAsNonCoding.getModel();
        mnSelection.add(mntmSetSelectionAsNonCoding);
        this.hasSelectionFunctions.add(mntmSetSelectionAsNonCoding);
        this.nucleotideFunctions.add(mntmSetSelectionAsNonCoding);
        JMenu mnViewMenu = new JMenu("View");
        mnViewMenu.setMnemonic(86);
        this.add(mnViewMenu);
        AbstractAction decFontSizeAction = new AbstractAction("Decrease Font Size"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getDecreaseFontSizeKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.zoomOut();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getDecreaseFontSizeKeyAccelerator(), "decfontsize");
        aliViewWin.getRootPane().getActionMap().put("decfontsize", decFontSizeAction);
        JMenuItem mntmDecreaseFontSize = new JMenuItem(decFontSizeAction);
        mntmDecreaseFontSize.setAction(decFontSizeAction);
        this.decFontSizeButtonModel = mntmDecreaseFontSize.getModel();
        mnViewMenu.add(decFontSizeAction);
        this.loadedAlignmentFunctions.add(mntmDecreaseFontSize);
        AbstractAction incFontSizeAction = new AbstractAction("Increase Font Size"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getIncreaseFontSizeKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.zoomIn();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getIncreaseFontSizeKeyAccelerator(), "incfontsize");
        aliViewWin.getRootPane().getActionMap().put("incfontsize", incFontSizeAction);
        JMenuItem mntmIncreaseFontSize = new JMenuItem(incFontSizeAction);
        mntmIncreaseFontSize.setAction(incFontSizeAction);
        this.incFontSizeButtonModel = mntmIncreaseFontSize.getModel();
        mnViewMenu.add(incFontSizeAction);
        this.loadedAlignmentFunctions.add(mntmIncreaseFontSize);
        mnViewMenu.add(new JSeparator());
        JCheckBoxMenuItem highlightCons = new JCheckBoxMenuItem("Highlight consensus characters");
        highlightCons.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem btn = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.setHighlightConsensus(btn.isSelected());
            }
        });
        NoneSelectedButtonGroup buttonGroupOneViewAtATime = new NoneSelectedButtonGroup();
        buttonGroupOneViewAtATime.add(highlightCons);
        this.highlightConsButtonModel = highlightCons.getModel();
        mnViewMenu.add(highlightCons);
        this.loadedAlignmentFunctions.add(highlightCons);
        JCheckBoxMenuItem highlightNonCons = new JCheckBoxMenuItem("Highlight Non-consensus characters");
        highlightNonCons.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem btn = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.setHighlightNonConsensus(btn.isSelected());
            }
        });
        buttonGroupOneViewAtATime.add(highlightNonCons);
        this.highlightNonConsButtonModel = highlightNonCons.getModel();
        mnViewMenu.add(highlightNonCons);
        this.loadedAlignmentFunctions.add(highlightNonCons);
        JCheckBoxMenuItem highlightDiff = new JCheckBoxMenuItem("Highlight diff from a selected sequence");
        highlightDiff.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem btn = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.setHighlightDiff(btn.isSelected());
            }
        });
        buttonGroupOneViewAtATime.add(highlightDiff);
        this.highlightDiffButtonModel = highlightDiff.getModel();
        mnViewMenu.add(highlightDiff);
        this.loadedAlignmentFunctions.add(highlightDiff);
        mnViewMenu.add(new JSeparator());
        JMenuItem mntmSortSequencesByName = new JMenuItem("Sort sequences by name");
        mntmSortSequencesByName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.sortSequencesByName();
            }
        });
        mnViewMenu.add(mntmSortSequencesByName);
        this.reorderAndDeleteFunctions.add(mntmSortSequencesByName);
        this.loadedAlignmentFunctions.add(mntmSortSequencesByName);
        JMenuItem mntmSortSequencesByCharColumn = new JMenuItem("Sort sequences by character in selected column");
        mntmSortSequencesByCharColumn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.sortSequencesByCharColumn();
            }
        });
        mnViewMenu.add(mntmSortSequencesByCharColumn);
        this.reorderAndDeleteFunctions.add(mntmSortSequencesByCharColumn);
        this.loadedAlignmentFunctions.add(mntmSortSequencesByCharColumn);
        mnViewMenu.add(new JSeparator());
        JMenuItem mntmGoToPos = new JMenuItem("Goto sequence position");
        mntmGoToPos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.goToPos();
            }
        });
        mntmGoToPos.setAccelerator(OSNativeUtils.getGoToPosKeyAccelerator());
        mnViewMenu.add(mntmGoToPos);
        this.loadedAlignmentFunctions.add(mntmGoToPos);
        mnViewMenu.add(new JSeparator());
        JCheckBoxMenuItem mntmToggleTranslation = new JCheckBoxMenuItem("Show as translation");
        mntmToggleTranslation.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem btn = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.setShowTranslation(btn.isSelected());
            }
        });
        mntmToggleTranslation.setAccelerator(OSNativeUtils.getToggleTranslationKeyAccelerator());
        buttonGroupOneViewAtATime.add(highlightNonCons);
        this.toggleTranslationButtonModel = mntmToggleTranslation.getModel();
        mnViewMenu.add(mntmToggleTranslation);
        this.nucleotideFunctions.add(mntmToggleTranslation);
        this.loadedAlignmentFunctions.add(mntmToggleTranslation);
        this.transOnePosAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.mntmToggleTranslationOnePos();
            }
        };
        JCheckBoxMenuItem mntmToggleTranslationOnePos = new JCheckBoxMenuItem(this.transOnePosAction);
        mntmToggleTranslationOnePos.setText("Show as translation (1 pos per AminoAcid)");
        mntmToggleTranslationOnePos.setAccelerator(OSNativeUtils.getToggleTranslationOnePosKeyAccelerator());
        mnViewMenu.add(mntmToggleTranslationOnePos);
        this.nucleotideFunctions.add(mntmToggleTranslationOnePos);
        this.loadedAlignmentFunctions.add(mntmToggleTranslationOnePos);
        JCheckBoxMenuItem mntmToggleAminoAcidCode = new JCheckBoxMenuItem("Show as Amino acid code (when show translate)");
        mntmToggleAminoAcidCode.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.toggleDrawAminoAcidCode();
            }
        });
        mntmToggleAminoAcidCode.setAccelerator(OSNativeUtils.getToggleTranslateShowAACodeKeyAccelerator());
        this.showAACodeButtonMoes = mntmToggleAminoAcidCode.getModel();
        mnViewMenu.add(mntmToggleAminoAcidCode);
        this.nucleotideFunctions.add(mntmToggleAminoAcidCode);
        this.loadedAlignmentFunctions.add(mntmToggleAminoAcidCode);
        JCheckBoxMenuItem mntmToggleTranslateShowBoth = new JCheckBoxMenuItem("Show both aminoacid and nucleotides when translating");
        mntmToggleTranslateShowBoth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.toggleTranslationShowBoth();
            }
        });
        mntmToggleTranslateShowBoth.setAccelerator(OSNativeUtils.getToggleTranslateShowBothKeyAccelerator());
        mnViewMenu.add(mntmToggleTranslateShowBoth);
        this.nucleotideFunctions.add(mntmToggleTranslateShowBoth);
        this.loadedAlignmentFunctions.add(mntmToggleTranslateShowBoth);
        JCheckBoxMenuItem mntmToggleIgnoreGapInTranslation = new JCheckBoxMenuItem("Ignore gaps when translating");
        mntmToggleIgnoreGapInTranslation.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.toggleIgnoreGapInTranslation();
            }
        });
        mntmToggleIgnoreGapInTranslation.setAccelerator(OSNativeUtils.getToggleIgnoreGapInTranslationKeyAccelerator());
        mnViewMenu.add(mntmToggleIgnoreGapInTranslation);
        this.nucleotideFunctions.add(mntmToggleIgnoreGapInTranslation);
        this.loadedAlignmentFunctions.add(mntmToggleIgnoreGapInTranslation);
        JMenuItem mntmToggleDrawCodonPos = new JMenuItem("Show codonpositions on ruler");
        mntmToggleDrawCodonPos.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.toggleDrawCodonpos();
            }
        });
        mnViewMenu.add(mntmToggleDrawCodonPos);
        this.drawCoonPosOnRulerButtonModel = mntmToggleDrawCodonPos.getModel();
        this.nucleotideFunctions.add(mntmToggleDrawCodonPos);
        this.loadedAlignmentFunctions.add(mntmToggleDrawCodonPos);
        this.mnGeneticCodeCode = new JMenu("Select genetic code for translation");
        for (final GeneticCode aCode : GeneticCode.allCodesArray) {
            JMenuItem genCodeSubM = new JMenuItem("" + aCode.transTable + ". " + aCode.name);
            genCodeSubM.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.setGeneticCode(aCode);
                }
            });
            this.mnGeneticCodeCode.add(genCodeSubM);
        }
        mnViewMenu.add(this.mnGeneticCodeCode);
        this.alwaysAvailableFunctions.add(this.mnGeneticCodeCode);
        JMenuItem mntmIncreaseReadingFrame = new JMenuItem("Reading frame +1");
        mntmIncreaseReadingFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.incReadingFrame();
            }
        });
        mntmIncreaseReadingFrame.setAccelerator(OSNativeUtils.incReadingFrameKeyAccelerator());
        mnViewMenu.add(mntmIncreaseReadingFrame);
        this.nucleotideFunctions.add(mntmIncreaseReadingFrame);
        this.loadedAlignmentFunctions.add(mntmIncreaseReadingFrame);
        JMenuItem mntmDecreaseReadingFrame = new JMenuItem("Reading frame -1");
        mntmDecreaseReadingFrame.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.decReadingFrame();
            }
        });
        mntmDecreaseReadingFrame.setAccelerator(OSNativeUtils.decReadingFrameKeyAccelerator());
        mnViewMenu.add(mntmDecreaseReadingFrame);
        this.nucleotideFunctions.add(mntmDecreaseReadingFrame);
        this.loadedAlignmentFunctions.add(mntmDecreaseReadingFrame);
        JMenuItem mntmCountStopCodons = new JMenuItem("Count stop codons");
        mntmCountStopCodons.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.countStopCodons();
            }
        });
        this.countCodonButtonModel = mntmCountStopCodons.getModel();
        mntmCountStopCodons.setAccelerator(OSNativeUtils.countStopCodonsKeyAccelerator());
        mnViewMenu.add(mntmCountStopCodons);
        this.loadedAlignmentFunctions.add(mntmCountStopCodons);
        mnViewMenu.add(new JSeparator());
        JCheckBoxMenuItem mntmShowCharsetsRuler = new JCheckBoxMenuItem("Show charsets ruler (if charsets are defined)");
        boolean isShowCharsetRuler = Settings.getShowCharsetRuler().getBooleanValue();
        if (isShowCharsetRuler) {
            mntmShowCharsetsRuler.setSelected(true);
        }
        mntmShowCharsetsRuler.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem btn = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.showCharsetsRuler(btn.isSelected());
            }
        });
        mnViewMenu.add(mntmShowCharsetsRuler);
        this.alwaysAvailableFunctions.add(mntmShowCharsetsRuler);
        mnViewMenu.add(new JSeparator());
        JCheckBoxMenuItem mntmFontCase = new JCheckBoxMenuItem("Always display as Upper case characters");
        mntmFontCase.setMnemonic(85);
        int fontCase = Settings.getFontCase().getIntValue();
        if (fontCase == 1) {
            mntmFontCase.setSelected(true);
        }
        mntmFontCase.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                JCheckBoxMenuItem btn = (JCheckBoxMenuItem)e.getSource();
                AliViewJMenuBar.this.aliViewWindow.setFontCaseUpper(btn.isSelected());
            }
        });
        mnViewMenu.add(mntmFontCase);
        this.alwaysAvailableFunctions.add(mntmFontCase);
        JMenu mnColorScheme = new JMenu("Colors");
        JMenu mnNucleotideSub = new JMenu("Nucleotide");
        mnColorScheme.add(mnNucleotideSub);
        ButtonGroup colorSchemeGroup = new ButtonGroup();
        ColorScheme settingsColorScheme = Settings.getColorSchemeNucleotide();
        for (final ColorScheme aScheme : ColorSchemeFactory.getNucleotideColorSchemes()) {
            JCheckBoxMenuItem colorSubmenu = new JCheckBoxMenuItem(aScheme.getName());
            colorSubmenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.setColorSchemeNucleotide(aScheme);
                }
            });
            colorSchemeGroup.add(colorSubmenu);
            if (settingsColorScheme == aScheme) {
                colorSubmenu.setSelected(true);
            }
            mnNucleotideSub.add(colorSubmenu);
        }
        JMenu mnAASub = new JMenu("Amino Acid");
        mnColorScheme.add(mnAASub);
        ButtonGroup colorSchemeGroupAA = new ButtonGroup();
        ColorScheme settingsColorSchemeAA = Settings.getColorSchemeAminoAcid();
        for (final ColorScheme aScheme : ColorSchemeFactory.getAAColorSchemes()) {
            JCheckBoxMenuItem colorSubmenu = new JCheckBoxMenuItem(aScheme.getName());
            colorSubmenu.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.setColorSchemeAminoAcid(aScheme);
                }
            });
            colorSchemeGroupAA.add(colorSubmenu);
            if (settingsColorSchemeAA == aScheme) {
                colorSubmenu.setSelected(true);
            }
            mnAASub.add(colorSubmenu);
        }
        mnColorScheme.setIcon(AppIcons.getColorsIcon());
        mnViewMenu.add(mnColorScheme);
        this.alwaysAvailableFunctions.add(mnColorScheme);
        JMenu mnAlign = new JMenu("Align");
        mnAlign.setMnemonic(65);
        this.add(mnAlign);
        JMenuItem mntmAlignInCurrent = new JMenuItem("Add and align sequences from clipboard (fasta)");
        mntmAlignInCurrent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.addAndAlignSeqFromClipboard();
            }
        });
        mnAlign.add(mntmAlignInCurrent);
        this.editFunctions.add(mntmAlignInCurrent);
        this.loadedAlignmentFunctions.add(mntmAlignInCurrent);
        JMenuItem mntmAlignInFromFile = new JMenuItem("Add and align sequences from file (fasta)");
        mntmAlignInFromFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.addAndAlignSeqFromFile();
            }
        });
        mnAlign.add(mntmAlignInFromFile);
        this.editFunctions.add(mntmAlignInFromFile);
        this.loadedAlignmentFunctions.add(mntmAlignInFromFile);
        JMenuItem mntmReAlignSelection = new JMenuItem("Realign selected block");
        mntmReAlignSelection.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.reAlignSelectionInSeparateThread();
            }
        });
        mnAlign.add(mntmReAlignSelection);
        this.realignSelectedBlockButtonModel = mntmReAlignSelection.getModel();
        this.editFunctions.add(mntmReAlignSelection);
        this.hasSelectionFunctions.add(mntmReAlignSelection);
        JMenuItem mntmReAlignSelectedSequence = new JMenuItem("Realign selected sequence(s)");
        mntmReAlignSelectedSequence.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.reAlignSelectedSequences();
            }
        });
        mnAlign.add(mntmReAlignSelectedSequence);
        this.realignSelectedSequencesButtonModel = mntmReAlignSelectedSequence.getModel();
        this.editFunctions.add(mntmReAlignSelectedSequence);
        this.loadedAlignmentFunctions.add(mntmReAlignSelectedSequence);
        JMenuItem mntmAlign = new JMenuItem("Realign everything");
        mntmAlign.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.reAlignEverythingWithDefaultProgram();
            }
        });
        mnAlign.add(mntmAlign);
        this.editFunctions.add(mntmAlign);
        this.loadedAlignmentFunctions.add(mntmAlign);
        JMenuItem mntmAlignAsAA = new JMenuItem("Realign everything as Translated Amino Acids");
        mntmAlignAsAA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.reAlignEverythingAsTranslatedAA();
            }
        });
        mnAlign.add(mntmAlignAsAA);
        this.editFunctions.add(mntmAlignAsAA);
        this.loadedAlignmentFunctions.add(mntmAlignAsAA);
        this.nucleotideFunctions.add(mntmAlignAsAA);
        mnAlign.add(new JSeparator());
        JMenu mnuAlignerSettings = new JMenu("Change default Aligner program");
        mnAlign.add(mnuAlignerSettings);
        this.alwaysAvailableFunctions.add(mnuAlignerSettings);
        JMenuItem mntmALLAlignerSettings = new JMenuItem("for realigning all (or selected blocks)");
        mntmALLAlignerSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.editAlignerALLSettings();
            }
        });
        mnuAlignerSettings.add(mntmALLAlignerSettings);
        JMenuItem mntmADDAlignerSettings = new JMenuItem("when pasting new sequences (profile-alignment)");
        mntmADDAlignerSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.editAlignerADDSettings();
            }
        });
        mnuAlignerSettings.add(mntmADDAlignerSettings);
        mnAlign.add(new JSeparator());
        AbstractAction moveselrightAction = new AbstractAction("Move selected positions right"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getMoveSelectedRightKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.moveSelectionRight();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getMoveSelectedRightKeyAccelerator(), "moveselright");
        aliViewWin.getRootPane().getActionMap().put("moveselright", moveselrightAction);
        JMenuItem mntmMoveSelectionRight = new JMenuItem(moveselrightAction);
        mnAlign.add(mntmMoveSelectionRight);
        mntmMoveSelectionRight.setIcon(AppIcons.getMoveRightIcon());
        this.hasSelectionFunctions.add(mntmMoveSelectionRight);
        this.editFunctions.add(mntmMoveSelectionRight);
        AbstractAction moveselleftAction = new AbstractAction("Move selected positions left"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getMoveSelectedLeftKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.moveSelectionLeft();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getMoveSelectedLeftKeyAccelerator(), "moveselleft");
        aliViewWin.getRootPane().getActionMap().put("moveselleft", moveselleftAction);
        JMenuItem mntmMoveSelectionLeft = new JMenuItem(moveselleftAction);
        mntmMoveSelectionLeft.setAction(moveselleftAction);
        mnAlign.add(mntmMoveSelectionLeft);
        mntmMoveSelectionLeft.setIcon(AppIcons.getMoveLeftIcon());
        this.editFunctions.add(mntmMoveSelectionLeft);
        this.hasSelectionFunctions.add(mntmMoveSelectionLeft);
        AbstractAction insertGapMRAction = new AbstractAction("Insert Gap move right"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getInsertGapMoveRightKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.insertGapMoveRight();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getInsertGapMoveRightKeyAccelerator(), "insertGapMRAction");
        aliViewWin.getRootPane().getActionMap().put("insertGapMRAction", insertGapMRAction);
        JMenuItem mntmInsertGapMoveRight = new JMenuItem(insertGapMRAction);
        mnAlign.add(mntmInsertGapMoveRight);
        this.editFunctions.add(mntmInsertGapMoveRight);
        this.hasSelectionFunctions.add(mntmInsertGapMoveRight);
        AbstractAction insertGapMoveLeftAction = new AbstractAction("Insert Gap move left"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getInsertGapMoveLeftKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.insertGapMoveLeft();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getInsertGapMoveLeftKeyAccelerator(), "insertGapMoveLeftAction");
        aliViewWin.getRootPane().getActionMap().put("insertGapMoveLeftAction", insertGapMoveLeftAction);
        JMenuItem mntmInsertGapMoveLeft = new JMenuItem(insertGapMoveLeftAction);
        mnAlign.add(mntmInsertGapMoveLeft);
        this.editFunctions.add(mntmInsertGapMoveLeft);
        this.hasSelectionFunctions.add(mntmInsertGapMoveLeft);
        AbstractAction deleteGapMoveLeftAction = new AbstractAction("Delete Gap at left"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getDeleteGapMoveLeftKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteGapMoveLeft();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getDeleteGapMoveLeftKeyAccelerator(), "deleteGapMoveLeftAction");
        aliViewWin.getRootPane().getActionMap().put("deleteGapMoveLeftAction", deleteGapMoveLeftAction);
        JMenuItem mntmDeleteGapMoveLeft = new JMenuItem(deleteGapMoveLeftAction);
        mnAlign.add(mntmDeleteGapMoveLeft);
        this.editFunctions.add(mntmDeleteGapMoveLeft);
        this.hasSelectionFunctions.add(mntmDeleteGapMoveLeft);
        AbstractAction deleteGapMoveRightAction = new AbstractAction("Delete Gap at right"){
            {
                this.putValue("AcceleratorKey", OSNativeUtils.getDeleteGapMoveRightKeyAccelerator());
            }

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.deleteGapMoveRight();
            }
        };
        aliViewWin.getRootPane().getInputMap(1).put(OSNativeUtils.getDeleteGapMoveRightKeyAccelerator(), "deleteGapMoveRightAction");
        aliViewWin.getRootPane().getActionMap().put("deleteGapMoveRightAction", deleteGapMoveRightAction);
        JMenuItem mntmDeleteGapMoveRight = new JMenuItem(deleteGapMoveRightAction);
        mnAlign.add(mntmDeleteGapMoveRight);
        this.editFunctions.add(mntmDeleteGapMoveRight);
        this.hasSelectionFunctions.add(mntmDeleteGapMoveRight);
        JMenu mnTools = new JMenu("Tools");
        mnTools.setMnemonic(84);
        this.add(mnTools);
        JMenu mnPrimer = new JMenu("Primer");
        mnPrimer.setMnemonic(80);
        mnTools.add(mnPrimer);
        JMenuItem mntmPrimerInCurrent = new JMenuItem("Find primer in current selection");
        mntmPrimerInCurrent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.findPrimerInCurrentSelection();
            }
        });
        mnPrimer.add(mntmPrimerInCurrent);
        this.hasSelectionFunctions.add(mntmPrimerInCurrent);
        this.nucleotideFunctions.add(mntmPrimerInCurrent);
        JMenuItem mntmFindPrimerSettings = new JMenuItem("Find primer settings");
        mntmFindPrimerSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.findPrimerSettings();
            }
        });
        mnPrimer.add(mntmFindPrimerSettings);
        this.alwaysAvailableFunctions.add(mntmFindPrimerSettings);
        this.mnExternal = new JMenu("External commands");
        this.mnExternal.setMnemonic(69);
        this.add(this.mnExternal);
        this.rebuildExternalCommandsSubmenu();
        JMenu mnHelp = new JMenu("Help");
        mnHelp.setMnemonic(72);
        this.add(mnHelp);
        JMenuItem mntmHelpOpen = new JMenuItem("Help");
        mntmHelpOpen.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.openHelp();
            }
        });
        mnHelp.add(mntmHelpOpen);
        this.alwaysAvailableFunctions.add(mntmHelpOpen);
        JMenuItem mntmCheckNew = new JMenuItem("Check for new version/version history");
        mntmCheckNew.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.checkNewVersion();
            }
        });
        mnHelp.add(mntmCheckNew);
        this.alwaysAvailableFunctions.add(mntmCheckNew);
        JMenuItem mntmReportBug = new JMenuItem("Report bug/feature request");
        mntmReportBug.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.openBugReportPage();
            }
        });
        mnHelp.add(mntmReportBug);
        this.alwaysAvailableFunctions.add(mntmReportBug);
        mnHelp.add(new JSeparator());
        if (OSNativeUtils.isAnythingButMac()) {
            JMenuItem mntmAbout = new JMenuItem("About");
            mntmAbout.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.showAbout();
                }
            });
            mnHelp.add(mntmAbout);
            this.alwaysAvailableFunctions.add(mntmAbout);
        }
    }

    private void rebuildExternalCommandsSubmenu() {
        this.mnExternal.removeAll();
        ArrayList<CommandItem> cmdItems = Settings.getExternalCommands();
        for (final CommandItem anItem : cmdItems) {
            if (!anItem.isActivated() || anItem.getName() == null || anItem.getName().length() <= 0) continue;
            JMenuItem nextCommandItem = new JMenuItem(anItem.getName());
            nextCommandItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.runExternalCommand(anItem);
                }
            });
            nextCommandItem.setSelected(anItem.isActivated());
            this.alwaysAvailableFunctions.add(nextCommandItem);
            this.mnExternal.add(nextCommandItem);
        }
        this.mnExternal.add(new JSeparator());
        JMenuItem mntmEditExternal = new JMenuItem("Edit external command");
        mntmEditExternal.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AliViewJMenuBar.this.aliViewWindow.editExternalCommands();
            }
        });
        this.mnExternal.add(mntmEditExternal);
        this.alwaysAvailableFunctions.add(mntmEditExternal);
    }

    private void rebuildRecentFilesSubmenu() {
        logger.info("rebuildRecentFilesSubmenu()");
        this.mnRecentFiles.removeAll();
        for (final File nextFile : Settings.getRecentFiles()) {
            JMenuItem nextItem = new JMenuItem(nextFile.getAbsolutePath());
            nextItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliView.openAlignmentFile(nextFile);
                }
            });
            this.mnRecentFiles.add(nextItem);
        }
        this.mnRecentFiles.invalidate();
        this.mnRecentFiles.repaint();
    }

    public void rebuildSelectCharsetsSubmenu() {
        logger.info("rebuildSelectCharsetsSubmenu()" + this.aliViewWindow.getAlignment().getAlignmentMeta().getCharsets());
        this.mnSelectCharset.removeAll();
        CharSets charsets = this.aliViewWindow.getAlignment().getAlignmentMeta().getCharsets();
        for (final CharSet aCharset : charsets) {
            JMenuItem nextItem = new JMenuItem(aCharset.getName());
            nextItem.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    AliViewJMenuBar.this.aliViewWindow.selectAll(aCharset);
                }
            });
            this.mnSelectCharset.add(nextItem);
        }
        if (charsets != null && charsets.size() > 0) {
            this.mnSelectCharset.setEnabled(true);
        } else {
            this.mnSelectCharset.setEnabled(false);
        }
        this.mnSelectCharset.invalidate();
        this.mnSelectCharset.repaint();
    }

    public final void setEditFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.editFunctions, enable);
    }

    public final void setAlwaysFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.alwaysAvailableFunctions, enable);
    }

    public final void setLoadedFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.loadedAlignmentFunctions, enable);
    }

    public final void setNucleotideFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.nucleotideFunctions, enable);
    }

    public final void setAAFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.aminoAcidFunctions, enable);
    }

    public final void setHasSelectionFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.hasSelectionFunctions, enable);
    }

    public final void setReorderFunctionsEnabled(boolean enable) {
        this.setAllEnabled(this.reorderAndDeleteFunctions, enable);
    }

    public void setUndoButtonEnabled(boolean b) {
        this.undoButton.setEnabled(b);
    }

    public void setRedoButtonEnabled(boolean b) {
        this.redoButton.setEnabled(b);
    }

    private void setAllEnabled(ArrayList<AbstractButton> comps, boolean enable) {
        if (!this.menuLock) {
            for (AbstractButton comp : comps) {
                comp.setEnabled(enable);
                Component[] subComponents = comp.getComponents();
                if (subComponents == null || subComponents.length <= 0) continue;
                this.setEnabledAllJMenuButtonsRecursive(subComponents, enable);
            }
        }
    }

    public void setMenuLock(boolean lock) {
        logger.info("lock" + lock);
        if (lock) {
            this.menuLock = false;
            this.disableAllButEssentialButtons();
            this.menuLock = true;
        } else {
            this.menuLock = false;
            this.updateAllMenuEnabled();
        }
    }

    private void disableAllRegisterdMenusAndSubs() {
        boolean enable = false;
        this.setAllEnabled(this.editFunctions, enable);
        this.setAllEnabled(this.alwaysAvailableFunctions, enable);
        this.setAllEnabled(this.loadedAlignmentFunctions, enable);
        this.setAllEnabled(this.nucleotideFunctions, enable);
        this.setAllEnabled(this.aminoAcidFunctions, enable);
        this.setAllEnabled(this.hasSelectionFunctions, enable);
        this.setAllEnabled(this.undoFunctions, enable);
        this.setAllEnabled(this.reorderAndDeleteFunctions, enable);
    }

    public void updateAllMenuEnabled() {
        this.disableAllButEssentialButtons();
        if (!this.aliViewWindow.isEmpty()) {
            logger.info("alignment.isAAAlignment()" + this.aliViewWindow.getAlignment().isAAAlignment());
            logger.info("alignment.isNucleotideAlignment()" + this.aliViewWindow.getAlignment().isNucleotideAlignment());
            this.setLoadedFunctionsEnabled(true);
            this.setReorderFunctionsEnabled(true);
            this.setUndoButtonEnabled(!this.aliViewWindow.isUndoStackEmpty());
            this.setRedoButtonEnabled(!this.aliViewWindow.isRedoStackEmpty());
            if (this.aliViewWindow.getAlignment().isEditable()) {
                this.setEditFunctionsEnabled(true);
                logger.info("editFunctionstrue");
            }
            if (this.aliViewWindow.getAlignment().isNucleotideAlignment()) {
                this.setNucleotideFunctionsEnabled(true);
                this.setHasSelectionFunctionsEnabled(this.aliViewWindow.getAlignment().hasSelection());
                this.setAAFunctionsEnabled(false);
            }
            if (this.aliViewWindow.getAlignment().isAAAlignment()) {
                this.setAAFunctionsEnabled(true);
                this.setHasSelectionFunctionsEnabled(this.aliViewWindow.getAlignment().hasSelection());
                this.setNucleotideFunctionsEnabled(false);
            }
            if (!this.aliViewWindow.getAlignment().isEditable()) {
                this.setEditFunctionsEnabled(false);
            }
        }
    }

    public void disableAllButEssentialButtons() {
        this.disableAllRegisterdMenusAndSubs();
        this.setAlwaysFunctionsEnabled(true);
    }

    private void setEnabledAllJMenuButtonsRecursive(Component[] allComps, boolean isEnabled) {
        for (Component comp : allComps) {
            Component[] subcomps;
            comp.setEnabled(isEnabled);
            if (!(comp instanceof AbstractButton) || (subcomps = ((AbstractButton)comp).getComponents()) == null || subcomps.length <= 0) continue;
            this.setEnabledAllJMenuButtonsRecursive(subcomps, isEnabled);
        }
    }

    public Action getTransOnePosAction() {
        return this.transOnePosAction;
    }

    public ButtonModel getToggleTranslationButtonModel() {
        return this.toggleTranslationButtonModel;
    }

    public ButtonModel getHighlightConsButtonModel() {
        return this.highlightConsButtonModel;
    }

    public ButtonModel getHighlightDiffTraceButtonModel() {
        return this.highlightDiffButtonModel;
    }

    public ButtonModel getHighlightNonConsButtonModel() {
        return this.highlightNonConsButtonModel;
    }

    public ButtonModel getShowAACodeButtonModel() {
        return this.showAACodeButtonMoes;
    }

    public ButtonModel getIncFontSizeButtonModel() {
        return this.incFontSizeButtonModel;
    }

    public ButtonModel getDecFontSizeButtonModel() {
        return this.decFontSizeButtonModel;
    }

    public ButtonModel getCoding0ButtonModel() {
        return this.coding0ButtonModel;
    }

    public ButtonModel getCoding1ButtonModel() {
        return this.coding1ButtonModel;
    }

    public ButtonModel getCoding2ButtonModel() {
        return this.coding2ButtonModel;
    }

    public ButtonModel getCodingNoneButtonModel() {
        return this.nonCodingButtonModel;
    }

    public ButtonModel getDrawCoonPosOnRulerButtonModel() {
        return this.drawCoonPosOnRulerButtonModel;
    }

    public ButtonModel getCountCodonButtonModel() {
        return this.countCodonButtonModel;
    }

    @Override
    public void newSequences(AlignmentEvent alignmentEvent) {
        logger.info("new sequences");
        this.updateAllMenuEnabled();
    }

    @Override
    public void alignmentMetaChanged(AlignmentEvent alignmentEvent) {
    }

    @Override
    public void intervalAdded(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    @Override
    public void intervalRemoved(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    @Override
    public void contentsChanged(ListDataEvent e) {
        if (e instanceof AlignmentDataEvent) {
            this.contentsChanged((AlignmentDataEvent)e);
        }
    }

    public void contentsChanged(AlignmentDataEvent e) {
        logger.info("contents changed");
        this.updateAllMenuEnabled();
    }

    @Override
    public void selectionChanged(AlignmentSelectionEvent e) {
        if (this.aliViewWindow.getAlignment().isNucleotideAlignment()) {
            this.setHasSelectionFunctionsEnabled(this.aliViewWindow.getAlignment().hasSelection());
            this.setAAFunctionsEnabled(false);
            this.setEditFunctionsEnabled(this.aliViewWindow.getAlignment().isEditable());
        }
        if (this.aliViewWindow.getAlignment().isAAAlignment()) {
            this.setHasSelectionFunctionsEnabled(this.aliViewWindow.getAlignment().hasSelection());
            this.setNucleotideFunctionsEnabled(false);
            this.setEditFunctionsEnabled(this.aliViewWindow.getAlignment().isEditable());
        }
    }

    @Override
    public void recentFilesChanged() {
        this.rebuildRecentFilesSubmenu();
    }

    @Override
    public void alignAllCmdsChanged() {
    }

    @Override
    public void alignAddCmdsChanged() {
    }

    @Override
    public void externalCmdsChanged() {
        this.rebuildExternalCommandsSubmenu();
    }

    public ButtonModel getCopyAsFastaButtonModel() {
        return this.copyAsFastaButtonModel;
    }

    public ButtonModel getCopyAsCharactersButtonModel() {
        return this.copyAsCharatersButtonModel;
    }

    public ButtonModel getRealignSelectedBlock() {
        return this.realignSelectedBlockButtonModel;
    }

    public ButtonModel getRealignSelectedSequences() {
        return this.realignSelectedSequencesButtonModel;
    }

    public ButtonModel getPasteAsFastaButtonModel() {
        return this.pasteAsFastaButtonModel;
    }

    public void editModeChanged() {
        logger.info("aliViewWindow.isEditMode()" + this.aliViewWindow.isEditMode());
        this.editModeButtonModel.setSelected(this.aliViewWindow.isEditMode());
    }

    public ButtonModel getCopyNameButtonModel() {
        return this.copyNameButtonModel;
    }

    public ButtonModel getRenameButtonModel() {
        return this.renameButtonModel;
    }

    public ButtonModel getDeleteSequencesButtonModel() {
        return this.deleteSequencesButtonModel;
    }

    public ButtonModel getAddNewSequenceButtonModel() {
        return this.addEmptySeqButtonModel;
    }
}

