/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import aliview.AliViewWindow;
import aliview.gui.AliViewJMenuBar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;

public class AlignmentPopupMenu
extends JPopupMenu
implements MouseListener {
    private AliViewWindow aliViewWin;
    private AliViewJMenuBar aliViewMenuBar;
    private MouseEvent mouseActivationEvent;

    public AlignmentPopupMenu(final AliViewWindow aliViewWin, AliViewJMenuBar aliViewMenuBar) {
        this.aliViewWin = aliViewWin;
        this.aliViewMenuBar = aliViewMenuBar;
        JMenuItem setTraceSeq = new JMenuItem("Set this sequence as template when Highlighting difference");
        setTraceSeq.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                aliViewWin.setDifferenceTraceSequence(AlignmentPopupMenu.this.mouseActivationEvent.getPoint());
            }
        });
        this.add(setTraceSeq);
        this.add(new JSeparator());
        JMenuItem copyItem = new JMenuItem("Copy (as fasta)");
        copyItem.setModel(aliViewMenuBar.getCopyAsFastaButtonModel());
        this.add(copyItem);
        JMenuItem copyNucItem = new JMenuItem("Copy (the characters only)");
        copyNucItem.setModel(aliViewMenuBar.getCopyAsCharactersButtonModel());
        this.add(copyNucItem);
        JMenuItem copyNameItem = new JMenuItem("Copy name(s) only");
        copyNameItem.setModel(aliViewMenuBar.getCopyNameButtonModel());
        this.add(copyNameItem);
        JMenuItem pasteItem = new JMenuItem("Paste sequence(s) from clipboard");
        pasteItem.setModel(aliViewMenuBar.getPasteAsFastaButtonModel());
        this.add(pasteItem);
        JMenuItem addEmptyItem = new JMenuItem("Add new empty sequence");
        addEmptyItem.setModel(aliViewMenuBar.getAddNewSequenceButtonModel());
        this.add(addEmptyItem);
        this.add(new JSeparator());
        JMenuItem renameItem = new JMenuItem("Rename sequence");
        renameItem.setModel(aliViewMenuBar.getRenameButtonModel());
        this.add(renameItem);
        this.add(new JSeparator());
        JMenuItem deleteItem = new JMenuItem("Delete selected sequence(s)");
        deleteItem.setModel(aliViewMenuBar.getDeleteSequencesButtonModel());
        this.add(deleteItem);
        this.add(new JSeparator());
        JMenuItem alignBlock = new JMenuItem("Realign selected block");
        alignBlock.setModel(aliViewMenuBar.getRealignSelectedBlock());
        this.add(alignBlock);
        JMenuItem alignSelectedSeq = new JMenuItem("Realign selected sequence(s)");
        alignSelectedSeq.setModel(aliViewMenuBar.getRealignSelectedSequences());
        this.add(alignSelectedSeq);
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.showPopupMenu(e);
        }
    }

    private void showPopupMenu(MouseEvent e) {
        this.mouseActivationEvent = e;
        this.show(e.getComponent(), e.getX(), e.getY());
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }
}

