/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;
import javax.swing.text.PlainDocument;
import org.apache.log4j.Logger;

public class SearchPanel
extends JPanel {
    private static final Logger logger = Logger.getLogger(SearchPanel.class);
    JTextField searchField;
    JLabel searchMessageLabel;
    Color NOT_FOUND_COLOR = new Color(255, 182, 182);
    Color defaultBG_color;

    public SearchPanel() {
        this.setLayout(new BoxLayout(this, 0));
        this.setPreferredSize(new Dimension(210, 30));
        this.searchField = new JTextField();
        this.defaultBG_color = this.searchField.getBackground();
        this.searchField.setText("Search");
        if (this.searchField.getDocument() instanceof PlainDocument) {
            PlainDocument doc = (PlainDocument)this.searchField.getDocument();
            doc.setDocumentFilter(new TrimPastedTextFilter());
        }
        this.searchField.setColumns(10);
        this.searchField.setEnabled(false);
        this.searchField.setHorizontalAlignment(2);
        this.searchField.setMaximumSize(new Dimension(130, 30));
        this.searchField.setPreferredSize(new Dimension(130, 30));
        this.searchField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchPanel.this.searchMessageLabel.setText("");
                SearchPanel.this.searchField.setEnabled(false);
            }

            public void focusGained(FocusEvent e) {
                SearchPanel.this.searchField.setEnabled(true);
                SearchPanel.this.searchField.selectAll();
            }
        });
        this.searchField.addMouseListener(new MouseListener(){

            public void mouseReleased(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
                SearchPanel.this.searchField.setEnabled(true);
            }

            public void mouseClicked(MouseEvent e) {
            }
        });
        this.searchMessageLabel = new JLabel();
        this.searchMessageLabel.setHorizontalAlignment(11);
        this.searchMessageLabel.setMaximumSize(new Dimension(80, 30));
        this.searchMessageLabel.setPreferredSize(new Dimension(80, 30));
        this.add(this.searchMessageLabel);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.searchField);
    }

    public JTextField getSearchField() {
        return this.searchField;
    }

    public JLabel getSearchMessageLabel() {
        return this.searchMessageLabel;
    }

    public void setText(String searchText) {
        this.searchField.setText(searchText);
    }

    public String getText() {
        return this.searchField.getText();
    }

    public void requestFocusAndSelectAll() {
        this.searchField.requestFocus();
    }

    public void setFoundMessage() {
        this.searchMessageLabel.setText("");
        this.searchField.setBackground(this.defaultBG_color);
    }

    public void setNoFoundMessage() {
        this.searchMessageLabel.setText("not found");
        this.searchField.setBackground(this.NOT_FOUND_COLOR);
    }

    class TrimPastedTextFilter
    extends DocumentFilter {
        TrimPastedTextFilter() {
        }

        public void insertString(DocumentFilter.FilterBypass fb, int offset, String inText, AttributeSet attrs) throws BadLocationException {
            logger.info("instr:" + inText);
            if (inText != null && inText.length() > 1) {
                inText = inText.trim();
            }
            super.insertString(fb, offset, inText, attrs);
        }

        public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String inText, AttributeSet attrs) throws BadLocationException {
            logger.info("replace");
            if (inText != null && inText.length() > 1) {
                inText = inText.trim();
            }
            super.replace(fb, offset, length, inText, attrs);
        }

        public void remove(DocumentFilter.FilterBypass fb, int offset, int length) throws BadLocationException {
            logger.info("remove");
            super.remove(fb, offset, length);
        }
    }
}

