/*
 * Decompiled with CFR 0.152.
 */
package aliview.gui;

import aliview.AliViewWindow;
import aliview.HelpUtils;
import aliview.messenges.Messenger;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import utils.OSNativeUtils;
import utils.nexus.CharSets;
import utils.nexus.NexusUtilities;

public class TextEditPanelCharsets
extends JPanel {
    private static final Logger logger = Logger.getLogger(TextEditPanelCharsets.class);
    private static final String LF = System.getProperty("line.separator");
    private static final Font MONOSPACED_FONT = new Font(OSNativeUtils.getMonospacedFontName(), 0, new JTextArea().getFont().getSize());
    private JFrame parentFrame;
    private JTextArea editTextArea;
    private CharSets originalCharsets;
    private AliViewWindow aliWin;

    public TextEditPanelCharsets(JFrame parFrame, AliViewWindow aliWindow) {
        this.parentFrame = parFrame;
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{100, 100, 100, 100};
        gridBagLayout.rowHeights = new int[]{66, 0, 32, 0};
        gridBagLayout.columnWeights = new double[]{1.0, 0.0, 0.0, 0.0};
        gridBagLayout.rowWeights = new double[]{0.0, 1.0, 0.0, Double.MIN_VALUE};
        this.setLayout(gridBagLayout);
        JButton btnHelp = new JButton("Help");
        btnHelp.setPreferredSize(new Dimension(100, 30));
        btnHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent arg0) {
                HelpUtils.display("EDIT_CHARSETS_DIALOG", TextEditPanelCharsets.this.parentFrame);
            }
        });
        JButton btnCancel = new JButton("Cancel");
        btnCancel.setPreferredSize(new Dimension(100, 30));
        btnCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextEditPanelCharsets.this.aliWin.getAlignment().getAlignmentMeta().setCharsets(TextEditPanelCharsets.this.originalCharsets);
                TextEditPanelCharsets.this.aliWin.requestPaneAndRulerRepaint();
                TextEditPanelCharsets.this.parentFrame.dispose();
            }
        });
        JButton btnApply = new JButton("Apply");
        btnApply.setPreferredSize(new Dimension(100, 30));
        btnApply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextEditPanelCharsets.this.applyText();
            }
        });
        JButton btnOk = new JButton("OK");
        btnOk.setPreferredSize(new Dimension(100, 30));
        btnOk.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                TextEditPanelCharsets.this.applyText();
                TextEditPanelCharsets.this.parentFrame.dispose();
            }
        });
        JTextArea exampleMessage = new JTextArea();
        String exampleText = "Example charset definitions (for more details see Help):" + LF + LF + "charset WOODSIA_TRNGR = 1-1194;" + LF + "charset WOODSIA_ATPA = 1195-3029;" + LF + "charset Pos1_andPos2_Charset = 1-3029\\3 2-3029\\3;" + LF + "charset Pos3_Charset = 3-3029\\3;" + LF;
        exampleMessage.setText(exampleText);
        exampleMessage.setEditable(false);
        Color bgCol = new Color(this.getBackground().getRGB());
        exampleMessage.setBackground(bgCol);
        exampleMessage.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.editTextArea = new JTextArea();
        this.editTextArea.setFont(MONOSPACED_FONT);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setOpaque(false);
        scrollPane.setViewportView(this.editTextArea);
        GridBagConstraints gbc_textArea = new GridBagConstraints();
        gbc_textArea.gridwidth = 4;
        gbc_textArea.fill = 1;
        gbc_textArea.gridx = 0;
        gbc_textArea.gridy = 0;
        this.add((Component)exampleMessage, gbc_textArea);
        GridBagConstraints gbc_scrollPane = new GridBagConstraints();
        gbc_scrollPane.gridwidth = 4;
        gbc_scrollPane.fill = 1;
        gbc_scrollPane.insets = new Insets(0, 0, 10, 0);
        gbc_scrollPane.gridx = 0;
        gbc_scrollPane.gridy = 1;
        this.add((Component)scrollPane, gbc_scrollPane);
        GridBagConstraints gbc_btnHelp = new GridBagConstraints();
        gbc_btnHelp.anchor = 17;
        gbc_btnHelp.insets = new Insets(0, 0, 0, 5);
        gbc_btnHelp.gridx = 0;
        gbc_btnHelp.gridy = 2;
        this.add((Component)btnHelp, gbc_btnHelp);
        GridBagConstraints gbc_btnApply = new GridBagConstraints();
        gbc_btnApply.anchor = 13;
        gbc_btnApply.insets = new Insets(0, 0, 0, 5);
        gbc_btnApply.gridx = 1;
        gbc_btnApply.gridy = 2;
        this.add((Component)btnApply, gbc_btnApply);
        GridBagConstraints gbc_btnOk = new GridBagConstraints();
        gbc_btnOk.anchor = 17;
        gbc_btnOk.gridx = 3;
        gbc_btnOk.gridy = 2;
        this.add((Component)btnOk, gbc_btnOk);
        GridBagConstraints gbc_btnCancel = new GridBagConstraints();
        gbc_btnCancel.insets = new Insets(0, 0, 0, 5);
        gbc_btnCancel.anchor = 13;
        gbc_btnCancel.gridx = 2;
        gbc_btnCancel.gridy = 2;
        this.add((Component)btnCancel, gbc_btnCancel);
        this.setAlignment(aliWindow);
    }

    private void setAlignment(AliViewWindow aliWin) {
        this.aliWin = aliWin;
        this.originalCharsets = aliWin.getAlignment().getAlignmentMeta().getCharsets();
        String charsetsBlock = NexusUtilities.getCharsetsBlockWithoutNexus(this.originalCharsets);
        this.editTextArea.setText(charsetsBlock);
    }

    public void applyText() {
        String newCharsetBlock = this.editTextArea.getText();
        try {
            CharSets charsets = NexusUtilities.createCharsetsFromNexusCharsetBlock(newCharsetBlock);
            this.aliWin.getAlignment().getAlignmentMeta().setCharsets(charsets);
        }
        catch (Exception e) {
            Messenger.showEditCharsetExceptionMessage(e, this.parentFrame);
        }
        logger.info("debug:");
        this.aliWin.getAlignment().getAlignmentMeta().getCharsets().debug();
        logger.info("end debug:");
        this.aliWin.requestRepaintAndRevalidateALL();
    }
}

