/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.MemoryUtils;
import aliview.importer.AlignmentImportException;
import aliview.sequences.FastFastQSequence;
import aliview.sequences.Sequence;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastFastQImporter {
    private static final Logger logger = Logger.getLogger(FastFastQImporter.class);
    private Reader reader;
    private int longestSequenceLength;

    public FastFastQImporter(Reader reader) {
        this.reader = reader;
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        double maxMem = MemoryUtils.getMaxMem();
        try {
            String line;
            BufferedReader r = new BufferedReader(this.reader);
            String name = null;
            int nLine = 0;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                if (nLine % 4 == 0) {
                    if (line.length() > 0 && line.charAt(0) != '@') {
                        throw new AlignmentImportException("Error fastq format: very fourth line in fastq file should start with @ character");
                    }
                    name = line.substring(1);
                }
                if (nLine % 4 == 1) {
                    if ((double)line.length() > maxMem / 8.0) {
                        throw new AlignmentImportException("Sequence to long for memory");
                    }
                    sequences.add(new FastFastQSequence(name, line));
                    this.longestSequenceLength = Math.max(this.longestSequenceLength, line.length());
                }
                ++nLine;
            }
        }
        catch (Exception e) {
            logger.error(e);
            throw new AlignmentImportException("could not import as fastq file because: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public int getLongestSequenceLength() {
        return this.longestSequenceLength;
    }
}

