/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.sequences.FastFastaSequence;
import aliview.sequences.Sequence;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastFastaImporterSlow {
    private static final Logger logger = Logger.getLogger(FastFastaImporterSlow.class);
    private Reader reader;
    private int longestSequenceLength;

    public FastFastaImporterSlow(Reader reader) {
        this.reader = reader;
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            String seqAsString;
            String line;
            StringBuilder sequence = new StringBuilder();
            BufferedReader r = new BufferedReader(this.reader);
            String name = null;
            int nLine = 0;
            while ((line = r.readLine()) != null) {
                line = line.trim();
                if (nLine == 0 && line.length() > 0 && line.charAt(0) != '>') {
                    throw new AlignmentImportException("Fasta file should start with > character");
                }
                if (line.length() > 0) {
                    if (line.charAt(0) == '>') {
                        if (name != null && name.length() > 0) {
                            seqAsString = sequence.toString();
                            seqAsString = seqAsString.replaceAll(" ", "");
                            sequences.add(new FastFastaSequence(name, seqAsString));
                            this.longestSequenceLength = Math.max(this.longestSequenceLength, seqAsString.length());
                            sequence = new StringBuilder();
                            name = null;
                        }
                        name = line;
                    } else {
                        sequence.append(line);
                    }
                }
                ++nLine;
            }
            if (name != null && name.length() > 0) {
                seqAsString = sequence.toString();
                seqAsString = seqAsString.replaceAll(" ", "");
                sequences.add(new FastFastaSequence(name, seqAsString));
                this.longestSequenceLength = Math.max(this.longestSequenceLength, seqAsString.length());
                name = null;
            }
        }
        catch (Exception e) {
            logger.error(e);
            throw new AlignmentImportException("could not import as fasta file because: " + e.getMessage());
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    public int getLongestSequenceLength() {
        return this.longestSequenceLength;
    }
}

