/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.MappedBuffReaderHelper;
import aliview.sequences.NexusSequence;
import aliview.sequences.Sequence;
import it.unimi.dsi.io.ByteBufferInpStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastNexusImporterSlow {
    private static final Logger logger = Logger.getLogger(FastNexusImporterSlow.class);
    File alignmentFile;

    public FastNexusImporterSlow(File alignmentFile) throws FileNotFoundException, IOException {
        this.alignmentFile = alignmentFile;
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        ArrayList<Sequence> allSeqs = new ArrayList<Sequence>();
        try {
            ByteBufferInpStream mappedBuff = ByteBufferInpStream.map(new FileInputStream(this.alignmentFile).getChannel(), FileChannel.MapMode.READ_ONLY);
            boolean longestSequenceLength = false;
            logger.info("Nexus file ix");
            MappedBuffReaderHelper readerHelper = new MappedBuffReaderHelper(mappedBuff);
            ArrayList<String> allTokens = readerHelper.readAllNexusTokensUntil("MATRIX");
            for (int n = 0; n < allTokens.size(); ++n) {
                String token = allTokens.get(n);
                logger.info(token);
            }
            boolean NEXUS_TYPE_SEQUENTIAL = false;
            boolean NEXUS_TYPE_INTERLEAVED = true;
            boolean importerType = NEXUS_TYPE_SEQUENTIAL;
            if (this.tokenExists(allTokens, "interleave")) {
                importerType = NEXUS_TYPE_INTERLEAVED;
                String token = this.tokenAfter(allTokens, "interleave");
                if (token != null && StringUtils.equalsIgnoreCase(token, "NO")) {
                    importerType = NEXUS_TYPE_SEQUENTIAL;
                }
            }
            int nChar = 0;
            String value = this.tokenAfter(allTokens, "nchar");
            if (value != null) {
                nChar = Integer.parseInt(value);
            }
            int nTax = 0;
            value = this.tokenAfter(allTokens, "ntax");
            if (value != null) {
                nTax = Integer.parseInt(value);
            }
            if (importerType == NEXUS_TYPE_SEQUENTIAL) {
                for (int n = 0; n < nTax; ++n) {
                    String name = readerHelper.readNextNexusSeqName();
                    long seqStartPointer = readerHelper.posOfNextNonWhiteNexusChar();
                    long seqEndPointer = readerHelper.getPosOfNonWhiteNexusCharacter(nChar - 1);
                    byte[] seqAsBytes = readerHelper.getBytesBetween(seqStartPointer, seqEndPointer);
                    NexusSequence seq = new NexusSequence(name, seqAsBytes);
                    allSeqs.add(seq);
                    readerHelper.setPosition(seqEndPointer + 1L);
                }
            }
            if (importerType == NEXUS_TYPE_INTERLEAVED) {
                logger.info("NEXUS_TYPE_INTERLEAVED");
            }
        }
        catch (Exception exc) {
            logger.info("could not read as nexus");
            exc.printStackTrace();
            throw new AlignmentImportException("Could not read nexus format");
        }
        return allSeqs;
    }

    private int tokenIndex(ArrayList<String> allTokens, String target) {
        for (int n = 0; n < allTokens.size(); ++n) {
            String token = allTokens.get(n);
            if (!StringUtils.equalsIgnoreCase(token, target)) continue;
            return n;
        }
        return -1;
    }

    private boolean tokenExists(ArrayList<String> allTokens, String target) {
        return this.tokenIndex(allTokens, target) > -1;
    }

    private String tokenAfter(ArrayList<String> allTokens, String target) {
        int index = this.tokenIndex(allTokens, target);
        if (index > -1 && allTokens.size() > index) {
            return allTokens.get(index + 1);
        }
        return null;
    }
}

