/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.FileIndexer;
import aliview.sequencelist.MemoryMappedSequencesFile;
import aliview.sequences.BasicSequence;
import aliview.sequences.FastaFileSequence;
import aliview.sequences.FileSequence;
import aliview.sequences.Sequence;
import aliview.subprocesses.SubThreadProgressWindow;
import it.unimi.dsi.io.ByteBufferInpStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FastaFileIndexer
implements FileIndexer {
    private static final Logger logger = Logger.getLogger(FastaFileIndexer.class);
    long estimateTotalSeqInFile = 0L;
    long fileSize = -1L;

    public ArrayList<Sequence> findSequencesInFile(MemoryMappedSequencesFile sequencesFile, long filePointerStart, int seqOffset, int nSeqsToRetrieve, SubThreadProgressWindow progressWin) {
        FileSequence seq;
        ByteBufferInpStream mappedBuff = sequencesFile.getMappedBuff();
        this.fileSize = mappedBuff.length();
        int nSeqCount = 0;
        ArrayList<Sequence> allSeqs = new ArrayList<Sequence>();
        for (int n = 0; n < nSeqsToRetrieve && (seq = this.findSequenceInFile(sequencesFile, filePointerStart, seqOffset)) != null; ++n) {
            long seqLength = seq.getLength();
            allSeqs.add(seq);
            ++seqOffset;
            filePointerStart = seq.getEndPointer() + 1L;
            ++nSeqCount;
            int MESSAGE_FREQUENCE = 1;
            if (this.estimateTotalSeqInFile > 500L) {
                MESSAGE_FREQUENCE = 100;
            }
            if (this.estimateTotalSeqInFile > 5000L) {
                MESSAGE_FREQUENCE = 1000;
            }
            if (nSeqCount % MESSAGE_FREQUENCE == 0 && nSeqCount > 1) {
                int lastSeqIndex = seqOffset;
                long lastSeqEndPointer = seq.getEndPointer();
                long oneSeqFileSizeSize = (lastSeqEndPointer + 1L) / (long)(lastSeqIndex + 1);
                this.estimateTotalSeqInFile = this.fileSize / oneSeqFileSizeSize;
                int current = lastSeqIndex;
                progressWin.setMessage("Indexing file " + current + " out of ~" + this.estimateTotalSeqInFile);
            }
            if (progressWin.wasSubThreadInterruptedByUser()) {
                Thread.currentThread().interrupt();
                break;
            }
            if (!sequencesFile.getMappedBuffLock().hasQueuedThreads()) continue;
            sequencesFile.getMappedBuffLock().unlock();
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            sequencesFile.getMappedBuffLock().lock();
        }
        return allSeqs;
    }

    public FileSequence findSequenceInFile(MemoryMappedSequencesFile sequencesFile, long filePointerStart, int seqOffset) {
        byte nextByte;
        StringBuilder name = new StringBuilder();
        BasicSequence sequence = null;
        boolean bytesUntilNextLFAreName = false;
        ByteBufferInpStream mappedBuff = sequencesFile.getMappedBuff();
        mappedBuff.position(filePointerStart);
        int lineLength = 0;
        while ((nextByte = (byte)mappedBuff.read()) != -1) {
            boolean findNextLF = false;
            if (nextByte == 62 && !bytesUntilNextLFAreName) {
                if (sequence != null) {
                    ((FileSequence)sequence).setEndPointer(mappedBuff.position() - 2L);
                    return sequence;
                }
                name = new StringBuilder(250);
                sequence = new FastaFileSequence(sequencesFile, mappedBuff.position());
                bytesUntilNextLFAreName = true;
            }
            if (nextByte == 10 && bytesUntilNextLFAreName) {
                sequence.setName(name.toString());
                ((FileSequence)sequence).setSequenceAfterNameStartPointer(mappedBuff.position() + 1L);
                bytesUntilNextLFAreName = false;
            }
            ++lineLength;
            if (!bytesUntilNextLFAreName) continue;
            name.append((char)nextByte);
        }
        if (nextByte == -1 && sequence != null) {
            logger.info("EOF=" + mappedBuff.position());
            ((FileSequence)sequence).setEndPointer(mappedBuff.position() - 1L);
        }
        return sequence;
    }
}

