/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import aliview.importer.AlignmentImportException;
import aliview.importer.ByteBufferAutogrow;
import aliview.importer.ReaderHelper;
import aliview.sequences.MSFSequence;
import aliview.sequences.Sequence;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MSFImporter {
    private static final Logger logger = Logger.getLogger(MSFImporter.class);
    private Reader reader;
    public static final int UNKNOWN = -1;
    public static int INTERLEAVED_OR_SINGLELINE_SEQUENTIAL = 0;
    public int formatType;

    public static void main(String[] args) throws FileNotFoundException, AlignmentImportException {
        File alignmentFile = new File("/home/anders/projekt/alignments/MSF_format.example.msf");
        MSFImporter importer = new MSFImporter(new FileReader(alignmentFile), INTERLEAVED_OR_SINGLELINE_SEQUENTIAL);
        importer.importSequences();
    }

    public MSFImporter(Reader reader, int formatType) {
        this.reader = reader;
        this.formatType = formatType;
    }

    public MSFImporter(FileReader fileReader) {
        this(fileReader, INTERLEAVED_OR_SINGLELINE_SEQUENTIAL);
    }

    public List<Sequence> importSequences() throws AlignmentImportException {
        long startTime = System.currentTimeMillis();
        ArrayList<Sequence> sequences = new ArrayList<Sequence>();
        try {
            String sequenceString = "";
            BufferedReader r = new BufferedReader(this.reader);
            ReaderHelper helper = new ReaderHelper(r);
            helper.readNextLine();
            String firstLine = helper.getNextLine();
            boolean isRightFormat = MSFImporter.isStringValidFirstLine(firstLine);
            if (!isRightFormat) {
                throw new AlignmentImportException("Could not read file as MSF format");
            }
            boolean containsMSF = helper.readUntilNextLineContains("MSF:");
            String metaLine = helper.getNextLine();
            String strLength = StringUtils.substringBetween(metaLine, "MSF:", "Type:");
            strLength = strLength.trim();
            int guessedLength = 0;
            try {
                guessedLength = Integer.parseInt(strLength);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
            logger.info("guessedLength" + guessedLength);
            boolean containsName = helper.readUntilNextLineContains("Name:");
            String firstNameLine = helper.getNextLine();
            String firstName = StringUtils.substringBetween(firstNameLine, ": ", " ");
            firstName = firstName.trim();
            logger.info("inside msf importer, firstName = " + firstName);
            if (this.formatType == INTERLEAVED_OR_SINGLELINE_SEQUENTIAL) {
                ArrayList<String> seqNames = new ArrayList<String>();
                ArrayList<ByteBufferAutogrow> seqBuffers = new ArrayList<ByteBufferAutogrow>();
                helper.readUntilNextLineContains("//");
                helper.readUntilNextLineContains(firstName);
                int seqCount = 0;
                boolean longestName = false;
                boolean longestSeq = false;
                while (helper.isNextLineContainingNonWhitespaceChars()) {
                    String line = helper.getNextLine();
                    line = line.trim();
                    int index = ReaderHelper.indexOfFirstNonWhiteCharAfterWhiteChar(line);
                    String name = line.substring(0, index).trim();
                    seqNames.add(name);
                    String seqChars = line.substring(index);
                    seqChars = ReaderHelper.removeSpaceAndTab(seqChars);
                    seqChars = this.replaceMSFGapCharacters(seqChars);
                    int capacity = guessedLength;
                    ByteBufferAutogrow seqBuff = new ByteBufferAutogrow(capacity);
                    seqBuff.append(seqChars);
                    seqBuffers.add(seqBuff);
                    ++seqCount;
                    helper.readNextLine();
                }
                while (helper.readUntilNextLineContains(firstName)) {
                    for (int lineCount = 0; lineCount < seqCount; ++lineCount) {
                        String line = helper.getNextLine();
                        line = line.trim();
                        int index = ReaderHelper.indexOfFirstNonWhiteCharAfterWhiteChar(line);
                        String moreChars = line.substring(index);
                        moreChars = ReaderHelper.removeSpaceAndTab(moreChars);
                        moreChars = this.replaceMSFGapCharacters(moreChars);
                        ByteBufferAutogrow seqBuff = (ByteBufferAutogrow)seqBuffers.get(lineCount);
                        seqBuff.append(moreChars);
                        helper.readNextLine();
                    }
                }
                for (int n = 0; n < seqCount; ++n) {
                    sequences.add(new MSFSequence((String)seqNames.get(n), ((ByteBufferAutogrow)seqBuffers.get(n)).getBytes()));
                    seqNames.set(n, null);
                    seqBuffers.set(n, null);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        System.out.println("reading sequences took " + (endTime - startTime) + " milliseconds");
        return sequences;
    }

    private String replaceMSFGapCharacters(String seqChars) {
        if (seqChars.indexOf(46) > -1) {
            seqChars = seqChars.replace('.', '-');
        }
        if (seqChars.indexOf(126) > -1) {
            seqChars = seqChars.replace('~', '-');
        }
        return seqChars;
    }

    public static boolean isStringValidFirstLine(String firstLine) {
        return StringUtils.contains(firstLine, "!!") || StringUtils.containsIgnoreCase(firstLine, "PileUp");
    }

    public static int GCGchecksum(Sequence seq) {
        int check = 0;
        for (int n = 0; n < seq.getLength(); ++n) {
            byte byteVal = seq.getBaseAtPos(n);
            int val = Character.toLowerCase(byteVal);
            if (val >= 97 && val <= 122) {
                val -= 32;
            }
            int positionMultiplier = n % 57 + 1;
            check += val * positionMultiplier;
        }
        return check %= 10000;
    }
}

