/*
 * Decompiled with CFR 0.152.
 */
package aliview.importer;

import it.unimi.dsi.io.ByteBufferInpStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedBuffReaderHelper {
    private static final Logger logger = Logger.getLogger(MappedBuffReaderHelper.class);
    private ByteBufferInpStream mappedBuff;
    private byte lastRead;

    public MappedBuffReaderHelper(ByteBufferInpStream mappedBuff) {
        this.mappedBuff = mappedBuff;
    }

    public void setPosition(long position) {
        this.mappedBuff.position(position);
    }

    public long findNext(byte target) {
        while (target != this.mappedBuff.read()) {
        }
        return this.mappedBuff.position() - 1L;
    }

    public long findNextOrEOF(byte target) {
        while (target != this.mappedBuff.read()) {
        }
        return this.mappedBuff.position() - 1L;
    }

    private boolean isEOF() {
        return this.lastRead == -1;
    }

    private byte read() throws EOFException {
        this.lastRead = (byte)this.mappedBuff.read();
        if (this.lastRead == -1) {
            throw new EOFException();
        }
        return this.lastRead;
    }

    public long appendBytesUntilNextLF(StringBuilder stringBuff) throws EOFException {
        byte nextByte;
        while (!this.isLF(nextByte = this.read())) {
            stringBuff.append((char)nextByte);
        }
        return this.mappedBuff.position() - 1L;
    }

    private boolean isReturnOrLF(int nextByte) {
        return nextByte == 10 || nextByte == 13;
    }

    private boolean isLF(int nextByte) {
        return nextByte == 10;
    }

    private boolean isSpaceOrTab(int nextByte) {
        return nextByte == 32 || nextByte == 9;
    }

    private boolean isWhiteOrLF(int nextByte) {
        return nextByte == 32 || nextByte == 9 || nextByte == 13 || nextByte == 10;
    }

    private boolean isSpace(int nextByte) {
        return nextByte == 32;
    }

    private boolean isCitation(byte nextByte) {
        return nextByte == 39;
    }

    public boolean hasNext() {
        return !this.isEOF();
    }

    public String readLine() throws EOFException {
        StringBuilder buff = new StringBuilder();
        this.appendBytesUntilNextLF(buff);
        return buff.toString();
    }

    public long posOfFirstNonWhiteCharAfterWhiteChar() throws EOFException {
        byte next;
        boolean whiteFound = false;
        long foundPos = -1L;
        do {
            if (!this.isSpaceOrTab(next = this.read())) continue;
            whiteFound = true;
        } while (!whiteFound || this.isSpaceOrTab(next));
        foundPos = this.mappedBuff.position() - 1L;
        return foundPos;
    }

    public void posOfFirstCharAfterNexusName() {
        boolean charFound = false;
        boolean whiteFound = false;
    }

    public boolean hasLineOnlyOneContinousSpace() throws EOFException {
        int previous = -1;
        int spaceCount = 0;
        byte next;
        while (!this.isLF(next = this.read())) {
            if (this.isSpaceOrTab(next) && !this.isSpaceOrTab(previous) && ++spaceCount > 1) {
                return false;
            }
            previous = next;
        }
        return spaceCount == 1;
    }

    public long posOfNextNewline() throws EOFException {
        byte next;
        long foundPos = -1L;
        while (!this.isLF(next = this.read())) {
        }
        foundPos = this.mappedBuff.position() - 1L;
        return foundPos;
    }

    public int countSpaceBetween(long seqStartPos, long firstNewlinePos) throws EOFException {
        this.mappedBuff.position(seqStartPos);
        int spaceCount = 0;
        long len = firstNewlinePos - seqStartPos;
        int n = 0;
        while ((long)n < len) {
            byte next = this.read();
            if (this.isSpace(next)) {
                ++spaceCount;
            }
            ++n;
        }
        return spaceCount;
    }

    public long posAtNSequenceCharacters(long seqStartPos, int countTarget) throws EOFException {
        this.mappedBuff.position(seqStartPos);
        int charCount = 0;
        while (charCount < countTarget) {
            byte next = this.read();
            if (this.isWhiteOrLF(next)) continue;
            ++charCount;
        }
        return this.mappedBuff.position() - 1L;
    }

    public boolean isNextLF() throws EOFException {
        byte next = this.read();
        return this.isReturnOrLF(next);
    }

    public String readString(long startPos, long endPos) throws IOException {
        long length = endPos - startPos;
        byte[] nameArray = new byte[(int)length];
        this.mappedBuff.position(startPos);
        this.mappedBuff.read(nameArray);
        return new String(nameArray);
    }

    public long posOfNextNonWhiteChar() throws EOFException {
        byte next;
        long foundPos = -1L;
        while (this.isWhiteOrLF(next = this.read())) {
        }
        foundPos = this.mappedBuff.position() - 1L;
        return foundPos;
    }

    public long skipUntilNextNonWhiteChar() throws EOFException {
        return this.posOfNextNonWhiteChar();
    }

    public int skipUntilNextNonWhiteCharOnNextLine() throws EOFException {
        byte next;
        long foundPos = -1L;
        int linebreaks = 0;
        do {
            if (!this.isLF(next = this.read())) continue;
            ++linebreaks;
        } while (linebreaks <= 0 || this.isWhiteOrLF(next));
        this.mappedBuff.position(this.mappedBuff.position() - 1L);
        return linebreaks;
    }

    public int skipUntilNextNonWhiteCharInFirstPosAfterNewLine() throws EOFException {
        byte next;
        long foundPos = -1L;
        int linebreaks = 0;
        int charCountSinceLF = 0;
        do {
            next = this.read();
            ++charCountSinceLF;
            if (!this.isLF(next)) continue;
            ++linebreaks;
            charCountSinceLF = 0;
        } while (charCountSinceLF != 1 || linebreaks <= 0 || this.isWhiteOrLF(next));
        this.mappedBuff.position(this.mappedBuff.position() - 1L);
        return linebreaks;
    }

    public String skipUntilLineContains(String string) throws EOFException {
        String nextLine;
        long startPointer = this.mappedBuff.position();
        do {
            startPointer = this.mappedBuff.position();
        } while (!(nextLine = this.readLine()).toUpperCase().contains(string.toUpperCase()));
        this.mappedBuff.position(startPointer);
        return nextLine;
    }

    private boolean isTokenDelimiter(int nextByte) {
        return nextByte == 32 || nextByte == 9 || nextByte == 13 || nextByte == 10 || nextByte == 61 || nextByte == 59;
    }

    private boolean isNexusCommentStart(int nextByte) {
        return nextByte == 91;
    }

    private boolean isNexusCommentEnd(int nextByte) {
        return nextByte == 93;
    }

    private boolean isNexusNameCitation(int nextByte) {
        return nextByte == 39;
    }

    public String getCharsUntilNexusCitation() throws EOFException {
        StringBuilder buff = new StringBuilder();
        byte nextByte;
        while (!this.isNexusNameCitation(nextByte = this.read())) {
            buff.append(nextByte);
        }
        return buff.toString();
    }

    public void skipUntilNexusCommentEnd() throws EOFException {
        byte nextByte;
        while (!this.isNexusCommentEnd(nextByte = this.read())) {
        }
    }

    public ArrayList<String> readAllNexusTokensUntil(String endToken) throws EOFException {
        ArrayList<String> tokens = new ArrayList<String>();
        StringBuilder buff = new StringBuilder();
        while (true) {
            byte nextByte;
            if (this.isNexusCommentStart(nextByte = this.read())) {
                this.skipUntilNexusCommentEnd();
            }
            if (this.isTokenDelimiter(nextByte)) {
                if (buff.length() <= 0) continue;
                String token = buff.toString();
                tokens.add(token);
                if (StringUtils.equalsIgnoreCase(token, endToken)) {
                    return tokens;
                }
                buff = new StringBuilder();
                continue;
            }
            buff.append((char)nextByte);
        }
    }

    public String readNextNexusSeqName() throws EOFException {
        StringBuilder buff = new StringBuilder();
        while (true) {
            byte nextByte;
            if (this.isNexusCommentStart(nextByte = this.read())) {
                this.skipUntilNexusCommentEnd();
                continue;
            }
            if (this.isNexusNameCitation(nextByte)) {
                String name = this.getCharsUntilNexusCitation();
                buff.append(name);
                continue;
            }
            if (this.isWhiteOrLF(nextByte)) {
                if (buff.length() <= 0) continue;
                return buff.toString();
            }
            buff.append((char)nextByte);
        }
    }

    public long posOfNextNonWhiteNexusChar() throws EOFException {
        byte nextByte;
        do {
            if (!this.isNexusCommentStart(nextByte = this.read())) continue;
            this.skipUntilNexusCommentEnd();
        } while (this.isWhiteOrLF(nextByte));
        return this.mappedBuff.position() - 1L;
    }

    public long posOfNextWhitespaceOrLF() throws EOFException {
        byte nextByte;
        while (!this.isWhiteOrLF(nextByte = this.read())) {
        }
        return this.mappedBuff.position() - 1L;
    }

    public long getPosOfNonWhiteNexusCharacter(int skipCount) throws EOFException {
        int counter = 0;
        while (true) {
            byte nextByte;
            if (this.isNexusCommentStart(nextByte = this.read())) {
                this.skipUntilNexusCommentEnd();
                continue;
            }
            if (!this.isWhiteOrLF(nextByte) && ++counter == skipCount) break;
        }
        return this.mappedBuff.position() - 1L;
    }

    public byte[] getBytesBetween(long seqStartPointer, long seqEndPointer) {
        long len = seqEndPointer - seqStartPointer + 1L;
        byte[] bytes = new byte[(int)len];
        this.mappedBuff.read(bytes, 0, bytes.length);
        return bytes;
    }

    public void readUntilNextNonBlankLine() {
    }

    public long position() {
        return this.mappedBuff.position();
    }
}

