/*
 * Decompiled with CFR 0.152.
 */
package aliview.primer;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class OligoCalc {
    private static final Logger logger = Logger.getLogger(OligoCalc.class);

    public static void main(String[] args) {
        double conc_primer = 200.0;
        double conc_salt = 50.0;
        double conc_mg = 0.0;
        String testSeq = "cagcaatggatggatgatct";
        logger.info(OligoCalc.getBaseStackingTM(testSeq, conc_primer, conc_salt, conc_mg));
    }

    private static double getEnthalpy(String seq) {
        double entalphy = 0.0;
        if ("AA".equalsIgnoreCase(seq)) {
            entalphy = -7.9;
        }
        if ("AC".equalsIgnoreCase(seq)) {
            entalphy = -8.4;
        }
        if ("AG".equalsIgnoreCase(seq)) {
            entalphy = -7.8;
        }
        if ("AT".equalsIgnoreCase(seq)) {
            entalphy = -7.2;
        }
        if ("CA".equalsIgnoreCase(seq)) {
            entalphy = -8.5;
        }
        if ("CC".equalsIgnoreCase(seq)) {
            entalphy = -8.0;
        }
        if ("CG".equalsIgnoreCase(seq)) {
            entalphy = -10.6;
        }
        if ("CT".equalsIgnoreCase(seq)) {
            entalphy = -7.8;
        }
        if ("GA".equalsIgnoreCase(seq)) {
            entalphy = -8.2;
        }
        if ("GC".equalsIgnoreCase(seq)) {
            entalphy = -10.6;
        }
        if ("GG".equalsIgnoreCase(seq)) {
            entalphy = -8.0;
        }
        if ("GT".equalsIgnoreCase(seq)) {
            entalphy = -8.4;
        }
        if ("TA".equalsIgnoreCase(seq)) {
            entalphy = -7.2;
        }
        if ("TC".equalsIgnoreCase(seq)) {
            entalphy = -8.2;
        }
        if ("TG".equalsIgnoreCase(seq)) {
            entalphy = -8.5;
        }
        if ("TT".equalsIgnoreCase(seq)) {
            entalphy = -7.9;
        }
        return entalphy;
    }

    private static double getEntropy(String seq) {
        double entropy = 0.0;
        if ("AA".equalsIgnoreCase(seq)) {
            entropy = -22.2;
        }
        if ("AC".equalsIgnoreCase(seq)) {
            entropy = -22.4;
        }
        if ("AG".equalsIgnoreCase(seq)) {
            entropy = -21.0;
        }
        if ("AT".equalsIgnoreCase(seq)) {
            entropy = -20.4;
        }
        if ("CA".equalsIgnoreCase(seq)) {
            entropy = -22.7;
        }
        if ("CC".equalsIgnoreCase(seq)) {
            entropy = -19.9;
        }
        if ("CG".equalsIgnoreCase(seq)) {
            entropy = -27.2;
        }
        if ("CT".equalsIgnoreCase(seq)) {
            entropy = -21.0;
        }
        if ("GA".equalsIgnoreCase(seq)) {
            entropy = -22.2;
        }
        if ("GC".equalsIgnoreCase(seq)) {
            entropy = -27.2;
        }
        if ("GG".equalsIgnoreCase(seq)) {
            entropy = -19.9;
        }
        if ("GT".equalsIgnoreCase(seq)) {
            entropy = -22.4;
        }
        if ("TA".equalsIgnoreCase(seq)) {
            entropy = -21.3;
        }
        if ("TC".equalsIgnoreCase(seq)) {
            entropy = -22.2;
        }
        if ("TG".equalsIgnoreCase(seq)) {
            entropy = -22.7;
        }
        if ("TT".equalsIgnoreCase(seq)) {
            entropy = -22.2;
        }
        return entropy;
    }

    public static double getBaseStackingTM(String sequence, double conc_primer, double conc_salt, double conc_mg) {
        char lastnucleotide;
        sequence = sequence.toUpperCase();
        double salt_effect = conc_salt / 1000.0 + conc_mg / 1000.0 * 140.0;
        double h = 0.0;
        double s = 0.0;
        s = 0.368 * (double)(sequence.length() - 1) * Math.log(salt_effect);
        char firstnucleotide = sequence.charAt(0);
        if (firstnucleotide == 'G' || firstnucleotide == 'C') {
            h += 0.1;
            s += -2.8;
        }
        if (firstnucleotide == 'A' || firstnucleotide == 'T') {
            h += 2.3;
            s += 4.1;
        }
        if ((lastnucleotide = sequence.charAt(sequence.length() - 1)) == 'G' || lastnucleotide == 'C') {
            h += 0.1;
            s += -2.8;
        }
        if (lastnucleotide == 'A' || lastnucleotide == 'T') {
            h += 2.3;
            s += 4.1;
        }
        for (int i = 0; i < sequence.length() - 1; ++i) {
            String subSeq = sequence.substring(i, i + 2);
            h += OligoCalc.getEnthalpy(subSeq);
            s += OligoCalc.getEntropy(subSeq);
        }
        double tm = 1000.0 * h / (s + 1.987 * Math.log(conc_primer / 2.0E9)) - 273.15;
        return tm;
    }

    public static double getEurofinsTM(String sequence) {
        sequence = sequence.toUpperCase();
        double L = sequence.length();
        double ng = StringUtils.countMatches(sequence, "G");
        double nc = StringUtils.countMatches(sequence, "C");
        double na = StringUtils.countMatches(sequence, "A");
        double nt = StringUtils.countMatches(sequence, "T");
        double tm = sequence.length() > 15 ? 69.3 + 41.0 * (ng + nc) / L - 650.0 / L : 2.0 * (na + nt) + 4.0 * (ng + nc);
        return tm;
    }
}

