/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AminoAcid;
import aliview.NucleotideUtilities;
import aliview.alignment.AAHistogram;
import aliview.alignment.AliHistogram;
import aliview.alignment.Alignment;
import aliview.alignment.AlignmentMeta;
import aliview.alignment.NucleotideHistogram;
import aliview.importer.FileFormat;
import aliview.sequencelist.AlignmentDataEvent;
import aliview.sequencelist.AlignmentDataListener;
import aliview.sequencelist.AlignmentSelectionListener;
import aliview.sequencelist.AlignmentSelectionModel;
import aliview.sequencelist.FindObject;
import aliview.sequencelist.Interval;
import aliview.sequencelist.SequencePositionComparator;
import aliview.sequences.InMemorySequence;
import aliview.sequences.Sequence;
import aliview.sequences.SequenceUtils;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataListener;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;
import utils.DialogUtils;
import utils.nexus.CharSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentListModel
implements ListModel,
Iterable<Sequence> {
    private static final String LF = System.getProperty("line.separator");
    private static final long serialVersionUID = -8081215660929212156L;
    private static final Logger logger = Logger.getLogger(AlignmentListModel.class);
    List<Sequence> delegateSequences;
    protected FileFormat fileFormat;
    protected int sequenceType = SequenceUtils.TYPE_UNKNOWN;
    private int selectionOffset;
    private AlignmentSelectionModel selectionModel = new AlignmentSelectionModel(this);
    protected EventListenerList listenerList = new EventListenerList();
    private volatile AliHistogram cachedHistogram;
    private volatile int cachedLongestSequenceName;
    private volatile int cachedLongestSequenceLength = -1;
    private boolean isTranslated;
    private Alignment alignment;

    public AlignmentListModel() {
        this.delegateSequences = new ArrayList<Sequence>();
    }

    public AlignmentListModel(List<Sequence> seqs) {
        for (Sequence seq : seqs) {
            seq.setAlignmentModel(this);
        }
        this.delegateSequences = seqs;
        this.fireSequenceIntervalAdded(0, seqs.size() - 1);
    }

    public AlignmentListModel(List<Sequence> seqs, FileFormat foundFormat) {
        this.fileFormat = foundFormat;
        for (Sequence seq : seqs) {
            seq.setAlignmentModel(this);
        }
        this.delegateSequences = seqs;
        this.fireSequenceIntervalAdded(0, seqs.size() - 1);
    }

    public AlignmentListModel(AlignmentListModel template) {
        ArrayList<Sequence> seqClone = new ArrayList<Sequence>();
        for (Sequence seq : template.delegateSequences) {
            seqClone.add(seq.getCopy());
        }
        this.fileFormat = template.fileFormat;
        this.delegateSequences = seqClone;
        this.sequenceType = template.sequenceType;
        this.fireSequencesChangedAllNew();
    }

    @Override
    public int getSize() {
        return this.delegateSequences.size();
    }

    public Sequence getElementAt(int index) {
        return this.delegateSequences.get(index);
    }

    @Override
    public void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    @Override
    public void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public void addAlignmentDataListener(AlignmentDataListener l) {
        this.listenerList.add(AlignmentDataListener.class, l);
    }

    public void removeAlignmentDataListener(AlignmentDataListener l) {
        this.listenerList.remove(AlignmentDataListener.class, l);
    }

    @Override
    public Iterator<Sequence> iterator() {
        return this.delegateSequences.listIterator();
    }

    public void setSequences(List<Sequence> list) {
        if (list != null) {
            for (Sequence seq : list) {
                seq.setAlignmentModel(this);
            }
            this.delegateSequences = list;
            this.fireSequencesChangedAllNew();
        }
    }

    public List<Sequence> getDelegateSequences() {
        return this.delegateSequences;
    }

    public AlignmentListModel getCopy() {
        return new AlignmentListModel(this);
    }

    public AlignmentListModel getCopyShallow() {
        AlignmentListModel copy = new AlignmentListModel();
        copy.delegateSequences.addAll(this.delegateSequences);
        copy.fileFormat = this.fileFormat;
        copy.sequenceType = this.sequenceType;
        return copy;
    }

    public Sequence get(int index) {
        if (index >= this.delegateSequences.size()) {
            return null;
        }
        return this.delegateSequences.get(index);
    }

    public Sequence set(int index, Sequence sequence) {
        sequence.setAlignmentModel(this);
        Sequence previous = this.delegateSequences.set(index, sequence);
        this.fireSequencesChanged(index, index);
        return previous;
    }

    public void add(Sequence sequence) {
        sequence.setAlignmentModel(this);
        this.delegateSequences.add(sequence);
        this.fireSequenceIntervalAdded(this.size() - 1, this.size() - 1);
    }

    public void add(int index, Sequence seq) {
        seq.setAlignmentModel(this);
        this.delegateSequences.add(index, seq);
        this.fireSequenceIntervalAdded(index, index);
    }

    public void addAll(AlignmentListModel otherSeqModel, boolean setSelected) {
        this.addAll(otherSeqModel.getDelegateSequencesCopy(), setSelected);
    }

    public void addAll(int index, AlignmentListModel otherSeqModel) {
        for (Sequence seq : otherSeqModel.getDelegateSequencesCopy()) {
            seq.setAlignmentModel(this);
        }
        this.delegateSequences.addAll(index, otherSeqModel.getDelegateSequencesCopy());
        this.fireSequenceIntervalAdded(index, index + otherSeqModel.getDelegateSequencesCopy().size());
    }

    public void addAll(List<Sequence> moreSeqs, boolean setSelected) {
        for (Sequence seq : moreSeqs) {
            seq.setAlignmentModel(this);
        }
        logger.info("added all moreSeqs.size()" + moreSeqs.size());
        this.delegateSequences.addAll(moreSeqs);
        if (setSelected) {
            this.selectionModel.setSequenceSelection(moreSeqs);
        }
        this.fireSequenceIntervalAdded(this.size() - moreSeqs.size(), this.size() - 1);
    }

    public List<Sequence> getDelegateSequencesCopy() {
        return new ArrayList<Sequence>(this.delegateSequences);
    }

    protected List<Sequence> getSequences() {
        return this.delegateSequences;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLongestSequenceLength() {
        if (this.cachedLongestSequenceLength <= 0) {
            AlignmentListModel alignmentListModel = this;
            synchronized (alignmentListModel) {
                if (this.cachedLongestSequenceLength < 0) {
                    int maxLen = 0;
                    for (int n = 0; n < this.delegateSequences.size(); ++n) {
                        int len = this.delegateSequences.get(n).getLength();
                        if (len <= maxLen) continue;
                        maxLen = len;
                    }
                    this.cachedLongestSequenceLength = maxLen;
                }
            }
        }
        return this.cachedLongestSequenceLength;
    }

    public int getShortestSequenceLength() {
        int minLen = this.getLongestSequenceLength();
        for (int n = 0; n < this.delegateSequences.size(); ++n) {
            int len = this.delegateSequences.get(n).getLength();
            if (len >= minLen) continue;
            minLen = len;
        }
        return minLen;
    }

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public int getSequenceType() {
        if (this.delegateSequences.size() > 0 && this.sequenceType == SequenceUtils.TYPE_UNKNOWN) {
            double ratio;
            int gapCount = 0;
            int nucleotideCount = 0;
            int otherCount = 0;
            block0: for (Sequence seq : this.delegateSequences) {
                for (int pos = 0; pos < seq.getLength(); ++pos) {
                    byte base = seq.getBaseAtPos(pos);
                    if (NucleotideUtilities.isGap(base)) {
                        ++gapCount;
                    } else if (NucleotideUtilities.isNucleoticeOrIUPAC(base)) {
                        ++nucleotideCount;
                    } else {
                        ++otherCount;
                    }
                    if (nucleotideCount + otherCount >= 1000) break block0;
                }
            }
            logger.info("gapCount=" + gapCount);
            logger.info("nucleotideCount=" + nucleotideCount);
            logger.info("otherCount=" + otherCount);
            this.sequenceType = nucleotideCount < 4 ? SequenceUtils.TYPE_UNKNOWN : ((ratio = (double)otherCount / (double)nucleotideCount) == 0.0 ? SequenceUtils.TYPE_NUCLEIC_ACID : (ratio > 0.2 ? SequenceUtils.TYPE_AMINO_ACID : SequenceUtils.TYPE_UNKNOWN));
            if (this.sequenceType == SequenceUtils.TYPE_UNKNOWN) {
                // empty if block
            }
        }
        return this.sequenceType;
    }

    public void reverseComplement(List<Sequence> seqs) {
        for (Sequence seq : seqs) {
            seq.reverseComplement();
        }
        if (seqs.size() > 0) {
            this.fireSequencesChanged(seqs);
        }
    }

    public void deleteSequence(Sequence seq) {
        this.delegateSequences.remove(seq);
        this.fireSequencesChangedAll();
    }

    public void deleteSequences(List<Sequence> toDelete) {
        for (Sequence seq : toDelete) {
            this.delegateSequences.remove(seq);
        }
        this.fireSequencesChangedAll();
    }

    public List<Sequence> deleteFullySelectedSequences() {
        List<Sequence> toDelete = this.getFullySelectedSequences();
        this.deleteSequences(toDelete);
        return toDelete;
    }

    public List<Sequence> getFullySelectedSequences() {
        ArrayList<Sequence> fullySelected = new ArrayList<Sequence>();
        for (Sequence seq : this.delegateSequences) {
            if (!seq.isAllSelected()) continue;
            fullySelected.add(seq);
        }
        return fullySelected;
    }

    public ArrayList<Sequence> deleteEmptySequences() {
        ArrayList<Sequence> toDelete = new ArrayList<Sequence>();
        for (Sequence seq : this.delegateSequences) {
            if (!seq.isEmpty()) continue;
            toDelete.add(seq);
        }
        this.deleteSequences(toDelete);
        return toDelete;
    }

    public void moveSelectedSequencesToBottom() {
        List<Sequence> selected = this.selectionModel.getSelectedSequences();
        this.moveSequencesToBottom(selected);
    }

    public void moveSelectedSequencesToTop() {
        List<Sequence> selected = this.selectionModel.getSelectedSequences();
        this.moveSequencesToTop(selected);
    }

    public void moveSelectedSequencesUp() {
        List<Sequence> selected = this.selectionModel.getSelectedSequences();
        this.moveSequencesUp(selected);
    }

    public void moveSelectedSequencesDown() {
        List<Sequence> selected = this.selectionModel.getSelectedSequences();
        this.moveSequencesDown(selected);
    }

    public void moveSelectedSequencesTo(int index) {
        List<Sequence> selected = this.selectionModel.getSelectedSequences();
        this.moveSequencesTo(index, selected);
    }

    public void moveSequencesToBottom(List<Sequence> seqs) {
        logger.info("removeAll");
        this.delegateSequences.removeAll(seqs);
        logger.info("addAll");
        this.delegateSequences.addAll(seqs);
        logger.info("seqChanged");
        if (seqs.size() > 0) {
            this.fireSequencesChangedAll();
        }
    }

    public void moveSequencesToTop(List<Sequence> seqs) {
        this.delegateSequences.removeAll(seqs);
        this.delegateSequences.addAll(0, seqs);
        if (seqs.size() > 0) {
            this.fireSequencesChangedAll();
        }
    }

    public void moveSequencesTo(int index, List<Sequence> seqs) {
        int n;
        if (index >= this.delegateSequences.size()) {
            index = this.delegateSequences.size() - 1;
        }
        if (index < 0) {
            index = 0;
        }
        int current = this.delegateSequences.indexOf(seqs.get(0));
        int diff = current - index;
        logger.info("diff" + diff);
        if (diff > 0) {
            for (n = 0; n < diff; ++n) {
                this.moveSequencesUp(seqs);
            }
        }
        if (diff < 0) {
            for (n = 0; n <= Math.abs(diff) - seqs.size(); ++n) {
                this.moveSequencesDown(seqs);
            }
        }
    }

    public void moveSequencesUp(List<Sequence> seqs) {
        Sequence seq;
        int index;
        logger.info("move seq up");
        if (seqs == null || seqs.size() == 0) {
            return;
        }
        Iterator<Sequence> iterator = seqs.iterator();
        while (iterator.hasNext() && (index = this.delegateSequences.indexOf(seq = iterator.next())) != 0) {
            Sequence previous = this.delegateSequences.set(index - 1, seq);
            this.delegateSequences.set(index, previous);
        }
        logger.info("seqs.size()" + seqs.size());
        if (seqs.size() > 0) {
            this.fireSequencesChangedAll();
        }
    }

    public void moveSequencesDown(List<Sequence> seqs) {
        Sequence seq;
        int index;
        logger.info("move seq down");
        if (seqs == null || seqs.size() == 0) {
            return;
        }
        for (int n = seqs.size() - 1; n >= 0 && (index = this.delegateSequences.indexOf(seq = seqs.get(n))) < this.delegateSequences.size() - 1; --n) {
            Sequence previous = this.delegateSequences.set(index + 1, seq);
            this.delegateSequences.set(index, previous);
        }
        logger.info("seqs.size()" + seqs.size());
        if (seqs.size() > 0) {
            this.fireSequencesChangedAll();
        }
    }

    public void writeSelectionAsFasta(Writer out) {
        List<Sequence> selectedSequences = this.selectionModel.getSelectedSequences();
        for (Sequence sequence : selectedSequences) {
            String tempSeq = sequence.getSelectedBasesAsString();
            try {
                out.append(">");
                out.append(sequence.getName());
                out.append(LF);
                out.append(sequence.getSelectedBasesAsString());
                out.append(LF);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        logger.info("Write done");
    }

    public void writeSelectedSequencesAsFasta(Writer out) {
        this.writeSelectedSequencesAsFasta(out, false);
    }

    public void writeSelectedSequencesAsFasta(Writer out, boolean useIDAsName) {
        List<Sequence> selectedSequences = this.selectionModel.getSelectedSequences();
        for (Sequence sequence : selectedSequences) {
            logger.info("has sel");
            this.writeSequenceAsFasta(sequence, out, useIDAsName);
        }
        logger.info("Write done");
    }

    private void writeSequenceAsFasta(Sequence sequence, Writer out, boolean useIDAsName) {
        try {
            out.append(">");
            if (useIDAsName) {
                out.append(Integer.toString(sequence.getID()));
            } else {
                out.append(sequence.getName());
            }
            out.append(LF);
            sequence.writeBases(out);
            out.append(LF);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeUnSelectedSequencesAsFasta(Writer out) {
        this.writeUnSelectedSequencesAsFasta(out, false);
    }

    public void writeUnSelectedSequencesAsFasta(Writer out, boolean useIDAsName) {
        List<Sequence> unSelectedSequences = this.selectionModel.getUnSelectedSequences();
        for (Sequence sequence : unSelectedSequences) {
            this.writeSequenceAsFasta(sequence, out, useIDAsName);
        }
        logger.info("Write done");
    }

    public byte getBaseAt(int x, int y) {
        return this.delegateSequences.get(y).getBaseAtPos(x);
    }

    public AminoAcid getTranslatedAminoAcidAtNucleotidePos(int x, int y) {
        return this.delegateSequences.get(y).getTranslatedAminoAcidAtNucleotidePos(x);
    }

    public int getLengthAt(int y) {
        return this.delegateSequences.get(y).getLength();
    }

    public int indexOf(Sequence seq) {
        return this.delegateSequences.indexOf(seq);
    }

    public FindObject findAndSelect(FindObject findObject) {
        if (this.isTranslated || this.getSequenceType() == SequenceUtils.TYPE_AMINO_ACID) {
            return this.findAndSelectInAASequences(findObject);
        }
        return this.findAndSelectInNucleotideSequences(findObject);
    }

    public FindObject findAndSelectALLInAASequences(FindObject findObj) {
        String regex = findObj.getRegexSearchTerm();
        Pattern pattern = Pattern.compile(regex, 2);
        findObj.setIsFound(false);
        for (int n = findObj.getNextFindSeqNumber(); n < this.getSize(); ++n) {
            Sequence seq = this.delegateSequences.get(n);
            Interval foundPos = seq.find(pattern, findObj.getNextFindStartPos());
            if (foundPos != null) {
                this.selectionModel.selectBases(seq, foundPos);
                findObj.setNextFindSeqNumber(n);
                findObj.setNextFindStartPos(Math.min(foundPos.getStartPos() + 1, this.getLongestSequenceLength() - 1));
                findObj.setFoundPos(foundPos.getStartPos(), n);
                findObj.setIsFound(true);
            }
            findObj.setNextFindStartPos(0);
        }
        findObj.setNextFindSeqNumber(0);
        findObj.setNextFindStartPos(0);
        return findObj;
    }

    public FindObject findAndSelectInAASequences(FindObject findObj) {
        String regex = findObj.getRegexSearchTerm();
        Pattern pattern = Pattern.compile(regex, 2);
        findObj.setIsFound(false);
        for (int n = findObj.getNextFindSeqNumber(); n < this.getSize(); ++n) {
            Sequence seq = this.delegateSequences.get(n);
            Interval foundPos = seq.find(pattern, findObj.getNextFindStartPos());
            if (foundPos != null) {
                this.selectionModel.selectBases(seq, foundPos);
                findObj.setNextFindSeqNumber(n);
                findObj.setNextFindStartPos(Math.min(foundPos.getStartPos() + 1, this.getLongestSequenceLength() - 1));
                findObj.setFoundPos(foundPos.getStartPos(), n);
                findObj.setIsFound(true);
                return findObj;
            }
            findObj.setNextFindStartPos(0);
        }
        findObj.setNextFindSeqNumber(0);
        findObj.setNextFindStartPos(0);
        return findObj;
    }

    public FindObject findAndSelectInNucleotideSequences(FindObject findObj) {
        String regex = findObj.getRegexSearchTerm();
        regex = regex.toLowerCase();
        regex = regex.replaceAll("w", "\\[tua\\]");
        regex = regex.replaceAll("n", "\\[agctu\\]");
        regex = regex.replaceAll("r", "\\[ag\\]");
        regex = regex.replaceAll("y", "\\[ctu\\]");
        regex = regex.replaceAll("m", "\\[ca\\]");
        regex = regex.replaceAll("k", "\\[tug\\]");
        regex = regex.replaceAll("s", "\\[cg\\]");
        regex = regex.replaceAll("b", "\\[ctug\\]");
        regex = regex.replaceAll("d", "\\[atug\\]");
        regex = regex.replaceAll("h", "\\[atuc\\]");
        regex = regex.replaceAll("v", "\\[acg\\]");
        regex = regex.replaceAll("n", "\\[agctu\\]");
        Pattern pattern = Pattern.compile(regex, 2);
        logger.info("startpos = " + findObj.getNextFindStartPos());
        findObj.setIsFound(false);
        for (int n = findObj.getNextFindSeqNumber(); n < this.getSize(); ++n) {
            Sequence seq = this.delegateSequences.get(n);
            Interval foundPos = seq.find(pattern, findObj.getNextFindStartPos());
            if (foundPos != null) {
                this.selectionModel.selectBases(seq, foundPos);
                findObj.setNextFindSeqNumber(n);
                findObj.setNextFindStartPos(Math.min(foundPos.getStartPos() + 1, this.getLongestSequenceLength() - 1));
                findObj.setFoundPos(foundPos.getStartPos(), n);
                findObj.setIsFound(true);
                return findObj;
            }
            findObj.setNextFindSeqNumber(n + 1);
            findObj.setNextFindStartPos(0);
        }
        logger.info("beforereset = " + findObj.getNextFindStartPos());
        findObj.setNextFindSeqNumber(0);
        findObj.setNextFindStartPos(0);
        return findObj;
    }

    public FindObject findInNames(FindObject findObj) {
        String uCaseSearchTerm = findObj.getSearchTerm().toUpperCase();
        if (findObj.isFindAll()) {
            findObj.clearIndices();
            for (int n = 0; n < this.delegateSequences.size(); ++n) {
                Sequence seq = this.delegateSequences.get(n);
                if (seq.getName().toUpperCase().indexOf(uCaseSearchTerm) <= -1) continue;
                logger.info("Found" + n);
                findObj.addFoundNameIndex(n);
                findObj.setIsFound(true);
            }
        } else {
            int startIndex = findObj.getNextNameFindIndex();
            if (startIndex >= this.delegateSequences.size()) {
                startIndex = 0;
            }
            findObj.clearIndices();
            for (int n = startIndex; n < this.delegateSequences.size(); ++n) {
                Sequence seq = this.delegateSequences.get(n);
                if (seq.getName().toUpperCase().indexOf(uCaseSearchTerm) <= -1) continue;
                logger.info("Found" + n);
                findObj.setFoundNameIndex(n);
                findObj.setIsFound(true);
                return findObj;
            }
        }
        return findObj;
    }

    public boolean isEditable() {
        return true;
    }

    public List<Sequence> insertGapRightOfSelectedBase(boolean undoable) {
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        Rectangle selectionBounds = this.selectionModel.getSelectionBounds();
        for (Sequence seq : selectedSeqs) {
            if (undoable) {
                editedSequences.add(seq.getCopy());
            }
            seq.insertGapRightOfSelectedBase();
        }
        if (selectedSeqs.size() == this.delegateSequences.size()) {
            int posToAdd = (int)(selectionBounds.getBounds().getMaxX() + 1.0);
            this.getAlignmentMeta().insertPosition(posToAdd);
        }
        if (selectedSeqs.size() > 0) {
            this.fireSequencesChanged(selectedSeqs);
        }
        return editedSequences;
    }

    public List<Sequence> insertGapLeftOfSelectedBase(boolean undoable) {
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        Rectangle selectionBounds = this.selectionModel.getSelectionBounds();
        for (Sequence seq : selectedSeqs) {
            if (undoable) {
                Sequence copy = seq.getCopy();
                editedSequences.add(copy);
            }
            seq.insertGapLeftOfSelectedBase();
        }
        if (selectedSeqs.size() > 0 && selectedSeqs.size() == this.delegateSequences.size()) {
            int posToAdd = (int)(selectionBounds.getBounds().getMaxX() - 1.0);
            this.getAlignmentMeta().insertPosition(posToAdd);
        }
        if (selectedSeqs.size() > 0) {
            this.fireSequencesChanged(selectedSeqs);
        }
        return editedSequences;
    }

    public List<Sequence> deleteGapMoveLeft(boolean undoable) {
        boolean gapPresentInAll = true;
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        Rectangle selectionBounds = this.selectionModel.getSelectionBounds();
        for (Sequence seq : selectedSeqs) {
            if (seq.isGapLeftOfSelection()) continue;
            gapPresentInAll = false;
            break;
        }
        if (gapPresentInAll) {
            selectedSeqs = this.selectionModel.getSelectedSequences();
            for (Sequence seq : selectedSeqs) {
                if (undoable) {
                    editedSequences.add(seq.getCopy());
                }
                seq.deleteGapLeftOfSelection();
            }
        }
        if (gapPresentInAll && selectedSeqs.size() == this.delegateSequences.size()) {
            int posToDelete = (int)(selectionBounds.getBounds().getMaxX() - 1.0);
            this.getAlignmentMeta().deletePosition(posToDelete);
        }
        if (gapPresentInAll) {
            this.fireSequencesChanged(selectedSeqs);
        }
        return editedSequences;
    }

    public List<Sequence> deleteGapMoveRight(boolean undoable) {
        boolean gapPresentInAll = true;
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        Rectangle selectionBounds = this.selectionModel.getSelectionBounds();
        for (Sequence seq : selectedSeqs) {
            if (seq.isGapRightOfSelection()) continue;
            gapPresentInAll = false;
            break;
        }
        if (gapPresentInAll) {
            selectedSeqs = this.selectionModel.getSelectedSequences();
            for (Sequence seq : selectedSeqs) {
                if (undoable) {
                    editedSequences.add(seq.getCopy());
                }
                seq.deleteGapRightOfSelection();
            }
        }
        if (gapPresentInAll && selectedSeqs.size() == this.delegateSequences.size()) {
            int posToDelete = (int)(selectionBounds.getBounds().getMaxX() + 1.0);
            this.getAlignmentMeta().deletePosition(posToDelete);
        }
        if (gapPresentInAll) {
            this.fireSequencesChanged(selectedSeqs);
        }
        return editedSequences;
    }

    public boolean isGapPresentRightOfSelection() {
        boolean gapPresentInAll = true;
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        for (Sequence seq : selectedSeqs) {
            if (seq.isGapRightOfSelection()) continue;
            gapPresentInAll = false;
            break;
        }
        return gapPresentInAll;
    }

    public boolean isGapOrEndPresentRightOfSelection() {
        boolean gapOrEndPresentInAll = true;
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        for (Sequence seq : selectedSeqs) {
            if (seq.isGapOrEndRightOfSelection()) continue;
            gapOrEndPresentInAll = false;
            break;
        }
        return gapOrEndPresentInAll;
    }

    public List<Sequence> moveSelectedResiduesRightIfGapIsPresent(boolean undoable) {
        Rectangle oldSelectRectangle = this.selectionModel.getSelectionBounds();
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        boolean wasEndRightOfSelection = false;
        if (this.isGapOrEndPresentRightOfSelection()) {
            List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
            for (Sequence seq : selectedSeqs) {
                if (undoable) {
                    editedSequences.add(seq.getCopy());
                }
                if (seq.isEndRightOfSelection()) {
                    wasEndRightOfSelection = true;
                }
                seq.moveSelectedResiduesRightIfGapOrEndIsPresent();
            }
        }
        Rectangle newSelect = this.selectionModel.getSelectionBounds();
        if (oldSelectRectangle != null) {
            newSelect.add(oldSelectRectangle);
            this.fireSequencesChanged(newSelect);
            if (wasEndRightOfSelection) {
                this.rightPadWithGapUntilEqualLength();
            }
        }
        return editedSequences;
    }

    public boolean isGapPresentLeftOfSelection() {
        boolean gapPresentInAll = true;
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        for (Sequence seq : selectedSeqs) {
            if (seq.isGapLeftOfSelection()) continue;
            gapPresentInAll = false;
            break;
        }
        return gapPresentInAll;
    }

    public List<Sequence> moveSelectedResiduesLeftIfGapIsPresent(boolean undoable) {
        Rectangle oldSelectRectangle = this.selectionModel.getSelectionBounds();
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        if (this.isGapPresentLeftOfSelection()) {
            List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
            for (Sequence seq : selectedSeqs) {
                if (undoable) {
                    editedSequences.add(seq.getCopy());
                }
                seq.moveSelectedResiduesLeftIfGapIsPresent();
            }
        }
        Rectangle newSelect = this.selectionModel.getSelectionBounds();
        if (oldSelectRectangle != null) {
            newSelect.add(oldSelectRectangle);
            this.fireSequencesChanged(newSelect);
        }
        return editedSequences;
    }

    public List<Sequence> moveSelectedResiduesIfGapIsPresent(int diff, boolean undoable) {
        int n;
        int absDiff;
        List<Sequence> editedSequences = new ArrayList<Sequence>();
        int unmovedDiff = diff - this.selectionOffset;
        if (unmovedDiff < 0) {
            absDiff = Math.abs(unmovedDiff);
            for (n = 0; n < absDiff; ++n) {
                if (editedSequences == null) {
                    editedSequences = this.moveSelectedResiduesLeftIfGapIsPresent(undoable);
                    continue;
                }
                this.moveSelectedResiduesLeftIfGapIsPresent(undoable);
            }
        }
        if (unmovedDiff > 0) {
            absDiff = Math.abs(unmovedDiff);
            for (n = 0; n < absDiff; ++n) {
                if (editedSequences == null) {
                    editedSequences = this.moveSelectedResiduesRightIfGapIsPresent(undoable);
                    continue;
                }
                this.moveSelectedResiduesRightIfGapIsPresent(undoable);
            }
        }
        this.selectionOffset = diff;
        return editedSequences;
    }

    public void realignNucleotidesUseTheseAASequenceAsTemplate(AlignmentListModel templateSeqs) throws Exception {
        this.setTranslation(true);
        for (Sequence templateSeq : templateSeqs.getDelegateSequencesCopy()) {
            Sequence nucSeq = this.getSequenceByName(templateSeq.getName());
            logger.info("nucSeq=" + nucSeq.getName() + nucSeq.getBasesAsString());
            logger.info("templateSeq=" + templateSeq.getName() + templateSeq.getBasesAsString());
            this.realignNucleotidesUseThisAASequenceAsTemplate(nucSeq, templateSeq);
        }
        this.setTranslation(false);
        this.fireSequencesChangedAll();
    }

    private void realignNucleotidesUseThisAASequenceAsTemplate(Sequence nucSeq, Sequence template) throws Exception {
        if (nucSeq instanceof InMemorySequence) {
            StringBuilder newSeq = new StringBuilder(nucSeq.getLength());
            int nextFindStartPos = 0;
            for (int n = 0; n < template.getLength(); ++n) {
                byte nextAAByte = template.getBaseAtPos(n);
                AminoAcid aaTemplate = AminoAcid.getAminoAcidFromByte(nextAAByte);
                if (aaTemplate.getCodeCharVal() == AminoAcid.GAP.getCodeCharVal()) {
                    newSeq.append('-');
                    newSeq.append('-');
                    newSeq.append('-');
                    continue;
                }
                int posFound = nucSeq.find(aaTemplate.getCodeByteVal(), nextFindStartPos);
                if (posFound == -1) {
                    logger.info("posnotfound");
                    throw new Exception("Alignments not matching-exception, when trying to align sequences");
                }
                byte[] nextNucs = nucSeq.getGapPaddedCodonInTranslatedPos(posFound);
                newSeq.append(new String(nextNucs));
                nextFindStartPos = posFound + 1;
            }
            logger.info("newSeq.length()" + newSeq.length());
            ((InMemorySequence)nucSeq).setBases(newSeq.toString().getBytes());
            this.fireSequencesChanged(nucSeq);
        }
    }

    public Sequence getSequenceByName(String name) {
        if (name == null) {
            return null;
        }
        Sequence foundSeq = null;
        for (Sequence seq : this.delegateSequences) {
            if (!name.equalsIgnoreCase(seq.getName())) continue;
            foundSeq = seq;
            break;
        }
        return foundSeq;
    }

    public ArrayList<Sequence> getSequencesByName(String name) {
        ArrayList<Sequence> foundSeqs = new ArrayList<Sequence>();
        if (name == null) {
            return foundSeqs;
        }
        for (Sequence seq : this.delegateSequences) {
            if (!name.equalsIgnoreCase(seq.getName())) continue;
            foundSeqs.add(seq);
        }
        return foundSeqs;
    }

    public void deleteAllGaps() {
        for (Sequence seq : this.delegateSequences) {
            seq.deleteAllGaps();
        }
        this.fireSequencesChangedAll();
    }

    public boolean rightPadWithGapUntilEqualLength() {
        int longLen = this.getLongestSequenceLength();
        ArrayList<Sequence> paddedSeqs = new ArrayList<Sequence>();
        for (Sequence sequence : this.delegateSequences) {
            if (sequence.getLength() >= longLen) continue;
            sequence.rightPadSequenceWithGaps(longLen);
            paddedSeqs.add(sequence);
        }
        if (paddedSeqs.size() > 0) {
            this.fireSequencesChanged(paddedSeqs);
            return true;
        }
        return false;
    }

    public boolean leftPadWithGapUntilEqualLength() {
        int longLen = this.getLongestSequenceLength();
        ArrayList<Sequence> paddedSeqs = new ArrayList<Sequence>();
        for (Sequence sequence : this.delegateSequences) {
            if (sequence.getLength() >= longLen) continue;
            sequence.leftPadSequenceWithGaps(longLen);
            paddedSeqs.add(sequence);
        }
        if (paddedSeqs.size() > 0) {
            this.fireSequencesChanged(paddedSeqs);
            return true;
        }
        return false;
    }

    public boolean rightTrimSequencesRemoveGapsUntilEqualLength() {
        boolean wasTrimmed = false;
        String cons = this.getConsensus();
        logger.info("cons=" + cons);
        if (cons.indexOf(45) > 0) {
            boolean[] deleteMask = new boolean[cons.length()];
            for (int n = deleteMask.length - 1; n >= 0 && cons.charAt(n) == '-'; --n) {
                deleteMask[n] = true;
            }
            if (ArrayUtils.contains(deleteMask, true)) {
                this.deleteBasesInAllSequencesFromMask(deleteMask);
                wasTrimmed = true;
            }
        }
        if (wasTrimmed) {
            this.fireSequencesChangedAll();
        }
        return wasTrimmed;
    }

    public void deleteBasesInAllSequencesFromMask(boolean[] deleteMask) {
        for (Sequence sequence : this.delegateSequences) {
            sequence.deleteBasesFromMask(deleteMask);
        }
        this.fireSequencesChangedAll();
    }

    public String getConsensus() {
        if (this.isTranslated || this.getSequenceType() == SequenceUtils.TYPE_AMINO_ACID) {
            return this.getAminoAcidConsensus();
        }
        return this.getNucleotideConsensus();
    }

    private String getAminoAcidConsensus() {
        byte[] consVals = new byte[this.getLongestSequenceLength()];
        Arrays.fill(consVals, AminoAcid.GAP.getCodeByteVal());
        for (Sequence sequence : this.delegateSequences) {
            for (int n = 0; n < sequence.getLength(); ++n) {
                consVals[n] = AminoAcid.getConsensusFromByteVal(sequence.getBaseAtPos(n), consVals[n]);
            }
        }
        String consAsString = new String(consVals);
        logger.info(consAsString);
        return consAsString;
    }

    private String getNucleotideConsensus() {
        int[] consVals = new int[this.getLongestSequenceLength()];
        for (Sequence sequence : this.delegateSequences) {
            int[] baseVals = sequence.getSequenceAsBaseVals();
            for (int n = 0; n < baseVals.length; ++n) {
                consVals[n] = consVals[n] | baseVals[n];
            }
        }
        char[] cons = new char[consVals.length];
        for (int n = 0; n < cons.length; ++n) {
            cons[n] = NucleotideUtilities.charFromBaseVal(consVals[n]);
        }
        return new String(cons);
    }

    public void reverseComplement() {
        for (Sequence seq : this.delegateSequences) {
            seq.reverseComplement();
        }
        this.fireSequencesChangedAll();
    }

    public void reverseComplementFullySelectedSequences() {
        List<Sequence> fullySelected = this.getFullySelectedSequences();
        for (Sequence seq : fullySelected) {
            seq.reverseComplement();
        }
        if (fullySelected.size() > 0) {
            this.fireSequencesChanged(fullySelected);
        }
    }

    public void complement() {
        for (Sequence seq : this.delegateSequences) {
            seq.complement();
        }
        this.fireSequencesChangedAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLongestSequenceName() {
        long startTime = System.currentTimeMillis();
        if (this.cachedLongestSequenceName <= 0) {
            AlignmentListModel alignmentListModel = this;
            synchronized (alignmentListModel) {
                if (this.cachedLongestSequenceName <= 0) {
                    int maxlen = 0;
                    for (Sequence seq : this.delegateSequences) {
                        maxlen = Math.max(maxlen, seq.getName().length());
                    }
                    this.cachedLongestSequenceName = maxlen;
                }
            }
        }
        long endTime = System.currentTimeMillis();
        logger.info("getLongestSequenceName took " + (endTime - startTime) + " milliseconds");
        return this.cachedLongestSequenceName;
    }

    public boolean isPositionValid(int x, int y) {
        return this.rangeCheck(x, y);
    }

    public boolean rangeCheck(int x, int y) {
        boolean isValid = false;
        if (y > -1 && y < this.delegateSequences.size() && x >= 0 && x < this.delegateSequences.get(y).getLength()) {
            isValid = true;
        }
        return isValid;
    }

    private boolean rangeCheck(Point point) {
        return this.rangeCheck(point.x, point.y);
    }

    public Sequence getSequenceByID(int id) {
        for (Sequence seq : this.delegateSequences) {
            if (seq.getID() != id) continue;
            return seq;
        }
        return null;
    }

    public void sortSequencesByName() {
        Collections.sort(this.delegateSequences);
        this.fireSequencesOrderChangedAll();
    }

    public void sortSequencesByCharInSelectedColumn(AliHistogram histogram) {
        Point selPos = this.selectionModel.getFirstSelectedPos();
        Collections.sort(this.delegateSequences, new SequencePositionComparator(selPos.x, this.getHistogram()));
        this.fireSequencesOrderChangedAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AliHistogram getHistogram() {
        if (this.cachedHistogram == null) {
            AlignmentListModel alignmentListModel = this;
            synchronized (alignmentListModel) {
                if (this.cachedHistogram == null) {
                    this.cachedHistogram = this.createHistogram();
                }
            }
        }
        return this.cachedHistogram;
    }

    private AliHistogram createHistogram() {
        long startTime = System.currentTimeMillis();
        AliHistogram histogram = null;
        histogram = this.sequenceType == SequenceUtils.TYPE_AMINO_ACID || this.isTranslated ? new AAHistogram(this.getLongestSequenceLength()) : new NucleotideHistogram(this.getLongestSequenceLength());
        for (Sequence seq : this.delegateSequences) {
            if (this.sequenceType == SequenceUtils.TYPE_AMINO_ACID || this.isTranslated) {
                histogram.addSequence(seq);
                continue;
            }
            histogram.addSequence(seq);
        }
        long endTime = System.currentTimeMillis();
        logger.info("Create histogram took " + (endTime - startTime) + " milliseconds");
        return histogram;
    }

    public List<Sequence> replaceSelectedCharactersWithThis(AlignmentListModel newOnes, boolean undoable) {
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        for (Sequence seq : selectedSeqs) {
            Sequence realignedSeq = newOnes.getSequenceByName(seq.getName());
            byte[] realignedBases = realignedSeq != null ? realignedSeq.getAllBasesAsByteArray() : SequenceUtils.createGapByteArray(newOnes.getLongestSequenceLength());
            int[] selPos = seq.getSelectedPositions();
            if (selPos.length > realignedBases.length) {
                byte[] paddedRealigned = Arrays.copyOf(realignedBases, selPos.length);
                for (int n = realignedBases.length; n < paddedRealigned.length; ++n) {
                    paddedRealigned[n] = 45;
                }
                realignedBases = paddedRealigned;
            }
            seq.replaceBases(selPos[0], selPos[selPos.length - 1], realignedBases);
            seq.setSelection(selPos[0], selPos[0] + realignedBases.length - 1, false);
            if (!undoable) continue;
            editedSequences.add(seq.getCopy());
        }
        if (selectedSeqs.size() > 0) {
            Rectangle bounds = this.selectionModel.getSelectionBounds();
            this.fireSequencesChanged(bounds);
        }
        return editedSequences;
    }

    public boolean mergeTwoSequences(InMemorySequence seq1, InMemorySequence seq2, boolean allowOverlap) {
        if (this.sequenceType == SequenceUtils.TYPE_NUCLEIC_ACID) {
            return this.mergeTwoNucleotideSequences(seq1, seq2, allowOverlap);
        }
        return this.mergeTwoAminoAcidSequences(seq1, seq2, allowOverlap);
    }

    public boolean mergeTwoAminoAcidSequences(InMemorySequence seq1, InMemorySequence seq2, boolean allowOverlap) {
        boolean isMerged = false;
        int nExactOverlap = SequenceUtils.countExactAminoAcidOverlap(seq1, seq2);
        int nDifferentOverlap = SequenceUtils.countDifferentAminoAcidOverlap(seq1, seq2);
        boolean isOverlap = false;
        boolean isOverlapExactlySame = false;
        if (nExactOverlap > 0 || nDifferentOverlap > 0) {
            isOverlap = true;
            if (nExactOverlap > 0 && nDifferentOverlap == 0) {
                isOverlapExactlySame = true;
            }
        }
        if (isOverlap) {
            String overlapMessage = "";
            if (isOverlapExactlySame) {
                overlapMessage = "Overlapping parts are identical (" + nExactOverlap + "bases)";
            } else {
                overlapMessage = "Overlapping parts are different (" + nDifferentOverlap + "/" + (nDifferentOverlap + nExactOverlap) + ")";
                overlapMessage = overlapMessage + LF + "Differences will be replaced by " + AminoAcid.X.getCodeCharVal();
            }
            String message = "Sequences are overlapping - " + overlapMessage + LF + "Do you want to continue?";
            int retVal = JOptionPane.showConfirmDialog(DialogUtils.getDialogParent(), message, "Continue?", 2);
            if (retVal != 0) {
                return false;
            }
        } else {
            String message = "Sequences are NOT overlapping" + LF + "Do you want to continue?";
            int retVal = JOptionPane.showConfirmDialog(DialogUtils.getDialogParent(), message, "Continue?", 2);
            if (retVal != 0) {
                return false;
            }
        }
        byte[] merged = new byte[seq1.getLength()];
        for (int n = 0; n < seq1.getLength(); ++n) {
            merged[n] = AminoAcid.getConsensusFromByteVal(seq1.getBaseAtPos(n), seq2.getBaseAtPos(n));
        }
        if (!isOverlap || allowOverlap) {
            seq1.setBases(merged);
            seq1.setName(seq1.getName() + "_merged_" + seq2.getName());
            seq2.setBases((byte[])merged.clone());
            seq2.setName(seq2.getName() + "_merged_" + seq1.getName());
            isMerged = true;
        }
        if (isMerged) {
            ArrayList<Sequence> mergedSeqs = new ArrayList<Sequence>(2);
            mergedSeqs.add(seq1);
            mergedSeqs.add(seq2);
            this.fireSequencesChanged(mergedSeqs);
        }
        return isMerged;
    }

    public boolean mergeTwoNucleotideSequences(InMemorySequence seq1, InMemorySequence seq2, boolean allowOverlap) {
        boolean isMerged = false;
        int nExactOverlap = SequenceUtils.countExactNucleotideOverlap(seq1, seq2);
        int nDifferentOverlap = SequenceUtils.countDifferentNucleotideOverlap(seq1, seq2);
        boolean isOverlap = false;
        boolean isOverlapExactlySame = false;
        if (nExactOverlap > 0 || nDifferentOverlap > 0) {
            isOverlap = true;
            if (nExactOverlap > 0 && nDifferentOverlap == 0) {
                isOverlapExactlySame = true;
            }
        }
        if (isOverlap) {
            String overlapMessage = "";
            overlapMessage = isOverlapExactlySame ? "Overlapping parts are identical (" + nExactOverlap + "bases)" : "Overlapping parts are different (" + nDifferentOverlap + "/" + (nDifferentOverlap + nExactOverlap) + ")";
            String message = "Sequences are overlapping - " + overlapMessage + LF + "Do you want to continue?";
            int retVal = JOptionPane.showConfirmDialog(DialogUtils.getDialogParent(), message, "Continue?", 2);
            if (retVal != 0) {
                return false;
            }
        } else {
            String message = "Sequences are NOT overlapping" + LF + "Do you want to continue?";
            int retVal = JOptionPane.showConfirmDialog(DialogUtils.getDialogParent(), message, "Continue?", 2);
            if (retVal != 0) {
                return false;
            }
        }
        byte[] merged = new byte[seq1.getLength()];
        for (int n = 0; n < seq1.getLength(); ++n) {
            merged[n] = NucleotideUtilities.getConsensusFromBases(seq1.getBaseAtPos(n), seq2.getBaseAtPos(n));
        }
        if (!isOverlap || allowOverlap) {
            seq1.setBases(merged);
            seq1.setName(seq1.getName() + "_merged_" + seq2.getName());
            seq2.setBases((byte[])merged.clone());
            seq2.setName(seq2.getName() + "_merged_" + seq1.getName());
            isMerged = true;
        }
        if (isMerged) {
            ArrayList<Sequence> mergedSeqs = new ArrayList<Sequence>(2);
            mergedSeqs.add(seq1);
            mergedSeqs.add(seq2);
            this.fireSequencesChanged(mergedSeqs);
        }
        return isMerged;
    }

    public ArrayList<Sequence> findDuplicates() {
        HashSet<Sequence> dupeSequences = new HashSet<Sequence>();
        for (int n = 0; n < this.delegateSequences.size(); ++n) {
            Sequence testSeq = this.delegateSequences.get(n);
            boolean isDupe = false;
            for (int m = n + 1; m < this.delegateSequences.size(); ++m) {
                Sequence otherSeq = this.delegateSequences.get(m);
                if (testSeq.getLength() == otherSeq.getLength()) {
                    if (!SequenceUtils.isSeqResiduesIdentical(testSeq, otherSeq)) continue;
                    dupeSequences.add(testSeq);
                    dupeSequences.add(otherSeq);
                    continue;
                }
                logger.debug("wrong len");
            }
            logger.info("dupeSequences.size()" + dupeSequences.size());
        }
        ArrayList<Sequence> dupeList = new ArrayList<Sequence>(dupeSequences);
        return dupeList;
    }

    public int size() {
        return this.delegateSequences.size();
    }

    public void sortSequencesByThisModel(AlignmentListModel prevSeqOrder) {
        ArrayList<Sequence> seqsInOrder = new ArrayList<Sequence>(prevSeqOrder.size());
        for (int n = 0; n < prevSeqOrder.getSize(); ++n) {
            Sequence prev = prevSeqOrder.get(n);
            Sequence seq = this.getSequenceByName(prev.getName());
            seqsInOrder.add(seq);
        }
        if (seqsInOrder.size() == this.delegateSequences.size()) {
            this.setSequences(seqsInOrder);
        }
        this.fireSequencesChangedAll();
    }

    public HashSet<String> findDuplicateNames() {
        HashSet<String> dupes = new HashSet<String>();
        HashSet<String> set = new HashSet<String>();
        for (Sequence seq : this.delegateSequences) {
            boolean isNotDuplicate = set.add(seq.getName());
            if (isNotDuplicate) continue;
            dupes.add(seq.getName());
        }
        return dupes;
    }

    public List<Sequence> replaceSelectedBasesWithGap(boolean undoable) {
        return this.replaceSelectedWithChar('-', undoable);
    }

    public List<Sequence> replaceSelectedWithChar(char newChar, boolean undoable) {
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        boolean wasReplaced = false;
        for (Sequence seq : selectedSeqs) {
            if (undoable) {
                editedSequences.add(seq.getCopy());
            }
            seq.replaceSelectedBasesWithChar(newChar);
            wasReplaced = true;
        }
        if (wasReplaced) {
            this.fireSequencesChanged(this.selectionModel.getSelectionBounds());
        }
        return editedSequences;
    }

    public List<Sequence> deleteSelectedBases() {
        ArrayList<Sequence> editedSequences = new ArrayList<Sequence>();
        List<Sequence> selectedSeqs = this.selectionModel.getSelectedSequences();
        for (Sequence seq : selectedSeqs) {
            editedSequences.add(seq);
            seq.deleteSelectedBases();
        }
        if (editedSequences.size() > 0) {
            this.fireSequencesChangedAll();
        }
        return editedSequences;
    }

    public ArrayList<Sequence> findAndSelectDuplicates() {
        ArrayList<Sequence> dupes = this.findDuplicates();
        this.selectionModel.selectSequences(dupes);
        return dupes;
    }

    public void selectDuplicateNamesSequences() {
        HashSet<String> dupeNames = this.findDuplicateNames();
        ArrayList<Sequence> dupeSeqs = new ArrayList<Sequence>();
        logger.debug("dupes found:" + dupeNames.size());
        for (String dupeName : dupeNames) {
            logger.debug("add all with name:" + dupeName);
            dupeSeqs.addAll(this.getSequencesByName(dupeName));
        }
        this.selectionModel.selectSequences(dupeSeqs);
    }

    public void selectEverythingWithinGaps(Point point) {
        if (!this.rangeCheck(point)) {
            return;
        }
        this.selectionModel.selectAllBasesUntilGapInThisSequence(this.delegateSequences.get(point.y), point.x);
    }

    public void selectAll(CharSet aCharSet) {
        ArrayList<Integer> columns = new ArrayList<Integer>();
        for (int n = 0; n < this.getLongestSequenceLength(); ++n) {
            if (!aCharSet.contains(n)) continue;
            columns.add(new Integer(n));
        }
        if (columns.size() > 0) {
            this.selectionModel.clearSequenceSelection();
            this.selectionModel.selectColumns(columns);
        }
    }

    public int getSelectedColumnCount() {
        return this.selectionModel.getSelectedColumnCount();
    }

    public int getSelectedSequencesCount() {
        return this.selectionModel.getSelectedSequencesCount();
    }

    public List<Sequence> getSelectedSequences() {
        return this.selectionModel.getSelectedSequences();
    }

    public String getSelectionNames() {
        return this.selectionModel.getSelectionNames();
    }

    public int getFirstSelectedWholeColumn() {
        return this.selectionModel.getFirstSelectedWholeColumn();
    }

    public int getLastSelectedWholeColumn() {
        return this.selectionModel.getLastSelectedWholeColumn();
    }

    public void setSelectionOffset(int i) {
        this.selectionOffset = i;
    }

    public String getSelectionAsNucleotides() {
        return this.selectionModel.getSelectionAsNucleotides();
    }

    public int getFirstSelectedSequenceIndex() {
        return this.selectionModel.getFirstSelectedSequenceIndex();
    }

    public int getLastSelectedSequenceIndex() {
        return this.selectionModel.getLastSelectedSequenceIndex();
    }

    public String getFirstSelectedName() {
        return this.selectionModel.getFirstSelectedName();
    }

    public List<Sequence> setFirstSelectedName(String newName) {
        return this.selectionModel.setFirstSelectedName(newName);
    }

    public Sequence getFirstSelected() {
        return this.selectionModel.getFirstSelected();
    }

    public boolean hasSelection() {
        return this.selectionModel.hasSelection();
    }

    public void selectAll() {
        this.selectionModel.selectAll();
    }

    public void selectionExtendRight() {
        this.selectionModel.selectionExtendRight();
    }

    public void selectionExtendLeft() {
        this.selectionModel.selectionExtendLeft();
    }

    public void selectionExtendDown() {
        this.selectionModel.selectionExtendDown();
    }

    public void selectionExtendTop() {
        this.selectionModel.selectionExtendTop();
    }

    public void invertSelection() {
        this.selectionModel.invertSelection();
    }

    public void copySelectionFromInto(int indexFrom, int indexTo) {
        this.selectionModel.copySelectionFromInto(indexFrom, indexTo);
    }

    public void selectColumn(int columnIndex) {
        this.selectionModel.selectColumn(columnIndex);
    }

    public void clearColumnSelection(int columnIndex) {
        this.selectionModel.clearColumnSelection(columnIndex);
    }

    public void copySelectionFromPosX1toX2(int x1, int x2) {
        this.selectionModel.copySelectionFromPosX1toX2(x1, x2);
    }

    public Point getFirstSelectedPos() {
        return this.selectionModel.getFirstSelectedPos();
    }

    public Point getLastSelectedPos() {
        return this.selectionModel.getLastSelectedPos();
    }

    public Point getFirstSelectedUngapedPos() {
        return this.selectionModel.getFirstSelectedUngapedPos();
    }

    public void setSelectionWithin(Rectangle bounds) {
        this.selectionModel.setSelectionWithin(bounds);
    }

    public void selectSequencesByName(String name) {
        ArrayList<Sequence> foundSeqs = this.getSequencesByName(name);
        this.selectionModel.selectSequences(foundSeqs);
    }

    public ArrayList<Integer> getIndicesOfSequencesWithSelection() {
        return this.selectionModel.getIndicesOfSequencesWithSelection();
    }

    public ArrayList<Integer> getIndicesOfSequencesWithAllSelected() {
        return this.selectionModel.getIndicesOfSequencesWithAllSelected();
    }

    public void selectSequencesWithIndex(List<Integer> listVals) {
        this.selectionModel.selectSequencesWithIndex(listVals);
    }

    public void selectSequencesWithIndex(int[] selectedIndex) {
        this.selectionModel.selectSequencesWithIndex(selectedIndex);
    }

    public void clearSequenceSelection() {
        this.selectionModel.clearSequenceSelection();
    }

    public void selectSequenceWithIndex(int y) {
        this.selectionModel.selectSequenceWithIndex(y);
    }

    public boolean isBaseSelected(int x, int y) {
        return this.selectionModel.isBaseSelected(x, y);
    }

    public void setSelectionAt(int xPos, int yPos, boolean clearFirst) {
        this.selectionModel.setSelectionAt(xPos, yPos, clearFirst);
    }

    public long getSelectionSize() {
        return this.selectionModel.getSelectionSize();
    }

    public boolean hasFullySelectedSequences() {
        return this.selectionModel.hasFullySelectedSequences();
    }

    public AlignmentSelectionModel getAlignmentSelectionModel() {
        return this.selectionModel;
    }

    public void setTempSelection(Rectangle selectRectMatrixCoords) {
        this.selectionModel.setTempSelection(selectRectMatrixCoords);
    }

    public Rectangle getTempSelection() {
        return this.selectionModel.getTempSelection();
    }

    public void clearTempSelection() {
        this.selectionModel.clearTempSelection();
    }

    public void clearAllSelectionInSequenceWithIndex(int y) {
        this.selectionModel.clearAllSelectionInSequenceWithIndex(y);
    }

    public void addAlignmentSelectionListener(AlignmentSelectionListener listener) {
        this.selectionModel.addAlignmentSelectionListener(listener);
    }

    private void fireSequencesChanged(Sequence seq) {
        int index = this.delegateSequences.indexOf(seq);
        this.fireSequencesChanged(index, index);
    }

    private void fireSequencesChanged(List<Sequence> seqs) {
        int minIndex = this.delegateSequences.size();
        int maxIndex = 0;
        for (Sequence seq : seqs) {
            int index = this.delegateSequences.indexOf(seq);
            minIndex = Math.min(index, minIndex);
            maxIndex = Math.max(index, maxIndex);
        }
        this.fireSequencesChanged(minIndex, maxIndex);
    }

    private void fireSequencesChanged(int minIndex, int maxIndex) {
        this.cachedLongestSequenceLength = -1;
        Rectangle rect = new Rectangle(0, minIndex, this.getLongestSequenceLength(), maxIndex + 1);
        this.fireSequencesChanged(rect);
    }

    private void fireSequencesChanged(Rectangle rect) {
        this.sequencesChanged(rect);
    }

    private void sequencesChanged(Rectangle rect) {
        logger.info("sequencesChanged");
        this.cachedLongestSequenceName = -1;
        this.cachedLongestSequenceLength = -1;
        this.cachedHistogram = null;
        Object[] listeners = this.listenerList.getListenerList();
        AlignmentDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            logger.info("listeners[i]" + listeners[i]);
            if (listeners[i] == AlignmentDataListener.class) {
                if (e == null) {
                    e = new AlignmentDataEvent(this, 0, rect);
                }
                ((AlignmentDataListener)listeners[i + 1]).contentsChanged(e);
                continue;
            }
            if (listeners[i] != ListDataListener.class) continue;
            if (e == null) {
                e = new AlignmentDataEvent(this, 0, rect);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    private void fireSequencesChangedAll() {
        this.fireSequencesChanged(0, this.size() - 1);
    }

    private void fireSequencesOrderChangedAll() {
        this.fireSequencesChanged(0, this.size() - 1);
    }

    private void fireSequencesChangedAllNew() {
        this.fireSequencesChanged(0, this.size() - 1);
    }

    private void fireSequenceIntervalRemoved(int index0, int index1) {
        this.fireSequencesChanged(index0, index1);
    }

    private void fireSequenceIntervalAdded(int index0, int index1) {
        if (index0 < 0 || index1 < 0) {
            return;
        }
        this.fireSequencesChanged(index0, index1);
    }

    public void setTranslation(boolean shouldTrans) {
        if (shouldTrans != this.isTranslated) {
            if (shouldTrans) {
                this.selectionModel.translateSelection(this.getAlignment().getAlignmentMeta());
            } else {
                this.selectionModel.reTranslateSelection(this.getAlignment().getAlignmentMeta());
            }
            this.isTranslated = shouldTrans;
            this.fireSequencesChangedAll();
        }
    }

    public AlignmentMeta getAlignmentMeta() {
        if (this.getAlignment() != null) {
            return this.getAlignment().getAlignmentMeta();
        }
        return null;
    }

    private Alignment getAlignment() {
        return this.alignment;
    }

    public boolean isTranslated() {
        return this.isTranslated;
    }

    public Rectangle getSelectionBounds() {
        return this.selectionModel.getSelectionBounds();
    }

    public void setAlignment(Alignment alignment) {
        this.alignment = alignment;
    }

    public void setSequenceType(int sequenceType) {
        this.sequenceType = sequenceType;
    }

    public void terminalGAPtoMissing() {
        for (Sequence seq : this.delegateSequences) {
            seq.terminalGAPtoMissing();
        }
        this.fireSequencesChangedAll();
    }

    public void missingToGAP() {
        for (Sequence seq : this.delegateSequences) {
            seq.missingToGAP();
        }
        this.fireSequencesChangedAll();
    }

    public boolean isEqualLength() {
        int longLen = this.getLongestSequenceLength();
        for (Sequence sequence : this.delegateSequences) {
            if (sequence.getLength() >= longLen) continue;
            return false;
        }
        return true;
    }
}

