/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.sequencelist.AlignmentSelectionModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class SequenceListSelectionModel
extends DefaultListSelectionModel {
    private static final Logger logger = Logger.getLogger(SequenceListSelectionModel.class);
    private AlignmentSelectionModel aliSelectionModel;

    public SequenceListSelectionModel(AlignmentSelectionModel aliSelectionModel) {
        this.aliSelectionModel = aliSelectionModel;
        super.setSelectionMode(2);
    }

    public boolean isSelectedIndex(int index) {
        return this.aliSelectionModel.isSequenceAtLeastPartlySelected(index);
    }

    public void setSelectionInterval(int index0, int index1) {
        logger.info("setSelectionInterval index0=" + index0 + " index1=" + index1);
        super.setSelectionInterval(index0, index1);
        this.aliSelectionModel.setSequenceSelection(index0, index1);
    }

    public void clearSelection() {
        logger.info("clear selection");
    }

    public void addSelectionInterval(int index0, int index1) {
        super.addSelectionInterval(index0, index1);
        logger.info("addSelectionInterval ix0=" + index0 + " ix1=" + index1);
        logger.info("addSelectionInterval getValueIsAdjusting=" + this.getValueIsAdjusting());
        int minIndex = Math.min(index0, index1);
        int maxIndex = Math.max(index0, index1);
        boolean shouldChange = false;
        for (int n = minIndex; n <= maxIndex; ++n) {
            if (this.aliSelectionModel.isSequenceAtLeastPartlySelected(n)) continue;
            shouldChange = true;
        }
        if (shouldChange) {
            this.aliSelectionModel.addSequenceSelection(index0, index1);
        }
    }

    public void removeSelectionInterval(int index0, int index1) {
        logger.info("removeSelectionInterval");
        super.removeSelectionInterval(index0, index1);
        this.aliSelectionModel.removeSequenceSelection(index0, index1);
    }

    public int getMinSelectionIndex() {
        logger.info("getMinSelectionIndex=" + this.aliSelectionModel.getFirstSelectedSequenceIndex());
        int minPos = this.aliSelectionModel.getFirstSelectedSequenceIndex();
        return minPos;
    }

    public int getMaxSelectionIndex() {
        logger.info("getMaxSelectionIndex" + this.aliSelectionModel.getLastSelectedSequenceIndex());
        int maxPos = this.aliSelectionModel.getLastSelectedSequenceIndex();
        return maxPos;
    }

    public int getAnchorSelectionIndex() {
        logger.info("getAnchorSelectionIndex" + super.getAnchorSelectionIndex());
        int anchorIndex = super.getAnchorSelectionIndex();
        if (anchorIndex == -1) {
            anchorIndex = this.aliSelectionModel.getFirstSelectedSequenceIndex();
        }
        logger.info("anchorIndex" + anchorIndex);
        return anchorIndex;
    }

    public void setAnchorSelectionIndex(int anchorIndex) {
        logger.info("setAnchorSelectionIndex" + anchorIndex);
        super.setAnchorSelectionIndex(anchorIndex);
    }

    public int getLeadSelectionIndex() {
        logger.info("getLeadSelectionIndex" + super.getLeadSelectionIndex());
        return super.getLeadSelectionIndex();
    }

    public void setLeadSelectionIndex(int leadIndex) {
        logger.info("setLeadSelectionIndex");
        super.setLeadSelectionIndex(leadIndex);
    }

    public boolean isSelectionEmpty() {
        return super.isSelectionEmpty();
    }

    public void insertIndexInterval(int index, int length, boolean before) {
        logger.info("insertIndexInterval index=" + index + " length" + length);
    }

    public void removeIndexInterval(int index0, int index1) {
        logger.info("removeIndexInterval");
    }

    public void setValueIsAdjusting(boolean isAdjusting) {
        logger.info("setValueIsAdjusting");
        super.setValueIsAdjusting(isAdjusting);
    }

    public boolean getValueIsAdjusting() {
        logger.info("getValueIsAdjusting");
        return super.getValueIsAdjusting();
    }

    public void setSelectionMode(int selectionMode) {
        super.setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return super.getSelectionMode();
    }

    public void addListSelectionListener(ListSelectionListener l) {
        super.addListSelectionListener(l);
    }

    public void removeListSelectionListener(ListSelectionListener l) {
        super.removeListSelectionListener(l);
    }
}

