/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequencelist;

import aliview.AliViewWindow;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.SequenceJList;
import aliview.sequences.Sequence;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.activation.ActivationDataFlavor;
import javax.activation.DataHandler;
import javax.swing.DropMode;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.TransferHandler;
import org.apache.log4j.Logger;

public class SequenceTransferHandler
extends TransferHandler {
    private static final Logger logger = Logger.getLogger(SequenceTransferHandler.class);
    private int[] rows = null;
    private int addIndex = -1;
    private int addCount = 0;
    private final DataFlavor LOCAL_OBJECT_FLAVOR = new ActivationDataFlavor(Object[].class, "application/x-java-jvm-local-objectref", "Array of items");
    private Object[] transferedObjects = null;
    private JComponent source = null;
    private AliViewWindow aliWindow;

    public SequenceTransferHandler(AliViewWindow aliWindow) {
        this.aliWindow = aliWindow;
    }

    protected Transferable createTransferable(JComponent c) {
        logger.info("create Transferable");
        this.source = c;
        JList list = (JList)c;
        AlignmentListModel model = (AlignmentListModel)list.getModel();
        ArrayList<Sequence> transObjs = new ArrayList<Sequence>();
        for (Object obj : list.getSelectedValues()) {
            logger.info(obj);
            transObjs.add((Sequence)obj);
        }
        this.transferedObjects = transObjs.toArray();
        return new DataHandler(this.transferedObjects, this.LOCAL_OBJECT_FLAVOR.getMimeType());
    }

    public boolean canImport(TransferHandler.TransferSupport info) {
        boolean isSupported = false;
        if (info.isDataFlavorSupported(this.LOCAL_OBJECT_FLAVOR)) {
            isSupported = true;
            ((JList)info.getComponent()).setDropMode(DropMode.INSERT);
        }
        if (info.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
            isSupported = true;
            ((JList)info.getComponent()).setDropMode(DropMode.ON);
        }
        return true;
    }

    public int getSourceActions(JComponent c) {
        return 3;
    }

    public boolean importData(TransferHandler.TransferSupport info) {
        try {
            Transferable tr = info.getTransferable();
            if (tr.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List fileList = (List)info.getTransferable().getTransferData(DataFlavor.javaFileListFlavor);
                this.aliWindow.fileDropped(fileList, info.getDropAction());
            } else if (tr.isDataFlavorSupported(this.LOCAL_OBJECT_FLAVOR)) {
                SequenceJList targetList = (SequenceJList)info.getComponent();
                JList.DropLocation dl = (JList.DropLocation)info.getDropLocation();
                AlignmentListModel model = targetList.getModel();
                int index = dl.getIndex();
                logger.info("drop location index" + index);
                logger.info("import");
                Object[] values = (Object[])info.getTransferable().getTransferData(this.LOCAL_OBJECT_FLAVOR);
                logger.info("" + this.source + targetList + values);
                logger.info("target index" + targetList.getSelectedIndex());
                if (this.source == targetList) {
                    logger.info("to index" + index);
                    this.aliWindow.moveSelectedTo(index);
                }
            }
            return true;
        }
        catch (UnsupportedFlavorException ufe) {
            ufe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return false;
    }

    protected void exportDone(JComponent c, Transferable t, int act) {
        logger.info("exportDone");
    }
}

