/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.AminoAcid;
import aliview.NucleotideUtilities;
import aliview.sequencelist.AlignmentListModel;
import aliview.sequencelist.Interval;
import aliview.sequences.AminoAcidAndPosition;
import aliview.sequences.Bases;
import aliview.sequences.DefaultSequenceSelectionModel;
import aliview.sequences.Sequence;
import aliview.sequences.SequenceSelectionModel;
import aliview.sequences.SequenceUtils;
import aliview.sequences.TranslatedBases;
import aliview.utils.ArrayUtilities;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicSequence
implements Sequence,
Comparable<Sequence> {
    private static final Logger logger = Logger.getLogger(BasicSequence.class);
    private boolean simpleName = false;
    public int selectionOffset = 0;
    protected Bases bases;
    protected TranslatedBases translatedBases;
    protected SequenceSelectionModel selectionModel;
    private AlignmentListModel alignmentModel;
    protected String name;
    protected int id;

    public BasicSequence() {
        this.id = SequenceUtils.createID();
        this.selectionModel = new DefaultSequenceSelectionModel();
    }

    public BasicSequence(Bases bases) {
        this();
        this.bases = bases;
    }

    public BasicSequence(BasicSequence template) {
        this.name = template.name;
        this.id = template.id;
        this.bases = template.getNonTranslatedBases().getCopy();
        this.alignmentModel = template.alignmentModel;
        this.selectionModel = this.createNewSelectionModel();
    }

    @Override
    public Sequence getCopy() {
        return new BasicSequence(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getSimpleName() {
        return this.name;
    }

    public boolean isTranslated() {
        if (this.getAlignmentModel() != null) {
            return this.getAlignmentModel().isTranslated();
        }
        return false;
    }

    @Override
    public int getLength() {
        return this.getBases().getLength();
    }

    @Override
    public int getNonTranslatedLength() {
        return this.getNonTranslatedBases().getLength();
    }

    @Override
    public byte[] getGapPaddedCodonInTranslatedPos(int pos) {
        return this.getTranslatedBases().getGapPaddedCodonInTranslatedPos(pos);
    }

    @Override
    public boolean isCodonSecondPos(int pos) {
        return this.getTranslatedBases().isCodonSecondPos(pos);
    }

    protected Bases getBases() {
        if (this.isTranslated()) {
            return this.getTranslatedBases();
        }
        return this.bases;
    }

    protected Bases getNonTranslatedBases() {
        return this.bases;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TranslatedBases getTranslatedBases() {
        if (this.translatedBases == null) {
            BasicSequence basicSequence = this;
            synchronized (basicSequence) {
                if (this.translatedBases == null) {
                    this.translatedBases = new TranslatedBases(this.bases, this);
                }
            }
        }
        return this.translatedBases;
    }

    public SequenceSelectionModel createNewSelectionModel() {
        return new DefaultSequenceSelectionModel();
    }

    @Override
    public int countStopCodon() {
        return this.getTranslatedBases().countStopCodon();
    }

    @Override
    public AminoAcid getTranslatedAminoAcidAtNucleotidePos(int x) {
        return this.getTranslatedBases().getAminoAcidAtNucleotidePos(x);
    }

    @Override
    public AminoAcidAndPosition getNoGapAminoAcidAtNucleotidePos(int target) {
        return this.getTranslatedBases().getNoGapAminoAcidAtNucleotidePos(target);
    }

    @Override
    public byte getBaseAtPos(int n) {
        return this.getBases().get(n);
    }

    @Override
    public char getCharAtPos(int n) {
        return (char)this.getBaseAtPos(n);
    }

    @Override
    public boolean isBaseSelected(int n) {
        return this.selectionModel.isSelected(n);
    }

    @Override
    public void clearAllSelection() {
        this.selectionModel.clearAll();
    }

    @Override
    public void selectAllBases() {
        this.selectionModel.selectAll();
    }

    @Override
    public long countSelectedPositions(int startIndex, int endIndex) {
        return this.selectionModel.countSelectedPositions(startIndex, endIndex);
    }

    @Override
    public String getSelectedBasesAsString() {
        StringBuilder selection = new StringBuilder();
        if (this.selectionModel.hasSelection()) {
            for (int n = 0; n < this.getBases().getLength(); ++n) {
                if (!this.selectionModel.isSelected(n)) continue;
                selection.append(this.getBases().charAt(n));
            }
        }
        return selection.toString();
    }

    @Override
    public byte[] getSelectedBasesAsByte() {
        byte[] bases = null;
        bases = this.getSelectedBasesAsString().toString().getBytes();
        return bases;
    }

    @Override
    public String getBasesAsString() {
        String baseString = "";
        baseString = this.bases.toString();
        return baseString;
    }

    @Override
    public void writeBases(OutputStream out) throws IOException {
        int length = this.getBases().getLength();
        for (int n = 0; n < length; ++n) {
            out.write(this.getBases().get(n));
        }
    }

    @Override
    public void writeBases(Writer out) throws IOException {
        int length = this.getBases().getLength();
        for (int n = 0; n < length; ++n) {
            out.write(this.getBases().get(n));
        }
    }

    @Override
    public void writeBasesBetween(int start, int end, Writer out) throws IOException {
        for (int n = start; n <= end; ++n) {
            out.write(this.getBases().charAt(n));
        }
    }

    public void toggleSimpleName() {
        this.simpleName = !this.simpleName;
    }

    public String toString() {
        if (this.simpleName) {
            return this.getSimpleName();
        }
        return this.getName();
    }

    @Override
    public Interval find(Pattern pattern, int startPos) {
        String basesAsString = this.getBases().toString();
        Matcher matcher = pattern.matcher(basesAsString);
        Interval foundInterval = null;
        boolean wasFound = matcher.find(startPos);
        if (wasFound) {
            int foundStart = matcher.start();
            int foundEnd = matcher.end() - 1;
            foundInterval = new Interval(foundStart, foundEnd);
        }
        return foundInterval;
    }

    @Override
    public int find(byte find, int startPos) {
        for (int n = startPos; n < this.getBases().getLength(); ++n) {
            if (find != this.getBases().get(n)) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int getFirstSelectedPosition() {
        return this.selectionModel.getFirstSelectedPosition();
    }

    @Override
    public int getLastSelectedPosition() {
        return this.selectionModel.getLastSelectedPosition(this.getLength());
    }

    @Override
    public void replaceSelectedBasesWithGap() {
        this.replaceSelectedBasesWithChar('-');
    }

    @Override
    public void replaceSelectedBasesWithChar(char newChar) {
        byte newBase = (byte)newChar;
        if (this.hasSelection()) {
            for (int n = 0; n < this.getBases().getLength(); ++n) {
                if (!this.isBaseSelected(n)) continue;
                this.getBases().set(n, newBase);
            }
        }
    }

    @Override
    public int[] getSequenceAsBaseVals() {
        int[] baseVals = new int[this.getBases().getLength()];
        for (int n = 0; n < this.getBases().getLength(); ++n) {
            baseVals[n] = NucleotideUtilities.baseValFromChar((char)this.getBases().get(n));
        }
        return baseVals;
    }

    @Override
    public void insertGapLeftOfSelectedBase() {
        int position = this.getFirstSelectedPosition();
        if (this.rangeCheck(position)) {
            this.insertGapAt(position);
        }
    }

    @Override
    public void insertGapRightOfSelectedBase() {
        int position = this.getLastSelectedPosition();
        if (this.rangeCheck(position + 1)) {
            this.insertGapAt(position + 1);
        }
    }

    @Override
    public boolean isGapRightOfSelection() {
        return this.isGapRightOfSelection(1);
    }

    @Override
    public boolean isEndRightOfSelection() {
        int rightSelected = this.getLastSelectedPosition();
        return rightSelected + 1 == this.getLength();
    }

    @Override
    public boolean isGapOrEndRightOfSelection() {
        if (this.isEndRightOfSelection()) {
            return true;
        }
        return this.isGapRightOfSelection();
    }

    @Override
    public boolean isGapLeftOfSelection() {
        return this.isGapLeftOfSelection(1);
    }

    public boolean isGapRightOfSelection(int offset) {
        boolean isGap = false;
        int rightSelected = this.getLastSelectedPosition();
        if (this.rangeCheck(rightSelected) && this.rangeCheck(rightSelected + offset) && NucleotideUtilities.isGap(this.getBaseAtPos(rightSelected + offset))) {
            isGap = true;
        }
        return isGap;
    }

    public boolean isGapLeftOfSelection(int offset) {
        boolean isGap = false;
        int leftSelected = this.getFirstSelectedPosition();
        if (this.rangeCheck(leftSelected) && this.rangeCheck(leftSelected - offset) && NucleotideUtilities.isGap(this.getBaseAtPos(leftSelected - offset))) {
            isGap = true;
        }
        return isGap;
    }

    @Override
    public void deleteGapLeftOfSelection() {
        int leftPosition = this.getFirstSelectedPosition();
        if (this.rangeCheck(leftPosition - 1) && NucleotideUtilities.isGap(this.getBaseAtPos(leftPosition - 1))) {
            this.deleteBase(leftPosition - 1);
        }
    }

    @Override
    public void deleteGapRightOfSelection() {
        int rightPosition = this.getLastSelectedPosition();
        if (this.rangeCheck(rightPosition + 1) && NucleotideUtilities.isGap(this.getBaseAtPos(rightPosition + 1))) {
            this.deleteBase(rightPosition + 1);
        }
    }

    public void moveSelectionRightIfGapOrEndIsPresent(int steps) {
        for (int m = 0; m < steps; ++m) {
            int leftPosition = this.getFirstSelectedPosition();
            int rightPosition = this.getLastSelectedPosition();
            if (!this.isGapOrEndRightOfSelection()) continue;
            for (int n = rightPosition; n >= leftPosition; --n) {
                this.getBases().moveBaseRight(n);
                if (this.isBaseSelected(n)) {
                    this.setSelectionAt(n + 1);
                    continue;
                }
                this.clearSelectionAt(n + 1);
            }
            this.getBases().set(leftPosition, '-');
            this.clearSelectionAt(leftPosition);
        }
    }

    public void moveSelectionLeftIfGapIsPresent(int steps) {
        for (int m = 0; m < steps; ++m) {
            int leftPosition = this.getFirstSelectedPosition();
            int rightPosition = this.getLastSelectedPosition();
            if (!this.rangeCheck(leftPosition - 1) || !this.rangeCheck(rightPosition) || !this.isGapLeftOfSelection()) continue;
            for (int n = leftPosition; n <= rightPosition; ++n) {
                this.getBases().moveBaseLeft(n);
                if (this.isBaseSelected(n)) {
                    this.setSelectionAt(n - 1);
                    continue;
                }
                this.clearSelectionAt(n - 1);
            }
            this.getBases().set(rightPosition, '-');
            this.clearSelectionAt(rightPosition);
        }
    }

    @Override
    public void moveSelectedResiduesRightIfGapOrEndIsPresent() {
        this.moveSelectionRightIfGapOrEndIsPresent(1);
    }

    @Override
    public void moveSelectedResiduesLeftIfGapIsPresent() {
        this.moveSelectionLeftIfGapIsPresent(1);
    }

    @Override
    public void insertGapAt(int n) {
        this.getBases().insertAt(n, (byte)45);
        this.selectionModel.insertNewPosAt(n);
    }

    @Override
    public int[] getSelectedPositions() {
        return this.selectionModel.getSelectedPositions(0, this.getLength() - 1);
    }

    @Override
    public void replaceBases(int startReplaceIndex, int stopReplaceIndex, byte[] insertBases) {
        this.getBases().replace(startReplaceIndex, stopReplaceIndex, insertBases);
    }

    @Override
    public void setSelectionAt(int i) {
        this.selectionModel.setSelectionAt(i);
    }

    @Override
    public void clearSelectionAt(int i) {
        this.selectionModel.clearSelectionAt(i);
    }

    @Override
    public void setSelection(int startIndex, int endIndex, boolean clearFirst) {
        startIndex = Math.max(0, startIndex);
        endIndex = Math.min(this.getLength() - 1, endIndex);
        this.selectionModel.setSelection(startIndex, endIndex, clearFirst);
    }

    private boolean rangeCheck(int pos) {
        return this.bases != null && pos >= 0 && pos < this.bases.getLength();
    }

    @Override
    public void deleteSelectedBases() {
        int[] toDelete = this.selectionModel.getSelectedPositions(0, this.getLength() - 1);
        this.getBases().delete(toDelete);
        this.createNewSelectionModel();
    }

    public void deleteBase(int index) {
        this.getBases().delete(index);
        this.selectionModel.removePosition(index);
    }

    @Override
    public void reverseComplement() {
        this.reverse();
        this.complement();
    }

    @Override
    public void complement() {
        this.getBases().complement();
    }

    public void reverse() {
        this.getBases().reverse();
    }

    @Override
    public void rightPadSequenceWithGaps(int finalLength) {
        int addCount = finalLength - this.getBases().getLength();
        if (addCount > 0) {
            byte[] additional = new byte[addCount];
            Arrays.fill(additional, (byte)45);
            this.getBases().append(additional);
        }
    }

    @Override
    public void leftPadSequenceWithGaps(int finalLength) {
        int addCount = finalLength - this.getBases().getLength();
        if (addCount > 0) {
            byte[] additional = new byte[addCount];
            Arrays.fill(additional, (byte)45);
            this.getBases().insertAt(0, additional);
        }
    }

    public String getCitatedName() {
        String name = this.getName();
        name = StringUtils.remove(name, '\'');
        logger.info(name);
        name = StringUtils.remove(name, '\"');
        name = StringUtils.remove(name, '>');
        name = "'" + name + "'";
        return name;
    }

    @Override
    public String getBasesAtThesePosAsString(ArrayList<Integer> allWantedPos) {
        StringBuilder allPos = new StringBuilder();
        for (Integer aPos : allWantedPos) {
            allPos.append((char)this.getBaseAtPos(aPos));
        }
        return allPos.toString();
    }

    @Override
    public void deleteBasesFromMask(boolean[] mask) {
        int n;
        int nTruePos = ArrayUtilities.count(mask, true);
        int[] toDelete = new int[nTruePos];
        int deleteCount = 0;
        for (n = 0; n < this.getBases().getLength() && n < mask.length; ++n) {
            if (!mask[n]) continue;
            toDelete[deleteCount] = n;
            ++deleteCount;
        }
        this.getBases().delete(toDelete);
        for (n = mask.length - 1; n >= 0; --n) {
            if (!mask[n]) continue;
            this.selectionModel.removePosition(n);
        }
    }

    public void append(String moreInterleavedsequence) {
        this.getBases().append(moreInterleavedsequence.getBytes());
    }

    @Override
    public boolean hasSelection() {
        return this.selectionModel.hasSelection();
    }

    @Override
    public void clearBase(int pos) {
        this.getBases().set(pos, (byte)45);
    }

    @Override
    public byte[] getAllBasesAsByteArray() {
        return this.getBases().toByteArray();
    }

    @Override
    public byte[] getBasesBetween(int startIndexInclusive, int endIndexInclusive) {
        return this.getBases().toByteArray(startIndexInclusive, endIndexInclusive);
    }

    @Override
    public boolean isEmpty() {
        boolean isEmpty = true;
        for (int n = 0; n < this.getBases().getLength(); ++n) {
            if (this.getBaseAtPos(n) == 45 || this.getBaseAtPos(n) == 63) continue;
            isEmpty = false;
            break;
        }
        return isEmpty;
    }

    @Override
    public int getUngapedLength() {
        return this.getUngapedPos(this.getLength());
    }

    @Override
    public int compareTo(Sequence other) {
        return this.getName().compareTo(other.getName());
    }

    @Override
    public int getUngapedPos(int position) {
        int posCount = 0;
        int gapCount = 0;
        for (int n = 0; n <= position; ++n) {
            if (NucleotideUtilities.isGap(this.getBaseAtPos(n))) {
                ++gapCount;
            } else {
                ++posCount;
            }
            if (!Thread.interrupted()) continue;
            return -1;
        }
        return posCount;
    }

    public String getUngapedSequence() {
        StringBuilder ungapedSeq = new StringBuilder(this.getLength());
        for (int n = 0; n < this.getLength(); ++n) {
            byte base = this.getBaseAtPos(n);
            if (NucleotideUtilities.isGap(base)) continue;
            ungapedSeq.append((char)base);
        }
        return ungapedSeq.toString();
    }

    @Override
    public void selectAllBasesUntilGap(int x) {
        int n;
        for (n = x; n < this.getLength() && !NucleotideUtilities.isGap(this.getBaseAtPos(n)); ++n) {
            this.setSelectionAt(n);
        }
        for (n = x; n >= 0 && !NucleotideUtilities.isGap(this.getBaseAtPos(n)); --n) {
            this.setSelectionAt(n);
        }
    }

    @Override
    public void selectionExtendRight() {
        if (this.hasSelection()) {
            int lastSelectedPos = this.getLastSelectedPosition();
            int seqEndPos = this.getLength() - 1;
            this.setSelection(lastSelectedPos, seqEndPos, true);
        }
    }

    @Override
    public void selectionExtendLeft() {
        if (this.hasSelection()) {
            int firstSelectedPos = this.getLastSelectedPosition();
            this.setSelection(0, firstSelectedPos, true);
        }
    }

    @Override
    public void invertSelection() {
        this.selectionModel.invertSelection(this.getLength());
    }

    @Override
    public void deleteAllGaps() {
        this.getNonTranslatedBases().deleteAll((byte)45);
        this.createNewSelectionModel();
    }

    @Override
    public int getID() {
        return this.id;
    }

    @Override
    public int getPosOfSelectedIndex(int posInSeq) {
        return this.selectionModel.countPositionsUntilSelectedCount(posInSeq);
    }

    @Override
    public boolean isAllSelected() {
        return this.selectionModel.isAllSelected();
    }

    @Override
    public int countChar(char targetChar) {
        int count = 0;
        for (int n = 0; n < this.getBases().getLength(); ++n) {
            if (this.getCharAtPos(n) != targetChar) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean contains(char testChar) {
        boolean contains = false;
        for (int n = 0; n < this.getBases().getLength(); ++n) {
            if (this.getCharAtPos(n) != testChar) continue;
            contains = true;
            break;
        }
        return contains;
    }

    @Override
    public int indexOf(char testChar) {
        for (int n = 0; n < this.getBases().getLength(); ++n) {
            if (this.getCharAtPos(n) != testChar) continue;
            return n;
        }
        return -1;
    }

    @Override
    public int countChar(char targetChar, int startpos, int endpos) {
        int count = 0;
        for (int n = startpos; n < endpos && n < this.getBases().getLength(); ++n) {
            if (targetChar != this.getBases().charAt(n)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void setAlignmentModel(AlignmentListModel model) {
        this.alignmentModel = model;
    }

    @Override
    public AlignmentListModel getAlignmentModel() {
        return this.alignmentModel;
    }

    @Override
    public void terminalGAPtoMissing() {
        int n;
        for (n = 0; n < this.getBases().getLength() && (this.getCharAtPos(n) == '?' || this.getCharAtPos(n) == '-'); ++n) {
            this.getBases().set(n, (byte)63);
        }
        for (n = this.getBases().getLength() - 1; n >= 0 && (this.getCharAtPos(n) == '?' || this.getCharAtPos(n) == '-'); --n) {
            this.getBases().set(n, (byte)63);
        }
    }

    @Override
    public void missingToGAP() {
        for (int n = 0; n < this.getBases().getLength(); ++n) {
            if (this.getCharAtPos(n) != '?') continue;
            this.getBases().set(n, (byte)45);
        }
    }
}

