/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.NucleotideUtilities;
import aliview.sequences.Bases;
import aliview.utils.ArrayUtilities;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Arrays;
import org.apache.commons.lang.ArrayUtils;
import org.apache.log4j.Logger;

public class DefaultBases
implements Bases {
    private static final Logger logger = Logger.getLogger(DefaultBases.class);
    private static final String TEXT_FILE_BYTE_ENCODING = "ASCII";
    byte[] backend;

    public DefaultBases(byte[] bytes) {
        this.backend = bytes;
    }

    public DefaultBases getCopy() {
        return new DefaultBases(ArrayUtils.clone(this.backend));
    }

    public int getLength() {
        return this.backend.length;
    }

    public byte get(int n) {
        return this.backend[n];
    }

    public char charAt(int n) {
        return (char)this.backend[n];
    }

    public byte[] toByteArray() {
        return this.backend;
    }

    public byte[] toByteArray(int startIndexInclusive, int endIndexInclusive) {
        byte[] subArray = ArrayUtils.subarray(this.backend, startIndexInclusive, endIndexInclusive + 1);
        return subArray;
    }

    public String toString() {
        String asString = null;
        try {
            asString = new String(this.backend, TEXT_FILE_BYTE_ENCODING);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return asString;
    }

    public void writeBasesBetween(int start, int end, Writer out) throws IOException {
        String outString = new String(this.toByteArray(start, end), TEXT_FILE_BYTE_ENCODING);
        out.write(outString);
    }

    public void set(int n, byte newBase) {
        this.assureSize(n);
        this.backend[n] = newBase;
    }

    private void assureSize(int n) {
        if (n >= this.backend.length) {
            this.resize(n + 1);
        }
    }

    private void resize(int n) {
        logger.info("resize=" + n);
        int additionalCount = n - this.backend.length;
        byte[] additional = new byte[additionalCount];
        Arrays.fill(additional, (byte)45);
        this.backend = ArrayUtils.addAll(this.backend, additional);
        logger.info("backend.length=" + this.backend.length);
    }

    public void append(byte[] newBytes) {
        this.backend = ArrayUtils.addAll(this.backend, newBytes);
    }

    public void moveBaseLeft(int n) {
        this.set(n - 1, this.get(n));
    }

    public void moveBaseRight(int n) {
        this.set(n + 1, this.get(n));
    }

    public void insertAt(int n, byte[] newBytes) {
        this.assureSize(n - 1);
        byte[] newArray = ArrayUtilities.insertAt(this.backend, n, newBytes);
        this.backend = newArray;
    }

    public void replace(int startReplaceIndex, int stopReplaceIndex, byte[] insertBases) {
        int newLength = this.backend.length - (stopReplaceIndex + 1 - startReplaceIndex) + insertBases.length;
        byte[] newBases = new byte[newLength];
        System.arraycopy(this.backend, 0, newBases, 0, startReplaceIndex);
        System.arraycopy(insertBases, 0, newBases, startReplaceIndex, insertBases.length);
        if (stopReplaceIndex < this.backend.length - 1) {
            System.arraycopy(this.backend, stopReplaceIndex + 1, newBases, startReplaceIndex + insertBases.length, this.backend.length - (stopReplaceIndex + 1));
        }
        this.backend = newBases;
    }

    public void deleteAll(byte target) {
        int count = 0;
        for (int n = 0; n < this.backend.length; ++n) {
            if (this.backend[n] != target) continue;
            ++count;
        }
        if (count > 0) {
            byte[] newBackend = new byte[this.backend.length - count];
            int index = 0;
            for (byte next : this.backend) {
                if (next == target) continue;
                newBackend[index] = next;
                ++index;
            }
            this.backend = newBackend;
        }
    }

    public void delete(int[] toDelete) {
        if (toDelete == null || toDelete.length == 0) {
            return;
        }
        Arrays.sort(toDelete);
        int nOutOfBounds = 0;
        for (int n = 0; n < toDelete.length; ++n) {
            if (toDelete[n] >= 0 && toDelete[n] < this.backend.length) continue;
            ++nOutOfBounds;
        }
        byte[] newBases = new byte[this.backend.length - toDelete.length + nOutOfBounds];
        int newIndex = 0;
        int deleteCount = 0;
        int nextToDelete = toDelete[deleteCount];
        for (int n = 0; n < this.backend.length; ++n) {
            if (n == nextToDelete) {
                if (++deleteCount < toDelete.length) {
                    nextToDelete = toDelete[deleteCount];
                    continue;
                }
                nextToDelete = -1;
                continue;
            }
            newBases[newIndex] = this.backend[n];
            ++newIndex;
        }
        this.backend = newBases;
    }

    public void complement() {
        NucleotideUtilities.complement(this.backend);
    }

    public void reverse() {
        ArrayUtils.reverse(this.backend);
    }

    public void set(int n, char c) {
        this.set(n, (byte)c);
    }

    public void delete(int pos) {
        this.delete(new int[]{pos});
    }

    public void insertAt(int n, byte newByte) {
        this.insertAt(n, new byte[]{newByte});
    }
}

