/*
 * Decompiled with CFR 0.152.
 */
package aliview.sequences;

import aliview.sequences.PositionToPointer;
import java.util.ArrayList;

public class PositionsToPointer {
    ArrayList<PositionToPointer> posToPointerList = new ArrayList();
    private PositionToPointer cachedPosToPoint;

    public PositionsToPointer getCopy() {
        PositionsToPointer copy = new PositionsToPointer();
        copy.posToPointerList = new ArrayList();
        for (PositionToPointer next : this.posToPointerList) {
            copy.posToPointerList.add(next.getCopy());
        }
        return copy;
    }

    public void add(PositionToPointer posToPoint) {
        this.posToPointerList.add(posToPoint);
    }

    public long getPointerFromPos(int pos) {
        long pointer = -1L;
        if (this.cachedPosToPoint != null) {
            pointer = this.cachedPosToPoint.getPointer(pos);
        }
        if (pointer == -1L) {
            this.cachedPosToPoint = this.getPosToPointerContaining(pos);
            pointer = this.cachedPosToPoint.getPointer(pos);
        }
        return pointer;
    }

    private PositionToPointer getPosToPointerContaining(int pos) {
        for (PositionToPointer posPoint : this.posToPointerList) {
            if (!posPoint.containsPos(pos)) continue;
            return posPoint;
        }
        return null;
    }

    public int getMaxPosition() {
        PositionToPointer lastPosPoint = this.posToPointerList.get(this.posToPointerList.size() - 1);
        return lastPosPoint.getEndPos();
    }

    public long getMaxPointer() {
        PositionToPointer lastPosPoint = this.posToPointerList.get(this.posToPointerList.size() - 1);
        return lastPosPoint.getEndPointer();
    }
}

