/*
 * Decompiled with CFR 0.152.
 */
package aliview.test;

import java.awt.Font;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Locale;
import sun.font.CompositeFont;
import sun.font.Font2D;
import sun.font.PhysicalFont;

public class FontTester {
    public static void main(String ... args) throws Exception {
        Font font = new Font("Serif", 0, 12);
        FontTester.describeFont(font);
        Font font2 = new Font("Monospaced", 0, 12);
        FontTester.describeFont(font2);
    }

    private static void describeFont(Font font) throws Exception {
        Method method = font.getClass().getDeclaredMethod("getFont2D", new Class[0]);
        method.setAccessible(true);
        Font2D f = (Font2D)method.invoke((Object)font, new Object[0]);
        FontTester.describeFont2D(f);
    }

    private static void describeFont2D(Font2D font) throws Exception {
        if (font instanceof CompositeFont) {
            System.out.println("Font '" + font.getFontName(Locale.getDefault()) + "' is composed of:");
            CompositeFont cf = (CompositeFont)font;
            for (int i = 0; i < cf.getNumSlots(); ++i) {
                PhysicalFont pf = cf.getSlotFont(i);
                FontTester.describeFont2D(pf);
            }
        } else {
            Class<?> clazz = Class.forName("sun.font.CFont");
            Field field = clazz.getDeclaredField("nativeFontName");
            field.setAccessible(true);
            String nativeFontName = (String)field.get(font);
            System.out.println("-> " + nativeFontName);
        }
    }
}

