/*
 * Decompiled with CFR 0.152.
 */
package aliview.test;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.BitSet;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.apache.commons.lang.math.IntRange;
import org.apache.log4j.Logger;
import utils.nexus.NexusRange;

public class Test
implements Cloneable {
    private static final Logger logger = Logger.getLogger(Test.class);
    private static final String NUM_ROWS = "num_rows";
    private static final String NUM_COLS = "num_cols";
    public int[] array = new int[]{12, 13, 19};
    private static byte[] testByte = "GTCACCGGCA".getBytes();
    private static String testString = "GTCACCGGCA";

    public static void main(String[] args) throws CloneNotSupportedException {
        int a = 0;
        logger.info(a % 4);
        a = 1;
        logger.info(a % 4);
        a = 4;
        logger.info(a % 4);
        NexusRange range = new NexusRange(new IntRange(64, 80), 3, 1);
        int n = 64;
        int posInRange = n - range.getMinimumInt();
        int rest = posInRange % range.getSteps();
        logger.info("rest=" + rest);
        n = 3029;
        int startVal = 1;
        int pos = 5;
        startVal = 2;
        int start = 0;
        int diff = -5;
        diff = Math.abs(diff);
        int posVal = (startVal - 1 + diff) % 3 + 1;
        posVal = 4 - Math.abs(posVal);
        logger.info(posVal);
        int endPos = Integer.MAX_VALUE;
        int startCorrected = 0;
        int val = (int)Math.ceil((double)(endPos - startCorrected + 1) / 3.0);
        logger.info(val);
        logger.info("((pos - start) % 3) + startVal=" + ((pos - start) % 3 + startVal));
        Test.testAlphaColor();
        Test t1 = new Test();
        Test tClone = (Test)t1.clone();
        t1.array[1] = 15;
        logger.info(tClone.array[1]);
        String[] splitted = "kjs   \t sdkj".split("\\s+");
        logger.info(splitted.length);
    }

    private static void testAlphaColor() {
        Color test = new Color(1, 1, 10, 0);
        logger.info("test.getAlpha()" + test.getAlpha());
        logger.info(test.getRGB());
        logger.info(Test.addTranspGrey(-687486, 0.45));
    }

    public static int getGolorVal(int r, int g, int b, int a) {
        int rgba = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return rgba;
    }

    public static int addTranspGrey(int inVal, double transp) {
        int a = 255;
        int r = (int)((double)Test.getRed(inVal) * transp);
        int g = (int)((double)Test.getGreen(inVal) * transp);
        int b = (int)((double)Test.getBlue(inVal) * transp);
        int rgba = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | (b & 0xFF) << 0;
        return rgba;
    }

    public static int getRed(int colVal) {
        return colVal >> 16 & 0xFF;
    }

    public static int getGreen(int colVal) {
        return colVal >> 8 & 0xFF;
    }

    public static int getBlue(int colVal) {
        return colVal >> 0 & 0xFF;
    }

    public static int getAlpha(int colVal) {
        return colVal >> 24 & 0xFF;
    }

    public static void buildTestFasta() throws IOException {
        File fasta = new File("/vol2/big_data/test-wide.fasta");
        BufferedWriter out = new BufferedWriter(new FileWriter(fasta));
        for (int i = 0; i < 500; ++i) {
            out.write(">Testseq-" + i + "\n");
            for (int n = 0; n < 1000000; ++n) {
                out.write(testString);
            }
            out.write(10);
            logger.info("done with seq" + i);
        }
    }

    private static void testBitSet() {
        BitSet bitSelection = new BitSet();
        bitSelection.set(8);
        logger.info(bitSelection.length());
        logger.info(bitSelection.get(4));
        logger.info(bitSelection.length());
        logger.info(bitSelection.get(100));
        logger.info(bitSelection.length());
        bitSelection.set(100);
        logger.info(bitSelection.length());
        bitSelection.set(98, true);
        bitSelection.set(90, true);
        logger.info(bitSelection.length());
        bitSelection.set(100, false);
        logger.info(bitSelection.length());
    }

    private void testFileDialog() {
        Frame f = new Frame();
        FileDialog fd = new FileDialog(f, "Hej", 0);
        fd.setDirectory("/home/anders/_ormbunkar");
        fd.setLocation(100, 100);
        fd.setSize(600, 600);
        fd.setFile("");
        fd.setVisible(true);
        File selectedFile = new File(fd.getFile());
    }

    private static void showMemStats() {
        int mb = 0x100000;
        Runtime runtime = Runtime.getRuntime();
        System.out.println("##### Heap utilization statistics [MB] #####");
        System.out.println("Used Memory:" + (runtime.totalMemory() - runtime.freeMemory()) / (long)mb);
        System.out.println("Free Memory:" + runtime.freeMemory() / (long)mb);
        System.out.println("Total Memory:" + runtime.totalMemory() / (long)mb);
        System.out.println("Max Memory:" + runtime.maxMemory() / (long)mb);
    }

    private void testprefs() {
        Preferences prefs = Preferences.userNodeForPackage(Test.class);
        int numRows = prefs.getInt(NUM_ROWS, 40);
        int numCols = prefs.getInt(NUM_COLS, 80);
        logger.info(numRows);
        logger.info(numCols);
        prefs.putInt(NUM_ROWS, 30);
        prefs.put("Another", "hejHopp");
        prefs.put("Third", "tree");
        try {
            prefs.flush();
        }
        catch (BackingStoreException e1) {
            e1.printStackTrace();
        }
        try {
            Thread.sleep(1000000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void testBitwise() {
        int x = 7;
        System.out.println("" + x);
        System.out.println(7);
    }

    public static void runJavascript() {
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName("JavaScript");
        try {
            engine.eval("print('Welocme to java world')");
        }
        catch (ScriptException e) {
            e.printStackTrace();
        }
    }

    public static void testArray() {
        long startTime = System.nanoTime();
        int size = 10000000;
        byte[] array = new byte[size];
        byte[] toarray = new byte[size];
        for (int n = 0; n < array.length; ++n) {
            toarray[n] = array[n];
        }
        long endTime = System.nanoTime();
        System.out.println("That took " + (endTime - startTime) + " nanoseconds");
        startTime = System.nanoTime();
        System.arraycopy(array, 0, toarray, 0, size);
        endTime = System.nanoTime();
        System.out.println("That took " + (endTime - startTime) + " nanoseconds");
        logger.info(1);
        logger.info(System.getProperty("java.io.tmpdir"));
        logger.info(Math.abs(2) + 1);
        int readingFrame = 3;
        int wantedFrame = 2;
        int startPos = 146;
        int offset = readingFrame - wantedFrame;
        int invertedOffset = 3 - offset;
        offset = invertedOffset % 3;
        logger.info(startPos += offset);
    }
}

