/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.Align;
import jebl.evolution.align.Output;
import jebl.evolution.align.Traceback;
import jebl.evolution.align.TracebackSimple;
import jebl.evolution.align.scores.Scores;

abstract class AlignSimple
extends Align {
    float[][] F = null;
    TracebackSimple[][] B;

    public AlignSimple(Scores sub, float d) {
        super(sub, d);
    }

    public abstract void doAlignment(String var1, String var2);

    public void prepareAlignment(String sq1, String sq2) {
        if (this.F == null) {
            this.n = sq1.length();
            this.m = sq2.length();
            this.seq1 = this.strip(sq1);
            this.seq2 = this.strip(sq2);
            this.F = new float[this.n + 1][this.m + 1];
            this.B = new TracebackSimple[this.n + 1][this.m + 1];
            int i = 0;
            while (i < this.n + 1) {
                int j = 0;
                while (j < this.m + 1) {
                    this.B[i][j] = new TracebackSimple(0, 0);
                    ++j;
                }
                ++i;
            }
        } else if (this.seq1.length() <= this.n && this.seq2.length() <= this.m) {
            this.n = sq1.length();
            this.m = sq2.length();
            this.seq1 = this.strip(sq1);
            this.seq2 = this.strip(sq2);
        } else {
            this.n = sq1.length();
            this.m = sq2.length();
            this.seq1 = this.strip(sq1);
            this.seq2 = this.strip(sq2);
            this.F = new float[this.n + 1][this.m + 1];
            this.B = new TracebackSimple[this.n + 1][this.m + 1];
            int i = 0;
            while (i < this.n + 1) {
                int j = 0;
                while (j < this.m + 1) {
                    this.B[i][j] = new TracebackSimple(0, 0);
                    ++j;
                }
                ++i;
            }
        }
    }

    public Traceback next(Traceback tb) {
        TracebackSimple tb2 = (TracebackSimple)tb;
        if (tb.i == 0 && tb.j == 0 && this.B[tb2.i][tb2.j].i == 0 && this.B[tb2.i][tb2.j].j == 0 || tb.i == -1) {
            return null;
        }
        return this.B[tb2.i][tb2.j];
    }

    public float getScore() {
        return this.F[this.B0.i][this.B0.j];
    }

    public void printf(Output out) {
        int j = 0;
        while (j <= this.m) {
            int i = 0;
            while (i < this.F.length) {
                float[] f = this.F[i];
                out.print(AlignSimple.padLeft(this.formatScore(f[j]), 5));
                ++i;
            }
            out.println();
            ++j;
        }
    }
}

