/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.align.AlignmentResult;
import jebl.evolution.align.ProfileCharacter;
import jebl.evolution.alignments.Alignment;
import jebl.evolution.sequences.Sequence;

class Profile {
    ProfileCharacter[] profile;
    private final int alphabetSize;
    int sequenceCount;
    private boolean automaticallyCalculatedAlphabetSize = false;
    private Map<Integer, String> paddedSequences = new HashMap<Integer, String>();
    private boolean supportsFreeEndGaps = false;
    private boolean isImmutable = false;

    public String getSequence(int sequenceNumber) {
        return this.paddedSequences.get(sequenceNumber);
    }

    public Profile(int alphabetSize) {
        this.alphabetSize = alphabetSize;
        if (alphabetSize < 0) {
            throw new IllegalArgumentException("Nonnegative alphabet size expected, got " + alphabetSize);
        }
    }

    public Profile(int sequenceNumber, String sequence) {
        this(Profile.calculateAlphabetSize(new String[]{sequence}));
        this.addSequence(sequenceNumber, sequence);
        this.automaticallyCalculatedAlphabetSize = true;
    }

    public static Profile createImmutableProfile(int sequenceNumber, String sequence) {
        int alphabetSize = Profile.calculateAlphabetSize(new String[]{sequence});
        Profile profile = new Profile(alphabetSize);
        profile.isImmutable = true;
        profile.automaticallyCalculatedAlphabetSize = true;
        profile.sequenceCount = 1;
        sequence = sequence.toUpperCase();
        profile.paddedSequences.put(sequenceNumber, sequence);
        int length = sequence.length();
        profile.profile = new ProfileCharacter[length];
        int i = 0;
        while (i < length) {
            profile.profile[i] = ProfileCharacter.getImmutableProfileCharacter(sequence.charAt(i));
            ++i;
        }
        return profile;
    }

    private void assertMutable() {
        if (this.isImmutable) {
            throw new IllegalArgumentException("This profile is immutable");
        }
    }

    public Profile(Alignment alignment, int alphabetSize) {
        this(alignment, alphabetSize, 0);
    }

    public Profile(Alignment alignment, int alphabetSize, int offset) {
        this.alphabetSize = alphabetSize;
        List<Sequence> sequenceList = alignment.getSequenceList();
        int i = 0;
        while (i < sequenceList.size()) {
            this.addSequence(i + offset, sequenceList.get(i).getString());
            ++i;
        }
    }

    public int getNumberOfSequences() {
        return this.sequenceCount;
    }

    public int length() {
        return this.profile.length;
    }

    private static ProfileCharacter[] createProfile(String sequence, int alphabetSize) {
        int length = sequence.length();
        ProfileCharacter[] results = new ProfileCharacter[length];
        int i = 0;
        while (i < length) {
            ProfileCharacter profile = new ProfileCharacter(alphabetSize);
            profile.addCharacter(sequence.charAt(i), 1);
            results[i] = profile;
            ++i;
        }
        return results;
    }

    void addSequence(int sequenceNumber, String sequence) {
        this.assertMutable();
        sequence = sequence.toUpperCase();
        if (this.automaticallyCalculatedAlphabetSize) {
            throw new IllegalStateException("if the constructor 'public Profile(int sequenceNumber,String sequence)'  is used, it's not safe to add new sequences");
        }
        if (this.supportsFreeEndGaps) {
            sequence = Profile.supportFreeEndGaps(sequence);
        }
        ++this.sequenceCount;
        if (this.sequenceCount == 1) {
            this.profile = Profile.createProfile(sequence, this.alphabetSize);
        } else {
            assert (this.profile.length == sequence.length());
            int i = 0;
            while (i < this.profile.length) {
                ProfileCharacter character = this.profile[i];
                character.addCharacter(sequence.charAt(i), 1);
                ++i;
            }
        }
        this.paddedSequences.put(sequenceNumber, sequence);
    }

    public void remove(Profile remove) {
        this.assertMutable();
        int size = this.length();
        assert (size == remove.length());
        int i = 0;
        while (i < size) {
            this.profile[i].removeProfileCharacter(remove.profile[i]);
            ++i;
        }
        this.sequenceCount -= remove.sequenceCount;
        for (Integer sequenceNumber : remove.paddedSequences.keySet()) {
            this.paddedSequences.remove(sequenceNumber);
        }
        this.trim();
    }

    private void trim() {
        this.assertMutable();
        int gapCount = 0;
        int count = 0;
        ProfileCharacter[] profileCharacterArray = this.profile;
        int n = this.profile.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileCharacter character = profileCharacterArray[n2];
            if (character.isAllGaps()) {
                ++gapCount;
            } else {
                ++count;
            }
            ++n2;
        }
        if (gapCount == 0) {
            return;
        }
        ProfileCharacter[] characters = new ProfileCharacter[count];
        char[][] sequences = new char[this.sequenceCount][];
        char[][] newSequences = new char[this.sequenceCount][];
        int[] sequenceNumbers = new int[this.sequenceCount];
        int i = 0;
        while (i < this.sequenceCount) {
            newSequences[i] = new char[count];
            ++i;
        }
        i = 0;
        for (Map.Entry<Integer, String> entry : this.paddedSequences.entrySet()) {
            sequenceNumbers[i] = entry.getKey();
            sequences[i++] = entry.getValue().toCharArray();
        }
        assert (i == this.sequenceCount);
        int index = 0;
        int sourceIndex = 0;
        ProfileCharacter[] profileCharacterArray2 = this.profile;
        int n3 = this.profile.length;
        int n4 = 0;
        while (n4 < n3) {
            ProfileCharacter character = profileCharacterArray2[n4];
            if (character.isAllGaps()) {
                ++sourceIndex;
            } else {
                characters[index] = character;
                int j = 0;
                while (j < this.sequenceCount) {
                    newSequences[j][index] = sequences[j][sourceIndex];
                    ++j;
                }
                ++sourceIndex;
                ++index;
            }
            ++n4;
        }
        int j = 0;
        while (j < this.sequenceCount) {
            String sequence = new String(newSequences[j]);
            assert (sequence.length() == count);
            this.paddedSequences.put(sequenceNumbers[j], sequence);
            ++j;
        }
        this.profile = characters;
    }

    public static Profile combine(Profile profile1, Profile profile2, AlignmentResult result1, AlignmentResult result2) {
        String sequence;
        int size = result1.size;
        int alphabetSize = Math.max(profile1.alphabetSize, profile2.alphabetSize);
        Profile result = new Profile(alphabetSize);
        result.profile = new ProfileCharacter[size];
        int index1 = 0;
        int index2 = 0;
        int i = 0;
        while (i < size) {
            ProfileCharacter character = new ProfileCharacter(alphabetSize);
            if (result1.values[i]) {
                character.addProfileCharacter(profile1.profile[index1++]);
            } else {
                character.addGaps(profile1.sequenceCount);
            }
            if (result2.values[i]) {
                character.addProfileCharacter(profile2.profile[index2++]);
            } else {
                character.addGaps(profile2.sequenceCount);
            }
            result.profile[i] = character;
            ++i;
        }
        for (Map.Entry<Integer, String> entry : profile1.paddedSequences.entrySet()) {
            sequence = entry.getValue();
            sequence = Profile.buildAlignmentString(sequence, result1);
            result.paddedSequences.put(entry.getKey(), sequence);
        }
        for (Map.Entry<Integer, String> entry : profile2.paddedSequences.entrySet()) {
            sequence = entry.getValue();
            sequence = Profile.buildAlignmentString(sequence, result2);
            result.paddedSequences.put(entry.getKey(), sequence);
        }
        result.sequenceCount = profile1.sequenceCount + profile2.sequenceCount;
        assert (result.sequenceCount == result.paddedSequences.size());
        return result;
    }

    public static int calculateAlphabetSize(String[] sequences) {
        int total = 0;
        boolean[] found = new boolean[127];
        String[] stringArray = sequences;
        int n = sequences.length;
        int n2 = 0;
        while (n2 < n) {
            String sequence = stringArray[n2];
            char[] cArray = sequence.toCharArray();
            int n3 = cArray.length;
            int n4 = 0;
            while (n4 < n3) {
                char character = cArray[n4];
                if (!found[character]) {
                    ++total;
                }
                found[character] = true;
                ++n4;
            }
            ++n2;
        }
        return total;
    }

    public static String buildAlignmentString(String sequence, AlignmentResult result) {
        StringBuilder builder = new StringBuilder();
        int index = 0;
        int i = 0;
        while (i < result.size) {
            if (result.values[i]) {
                builder.append(sequence.charAt(index++));
            } else {
                builder.append('-');
            }
            ++i;
        }
        assert (index == sequence.length());
        return builder.toString();
    }

    public void print(boolean displaySequences) {
        if (displaySequences) {
            int maximum = 0;
            int k = 0;
            while (k < this.paddedSequences.size()) {
                String sequence = this.paddedSequences.get(k);
                maximum = Math.max(maximum, sequence.length());
                System.out.println(sequence);
                ++k;
            }
            int i = 0;
            while (i < maximum) {
                System.out.print(i % 10);
                ++i;
            }
        }
        System.out.println();
        int count = 0;
        int index = 0;
        ProfileCharacter[] profileCharacterArray = this.profile;
        int n = this.profile.length;
        int n2 = 0;
        while (n2 < n) {
            ProfileCharacter character = profileCharacterArray[n2];
            System.out.print(" " + index++ + ":");
            if ((count += character.print()) > 800000) {
                count = 0;
                System.out.println();
            }
            ++n2;
        }
        System.out.println();
    }

    public String toString(int offset, int count) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        while (i < count) {
            ProfileCharacter character = this.profile[offset + i];
            result.append(character.toString());
            ++i;
        }
        return result.toString();
    }

    static String supportFreeEndGaps(String sequence) {
        char[] characters = sequence.toCharArray();
        int count = characters.length;
        int highestNonGapIndex = 0;
        int lowestNonGapIndex = count;
        int i = 0;
        while (i < count) {
            if (characters[i] != '-') {
                lowestNonGapIndex = i;
                break;
            }
            ++i;
        }
        i = count - 1;
        while (i >= 0) {
            if (characters[i] != '-') {
                highestNonGapIndex = i;
                break;
            }
            --i;
        }
        StringBuilder result = new StringBuilder(count);
        int i2 = 0;
        while (i2 < count) {
            if (i2 < lowestNonGapIndex || i2 > highestNonGapIndex) {
                result.append('_');
            } else {
                result.append(characters[i2]);
            }
            ++i2;
        }
        return result.toString();
    }

    public Profile supportFreeEndGaps() {
        if (this.supportsFreeEndGaps) {
            return this;
        }
        if (this.sequenceCount < 2) {
            return this;
        }
        Profile result = new Profile(this.alphabetSize + 1);
        result.supportsFreeEndGaps = true;
        for (Map.Entry<Integer, String> entry : this.paddedSequences.entrySet()) {
            String sequence = entry.getValue();
            result.addSequence(entry.getKey(), sequence);
        }
        return result;
    }
}

