/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align;

import jebl.evolution.align.AlignLinearSpace;
import jebl.evolution.align.NeedlemanWunschLinearSpace;
import jebl.evolution.align.TracebackPlotter;
import jebl.evolution.align.TracebackSimple;
import jebl.evolution.align.scores.Scores;

public class SmithWatermanLinearSpace
extends AlignLinearSpace {
    TracebackSimple[][] start = null;
    float maxval;
    int start1;
    int start2;
    int end1;
    int end2;

    public SmithWatermanLinearSpace(Scores sub, float d) {
        super(sub, d);
    }

    public void doAlignment(String sq1, String sq2) {
        super.prepareAlignment(sq1, sq2);
        int n = this.n;
        int m = this.m;
        float[][] score = this.sub.score;
        this.start = new TracebackSimple[2][sq2.length() + 1];
        char[] s1 = sq1.toCharArray();
        char[] s2 = sq2.toCharArray();
        this.maxval = Float.NEGATIVE_INFINITY;
        int j = 0;
        while (j <= m) {
            this.start[1][j] = new TracebackSimple(0, j);
            ++j;
        }
        int i = 1;
        while (i <= n) {
            SmithWatermanLinearSpace.swap01((Object[])this.F);
            SmithWatermanLinearSpace.swap01((Object[])this.start);
            this.start[1][0] = new TracebackSimple(i, 0);
            int j2 = 1;
            while (j2 <= m) {
                float val;
                float s = score[s1[i - 1]][s2[j2 - 1]];
                this.F[1][j2] = val = SmithWatermanLinearSpace.max(0.0f, this.F[0][j2 - 1] + s, this.F[0][j2] - this.d, this.F[1][j2 - 1] - this.d);
                if (val == 0.0f) {
                    this.start[1][j2] = new TracebackSimple(i, j2);
                } else if (val == this.F[0][j2 - 1] + s) {
                    this.start[1][j2] = this.start[0][j2 - 1];
                } else if (val == this.F[0][j2] - this.d) {
                    this.start[1][j2] = this.start[0][j2];
                } else if (val == this.F[1][j2 - 1] - this.d) {
                    this.start[1][j2] = this.start[1][j2 - 1];
                } else {
                    throw new Error("SWSmart 1");
                }
                if (val > this.maxval) {
                    this.maxval = val;
                    TracebackSimple sij = this.start[1][j2];
                    this.start1 = sij.i;
                    this.start2 = sij.j;
                    this.end1 = i;
                    this.end2 = j2;
                }
                ++j2;
            }
            ++i;
        }
    }

    public float getScore() {
        return this.maxval;
    }

    public String[] getMatch() {
        String subseq1 = this.seq1.substring(this.start1, this.end1);
        String subseq2 = this.seq2.substring(this.start2, this.end2);
        NeedlemanWunschLinearSpace nwls1 = new NeedlemanWunschLinearSpace(this.sub, this.d);
        nwls1.doAlignment(subseq1, subseq2);
        return nwls1.getMatch();
    }

    public void traceback(TracebackPlotter plotter) {
        String subseq1 = this.seq1.substring(this.start1, this.end1);
        String subseq2 = this.seq2.substring(this.start2, this.end2);
        NeedlemanWunschLinearSpace nwls1 = new NeedlemanWunschLinearSpace(this.sub, this.d);
        nwls1.doAlignment(subseq1, subseq2);
        nwls1.traceback(plotter, this.start1, this.start2, this.seq1, this.seq2);
    }
}

