/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.align.scores;

import jebl.evolution.align.scores.AminoAcidScores;
import jebl.evolution.align.scores.NucleotideScores;
import jebl.evolution.align.scores.ScoreMatrix;

public abstract class Scores
implements ScoreMatrix {
    public float[][] score;
    private String extraResidues = "";

    protected void buildScores(float[][] scores) {
        String states = this.getAlphabet().toUpperCase();
        this.score = new float[127][127];
        int i = 0;
        while (i < states.length()) {
            char a = states.charAt(i);
            char lca = Character.toLowerCase(a);
            int j = 0;
            while (j <= i) {
                char b = states.charAt(j);
                char lcb = Character.toLowerCase(b);
                float f = scores[i][j];
                this.score[lcb][lca] = f;
                this.score[lca][lcb] = f;
                this.score[b][lca] = f;
                this.score[lca][b] = f;
                this.score[lcb][a] = f;
                this.score[a][lcb] = f;
                this.score[b][a] = f;
                this.score[a][b] = f;
                ++j;
            }
            ++i;
        }
    }

    void buildScores(float match, float mismatch) {
        int states = this.getAlphabet().length();
        float[][] scores = new float[states][states];
        int i = 0;
        while (i < states) {
            int j = 0;
            while (j < states) {
                scores[i][j] = i == j ? match : mismatch;
                ++j;
            }
            ++i;
        }
        this.buildScores(scores);
    }

    public final float getScore(char x, char y) {
        return this.score[x][y];
    }

    public String toString() {
        String name = this.getClass().getName();
        return name.substring(name.lastIndexOf(".") + 1);
    }

    public static Scores forMatrix(ScoreMatrix scoreMatrix) {
        final String alphabet = scoreMatrix.getAlphabet();
        final String name = scoreMatrix.getName();
        float[][] scores = new float[alphabet.length()][alphabet.length()];
        int i = 0;
        while (i < alphabet.length()) {
            char a = alphabet.charAt(i);
            int j = 0;
            while (j < alphabet.length()) {
                char b = alphabet.charAt(j);
                scores[i][j] = scoreMatrix.getScore(a, b);
                ++j;
            }
            ++i;
        }
        Scores result = new Scores(){

            public String getAlphabet() {
                return alphabet;
            }

            public String getName() {
                return name;
            }
        };
        result.buildScores(scores);
        return result;
    }

    public static Scores duplicate(Scores scores) {
        Scores result;
        if (scores instanceof AminoAcidScores) {
            result = new AminoAcidScores();
        } else if (scores instanceof NucleotideScores) {
            result = new NucleotideScores((NucleotideScores)scores);
        } else {
            final String alphabet = scores.getAlphabet();
            final String name = scores.getName();
            result = new Scores(){

                public String getAlphabet() {
                    return String.valueOf(alphabet) + this.getExtraResidues();
                }

                public String getName() {
                    return name;
                }
            };
        }
        result.extraResidues = scores.getExtraResidues();
        result.score = new float[127][127];
        int i = 0;
        while (i < 127) {
            System.arraycopy(scores.score[i], 0, result.score[i], 0, 127);
            ++i;
        }
        return result;
    }

    public static Scores includeGaps(Scores scores, float gapVersusResidueCost, float gapVersusGapCost) {
        Scores result = Scores.duplicate(scores);
        String states = scores.getAlphabet();
        int i = 0;
        while (i < states.length()) {
            char res1 = states.charAt(i);
            result.score[45][res1] = gapVersusResidueCost;
            result.score[res1][45] = gapVersusResidueCost;
            ++i;
        }
        result.score[45][45] = gapVersusGapCost;
        return result;
    }

    public static Scores includeAdditionalCharacters(Scores scores, String characters) {
        Scores result = Scores.duplicate(scores);
        String states = scores.getAlphabet();
        char[] unique = new char[characters.length()];
        int index = 0;
        char[] cArray = characters.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            if (states.indexOf(character) < 0) {
                unique[index++] = character;
            }
            ++n2;
        }
        result.extraResidues = String.valueOf(result.extraResidues) + new String(unique, 0, index);
        return result;
    }

    protected String getExtraResidues() {
        return this.extraResidues;
    }

    public String getMatrixString() {
        String alphabet = this.getAlphabet();
        StringBuilder builder = new StringBuilder();
        builder.append("  ");
        char[] cArray = alphabet.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c1 = cArray[n2];
            builder.append("  ").append(c1).append("   ");
            ++n2;
        }
        builder.append("\n");
        cArray = alphabet.toCharArray();
        n = cArray.length;
        n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            builder.append(c).append(" ");
            char[] cArray2 = alphabet.toCharArray();
            int n3 = cArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                char c1 = cArray2[n4];
                float s = this.score[c][c1];
                builder.append(String.format("%+1.2f ", Float.valueOf(s)));
                ++n4;
            }
            builder.append("\n");
            ++n2;
        }
        return builder.toString();
    }
}

