/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import jebl.evolution.coalescent.DemographicFunction;

public class EmpiricalDemographicFunction
implements DemographicFunction {
    private final double[] populationSizes;
    private final double[] times;
    private final boolean stepwise;

    public EmpiricalDemographicFunction(double[] populationSizes, double[] times, boolean stepwise) {
        this.populationSizes = populationSizes;
        this.times = times;
        this.stepwise = stepwise;
    }

    public double getDemographic(double t) {
        assert (t >= 0.0);
        if (t > this.times[this.times.length - 1]) {
            return this.populationSizes[this.populationSizes.length - 1];
        }
        if (this.stepwise) {
            int i = 0;
            while (i < this.times.length) {
                if (this.times[i] >= t) {
                    return this.populationSizes[i];
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.times.length) {
                if (this.times[i] == t) {
                    return this.populationSizes[i];
                }
                if (this.times[i] > t) {
                    double proportion = (t - this.times[i - 1]) / (this.times[i] - this.times[i - 1]);
                    double popSize = this.populationSizes[i - 1] + proportion * (this.populationSizes[i] - this.populationSizes[i - 1]);
                    return popSize;
                }
                ++i;
            }
        }
        throw new RuntimeException("Error in jebl.evolution.treesimulation.EmpiricalDemographicFunction.getDemographic: went off the end of the array");
    }

    public double getIntensity(double t) {
        throw new UnsupportedOperationException("getIntensity is not implemented in jebl.evolution.treesimulation.EmpiricalDemographicFunction");
    }

    public double getInverseIntensity(double x) {
        throw new UnsupportedOperationException("getInverseIntensity is not implemented in jebl.evolution.treesimulation.EmpiricalDemographicFunction");
    }

    public boolean hasIntegral() {
        return false;
    }

    public double getIntegral(double start, double finish) {
        return 0.0;
    }

    public int getArgumentCount() {
        return 0;
    }

    public String getArgumentName(int n) {
        return null;
    }

    public double getArgument(int n) {
        return 0.0;
    }

    public void setArgument(int n, double value) {
    }

    public double getLowerBound(int n) {
        return 0.0;
    }

    public double getUpperBound(int n) {
        return 0.0;
    }
}

