/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.coalescent;

import java.util.Arrays;
import jebl.evolution.coalescent.IntervalList;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.RootedTreeUtils;

public class Intervals
implements IntervalList {
    private Event[] events;
    private int eventCount;
    private int sampleCount;
    private boolean intervalsKnown = false;
    private double[] intervals;
    private int[] lineageCounts;
    private IntervalList.IntervalType[] intervalTypes;
    private int intervalCount = 0;

    public Intervals(RootedTree tree) {
        this(tree.getNodes().size());
        if (!RootedTreeUtils.isBinary(tree)) {
            throw new IllegalArgumentException("Tree must be rooted and binary");
        }
        for (Node node : tree.getExternalNodes()) {
            this.addSampleEvent(tree.getHeight(node));
        }
        for (Node node : tree.getInternalNodes()) {
            this.addCoalescentEvent(tree.getHeight(node));
        }
    }

    public Intervals(int maxEventCount) {
        this.events = new Event[maxEventCount];
        int i = 0;
        while (i < maxEventCount) {
            this.events[i] = new Event();
            ++i;
        }
        this.eventCount = 0;
        this.sampleCount = 0;
        this.intervals = new double[maxEventCount - 1];
        this.intervalTypes = new IntervalList.IntervalType[maxEventCount - 1];
        this.lineageCounts = new int[maxEventCount - 1];
        this.intervalsKnown = false;
    }

    public void copyIntervals(Intervals source) {
        this.intervalsKnown = source.intervalsKnown;
        this.eventCount = source.eventCount;
        this.sampleCount = source.sampleCount;
        if (this.intervalsKnown) {
            System.arraycopy(source.intervals, 0, this.intervals, 0, this.intervals.length);
            System.arraycopy(source.intervalTypes, 0, this.intervalTypes, 0, this.intervals.length);
            System.arraycopy(source.lineageCounts, 0, this.lineageCounts, 0, this.intervals.length);
        }
    }

    public void resetEvents() {
        this.intervalsKnown = false;
        this.eventCount = 0;
        this.sampleCount = 0;
    }

    public void addSampleEvent(double time) {
        this.events[this.eventCount].time = time;
        this.events[this.eventCount].type = IntervalList.IntervalType.SAMPLE;
        ++this.eventCount;
        ++this.sampleCount;
        this.intervalsKnown = false;
    }

    public void addCoalescentEvent(double time) {
        this.events[this.eventCount].time = time;
        this.events[this.eventCount].type = IntervalList.IntervalType.COALESCENT;
        ++this.eventCount;
        this.intervalsKnown = false;
    }

    public void addMigrationEvent(double time, int destination) {
        this.events[this.eventCount].time = time;
        this.events[this.eventCount].type = IntervalList.IntervalType.MIGRATION;
        this.events[this.eventCount].info = destination;
        ++this.eventCount;
        this.intervalsKnown = false;
    }

    public void addNothingEvent(double time) {
        this.events[this.eventCount].time = time;
        this.events[this.eventCount].type = IntervalList.IntervalType.NOTHING;
        ++this.eventCount;
        this.intervalsKnown = false;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public int getIntervalCount() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalCount;
    }

    public double getInterval(int i) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervals[i];
    }

    public int getLineageCount(int i) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.lineageCounts[i];
    }

    public int getCoalescentEvents(int i) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        if (i < this.intervalCount - 1) {
            return this.lineageCounts[i] - this.lineageCounts[i + 1];
        }
        return this.lineageCounts[i] - 1;
    }

    public IntervalList.IntervalType getIntervalType(int i) {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.intervalTypes[i];
    }

    public double getTotalDuration() {
        if (!this.intervalsKnown) {
            this.calculateIntervals();
        }
        return this.events[this.eventCount - 1].time;
    }

    public boolean isBinaryCoalescent() {
        return true;
    }

    public boolean isCoalescentOnly() {
        return true;
    }

    private void calculateIntervals() {
        if (this.eventCount < 2) {
            throw new IllegalArgumentException("Too few events to construct intervals");
        }
        Arrays.sort(this.events, 0, this.eventCount - 1);
        if (this.events[0].type != IntervalList.IntervalType.SAMPLE) {
            throw new IllegalArgumentException("First event is not a sample event");
        }
        this.intervalCount = this.eventCount - 1;
        double lastTime = this.events[0].time;
        int lineages = 1;
        int i = 1;
        while (i < this.eventCount) {
            this.intervals[i - 1] = this.events[i].time - lastTime;
            this.intervalTypes[i - 1] = this.events[i].type;
            this.lineageCounts[i - 1] = lineages++;
            if (this.events[i].type != IntervalList.IntervalType.SAMPLE && this.events[i].type == IntervalList.IntervalType.COALESCENT) {
                --lineages;
            }
            lastTime = this.events[i].time;
            ++i;
        }
        this.intervalsKnown = true;
    }

    private class Event
    implements Comparable {
        IntervalList.IntervalType type;
        double time;
        int info;

        private Event() {
        }

        public int compareTo(Object o) {
            double t = ((Event)o).time;
            if (t < this.time) {
                return 1;
            }
            if (t > this.time) {
                return -1;
            }
            return this.type.compareTo(((Event)o).type);
        }
    }
}

