/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.distances;

import jebl.evolution.alignments.Alignment;
import jebl.evolution.alignments.Pattern;
import jebl.evolution.distances.BasicDistanceMatrix;
import jebl.evolution.sequences.Nucleotides;
import jebl.evolution.sequences.State;
import jebl.util.ProgressListener;

public class F84DistanceMatrix
extends BasicDistanceMatrix {
    public F84DistanceMatrix(Alignment alignment, ProgressListener progress) {
        super(alignment.getTaxa(), new Initialaizer().getDistances(alignment, progress));
    }

    public F84DistanceMatrix(Alignment alignment) {
        super(alignment.getTaxa(), new Initialaizer().getDistances(alignment, null));
    }

    static class Initialaizer {
        private static final double MAX_DISTANCE = 1000.0;
        private Alignment alignment;

        Initialaizer() {
        }

        private double calculatePairwiseDistance(int taxon1, int taxon2) {
            double[] total = new double[4];
            double[] transversions = new double[4];
            for (Pattern pattern : this.alignment.getPatterns()) {
                State state1 = pattern.getState(taxon1);
                State state2 = pattern.getState(taxon2);
                double weight = pattern.getWeight();
                if (state1.isAmbiguous() || state2.isAmbiguous()) continue;
                int n = state1.getIndex();
                total[n] = total[n] + weight;
                if (!Nucleotides.isTransversion(state1, state2)) continue;
                int n2 = state1.getIndex();
                transversions[n2] = transversions[n2] + weight;
            }
            double totalTransversions = 0.0;
            int i = 0;
            while (i < 4) {
                if (total[i] > 0.0) {
                    totalTransversions += transversions[i] / total[i];
                }
                ++i;
            }
            double expDist = 1.0 - totalTransversions / 2.0;
            return expDist > 0.0 ? -Math.log(expDist) : 1000.0;
        }

        synchronized double[][] getDistances(Alignment alignment, ProgressListener progress) {
            this.alignment = alignment;
            int stateCount = alignment.getSequenceType().getCanonicalStateCount();
            if (stateCount != 4) {
                throw new IllegalArgumentException("F84DistanceMatrix must have nucleotide patterns");
            }
            int dimension = alignment.getTaxa().size();
            double[][] distances = new double[dimension][dimension];
            float tot = dimension * (dimension - 1) / 2;
            int done = 0;
            int i = 0;
            while (i < dimension) {
                int j = i + 1;
                while (j < dimension) {
                    distances[i][j] = this.calculatePairwiseDistance(i, j);
                    distances[j][i] = distances[i][j];
                    if (progress != null) {
                        progress.setProgress((float)(++done) / tot);
                    }
                    ++j;
                }
                ++i;
            }
            return distances;
        }
    }
}

