/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import jebl.evolution.graphs.Graph;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ConsensusTreeBuilder;
import jebl.evolution.trees.MutableRootedTree;
import jebl.evolution.trees.Tree;
import jebl.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GreedyUnrootedConsensusTreeBuilder
extends ConsensusTreeBuilder<Tree> {
    private final Tree[] trees;
    private final Taxon outGroup;
    private final double supportThreshold;
    private final boolean debug = false;

    GreedyUnrootedConsensusTreeBuilder(Tree[] trees, Taxon outGroup, double supportThreshold) {
        super(trees);
        this.trees = trees;
        this.outGroup = outGroup;
        this.supportThreshold = supportThreshold;
    }

    GreedyUnrootedConsensusTreeBuilder(Tree[] trees, Taxon outGroup, double supportThreshold, String supportAttributeName, boolean asPercent) {
        super(trees, supportAttributeName, asPercent);
        this.trees = trees;
        this.outGroup = outGroup;
        this.supportThreshold = supportThreshold;
    }

    @Override
    public String getMethodDescription() {
        return String.valueOf(this.getSupportDescription(this.supportThreshold)) + " greedy clustering";
    }

    private String subTreeRep(Tree t, Node n, Node root) {
        if (t.isExternal(n)) {
            return t.getTaxon(n).getName();
        }
        StringBuilder b = new StringBuilder();
        for (Node x : t.getAdjacencies(n)) {
            if (x == root) continue;
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(this.subTreeRep(t, x, n));
        }
        return String.valueOf('(') + b.toString() + ')';
    }

    private String tipsAsText(FixedBitSet b) {
        String names = "(";
        int i = b.nextOnBit(0);
        while (i >= 0) {
            names = String.valueOf(names) + ((Taxon)this.taxons.get(i)).getName() + ",";
            i = b.nextOnBit(i + 1);
        }
        return String.valueOf(names) + ")";
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final Tree build() {
        try {
            LinkedHashMap<FixedBitSet, Support> support = new LinkedHashMap<FixedBitSet, Support>();
            double[] sumBranchesOfExternal = new double[this.taxons.size()];
            int nTree = 0;
            Tree[] treeArray = this.trees;
            int n = this.trees.length;
            int n2 = 0;
            while (n2 < n) {
                Tree tree = treeArray[n2];
                int initialCapacity = tree.getNodes().size();
                LinkedHashSet<Node> scanSet = new LinkedHashSet<Node>(initialCapacity);
                LinkedHashMap<Node, FixedBitSet> doneSet = new LinkedHashMap<Node, FixedBitSet>(initialCapacity);
                for (Node n3 : tree.getExternalNodes()) {
                    FixedBitSet b = new FixedBitSet(this.nExternalNodes);
                    int position = this.taxons.indexOf(tree.getTaxon(n3));
                    b.set(position);
                    doneSet.put(n3, b);
                    for (Node node : tree.getAdjacencies(n3)) {
                        scanSet.add(node);
                    }
                    int n4 = position;
                    sumBranchesOfExternal[n4] = sumBranchesOfExternal[n4] + tree.getEdgeLength(n3, tree.getAdjacencies(n3).get(0));
                }
                int nInternalEdges = this.nExternalNodes - 3;
                ArrayList<Node> intr = new ArrayList<Node>(tree.getInternalNodes());
                while (scanSet.size() > 0) {
                    LinkedHashSet<Node> nextScanSet = new LinkedHashSet<Node>(initialCapacity);
                    for (Node n5 : scanSet) {
                        int nDone = 0;
                        List<Node> adjacencies = tree.getAdjacencies(n5);
                        for (Node a : adjacencies) {
                            if (!doneSet.containsKey(a)) continue;
                            ++nDone;
                        }
                        if (nDone + 1 < adjacencies.size()) {
                            nextScanSet.add(n5);
                            continue;
                        }
                        if (nDone < adjacencies.size()) {
                            Support s;
                            FixedBitSet b = new FixedBitSet(this.nExternalNodes);
                            Node notDone = null;
                            for (Node a : adjacencies) {
                                if (doneSet.containsKey(a)) {
                                    FixedBitSet subSet = (FixedBitSet)doneSet.get(a);
                                    if (subSet == null) assert (false);
                                    b.union(subSet);
                                    continue;
                                }
                                notDone = a;
                            }
                            double branch = tree.getEdgeLength(n5, notDone);
                            doneSet.put(n5, new FixedBitSet(b));
                            nextScanSet.remove(n5);
                            if (!b.contains(0)) {
                                b.complement();
                            }
                            if ((s = (Support)support.get(b)) == null) {
                                s = new Support();
                                support.put(b, s);
                            }
                            s.add(branch);
                            --nInternalEdges;
                            nextScanSet.add(notDone);
                            continue;
                        }
                        doneSet.put(n5, null);
                    }
                    scanSet = nextScanSet;
                }
                if (this.fireSetProgress(0.9 * (double)(++nTree) / (double)this.trees.length)) {
                    return null;
                }
                ++n2;
            }
            Comparator<Map.Entry<FixedBitSet, Support>> comparator = new Comparator<Map.Entry<FixedBitSet, Support>>(){

                @Override
                public int compare(Map.Entry<FixedBitSet, Support> o1, Map.Entry<FixedBitSet, Support> o2) {
                    return o2.getValue().nTreesWithClade - o1.getValue().nTreesWithClade;
                }
            };
            PriorityQueue<Map.Entry<FixedBitSet, Support>> queue = new PriorityQueue<Map.Entry<FixedBitSet, Support>>(support.size(), comparator);
            for (Map.Entry entry : support.entrySet()) {
                queue.add(entry);
            }
            MutableRootedTree mutableRootedTree = new MutableRootedTree();
            ArrayList<Node> internalNodes = new ArrayList<Node>(this.nExternalNodes);
            ArrayList<FixedBitSet> internalNodesTips = new ArrayList<FixedBitSet>(this.nExternalNodes);
            assert (this.taxons.size() == this.nExternalNodes);
            internalNodesTips.add(new FixedBitSet(this.nExternalNodes));
            Node[] nodes = new Node[this.nExternalNodes];
            int nt = 0;
            while (nt < this.taxons.size()) {
                nodes[nt] = mutableRootedTree.createExternalNode((Taxon)this.taxons.get(nt));
                ((FixedBitSet)internalNodesTips.get(0)).set(nt);
                ++nt;
            }
            internalNodes.add(mutableRootedTree.createInternalNode(Arrays.asList(nodes)));
            while (queue.peek() != null) {
                boolean bl;
                Map.Entry<FixedBitSet, Support> e = queue.poll();
                Support s = e.getValue();
                double psupport = 1.0 * (double)s.nTreesWithClade / (double)this.trees.length;
                if (psupport < this.supportThreshold) break;
                FixedBitSet splitTips = e.getKey();
                boolean bl2 = false;
                int nsub = internalNodesTips.size() - 1;
                while (nsub >= 0) {
                    block37: {
                        boolean bl3;
                        FixedBitSet sharedTips;
                        block38: {
                            int nSplit = ((FixedBitSet)internalNodesTips.get(nsub)).intersectCardinality(splitTips);
                            FixedBitSet allNodeTips = (FixedBitSet)internalNodesTips.get(nsub);
                            if (nSplit <= 0 || nSplit >= allNodeTips.cardinality()) break block37;
                            sharedTips = new FixedBitSet(allNodeTips);
                            sharedTips.intersect(splitTips);
                            if (sharedTips.equals(splitTips)) break block38;
                            sharedTips.complement();
                            sharedTips.intersect(allNodeTips);
                            if (!sharedTips.equals(FixedBitSet.complement(splitTips))) break block37;
                        }
                        boolean bl4 = true;
                        ArrayList<Integer> split = new ArrayList<Integer>();
                        Node n6 = (Node)internalNodes.get(nsub);
                        int l = 0;
                        List<Node> children = mutableRootedTree.getChildren(n6);
                        for (Node ch : children) {
                            if (mutableRootedTree.isExternal(ch)) {
                                if (sharedTips.contains(this.taxons.indexOf(mutableRootedTree.getTaxon(ch)))) {
                                    split.add(l);
                                }
                            } else {
                                int o = internalNodes.indexOf(ch);
                                int i = ((FixedBitSet)internalNodesTips.get(o)).intersectCardinality(sharedTips);
                                if (i == ((FixedBitSet)internalNodesTips.get(o)).cardinality()) {
                                    split.add(l);
                                } else if (i > 0) {
                                    bl3 = false;
                                    break;
                                }
                            }
                            ++l;
                        }
                        if (!bl3 || split.size() >= children.size()) {
                            bl = false;
                            break;
                        }
                        if (split.size() == 0) {
                            System.out.println("Bug??");
                            assert (false);
                        }
                        Node detached = mutableRootedTree.detachChildren(n6, split);
                        double length = s.sumBranches / (double)s.nTreesWithClade;
                        mutableRootedTree.setLength(detached, length);
                        detached.setAttribute(this.getSupportAttributeName(), this.isSupportAsPercent() ? 100.0 * psupport : psupport);
                        internalNodes.add(nsub + 1, detached);
                        internalNodesTips.add(nsub + 1, new FixedBitSet(sharedTips));
                        break;
                    }
                    --nsub;
                }
                if (!(psupport >= 0.5) || bl) continue;
                System.out.println("Bug??");
                assert (false);
            }
            nt = 0;
            while (nt < this.taxons.size()) {
                Node n7 = mutableRootedTree.getNode((Taxon)this.taxons.get(nt));
                mutableRootedTree.setLength(n7, sumBranchesOfExternal[nt] / (double)this.trees.length);
                ++nt;
            }
            if (this.outGroup != null) {
                Node out = mutableRootedTree.getNode(this.outGroup);
                LinkedHashSet<String> a = new LinkedHashSet<String>();
                a.add(this.getSupportAttributeName());
                mutableRootedTree.reRootWithOutgroup(out, a);
            }
            mutableRootedTree.setConceptuallyUnrooted(true);
            this.fireSetProgress(1.0);
            return mutableRootedTree;
        }
        catch (Graph.NoEdgeException noEdgeException) {
            return null;
        }
    }

    static final class Support {
        private int nTreesWithClade = 0;
        private double sumBranches = 0.0;

        Support() {
        }

        public final void add(double branch) {
            this.sumBranches += branch;
            ++this.nTreesWithClade;
        }
    }
}

