/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.ConsensusTreeBuilder;
import jebl.evolution.trees.MutableRootedTree;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Tree;
import jebl.evolution.trees.Utils;
import jebl.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MRCACConsensusTreeBuilder
extends ConsensusTreeBuilder<RootedTree> {
    RootedTree[] trees;
    private double supportThreshold;
    private List<FixedBitSet> tipsInCluster;
    private TreeInfo[] info;
    private boolean debug = false;
    double[][] height;

    public MRCACConsensusTreeBuilder(Tree[] trees, double supportThreshold) {
        this(trees, supportThreshold, "Consensus support(%)", true);
    }

    public MRCACConsensusTreeBuilder(Tree[] trees, double supportThreshold, String supportAttributeName, boolean asPercent) {
        super(trees, supportAttributeName, asPercent);
        this.trees = new RootedTree[trees.length];
        int i = 0;
        while (i < trees.length) {
            this.trees[i] = (RootedTree)trees[i];
            ++i;
        }
        this.supportThreshold = supportThreshold;
        this.info = new TreeInfo[trees.length];
        int iTree = 0;
        while (iTree < trees.length) {
            this.info[iTree] = new TreeInfo(this.trees[iTree]);
            ++iTree;
        }
    }

    @Override
    public RootedTree build() {
        return this.earliestCommonAncestorClustering(this.supportThreshold);
    }

    @Override
    public String getMethodDescription() {
        return String.valueOf(this.getSupportDescription(this.supportThreshold)) + " MRCACC";
    }

    void setupPairs() {
        this.height = new double[this.nExternalNodes][this.nExternalNodes];
        if (this.debug) {
            int k = 0;
            while (k < this.taxons.size()) {
                System.out.print(String.valueOf(((Taxon)this.taxons.get(k)).getName()) + ":" + k + ", ");
                ++k;
            }
            System.out.println();
        }
        int iTree = 0;
        while (iTree < this.trees.length) {
            if (this.debug) {
                System.out.println("tree " + Utils.toNewick(this.trees[iTree]));
            }
            TreeInfo info = this.info[iTree];
            int[] nArray = info.postorder;
            int n = info.postorder.length;
            int n2 = 0;
            while (n2 < n) {
                int nodeIndex = nArray[n2];
                int leftChildIndex = info.nodeChildren[nodeIndex][0];
                int rightChildIndex = info.nodeChildren[nodeIndex][1];
                FixedBitSet left = info.nodesTipSet[leftChildIndex];
                FixedBitSet right = info.nodesTipSet[rightChildIndex];
                int lTip = left.nextOnBit(0);
                while (lTip >= 0) {
                    int rTip = right.nextOnBit(0);
                    while (rTip >= 0) {
                        double h = this.trees[iTree].getHeight(info.allNodes[nodeIndex]);
                        double[] dArray = this.height[Math.min(lTip, rTip)];
                        int n3 = Math.max(lTip, rTip);
                        dArray[n3] = dArray[n3] + h;
                        rTip = right.nextOnBit(rTip + 1);
                    }
                    lTip = left.nextOnBit(lTip + 1);
                }
                ++n2;
            }
            ++iTree;
        }
        int d = 0;
        while (d < this.nExternalNodes) {
            int d1 = d + 1;
            while (d1 < this.nExternalNodes) {
                double[] dArray = this.height[d];
                int n = d1++;
                dArray[n] = dArray[n] / (double)this.trees.length;
            }
            ++d;
        }
    }

    private double[] updateHeights(int i, int j) {
        int nClusters = this.tipsInCluster.size();
        double[] distances = new double[nClusters + 1];
        FixedBitSet joined = new FixedBitSet(this.tipsInCluster.get(i));
        joined.union(this.tipsInCluster.get(j));
        int numberOfTreesSupportClade = 0;
        if (nClusters == 2) {
            RootedTree[] rootedTreeArray = this.trees;
            int n = this.trees.length;
            int n2 = 0;
            while (n2 < n) {
                RootedTree tree = rootedTreeArray[n2];
                distances[1] = distances[1] + tree.getHeight(tree.getRootNode());
                ++n2;
            }
            distances[2] = 1.0;
        } else {
            int l = 0;
            while (l < nClusters) {
                if (l != i && l != j) {
                    FixedBitSet joinedWithL = new FixedBitSet(joined);
                    joinedWithL.union(this.tipsInCluster.get(l));
                    int iTree = 0;
                    while (iTree < this.trees.length) {
                        RootedTree tree = this.trees[iTree];
                        TreeInfo info = this.info[iTree];
                        boolean commonAnncestorFound = false;
                        int[] nArray = info.postorder;
                        int n = info.postorder.length;
                        int n3 = 0;
                        while (n3 < n) {
                            int nodeIndex = nArray[n3];
                            FixedBitSet nodeBS = info.nodesTipSet[nodeIndex];
                            if (!commonAnncestorFound && joined.setInclusion(nodeBS)) {
                                int tipsInClusters;
                                int tipsInSubtree = nodeBS.cardinality();
                                numberOfTreesSupportClade += tipsInSubtree == (tipsInClusters = joined.cardinality()) ? 1 : 0;
                                commonAnncestorFound = true;
                            }
                            if (joinedWithL.setInclusion(nodeBS)) {
                                int n4 = l;
                                distances[n4] = distances[n4] + tree.getHeight(info.allNodes[nodeIndex]);
                                break;
                            }
                            ++n3;
                        }
                        ++iTree;
                    }
                }
                ++l;
            }
        }
        int l = 0;
        while (l < nClusters) {
            int n = l++;
            distances[n] = distances[n] / (double)this.trees.length;
        }
        distances[nClusters] = (double)numberOfTreesSupportClade / (double)this.trees.length;
        return distances;
    }

    private RootedTree earliestCommonAncestorClustering(double supportThreshold) {
        MutableRootedTree consensus = new MutableRootedTree();
        ArrayList<Node> subTrees = new ArrayList<Node>(this.nExternalNodes);
        double[] tipHeights = new double[this.taxons.size()];
        RootedTree[] rootedTreeArray = this.trees;
        int n = this.trees.length;
        int n2 = 0;
        while (n2 < n) {
            RootedTree tree = rootedTreeArray[n2];
            for (Node e : tree.getExternalNodes()) {
                int i;
                int n3 = i = this.taxons.indexOf(tree.getTaxon(e));
                tipHeights[n3] = tipHeights[n3] + tree.getHeight(e);
            }
            ++n2;
        }
        this.tipsInCluster = new ArrayList<FixedBitSet>(this.nExternalNodes);
        int k = 0;
        while (k < this.nExternalNodes) {
            FixedBitSet b = new FixedBitSet(this.nExternalNodes);
            b.set(k);
            this.tipsInCluster.add(b);
            Node externalNode = consensus.createExternalNode((Taxon)this.taxons.get(k));
            consensus.setHeight(externalNode, tipHeights[k] / (double)this.trees.length);
            subTrees.add(externalNode);
            ++k;
        }
        this.setupPairs();
        int nClusters = this.nExternalNodes;
        while (nClusters > 1) {
            double mostRecentAnncestorHeight = Double.MAX_VALUE;
            int besti = 0;
            int bestj = 0;
            int d = 0;
            while (d < nClusters) {
                int d1 = d + 1;
                while (d1 < nClusters) {
                    if (this.height[d][d1] < mostRecentAnncestorHeight) {
                        mostRecentAnncestorHeight = this.height[d][d1];
                        besti = d;
                        bestj = d1;
                    }
                    ++d1;
                }
                ++d;
            }
            double[] newHeights = this.updateHeights(besti, bestj);
            double supportForClade = newHeights[newHeights.length - 1];
            Node[] children = new Node[]{(Node)subTrees.get(besti), (Node)subTrees.get(bestj)};
            double maxChild = Math.max(consensus.getHeight(children[0]), consensus.getHeight(children[1]));
            mostRecentAnncestorHeight = Math.max(mostRecentAnncestorHeight, maxChild);
            MutableRootedTree.MutableRootedNode sub = consensus.createInternalNode(Arrays.asList(children));
            consensus.setHeight(sub, mostRecentAnncestorHeight);
            if (nClusters > 2) {
                sub.setAttribute(this.getSupportAttributeName(), this.isSupportAsPercent() ? 100.0 * supportForClade : supportForClade);
            }
            subTrees.set(besti, sub);
            this.tipsInCluster.get(besti).union(this.tipsInCluster.get(bestj));
            this.tipsInCluster.remove(bestj);
            subTrees.remove(bestj);
            int i = 0;
            while (i < nClusters) {
                if (besti < i) {
                    this.height[besti][i] = newHeights[i];
                } else {
                    this.height[i][besti] = newHeights[i];
                }
                ++i;
            }
            i = 0;
            while (i < nClusters - 1) {
                int j = bestj;
                while (j < nClusters - 1) {
                    this.height[i][j] = this.height[i + (i >= bestj ? 1 : 0)][j + 1];
                    ++j;
                }
                ++i;
            }
            --nClusters;
        }
        if (this.isSupportAsPercent()) {
            supportThreshold *= 100.0;
        }
        for (Node node : consensus.getInternalNodes()) {
            Object sup = node.getAttribute(this.getSupportAttributeName());
            if (sup == null || !((Double)sup < supportThreshold)) continue;
            consensus.removeInternalNode(node);
        }
        return consensus;
    }

    class TreeInfo {
        FixedBitSet[] nodesTipSet;
        int[] postorder;
        int[][] nodeChildren;
        private Node[] allNodes;

        TreeInfo(RootedTree tree) {
            this.allNodes = new Node[tree.getNodes().size()];
            for (Node node : tree.getExternalNodes()) {
                int i = MRCACConsensusTreeBuilder.this.taxons.indexOf(tree.getTaxon(node));
                this.allNodes[i] = node;
            }
            int k = MRCACConsensusTreeBuilder.this.nExternalNodes;
            Iterator<Node> iterator = tree.getInternalNodes().iterator();
            while (iterator.hasNext()) {
                Node node;
                this.allNodes[k] = node = iterator.next();
                ++k;
            }
            this.postorder = new int[this.allNodes.length - MRCACConsensusTreeBuilder.this.nExternalNodes];
            this.nodesTipSet = new FixedBitSet[this.allNodes.length];
            this.nodeChildren = new int[this.allNodes.length][];
            this.inPostorder(tree, tree.getRootNode(), 0);
        }

        private int inPostorder(RootedTree tree, Node node, int nPost) {
            List<Node> all = Arrays.asList(this.allNodes);
            FixedBitSet b = new FixedBitSet(this.allNodes.length);
            int c = all.indexOf(node);
            if (tree.isExternal(node)) {
                b.set(c);
            } else {
                List<Node> children = tree.getChildren(node);
                this.nodeChildren[c] = new int[children.size()];
                int nc = 0;
                for (Node child : children) {
                    int c1;
                    nPost = this.inPostorder(tree, child, nPost);
                    this.nodeChildren[c][nc] = c1 = all.indexOf(child);
                    ++nc;
                    b.union(this.nodesTipSet[c1]);
                }
                this.postorder[nPost] = c;
                ++nPost;
            }
            this.nodesTipSet[c] = b;
            return nPost;
        }
    }
}

