/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jebl.evolution.graphs.Node;
import jebl.evolution.trees.FilteredRootedTree;
import jebl.evolution.trees.RootedTree;
import jebl.evolution.trees.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortedRootedTree
extends FilteredRootedTree {
    private final Comparator<Node> comparator;

    public SortedRootedTree(final RootedTree source, BranchOrdering branchOrdering) {
        super(source);
        switch (branchOrdering) {
            case INCREASING_NODE_DENSITY: {
                this.comparator = new Comparator<Node>(){

                    @Override
                    public int compare(Node node1, Node node2) {
                        return Utils.getExternalNodeCount(source, node1) - Utils.getExternalNodeCount(source, node2);
                    }

                    public boolean equals(Node node1, Node node2) {
                        return this.compare(node1, node2) == 0;
                    }
                };
                break;
            }
            case DECREASING_NODE_DENSITY: {
                this.comparator = new Comparator<Node>(){

                    @Override
                    public int compare(Node node1, Node node2) {
                        return Utils.getExternalNodeCount(source, node2) - Utils.getExternalNodeCount(source, node1);
                    }

                    public boolean equals(Node node1, Node node2) {
                        return this.compare(node1, node2) == 0;
                    }
                };
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown enum value");
            }
        }
    }

    public SortedRootedTree(RootedTree source, Comparator<Node> comparator) {
        super(source);
        this.comparator = comparator;
    }

    @Override
    public List<Node> getChildren(Node node) {
        List<Node> sourceList = this.source.getChildren(node);
        Collections.sort(sourceList, this.comparator);
        return sourceList;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum BranchOrdering {
        INCREASING_NODE_DENSITY("increasing"),
        DECREASING_NODE_DENSITY("decreasing");

        private String name;

        private BranchOrdering(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

