/*
 * Decompiled with CFR 0.152.
 */
package jebl.evolution.trees;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jebl.evolution.graphs.Node;
import jebl.evolution.taxa.Taxon;
import jebl.evolution.trees.RootedTree;
import jebl.util.FixedBitSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TreeBiPartitionInfo {
    final List<Taxon> taxa;
    final RootedTree t;
    final int nTips;
    HashMap<FixedBitSet, BiPartiotionInfo> all;

    public TreeBiPartitionInfo(RootedTree t, List<Taxon> taxa) {
        this.t = t;
        this.taxa = taxa;
        this.nTips = t.getExternalNodes().size();
        this.all = new LinkedHashMap<FixedBitSet, BiPartiotionInfo>();
        this.forNode(t.getRootNode());
    }

    private FixedBitSet forNode(Node n) {
        FixedBitSet p = new FixedBitSet(this.nTips);
        if (this.t.isExternal(n)) {
            int pos = this.taxa.indexOf(this.t.getTaxon(n));
            p.set(pos);
        } else {
            for (Node c : this.t.getChildren(n)) {
                FixedBitSet info = this.forNode(c);
                p.union(info);
            }
        }
        boolean wasComplemented = false;
        if (this.t.getParent(n) != this.t.getRootNode() && !p.contains(0)) {
            p.complement();
            wasComplemented = true;
        }
        this.all.put(p, new BiPartiotionInfo(n));
        if (wasComplemented) {
            p.complement();
        }
        return p;
    }

    public static double distance(TreeBiPartitionInfo t1, TreeBiPartitionInfo t2, DistanceNorm norm) {
        for (BiPartiotionInfo k : t2.all.values()) {
            k.has = false;
        }
        double din = 0.0;
        double dout = 0.0;
        for (Map.Entry<FixedBitSet, BiPartiotionInfo> k : t1.all.entrySet()) {
            double dif;
            BiPartiotionInfo info = t2.all.get(k.getKey());
            double b1 = t1.t.getLength(k.getValue().n);
            if (info != null) {
                double b2 = t2.t.getLength(info.n);
                info.has = true;
                dif = Math.abs(b1 - b2);
            } else {
                dif = b1;
            }
            if (norm == DistanceNorm.NORM1) {
                din += dif;
                continue;
            }
            din += dif * dif;
        }
        for (BiPartiotionInfo info : t2.all.values()) {
            if (info.has) continue;
            double dif = t2.t.getLength(info.n);
            if (norm == DistanceNorm.NORM1) {
                dout += dif;
                continue;
            }
            dout += dif * dif;
        }
        double d = din + dout;
        return norm == DistanceNorm.NORM1 ? d : Math.sqrt(d);
    }

    class BiPartiotionInfo {
        Node n;
        public boolean has;

        BiPartiotionInfo(Node n) {
            this.n = n;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DistanceNorm {
        NORM1,
        NORM2;

    }
}

