/*
 * Decompiled with CFR 0.152.
 */
package jebl.math;

import jebl.math.MersenneTwisterFast;

public class Random {
    private static final MersenneTwisterFast random = new MersenneTwisterFast();

    private Random() {
    }

    public static int randomChoice(double[] cf) {
        int s;
        double U = random.nextDouble();
        if (U <= cf[0]) {
            s = 0;
        } else {
            s = 1;
            while (s < cf.length) {
                if (U <= cf[s] && U > cf[s - 1]) break;
                ++s;
            }
        }
        return s;
    }

    public static double[] getNormalized(double[] array) {
        double[] newArray = new double[array.length];
        double total = Random.getTotal(array);
        int i = 0;
        while (i < array.length) {
            newArray[i] = array[i] / total;
            ++i;
        }
        return newArray;
    }

    public static double getTotal(double[] array, int start, int end) {
        double total = 0.0;
        int i = start;
        while (i < end) {
            total += array[i];
            ++i;
        }
        return total;
    }

    public static double getTotal(double[] array) {
        return Random.getTotal(array, 0, array.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setSeed(long seed) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.setSeed(seed);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte nextByte() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextByte();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean nextBoolean() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextBoolean();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void nextBytes(byte[] bs) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.nextBytes(bs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char nextChar() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextChar();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextGaussian() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextGaussian();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static double nextDouble() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextDouble();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static float nextFloat() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextFloat();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long nextLong() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextLong();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static short nextShort() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextShort();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt() {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int nextInt(int n) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.nextInt(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] array) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(array);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shuffle(int[] array, int numberOfShuffles) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            random.shuffle(array, numberOfShuffles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int[] shuffled(int l) {
        MersenneTwisterFast mersenneTwisterFast = random;
        synchronized (mersenneTwisterFast) {
            return random.shuffled(l);
        }
    }
}

