/*
 * Decompiled with CFR 0.152.
 */
package jebl.util;

import java.util.Arrays;

public class FixedBitSet {
    int[] bits;
    int size;
    private static final int ADDRESS_BITS_PER_UNIT = 5;
    private static final int BITS_PER_UNIT = 32;
    private static final int BIT_INDEX_MASK = 31;
    private static final byte[] firstBitLocation;

    static {
        byte[] byArray = new byte[256];
        byArray[0] = -1;
        byArray[2] = 1;
        byArray[4] = 2;
        byArray[6] = 1;
        byArray[8] = 3;
        byArray[10] = 1;
        byArray[12] = 2;
        byArray[14] = 1;
        byArray[16] = 4;
        byArray[18] = 1;
        byArray[20] = 2;
        byArray[22] = 1;
        byArray[24] = 3;
        byArray[26] = 1;
        byArray[28] = 2;
        byArray[30] = 1;
        byArray[32] = 5;
        byArray[34] = 1;
        byArray[36] = 2;
        byArray[38] = 1;
        byArray[40] = 3;
        byArray[42] = 1;
        byArray[44] = 2;
        byArray[46] = 1;
        byArray[48] = 4;
        byArray[50] = 1;
        byArray[52] = 2;
        byArray[54] = 1;
        byArray[56] = 3;
        byArray[58] = 1;
        byArray[60] = 2;
        byArray[62] = 1;
        byArray[64] = 6;
        byArray[66] = 1;
        byArray[68] = 2;
        byArray[70] = 1;
        byArray[72] = 3;
        byArray[74] = 1;
        byArray[76] = 2;
        byArray[78] = 1;
        byArray[80] = 4;
        byArray[82] = 1;
        byArray[84] = 2;
        byArray[86] = 1;
        byArray[88] = 3;
        byArray[90] = 1;
        byArray[92] = 2;
        byArray[94] = 1;
        byArray[96] = 5;
        byArray[98] = 1;
        byArray[100] = 2;
        byArray[102] = 1;
        byArray[104] = 3;
        byArray[106] = 1;
        byArray[108] = 2;
        byArray[110] = 1;
        byArray[112] = 4;
        byArray[114] = 1;
        byArray[116] = 2;
        byArray[118] = 1;
        byArray[120] = 3;
        byArray[122] = 1;
        byArray[124] = 2;
        byArray[126] = 1;
        byArray[128] = 7;
        byArray[130] = 1;
        byArray[132] = 2;
        byArray[134] = 1;
        byArray[136] = 3;
        byArray[138] = 1;
        byArray[140] = 2;
        byArray[142] = 1;
        byArray[144] = 4;
        byArray[146] = 1;
        byArray[148] = 2;
        byArray[150] = 1;
        byArray[152] = 3;
        byArray[154] = 1;
        byArray[156] = 2;
        byArray[158] = 1;
        byArray[160] = 5;
        byArray[162] = 1;
        byArray[164] = 2;
        byArray[166] = 1;
        byArray[168] = 3;
        byArray[170] = 1;
        byArray[172] = 2;
        byArray[174] = 1;
        byArray[176] = 4;
        byArray[178] = 1;
        byArray[180] = 2;
        byArray[182] = 1;
        byArray[184] = 3;
        byArray[186] = 1;
        byArray[188] = 2;
        byArray[190] = 1;
        byArray[192] = 6;
        byArray[194] = 1;
        byArray[196] = 2;
        byArray[198] = 1;
        byArray[200] = 3;
        byArray[202] = 1;
        byArray[204] = 2;
        byArray[206] = 1;
        byArray[208] = 4;
        byArray[210] = 1;
        byArray[212] = 2;
        byArray[214] = 1;
        byArray[216] = 3;
        byArray[218] = 1;
        byArray[220] = 2;
        byArray[222] = 1;
        byArray[224] = 5;
        byArray[226] = 1;
        byArray[228] = 2;
        byArray[230] = 1;
        byArray[232] = 3;
        byArray[234] = 1;
        byArray[236] = 2;
        byArray[238] = 1;
        byArray[240] = 4;
        byArray[242] = 1;
        byArray[244] = 2;
        byArray[246] = 1;
        byArray[248] = 3;
        byArray[250] = 1;
        byArray[252] = 2;
        byArray[254] = 1;
        firstBitLocation = byArray;
    }

    private static int unitIndex(int bitIndex) {
        return bitIndex >> 5;
    }

    private int countBits(int b) {
        int sum = 0;
        while (b != 0) {
            b &= b - 1;
            ++sum;
        }
        return sum;
    }

    private static int bit(int bitIndex) {
        return 1 << (bitIndex & 0x1F);
    }

    public FixedBitSet(int size) {
        this.size = size;
        this.bits = new int[FixedBitSet.unitIndex(size - 1) + 1];
    }

    public FixedBitSet(FixedBitSet bs) {
        this.bits = (int[])bs.bits.clone();
        this.size = bs.size;
    }

    public void set(int position) {
        int unitIndex;
        int n = unitIndex = FixedBitSet.unitIndex(position);
        this.bits[n] = this.bits[n] | FixedBitSet.bit(position);
    }

    public void clear(int position) {
        int unitIndex;
        int n = unitIndex = FixedBitSet.unitIndex(position);
        this.bits[n] = this.bits[n] & ~FixedBitSet.bit(position);
    }

    public boolean setInclusion(FixedBitSet bitset) {
        int k = 0;
        while (k < this.bits.length) {
            if (this.bits[k] != (this.bits[k] & bitset.bits[k])) {
                return false;
            }
            ++k;
        }
        return true;
    }

    public void union(FixedBitSet b) {
        int k = 0;
        while (k < Math.min(this.bits.length, b.bits.length)) {
            int n = k;
            this.bits[n] = this.bits[n] | b.bits[k];
            ++k;
        }
    }

    public void intersect(FixedBitSet b) {
        int k = 0;
        while (k < Math.min(this.bits.length, b.bits.length)) {
            int n = k;
            this.bits[n] = this.bits[n] & b.bits[k];
            ++k;
        }
    }

    public void setMinus(FixedBitSet b) {
        int k = 0;
        while (k < Math.min(this.bits.length, b.bits.length)) {
            int n = k;
            this.bits[n] = this.bits[n] & ~b.bits[k];
            ++k;
        }
    }

    public int intersectCardinality(FixedBitSet b) {
        int c = 0;
        int k = 0;
        while (k < Math.min(this.bits.length, b.bits.length)) {
            c += this.countBits(this.bits[k] & b.bits[k]);
            ++k;
        }
        return c;
    }

    public static FixedBitSet complement(FixedBitSet b) {
        FixedBitSet t = new FixedBitSet(b);
        t.complement();
        return t;
    }

    public void complement() {
        int k = 0;
        while (k < this.bits.length - 1) {
            this.bits[k] = ~this.bits[k];
            ++k;
        }
        this.bits[k] = ~this.bits[k];
        int mask = FixedBitSet.bit(this.size) - 1;
        if (mask != 0) {
            int n = k;
            this.bits[n] = this.bits[n] & mask;
        }
    }

    private int firstOnBit(int i) {
        int k = 0;
        while (k < 4) {
            char b = (char)(i & 0xFF);
            if (b != '\u0000') {
                return 8 * k + firstBitLocation[b];
            }
            i >>= 8;
            ++k;
        }
        return -1;
    }

    public int nextOnBit(int fromIndex) {
        int testIndex;
        int u = FixedBitSet.unitIndex(fromIndex);
        int unit = this.bits[u] >> (testIndex = fromIndex & 0x1F);
        if (unit == 0) {
            testIndex = 0;
            while (unit == 0 && u < this.bits.length - 1) {
                unit = this.bits[++u];
            }
        }
        if (unit == 0) {
            return -1;
        }
        return u * 32 + (testIndex += this.firstOnBit(unit));
    }

    public int cardinality() {
        int sum = 0;
        int[] nArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            int b = nArray[n2];
            sum += this.countBits(b);
            ++n2;
        }
        return sum;
    }

    public boolean contains(int i) {
        int unitIndex = FixedBitSet.unitIndex(i);
        return (this.bits[unitIndex] & FixedBitSet.bit(i)) != 0;
    }

    public int hashCode() {
        int code = 0;
        int[] nArray = this.bits;
        int n = this.bits.length;
        int n2 = 0;
        while (n2 < n) {
            int bit = nArray[n2];
            code ^= bit;
            ++n2;
        }
        return code;
    }

    public boolean equals(Object x) {
        if (x instanceof FixedBitSet) {
            FixedBitSet b = (FixedBitSet)x;
            return b.size == this.size && Arrays.equals(this.bits, b.bits);
        }
        return false;
    }

    public String toString() {
        StringBuilder rep = new StringBuilder();
        rep.append("{");
        int b = 0;
        while (b < this.size) {
            if (this.contains(b)) {
                if (rep.length() > 0) {
                    rep.append("," + b);
                } else {
                    rep.append("" + b);
                }
            }
            ++b;
        }
        rep.append("}");
        return rep.toString();
    }
}

