/*
 * Decompiled with CFR 0.152.
 */
package jebl.util;

import java.awt.Image;
import jebl.util.Cancelable;
import jebl.util.SimpleListener;

public abstract class ProgressListener
implements Cancelable {
    public static final ProgressListener EMPTY = new EmptyProgressListener();

    public final boolean setProgress(double fractionCompleted) {
        if (fractionCompleted < 0.0) assert (false) : "Progress must be >=0 but got " + fractionCompleted;
        if (fractionCompleted > 1.0000001) assert (false) : "Progress must be <=1 but got " + fractionCompleted;
        if (fractionCompleted > 1.0) {
            fractionCompleted = 1.0;
        }
        this._setProgress(fractionCompleted);
        return this.isCanceled();
    }

    public final boolean setProgress(int currentStep, int numberOfSteps) {
        return this.setProgress((long)currentStep, (long)numberOfSteps);
    }

    public final boolean setProgress(long currentStep, long numberOfSteps) {
        if (numberOfSteps <= 0L) {
            throw new IllegalArgumentException("numberOfSteps=" + numberOfSteps);
        }
        if (currentStep < 0L || currentStep > numberOfSteps) {
            throw new IllegalArgumentException("currentStep must be between 0 and numberOfSteps inclusive.");
        }
        double progress = (double)currentStep / (double)numberOfSteps;
        return this.setProgress(progress);
    }

    protected abstract void _setProgress(double var1);

    public final boolean setIndeterminateProgress() {
        this._setIndeterminateProgress();
        return this.isCanceled();
    }

    protected abstract void _setIndeterminateProgress();

    public final boolean setMessage(String message) {
        this._setMessage(message == null ? "" : message);
        return this.isCanceled();
    }

    public final boolean setImage(Image image) {
        this._setImage(image);
        return this.isCanceled();
    }

    protected void _setImage(Image image) {
    }

    public void addFeedbackAction(String label, SimpleListener listener) {
    }

    public void addFeedbackAction(String label, String description, SimpleListener listener) {
        this.addFeedbackAction(label, listener);
    }

    public void removeFeedbackAction(String label) {
    }

    public void setTitle(String title) {
    }

    protected abstract void _setMessage(String var1);

    public abstract boolean isCanceled();

    private static class EmptyProgressListener
    extends ProgressListener {
        private EmptyProgressListener() {
        }

        protected void _setProgress(double fractionCompleted) {
        }

        protected void _setMessage(String message) {
        }

        public boolean isCanceled() {
            return false;
        }

        protected void _setIndeterminateProgress() {
        }
    }

    public static class Wrapper
    extends ProgressListener {
        private final ProgressListener internalProgressListener;

        public Wrapper(ProgressListener internalProgressListener) {
            this.internalProgressListener = internalProgressListener;
        }

        protected void _setProgress(double fractionCompleted) {
            this.internalProgressListener._setProgress(fractionCompleted);
        }

        protected void _setIndeterminateProgress() {
            this.internalProgressListener._setIndeterminateProgress();
        }

        protected void _setMessage(String message) {
            this.internalProgressListener._setMessage(message);
        }

        public boolean isCanceled() {
            return this.internalProgressListener.isCanceled();
        }

        protected void _setImage(Image image) {
            this.internalProgressListener._setImage(image);
        }

        public void addFeedbackAction(String label, SimpleListener listener) {
            this.internalProgressListener.addFeedbackAction(label, listener);
        }

        public void addFeedbackAction(String label, String description, SimpleListener listener) {
            this.internalProgressListener.addFeedbackAction(label, description, listener);
        }

        public void removeFeedbackAction(String label) {
            this.internalProgressListener.removeFeedbackAction(label);
        }

        public void setTitle(String title) {
            this.internalProgressListener.setTitle(title);
        }
    }
}

